/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.action.duration;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionBase;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGMeasureManager;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.util.TGBeatRange;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGNoteRange;

public class TGSetDurationAction
extends TGActionBase {
    public static final String NAME = "action.note.duration.set-duration";

    public TGSetDurationAction(TGContext context) {
        super(context, NAME);
    }

    @Override
    protected void processAction(TGActionContext context) {
        block3: {
            TGFactory factory;
            TGMeasureManager measureManager;
            TGDuration duration;
            TGBeatRange beats;
            block2: {
                TGNoteRange noteRange = (TGNoteRange)context.getAttribute("note-range");
                beats = (TGBeatRange)context.getAttribute("beat-range");
                duration = (TGDuration)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_DURATION);
                TGSongManager songManager = this.getSongManager(context);
                measureManager = songManager.getMeasureManager();
                factory = songManager.getFactory();
                if (noteRange == null || noteRange.isEmpty()) break block2;
                for (TGNote note : noteRange.getNotes()) {
                    TGVoice voice = note.getVoice();
                    TGBeat beat = voice.getBeat();
                    TGMeasure measure = beat.getMeasure();
                    measureManager.changeDuration(measure, beat, duration.clone(factory), voice.getIndex(), true);
                }
                break block3;
            }
            if (beats == null || beats.isEmpty()) break block3;
            TGVoice voice = (TGVoice)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_VOICE);
            for (TGBeat beat : beats.getBeats()) {
                TGMeasure measure = beat.getMeasure();
                measureManager.changeDuration(measure, beat, duration.clone(factory), voice.getIndex(), true);
            }
        }
    }
}

