/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.jack.console;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.util.TGMessageDialogUtil;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.jack.connection.JackConnectionManager;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UICheckBox;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.error.TGErrorManager;

public class JackConsoleDialog
implements TGEventListener {
    private TGContext context;
    private JackConnectionManager jackConnectionManager;
    private UIWindow dialog;
    private UILegendPanel groupOptions;
    private UICheckBox buttonAutoConnectPorts;
    private UIButton buttonStoreConnections;
    private UIButton buttonRestoreConnections;

    public JackConsoleDialog(TGContext context, JackConnectionManager jackConnectionManager) {
        this.context = context;
        this.jackConnectionManager = jackConnectionManager;
    }

    public void show() {
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UIWindow uiParent = TGWindow.getInstance((TGContext)this.context).getWindow();
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = uiFactory.createWindow(uiParent, false, false);
        this.dialog.setLayout((UILayout)dialogLayout);
        this.dialog.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TuxGuitar.getInstance().getSkinManager().removeLoader((TGEventListener)JackConsoleDialog.this);
                TuxGuitar.getInstance().getLanguageManager().removeLoader((TGEventListener)JackConsoleDialog.this);
            }
        });
        UITableLayout groupLayout = new UITableLayout();
        this.groupOptions = uiFactory.createLegendPanel((UIContainer)this.dialog);
        this.groupOptions.setLayout((UILayout)groupLayout);
        dialogLayout.set((UIControl)this.groupOptions, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(350.0f), null, null);
        this.buttonAutoConnectPorts = uiFactory.createCheckBox((UIContainer)this.groupOptions);
        this.buttonAutoConnectPorts.setSelected(this.jackConnectionManager.isAutoConnectPorts());
        this.buttonAutoConnectPorts.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                final boolean selection = JackConsoleDialog.this.buttonAutoConnectPorts.isSelected();
                new Thread(new Runnable(){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.JackConsoleDialog.this.updateAutoConnectPorts(selection);
                    }
                }).start();
            }
        });
        groupLayout.set((UIControl)this.buttonAutoConnectPorts, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)this.dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.buttonStoreConnections = uiFactory.createButton((UIContainer)buttons);
        this.buttonStoreConnections.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        JackConsoleDialog.this.storeConnections();
                    }
                }).start();
            }
        });
        buttonsLayout.set((UIControl)this.buttonStoreConnections, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        this.buttonRestoreConnections = uiFactory.createButton((UIContainer)buttons);
        this.buttonRestoreConnections.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        JackConsoleDialog.this.restoreConnections();
                    }
                }).start();
            }
        });
        buttonsLayout.set((UIControl)this.buttonRestoreConnections, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        this.loadIcons(false);
        this.loadProperties(false);
        TuxGuitar.getInstance().getSkinManager().addLoader((TGEventListener)this);
        TuxGuitar.getInstance().getLanguageManager().addLoader((TGEventListener)this);
        TGDialogUtil.openDialog((UIWindow)this.dialog, (int)5);
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public void loadProperties() {
        this.loadProperties(true);
    }

    public void loadProperties(boolean layout) {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty((String)"jack.console.title"));
            this.groupOptions.setText(TuxGuitar.getProperty((String)"jack.console.options"));
            this.buttonAutoConnectPorts.setText(TuxGuitar.getProperty((String)"jack.console.autoconnect.ports"));
            this.buttonStoreConnections.setText(TuxGuitar.getProperty((String)"jack.console.store.connections"));
            this.buttonRestoreConnections.setText(TuxGuitar.getProperty((String)"jack.console.restore.connections"));
            if (layout) {
                this.dialog.layout();
            }
        }
    }

    public void loadIcons() {
        this.loadIcons(true);
    }

    public void loadIcons(boolean layout) {
        if (!this.isDisposed()) {
            this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
            if (layout) {
                this.dialog.layout();
            }
        }
    }

    public void updateAutoConnectPorts(boolean autoConnectPorts) {
        try {
            this.jackConnectionManager.setAutoConnectPorts(autoConnectPorts);
            this.jackConnectionManager.saveConfig();
        }
        catch (Throwable throwable) {
            TGErrorManager.getInstance((TGContext)this.context).handleError(throwable);
        }
    }

    public void storeConnections() {
        try {
            this.jackConnectionManager.loadExistingConnections();
            this.jackConnectionManager.saveConfig();
            this.showInfoMessage("jack.console.info.message.title", "jack.console.store.connections.success");
        }
        catch (Throwable throwable) {
            TGErrorManager.getInstance((TGContext)this.context).handleError(throwable);
        }
    }

    public void restoreConnections() {
        try {
            this.jackConnectionManager.connectAllPorts();
            this.showInfoMessage("jack.console.info.message.title", "jack.console.restore.connections.success");
        }
        catch (Throwable throwable) {
            TGErrorManager.getInstance((TGContext)this.context).handleError(throwable);
        }
    }

    public void showInfoMessage(String title, String message) {
        TGMessageDialogUtil.infoMessage((TGContext)this.context, (UIWindow)this.dialog, (String)TuxGuitar.getProperty((String)title), (String)TuxGuitar.getProperty((String)message));
    }

    public void processEvent(TGEvent event) {
        if ("ui-skin".equals(event.getEventType())) {
            this.loadIcons();
        } else if ("language".equals(event.getEventType())) {
            this.loadProperties();
        }
    }
}

