/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.swt.widget;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.ScrollBar;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.resource.UISize;
import org.herac.tuxguitar.ui.swt.event.SWTSelectionListenerManager;
import org.herac.tuxguitar.ui.swt.widget.SWTEventReceiver;
import org.herac.tuxguitar.ui.widget.UIScrollBar;

public class SWTScrollBar
extends SWTEventReceiver<ScrollBar>
implements UIScrollBar {
    private Integer thumb;
    private Integer maximum;
    private Integer minimum;
    private Integer increment;
    private SWTSelectionListenerManager selectionListener = new SWTSelectionListenerManager(this);

    public SWTScrollBar(ScrollBar control) {
        super(control);
    }

    public void dispose() {
        ((ScrollBar)this.getControl()).dispose();
    }

    public boolean isDisposed() {
        return ((ScrollBar)this.getControl()).isDisposed();
    }

    public void setValue(int value) {
        ((ScrollBar)this.getControl()).setSelection(value);
    }

    public int getValue() {
        return ((ScrollBar)this.getControl()).getSelection();
    }

    public boolean isEnabled() {
        return ((ScrollBar)this.getControl()).isEnabled();
    }

    public void setEnabled(boolean enabled) {
        ((ScrollBar)this.getControl()).setEnabled(enabled);
    }

    public boolean isVisible() {
        return ((ScrollBar)this.getControl()).isVisible();
    }

    public void setVisible(boolean visible) {
        ((ScrollBar)this.getControl()).setVisible(visible);
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
        this.updateRangeValues();
    }

    public int getMaximum() {
        return this.maximum != null ? this.maximum : -1;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
        this.updateRangeValues();
    }

    public int getMinimum() {
        return this.minimum != null ? this.minimum : -1;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
        this.updateRangeValues();
    }

    public int getIncrement() {
        return this.increment != null ? this.increment : -1;
    }

    public void setThumb(int thumb) {
        this.thumb = thumb;
        this.updateRangeValues();
    }

    public int getThumb() {
        return this.thumb != null ? this.thumb : -1;
    }

    public UISize getSize() {
        Point point = ((ScrollBar)this.getControl()).getSize();
        return new UISize((float)point.x, (float)point.y);
    }

    public void updateRangeValues() {
        if (this.increment != null) {
            ((ScrollBar)this.getControl()).setIncrement(this.increment.intValue());
        }
        if (this.minimum != null) {
            ((ScrollBar)this.getControl()).setMinimum(this.minimum.intValue());
        }
        if (this.maximum != null) {
            ((ScrollBar)this.getControl()).setMaximum(this.maximum + (this.thumb != null ? this.thumb : 0));
        }
        if (this.thumb != null) {
            ((ScrollBar)this.getControl()).setThumb(this.thumb.intValue());
        }
    }

    public void addSelectionListener(UISelectionListener listener) {
        if (this.selectionListener.isEmpty()) {
            ((ScrollBar)this.getControl()).addSelectionListener((SelectionListener)this.selectionListener);
        }
        this.selectionListener.addListener(listener);
    }

    public void removeSelectionListener(UISelectionListener listener) {
        this.selectionListener.removeListener(listener);
        if (this.selectionListener.isEmpty()) {
            ((ScrollBar)this.getControl()).removeSelectionListener((SelectionListener)this.selectionListener);
        }
    }
}

