
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was Config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# provide meta-data
set(syncthingplasmoid_varname "SYNCTHINGPLASMOID")
set(syncthingplasmoid-git_varname "SYNCTHINGPLASMOID")
set(SYNCTHINGPLASMOID_DISPLAY_NAME "Syncthing Plasmoid (git)")
set(SYNCTHINGPLASMOID_AUTHOR "Martchus")
set(SYNCTHINGPLASMOID_VERSION "1.7.11-2761.f2db7c6e")
set(SYNCTHINGPLASMOID_VERSION_MAJOR "1")
set(SYNCTHINGPLASMOID_VERSION_MINOR "7")
set(SYNCTHINGPLASMOID_VERSION_PATCH "11")
set(SYNCTHINGPLASMOID_GIT_REV_COUNT "2761")
set(SYNCTHINGPLASMOID_GIT_LAST_COMMIT_ID "f2db7c6e")
set(SYNCTHINGPLASMOID_URL "https://Martchus.github.io/syncthingtray")
set(SYNCTHINGPLASMOID_DESCRIPTION "Plasmoid to interact with Syncthing v1")
set(SYNCTHINGPLASMOID_LICENSE "GPL-2.0+")

# define general config
set(SYNCTHINGPLASMOID_IS_HEADER_ONLY NO)
set(SYNCTHINGPLASMOID_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include/syncthingplasmoid-git")
set(SYNCTHINGPLASMOID_BIN_DIR "${PACKAGE_PREFIX_DIR}/bin")
set(SYNCTHINGPLASMOID_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib")
set(SYNCTHINGPLASMOID_DATA_DIRS "${PACKAGE_PREFIX_DIR}/share/syncthingplasmoid-git")
set(SYNCTHINGPLASMOID_MODULE_DIRS "${PACKAGE_PREFIX_DIR}/share/syncthingplasmoid-git/cmake/modules")
set(SYNCTHINGPLASMOID_CONFIG_DIRS "${PACKAGE_PREFIX_DIR}/share/syncthingplasmoid-git/cmake")
set(SYNCTHINGPLASMOID_PRIVATE_QT_MODULES "Network;Qml;Gui;Widgets;Quick;Core")
set(SYNCTHINGPLASMOID_PRIVATE_KF_MODULES "Config")
set(SYNCTHINGPLASMOID_PUBLIC_QT_MODULES "")
set(SYNCTHINGPLASMOID_PUBLIC_KF_MODULES "")
set(SYNCTHINGPLASMOID_REQUIRED_PACKAGES "syncthingconnector-git;syncthingmodel-git;syncthingwidgets-git")
set(SYNCTHINGPLASMOID_REQUIRED_PKG_CONFIG_MODULES "")
set(SYNCTHINGPLASMOID_HAS_QT_TRANSLATION_FILES YES)
set(SYNCTHINGPLASMOID_QT_RESOURCES syncthingplasmoid_translations)

# define mapping from CMake targets to pkg-config module names
set(PKG_CONFIG_syncthingplasmoid-git "syncthingplasmoid-git")

# save policies before modifying them e.g. though the inclusion of 3rdParty
cmake_policy(PUSH)

# define additional find_package arguments for required CMake-packages

# define library config, add imported target
set(SYNCTHINGPLASMOID_PACKAGE "syncthingplasmoid-git")
set(SYNCTHINGPLASMOID_LIB "syncthingplasmoid-git")
set(SYNCTHINGPLASMOID_LIB_IS_SHARED "ON")
set(SYNCTHINGPLASMOID_STATIC_LINKAGE "OFF")
if(NOT TARGET "${SYNCTHINGPLASMOID_LIB}")
    # make dependencies of the library available
    # caveat: This currently does *not* cover Qt and KF modules which are so far only handled
    #         separately when using the function use_syncthingplasmoid.

    # find c++utilities-git to use its CMake modules
    if (NOT SYNCTHINGPLASMOID_PACKAGE STREQUAL "c++utilities-git")
        find_package("c++utilities-git" ${SYNCTHINGPLASMOID_FIND_PACKAGE_ARGS_c++utilities-git} REQUIRED)
    endif ()

    # prefer static libraries if syncthingplasmoid was configured this way during its build
    set(SYNCTHINGPLASMOID_DEFAULT_CMAKE_MODULE_PATH "${CMAKE_MODULE_PATH}")
    list(APPEND CMAKE_MODULE_PATH "${SYNCTHINGPLASMOID_MODULE_DIRS}")
    list(APPEND CMAKE_MODULE_PATH "${CPP_UTILITIES_MODULE_DIRS}")
    include(3rdPartyFunctions)
    if (SYNCTHINGPLASMOID_STATIC_LINKAGE)
        save_library_preference()
        prefer_static_libraries()
    endif ()

    # find all required packages
    foreach (_REQUIRED_PACKAGE ${SYNCTHINGPLASMOID_REQUIRED_PACKAGES})
        string(REGEX MATCH _REQUIRED_PACKAGE_MATCH "(.*)-([^-]*)" "${_REQUIRED_PACKAGE}")
        if (_REQUIRED_PACKAGE_MATCH)
            set(_REQUIRED_PACKAGE "${CMAKE_MATCH_1}")
            set(_REQUIRED_VERSION "${CMAKE_MATCH_2}")
        else ()
            unset(_REQUIRED_VERSION)
        endif ()
        string(REPLACE "::" "_" _REQUIRED_PACKAGE_VARNAME "${_REQUIRED_PACKAGE}")
        if (SYNCTHINGPLASMOID_FIND_PACKAGE_ARGS_${_REQUIRED_PACKAGE_VARNAME})
            set(_FIND_PACKAGE_ARGS ${SYNCTHINGPLASMOID_FIND_PACKAGE_ARGS_${_REQUIRED_PACKAGE_VARNAME}})
        else ()
            set(_FIND_PACKAGE_ARGS REQUIRED)
        endif ()
        if (_REQUIRED_VERSION)
            find_package("${_REQUIRED_PACKAGE}" "${_REQUIRED_VERSION}" ${_FIND_PACKAGE_ARGS})
        else ()
            find_package("${_REQUIRED_PACKAGE}" ${_FIND_PACKAGE_ARGS})
        endif()
    endforeach()

    # find all required pkg-config modules
    if (SYNCTHINGPLASMOID_REQUIRED_PKG_CONFIG_MODULES)
        foreach (SYNCTHINGPLASMOID_REQUIRED_PKG_CONFIG_MODULE ${SYNCTHINGPLASMOID_REQUIRED_PKG_CONFIG_MODULES})
            string(REPLACE "::" "_" SYNCTHINGPLASMOID_REQUIRED_PKG_CONFIG_MODULE_VARNAME "${SYNCTHINGPLASMOID_REQUIRED_PKG_CONFIG_MODULE}")
            use_pkg_config_module(
                TARGET_NAME "${SYNCTHINGPLASMOID_REQUIRED_PKG_CONFIG_MODULE}"
                PKG_CONFIG_MODULES "${PKG_CONFIG_${SYNCTHINGPLASMOID_REQUIRED_PKG_CONFIG_MODULE_VARNAME}}"
                LIBRARIES_VARIABLE DEV_NULL
                PKG_CONFIG_MODULES_VARIABLE DEV_NULL
            )
        endforeach ()
    endif ()

    # restore preference of static libraries
    if (SYNCTHINGPLASMOID_STATIC_LINKAGE)
        restore_library_preference()
    endif ()

    # add target for the library itself
    include("${CMAKE_CURRENT_LIST_DIR}/syncthingplasmoid-gitTargets.cmake")

    # restore module path
    set(CMAKE_MODULE_PATH "${SYNCTHINGPLASMOID_DEFAULT_CMAKE_MODULE_PATH}")
endif()

# define function to ease use of library in projects following conventions of c++utilities' build script
function(use_syncthingplasmoid)
    # make CMake modules of the project available
    list(APPEND CMAKE_MODULE_PATH "${SYNCTHINGPLASMOID_MODULE_DIRS}")
    set(CMAKE_MODULE_PATH "${CMAKE_MODULE_PATH}" PARENT_SCOPE)

    # parse arguments
    list(APPEND CMAKE_MODULE_PATH "${CPP_UTILITIES_MODULE_DIRS}")
    include(3rdParty)
    parse_arguments_for_use_functions(${ARGN})

    # link against library (also "link" against header-only libs to get compile defs and interface link libs)
    link_directories(${SYNCTHINGPLASMOID_LIB_DIR})
    if (ARGS_ONLY_HEADERS)
        set(TARGET_NAME "${SYNCTHINGPLASMOID_LIB}-headers")
    else ()
        set(TARGET_NAME "${SYNCTHINGPLASMOID_LIB}")
    endif ()
    set("${ARGS_LIBRARIES_VARIABLE}" "${${ARGS_LIBRARIES_VARIABLE}};${TARGET_NAME}" PARENT_SCOPE)
    set("${ARGS_PACKAGES_VARIABLE}" "${${ARGS_PACKAGES_VARIABLE}};${SYNCTHINGPLASMOID_PACKAGE}" PARENT_SCOPE)

    if (ARGS_ONLY_HEADERS)
        return ()
    endif ()

    # add required Qt and KF modules
    set(IMPORTED_QT_MODULES
        ${IMPORTED_QT_MODULES}
        ${SYNCTHINGPLASMOID_PUBLIC_QT_MODULES}
        ${SYNCTHINGPLASMOID_PRIVATE_QT_MODULES}
        PARENT_SCOPE
    )
    set(IMPORTED_KF_MODULES
        ${IMPORTED_KF_MODULES}
        ${SYNCTHINGPLASMOID_PUBLIC_KF_MODULES}
        ${SYNCTHINGPLASMOID_PRIVATE_KF_MODULES}
        PARENT_SCOPE
    )

    # add required translations to APP_SPECIFIC_QT_TRANSLATION_FILES_ARRAY
    if(SYNCTHINGPLASMOID_HAS_QT_TRANSLATION_FILES)
        set(APP_SPECIFIC_QT_TRANSLATION_FILES "${APP_SPECIFIC_QT_TRANSLATION_FILES};syncthingplasmoid" PARENT_SCOPE)
    endif()

    # add Qt resources if it is a static library
    if (NOT SYNCTHINGPLASMOID_LIB_IS_SHARED)
        set(STATIC_LIBRARIES_QT_RESOURCES "${STATIC_LIBRARIES_QT_RESOURCES};${SYNCTHINGPLASMOID_QT_RESOURCES}" PARENT_SCOPE)
    endif()
endfunction()

# restore policies
cmake_policy(POP)
