
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was Config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# provide meta-data
set(reflective_rapidjson_varname "REFLECTIVE_RAPIDJSON")
set(reflective_rapidjson_varname "REFLECTIVE_RAPIDJSON")
set(REFLECTIVE_RAPIDJSON_DISPLAY_NAME "Reflection for RapidJSON")
set(REFLECTIVE_RAPIDJSON_AUTHOR "Martchus")
set(REFLECTIVE_RAPIDJSON_VERSION "0.0.16")
set(REFLECTIVE_RAPIDJSON_VERSION_MAJOR "0")
set(REFLECTIVE_RAPIDJSON_VERSION_MINOR "0")
set(REFLECTIVE_RAPIDJSON_VERSION_PATCH "16")
set(REFLECTIVE_RAPIDJSON_GIT_REV_COUNT "")
set(REFLECTIVE_RAPIDJSON_GIT_LAST_COMMIT_ID "")
set(REFLECTIVE_RAPIDJSON_URL "https://github.com/Martchus/reflective-rapidjson")
set(REFLECTIVE_RAPIDJSON_DESCRIPTION "Reflection for serializing/deserializing with RapidJSON")
set(REFLECTIVE_RAPIDJSON_LICENSE "GPL-2.0+")

# define general config
set(REFLECTIVE_RAPIDJSON_IS_HEADER_ONLY YES)
set(REFLECTIVE_RAPIDJSON_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include")
set(REFLECTIVE_RAPIDJSON_BIN_DIR "${PACKAGE_PREFIX_DIR}/bin")
set(REFLECTIVE_RAPIDJSON_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib")
set(REFLECTIVE_RAPIDJSON_DATA_DIRS "${PACKAGE_PREFIX_DIR}/share/reflective_rapidjson")
set(REFLECTIVE_RAPIDJSON_MODULE_DIRS "${PACKAGE_PREFIX_DIR}/share/reflective_rapidjson/cmake/modules")
set(REFLECTIVE_RAPIDJSON_CONFIG_DIRS "${PACKAGE_PREFIX_DIR}/share/reflective_rapidjson/cmake")
set(REFLECTIVE_RAPIDJSON_PRIVATE_QT_MODULES "")
set(REFLECTIVE_RAPIDJSON_PRIVATE_KF_MODULES "")
set(REFLECTIVE_RAPIDJSON_PUBLIC_QT_MODULES "")
set(REFLECTIVE_RAPIDJSON_PUBLIC_KF_MODULES "")
set(REFLECTIVE_RAPIDJSON_REQUIRED_PACKAGES "c++utilities")
set(REFLECTIVE_RAPIDJSON_REQUIRED_PKG_CONFIG_MODULES "")
set(REFLECTIVE_RAPIDJSON_HAS_QT_TRANSLATION_FILES )
set(REFLECTIVE_RAPIDJSON_QT_RESOURCES )

# define mapping from CMake targets to pkg-config module names
set(PKG_CONFIG_reflective_rapidjson "reflective_rapidjson")

# define additional find_package arguments for required CMake-packages

# define library config, add imported target
set(REFLECTIVE_RAPIDJSON_PACKAGE "reflective_rapidjson")
set(REFLECTIVE_RAPIDJSON_LIB "reflective_rapidjson")
set(REFLECTIVE_RAPIDJSON_LIB_IS_SHARED "ON")
set(REFLECTIVE_RAPIDJSON_STATIC_LINKAGE "OFF")
if(NOT TARGET "${REFLECTIVE_RAPIDJSON_LIB}")
    # make dependencies of the library available
    # caveat: This currently does *not* cover Qt and KF modules which are so far only handled
    #         separately when using the function use_reflective_rapidjson.

    # prefer static libraries if reflective_rapidjson was configured this way during its build
    if (REFLECTIVE_RAPIDJSON_STATIC_LINKAGE)
        set(REFLECTIVE_RAPIDJSON_DEFAULT_CMAKE_FIND_LIBRARY_SUFFIXES ${CMAKE_FIND_LIBRARY_SUFFIXES})
        if (WIN32)
            set(CMAKE_FIND_LIBRARY_SUFFIXES .a .lib)
        else ()
            set(CMAKE_FIND_LIBRARY_SUFFIXES .a)
        endif ()
        set(REFLECTIVE_RAPIDJSON_DEFAULT_PKG_CONFIG_USE_STATIC_LIBS ${PKG_CONFIG_USE_STATIC_LIBS})
        set(PKG_CONFIG_USE_STATIC_LIBS ON)
    endif ()

    # find all required packages
    foreach (_REQUIRED_PACKAGE ${REFLECTIVE_RAPIDJSON_REQUIRED_PACKAGES})
        string(REGEX MATCH _REQUIRED_PACKAGE_MATCH "(.*)-([^-]*)" "${_REQUIRED_PACKAGE}")
        if (_REQUIRED_PACKAGE_MATCH)
            set(_REQUIRED_PACKAGE "${CMAKE_MATCH_1}")
            set(_REQUIRED_VERSION "${CMAKE_MATCH_2}")
        else ()
            unset(_REQUIRED_VERSION)
        endif ()
        string(REPLACE "::" "_" _REQUIRED_PACKAGE_VARNAME "${_REQUIRED_PACKAGE}")
        if (REFLECTIVE_RAPIDJSON_FIND_PACKAGE_ARGS_${_REQUIRED_PACKAGE_VARNAME})
            set(_FIND_PACKAGE_ARGS ${REFLECTIVE_RAPIDJSON_FIND_PACKAGE_ARGS_${_REQUIRED_PACKAGE_VARNAME}})
        else ()
            set(_FIND_PACKAGE_ARGS REQUIRED)
        endif ()
        if (_REQUIRED_VERSION)
            find_package("${_REQUIRED_PACKAGE}" "${_REQUIRED_VERSION}" ${_FIND_PACKAGE_ARGS})
        else ()
            find_package("${_REQUIRED_PACKAGE}" ${_FIND_PACKAGE_ARGS})
        endif()
    endforeach()

    # find all required pkg-config modules
    if (REFLECTIVE_RAPIDJSON_REQUIRED_PKG_CONFIG_MODULES)
        include(3rdParty)
        foreach (REFLECTIVE_RAPIDJSON_REQUIRED_PKG_CONFIG_MODULE ${REFLECTIVE_RAPIDJSON_REQUIRED_PKG_CONFIG_MODULES})
            string(REPLACE "::" "_" REFLECTIVE_RAPIDJSON_REQUIRED_PKG_CONFIG_MODULE_VARNAME "${REFLECTIVE_RAPIDJSON_REQUIRED_PKG_CONFIG_MODULE}")
            use_pkg_config_module(
                TARGET_NAME "${REFLECTIVE_RAPIDJSON_REQUIRED_PKG_CONFIG_MODULE}"
                PKG_CONFIG_MODULES "${PKG_CONFIG_${REFLECTIVE_RAPIDJSON_REQUIRED_PKG_CONFIG_MODULE_VARNAME}}"
                LIBRARIES_VARIABLE DEV_NULL
                PKG_CONFIG_MODULES_VARIABLE DEV_NULL
            )
        endforeach ()
    endif ()

    # restore preference of static libraries
    if (REFLECTIVE_RAPIDJSON_STATIC_LINKAGE)
        set(CMAKE_FIND_LIBRARY_SUFFIXES ${REFLECTIVE_RAPIDJSON_DEFAULT_CMAKE_FIND_LIBRARY_SUFFIXES})
        unset(REFLECTIVE_RAPIDJSON_DEFAULT_CMAKE_FIND_LIBRARY_SUFFIXES)
        set(PKG_CONFIG_USE_STATIC_LIBS ${REFLECTIVE_RAPIDJSON_DEFAULT_PKG_CONFIG_USE_STATIC_LIBS})
        unset(REFLECTIVE_RAPIDJSON_DEFAULT_PKG_CONFIG_USE_STATIC_LIBS)
    endif ()

    # add target for the library itself
    include("${CMAKE_CURRENT_LIST_DIR}/reflective_rapidjsonTargets.cmake")
endif()

# define function to ease use of library in projects following conventions of c++utilities' build script
function(use_reflective_rapidjson)
    # make CMake modules of the project available
    list(APPEND CMAKE_MODULE_PATH "${REFLECTIVE_RAPIDJSON_MODULE_DIRS}")
    set(CMAKE_MODULE_PATH "${CMAKE_MODULE_PATH}" PARENT_SCOPE)

    # parse arguments
    include(3rdParty)
    parse_arguments_for_use_functions(${ARGN})

    # link against library (also "link" against header-only libs to get compile defs and interface link libs)
    link_directories(${REFLECTIVE_RAPIDJSON_LIB_DIR})
    if (ARGS_ONLY_HEADERS)
        set(TARGET_NAME "${REFLECTIVE_RAPIDJSON_LIB}-headers")
    else ()
        set(TARGET_NAME "${REFLECTIVE_RAPIDJSON_LIB}")
    endif ()
    set("${ARGS_LIBRARIES_VARIABLE}" "${${ARGS_LIBRARIES_VARIABLE}};${TARGET_NAME}" PARENT_SCOPE)
    set("${ARGS_PACKAGES_VARIABLE}" "${${ARGS_PACKAGES_VARIABLE}};${REFLECTIVE_RAPIDJSON_PACKAGE}" PARENT_SCOPE)

    if (ARGS_ONLY_HEADERS)
        return ()
    endif ()

    # add required Qt and KF modules
    set(IMPORTED_QT_MODULES
        ${IMPORTED_QT_MODULES}
        ${REFLECTIVE_RAPIDJSON_PUBLIC_QT_MODULES}
        ${REFLECTIVE_RAPIDJSON_PRIVATE_QT_MODULES}
        PARENT_SCOPE
    )
    set(IMPORTED_KF_MODULES
        ${IMPORTED_KF_MODULES}
        ${REFLECTIVE_RAPIDJSON_PUBLIC_KF_MODULES}
        ${REFLECTIVE_RAPIDJSON_PRIVATE_KF_MODULES}
        PARENT_SCOPE
    )

    # add required translations to APP_SPECIFIC_QT_TRANSLATION_FILES_ARRAY
    if(REFLECTIVE_RAPIDJSON_HAS_QT_TRANSLATION_FILES)
        set(APP_SPECIFIC_QT_TRANSLATION_FILES "${APP_SPECIFIC_QT_TRANSLATION_FILES};reflective_rapidjson" PARENT_SCOPE)
    endif()

    # add Qt resources if it is a static library
    if (NOT REFLECTIVE_RAPIDJSON_LIB_IS_SHARED)
        set(STATIC_LIBRARIES_QT_RESOURCES "${STATIC_LIBRARIES_QT_RESOURCES};${REFLECTIVE_RAPIDJSON_QT_RESOURCES}" PARENT_SCOPE)
    endif()
endfunction()
