# Stefan Achatz 2014
#
# Tries to find libgaminggear and sets following variables according to found capabilities:
#
# GAMINGGEAR0_FOUND
# GAMINGGEAR0_INCLUDE_DIR
# GAMINGGEAR0_LIBRARY
# GAMINGGEAR0_WIDGET_LIBRARY
# GAMINGGEAR0_VERSION
# GAMINGGEAR0_FX_PLUGIN_DIR

FIND_PACKAGE(PkgConfig)
PKG_CHECK_MODULES(PKG_GAMINGGEAR gaminggear-0)

FIND_PATH(GAMINGGEAR0_INCLUDE_DIR gaminggear/gaminggear.h
  HINTS
    ${PKG_GAMINGGEAR_INCLUDEDIR}
)

FIND_LIBRARY(GAMINGGEAR0_LIBRARY gaminggear
  HINTS ${PKG_GAMINGGEAR_LIBRARY_DIRS}
)

FIND_LIBRARY(GAMINGGEAR0_WIDGET_LIBRARY gaminggearwidget
  HINTS ${PKG_GAMINGGEAR_LIBRARY_DIRS}
)

SET(GAMINGGEAR0_FX_PLUGIN_DIR /usr/lib/gaminggear_plugins)

IF(GAMINGGEAR0_LIBRARY AND GAMINGGEAR0_WIDGET_LIBRARY AND GAMINGGEAR0_INCLUDE_DIR)
  FILE(READ "${GAMINGGEAR0_INCLUDE_DIR}/gaminggear/gaminggear.h" _CONTENTS)
  IF(_CONTENTS)
    STRING(REGEX REPLACE ".*#define[ \t]+GAMINGGEAR_VERSION_STRING[ \t]+\"([0-9.]+)\".*" "\\1" GAMINGGEAR0_VERSION "${_CONTENTS}")
  ELSE()
    MESSAGE(FATAL_ERROR "Can't read ${GAMINGGEAR0_INCLUDE_DIR}/gaminggear/gaminggear.h")
  ENDIF()

  IF(GAMINGGEAR0_FIND_VERSION)
    IF(GAMINGGEAR0_FIND_VERSION_EXACT)
      IF(GAMINGGEAR0_VERSION VERSION_EQUAL GAMINGGEAR0_FIND_VERSION)
        SET(GAMINGGEAR0_FOUND true)
      ELSE()
        SET(GAMINGGEAR0_FOUND false)
        MESSAGE("GAMINGGEAR0 version mismatch ${GAMINGGEAR0_VERSION} != ${GAMINGGEAR0_FIND_VERSION}")
      ENDIF()
    ELSE()
      IF(GAMINGGEAR0_VERSION VERSION_EQUAL GAMINGGEAR0_FIND_VERSION OR
         GAMINGGEAR0_VERSION VERSION_GREATER GAMINGGEAR0_FIND_VERSION)
        SET(GAMINGGEAR0_FOUND true)
      ELSE()
        SET(GAMINGGEAR0_FOUND false)
        MESSAGE("GAMINGGEAR0 version mismatch ${GAMINGGEAR0_VERSION} < ${GAMINGGEAR0_FIND_VERSION}")
      ENDIF()
    ENDIF()
  ELSE()
    SET(GAMINGGEAR0_FOUND true)
  ENDIF()
ENDIF()

IF(NOT GAMINGGEAR0_FOUND)
  UNSET(GAMINGGEAR0_INCLUDE_DIR)
  UNSET(GAMINGGEAR0_LIBRARY)
  UNSET(GAMINGGEAR0_WIDGET_LIBRARY)
  UNSET(GAMINGGEAR0_VERSION)
  UNSET(GAMINGGEAR0_FX_PLUGIN_DIR)
ENDIF()

IF(GAMINGGEAR0_FIND_REQUIRED AND NOT GAMINGGEAR0_FOUND)
  MESSAGE(FATAL_ERROR "Could not find GAMINGGEAR0")
ENDIF()
