export default `<div class="login-client-image">
  <% if (client.logoUri) { %><img src="<%= client.logoUri %>"><% } %>
</div>

<ul>
<% if ([details.missingOIDCScope, details.missingOIDCClaims, details.missingResourceScopes].filter(Boolean).length === 0) { %>
  <li>the client is asking you to confirm previously given authorization</li>
<% } %>

<% missingOIDCScope = new Set(details.missingOIDCScope); missingOIDCScope.delete('openid'); missingOIDCScope.delete('offline_access') %>
<% if (missingOIDCScope.size) { %>
  <li>scopes:</li>
  <ul>
    <% missingOIDCScope.forEach((scope) => { %>
      <li><%= scope %></li>
    <% }) %>
  </ul>
<% } %>

<% missingOIDCClaims = new Set(details.missingOIDCClaims); ['sub', 'sid', 'auth_time', 'acr', 'amr', 'iss'].forEach(Set.prototype.delete.bind(missingOIDCClaims)) %>
<% if (missingOIDCClaims.size) { %>
  <li>claims:</li>
  <ul>
    <% missingOIDCClaims.forEach((claim) => { %>
      <li><%= claim %></li>
    <% }) %>
  </ul>
<% } %>

<% missingResourceScopes = details.missingResourceScopes %>
<% if (missingResourceScopes) { %>
  <% for (const [indicator, scopes] of Object.entries(details.missingResourceScopes)) { %>
    <li><%= indicator %>:</li>
    <ul>
      <% scopes.forEach((scope) => { %>
        <li><%= scope %></li>
      <% }) %>
    </ul>
  <% } %>
<% } %>

<% if (params.scope && params.scope.includes('offline_access')) { %>
  <li>
  the client is asking to have offline access to this authorization
    <% if ((!details.missingOIDCScope) || !details.missingOIDCScope.includes('offline_access')) { %>
      (which you've previously granted)
    <% } %>
  </li>
<% } %>

</ul>

<form autocomplete="off" action="<%= submitUrl %>" method="post">
  <input type="hidden" name="prompt" value="consent"/>
  <button autofocus type="submit" class="login login-submit">Continue</button>
</form>
`;
