import type { Options } from "./config.ts";
import type { AstObject } from "./parse.ts";
import type { Eta } from "./core.ts";
/**
 * Compiles a template string to a function string. Most often users just use `compile()`, which calls `compileToString` and creates a new function using the result
 */
export declare function compileToString(this: Eta, str: string, options?: Partial<Options>): string;
/**
 * Loops through the AST generated by `parse` and transform each item into JS calls
 *
 * **Example**
 *
 * ```js
 * let templateAST = ['Hi ', { val: 'it.name', t: 'i' }]
 * compileBody.call(Eta, templateAST)
 * // => "__eta.res+='Hi '\n__eta.res+=__eta.e(it.name)\n"
 * ```
 */
export declare function compileBody(this: Eta, buff: Array<AstObject>): string;
//# sourceMappingURL=compile-string.d.ts.map