/**
 * klona/json - MIT License
 *
 * https://github.com/lukeed/klona/blob/master/license
 */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "klona", {
    enumerable: true,
    get: function() {
        return klona;
    }
});
function klona(val) {
    var index, out, tmp;
    if (Array.isArray(val)) {
        out = Array(index = val.length);
        while(index--)out[index] = (tmp = val[index]) && typeof tmp === "object" ? klona(tmp) : tmp;
        return out;
    }
    if (Object.prototype.toString.call(val) === "[object Object]") {
        out = {}; // null
        for(index in val){
            if (index === "__proto__") {
                Object.defineProperty(out, index, {
                    value: klona(val[index]),
                    configurable: true,
                    enumerable: true,
                    writable: true
                });
            } else {
                out[index] = (tmp = val[index]) && typeof tmp === "object" ? klona(tmp) : tmp;
            }
        }
        return out;
    }
    return val;
}
