<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>
<tagfile>
  <compound kind="file">
    <name>barrier.h</name>
    <path>/build/coin/src/coin/include/Inventor/C/threads/</path>
    <filename>barrier_8h</filename>
    <includes id="common_8h" name="common.h" local="no" imported="no">Inventor/C/threads/common.h</includes>
    <member kind="function">
      <type>cc_barrier *</type>
      <name>cc_barrier_construct</name>
      <anchorfile>barrier_8h.html</anchorfile>
      <anchor>a08b3fa4e3a37add61b05759033d4de1b</anchor>
      <arglist>(unsigned int numthreads)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_barrier_destruct</name>
      <anchorfile>barrier_8h.html</anchorfile>
      <anchor>aadab0c4cb10481f3e272885a84a4709d</anchor>
      <arglist>(cc_barrier *barrier)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_barrier_enter</name>
      <anchorfile>barrier_8h.html</anchorfile>
      <anchor>acb9ec6cb444608a16d1bed98a55949ae</anchor>
      <arglist>(cc_barrier *barrier)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>common.h</name>
    <path>/build/coin/src/coin/include/Inventor/C/threads/</path>
    <filename>common_8h</filename>
    <member kind="typedef">
      <type>struct cc_sched</type>
      <name>cc_sched</name>
      <anchorfile>group__threads.html</anchorfile>
      <anchor>ga42acbbf50baecd447dfbc76305b4bafb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_wpool</type>
      <name>cc_wpool</name>
      <anchorfile>group__threads.html</anchorfile>
      <anchor>ga5cd98b5d28446124b569ac260b1ca774</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_worker</type>
      <name>cc_worker</name>
      <anchorfile>group__threads.html</anchorfile>
      <anchor>ga256d99f9f55c522f7b478a5e091a7aa6</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_thread</type>
      <name>cc_thread</name>
      <anchorfile>group__threads.html</anchorfile>
      <anchor>ga125b0ce154c9b9ead0a92df5abdbed70</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_mutex</type>
      <name>cc_mutex</name>
      <anchorfile>group__threads.html</anchorfile>
      <anchor>ga480e847013035e71e32afbb8f8470626</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_rwmutex</type>
      <name>cc_rwmutex</name>
      <anchorfile>group__threads.html</anchorfile>
      <anchor>ga2aeb009bcdf2e26aa2bb3275e09422cb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_condvar</type>
      <name>cc_condvar</name>
      <anchorfile>group__threads.html</anchorfile>
      <anchor>ga4009ed32241ef5637806e8526c9061db</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_storage</type>
      <name>cc_storage</name>
      <anchorfile>group__threads.html</anchorfile>
      <anchor>ga39bad19f9e36be7b7ec7c498e1a7254a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_fifo</type>
      <name>cc_fifo</name>
      <anchorfile>group__threads.html</anchorfile>
      <anchor>ga7d996ed6e701d03f8e9480b55a540828</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_barrier</type>
      <name>cc_barrier</name>
      <anchorfile>group__threads.html</anchorfile>
      <anchor>ga697b4c8e006ee21aacf099a7377a8ea4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_recmutex</type>
      <name>cc_recmutex</name>
      <anchorfile>group__threads.html</anchorfile>
      <anchor>ga33e7e331036f7b76a8b14ad03a226969</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>cc_precedence</name>
      <anchorfile>group__threads.html</anchorfile>
      <anchor>ga8fee93200a830bf8d695dc1ad90284bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>cc_threads_implementation</name>
      <anchorfile>group__threads.html</anchorfile>
      <anchor>ga8aea26903d4582f3645184059e50e25c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>cc_retval</name>
      <anchorfile>group__threads.html</anchorfile>
      <anchor>gafb1e455fcfc68469973c055b20999d1b</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_thread_implementation</name>
      <anchorfile>common_8h.html</anchorfile>
      <anchor>a135759144d479fdfc6346eb99bd6a91f</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>condvar.h</name>
    <path>/build/coin/src/coin/include/Inventor/C/threads/</path>
    <filename>condvar_8h</filename>
    <includes id="common_8h" name="common.h" local="no" imported="no">Inventor/C/threads/common.h</includes>
    <member kind="function">
      <type>cc_condvar *</type>
      <name>cc_condvar_construct</name>
      <anchorfile>condvar_8h.html</anchorfile>
      <anchor>af43cd24911db044ca2481fdccde7a1f0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_condvar_destruct</name>
      <anchorfile>condvar_8h.html</anchorfile>
      <anchor>afb0209d8ddc637437fe467c14d407832</anchor>
      <arglist>(cc_condvar *condvar)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_condvar_wait</name>
      <anchorfile>condvar_8h.html</anchorfile>
      <anchor>aef8501afbc406efd662e8175546edd14</anchor>
      <arglist>(cc_condvar *condvar, cc_mutex *mutex)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_condvar_timed_wait</name>
      <anchorfile>condvar_8h.html</anchorfile>
      <anchor>aa52ad3084323b1619ab73d5eaf6fbb88</anchor>
      <arglist>(cc_condvar *condvar, cc_mutex *mutex, cc_time period)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_condvar_wake_one</name>
      <anchorfile>condvar_8h.html</anchorfile>
      <anchor>a07daf12565da74c1c8adc7a3023468a5</anchor>
      <arglist>(cc_condvar *condvar)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_condvar_wake_all</name>
      <anchorfile>condvar_8h.html</anchorfile>
      <anchor>aa0855441ff36d1ad59ec4e576ff85e0d</anchor>
      <arglist>(cc_condvar *condvar)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>fifo.h</name>
    <path>/build/coin/src/coin/include/Inventor/C/threads/</path>
    <filename>fifo_8h</filename>
    <includes id="common_8h" name="common.h" local="no" imported="no">Inventor/C/threads/common.h</includes>
    <member kind="function">
      <type>cc_fifo *</type>
      <name>cc_fifo_new</name>
      <anchorfile>fifo_8h.html</anchorfile>
      <anchor>a4e4fcdd2972f0f1bb11b2d4745079191</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_fifo_delete</name>
      <anchorfile>fifo_8h.html</anchorfile>
      <anchor>aef1a8b82445d1674f0d9806e4e86ab4b</anchor>
      <arglist>(cc_fifo *fifo)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_fifo_assign</name>
      <anchorfile>fifo_8h.html</anchorfile>
      <anchor>a4b59b38f87481efc2041bb7bc2c8a13c</anchor>
      <arglist>(cc_fifo *fifo, void *ptr, uint32_t type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_fifo_retrieve</name>
      <anchorfile>fifo_8h.html</anchorfile>
      <anchor>ae22cfbc1394df9c68a2518d00b33f406</anchor>
      <arglist>(cc_fifo *fifo, void **ptr, uint32_t *type)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_fifo_try_retrieve</name>
      <anchorfile>fifo_8h.html</anchorfile>
      <anchor>aecd1aa4e9efb711dbbba929fcf23c17b</anchor>
      <arglist>(cc_fifo *fifo, void **ptr, uint32_t *type)</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>cc_fifo_size</name>
      <anchorfile>fifo_8h.html</anchorfile>
      <anchor>a3cf31898a7217a97ef00324cc0d6e0c5</anchor>
      <arglist>(cc_fifo *fifo)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_fifo_lock</name>
      <anchorfile>fifo_8h.html</anchorfile>
      <anchor>a654abc1b5249b4b8348f4aebb52bd900</anchor>
      <arglist>(cc_fifo *fifo)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_fifo_unlock</name>
      <anchorfile>fifo_8h.html</anchorfile>
      <anchor>a97d46b795994d8e6d7237d99393d8d94</anchor>
      <arglist>(cc_fifo *fifo)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_fifo_peek</name>
      <anchorfile>fifo_8h.html</anchorfile>
      <anchor>a254a1a966ae1da0153f884e9b1df2c92</anchor>
      <arglist>(cc_fifo *fifo, void **item, uint32_t *type)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_fifo_contains</name>
      <anchorfile>fifo_8h.html</anchorfile>
      <anchor>af9f1a63db8598d795a3b5f07fcca52f4</anchor>
      <arglist>(cc_fifo *fifo, void *item)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_fifo_reclaim</name>
      <anchorfile>fifo_8h.html</anchorfile>
      <anchor>ab43246ce53fc777cfefcd85407e08e83</anchor>
      <arglist>(cc_fifo *fifo, void *item)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>hash.h</name>
    <path>/build/coin/src/coin/include/Inventor/C/base/</path>
    <filename>hash_8h</filename>
    <member kind="typedef">
      <type>uintptr_t</type>
      <name>cc_hash_key</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>af06662abf2e6f6f516b00673cba5969b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_hash</type>
      <name>cc_hash</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>a727fda23295414ad0fc28e16be55f8aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>cc_hash_key</type>
      <name>cc_hash_func</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>a4898219b43dabf39e47a1d061c440277</anchor>
      <arglist>(const cc_hash_key key)</arglist>
    </member>
    <member kind="typedef">
      <type>void</type>
      <name>cc_hash_apply_func</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>ac1fff00729b2bb34f90bfbd4121a2e61</anchor>
      <arglist>(cc_hash_key key, void *val, void *closure)</arglist>
    </member>
    <member kind="function">
      <type>cc_hash *</type>
      <name>cc_hash_construct</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>a5ddc99f3996de4a625ff68a415fe597b</anchor>
      <arglist>(unsigned int size, float loadfactor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_hash_destruct</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>aec73575d34a0ef54ae43d36ff056ddd9</anchor>
      <arglist>(cc_hash *ht)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_hash_clear</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>a7f7571eab4742e08fe4a0290dc97369a</anchor>
      <arglist>(cc_hash *ht)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_hash_put</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>af7f9e79d9d42b55093cdf2eb6dd380d8</anchor>
      <arglist>(cc_hash *ht, cc_hash_key key, void *val)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_hash_get</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>ae48139859990f932d46bfd311e9e5612</anchor>
      <arglist>(cc_hash *ht, cc_hash_key key, void **val)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_hash_remove</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>ac935a65f1170c7fcd2a5bb2f739ae5fd</anchor>
      <arglist>(cc_hash *ht, cc_hash_key key)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_hash_apply</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>a012b0962e9368b8eadd3f579511e04bf</anchor>
      <arglist>(cc_hash *ht, cc_hash_apply_func *func, void *closure)</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>cc_hash_get_num_elements</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>a7c5f67dc300bcfa466d9658749186ff9</anchor>
      <arglist>(cc_hash *ht)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_hash_set_hash_func</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>a7d83ee3b50d24b6c614d824f466a5f7a</anchor>
      <arglist>(cc_hash *ht, cc_hash_func *func)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_hash_print_stat</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>a9f2f3e61fd5a5ca79329d43ac4812474</anchor>
      <arglist>(cc_hash *ht)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>heap.h</name>
    <path>/build/coin/src/coin/include/Inventor/C/base/</path>
    <filename>heap_8h</filename>
    <member kind="typedef">
      <type>int</type>
      <name>cc_heap_compare_cb</name>
      <anchorfile>heap_8h.html</anchorfile>
      <anchor>a47f3785a4735870bb7386a9e0a334625</anchor>
      <arglist>(void *o1, void *o2)</arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_heap</type>
      <name>cc_heap</name>
      <anchorfile>heap_8h.html</anchorfile>
      <anchor>a3cfe921d58e2792362b8c28cc74c2637</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>cc_heap *</type>
      <name>cc_heap_construct</name>
      <anchorfile>heap_8h.html</anchorfile>
      <anchor>a9be3b026a6ef0c5d78fffd46ac3b3b8c</anchor>
      <arglist>(unsigned int size, cc_heap_compare_cb *comparecb, SbBool support_remove)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_heap_destruct</name>
      <anchorfile>heap_8h.html</anchorfile>
      <anchor>a0288a01e95c1a24413645d0623a82166</anchor>
      <arglist>(cc_heap *h)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_heap_clear</name>
      <anchorfile>heap_8h.html</anchorfile>
      <anchor>a71e9aa42386f736864042e72ee7ad0ca</anchor>
      <arglist>(cc_heap *h)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_heap_add</name>
      <anchorfile>heap_8h.html</anchorfile>
      <anchor>aefa3ba63b7ace7b1cc0d774d54576a4f</anchor>
      <arglist>(cc_heap *h, void *o)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>cc_heap_get_top</name>
      <anchorfile>heap_8h.html</anchorfile>
      <anchor>aa3173f1d3d5a0f8518380a7b713a952a</anchor>
      <arglist>(cc_heap *h)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>cc_heap_extract_top</name>
      <anchorfile>heap_8h.html</anchorfile>
      <anchor>aa253e04784df1765ae4769fe80b28cea</anchor>
      <arglist>(cc_heap *h)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_heap_remove</name>
      <anchorfile>heap_8h.html</anchorfile>
      <anchor>a088aeb698e4df777529b702e3f523235</anchor>
      <arglist>(cc_heap *h, void *o)</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>cc_heap_elements</name>
      <anchorfile>heap_8h.html</anchorfile>
      <anchor>aae0cabf2363726f31257dfbbfef3765f</anchor>
      <arglist>(cc_heap *h)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_heap_empty</name>
      <anchorfile>heap_8h.html</anchorfile>
      <anchor>ade2be8b0679dbb5d9be8c6ac486a84f8</anchor>
      <arglist>(cc_heap *h)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>memalloc.h</name>
    <path>/build/coin/src/coin/include/Inventor/C/base/</path>
    <filename>memalloc_8h</filename>
    <member kind="typedef">
      <type>struct cc_memalloc</type>
      <name>cc_memalloc</name>
      <anchorfile>memalloc_8h.html</anchorfile>
      <anchor>ae3c740f22f57a7a7d7a05b1cce58c451</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>cc_memalloc_strategy_cb</name>
      <anchorfile>memalloc_8h.html</anchorfile>
      <anchor>abc5453b97baa2e9a66c2a1130270cc15</anchor>
      <arglist>(const int numunits_allocated)</arglist>
    </member>
    <member kind="function">
      <type>cc_memalloc *</type>
      <name>cc_memalloc_construct</name>
      <anchorfile>memalloc_8h.html</anchorfile>
      <anchor>ac9ed08ff8666e9dac4c2060f4b5ea7ca</anchor>
      <arglist>(const unsigned int unitsize)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_memalloc_destruct</name>
      <anchorfile>memalloc_8h.html</anchorfile>
      <anchor>a12e3bbd5b1a9771b5af9a0becf7642dc</anchor>
      <arglist>(cc_memalloc *allocator)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>cc_memalloc_allocate</name>
      <anchorfile>memalloc_8h.html</anchorfile>
      <anchor>ab51b6af04b140b1107b08187f3b57237</anchor>
      <arglist>(cc_memalloc *allocator)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_memalloc_deallocate</name>
      <anchorfile>memalloc_8h.html</anchorfile>
      <anchor>a90bd1bc461b30fc15280b1da65007c3a</anchor>
      <arglist>(cc_memalloc *allocator, void *ptr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_memalloc_clear</name>
      <anchorfile>memalloc_8h.html</anchorfile>
      <anchor>a5161cb02bd23ce15d6103960f4591d55</anchor>
      <arglist>(cc_memalloc *allocator)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_memalloc_set_strategy</name>
      <anchorfile>memalloc_8h.html</anchorfile>
      <anchor>a3de013b2bf9a5c6dfd24fea80ed9f59c</anchor>
      <arglist>(cc_memalloc *allocator, cc_memalloc_strategy_cb *cb)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>mutex.h</name>
    <path>/build/coin/src/coin/include/Inventor/C/threads/</path>
    <filename>mutex_8h</filename>
    <includes id="common_8h" name="common.h" local="no" imported="no">Inventor/C/threads/common.h</includes>
    <member kind="function">
      <type>cc_mutex *</type>
      <name>cc_mutex_construct</name>
      <anchorfile>mutex_8h.html</anchorfile>
      <anchor>a67514cef4b9e1d00b0b0351e8cc2f3e0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_mutex_destruct</name>
      <anchorfile>mutex_8h.html</anchorfile>
      <anchor>ae7c298016280a87354ee7f53f9774104</anchor>
      <arglist>(cc_mutex *mutex)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_mutex_lock</name>
      <anchorfile>mutex_8h.html</anchorfile>
      <anchor>ab68ff1ae48b2a4e79c2e80920efb464a</anchor>
      <arglist>(cc_mutex *mutex)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_mutex_try_lock</name>
      <anchorfile>mutex_8h.html</anchorfile>
      <anchor>ad82cc2b3ffa50695c8b311c9312e1316</anchor>
      <arglist>(cc_mutex *mutex)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_mutex_unlock</name>
      <anchorfile>mutex_8h.html</anchorfile>
      <anchor>a958bb509f74af082422fe35a11984cfd</anchor>
      <arglist>(cc_mutex *mutex)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>rbptree.h</name>
    <path>/build/coin/src/coin/include/Inventor/C/base/</path>
    <filename>rbptree_8h</filename>
    <class kind="struct">cc_rbptree</class>
    <member kind="typedef">
      <type>struct cc_rbptree_node</type>
      <name>cc_rbptree_node</name>
      <anchorfile>rbptree_8h.html</anchorfile>
      <anchor>a5209167b68ccfcbe6d068b16057102ed</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_rbptree</type>
      <name>cc_rbptree</name>
      <anchorfile>rbptree_8h.html</anchorfile>
      <anchor>ab09eebdf9578e3f9aa6a2e6c852c76ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>void</type>
      <name>cc_rbptree_traversecb</name>
      <anchorfile>rbptree_8h.html</anchorfile>
      <anchor>a48571686e40c3566ebf3e9458b2aaa17</anchor>
      <arglist>(void *p, void *data, void *closure)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_rbptree_init</name>
      <anchorfile>rbptree_8h.html</anchorfile>
      <anchor>af09e13486f87122b6d6f096960415c8b</anchor>
      <arglist>(cc_rbptree *t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_rbptree_clean</name>
      <anchorfile>rbptree_8h.html</anchorfile>
      <anchor>aa6d7161d1c7b096a40e4ade32414867c</anchor>
      <arglist>(cc_rbptree *t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_rbptree_insert</name>
      <anchorfile>rbptree_8h.html</anchorfile>
      <anchor>a84a326595b5d2def77f6727a666a00ba</anchor>
      <arglist>(cc_rbptree *t, void *p, void *data)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_rbptree_remove</name>
      <anchorfile>rbptree_8h.html</anchorfile>
      <anchor>a77937a81bb8d88f04a23bab29d614194</anchor>
      <arglist>(cc_rbptree *t, void *p)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>cc_rbptree_size</name>
      <anchorfile>rbptree_8h.html</anchorfile>
      <anchor>a2806ddfd9cf98ae83ff39154572886d2</anchor>
      <arglist>(const cc_rbptree *t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_rbptree_traverse</name>
      <anchorfile>rbptree_8h.html</anchorfile>
      <anchor>abf647ec6e901c359427cf7c868ca9db0</anchor>
      <arglist>(const cc_rbptree *t, cc_rbptree_traversecb *func, void *closure)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_rbptree_debug</name>
      <anchorfile>rbptree_8h.html</anchorfile>
      <anchor>aaea2989fd3afd6b7cf29e7407a544c00</anchor>
      <arglist>(const cc_rbptree *t)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>recmutex.h</name>
    <path>/build/coin/src/coin/include/Inventor/C/threads/</path>
    <filename>recmutex_8h</filename>
    <includes id="common_8h" name="common.h" local="no" imported="no">Inventor/C/threads/common.h</includes>
    <member kind="function">
      <type>cc_recmutex *</type>
      <name>cc_recmutex_construct</name>
      <anchorfile>recmutex_8h.html</anchorfile>
      <anchor>ac104959a6bd31cca7d271fb1a90145d0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_recmutex_destruct</name>
      <anchorfile>recmutex_8h.html</anchorfile>
      <anchor>ad2cbeae6e909c185748ffe0a62daf7f1</anchor>
      <arglist>(cc_recmutex *recmutex)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_recmutex_lock</name>
      <anchorfile>recmutex_8h.html</anchorfile>
      <anchor>a236f7a2dbc904f55231186cbde2828f0</anchor>
      <arglist>(cc_recmutex *recmutex)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_recmutex_unlock</name>
      <anchorfile>recmutex_8h.html</anchorfile>
      <anchor>ac19c670433c86270d18513b35bc186c4</anchor>
      <arglist>(cc_recmutex *recmutex)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_recmutex_try_lock</name>
      <anchorfile>recmutex_8h.html</anchorfile>
      <anchor>aa6b36adf80a064ce584f0474bc3cfb91</anchor>
      <arglist>(cc_recmutex *recmutex)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>rwmutex.h</name>
    <path>/build/coin/src/coin/include/Inventor/C/threads/</path>
    <filename>rwmutex_8h</filename>
    <includes id="common_8h" name="common.h" local="no" imported="no">Inventor/C/threads/common.h</includes>
    <member kind="function">
      <type>cc_rwmutex *</type>
      <name>cc_rwmutex_construct</name>
      <anchorfile>rwmutex_8h.html</anchorfile>
      <anchor>af66434284d47f7ec42a2e3e039c7ab3f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>cc_rwmutex *</type>
      <name>cc_rwmutex_construct_etc</name>
      <anchorfile>rwmutex_8h.html</anchorfile>
      <anchor>a77b0f32aa4a12f3b96417f689e4d6fe1</anchor>
      <arglist>(cc_precedence policy)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_rwmutex_destruct</name>
      <anchorfile>rwmutex_8h.html</anchorfile>
      <anchor>a00629d8116bd7783e5fcd94bc790aee8</anchor>
      <arglist>(cc_rwmutex *rwmutex)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_rwmutex_write_lock</name>
      <anchorfile>rwmutex_8h.html</anchorfile>
      <anchor>a6d095f0878e5ab4a7baf55d20e13c6a9</anchor>
      <arglist>(cc_rwmutex *rwmutex)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_rwmutex_write_try_lock</name>
      <anchorfile>rwmutex_8h.html</anchorfile>
      <anchor>a4276fa164bdddde7ab8a589145879398</anchor>
      <arglist>(cc_rwmutex *rwmutex)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_rwmutex_write_unlock</name>
      <anchorfile>rwmutex_8h.html</anchorfile>
      <anchor>ac42b9d7e4dc8fb6bab15cfc335f6356a</anchor>
      <arglist>(cc_rwmutex *rwmutex)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_rwmutex_read_lock</name>
      <anchorfile>rwmutex_8h.html</anchorfile>
      <anchor>abd167fb3395d37f0ccbd6e17c5a91c13</anchor>
      <arglist>(cc_rwmutex *rwmutex)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_rwmutex_read_try_lock</name>
      <anchorfile>rwmutex_8h.html</anchorfile>
      <anchor>a29505e11963df28bd489b008e9cac00f</anchor>
      <arglist>(cc_rwmutex *rwmutex)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_rwmutex_read_unlock</name>
      <anchorfile>rwmutex_8h.html</anchorfile>
      <anchor>abaf5ab58f3d51204ea8bc2bf0bd18f9e</anchor>
      <arglist>(cc_rwmutex *rwmutex)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SbClip.h</name>
    <path>/build/coin/src/coin/include/Inventor/</path>
    <filename>SbClip_8h</filename>
    <class kind="class">SbClip</class>
    <member kind="typedef">
      <type>void *</type>
      <name>SbClipCallback</name>
      <anchorfile>SbClip_8h.html</anchorfile>
      <anchor>a7b99637988652ddb53ced29ce010e18e</anchor>
      <arglist>(const SbVec3f &amp;v0, void *vdata0, const SbVec3f &amp;v1, void *vdata1, const SbVec3f &amp;newvertex, void *userdata)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SbDict.h</name>
    <path>/build/coin/src/coin/include/Inventor/</path>
    <filename>SbDict_8h</filename>
    <class kind="class">SbDict</class>
    <member kind="typedef">
      <type>uintptr_t</type>
      <name>SbDictKeyType</name>
      <anchorfile>SbDict_8h.html</anchorfile>
      <anchor>acb82d07bb08c0b99aaf953617f4212fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>void</type>
      <name>SbDictApplyFunc</name>
      <anchorfile>SbDict_8h.html</anchorfile>
      <anchor>aff41e28ec4b46527fe4c91be4616eca9</anchor>
      <arglist>(SbDictKeyType key, void *value)</arglist>
    </member>
    <member kind="typedef">
      <type>void</type>
      <name>SbDictApplyDataFunc</name>
      <anchorfile>SbDict_8h.html</anchorfile>
      <anchor>a42154327d573d825af27f7b67e82846c</anchor>
      <arglist>(SbDictKeyType key, void *value, void *data)</arglist>
    </member>
    <member kind="typedef">
      <type>SbDictKeyType</type>
      <name>SbDictHashingFunc</name>
      <anchorfile>SbDict_8h.html</anchorfile>
      <anchor>a68895d232bbc01b1edc40809de2db5d6</anchor>
      <arglist>(const SbDictKeyType key)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SbImage.h</name>
    <path>/build/coin/src/coin/include/Inventor/</path>
    <filename>SbImage_8h</filename>
    <class kind="class">SbImage</class>
    <member kind="typedef">
      <type>SbBool</type>
      <name>SbImageScheduleReadCB</name>
      <anchorfile>SbImage_8h.html</anchorfile>
      <anchor>aec75901f7cf7231e18a9319c8c93027d</anchor>
      <arglist>(const SbString &amp;, SbImage *, void *)</arglist>
    </member>
    <member kind="typedef">
      <type>SbBool</type>
      <name>SbImageReadImageCB</name>
      <anchorfile>SbImage_8h.html</anchorfile>
      <anchor>a749e25189202ba72003c04cc9e591045</anchor>
      <arglist>(const SbString &amp;, SbImage *, void *)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SbProfilingData.h</name>
    <path>/build/coin/src/coin/include/Inventor/annex/Profiler/</path>
    <filename>SbProfilingData_8h</filename>
    <includes id="SoType_8h" name="SoType.h" local="no" imported="no">Inventor/SoType.h</includes>
    <class kind="class">SbProfilingData</class>
    <member kind="typedef">
      <type>void *</type>
      <name>SbProfilingNodeKey</name>
      <anchorfile>SbProfilingData_8h.html</anchorfile>
      <anchor>ab504be724d5409b88c9735f92c9d2e60</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int16_t</type>
      <name>SbProfilingNodeTypeKey</name>
      <anchorfile>SbProfilingData_8h.html</anchorfile>
      <anchor>a050c3662b04c5000d45cfcf792ce40db</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>const char *</type>
      <name>SbProfilingNodeNameKey</name>
      <anchorfile>SbProfilingData_8h.html</anchorfile>
      <anchor>a766ecc81c4a94c10db9f1282a9eaeb4f</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SbTesselator.h</name>
    <path>/build/coin/src/coin/include/Inventor/</path>
    <filename>SbTesselator_8h</filename>
    <class kind="class">SbTesselator</class>
    <member kind="typedef">
      <type>void</type>
      <name>SbTesselatorCB</name>
      <anchorfile>SbTesselator_8h.html</anchorfile>
      <anchor>a7f7d2fcfc589decba0aab9eb3f253b90</anchor>
      <arglist>(void *v0, void *v1, void *v2, void *data)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>sched.h</name>
    <path>/build/coin/src/coin/include/Inventor/C/threads/</path>
    <filename>sched_8h</filename>
    <includes id="common_8h" name="common.h" local="no" imported="no">Inventor/C/threads/common.h</includes>
    <member kind="typedef">
      <type>void</type>
      <name>cc_sched_f</name>
      <anchorfile>sched_8h.html</anchorfile>
      <anchor>a76544dc5c498d7b827403cb313051dab</anchor>
      <arglist>(void *closure)</arglist>
    </member>
    <member kind="function">
      <type>cc_sched *</type>
      <name>cc_sched_construct</name>
      <anchorfile>sched_8h.html</anchorfile>
      <anchor>aa6708ee2026420e559ebfac7a59ffa18</anchor>
      <arglist>(int numthreads)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_sched_destruct</name>
      <anchorfile>sched_8h.html</anchorfile>
      <anchor>ad3970d66c72d7c3600a4512a0e6f10ac</anchor>
      <arglist>(cc_sched *sched)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_sched_set_num_threads</name>
      <anchorfile>sched_8h.html</anchorfile>
      <anchor>aa32ed8dd1ca6f5d31f6c177c919827d9</anchor>
      <arglist>(cc_sched *sched, int num)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_sched_get_num_threads</name>
      <anchorfile>sched_8h.html</anchorfile>
      <anchor>a9727b730645317fc320923e756a675c9</anchor>
      <arglist>(cc_sched *sched)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>cc_sched_schedule</name>
      <anchorfile>sched_8h.html</anchorfile>
      <anchor>a6fdaca4dd411f6baf4b6635f7879064b</anchor>
      <arglist>(cc_sched *sched, cc_sched_f *workfunc, void *closure, float priority)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_sched_unschedule</name>
      <anchorfile>sched_8h.html</anchorfile>
      <anchor>a7675245f822e5d88c1b2a38766aa794c</anchor>
      <arglist>(cc_sched *sched, uint32_t schedid)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_sched_wait_all</name>
      <anchorfile>sched_8h.html</anchorfile>
      <anchor>af37556dd26772e72f650f3378bf99ffd</anchor>
      <arglist>(cc_sched *sched)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_sched_get_num_remaining</name>
      <anchorfile>sched_8h.html</anchorfile>
      <anchor>a9c269e9d5c97530f4a5b51df5272c776</anchor>
      <arglist>(cc_sched *sched)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_sched_set_num_allowed</name>
      <anchorfile>sched_8h.html</anchorfile>
      <anchor>ab32995a3067e56acbd21b362ca9be7d2</anchor>
      <arglist>(cc_sched *sched, int num)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_sched_change_priority</name>
      <anchorfile>sched_8h.html</anchorfile>
      <anchor>ae0a097a0cd951009b75dd7be2c16871d</anchor>
      <arglist>(cc_sched *sched, uint32_t schedid, float priority)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>ScXMLStateMachine.h</name>
    <path>/build/coin/src/coin/include/Inventor/scxml/</path>
    <filename>ScXMLStateMachine_8h</filename>
    <class kind="class">ScXMLStateMachine</class>
    <member kind="typedef">
      <type>void</type>
      <name>ScXMLStateMachineDeleteCB</name>
      <anchorfile>ScXMLStateMachine_8h.html</anchorfile>
      <anchor>ae034fd3855c0742ad9ee1cf922ae9a93</anchor>
      <arglist>(void *userdata, ScXMLStateMachine *statemachine)</arglist>
    </member>
    <member kind="typedef">
      <type>void</type>
      <name>ScXMLStateChangeCB</name>
      <anchorfile>ScXMLStateMachine_8h.html</anchorfile>
      <anchor>a382ec530b26743dc815f7cb832ce00a4</anchor>
      <arglist>(void *userdata, ScXMLStateMachine *statemachine, const char *stateidentifier, SbBool enterstate, SbBool success)</arglist>
    </member>
    <member kind="typedef">
      <type>void</type>
      <name>ScXMLParallelStateChangeCB</name>
      <anchorfile>ScXMLStateMachine_8h.html</anchorfile>
      <anchor>abb78f2e452e7fe8ca2587c25c15097cf</anchor>
      <arglist>(void *userdata, ScXMLStateMachine *statemachine, int numstates, const char **stateidentifiers, SbBool enterstate, SbBool success)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoActionMethodList.h</name>
    <path>/build/coin/src/coin/include/Inventor/lists/</path>
    <filename>SoActionMethodList_8h</filename>
    <includes id="SoType_8h" name="SoType.h" local="no" imported="no">Inventor/SoType.h</includes>
    <class kind="class">SoActionMethodList</class>
    <member kind="typedef">
      <type>void(*</type>
      <name>SoActionMethod</name>
      <anchorfile>SoActionMethodList_8h.html</anchorfile>
      <anchor>a20da48d2b340cf58ff0fca763fcf1577</anchor>
      <arglist>)(SoAction *, SoNode *)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoCallback.h</name>
    <path>/build/coin/src/coin/include/Inventor/nodes/</path>
    <filename>SoCallback_8h</filename>
    <class kind="class">SoCallback</class>
    <member kind="typedef">
      <type>void</type>
      <name>SoCallbackCB</name>
      <anchorfile>SoCallback_8h.html</anchorfile>
      <anchor>ad9451945b593767f377104fab4bb2035</anchor>
      <arglist>(void *userdata, SoAction *action)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoCallbackAction.h</name>
    <path>/build/coin/src/coin/include/Inventor/actions/</path>
    <filename>SoCallbackAction_8h</filename>
    <class kind="class">SoCallbackAction</class>
    <member kind="typedef">
      <type>void</type>
      <name>SoTriangleCB</name>
      <anchorfile>SoCallbackAction_8h.html</anchorfile>
      <anchor>a38c75c113e2ddebb11872737e22de036</anchor>
      <arglist>(void *userdata, SoCallbackAction *action, const SoPrimitiveVertex *v1, const SoPrimitiveVertex *v2, const SoPrimitiveVertex *v3)</arglist>
    </member>
    <member kind="typedef">
      <type>void</type>
      <name>SoLineSegmentCB</name>
      <anchorfile>SoCallbackAction_8h.html</anchorfile>
      <anchor>a6e4ebc8a54b96078d4a70b552d8a1f86</anchor>
      <arglist>(void *userdata, SoCallbackAction *action, const SoPrimitiveVertex *v1, const SoPrimitiveVertex *v2)</arglist>
    </member>
    <member kind="typedef">
      <type>void</type>
      <name>SoPointCB</name>
      <anchorfile>SoCallbackAction_8h.html</anchorfile>
      <anchor>a404627c51c9d7daaae5351ca11fd815d</anchor>
      <arglist>(void *userdata, SoCallbackAction *action, const SoPrimitiveVertex *v)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>lists/SoCallbackList.h</name>
    <path>/build/coin/src/coin/include/Inventor/lists/</path>
    <filename>lists_2SoCallbackList_8h</filename>
    <class kind="class">SoCallbackList</class>
    <member kind="typedef">
      <type>void</type>
      <name>SoCallbackListCB</name>
      <anchorfile>lists_2SoCallbackList_8h.html</anchorfile>
      <anchor>af2e448a2584c8740fc2735ec3972c49e</anchor>
      <arglist>(void *userdata, void *callbackdata)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoContextHandler.h</name>
    <path>/build/coin/src/coin/include/Inventor/misc/</path>
    <filename>SoContextHandler_8h</filename>
    <class kind="class">SoContextHandler</class>
  </compound>
  <compound kind="file">
    <name>SoDB.h</name>
    <path>/build/coin/src/coin/include/Inventor/</path>
    <filename>SoDB_8h</filename>
    <includes id="SoType_8h" name="SoType.h" local="no" imported="no">Inventor/SoType.h</includes>
    <class kind="class">SoDB</class>
    <member kind="typedef">
      <type>void</type>
      <name>SoDBHeaderCB</name>
      <anchorfile>SoDB_8h.html</anchorfile>
      <anchor>adfef9190f2aba6f35abf08374dffc68a</anchor>
      <arglist>(void *data, SoInput *input)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoDragger.h</name>
    <path>/build/coin/src/coin/include/Inventor/draggers/</path>
    <filename>SoDragger_8h</filename>
    <includes id="lists_2SoCallbackList_8h" name="lists/SoCallbackList.h" local="no" imported="no">Inventor/lists/SoCallbackList.h</includes>
    <class kind="class">SoDragger</class>
    <member kind="typedef">
      <type>void</type>
      <name>SoDraggerCB</name>
      <anchorfile>SoDragger_8h.html</anchorfile>
      <anchor>aee66fa82a01dba5b1b7b72c13cec68fc</anchor>
      <arglist>(void *data, SoDragger *dragger)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoEventCallback.h</name>
    <path>/build/coin/src/coin/include/Inventor/nodes/</path>
    <filename>SoEventCallback_8h</filename>
    <class kind="class">SoEventCallback</class>
    <member kind="typedef">
      <type>void</type>
      <name>SoEventCallbackCB</name>
      <anchorfile>SoEventCallback_8h.html</anchorfile>
      <anchor>a6e0dbb53c95cc1225c031e027c7bc7b1</anchor>
      <arglist>(void *userdata, SoEventCallback *node)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoExtSelection.h</name>
    <path>/build/coin/src/coin/include/Inventor/nodes/</path>
    <filename>SoExtSelection_8h</filename>
    <includes id="SoSelection_8h" name="SoSelection.h" local="no" imported="no">Inventor/nodes/SoSelection.h</includes>
    <includes id="SoCallbackAction_8h" name="SoCallbackAction.h" local="no" imported="no">Inventor/actions/SoCallbackAction.h</includes>
    <class kind="class">SoExtSelection</class>
  </compound>
  <compound kind="file">
    <name>SoForeignFileKit.h</name>
    <path>/build/coin/src/coin/include/Inventor/annex/ForeignFiles/</path>
    <filename>SoForeignFileKit_8h</filename>
    <class kind="class">SoForeignFileKit</class>
  </compound>
  <compound kind="file">
    <name>SoGLCacheContextElement.h</name>
    <path>/build/coin/src/coin/include/Inventor/elements/</path>
    <filename>SoGLCacheContextElement_8h</filename>
    <class kind="class">SoGLCacheContextElement</class>
  </compound>
  <compound kind="file">
    <name>SoGLImage.h</name>
    <path>/build/coin/src/coin/include/Inventor/misc/</path>
    <filename>SoGLImage_8h</filename>
    <includes id="SoType_8h" name="SoType.h" local="no" imported="no">Inventor/SoType.h</includes>
    <class kind="class">SoGLImage</class>
  </compound>
  <compound kind="file">
    <name>SoGLMultiTextureCoordinateElement.h</name>
    <path>/build/coin/src/coin/include/Inventor/elements/</path>
    <filename>SoGLMultiTextureCoordinateElement_8h</filename>
    <includes id="SoMultiTextureCoordinateElement_8h" name="SoMultiTextureCoordinateElement.h" local="no" imported="no">Inventor/elements/SoMultiTextureCoordinateElement.h</includes>
    <class kind="class">SoGLMultiTextureCoordinateElement</class>
    <class kind="class">SoGLMultiTextureCoordinateElement::GLUnitData</class>
  </compound>
  <compound kind="file">
    <name>SoGLRenderAction.h</name>
    <path>/build/coin/src/coin/include/Inventor/actions/</path>
    <filename>SoGLRenderAction_8h</filename>
    <class kind="class">SoGLRenderAction</class>
    <member kind="typedef">
      <type>void</type>
      <name>SoGLRenderPassCB</name>
      <anchorfile>SoGLRenderAction_8h.html</anchorfile>
      <anchor>a53d49957c78db1408e769922d160cc0d</anchor>
      <arglist>(void *userdata)</arglist>
    </member>
    <member kind="typedef">
      <type>float</type>
      <name>SoGLSortedObjectOrderCB</name>
      <anchorfile>SoGLRenderAction_8h.html</anchorfile>
      <anchor>a4ad9050a0255e669ec9714b2ae789d24</anchor>
      <arglist>(void *userdata, SoGLRenderAction *action)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoIntersectionDetectionAction.h</name>
    <path>/build/coin/src/coin/include/Inventor/collision/</path>
    <filename>SoIntersectionDetectionAction_8h</filename>
    <includes id="SoCallbackAction_8h" name="SoCallbackAction.h" local="no" imported="no">Inventor/actions/SoCallbackAction.h</includes>
    <class kind="struct">SoIntersectingPrimitive</class>
    <class kind="class">SoIntersectionDetectionAction</class>
  </compound>
  <compound kind="file">
    <name>SoMultiTextureCoordinateElement.h</name>
    <path>/build/coin/src/coin/include/Inventor/elements/</path>
    <filename>SoMultiTextureCoordinateElement_8h</filename>
    <class kind="class">SoMultiTextureCoordinateElement</class>
    <class kind="class">SoMultiTextureCoordinateElement::UnitData</class>
  </compound>
  <compound kind="file">
    <name>SoOutput.h</name>
    <path>/build/coin/src/coin/include/Inventor/</path>
    <filename>SoOutput_8h</filename>
    <class kind="class">SoOutput</class>
  </compound>
  <compound kind="file">
    <name>SoProfilingReportGenerator.h</name>
    <path>/build/coin/src/coin/include/Inventor/annex/Profiler/utils/</path>
    <filename>SoProfilingReportGenerator_8h</filename>
    <class kind="class">SoProfilingReportGenerator</class>
  </compound>
  <compound kind="file">
    <name>SoProto.h</name>
    <path>/build/coin/src/coin/include/Inventor/misc/</path>
    <filename>SoProto_8h</filename>
    <class kind="class">SoProto</class>
  </compound>
  <compound kind="file">
    <name>SoRenderManager.h</name>
    <path>/build/coin/src/coin/include/Inventor/</path>
    <filename>SoRenderManager_8h</filename>
    <includes id="SoGLRenderAction_8h" name="SoGLRenderAction.h" local="no" imported="no">Inventor/actions/SoGLRenderAction.h</includes>
    <class kind="class">SoRenderManager</class>
    <class kind="class">SoRenderManager::Superimposition</class>
  </compound>
  <compound kind="file">
    <name>SoSceneManager.h</name>
    <path>/build/coin/src/coin/include/Inventor/</path>
    <filename>SoSceneManager_8h</filename>
    <class kind="class">SoSceneManager</class>
    <member kind="typedef">
      <type>void</type>
      <name>SoSceneManagerRenderCB</name>
      <anchorfile>SoSceneManager_8h.html</anchorfile>
      <anchor>abada319f5f2375442afabf9d7d61e726</anchor>
      <arglist>(void *userdata, class SoSceneManager *mgr)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoScXMLNavigationTarget.h</name>
    <path>/build/coin/src/coin/include/Inventor/navigation/</path>
    <filename>SoScXMLNavigationTarget_8h</filename>
    <class kind="class">SoScXMLNavigationTarget</class>
    <class kind="class">SoScXMLNavigationTarget::Data</class>
  </compound>
  <compound kind="file">
    <name>SoSelection.h</name>
    <path>/build/coin/src/coin/include/Inventor/nodes/</path>
    <filename>SoSelection_8h</filename>
    <class kind="class">SoSelection</class>
    <member kind="typedef">
      <type>SoPath *</type>
      <name>SoSelectionPickCB</name>
      <anchorfile>SoSelection_8h.html</anchorfile>
      <anchor>abdc320e66f9b345540a490491c618ecb</anchor>
      <arglist>(void *data, const SoPickedPoint *pick)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoSensor.h</name>
    <path>/build/coin/src/coin/include/Inventor/sensors/</path>
    <filename>SoSensor_8h</filename>
    <class kind="class">SoSensor</class>
    <member kind="typedef">
      <type>void</type>
      <name>SoSensorCB</name>
      <anchorfile>SoSensor_8h.html</anchorfile>
      <anchor>a0e20257319c3430fe1cee699ef6e3420</anchor>
      <arglist>(void *data, SoSensor *sensor)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoShaderProgram.h</name>
    <path>/build/coin/src/coin/include/Inventor/nodes/</path>
    <filename>SoShaderProgram_8h</filename>
    <class kind="class">SoShaderProgram</class>
  </compound>
  <compound kind="file">
    <name>SoType.h</name>
    <path>/build/coin/src/coin/include/Inventor/</path>
    <filename>SoType_8h</filename>
    <includes id="SbDict_8h" name="SbDict.h" local="no" imported="no">Inventor/SbDict.h</includes>
    <class kind="class">SbList</class>
    <class kind="class">SoType</class>
  </compound>
  <compound kind="file">
    <name>SoVertexAttributeElement.h</name>
    <path>/build/coin/src/coin/include/Inventor/elements/</path>
    <filename>SoVertexAttributeElement_8h</filename>
    <class kind="class">SoVertexAttributeElement</class>
  </compound>
  <compound kind="file">
    <name>SoVRMLAnchor.h</name>
    <path>/build/coin/src/coin/include/Inventor/VRMLnodes/</path>
    <filename>SoVRMLAnchor_8h</filename>
    <class kind="class">SoVRMLAnchor</class>
  </compound>
  <compound kind="file">
    <name>SoVRMLAudioClip.h</name>
    <path>/build/coin/src/coin/include/Inventor/VRMLnodes/</path>
    <filename>SoVRMLAudioClip_8h</filename>
    <class kind="class">SoVRMLAudioClip</class>
  </compound>
  <compound kind="file">
    <name>SoVRMLImageTexture.h</name>
    <path>/build/coin/src/coin/include/Inventor/VRMLnodes/</path>
    <filename>SoVRMLImageTexture_8h</filename>
    <includes id="SbImage_8h" name="SbImage.h" local="no" imported="no">Inventor/SbImage.h</includes>
    <class kind="class">SoVRMLImageTexture</class>
  </compound>
  <compound kind="file">
    <name>SoVRMLInline.h</name>
    <path>/build/coin/src/coin/include/Inventor/VRMLnodes/</path>
    <filename>SoVRMLInline_8h</filename>
    <includes id="SoCallbackAction_8h" name="SoCallbackAction.h" local="no" imported="no">Inventor/actions/SoCallbackAction.h</includes>
    <class kind="class">SoVRMLInline</class>
  </compound>
  <compound kind="file">
    <name>SoVRMLScript.h</name>
    <path>/build/coin/src/coin/include/Inventor/VRMLnodes/</path>
    <filename>SoVRMLScript_8h</filename>
    <class kind="class">SoVRMLScript</class>
  </compound>
  <compound kind="file">
    <name>SoWWWAnchor.h</name>
    <path>/build/coin/src/coin/include/Inventor/nodes/</path>
    <filename>SoWWWAnchor_8h</filename>
    <class kind="class">SoWWWAnchor</class>
  </compound>
  <compound kind="file">
    <name>SoWWWInline.h</name>
    <path>/build/coin/src/coin/include/Inventor/nodes/</path>
    <filename>SoWWWInline_8h</filename>
    <includes id="SoCallbackAction_8h" name="SoCallbackAction.h" local="no" imported="no">Inventor/actions/SoCallbackAction.h</includes>
    <class kind="class">SoWWWInline</class>
  </compound>
  <compound kind="file">
    <name>spidermonkey.h</name>
    <path>/build/coin/src/coin/include/Inventor/C/glue/</path>
    <filename>spidermonkey_8h</filename>
    <class kind="struct">JSIdArray</class>
    <class kind="struct">JSClass</class>
    <class kind="struct">JSPropertySpec</class>
    <class kind="struct">JSFunctionSpec</class>
    <class kind="struct">JSErrorReport</class>
    <class kind="struct">SpiderMonkey_t</class>
  </compound>
  <compound kind="file">
    <name>storage.h</name>
    <path>/build/coin/src/coin/include/Inventor/C/threads/</path>
    <filename>storage_8h</filename>
    <includes id="common_8h" name="common.h" local="no" imported="no">Inventor/C/threads/common.h</includes>
  </compound>
  <compound kind="file">
    <name>string.h</name>
    <path>/build/coin/src/coin/include/Inventor/C/base/</path>
    <filename>string_8h</filename>
    <class kind="struct">cc_string</class>
  </compound>
  <compound kind="file">
    <name>thread.h</name>
    <path>/build/coin/src/coin/include/Inventor/C/threads/</path>
    <filename>thread_8h</filename>
    <includes id="common_8h" name="common.h" local="no" imported="no">Inventor/C/threads/common.h</includes>
  </compound>
  <compound kind="file">
    <name>tidbits.h</name>
    <path>/build/coin/src/coin/include/Inventor/C/</path>
    <filename>tidbits_8h</filename>
    <member kind="function">
      <type>void</type>
      <name>cc_coin_atexit_static_internal</name>
      <anchorfile>tidbits_8h.html</anchorfile>
      <anchor>a543c2c5b6e2507250ab773f1838105ec</anchor>
      <arglist>(coin_atexit_f *fp)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>worker.h</name>
    <path>/build/coin/src/coin/include/Inventor/C/threads/</path>
    <filename>worker_8h</filename>
    <includes id="common_8h" name="common.h" local="no" imported="no">Inventor/C/threads/common.h</includes>
    <member kind="function">
      <type>void</type>
      <name>cc_worker_destruct</name>
      <anchorfile>worker_8h.html</anchorfile>
      <anchor>abab35ee0bc4d8daa85f92e543c1282fd</anchor>
      <arglist>(cc_worker *worker)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_worker_start</name>
      <anchorfile>worker_8h.html</anchorfile>
      <anchor>ac5c05ca84a6b98e22b80c92e4c483f3e</anchor>
      <arglist>(cc_worker *worker, cc_worker_f *workfunc, void *closure)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>wpool.h</name>
    <path>/build/coin/src/coin/include/Inventor/C/threads/</path>
    <filename>wpool_8h</filename>
    <includes id="common_8h" name="common.h" local="no" imported="no">Inventor/C/threads/common.h</includes>
    <member kind="function">
      <type>cc_wpool *</type>
      <name>cc_wpool_construct</name>
      <anchorfile>wpool_8h.html</anchorfile>
      <anchor>a9550e19fd66501b2d8f04ae3d1567e0d</anchor>
      <arglist>(int numworkers)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_wpool_destruct</name>
      <anchorfile>wpool_8h.html</anchorfile>
      <anchor>a3a88eb052e62c806ad1ba3baa7a9a267</anchor>
      <arglist>(cc_wpool *pool)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_wpool_get_num_workers</name>
      <anchorfile>wpool_8h.html</anchorfile>
      <anchor>a4dcdd6841fcde116c5db4110512ac349</anchor>
      <arglist>(cc_wpool *pool)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_wpool_set_num_workers</name>
      <anchorfile>wpool_8h.html</anchorfile>
      <anchor>aa8dd9d5e8efbbd3bfc6868437eb1dde1</anchor>
      <arglist>(cc_wpool *pool, int newnum)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_wpool_wait_all</name>
      <anchorfile>wpool_8h.html</anchorfile>
      <anchor>aa72a4d47ebc25bde285eda7e92ab1d60</anchor>
      <arglist>(cc_wpool *pool)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_wpool_try_begin</name>
      <anchorfile>wpool_8h.html</anchorfile>
      <anchor>a124e8b13ad6d891464464faf1dc06720</anchor>
      <arglist>(cc_wpool *pool, int numworkersneeded)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_wpool_begin</name>
      <anchorfile>wpool_8h.html</anchorfile>
      <anchor>af74a596c25276cf64940945ced3e1aac</anchor>
      <arglist>(cc_wpool *pool, int numworkersneeded)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_wpool_start_worker</name>
      <anchorfile>wpool_8h.html</anchorfile>
      <anchor>ab6520bc3ada9718920816fda16fe345f</anchor>
      <arglist>(cc_wpool *pool, cc_wpool_f *workfunc, void *closure)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_wpool_end</name>
      <anchorfile>wpool_8h.html</anchorfile>
      <anchor>aee918e25fac8bb394789c70c3501a522</anchor>
      <arglist>(cc_wpool *pool)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>cc_debugerror</name>
    <filename>structcc__debugerror.html</filename>
  </compound>
  <compound kind="struct">
    <name>cc_error</name>
    <filename>structcc__error.html</filename>
  </compound>
  <compound kind="struct">
    <name>cc_glglue_offscreen_cb_functions</name>
    <filename>structcc__glglue__offscreen__cb__functions.html</filename>
  </compound>
  <compound kind="struct">
    <name>cc_rbptree</name>
    <filename>structcc__rbptree.html</filename>
  </compound>
  <compound kind="struct">
    <name>cc_string</name>
    <filename>structcc__string.html</filename>
  </compound>
  <compound kind="struct">
    <name>SoLazyElement::CoinState</name>
    <filename>structSoLazyElement_1_1CoinState.html</filename>
  </compound>
  <compound kind="class">
    <name>SoScXMLNavigationTarget::Data</name>
    <filename>classSoScXMLNavigationTarget_1_1Data.html</filename>
  </compound>
  <compound kind="struct">
    <name>SoGLLazyElement::GLState</name>
    <filename>structSoGLLazyElement_1_1GLState.html</filename>
  </compound>
  <compound kind="class">
    <name>SoGLMultiTextureImageElement::GLUnitData</name>
    <filename>classSoGLMultiTextureImageElement_1_1GLUnitData.html</filename>
  </compound>
  <compound kind="class">
    <name>SoGLMultiTextureCoordinateElement::GLUnitData</name>
    <filename>classSoGLMultiTextureCoordinateElement_1_1GLUnitData.html</filename>
  </compound>
  <compound kind="struct">
    <name>JSClass</name>
    <filename>structJSClass.html</filename>
  </compound>
  <compound kind="struct">
    <name>JSErrorReport</name>
    <filename>structJSErrorReport.html</filename>
  </compound>
  <compound kind="struct">
    <name>JSFunctionSpec</name>
    <filename>structJSFunctionSpec.html</filename>
  </compound>
  <compound kind="struct">
    <name>JSIdArray</name>
    <filename>structJSIdArray.html</filename>
  </compound>
  <compound kind="struct">
    <name>JSPropertySpec</name>
    <filename>structJSPropertySpec.html</filename>
  </compound>
  <compound kind="class">
    <name>SbBarrier</name>
    <filename>classSbBarrier.html</filename>
  </compound>
  <compound kind="class">
    <name>SbBox2d</name>
    <filename>classSbBox2d.html</filename>
    <member kind="function">
      <type></type>
      <name>SbBox2d</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>ab5d433a13b536b2935830e6e0e81bbcf</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox2d</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>ab35a9df21fe541e6d26f1d9bdb18001b</anchor>
      <arglist>(double xmin, double ymin, double xmax, double ymax)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox2d</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a47551f0655643ba2556d56dc137e2aa3</anchor>
      <arglist>(const SbVec2d &amp;minpoint, const SbVec2d &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2d &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>ac95c2f308fed44c6bb399e61a50a9f70</anchor>
      <arglist>(double xmin, double ymin, double xmax, double ymax)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2d &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a28504f92d8e1af08da2f841883b8a839</anchor>
      <arglist>(const SbVec2d &amp;minpoint, const SbVec2d &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2d &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a9911fcb3302faad2b6778a20bc7f2509</anchor>
      <arglist>(const SbBox2f &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2d &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a2c86872d0aea6b849904f1714174f307</anchor>
      <arglist>(const SbBox2s &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2d &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a52d1f9128dd2d5068b936f0dfbeee3a8</anchor>
      <arglist>(const SbBox2i32 &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a70e9741dc9576ef036330cec59372b73</anchor>
      <arglist>(double &amp;xmin, double &amp;ymin, double &amp;xmax, double &amp;ymax) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a39ba783506710d2a7bc556ae9026e912</anchor>
      <arglist>(SbVec2d &amp;minpoint, SbVec2d &amp;maxpoint) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec2d &amp;</type>
      <name>getMin</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>aa22176ba758441eb0c2ab2bd1908bd8a</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>getMin</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a68745130b47973a8cbb4c96d6bb75035</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SbVec2d &amp;</type>
      <name>getMax</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a7d7cfacbd386b69afa85ff4e4e5e45c2</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>getMax</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a136376a27439d712e88e3624a6e5b70c</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a579b3a3ce2297998dda39f036ad1caf3</anchor>
      <arglist>(const SbVec2d &amp;point)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>aeab99592f3ed491da6ea1e23ea1b94e7</anchor>
      <arglist>(const SbBox2d &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeEmpty</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a61a1cb11326fc2a0a4d16a0851fdbda5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isEmpty</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a078627a91962bc8eb5d91ef1f7ca2d0d</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>hasArea</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>ae1cb3389cfa0cc3334975ebb9c9a42f4</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a42fab3a8f097d70919893bf4015688b1</anchor>
      <arglist>(const SbVec2d &amp;point) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>ae9fd30808378f8be4aefc058d125e366</anchor>
      <arglist>(const SbBox2d &amp;box) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d</type>
      <name>getClosestPoint</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>af4e49b61d27778544e7e714aa78e1094</anchor>
      <arglist>(const SbVec2d &amp;p) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>findIntersection</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>afbaafeded01e7ed557dce4c19de90770</anchor>
      <arglist>(const SbVec2d &amp;a, const SbVec2d &amp;b, SbVec2d &amp;ia, SbVec2d &amp;ib) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d</type>
      <name>getCenter</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>aa91a42154888f6a368a729b005d18a94</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getOrigin</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a78988e26894b58fd586daeb3990c9ccc</anchor>
      <arglist>(double &amp;originX, double &amp;originY) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getSize</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a53a8d643488cea26386124a1207c2445</anchor>
      <arglist>(double &amp;sizeX, double &amp;sizeY) const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getAspectRatio</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a639c88a9b465785252065eed5f1d75b5</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>ab6de355aab03179a741038c6856378bd</anchor>
      <arglist>(const SbBox2d &amp;b1, const SbBox2d &amp;b2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator !=</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a0560f0fa6b9aa86a197a8aed397df753</anchor>
      <arglist>(const SbBox2d &amp;b1, const SbBox2d &amp;b2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbBox2f</name>
    <filename>classSbBox2f.html</filename>
    <member kind="function">
      <type></type>
      <name>SbBox2f</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>af60e9222058dbdcd867cbb048c721b03</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox2f</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a488cf3016af1093b2189a19cc9087fc6</anchor>
      <arglist>(float xmin, float ymin, float xmax, float ymax)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox2f</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a9ec2e3cb95df5dbcf3f331aed736f1b7</anchor>
      <arglist>(const SbVec2f &amp;minpoint, const SbVec2f &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2f &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a36c09cc65b4a63013bc31dea68a7b6e1</anchor>
      <arglist>(float xmin, float ymin, float xmax, float ymax)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2f &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>af3a9b1d9fd5ff0af88a6a77f44e00878</anchor>
      <arglist>(const SbVec2f &amp;minpoint, const SbVec2f &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2f &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>af4abc503bb458358536c5b4e5454bd85</anchor>
      <arglist>(const SbBox2d &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2f &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a95232a587c8a3c42c4d0c128f7582a01</anchor>
      <arglist>(const SbBox2s &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2f &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>ad97a22a8df3411c4bdbb267aaa41da78</anchor>
      <arglist>(const SbBox2i32 &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>abcb117bc390a89fbc5ca1a683275dc15</anchor>
      <arglist>(float &amp;xmin, float &amp;ymin, float &amp;xmax, float &amp;ymax) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a5cd15fa629ff67122462dcaf9c93d8f3</anchor>
      <arglist>(SbVec2f &amp;minpoint, SbVec2f &amp;maxpoint) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec2f &amp;</type>
      <name>getMin</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>ae2c43a14d9842d0c1339b422f86c9dd9</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>getMin</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a87381f189b356411c3bb009334f14eeb</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SbVec2f &amp;</type>
      <name>getMax</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a4458392eb8d8fed8629d56e7e55247db</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>ae2e64a1f974668066070f8b85256cc1e</anchor>
      <arglist>(const SbVec2f &amp;point)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a2d6c817d8fde53380e5bd1fa68b22f08</anchor>
      <arglist>(const SbBox2f &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeEmpty</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a8a53357d402331b2433a190182c055dc</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isEmpty</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>abb775b01a784d95d695dfd82a6b17a54</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>hasArea</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>afb4476925b33e23e31d76b0ccefd509f</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>aacf1013f7815e28bdaee38a57df4e66b</anchor>
      <arglist>(const SbVec2f &amp;point) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a28f8f0fcb41c129aaedf71701153c062</anchor>
      <arglist>(const SbBox2f &amp;box) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f</type>
      <name>getClosestPoint</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a6e7b45e800b49b309a5bcd8fc2d76a2d</anchor>
      <arglist>(const SbVec2f &amp;point) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f</type>
      <name>getCenter</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>af398f5fe73d502479f88afb145c76a8a</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getOrigin</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>aaf081459344718f07ccdd3071d9e25aa</anchor>
      <arglist>(float &amp;originX, float &amp;originY) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getSize</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a22aff168fa0eead13d8062d5fb90b418</anchor>
      <arglist>(float &amp;sizeX, float &amp;sizeY) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getAspectRatio</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a232499c07c51b64a1a0fbbee00e01c4c</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a44f45d9426e170bec8f85b0fd82033d8</anchor>
      <arglist>(const SbBox2f &amp;b1, const SbBox2f &amp;b2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator !=</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a7f646fe25eadecb82a0bc8771d05ec85</anchor>
      <arglist>(const SbBox2f &amp;b1, const SbBox2f &amp;b2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbBox2i32</name>
    <filename>classSbBox2i32.html</filename>
    <member kind="function">
      <type></type>
      <name>SbBox2i32</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a00a108df9578449c28a71e82df2e3425</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox2i32</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a3f3b707dd61816ec42977710045a80eb</anchor>
      <arglist>(int32_t xmin, int32_t ymin, int32_t xmax, int32_t ymax)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox2i32</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a3ccb05c485c28ffe37a0b006bdaa7b73</anchor>
      <arglist>(const SbVec2i32 &amp;minpoint, const SbVec2i32 &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2i32 &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a07b5e5d4d93577e76196c787b241af7a</anchor>
      <arglist>(int32_t xmin, int32_t ymin, int32_t xmax, int32_t ymax)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2i32 &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>af968faf7abaa4a340f9a51f1d5f41d36</anchor>
      <arglist>(const SbVec2i32 &amp;minpoint, const SbVec2i32 &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2i32 &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a50cf910454ea88f88a9183d0a8a88a70</anchor>
      <arglist>(const SbBox2s &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2i32 &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>ad6b3a830d99a9134c2c094dc2bf1eb96</anchor>
      <arglist>(const SbBox2f &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2i32 &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>abb51acdad3cd319cec4a5c1e81d5ed62</anchor>
      <arglist>(const SbBox2d &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a8804e4efb51b6fdc4d9fea00091d411f</anchor>
      <arglist>(int32_t &amp;xmin, int32_t &amp;ymin, int32_t &amp;xmax, int32_t &amp;ymax) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>ad9e4e3efac613ec5f2f2f830b1816578</anchor>
      <arglist>(SbVec2i32 &amp;minpoint, SbVec2i32 &amp;maxpoint) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec2i32 &amp;</type>
      <name>getMin</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>ade23c0566b2b48673d11b16e15af6365</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec2i32 &amp;</type>
      <name>getMax</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a3b65dc81f0c914431edb55b7757f42f1</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a8bafd6a3bee621e012315639c107d239</anchor>
      <arglist>(const SbVec2i32 &amp;point)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a351aac1810159af0755a5f338ddc9628</anchor>
      <arglist>(const SbBox2i32 &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeEmpty</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>acecabbd2c9355ec12504aab11b5a2819</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>abf11de7712d5ba58280170f3ba43777e</anchor>
      <arglist>(const SbVec2i32 &amp;point) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a42936a8bddc8041ca3116994a2ef8721</anchor>
      <arglist>(const SbBox2i32 &amp;box) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getOrigin</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a7d25f40dcc9b72fb0e85b70b4c0c818e</anchor>
      <arglist>(int32_t &amp;originX, int32_t &amp;originY) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getSize</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a34d44973c91bc0cb3ff42fc4b7061420</anchor>
      <arglist>(int32_t &amp;sizeX, int32_t &amp;sizeY) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getAspectRatio</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a0f38ec07905cc0de85895c9bf5afc179</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>aab3f8be9fe431ab0554ee51e7ed15142</anchor>
      <arglist>(const SbBox2i32 &amp;b1, const SbBox2i32 &amp;b2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator !=</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a75e2bf3ea337d70d4b8693c421550af9</anchor>
      <arglist>(const SbBox2i32 &amp;b1, const SbBox2i32 &amp;b2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbBox2s</name>
    <filename>classSbBox2s.html</filename>
    <member kind="function">
      <type></type>
      <name>SbBox2s</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a9c89d2e09b48756623200f573d3d8c32</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox2s</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>adc4b8796c9228ef325f6c7e63ecb3442</anchor>
      <arglist>(short xmin, short ymin, short xmax, short ymax)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox2s</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>aae69b105fdcb01d3a4e9482de5f55271</anchor>
      <arglist>(const SbVec2s &amp;minpoint, const SbVec2s &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2s &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a45e3b9b59d7e4d62e4a38d54743aff2b</anchor>
      <arglist>(short xmin, short ymin, short xmax, short ymax)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2s &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>ae63d6210915c86cd2cb87b5e303ed3ab</anchor>
      <arglist>(const SbVec2s &amp;minpoint, const SbVec2s &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2s &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a2127e685bab4548cac5ba22ec7605e42</anchor>
      <arglist>(const SbBox2i32 &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2s &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a93f392204a9df6e72745f203b8ad09f1</anchor>
      <arglist>(const SbBox2f &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2s &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a22d4c407102514013fcb8e506a9b5b85</anchor>
      <arglist>(const SbBox2d &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a62b002f0d676b673cda16c62c58b8e67</anchor>
      <arglist>(short &amp;xmin, short &amp;ymin, short &amp;xmax, short &amp;ymax) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>ad13d193a70f4a25de1a9c04983ea2e17</anchor>
      <arglist>(SbVec2s &amp;minpoint, SbVec2s &amp;maxpoint) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec2s &amp;</type>
      <name>getMin</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a4c12214c607fde751a12a852ea91d959</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec2s &amp;</type>
      <name>getMax</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a6807b8102785f350aebcce1d2da3b235</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a1dca266f470c5a66671ee6cab151ad3f</anchor>
      <arglist>(const SbVec2s &amp;point)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>af04182b3564b7e62eeda4ab6d5f36de6</anchor>
      <arglist>(const SbBox2s &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeEmpty</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>aa22e56acd95b2ffdc76ddf77ee0c6bcb</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a7d43130e1276323a96ca2a2f0556974d</anchor>
      <arglist>(const SbVec2s &amp;point) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a10b12b197a5a0c2bcdc323c9c06f13ac</anchor>
      <arglist>(const SbBox2s &amp;box) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getOrigin</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a9a3167d6a4a6366f2bbfe56b177dd1c6</anchor>
      <arglist>(short &amp;originX, short &amp;originY) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getSize</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a9f85c39e8620acef3af888e72b5abf41</anchor>
      <arglist>(short &amp;sizeX, short &amp;sizeY) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getAspectRatio</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a5eb267852306c85361e1f69d74555215</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a1042a3532734ad78f25483c2f1305458</anchor>
      <arglist>(const SbBox2s &amp;b1, const SbBox2s &amp;b2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator !=</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>af3958a462273558a35b10ea5e688b0cd</anchor>
      <arglist>(const SbBox2s &amp;b1, const SbBox2s &amp;b2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbBox3d</name>
    <filename>classSbBox3d.html</filename>
    <member kind="function">
      <type></type>
      <name>SbBox3d</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a45ea275b28082f1ee978041b7a0ca6a8</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox3d</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>ab70192aeedddd65122a5fc352c4dfe1c</anchor>
      <arglist>(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox3d</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>ab90fc4d7004dfdfe6c9d09c359df61a2</anchor>
      <arglist>(const SbVec3d &amp;minpoint, const SbVec3d &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3d &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a43a4b2b558e8a21d33648b1bda85f789</anchor>
      <arglist>(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3d &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a650b55c2c282cdcfc4ab2115b6ecaa0e</anchor>
      <arglist>(const SbVec3d &amp;minpoint, const SbVec3d &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3d &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>aa88a95e250520e098a655bf263a20d13</anchor>
      <arglist>(const SbBox3f &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3d &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a9bceea65b321021e97decbf346002b73</anchor>
      <arglist>(const SbBox3s &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3d &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a637c1cace5e460cf431bf930e809603e</anchor>
      <arglist>(const SbBox3i32 &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a4d6f74741bd4b69b12399df0a945c4ca</anchor>
      <arglist>(double &amp;xmin, double &amp;ymin, double &amp;zmin, double &amp;xmax, double &amp;ymax, double &amp;zmax) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>acb83b36887982755a89be1648942326a</anchor>
      <arglist>(SbVec3d &amp;minpoint, SbVec3d &amp;maxpoint) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec3d &amp;</type>
      <name>getMin</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a230912e13f16043e301acb5535958263</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>getMin</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a54dd241796af5a3b58300856e1e3f4b9</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SbVec3d &amp;</type>
      <name>getMax</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a68390d415f6110bb31b5cc4d91364725</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>getMax</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a9efbd7394f969d498fd82720803a05a5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>ac893a7e396c4e3e52c3167419bab3a1b</anchor>
      <arglist>(const SbVec3d &amp;pt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a573d9e294173cee3cbe859bcd3d6246f</anchor>
      <arglist>(const SbBox3d &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transform</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a962b54989a51435308b1ea93e523b319</anchor>
      <arglist>(const SbDPMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeEmpty</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a026528f81ff09aa8120c03b42d88ebc3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isEmpty</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a43f86fc2ffcb57fc8a18e9d204f9430c</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>hasVolume</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a208d930fe163c706262fb2d00ef133c4</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getVolume</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>abc7fac6acc8649fb9ef3c9c2f3e3d9d6</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a1d56774b7842b909d29152c18e4441a7</anchor>
      <arglist>(const SbVec3d &amp;point) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a3fbf030c2133d5d00ee57f475fe8ab52</anchor>
      <arglist>(const SbBox3d &amp;box) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>getClosestPoint</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a7104e1cd1b53b2cc563ef348e15760e8</anchor>
      <arglist>(const SbVec3d &amp;point) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>outside</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a4f58579aa9e0febd54299cae8cd6a0c0</anchor>
      <arglist>(const SbDPMatrix &amp;mvp, int &amp;cullbits) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>getCenter</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a0d48d64db24d093906a1f7b5db2153e7</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getOrigin</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a6e61fe14df0acf7c3c676dce2367a9eb</anchor>
      <arglist>(double &amp;origoX, double &amp;origoY, double &amp;origoZ) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getSize</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a6e6c1846708b42b61c591e40b77fe9bc</anchor>
      <arglist>(double &amp;sizeX, double &amp;sizeY, double &amp;sizeZ) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>getSize</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a933ba7c6469b3fe0df6f3323af202778</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getSpan</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a4770f04a2ad3da733a3057a49cb73668</anchor>
      <arglist>(const SbVec3d &amp;dir, double &amp;dmin, double &amp;dmax) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a94ea16498d4d455a0b4efa0348be689f</anchor>
      <arglist>(FILE *file) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>ab4a51a09147360c5bc153f0db3a7ee92</anchor>
      <arglist>(const SbBox3d &amp;b1, const SbBox3d &amp;b2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator !=</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a165ee257d7a5929383048ab3338a5704</anchor>
      <arglist>(const SbBox3d &amp;b1, const SbBox3d &amp;b2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbBox3f</name>
    <filename>classSbBox3f.html</filename>
    <member kind="function">
      <type></type>
      <name>SbBox3f</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>acda68a85f93e1c8756d2f1804e1fab4e</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox3f</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>ae9b4d556bd2445c2245ad28b28e21d00</anchor>
      <arglist>(float xmin, float ymin, float zmin, float xmax, float ymax, float zmax)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox3f</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>ad190f9a9eae99d4d498443d1cf7a81db</anchor>
      <arglist>(const SbVec3f &amp;minpoint, const SbVec3f &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3f &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a2d834ff650b6b13dfd031391548b7a54</anchor>
      <arglist>(float xmin, float ymin, float zmin, float xmax, float ymax, float zmax)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3f &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a401fe84bbd869ebcf4e0239cdb341085</anchor>
      <arglist>(const SbVec3f &amp;minpoint, const SbVec3f &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3f &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>aaeb8955f8a8e15f2929f9b14d59aabee</anchor>
      <arglist>(const SbBox3d &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3f &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a72d624cf6e21ea8140db50f20b70776d</anchor>
      <arglist>(const SbBox3s &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3f &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a2a2f27fd6b76e6557a2b9de0d209e178</anchor>
      <arglist>(const SbBox3i32 &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a594edd3669317d8acaaebe135dd8299a</anchor>
      <arglist>(float &amp;xmin, float &amp;ymin, float &amp;zmin, float &amp;xmax, float &amp;ymax, float &amp;zmax) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a357694b134209000e613f4394aa52a2c</anchor>
      <arglist>(SbVec3f &amp;minpoint, SbVec3f &amp;maxpoint) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f &amp;</type>
      <name>getMin</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>ad48bea3318af82b45010d059a27188e7</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>getMin</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a19ba3e3cd73083cfe9a099813616c4cc</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f &amp;</type>
      <name>getMax</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a988bf40effbfd3c9f943b11006dd0a3b</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>getMax</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a6957d8a5bd2296ff6174885b79ad7acf</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>af34b9c76920737d7791f88c090a22634</anchor>
      <arglist>(const SbVec3f &amp;pt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>ae81199b5fe1786b8f621d794a153c20a</anchor>
      <arglist>(const SbBox3f &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transform</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>aef13d65bf2de3ce2f3bc963b6d1bda7e</anchor>
      <arglist>(const SbMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeEmpty</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a5ef7fe06e8ceb456f75fc2762a9b50aa</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isEmpty</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a76d00f8c689419f2fa059069dd649ddc</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>hasVolume</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a53e548067e1dd4f62caee438d69bb6df</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getVolume</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a9c4b5c53b7ee0820fdcc45ee7ef18710</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>ad2ade81b31c1a934b731ba0007cd0715</anchor>
      <arglist>(const SbVec3f &amp;pt) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>ac85c034ca9715c927748be4d52a8bfcf</anchor>
      <arglist>(const SbBox3f &amp;box) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getClosestPoint</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a5a5751ffd712f2c103af2c9ffe883b7b</anchor>
      <arglist>(const SbVec3f &amp;point) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>outside</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>af295cc29778833c17c2eb46ec6715afa</anchor>
      <arglist>(const SbMatrix &amp;mvp, int &amp;cullbits) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getCenter</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a12cb71fda5329b9be25868fcc4d9f4c5</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getOrigin</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a1564fbd351de828e8629ce91c3354c98</anchor>
      <arglist>(float &amp;originX, float &amp;originY, float &amp;originZ) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getSize</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a8a5d5c8b39e8e23984fd60c305889cfd</anchor>
      <arglist>(float &amp;sizeX, float &amp;sizeY, float &amp;sizeZ) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getSize</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>aaff47e21a8c06bad5f4bbef75a73980e</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getSpan</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a98d4f51e5d902ac5f0b6543296fe4db0</anchor>
      <arglist>(const SbVec3f &amp;dir, float &amp;dmin, float &amp;dmax) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>ae8f31abe45186d3a29347ca9cf844edf</anchor>
      <arglist>(FILE *file) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>ab8d0c8d5fad634d9067c36c06c5427fc</anchor>
      <arglist>(const SbBox3f &amp;b1, const SbBox3f &amp;b2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator !=</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a8359df14d46c496590f62da1fd8a317c</anchor>
      <arglist>(const SbBox3f &amp;b1, const SbBox3f &amp;b2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbBox3i32</name>
    <filename>classSbBox3i32.html</filename>
    <member kind="function">
      <type>SbBox3i32 &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3i32.html</anchorfile>
      <anchor>abf5676f3a1507aa76ea876c553cbd637</anchor>
      <arglist>(const SbBox3s &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3i32 &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3i32.html</anchorfile>
      <anchor>ad5074f94e70365f84581aa1b5e059da4</anchor>
      <arglist>(const SbBox3f &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3i32 &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3i32.html</anchorfile>
      <anchor>af843ddd52e67a4fe95d75b2b783628a4</anchor>
      <arglist>(const SbBox3d &amp;box)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbBox3s</name>
    <filename>classSbBox3s.html</filename>
    <member kind="function">
      <type></type>
      <name>SbBox3s</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>af34ced593533a18d9744eda71fe932f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox3s</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>ae563f1b8d0fe6397dbe2db8d2f6634f3</anchor>
      <arglist>(short xmin, short ymin, short zmin, short xmax, short ymax, short zmax)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox3s</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a060ac9e7fa6d50e26a70dfe67503ba8c</anchor>
      <arglist>(const SbVec3s &amp;minpoint, const SbVec3s &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3s &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a2c477237d4a0e162a8118092a58c51ee</anchor>
      <arglist>(short xmin, short ymin, short zmin, short xmax, short ymax, short zmax)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3s &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a3c9080831e46e5719873beddab6e9f82</anchor>
      <arglist>(const SbVec3s &amp;minpoint, const SbVec3s &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3s &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>ae8d2fa61d7f88aba9ca027008eb2d5ee</anchor>
      <arglist>(const SbBox3i32 &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3s &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a56964bf82750b50608ebf6d049b092a1</anchor>
      <arglist>(const SbBox3f &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3s &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>ac4648044180760e079b576d7bc281fb0</anchor>
      <arglist>(const SbBox3d &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a30881f3a5c3a82db82c9f13800c7342e</anchor>
      <arglist>(short &amp;xmin, short &amp;ymin, short &amp;zmin, short &amp;xmax, short &amp;ymax, short &amp;zmax) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a0dcd9fddb2cbb7d134eed39d3c6a8dc9</anchor>
      <arglist>(SbVec3s &amp;minpoint, SbVec3s &amp;maxpoint) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec3s &amp;</type>
      <name>getMin</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>ac1d344faa0be43b3223aa390b7145cea</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec3s &amp;</type>
      <name>getMax</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a0760465c28eea167e8a8d2638cd4720d</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a68ef880438212a29e6a7254a55a5fe10</anchor>
      <arglist>(const SbVec3s &amp;pt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>acc8678e70b1802613f1ba2a4cdbc6b66</anchor>
      <arglist>(const SbBox3s &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeEmpty</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a57664b65dd1ff57ee18c14a1c44f23ca</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a892a51850a424596c946a739f2341529</anchor>
      <arglist>(const SbVec3s &amp;pt) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a71357321e5967d1894b6f48f97d272f1</anchor>
      <arglist>(const SbBox3s &amp;box) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getClosestPoint</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>ac404845a940b5c575a2f1cd58a8dd3fd</anchor>
      <arglist>(const SbVec3f &amp;pt) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getOrigin</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>add6bad09abaf487579e2391195bc3fc9</anchor>
      <arglist>(short &amp;originX, short &amp;originY, short &amp;originZ) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getSize</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>aec5b660a53c348e2d6ed08dc7e28d7e6</anchor>
      <arglist>(short &amp;sizeX, short &amp;sizeY, short &amp;sizeZ) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a8947d1fa6e0badfc158e309139b23d90</anchor>
      <arglist>(const SbBox3s &amp;b1, const SbBox3s &amp;b2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator !=</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>afad94cc8be071b8c978cf27624dc0348</anchor>
      <arglist>(const SbBox3s &amp;b1, const SbBox3s &amp;b2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbBSPTree</name>
    <filename>classSbBSPTree.html</filename>
    <member kind="function">
      <type></type>
      <name>SbBSPTree</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a81cd11e722bd4d8782c9b2617e0e3907</anchor>
      <arglist>(const int maxnodepts=64, const int initsize=4)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbBSPTree</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a20b5c9fe452abb73582520f2503f302e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>numPoints</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a30be9f13dd903a1d481139f2a76edc0f</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getPoint</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a1575d2890567ff298f83c29480b56dfb</anchor>
      <arglist>(const int idx) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getPoint</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>ac87b2bc35a326f28d56d0db46a1b70a7</anchor>
      <arglist>(const int idx, SbVec3f &amp;pt) const</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>getUserData</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>aefdf2b4c4b3532da4813e266578de681</anchor>
      <arglist>(const int idx) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUserData</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a3e0dc00d4b8a12821f8cf6995fd9620e</anchor>
      <arglist>(const int idx, void *const data)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>addPoint</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a94c0936113aecbd1089f5692965cdde6</anchor>
      <arglist>(const SbVec3f &amp;pt, void *const userdata=NULL)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>removePoint</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>abe40262d6438a4228b4acc9ff944b9b3</anchor>
      <arglist>(const SbVec3f &amp;pt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removePoint</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a7c352323ca873a56b2dafc4e1022ec07</anchor>
      <arglist>(const int idx)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>findPoint</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a351d57d2a2496e35199032743230630a</anchor>
      <arglist>(const SbVec3f &amp;pos) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>findClosest</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a881bb8ab93cf664bf76e06104bd8b936</anchor>
      <arglist>(const SbVec3f &amp;pos) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>ae2d8a472cce88969ad72455554f25842</anchor>
      <arglist>(const int initsize=4)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>findPoints</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a7fb7b5d794aa07733316259afbc62ff8</anchor>
      <arglist>(const SbSphere &amp;sphere, SbIntList &amp;array) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>findClosest</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a04e7a2dca0335914f01d8d10f84c8498</anchor>
      <arglist>(const SbSphere &amp;sphere, SbIntList &amp;array) const</arglist>
    </member>
    <member kind="function">
      <type>const SbBox3f &amp;</type>
      <name>getBBox</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a9f74f6b65038dfe090f94436a51c1c29</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f *</type>
      <name>getPointsArrayPtr</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a7bb72924d56381c26228b14d26fc9991</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>findPoints</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a4ad3f661679a957a121f0101a64616c5</anchor>
      <arglist>(const SbSphere &amp;sphere, SbList&lt; int &gt; &amp;array) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>findClosest</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>aaeb48f1e69c7ad95e70111d4f0ace2e7</anchor>
      <arglist>(const SbSphere &amp;sphere, SbList&lt; int &gt; &amp;array) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbByteBuffer</name>
    <filename>classSbByteBuffer.html</filename>
  </compound>
  <compound kind="class">
    <name>SbClip</name>
    <filename>classSbClip.html</filename>
    <member kind="function">
      <type></type>
      <name>SbClip</name>
      <anchorfile>classSbClip.html</anchorfile>
      <anchor>ad84357d002b55482d098de8d44ff7d3e</anchor>
      <arglist>(SbClipCallback *callback=NULL, void *userdata=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addVertex</name>
      <anchorfile>classSbClip.html</anchorfile>
      <anchor>a341c5e4129ebef7f8447d408350ae98a</anchor>
      <arglist>(const SbVec3f &amp;v, void *vdata=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchorfile>classSbClip.html</anchorfile>
      <anchor>a0f4196a57e40383c33d04e9e19d2d5fc</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clip</name>
      <anchorfile>classSbClip.html</anchorfile>
      <anchor>adb59533f96dbca4e433fa8194e69677a</anchor>
      <arglist>(const SbPlane &amp;plane)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getNumVertices</name>
      <anchorfile>classSbClip.html</anchorfile>
      <anchor>addf1f7acf9e6eeccf8ec4190ba5a7a15</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getVertex</name>
      <anchorfile>classSbClip.html</anchorfile>
      <anchor>a2c567e8d2b7ffb6228459b48d0402dcd</anchor>
      <arglist>(const int idx, SbVec3f &amp;v, void **vdata=NULL) const</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>getVertexData</name>
      <anchorfile>classSbClip.html</anchorfile>
      <anchor>a9a4ad6e7f17725791209f42091ca8d84</anchor>
      <arglist>(const int idx) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbColor</name>
    <filename>classSbColor.html</filename>
    <base>SbVec3f</base>
    <member kind="function">
      <type></type>
      <name>SbColor</name>
      <anchorfile>classSbColor.html</anchorfile>
      <anchor>a57b97220a4686bf7f16c9a7daa81e995</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbColor</name>
      <anchorfile>classSbColor.html</anchorfile>
      <anchor>ad505d11c8d16b471e41d35a0f19bad6f</anchor>
      <arglist>(const SbVec3f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbColor</name>
      <anchorfile>classSbColor.html</anchorfile>
      <anchor>a8c13fdb8bb612dc9050af5fee374cc2d</anchor>
      <arglist>(const float *const rgb)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbColor</name>
      <anchorfile>classSbColor.html</anchorfile>
      <anchor>af4c539e5b646684bd3687a529d66ad8a</anchor>
      <arglist>(const float r, const float g, const float b)</arglist>
    </member>
    <member kind="function">
      <type>SbColor &amp;</type>
      <name>setHSVValue</name>
      <anchorfile>classSbColor.html</anchorfile>
      <anchor>ab0e0b257d9e44ccfeb0361e060dfc7ee</anchor>
      <arglist>(float h, float s, float v)</arglist>
    </member>
    <member kind="function">
      <type>SbColor &amp;</type>
      <name>setHSVValue</name>
      <anchorfile>classSbColor.html</anchorfile>
      <anchor>a06585db40ed0e0e3ad8ad9f0426acf49</anchor>
      <arglist>(const float hsv[3])</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getHSVValue</name>
      <anchorfile>classSbColor.html</anchorfile>
      <anchor>a66683abe1ecd2536c3ea60a25e8db424</anchor>
      <arglist>(float &amp;h, float &amp;s, float &amp;v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getHSVValue</name>
      <anchorfile>classSbColor.html</anchorfile>
      <anchor>a700c133cff1baeef06e448d94b6df992</anchor>
      <arglist>(float hsv[3]) const</arglist>
    </member>
    <member kind="function">
      <type>SbColor &amp;</type>
      <name>setPackedValue</name>
      <anchorfile>classSbColor.html</anchorfile>
      <anchor>aea92d5997a1ac924c9bf68c9c9c23ecb</anchor>
      <arglist>(const uint32_t rgba, float &amp;transparency)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>getPackedValue</name>
      <anchorfile>classSbColor.html</anchorfile>
      <anchor>a6ce20c3937e0765fd208a80ada74c108</anchor>
      <arglist>(const float transparency=0.0f) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbColor4f</name>
    <filename>classSbColor4f.html</filename>
    <base>SbVec4f</base>
    <member kind="function">
      <type></type>
      <name>SbColor4f</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>abf2300514eb7df2d08870e181f2fc4d4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbColor4f</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a53e7fc28bfa7153848582f9bff90fdf4</anchor>
      <arglist>(const SbColor &amp;rgb, const float alpha=1.0f)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbColor4f</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>aee7803324174c72f1c50185c97007aa5</anchor>
      <arglist>(const SbVec4f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbColor4f</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>ae76a933cb041ea3717fe2a565de13b2b</anchor>
      <arglist>(const float *const rgba)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbColor4f</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>ad1a3fec4de9db97cd1ebd48e81810f27</anchor>
      <arglist>(const float r, const float g, const float b, const float a=1.0f)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a4b4894afb2bb85d3398b1ee18e3087d4</anchor>
      <arglist>(const float r, const float g, const float b, const float a=1.0f)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a800bec94d1e9de045f9c274ad256d913</anchor>
      <arglist>(const float col[4])</arglist>
    </member>
    <member kind="function">
      <type>const float *</type>
      <name>getValue</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>abcdf6da87165b4bcbcc7bc15fc28c21a</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a6a8d80bc0b6c99f22de3ec3c709c0dfb</anchor>
      <arglist>(float &amp;r, float &amp;g, float &amp;b, float &amp;a)</arglist>
    </member>
    <member kind="function">
      <type>SbColor4f &amp;</type>
      <name>setRGB</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a734808c688beb9359623a13dc0d5f010</anchor>
      <arglist>(const SbColor &amp;col)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getRGB</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a973c01d8c620d3003e6bdd538d0b3360</anchor>
      <arglist>(SbColor &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>SbColor4f &amp;</type>
      <name>setHSVValue</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a18d2536de1a547cb257aadc6e50dd88f</anchor>
      <arglist>(float h, float s, float v, float a=1.0f)</arglist>
    </member>
    <member kind="function">
      <type>SbColor4f &amp;</type>
      <name>setHSVValue</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a04e5474068c768e2fc4eb6850b50237a</anchor>
      <arglist>(const float hsv[3], float alpha=1.0f)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getHSVValue</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a633e929a07e54bc804d616fe2530c53d</anchor>
      <arglist>(float &amp;h, float &amp;s, float &amp;v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getHSVValue</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>abc7edf13a1103b532a083e02943f423c</anchor>
      <arglist>(float hsv[3]) const</arglist>
    </member>
    <member kind="function">
      <type>SbColor4f &amp;</type>
      <name>setPackedValue</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a22e7a117d0bf23c0ac65575fa25bd677</anchor>
      <arglist>(const uint32_t rgba)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>getPackedValue</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a291f3819878dd9df1f017166a9d18ea4</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>operator[]</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a98798593c78fba010bb5a9cb56068c7c</anchor>
      <arglist>(const int idx) const</arglist>
    </member>
    <member kind="function">
      <type>float &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>ae8a3bdb9100bf8dce49cdaf2328b759c</anchor>
      <arglist>(const int idx)</arglist>
    </member>
    <member kind="function">
      <type>SbColor4f &amp;</type>
      <name>operator *=</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>afd8bd344b3731ed68ef0eabada3e9ee0</anchor>
      <arglist>(const float d)</arglist>
    </member>
    <member kind="function">
      <type>SbColor4f &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>ab257bf4d02b46088c6b1f2d3a06c7d23</anchor>
      <arglist>(const float d)</arglist>
    </member>
    <member kind="function">
      <type>SbColor4f &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a26329aa5fe3dda3ee1d3f3146bc33b96</anchor>
      <arglist>(const SbColor4f &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>SbColor4f &amp;</type>
      <name>operator-=</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>afe4e215e3f77dc75b6e33323baeddc30</anchor>
      <arglist>(const SbColor4f &amp;c)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbColor4f</type>
      <name>operator *</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a066e1f59f27edb7512417358d643f82f</anchor>
      <arglist>(const SbColor4f &amp;c, const float d)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbColor4f</type>
      <name>operator *</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>ae38d2bc02bbacd42e78a7cc97df36264</anchor>
      <arglist>(const float d, const SbColor4f &amp;c)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbColor4f</type>
      <name>operator/</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>ae48a713a98060ce1409e185c9a79bb3c</anchor>
      <arglist>(const SbColor4f &amp;c, const float d)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbColor4f</type>
      <name>operator+</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a7681baa1f2aca9f602b8ca4141a30ccb</anchor>
      <arglist>(const SbColor4f &amp;v1, const SbColor4f &amp;v2)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbColor4f</type>
      <name>operator -</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a659841532055a87b8fd2133f8c17551b</anchor>
      <arglist>(const SbColor4f &amp;v1, const SbColor4f &amp;v2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a3fff3adfe14963774875fd2d5116aa31</anchor>
      <arglist>(const SbColor4f &amp;v1, const SbColor4f &amp;v2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator !=</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a9b3d148233a9da4b88f399a21959474e</anchor>
      <arglist>(const SbColor4f &amp;v1, const SbColor4f &amp;v2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbCondVar</name>
    <filename>classSbCondVar.html</filename>
  </compound>
  <compound kind="class">
    <name>SbCylinder</name>
    <filename>classSbCylinder.html</filename>
    <member kind="function">
      <type></type>
      <name>SbCylinder</name>
      <anchorfile>classSbCylinder.html</anchorfile>
      <anchor>ab268ab24f22bd16e48cf39208af2ecc2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbCylinder</name>
      <anchorfile>classSbCylinder.html</anchorfile>
      <anchor>a8fddfda354f81860438fb87545cfc345</anchor>
      <arglist>(const SbLine &amp;a, const float r)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbCylinder.html</anchorfile>
      <anchor>af90337238a8ab3a5db63e0a69c5e9d71</anchor>
      <arglist>(const SbLine &amp;a, const float r)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAxis</name>
      <anchorfile>classSbCylinder.html</anchorfile>
      <anchor>a67bbd92c4b5d74aa76c795c44a50a003</anchor>
      <arglist>(const SbLine &amp;a)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRadius</name>
      <anchorfile>classSbCylinder.html</anchorfile>
      <anchor>a03a31659f75d8da21d426051bc2bf9b1</anchor>
      <arglist>(const float r)</arglist>
    </member>
    <member kind="function">
      <type>const SbLine &amp;</type>
      <name>getAxis</name>
      <anchorfile>classSbCylinder.html</anchorfile>
      <anchor>a7b6dc2de5ff0eaf65150552246cd7197</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getRadius</name>
      <anchorfile>classSbCylinder.html</anchorfile>
      <anchor>af4b3bb471407a3facc291aea91d42f94</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbCylinder.html</anchorfile>
      <anchor>a1d7aa17122c237649d775c321ed57f9b</anchor>
      <arglist>(const SbLine &amp;l, SbVec3f &amp;intersection) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbCylinder.html</anchorfile>
      <anchor>a4f5ec3fbe62417564e08be3c0d88720c</anchor>
      <arglist>(const SbLine &amp;l, SbVec3f &amp;enter, SbVec3f &amp;exit) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbCylinder.html</anchorfile>
      <anchor>a27c11426891c42b14f18d80d4e3bc67a</anchor>
      <arglist>(FILE *file) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbCylinderPlaneProjector</name>
    <filename>classSbCylinderPlaneProjector.html</filename>
    <base>SbCylinderSectionProjector</base>
    <member kind="function">
      <type></type>
      <name>SbCylinderPlaneProjector</name>
      <anchorfile>classSbCylinderPlaneProjector.html</anchorfile>
      <anchor>a08fd132904bbd02f023a9828343042cc</anchor>
      <arglist>(const float edgetol=0.9f, const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbCylinderPlaneProjector</name>
      <anchorfile>classSbCylinderPlaneProjector.html</anchorfile>
      <anchor>abdc129cdfa4dd62899ee4aee8b6db575</anchor>
      <arglist>(const SbCylinder &amp;cyl, const float edgetol=0.9f, const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbProjector *</type>
      <name>copy</name>
      <anchorfile>classSbCylinderPlaneProjector.html</anchorfile>
      <anchor>a7e1b4c25dd1713a1261f16ae595ce6ec</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>project</name>
      <anchorfile>classSbCylinderPlaneProjector.html</anchorfile>
      <anchor>afb1bc7a499cfab6096c991dfb14ee569</anchor>
      <arglist>(const SbVec2f &amp;point)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbRotation</type>
      <name>getRotation</name>
      <anchorfile>classSbCylinderPlaneProjector.html</anchorfile>
      <anchor>aca777eb280e6dec53fdfe4df92248799</anchor>
      <arglist>(const SbVec3f &amp;point1, const SbVec3f &amp;point2)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbRotation</type>
      <name>getRotation</name>
      <anchorfile>classSbCylinderPlaneProjector.html</anchorfile>
      <anchor>a4aba339a4a76f500347952d5c901fbc7</anchor>
      <arglist>(const SbVec3f &amp;point1, const SbBool tol1, const SbVec3f &amp;point2, const SbBool tol2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbCylinderProjector</name>
    <filename>classSbCylinderProjector.html</filename>
    <base>SbProjector</base>
    <member kind="function" virtualness="pure">
      <type>virtual SbVec3f</type>
      <name>project</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a0932d5f18d746906ef42ab363d8913be</anchor>
      <arglist>(const SbVec2f &amp;point)=0</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>projectAndGetRotation</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a8c299f86e571141f3cdaa07c222b7b07</anchor>
      <arglist>(const SbVec2f &amp;point, SbRotation &amp;rot)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual SbRotation</type>
      <name>getRotation</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>aa5dd6c4bc18a40ed5706b22beedcee58</anchor>
      <arglist>(const SbVec3f &amp;point1, const SbVec3f &amp;point2)=0</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCylinder</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>ac4c6c87f8bc0656f781b9281d9c37294</anchor>
      <arglist>(const SbCylinder &amp;cyl)</arglist>
    </member>
    <member kind="function">
      <type>const SbCylinder &amp;</type>
      <name>getCylinder</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a9845182c192fe25f1232797b6676d02b</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOrientToEye</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a366afa63e637a639ed16ee34374d7073</anchor>
      <arglist>(const SbBool orienttoeye)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isOrientToEye</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>ab9a036d36ca1ad3ea6a7cf5dc7078525</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFront</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a3a66f1c989709170b78c07cf172293ae</anchor>
      <arglist>(const SbBool infront)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isFront</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>aeb2c8b094a831defa48d0c92890d1417</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isPointInFront</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a6e08f31c1bc2350bddb9e5c3bd3dd470</anchor>
      <arglist>(const SbVec3f &amp;point) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setWorkingSpace</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a67017820b22d21be5008a09517cad5d9</anchor>
      <arglist>(const SbMatrix &amp;space)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SbCylinderProjector</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a6dd2e2729ca64533ad3f6e46c5a04226</anchor>
      <arglist>(const SbBool orienttoeye)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SbCylinderProjector</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a0c3291f74209ce8faed25c9074ec10f9</anchor>
      <arglist>(const SbCylinder &amp;cylinder, const SbBool orienttoeye)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbBool</type>
      <name>intersectCylinderFront</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a11b8f0cd7a7d1f7946e10283aa0fb394</anchor>
      <arglist>(const SbLine &amp;line, SbVec3f &amp;result)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbBool</type>
      <name>intersectFront</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a6040babe44b89117f1cb3bc0cdffc377</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbCylinder</type>
      <name>cylinder</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>aa3debf12deff6aa74807637383eacd77</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbBool</type>
      <name>orientToEye</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>afed152233dd402a2376f300c34adfa84</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbBool</type>
      <name>needSetup</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>af4238e26836efac6c8d10a8579a7ec70</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>lastPoint</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>af2e2f91ad80b06fa7072bad5bdd78647</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbCylinderSectionProjector</name>
    <filename>classSbCylinderSectionProjector.html</filename>
    <base>SbCylinderProjector</base>
    <member kind="function">
      <type></type>
      <name>SbCylinderSectionProjector</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>a372620eae35a518562eaa71ec623ca88</anchor>
      <arglist>(const float edgetol=0.9f, const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbCylinderSectionProjector</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>ad55f8fc72cd86d3153ed5a929277622d</anchor>
      <arglist>(const SbCylinder &amp;cyl, const float edgetol=0.9f, const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbProjector *</type>
      <name>copy</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>a3ae3c84a67868012d180e64a3f6c300e</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>project</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>a1559a388a0fdcd3de1ef8a2fe1066388</anchor>
      <arglist>(const SbVec2f &amp;point)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbRotation</type>
      <name>getRotation</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>a520520c707d304d80d4e6a8dd7f0374f</anchor>
      <arglist>(const SbVec3f &amp;point1, const SbVec3f &amp;point2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTolerance</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>a5d62015051b829b7af812d98fd0303be</anchor>
      <arglist>(const float edgetol)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getTolerance</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>a92e7b94c54420895485964b929652d38</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isWithinTolerance</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>a901871f080a352cdaec49f13a0ccce13</anchor>
      <arglist>(const SbVec3f &amp;point)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>setupTolerance</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>abbed8e29371e9d9b76e5341883bfdd7c</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>tolerance</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>aefc718ff69cf2e490fd9de532a9b43ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>tolDist</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>a798cc0c751300b98aa20d6381994a802</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>planeDir</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>a6c1a2f3bba580766b888672dfdfd6834</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbLine</type>
      <name>planeLine</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>a989430109a1f431e9a6a60a75e47cef9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>planeDist</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>aa1a721305a73dc62e97aff7be3b3e5a6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbPlane</type>
      <name>tolPlane</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>a5d8b4276b37a9b596458366615506ecb</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbCylinderSheetProjector</name>
    <filename>classSbCylinderSheetProjector.html</filename>
    <base>SbCylinderProjector</base>
    <member kind="function">
      <type></type>
      <name>SbCylinderSheetProjector</name>
      <anchorfile>classSbCylinderSheetProjector.html</anchorfile>
      <anchor>a5cd81d6b119f6a77a4901d21c601339c</anchor>
      <arglist>(const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbCylinderSheetProjector</name>
      <anchorfile>classSbCylinderSheetProjector.html</anchorfile>
      <anchor>aad3e95afc70fc70876845988f856205b</anchor>
      <arglist>(const SbCylinder &amp;cyl, const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbProjector *</type>
      <name>copy</name>
      <anchorfile>classSbCylinderSheetProjector.html</anchorfile>
      <anchor>a79a2ea6a1ecc1e34e3d9b041b06d771b</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>project</name>
      <anchorfile>classSbCylinderSheetProjector.html</anchorfile>
      <anchor>ac37ca81fe5dd8d1e7ecb176b692c8697</anchor>
      <arglist>(const SbVec2f &amp;point)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbRotation</type>
      <name>getRotation</name>
      <anchorfile>classSbCylinderSheetProjector.html</anchorfile>
      <anchor>a69a4e33d14b05a51533f45e977116bbe</anchor>
      <arglist>(const SbVec3f &amp;point1, const SbVec3f &amp;point2)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>setupPlane</name>
      <anchorfile>classSbCylinderSheetProjector.html</anchorfile>
      <anchor>af48ce18494eb4209176f1f6aab916d0d</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>workingProjPoint</name>
      <anchorfile>classSbCylinderSheetProjector.html</anchorfile>
      <anchor>a00ea3600bebe862c80d4cf120eaa184f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>planeDir</name>
      <anchorfile>classSbCylinderSheetProjector.html</anchorfile>
      <anchor>af431cab97204963a160c156e04d103ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbPlane</type>
      <name>tolPlane</name>
      <anchorfile>classSbCylinderSheetProjector.html</anchorfile>
      <anchor>aba60a9c4f3431342af1a621f31179ddb</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbDict</name>
    <filename>classSbDict.html</filename>
    <member kind="function">
      <type></type>
      <name>SbDict</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>a92792a27e53f730d81c3f545ea1aeb66</anchor>
      <arglist>(const int entries=251)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDict</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>adc2e06721f4e751e6c4b128eaed92b1c</anchor>
      <arglist>(const SbDict &amp;from)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbDict</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>abc0830ad6fc3f118ef9364193b488bd9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SbDict &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>a79d4f48693dedcc4e643b7e65beecca3</anchor>
      <arglist>(const SbDict &amp;from)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>applyToAll</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>a148c4be9d752bf8761eaf0d17e726151</anchor>
      <arglist>(SbDictApplyFunc *rtn) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>applyToAll</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>a4aa1910e2cc897f62451627469f3630e</anchor>
      <arglist>(SbDictApplyDataFunc *rtn, void *data) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>a7a685b879d51576ad1719b9beca0b03b</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>enter</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>a0bba31f23e0a1d50cd3167b27b3398e0</anchor>
      <arglist>(const Key key, void *const value)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>find</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>a527da743f9a92a4c020c3729daa52130</anchor>
      <arglist>(const Key key, void *&amp;value) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makePList</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>a7899d71e83dc06751a2f84a6e47945f5</anchor>
      <arglist>(SbPList &amp;keys, SbPList &amp;values)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>remove</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>a99399bd0d0a2400d2050acad0f944853</anchor>
      <arglist>(const Key key)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHashingFunction</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>acb8a122d624bbb4c70236f1e8998e6b0</anchor>
      <arglist>(SbDictHashingFunc *func)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbDPLine</name>
    <filename>classSbDPLine.html</filename>
    <member kind="function">
      <type></type>
      <name>SbDPLine</name>
      <anchorfile>classSbDPLine.html</anchorfile>
      <anchor>acd891c0ec98d97dbd7875444eb15d728</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPLine</name>
      <anchorfile>classSbDPLine.html</anchorfile>
      <anchor>abeb8525f59026c04f1bfc9e5f9384af4</anchor>
      <arglist>(const SbVec3d &amp;p0, const SbVec3d &amp;p1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbDPLine.html</anchorfile>
      <anchor>a2bbe6dd0ab4145e4443d5a3d1c2ee268</anchor>
      <arglist>(const SbVec3d &amp;p0, const SbVec3d &amp;p1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPosDir</name>
      <anchorfile>classSbDPLine.html</anchorfile>
      <anchor>a577cfe7776c15483c5d1a8adc2c29cfc</anchor>
      <arglist>(const SbVec3d &amp;position, const SbVec3d &amp;direction)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>getClosestPoints</name>
      <anchorfile>classSbDPLine.html</anchorfile>
      <anchor>a7733c69076f63db1d57787eaca845a1e</anchor>
      <arglist>(const SbDPLine &amp;line2, SbVec3d &amp;ptOnThis, SbVec3d &amp;ptOnLine2) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>getClosestPoint</name>
      <anchorfile>classSbDPLine.html</anchorfile>
      <anchor>a01f65400965ff8aa1627b09d4a1223a0</anchor>
      <arglist>(const SbVec3d &amp;point) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec3d &amp;</type>
      <name>getPosition</name>
      <anchorfile>classSbDPLine.html</anchorfile>
      <anchor>ac748f15d3c140af895b97c9700dd9293</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec3d &amp;</type>
      <name>getDirection</name>
      <anchorfile>classSbDPLine.html</anchorfile>
      <anchor>ae44074b59d27ae08b68897eeb2fbf55a</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbDPLine.html</anchorfile>
      <anchor>a451046f060514ce25409a1687a998d67</anchor>
      <arglist>(FILE *file) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbDPMatrix</name>
    <filename>classSbDPMatrix.html</filename>
    <member kind="function">
      <type></type>
      <name>SbDPMatrix</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a128a211a7842030be0e1c041f471f991</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPMatrix</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a8cde278900f7f4c9685958e5c788ba2b</anchor>
      <arglist>(const double a11, const double a12, const double a13, const double a14, const double a21, const double a22, const double a23, const double a24, const double a31, const double a32, const double a33, const double a34, const double a41, const double a42, const double a43, const double a44)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPMatrix</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a26d2933f7ff756a6c11c2696bf7c8603</anchor>
      <arglist>(const SbDPMat &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPMatrix</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>afa1e0f29be6a11a565f221f96076ba87</anchor>
      <arglist>(const SbDPMat *matrix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPMatrix</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>ab7b2feaf256ebcc815c7b4148a50449f</anchor>
      <arglist>(const SbMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbDPMatrix</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a98f02d5633413ffbdeb4044eb4552248</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a47126c746af49b0bf8b700a8b99fe09e</anchor>
      <arglist>(const SbDPMat &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>aea0f76b23ee126dbd9d92d66b77f3ebd</anchor>
      <arglist>(const SbMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a7039941aa193a375d440923e93580619</anchor>
      <arglist>(const double *pMat)</arglist>
    </member>
    <member kind="function">
      <type>const SbDPMat &amp;</type>
      <name>getValue</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a50df2a9119becd9b95b563e820d21d35</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeIdentity</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a5ebe71e85bd73734f391f3c7736a6a59</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRotate</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>aecb5ac77f13d3041efab4239f496b024</anchor>
      <arglist>(const SbDPRotation &amp;q)</arglist>
    </member>
    <member kind="function">
      <type>SbDPMatrix</type>
      <name>inverse</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>aee98fe7de513a47ab5cd6b7acd6b70d6</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>det3</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a6fdca786a6ede0c267383c0b4219cb76</anchor>
      <arglist>(int r1, int r2, int r3, int c1, int c2, int c3) const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>det3</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a516c34880624ed3bcb8b17e219ccaf5b</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>det4</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a707aecbb10eea724314e10065cc6ed3d</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>equals</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a8f73f7619edb41946aa52ca6e0c6ee74</anchor>
      <arglist>(const SbDPMatrix &amp;m, double tolerance) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a96ed5467dec809a4a922527353e3475e</anchor>
      <arglist>(SbDPMat &amp;m) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setScale</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a965c24d5efbdbbd0ec34ee327a063073</anchor>
      <arglist>(const double s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setScale</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>aa6d94a40b76407b8feb94b8a4cc409ee</anchor>
      <arglist>(const SbVec3d &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTranslate</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>ab74a0f653f57e888074078748031faca</anchor>
      <arglist>(const SbVec3d &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTransform</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>abde926c18b54a0d8666130918c744e88</anchor>
      <arglist>(const SbVec3d &amp;t, const SbDPRotation &amp;r, const SbVec3d &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTransform</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>aec1c06558a7c4deed0093102308ff384</anchor>
      <arglist>(const SbVec3d &amp;t, const SbDPRotation &amp;r, const SbVec3d &amp;s, const SbDPRotation &amp;so)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTransform</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>abfd3f938b5145dc09a81b5b381cd39b8</anchor>
      <arglist>(const SbVec3d &amp;translation, const SbDPRotation &amp;rotation, const SbVec3d &amp;scaleFactor, const SbDPRotation &amp;scaleOrientation, const SbVec3d &amp;center)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getTransform</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a06d3aefc6885a646bf79e9c8c20d43f0</anchor>
      <arglist>(SbVec3d &amp;t, SbDPRotation &amp;r, SbVec3d &amp;s, SbDPRotation &amp;so) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getTransform</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a18dfd7025b43b9456e29ee2a2a0b9965</anchor>
      <arglist>(SbVec3d &amp;translation, SbDPRotation &amp;rotation, SbVec3d &amp;scaleFactor, SbDPRotation &amp;scaleOrientation, const SbVec3d &amp;center) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>factor</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>abf2e53bbe1cfae3a6e6942b94c7fe23b</anchor>
      <arglist>(SbDPMatrix &amp;r, SbVec3d &amp;s, SbDPMatrix &amp;u, SbVec3d &amp;t, SbDPMatrix &amp;proj)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>LUDecomposition</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>ae2a77b2e48bdfcf31d1ccc2c357dfdaa</anchor>
      <arglist>(int index[4], double &amp;d)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>LUBackSubstitution</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a1f18ea570df7f55b1767f996568379b5</anchor>
      <arglist>(int index[4], double b[4]) const</arglist>
    </member>
    <member kind="function">
      <type>SbDPMatrix</type>
      <name>transpose</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a7b8a74bdf0fc406e40222afa9a06f75d</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbDPMatrix &amp;</type>
      <name>multRight</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a94cfe014d9ff734715d95528594f0dab</anchor>
      <arglist>(const SbDPMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>SbDPMatrix &amp;</type>
      <name>multLeft</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>ad460ff02e7cbb1d936924860c2597f07</anchor>
      <arglist>(const SbDPMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multMatrixVec</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>ac987c85f1e4d0f8b16377207c83ae3b7</anchor>
      <arglist>(const SbVec3d &amp;src, SbVec3d &amp;dst) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multVecMatrix</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>afbf3846b6265d9fd9ebb07159e8e7f25</anchor>
      <arglist>(const SbVec3d &amp;src, SbVec3d &amp;dst) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multDirMatrix</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>aa392eb35c058eab4a356a050ce6135b0</anchor>
      <arglist>(const SbVec3d &amp;src, SbVec3d &amp;dst) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multLineMatrix</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>ad7b853dbe112f2a98301dd6c35117f9e</anchor>
      <arglist>(const SbDPLine &amp;src, SbDPLine &amp;dst) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multVecMatrix</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a52bb5422ed7e66b2806eef85d164bd5f</anchor>
      <arglist>(const SbVec4d &amp;src, SbVec4d &amp;dst) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>acb77c1ba6d584755815a4f5fc90db5f1</anchor>
      <arglist>(FILE *fp) const</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator double *</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>ad050e634a24d8b5d8cd116e80316e74f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator SbDPMat &amp;</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a7e631132127dd962adc8ae686f414efb</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>double *</type>
      <name>operator []</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a4ed3ec1bbf10fca74a19d28d08e77cf3</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>const double *</type>
      <name>operator []</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a3dd554ddd1a93f08f7db3cc45450c5f5</anchor>
      <arglist>(int i) const</arglist>
    </member>
    <member kind="function">
      <type>SbDPMatrix &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>ab4bf47329bd286320f889bc267027b8a</anchor>
      <arglist>(const SbDPMat &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>SbDPMatrix &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>acb80ec05f96b34bef20434d629ede014</anchor>
      <arglist>(const SbDPMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>SbDPMatrix &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a1dbd777cd44b861cbecd64ec1da2204f</anchor>
      <arglist>(const SbDPRotation &amp;q)</arglist>
    </member>
    <member kind="function">
      <type>SbDPMatrix &amp;</type>
      <name>operator *=</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a6b265c89189a53620f2b62edfb1a229e</anchor>
      <arglist>(const SbDPMatrix &amp;m)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbDPMatrix</type>
      <name>identity</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a77c852c30e49dea81679efbb9eeb71b2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbDPMatrix</type>
      <name>operator *</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>ae0b7a79611779ec386580ab7681bc320</anchor>
      <arglist>(const SbDPMatrix &amp;m1, const SbDPMatrix &amp;m2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a728375812e131ac66d696b78a720985a</anchor>
      <arglist>(const SbDPMatrix &amp;m1, const SbDPMatrix &amp;m2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator !=</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a1cb0581fc56417ba8c6cbc09fb0c3bb4</anchor>
      <arglist>(const SbDPMatrix &amp;m1, const SbDPMatrix &amp;m2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbDPPlane</name>
    <filename>classSbDPPlane.html</filename>
    <member kind="function">
      <type></type>
      <name>SbDPPlane</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>a19743ddaf4a384d3cba5a4e6f9a5a3ea</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPPlane</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>a45410d9d067acdb90601e54d893579c5</anchor>
      <arglist>(const SbVec3d &amp;normal, const double D)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPPlane</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>ae8b10470c878267cd3762cd89104db83</anchor>
      <arglist>(const SbVec3d &amp;p0, const SbVec3d &amp;p1, const SbVec3d &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPPlane</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>acc7c2504435602ca952768e1c9cffa13</anchor>
      <arglist>(const SbVec3d &amp;normal, const SbVec3d &amp;point)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>offset</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>a87d41a81065603b897e0f2c284ef6cdc</anchor>
      <arglist>(const double d)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>a50b32db557caf0663528ec50cb39d838</anchor>
      <arglist>(const SbDPLine &amp;l, SbVec3d &amp;intersection) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transform</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>a71e39eb1f846b916e17780b013d9e5a8</anchor>
      <arglist>(const SbDPMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isInHalfSpace</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>ad22b7edb663cc2a0e6d067ee1c3b95c3</anchor>
      <arglist>(const SbVec3d &amp;point) const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getDistance</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>ad401ba821b85269b43dbddeefe438741</anchor>
      <arglist>(const SbVec3d &amp;point) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec3d &amp;</type>
      <name>getNormal</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>a7fd166ca1942bb3f2c29cef67667ed88</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getDistanceFromOrigin</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>a6f6165d0efa2cc9b13a7caf38393fe4f</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>a7a59f90989c7a1dd533b15ac4401dbd1</anchor>
      <arglist>(FILE *file) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>a99cca71249e7bd73004ec924a62d2bf0</anchor>
      <arglist>(const SbDPPlane &amp;pl, SbDPLine &amp;line) const</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>ae782368c6d9fae2120c18c92230c8d89</anchor>
      <arglist>(const SbDPPlane &amp;p1, const SbDPPlane &amp;p2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator !=</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>a9dac929d2c1b1c102ec57762d34e8b1d</anchor>
      <arglist>(const SbDPPlane &amp;p1, const SbDPPlane &amp;p2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbDPRotation</name>
    <filename>classSbDPRotation.html</filename>
    <member kind="function">
      <type></type>
      <name>SbDPRotation</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a75e95ae9852ea9bbc637e2620b1e94f9</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPRotation</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>ac0780b9ba075f24437a86aa1423ad5ed</anchor>
      <arglist>(const SbVec3d &amp;axis, const double radians)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPRotation</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a526858027f32f228658c698e9dd8d430</anchor>
      <arglist>(const double q[4])</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPRotation</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a2f4eb6b6904cbf232a616aced527fec9</anchor>
      <arglist>(const double q0, const double q1, const double q2, const double q3)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPRotation</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a26323e59933868a9aee01f90f97fae39</anchor>
      <arglist>(const SbDPMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPRotation</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>aa722c5954dfabfd29a44466ba70e4e3f</anchor>
      <arglist>(const SbVec3d &amp;rotateFrom, const SbVec3d &amp;rotateTo)</arglist>
    </member>
    <member kind="function">
      <type>const double *</type>
      <name>getValue</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>af4433e43ffabc68688c4e0a228b98232</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a5f42efb6c78b16728d737999f2404af2</anchor>
      <arglist>(double &amp;q0, double &amp;q1, double &amp;q2, double &amp;q3) const</arglist>
    </member>
    <member kind="function">
      <type>SbDPRotation &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a79f13ce745916c9793ae37aee6ed4d2a</anchor>
      <arglist>(const double q0, const double q1, const double q2, const double q3)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>af41c757c55e6a8acd26b7253cd7441ce</anchor>
      <arglist>(SbVec3d &amp;axis, double &amp;radians) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a6c7f26e6eacef9cba668a79ff2ff4db3</anchor>
      <arglist>(SbDPMatrix &amp;matrix) const</arglist>
    </member>
    <member kind="function">
      <type>SbDPRotation &amp;</type>
      <name>invert</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a404861abbf42a5c66445738fe5275003</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbDPRotation</type>
      <name>inverse</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a28283458d8f07570f876da79c0e85262</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbDPRotation &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a523b33d8acfb38b8b34dc3f08cb47425</anchor>
      <arglist>(const double q[4])</arglist>
    </member>
    <member kind="function">
      <type>SbDPRotation &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a159abdcd77b50ceda59b4a0592778af1</anchor>
      <arglist>(const SbDPMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>SbDPRotation &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a6859b5db7a7d0c688397583cc87da55f</anchor>
      <arglist>(const SbVec3d &amp;axis, const double radians)</arglist>
    </member>
    <member kind="function">
      <type>SbDPRotation &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a62330c9ee7c08b3d0aca25cce1f77195</anchor>
      <arglist>(const SbVec3d &amp;rotateFrom, const SbVec3d &amp;rotateTo)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>equals</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>afe5268722c49695ee5abcd337a669c3d</anchor>
      <arglist>(const SbDPRotation &amp;r, double tolerance) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multVec</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a449a9cd36921be328201d5dc44a3e658</anchor>
      <arglist>(const SbVec3d &amp;src, SbVec3d &amp;dst) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scaleAngle</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a43fd701a0941cc47f940f5b62692602a</anchor>
      <arglist>(const double scaleFactor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>aad7509e1061ede4c727d6c6d6af88145</anchor>
      <arglist>(FILE *fp) const</arglist>
    </member>
    <member kind="function">
      <type>SbDPRotation &amp;</type>
      <name>operator *=</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>ac8f676cbeee9d581df221cdb7edd6e69</anchor>
      <arglist>(const SbDPRotation &amp;q)</arglist>
    </member>
    <member kind="function">
      <type>SbDPRotation &amp;</type>
      <name>operator *=</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>aba3fdc674b2a4e651f598b1507fd9ff5</anchor>
      <arglist>(const double s)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbDPRotation</type>
      <name>slerp</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a1653228819abaf8d9b2353fc22584331</anchor>
      <arglist>(const SbDPRotation &amp;rot0, const SbDPRotation &amp;rot1, double t)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbDPRotation</type>
      <name>identity</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>aa6dd1f0167071e01c72c61f292ddf9f5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a456c673216e5fe96d0919d36f37c78a1</anchor>
      <arglist>(const SbDPRotation &amp;q1, const SbDPRotation &amp;q2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>ad518f0072406b2b16a7104a3da13e83f</anchor>
      <arglist>(const SbDPRotation &amp;q1, const SbDPRotation &amp;q2)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbDPRotation</type>
      <name>operator *</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a58e88206a3d73a4878edc84c0a40d244</anchor>
      <arglist>(const SbDPRotation &amp;q1, const SbDPRotation &amp;q2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbDPViewVolume</name>
    <filename>classSbDPViewVolume.html</filename>
    <member kind="enumeration">
      <type></type>
      <name>ProjectionType</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a6e291b38723761fefa5f4d548656f02d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ORTHOGRAPHIC</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a6e291b38723761fefa5f4d548656f02daba5f0b8714367d2d4f3fc89d827dad01</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PERSPECTIVE</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a6e291b38723761fefa5f4d548656f02daf82dddc9bfb5b1bc708b4d0831a2fa08</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ORTHOGRAPHIC</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a6e291b38723761fefa5f4d548656f02daba5f0b8714367d2d4f3fc89d827dad01</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PERSPECTIVE</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a6e291b38723761fefa5f4d548656f02daf82dddc9bfb5b1bc708b4d0831a2fa08</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPViewVolume</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a6a9df3bca0f7d4224f6d9f87fbcfc0b6</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbDPViewVolume</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a2fcb214d160096d3f035c3a7aeec3407</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getMatrices</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>af74dae18438d0bc4c1c778a6f850a1ce</anchor>
      <arglist>(SbDPMatrix &amp;affine, SbDPMatrix &amp;proj) const</arglist>
    </member>
    <member kind="function">
      <type>SbDPMatrix</type>
      <name>getMatrix</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>afbc5e0bb1899148097bc0e3218fd0c07</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbDPMatrix</type>
      <name>getCameraSpaceMatrix</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a5b64c046474305159367978c9bc28b38</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>projectPointToLine</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a607c2d4a45b9c501d70598741787b3a3</anchor>
      <arglist>(const SbVec2d &amp;pt, SbDPLine &amp;line) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>projectPointToLine</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>aaa6d06f4021905d425555ed9aaaf3ab6</anchor>
      <arglist>(const SbVec2d &amp;pt, SbVec3d &amp;line0, SbVec3d &amp;line1) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>projectToScreen</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>af1c09d94f1763b368bca7ad2a6c4c9c8</anchor>
      <arglist>(const SbVec3d &amp;src, SbVec3d &amp;dst) const</arglist>
    </member>
    <member kind="function">
      <type>SbPlane</type>
      <name>getPlane</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a4ca978d306d2da7c9163fbf90aadf656</anchor>
      <arglist>(const double distFromEye) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>getSightPoint</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a79be264c3a4288ea537ebafb4b724d48</anchor>
      <arglist>(const double distFromEye) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>getPlanePoint</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a17b45805b941b9b380b963ee442cc77e</anchor>
      <arglist>(const double distFromEye, const SbVec2d &amp;normPoint) const</arglist>
    </member>
    <member kind="function">
      <type>SbDPRotation</type>
      <name>getAlignRotation</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>af7b964bf2f24916e8e437be2beb5edc9</anchor>
      <arglist>(SbBool rightAngleOnly=FALSE) const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getWorldToScreenScale</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a23ec4d873f268e23d19017d4169f9d9f</anchor>
      <arglist>(const SbVec3d &amp;worldCenter, double normRadius) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d</type>
      <name>projectBox</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a71dc5ec274cb0d2ea7baea9a829b0b87</anchor>
      <arglist>(const SbBox3f &amp;box) const</arglist>
    </member>
    <member kind="function">
      <type>SbDPViewVolume</type>
      <name>narrow</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a58b9fac404b9dec06252bd4f73c608ed</anchor>
      <arglist>(double left, double bottom, double right, double top) const</arglist>
    </member>
    <member kind="function">
      <type>SbDPViewVolume</type>
      <name>narrow</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a1606850aa41d79d1439f81306a10aa44</anchor>
      <arglist>(const SbBox3f &amp;box) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ortho</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a5b1ae06d0a994807f8b7b03591390af6</anchor>
      <arglist>(double left, double right, double bottom, double top, double nearval, double farval)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>perspective</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a79b16609b4bb4ea993d2dc0abb1e9372</anchor>
      <arglist>(double fovy, double aspect, double nearval, double farval)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>frustum</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a5a1a8270a5c8a792b4baaa0f0db9718c</anchor>
      <arglist>(double left, double right, double bottom, double top, double nearval, double farval)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rotateCamera</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a67b021bbbc5a24853825d464444a8377</anchor>
      <arglist>(const SbDPRotation &amp;q)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>translateCamera</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a56e666557e3a6cd38ab28b803ee2fdd4</anchor>
      <arglist>(const SbVec3d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>zVector</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a56ba7cc19a2cb12507460095b078fcf9</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbDPViewVolume</type>
      <name>zNarrow</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a821a699d3878ccc74e1be7895d406106</anchor>
      <arglist>(double nearval, double farval) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scale</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a3dc5c5e4cd6a2d0ae9059811dc80e5ad</anchor>
      <arglist>(double factor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scaleWidth</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a417df19943bcf1c2bdaeaf8336386ee7</anchor>
      <arglist>(double ratio)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scaleHeight</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a999e189bd9500c74c4af3a0bc4ad94de</anchor>
      <arglist>(double ratio)</arglist>
    </member>
    <member kind="function">
      <type>ProjectionType</type>
      <name>getProjectionType</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a0a0fe4809db50e3b84f7b83a317ff5cf</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec3d &amp;</type>
      <name>getProjectionPoint</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a14c30f450f61b8ad1bef6632e8e09458</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec3d &amp;</type>
      <name>getProjectionDirection</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a891035e06c6e2fbf47c72b55e571c06f</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getNearDist</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a168a5a2f5375113b4980be63db98124b</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getWidth</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>abd9746a3e63672711672808635c94f37</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getHeight</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>ac63dc69356a7220bf5fb3197b917f835</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getDepth</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a660dc2b889f4bb58582d4c64a6dffb9c</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>ab29ef53ebec0bca7e1cda4b1963d2546</anchor>
      <arglist>(FILE *fp) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getViewVolumePlanes</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>ab323b43dbb8f6f22db455fb743ee53a0</anchor>
      <arglist>(SbPlane planes[6]) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transform</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>aaa31bc923afc5064b7cfc0317291dd8c</anchor>
      <arglist>(const SbDPMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>getViewUp</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a4cb448d2972bf657b5f1ef6d4e20409c</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbFifo</name>
    <filename>classSbFifo.html</filename>
  </compound>
  <compound kind="class">
    <name>SbHeap</name>
    <filename>classSbHeap.html</filename>
    <member kind="function">
      <type></type>
      <name>SbHeap</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>ac2992274d2b95a4fc4c9e596a43fa810</anchor>
      <arglist>(const SbHeapFuncs &amp;SbHeapFuncs, const int initsize=1024)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbHeap</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>a82d70ed3e4e280473261ecd68e5f89cc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>emptyHeap</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>a90933aaa6cf97fe3770944cc7b949c1b</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>size</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>a7d8404933090f9662d00fa298f8eb7ec</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>add</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>a391497a9c15341877e0139696e36488e</anchor>
      <arglist>(void *obj)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>a8a7e532b4747e84aa5de3892e484a08f</anchor>
      <arglist>(const int pos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>ab9441203bdf007b2ad839cb66f894111</anchor>
      <arglist>(void *obj)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>extractMin</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>ac9ca75ef3d29b357807660859c7ff9dd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>getMin</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>a8e16f8b087f872d7b3d78009c8a2c9f0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>operator[]</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>ac6e4b8b6a82325634d3223c02ab286b4</anchor>
      <arglist>(const int idx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>newWeight</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>a48c0b4f7e527bb6dbe4139ab88c9e6ba</anchor>
      <arglist>(void *obj, int hpos=-1)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>buildHeap</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>a26fcc520108e1f46e04a3a9513ab0fcb</anchor>
      <arglist>(SbBool(*progresscb)(float percentage, void *data)=NULL, void *data=NULL)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>traverseHeap</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>a2d31bc489d603a5566c1d814807a19da</anchor>
      <arglist>(SbBool(*func)(void *, void *), void *userdata) const</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>SbHeapFuncs</name>
    <filename>structSbHeapFuncs.html</filename>
    <member kind="variable">
      <type>float(*</type>
      <name>eval_func</name>
      <anchorfile>structSbHeapFuncs.html</anchorfile>
      <anchor>a5c73f24b66111ee54c8f54c478ee133e</anchor>
      <arglist>)(void *)</arglist>
    </member>
    <member kind="variable">
      <type>int(*</type>
      <name>get_index_func</name>
      <anchorfile>structSbHeapFuncs.html</anchorfile>
      <anchor>af35c5326d7d98064539f2474cfe054e5</anchor>
      <arglist>)(void *)</arglist>
    </member>
    <member kind="variable">
      <type>void(*</type>
      <name>set_index_func</name>
      <anchorfile>structSbHeapFuncs.html</anchorfile>
      <anchor>a52baccb47c85e89e17c422fc18881e8e</anchor>
      <arglist>)(void *, int)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbImage</name>
    <filename>classSbImage.html</filename>
    <member kind="function">
      <type></type>
      <name>SbImage</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a550b12717f54edaea466e959d2980d89</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbImage</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a778084cf728861bd8d0914ea2fcba96e</anchor>
      <arglist>(const unsigned char *bytes, const SbVec2s &amp;size, const int bytesperpixel)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbImage</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a3c65278b7e9875b5b3b96cd5f40811ec</anchor>
      <arglist>(const unsigned char *bytes, const SbVec3s &amp;size, const int bytesperpixel)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbImage</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a32a64d8424b7754e4f870e8afb7757fa</anchor>
      <arglist>(const SbImage &amp;image)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbImage</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a79f9dcc12b3fe1c11f2d4fc289610f1c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a8c119ce77ae392580d3f4776adeb72ce</anchor>
      <arglist>(const SbVec2s &amp;size, const int bytesperpixel, const unsigned char *bytes)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a1d234ffdf7ae23b249cd9978044c7e69</anchor>
      <arglist>(const SbVec3s &amp;size, const int bytesperpixel, const unsigned char *bytes)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValuePtr</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a5393d25e565e123ebc889055612592bf</anchor>
      <arglist>(const SbVec2s &amp;size, const int bytesperpixel, const unsigned char *bytes)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValuePtr</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a4cdc0f3a01dc4651a4aa9794d58357d2</anchor>
      <arglist>(const SbVec3s &amp;size, const int bytesperpixel, const unsigned char *bytes)</arglist>
    </member>
    <member kind="function">
      <type>unsigned char *</type>
      <name>getValue</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>aef417ee5c9e6057e94ce0dff5e780f91</anchor>
      <arglist>(SbVec2s &amp;size, int &amp;bytesperpixel) const</arglist>
    </member>
    <member kind="function">
      <type>unsigned char *</type>
      <name>getValue</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a3c4ff6c988be78b643dea37a03168298</anchor>
      <arglist>(SbVec3s &amp;size, int &amp;bytesperpixel) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s</type>
      <name>getSize</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a2ba0bcaf4bc665bd814580997fc56618</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>readFile</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a869f0fa0bfe5b58bf31e8c00bc0dc6c0</anchor>
      <arglist>(const SbString &amp;filename, const SbString *const *searchdirectories=NULL, const int numdirectories=0)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a47a3cb0a7245bc77472c8201e6f65896</anchor>
      <arglist>(const SbImage &amp;image) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a303a5baeec154f07385871f6e17f210a</anchor>
      <arglist>(const SbImage &amp;image) const</arglist>
    </member>
    <member kind="function">
      <type>SbImage &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a5f21488a4af52f41f22015396315f6e8</anchor>
      <arglist>(const SbImage &amp;image)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>hasData</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a0bb2bd63a6db68120d71a41b5e5df366</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readLock</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a92b81d2375880c6b0b01d6c026a0ca94</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readUnlock</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a6bb9be210c0bfd866986dc75c2a1f422</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>scheduleReadFile</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>aeb76fecd85ad2b627f4b3bd247e1df3a</anchor>
      <arglist>(SbImageScheduleReadCB *cb, void *closure, const SbString &amp;filename, const SbString *const *searchdirectories=NULL, const int numdirectories=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>addReadImageCB</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a24b1dd5bb0bfa78a89db2363f822561c</anchor>
      <arglist>(SbImageReadImageCB *cb, void *closure)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>removeReadImageCB</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a57f25c820e03b12c28e2775a69ccebea</anchor>
      <arglist>(SbImageReadImageCB *cb, void *closure)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbString</type>
      <name>searchForFile</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a1155f75c7b9aa27fcd0b004bde938704</anchor>
      <arglist>(const SbString &amp;basename, const SbString *const *dirlist, const int numdirs)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbIntList</name>
    <filename>classSbIntList.html</filename>
    <base>SbPList</base>
    <member kind="function">
      <type></type>
      <name>SbIntList</name>
      <anchorfile>classSbIntList.html</anchorfile>
      <anchor>a77787425ccf57683a584e891c16f783b</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbIntList</name>
      <anchorfile>classSbIntList.html</anchorfile>
      <anchor>afca9c9369d5fe31414c0b068772fe0bf</anchor>
      <arglist>(const int sizehint)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbIntList.html</anchorfile>
      <anchor>aa7c78267d6164e2e3d9550e7c1c023c0</anchor>
      <arglist>(const int item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbIntList.html</anchorfile>
      <anchor>a8c36ff744a7dc5749699447d696f77bc</anchor>
      <arglist>(const int item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbIntList.html</anchorfile>
      <anchor>a832e8fa620c7101da392b1a77c3bb9bf</anchor>
      <arglist>(const int item, const int addbefore)</arglist>
    </member>
    <member kind="function">
      <type>int &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbIntList.html</anchorfile>
      <anchor>a76fe6ac0f09adf1cfd97e41f188b271e</anchor>
      <arglist>(const int idx) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr</name>
    <filename>classSbLazyPimplPtr.html</filename>
    <templarg>T</templarg>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; PImpl &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoAudioRenderActionP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoCenterballDraggerP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoCenterballManipP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoClipPlaneManipP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoDirectionalLightDraggerP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoDirectionalLightManipP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoDragPointDraggerP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoGeoSeparatorP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoGetBoundingBoxActionP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoGetMatrixActionP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoGetPrimitiveCountActionP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoGlobalSimplifyActionP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoHandleBoxDraggerP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoHandleBoxManipP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoJackDraggerP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoJackManipP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoPickActionP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoPointLightDraggerP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoPointLightManipP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoRotateCylindricalDraggerP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoRotateDiscDraggerP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoRotateSphericalDraggerP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoScale1DraggerP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoScale2DraggerP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoScale2UniformDraggerP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoScaleUniformDraggerP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoSearchActionP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoShapeSimplifyActionP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoSpotLightDraggerP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoSpotLightManipP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoTabBoxDraggerP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoTabBoxManipP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoTabPlaneDraggerP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoTrackballManipP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoTransformBoxDraggerP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoTransformBoxManipP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoTransformerManipP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoTransformManipP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoTranslate1DraggerP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLazyPimplPtr&lt; SoWriteActionP &gt;</name>
    <filename>classSbLazyPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbLine</name>
    <filename>classSbLine.html</filename>
    <member kind="function">
      <type></type>
      <name>SbLine</name>
      <anchorfile>classSbLine.html</anchorfile>
      <anchor>aa8db4c11f19c63d8431002d34edaa515</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbLine</name>
      <anchorfile>classSbLine.html</anchorfile>
      <anchor>a5ab86e886ad329357c68bbb67c92d53c</anchor>
      <arglist>(const SbVec3f &amp;origin, const SbVec3f &amp;point)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbLine.html</anchorfile>
      <anchor>a6beb09e9ca8cf702ddcf0b2a56793a1d</anchor>
      <arglist>(const SbVec3f &amp;origin, const SbVec3f &amp;point)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPosDir</name>
      <anchorfile>classSbLine.html</anchorfile>
      <anchor>ab4910d8a37e4e80c80eabc4caee321e6</anchor>
      <arglist>(const SbVec3f &amp;position, const SbVec3f &amp;direction)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>getClosestPoints</name>
      <anchorfile>classSbLine.html</anchorfile>
      <anchor>a1ad1e9287b0bdf60dc571169b653d48b</anchor>
      <arglist>(const SbLine &amp;line2, SbVec3f &amp;ptOnThis, SbVec3f &amp;ptOnLine2) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getClosestPoint</name>
      <anchorfile>classSbLine.html</anchorfile>
      <anchor>ad7545ac9b3f58a997210b4105b03172e</anchor>
      <arglist>(const SbVec3f &amp;point) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f &amp;</type>
      <name>getPosition</name>
      <anchorfile>classSbLine.html</anchorfile>
      <anchor>a1aa72583aa021c8fb014cb1976bfea82</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f &amp;</type>
      <name>getDirection</name>
      <anchorfile>classSbLine.html</anchorfile>
      <anchor>aabaffac41aa2361adf612f33f7a7451f</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbLine.html</anchorfile>
      <anchor>abcc3a3f02dfa22e838569e0c5a553baa</anchor>
      <arglist>(FILE *file) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbLineProjector</name>
    <filename>classSbLineProjector.html</filename>
    <base>SbProjector</base>
    <member kind="function">
      <type></type>
      <name>SbLineProjector</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>a62208e6694d0c49d5f5f2285253dd2c6</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbProjector *</type>
      <name>copy</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>ae93ba9c9d23f7fb542a1324737f9ba70</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>project</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>a37d1853c90acf15a9f1b89f5ce916328</anchor>
      <arglist>(const SbVec2f &amp;point)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>tryProject</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>a30d31ed062b21ede8aba6d6efb7cabcd</anchor>
      <arglist>(const SbVec2f &amp;point, const float epsilon, SbVec3f &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLine</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>a67f4544fb46670d4a5a1f7d19f07a3c9</anchor>
      <arglist>(const SbLine &amp;line)</arglist>
    </member>
    <member kind="function">
      <type>const SbLine &amp;</type>
      <name>getLine</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>ab2efc40fba7e0711d3815ba44896faaa</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>getVector</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>a0ac417f0ecb8ba48885eb38797cd8cb0</anchor>
      <arglist>(const SbVec2f &amp;viewpos1, const SbVec2f &amp;viewpos2)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>getVector</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>a69cdc927750e6a129219255de434f535</anchor>
      <arglist>(const SbVec2f &amp;viewpos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStartPosition</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>a1a5e94503de9afdc59070e6c2e3da3fc</anchor>
      <arglist>(const SbVec2f &amp;viewpos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStartPosition</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>ad03cee2f1c3908b186d9373dd320b6c5</anchor>
      <arglist>(const SbVec3f &amp;point)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbLine</type>
      <name>line</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>a941a98593075b2dd72aefe27389675dd</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>lastPoint</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>a933b480d6eee70fa3dea6a5fcf4aae5b</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList</name>
    <filename>classSbList.html</filename>
    <templarg>Type</templarg>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; Type &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; Type &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; Type &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; Type &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const Type item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const Type item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const Type item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const Type item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const Type item)</arglist>
    </member>
    <member kind="function">
      <type>Type</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const Type *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>Type</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>Type &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; Type &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; Type &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; BogusSet * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; BogusSet * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; BogusSet * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; BogusSet * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; BogusSet * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const BogusSet * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const BogusSet * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const BogusSet * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const BogusSet * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const BogusSet * item)</arglist>
    </member>
    <member kind="function">
      <type>BogusSet *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const BogusSet * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>BogusSet *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>BogusSet * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; BogusSet * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; BogusSet * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; CallbackInfo &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; CallbackInfo &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; CallbackInfo &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; CallbackInfo &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; CallbackInfo &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const CallbackInfo item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const CallbackInfo item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const CallbackInfo item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const CallbackInfo item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const CallbackInfo item)</arglist>
    </member>
    <member kind="function">
      <type>CallbackInfo</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const CallbackInfo *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>CallbackInfo</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>CallbackInfo &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; CallbackInfo &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; CallbackInfo &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; cc_xml_attr * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; cc_xml_attr * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; cc_xml_attr * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; cc_xml_attr * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; cc_xml_attr * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const cc_xml_attr * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const cc_xml_attr * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const cc_xml_attr * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const cc_xml_attr * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const cc_xml_attr * item)</arglist>
    </member>
    <member kind="function">
      <type>cc_xml_attr *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const cc_xml_attr * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>cc_xml_attr *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>cc_xml_attr * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; cc_xml_attr * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; cc_xml_attr * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; cc_xml_elt * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; cc_xml_elt * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; cc_xml_elt * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; cc_xml_elt * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; cc_xml_elt * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const cc_xml_elt * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const cc_xml_elt * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const cc_xml_elt * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const cc_xml_elt * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const cc_xml_elt * item)</arglist>
    </member>
    <member kind="function">
      <type>cc_xml_elt *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const cc_xml_elt * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>cc_xml_elt *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>cc_xml_elt * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; cc_xml_elt * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; cc_xml_elt * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; class CatalogItem * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; class CatalogItem * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; class CatalogItem * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; class CatalogItem * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; class CatalogItem * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const class CatalogItem * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const class CatalogItem * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const class CatalogItem * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const class CatalogItem * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const class CatalogItem * item)</arglist>
    </member>
    <member kind="function">
      <type>class CatalogItem *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const class CatalogItem * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>class CatalogItem *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>class CatalogItem * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; class CatalogItem * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; class CatalogItem * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; const char * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; const char * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; const char * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; const char * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; const char * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const const char * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const const char * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const const char * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const const char * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const const char * item)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const const char * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>const char * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; const char * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; const char * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; ContentsCopiedMap * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; ContentsCopiedMap * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; ContentsCopiedMap * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; ContentsCopiedMap * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; ContentsCopiedMap * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const ContentsCopiedMap * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const ContentsCopiedMap * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const ContentsCopiedMap * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const ContentsCopiedMap * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const ContentsCopiedMap * item)</arglist>
    </member>
    <member kind="function">
      <type>ContentsCopiedMap *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const ContentsCopiedMap * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>ContentsCopiedMap *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>ContentsCopiedMap * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; ContentsCopiedMap * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; ContentsCopiedMap * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; dldata &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; dldata &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; dldata &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; dldata &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; dldata &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const dldata item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const dldata item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const dldata item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const dldata item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const dldata item)</arglist>
    </member>
    <member kind="function">
      <type>dldata</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const dldata *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>dldata</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>dldata &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; dldata &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; dldata &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; double &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; double &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; double &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; double &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; double &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const double item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const double item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const double item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const double item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const double item)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const double *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>double &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; double &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; double &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; float &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; float &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; float &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; float &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; float &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const float item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const float item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const float item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const float item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const float item)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const float *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>float &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; float &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; float &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; int &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; int &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; int &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; int &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; int &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const int item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const int item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const int item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const int item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const int item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const int *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>int &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; int &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; int &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; int32_t &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; int32_t &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; int32_t &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; int32_t &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; int32_t &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const int32_t item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const int32_t item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const int32_t item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const int32_t item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const int32_t item)</arglist>
    </member>
    <member kind="function">
      <type>int32_t</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const int32_t *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>int32_t</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>int32_t &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; int32_t &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; int32_t &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; ReadImageCBData &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; ReadImageCBData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; ReadImageCBData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; ReadImageCBData &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; ReadImageCBData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const ReadImageCBData item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const ReadImageCBData item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const ReadImageCBData item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const ReadImageCBData item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const ReadImageCBData item)</arglist>
    </member>
    <member kind="function">
      <type>ReadImageCBData</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const ReadImageCBData *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>ReadImageCBData</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>ReadImageCBData &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; ReadImageCBData &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; ReadImageCBData &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SbBool &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SbBool &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SbBool &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SbBool &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SbBool &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SbBool item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SbBool item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SbBool item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SbBool item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SbBool item)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SbBool *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SbBool &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SbBool &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SbClipData &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SbClipData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SbClipData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SbClipData &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SbClipData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SbClipData item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SbClipData item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SbClipData item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SbClipData item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SbClipData item)</arglist>
    </member>
    <member kind="function">
      <type>SbClipData</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SbClipData *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SbClipData</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SbClipData &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SbClipData &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SbClipData &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SbList&lt; SbVec2s &gt; &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SbList&lt; SbVec2s &gt; &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SbList&lt; SbVec2s &gt; &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SbList&lt; SbVec2s &gt; &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SbList&lt; SbVec2s &gt; &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SbList&lt; SbVec2s &gt; item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SbList&lt; SbVec2s &gt; item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SbList&lt; SbVec2s &gt; item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SbList&lt; SbVec2s &gt; item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SbList&lt; SbVec2s &gt; item)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SbVec2s &gt;</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SbList&lt; SbVec2s &gt; *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SbVec2s &gt;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SbVec2s &gt; &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SbList&lt; SbVec2s &gt; &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SbList&lt; SbVec2s &gt; &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SbMatrix &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SbMatrix &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SbMatrix &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SbMatrix &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SbMatrix &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SbMatrix item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SbMatrix item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SbMatrix item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SbMatrix item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SbMatrix item)</arglist>
    </member>
    <member kind="function">
      <type>SbMatrix</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SbMatrix *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SbMatrix</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SbMatrix &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SbMatrix &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SbMatrix &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SbName &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SbName &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SbName &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SbName &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SbName &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SbName item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SbName item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SbName item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SbName item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SbName item)</arglist>
    </member>
    <member kind="function">
      <type>SbName</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SbName *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SbName</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SbName &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SbName &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SbName &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SbString &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SbString &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SbString &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SbString &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SbString &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SbString item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SbString item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SbString item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SbString item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SbString item)</arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SbString *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SbString &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SbString &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SbString &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SbTri3f * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SbTri3f * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SbTri3f * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SbTri3f * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SbTri3f * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SbTri3f * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SbTri3f * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SbTri3f * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SbTri3f * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SbTri3f * item)</arglist>
    </member>
    <member kind="function">
      <type>SbTri3f *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SbTri3f * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SbTri3f *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SbTri3f * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SbTri3f * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SbTri3f * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SbUniqueId &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SbUniqueId &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SbUniqueId &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SbUniqueId &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SbUniqueId &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SbUniqueId item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SbUniqueId item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SbUniqueId item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SbUniqueId item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SbUniqueId item)</arglist>
    </member>
    <member kind="function">
      <type>SbUniqueId</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SbUniqueId *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SbUniqueId</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SbUniqueId &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SbUniqueId &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SbUniqueId &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SbVec2f &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SbVec2f &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SbVec2f &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SbVec2f &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SbVec2f &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SbVec2f item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SbVec2f item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SbVec2f item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SbVec2f item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SbVec2f item)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SbVec2f *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SbVec2f &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SbVec2f &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SbVec2s &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SbVec2s &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SbVec2s &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SbVec2s &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SbVec2s &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SbVec2s item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SbVec2s item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SbVec2s item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SbVec2s item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SbVec2s item)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SbVec2s *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SbVec2s &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SbVec2s &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SbVec3f &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SbVec3f &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SbVec3f &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SbVec3f &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SbVec3f &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SbVec3f item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SbVec3f item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SbVec3f item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SbVec3f item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SbVec3f item)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SbVec3f &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SbVec3f &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SbVec4f &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SbVec4f &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SbVec4f &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SbVec4f &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SbVec4f &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SbVec4f item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SbVec4f item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SbVec4f item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SbVec4f item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SbVec4f item)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SbVec4f *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SbVec4f &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SbVec4f &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; ScXMLEventTarget * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; ScXMLEventTarget * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; ScXMLEventTarget * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; ScXMLEventTarget * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; ScXMLEventTarget * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const ScXMLEventTarget * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const ScXMLEventTarget * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const ScXMLEventTarget * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const ScXMLEventTarget * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const ScXMLEventTarget * item)</arglist>
    </member>
    <member kind="function">
      <type>ScXMLEventTarget *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const ScXMLEventTarget * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>ScXMLEventTarget *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>ScXMLEventTarget * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; ScXMLEventTarget * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; ScXMLEventTarget * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SendLookup &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SendLookup &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SendLookup &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SendLookup &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SendLookup &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SendLookup item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SendLookup item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SendLookup item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SendLookup item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SendLookup item)</arglist>
    </member>
    <member kind="function">
      <type>SendLookup</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SendLookup *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SendLookup</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SendLookup &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SendLookup &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SendLookup &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; ShapeData * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; ShapeData * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; ShapeData * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; ShapeData * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; ShapeData * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const ShapeData * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const ShapeData * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const ShapeData * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const ShapeData * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const ShapeData * item)</arglist>
    </member>
    <member kind="function">
      <type>ShapeData *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const ShapeData * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>ShapeData *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>ShapeData * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; ShapeData * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; ShapeData * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; so_plane_data &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; so_plane_data &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; so_plane_data &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; so_plane_data &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; so_plane_data &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const so_plane_data item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const so_plane_data item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const so_plane_data item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const so_plane_data item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const so_plane_data item)</arglist>
    </member>
    <member kind="function">
      <type>so_plane_data</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const so_plane_data *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>so_plane_data</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>so_plane_data &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; so_plane_data &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; so_plane_data &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoDelayQueueSensor * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoDelayQueueSensor * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoDelayQueueSensor * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoDelayQueueSensor * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoDelayQueueSensor * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoDelayQueueSensor * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoDelayQueueSensor * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoDelayQueueSensor * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoDelayQueueSensor * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoDelayQueueSensor * item)</arglist>
    </member>
    <member kind="function">
      <type>SoDelayQueueSensor *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoDelayQueueSensor * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoDelayQueueSensor *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoDelayQueueSensor * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoDelayQueueSensor * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoDelayQueueSensor * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoElement * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoElement * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoElement * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoElement * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoElement * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoElement * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoElement * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoElement * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoElement * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoElement * item)</arglist>
    </member>
    <member kind="function">
      <type>SoElement *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoElement * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoElement *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoElement * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoElement * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoElement * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoEnumEntry * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoEnumEntry * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoEnumEntry * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoEnumEntry * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoEnumEntry * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoEnumEntry * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoEnumEntry * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoEnumEntry * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoEnumEntry * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoEnumEntry * item)</arglist>
    </member>
    <member kind="function">
      <type>SoEnumEntry *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoEnumEntry * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoEnumEntry *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoEnumEntry * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoEnumEntry * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoEnumEntry * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoFieldContainerCopyMap * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoFieldContainerCopyMap * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoFieldContainerCopyMap * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoFieldContainerCopyMap * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoFieldContainerCopyMap * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoFieldContainerCopyMap * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoFieldContainerCopyMap * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoFieldContainerCopyMap * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoFieldContainerCopyMap * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoFieldContainerCopyMap * item)</arglist>
    </member>
    <member kind="function">
      <type>SoFieldContainerCopyMap *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoFieldContainerCopyMap * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoFieldContainerCopyMap *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoFieldContainerCopyMap * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoFieldContainerCopyMap * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoFieldContainerCopyMap * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoFieldEntry * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoFieldEntry * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoFieldEntry * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoFieldEntry * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoFieldEntry * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoFieldEntry * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoFieldEntry * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoFieldEntry * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoFieldEntry * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoFieldEntry * item)</arglist>
    </member>
    <member kind="function">
      <type>SoFieldEntry *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoFieldEntry * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoFieldEntry *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoFieldEntry * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoFieldEntry * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoFieldEntry * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoGLDisplayList * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoGLDisplayList * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoGLDisplayList * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoGLDisplayList * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoGLDisplayList * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoGLDisplayList * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoGLDisplayList * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoGLDisplayList * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoGLDisplayList * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoGLDisplayList * item)</arglist>
    </member>
    <member kind="function">
      <type>SoGLDisplayList *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoGLDisplayList * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoGLDisplayList *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoGLDisplayList * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoGLDisplayList * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoGLDisplayList * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoGLDriver * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoGLDriver * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoGLDriver * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoGLDriver * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoGLDriver * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoGLDriver * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoGLDriver * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoGLDriver * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoGLDriver * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoGLDriver * item)</arglist>
    </member>
    <member kind="function">
      <type>SoGLDriver *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoGLDriver * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoGLDriver *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoGLDriver * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoGLDriver * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoGLDriver * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoGLMultiTextureCoordinateElement::GLUnitData &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoGLMultiTextureCoordinateElement::GLUnitData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoGLMultiTextureCoordinateElement::GLUnitData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoGLMultiTextureCoordinateElement::GLUnitData &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoGLMultiTextureCoordinateElement::GLUnitData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoGLMultiTextureCoordinateElement::GLUnitData item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoGLMultiTextureCoordinateElement::GLUnitData item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoGLMultiTextureCoordinateElement::GLUnitData item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoGLMultiTextureCoordinateElement::GLUnitData item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoGLMultiTextureCoordinateElement::GLUnitData item)</arglist>
    </member>
    <member kind="function">
      <type>SoGLMultiTextureCoordinateElement::GLUnitData</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoGLMultiTextureCoordinateElement::GLUnitData *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoGLMultiTextureCoordinateElement::GLUnitData</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoGLMultiTextureCoordinateElement::GLUnitData &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoGLMultiTextureCoordinateElement::GLUnitData &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoGLMultiTextureCoordinateElement::GLUnitData &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoGLMultiTextureImageElement::GLUnitData &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoGLMultiTextureImageElement::GLUnitData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoGLMultiTextureImageElement::GLUnitData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoGLMultiTextureImageElement::GLUnitData &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoGLMultiTextureImageElement::GLUnitData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoGLMultiTextureImageElement::GLUnitData item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoGLMultiTextureImageElement::GLUnitData item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoGLMultiTextureImageElement::GLUnitData item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoGLMultiTextureImageElement::GLUnitData item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoGLMultiTextureImageElement::GLUnitData item)</arglist>
    </member>
    <member kind="function">
      <type>SoGLMultiTextureImageElement::GLUnitData</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoGLMultiTextureImageElement::GLUnitData *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoGLMultiTextureImageElement::GLUnitData</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoGLMultiTextureImageElement::GLUnitData &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoGLMultiTextureImageElement::GLUnitData &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoGLMultiTextureImageElement::GLUnitData &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoGLRenderCache * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoGLRenderCache * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoGLRenderCache * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoGLRenderCache * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoGLRenderCache * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoGLRenderCache * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoGLRenderCache * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoGLRenderCache * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoGLRenderCache * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoGLRenderCache * item)</arglist>
    </member>
    <member kind="function">
      <type>SoGLRenderCache *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoGLRenderCache * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoGLRenderCache *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoGLRenderCache * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoGLRenderCache * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoGLRenderCache * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoInput_FileInfo * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoInput_FileInfo * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoInput_FileInfo * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoInput_FileInfo * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoInput_FileInfo * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoInput_FileInfo * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoInput_FileInfo * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoInput_FileInfo * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoInput_FileInfo * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoInput_FileInfo * item)</arglist>
    </member>
    <member kind="function">
      <type>SoInput_FileInfo *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoInput_FileInfo * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoInput_FileInfo *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoInput_FileInfo * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoInput_FileInfo * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoInput_FileInfo * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoMultiTextureCoordinateElement::UnitData &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoMultiTextureCoordinateElement::UnitData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoMultiTextureCoordinateElement::UnitData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoMultiTextureCoordinateElement::UnitData &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoMultiTextureCoordinateElement::UnitData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoMultiTextureCoordinateElement::UnitData item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoMultiTextureCoordinateElement::UnitData item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoMultiTextureCoordinateElement::UnitData item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoMultiTextureCoordinateElement::UnitData item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoMultiTextureCoordinateElement::UnitData item)</arglist>
    </member>
    <member kind="function">
      <type>SoMultiTextureCoordinateElement::UnitData</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoMultiTextureCoordinateElement::UnitData *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoMultiTextureCoordinateElement::UnitData</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoMultiTextureCoordinateElement::UnitData &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoMultiTextureCoordinateElement::UnitData &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoMultiTextureCoordinateElement::UnitData &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoMultiTextureEnabledElement::Mode &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoMultiTextureEnabledElement::Mode &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoMultiTextureEnabledElement::Mode &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoMultiTextureEnabledElement::Mode &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoMultiTextureEnabledElement::Mode &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoMultiTextureEnabledElement::Mode item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoMultiTextureEnabledElement::Mode item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoMultiTextureEnabledElement::Mode item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoMultiTextureEnabledElement::Mode item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoMultiTextureEnabledElement::Mode item)</arglist>
    </member>
    <member kind="function">
      <type>SoMultiTextureEnabledElement::Mode</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoMultiTextureEnabledElement::Mode *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoMultiTextureEnabledElement::Mode</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoMultiTextureEnabledElement::Mode &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoMultiTextureEnabledElement::Mode &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoMultiTextureEnabledElement::Mode &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoMultiTextureImageElement::UnitData &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoMultiTextureImageElement::UnitData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoMultiTextureImageElement::UnitData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoMultiTextureImageElement::UnitData &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoMultiTextureImageElement::UnitData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoMultiTextureImageElement::UnitData item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoMultiTextureImageElement::UnitData item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoMultiTextureImageElement::UnitData item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoMultiTextureImageElement::UnitData item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoMultiTextureImageElement::UnitData item)</arglist>
    </member>
    <member kind="function">
      <type>SoMultiTextureImageElement::UnitData</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoMultiTextureImageElement::UnitData *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoMultiTextureImageElement::UnitData</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoMultiTextureImageElement::UnitData &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoMultiTextureImageElement::UnitData &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoMultiTextureImageElement::UnitData &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoMultiTextureMatrixElement::UnitData &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoMultiTextureMatrixElement::UnitData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoMultiTextureMatrixElement::UnitData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoMultiTextureMatrixElement::UnitData &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoMultiTextureMatrixElement::UnitData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoMultiTextureMatrixElement::UnitData item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoMultiTextureMatrixElement::UnitData item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoMultiTextureMatrixElement::UnitData item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoMultiTextureMatrixElement::UnitData item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoMultiTextureMatrixElement::UnitData item)</arglist>
    </member>
    <member kind="function">
      <type>SoMultiTextureMatrixElement::UnitData</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoMultiTextureMatrixElement::UnitData *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoMultiTextureMatrixElement::UnitData</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoMultiTextureMatrixElement::UnitData &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoMultiTextureMatrixElement::UnitData &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoMultiTextureMatrixElement::UnitData &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoNode * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoNode * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoNode * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoNode * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoNode * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoNode * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoNode * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoNode * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoNode * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoNode * item)</arglist>
    </member>
    <member kind="function">
      <type>SoNode *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoNode * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoNode *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoNode * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoNode * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoNode * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoOutputDataEntry * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoOutputDataEntry * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoOutputDataEntry * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoOutputDataEntry * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoOutputDataEntry * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoOutputDataEntry * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoOutputDataEntry * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoOutputDataEntry * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoOutputDataEntry * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoOutputDataEntry * item)</arglist>
    </member>
    <member kind="function">
      <type>SoOutputDataEntry *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoOutputDataEntry * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoOutputDataEntry *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoOutputDataEntry * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoOutputDataEntry * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoOutputDataEntry * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoOutputROUTE &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoOutputROUTE &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoOutputROUTE &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoOutputROUTE &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoOutputROUTE &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoOutputROUTE item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoOutputROUTE item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoOutputROUTE item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoOutputROUTE item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoOutputROUTE item)</arglist>
    </member>
    <member kind="function">
      <type>SoOutputROUTE</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoOutputROUTE *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoOutputROUTE</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoOutputROUTE &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoOutputROUTE &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoOutputROUTE &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoOutputROUTEList * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoOutputROUTEList * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoOutputROUTEList * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoOutputROUTEList * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoOutputROUTEList * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoOutputROUTEList * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoOutputROUTEList * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoOutputROUTEList * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoOutputROUTEList * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoOutputROUTEList * item)</arglist>
    </member>
    <member kind="function">
      <type>SoOutputROUTEList *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoOutputROUTEList * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoOutputROUTEList *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoOutputROUTEList * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoOutputROUTEList * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoOutputROUTEList * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoPath * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoPath * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoPath * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoPath * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoPath * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoPath * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoPath * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoPath * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoPath * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoPath * item)</arglist>
    </member>
    <member kind="function">
      <type>SoPath *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoPath * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoPath *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoPath * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoPath * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoPath * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoProto * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoProto * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoProto * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoProto * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoProto * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoProto * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoProto * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoProto * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoProto * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoProto * item)</arglist>
    </member>
    <member kind="function">
      <type>SoProto *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoProto * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoProto *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoProto * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoProto * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoProto * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoSFNode * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoSFNode * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoSFNode * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoSFNode * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoSFNode * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoSFNode * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoSFNode * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoSFNode * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoSFNode * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoSFNode * item)</arglist>
    </member>
    <member kind="function">
      <type>SoSFNode *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoSFNode * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoSFNode *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoSFNode * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoSFNode * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoSFNode * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoShadowLightCache * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoShadowLightCache * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoShadowLightCache * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoShadowLightCache * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoShadowLightCache * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoShadowLightCache * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoShadowLightCache * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoShadowLightCache * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoShadowLightCache * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoShadowLightCache * item)</arglist>
    </member>
    <member kind="function">
      <type>SoShadowLightCache *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoShadowLightCache * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoShadowLightCache *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoShadowLightCache * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoShadowLightCache * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoShadowLightCache * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; soshape_bigtexture * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; soshape_bigtexture * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; soshape_bigtexture * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; soshape_bigtexture * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; soshape_bigtexture * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const soshape_bigtexture * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const soshape_bigtexture * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const soshape_bigtexture * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const soshape_bigtexture * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const soshape_bigtexture * item)</arglist>
    </member>
    <member kind="function">
      <type>soshape_bigtexture *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const soshape_bigtexture * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>soshape_bigtexture *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>soshape_bigtexture * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; soshape_bigtexture * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; soshape_bigtexture * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoTempPath * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoTempPath * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoTempPath * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoTempPath * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoTempPath * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoTempPath * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoTempPath * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoTempPath * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoTempPath * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoTempPath * item)</arglist>
    </member>
    <member kind="function">
      <type>SoTempPath *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoTempPath * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoTempPath *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoTempPath * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoTempPath * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoTempPath * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoTextureCombineElement::UnitData &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoTextureCombineElement::UnitData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoTextureCombineElement::UnitData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoTextureCombineElement::UnitData &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoTextureCombineElement::UnitData &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoTextureCombineElement::UnitData item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoTextureCombineElement::UnitData item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoTextureCombineElement::UnitData item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoTextureCombineElement::UnitData item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoTextureCombineElement::UnitData item)</arglist>
    </member>
    <member kind="function">
      <type>SoTextureCombineElement::UnitData</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoTextureCombineElement::UnitData *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoTextureCombineElement::UnitData</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoTextureCombineElement::UnitData &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoTextureCombineElement::UnitData &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoTextureCombineElement::UnitData &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoTimerQueueSensor * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoTimerQueueSensor * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoTimerQueueSensor * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoTimerQueueSensor * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoTimerQueueSensor * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoTimerQueueSensor * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoTimerQueueSensor * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoTimerQueueSensor * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoTimerQueueSensor * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoTimerQueueSensor * item)</arglist>
    </member>
    <member kind="function">
      <type>SoTimerQueueSensor *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoTimerQueueSensor * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoTimerQueueSensor *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoTimerQueueSensor * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoTimerQueueSensor * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoTimerQueueSensor * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoTimerSensor * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoTimerSensor * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoTimerSensor * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoTimerSensor * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoTimerSensor * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoTimerSensor * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoTimerSensor * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoTimerSensor * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoTimerSensor * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoTimerSensor * item)</arglist>
    </member>
    <member kind="function">
      <type>SoTimerSensor *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoTimerSensor * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoTimerSensor *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoTimerSensor * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoTimerSensor * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoTimerSensor * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoTypeData * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoTypeData * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoTypeData * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoTypeData * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoTypeData * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoTypeData * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoTypeData * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoTypeData * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoTypeData * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoTypeData * item)</arglist>
    </member>
    <member kind="function">
      <type>SoTypeData *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoTypeData * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoTypeData *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoTypeData * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoTypeData * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoTypeData * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoVBO * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoVBO * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoVBO * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoVBO * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoVBO * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoVBO * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoVBO * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoVBO * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoVBO * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoVBO * item)</arglist>
    </member>
    <member kind="function">
      <type>SoVBO *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoVBO * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoVBO *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoVBO * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoVBO * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoVBO * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoVRMLColor * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoVRMLColor * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoVRMLColor * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoVRMLColor * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoVRMLColor * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoVRMLColor * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoVRMLColor * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoVRMLColor * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoVRMLColor * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoVRMLColor * item)</arglist>
    </member>
    <member kind="function">
      <type>SoVRMLColor *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoVRMLColor * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoVRMLColor *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoVRMLColor * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoVRMLColor * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoVRMLColor * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoVRMLCoordinate * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoVRMLCoordinate * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoVRMLCoordinate * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoVRMLCoordinate * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoVRMLCoordinate * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoVRMLCoordinate * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoVRMLCoordinate * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoVRMLCoordinate * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoVRMLCoordinate * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoVRMLCoordinate * item)</arglist>
    </member>
    <member kind="function">
      <type>SoVRMLCoordinate *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoVRMLCoordinate * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoVRMLCoordinate *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoVRMLCoordinate * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoVRMLCoordinate * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoVRMLCoordinate * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoVRMLGroup * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoVRMLGroup * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoVRMLGroup * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoVRMLGroup * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoVRMLGroup * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoVRMLGroup * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoVRMLGroup * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoVRMLGroup * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoVRMLGroup * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoVRMLGroup * item)</arglist>
    </member>
    <member kind="function">
      <type>SoVRMLGroup *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoVRMLGroup * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoVRMLGroup *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoVRMLGroup * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoVRMLGroup * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoVRMLGroup * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoVRMLNormal * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoVRMLNormal * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoVRMLNormal * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoVRMLNormal * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoVRMLNormal * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoVRMLNormal * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoVRMLNormal * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoVRMLNormal * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoVRMLNormal * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoVRMLNormal * item)</arglist>
    </member>
    <member kind="function">
      <type>SoVRMLNormal *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoVRMLNormal * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoVRMLNormal *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoVRMLNormal * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoVRMLNormal * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoVRMLNormal * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; SoVRMLTextureCoordinate * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; SoVRMLTextureCoordinate * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; SoVRMLTextureCoordinate * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; SoVRMLTextureCoordinate * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; SoVRMLTextureCoordinate * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const SoVRMLTextureCoordinate * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const SoVRMLTextureCoordinate * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const SoVRMLTextureCoordinate * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const SoVRMLTextureCoordinate * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const SoVRMLTextureCoordinate * item)</arglist>
    </member>
    <member kind="function">
      <type>SoVRMLTextureCoordinate *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoVRMLTextureCoordinate * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>SoVRMLTextureCoordinate *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>SoVRMLTextureCoordinate * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; SoVRMLTextureCoordinate * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; SoVRMLTextureCoordinate * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; struct so_eval_node * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; struct so_eval_node * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; struct so_eval_node * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; struct so_eval_node * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; struct so_eval_node * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const struct so_eval_node * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const struct so_eval_node * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const struct so_eval_node * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const struct so_eval_node * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const struct so_eval_node * item)</arglist>
    </member>
    <member kind="function">
      <type>struct so_eval_node *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const struct so_eval_node * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>struct so_eval_node *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>struct so_eval_node * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; struct so_eval_node * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; struct so_eval_node * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; struct Vertex * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; struct Vertex * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; struct Vertex * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; struct Vertex * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; struct Vertex * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const struct Vertex * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const struct Vertex * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const struct Vertex * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const struct Vertex * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const struct Vertex * item)</arglist>
    </member>
    <member kind="function">
      <type>struct Vertex *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const struct Vertex * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>struct Vertex *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>struct Vertex * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; struct Vertex * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; struct Vertex * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; uint16_t &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; uint16_t &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; uint16_t &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; uint16_t &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; uint16_t &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const uint16_t item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const uint16_t item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const uint16_t item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const uint16_t item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const uint16_t item)</arglist>
    </member>
    <member kind="function">
      <type>uint16_t</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const uint16_t *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>uint16_t</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>uint16_t &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; uint16_t &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; uint16_t &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; uint32_t &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; uint32_t &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; uint32_t &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; uint32_t &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; uint32_t &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const uint32_t item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const uint32_t item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const uint32_t item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const uint32_t item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const uint32_t item)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const uint32_t *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>uint32_t &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; uint32_t &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; uint32_t &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; uint8_t &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; uint8_t &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; uint8_t &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; uint8_t &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; uint8_t &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const uint8_t item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const uint8_t item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const uint8_t item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const uint8_t item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const uint8_t item)</arglist>
    </member>
    <member kind="function">
      <type>uint8_t</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const uint8_t *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>uint8_t</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>uint8_t &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; uint8_t &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; uint8_t &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; unsigned int &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; unsigned int &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; unsigned int &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; unsigned int &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; unsigned int &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const unsigned int item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const unsigned int item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const unsigned int item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const unsigned int item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const unsigned int item)</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const unsigned int *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>unsigned int &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; unsigned int &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; unsigned int &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; versionrange &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; versionrange &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; versionrange &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; versionrange &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; versionrange &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const versionrange item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const versionrange item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const versionrange item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const versionrange item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const versionrange item)</arglist>
    </member>
    <member kind="function">
      <type>versionrange</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const versionrange *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>versionrange</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>versionrange &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; versionrange &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; versionrange &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; Vertex &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; Vertex &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; Vertex &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; Vertex &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; Vertex &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const Vertex item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const Vertex item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const Vertex item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const Vertex item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const Vertex item)</arglist>
    </member>
    <member kind="function">
      <type>Vertex</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const Vertex *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>Vertex</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>Vertex &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; Vertex &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; Vertex &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList&lt; void * &gt;</name>
    <filename>classSbList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; void * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; void * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; void * &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; void * &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const void * item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a26e05d15760755bad07c729bf83f46b0</anchor>
      <arglist>(const void * item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const void * item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const void * item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0eefe70ca4d6d829657e3e8f70f64595</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const void * item)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const void * *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a9cb1e3df191a7c8868a6367b92950eb2</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af3d4a59556a9dbbcf041a7c4d9fcbbc4</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>void * &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>acdd08e7aa8935c8e2acc1391768d6d50</anchor>
      <arglist>(const SbList&lt; void * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a81811bcc8c46203bd47e10688fbaa771</anchor>
      <arglist>(const SbList&lt; void * &gt; &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a90d63796f5e520d51df7892923795416</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbMatrix</name>
    <filename>classSbMatrix.html</filename>
    <member kind="function">
      <type></type>
      <name>SbMatrix</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>aa9c543c99277c8efe81ecaa27d2977a3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbMatrix</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>af4f62a6e3d63538dc5660b59592f3559</anchor>
      <arglist>(const float a11, const float a12, const float a13, const float a14, const float a21, const float a22, const float a23, const float a24, const float a31, const float a32, const float a33, const float a34, const float a41, const float a42, const float a43, const float a44)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbMatrix</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a11cc61c8a398ca99f727c24e9dac5145</anchor>
      <arglist>(const SbMat &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbMatrix</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a14a38bb0c23bd9899b73e1cf6d42674f</anchor>
      <arglist>(const SbMat *matrix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbMatrix</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a8e36c51695b7f881e6527a0171e4b59b</anchor>
      <arglist>(const SbDPMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbMatrix</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a56c2af917e531b6a2c689277da0e5e40</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a823e51aa6487c9445f08520664bb0f24</anchor>
      <arglist>(const SbMat &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a336dcb30ce4faaac2f0ad661b3c611d4</anchor>
      <arglist>(const SbDPMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a64f74a53cfa9fa179febed9c526a5e5a</anchor>
      <arglist>(const float *pMat)</arglist>
    </member>
    <member kind="function">
      <type>const SbMat &amp;</type>
      <name>getValue</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a014acdd070149546d6690c25998a548d</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeIdentity</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>aa3932a07fef33751bea1d2afad98dd80</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRotate</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>ad980a0a21520443af5f27ad2c3a0ac4d</anchor>
      <arglist>(const SbRotation &amp;q)</arglist>
    </member>
    <member kind="function">
      <type>SbMatrix</type>
      <name>inverse</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a30283aaf0c69cc06a48103521d1afb02</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>det3</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>aad2fa84564d647f0d59ec9292043e7a6</anchor>
      <arglist>(int r1, int r2, int r3, int c1, int c2, int c3) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>det3</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>aa7511fa93110f04114d47ace3075da6b</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>det4</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>ad969ead9bfe886b53331aaba7bfc58e5</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>equals</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a144ee908dfcb56e96543ef07638d8cdb</anchor>
      <arglist>(const SbMatrix &amp;m, float tolerance) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>afb18f1588e9b2000c0130af2dd68c2c9</anchor>
      <arglist>(SbMat &amp;m) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setScale</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>ac3fe68df7dff290a61a29ee3494559fb</anchor>
      <arglist>(const float s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setScale</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a20666edc6bd3449c8121213504e2d779</anchor>
      <arglist>(const SbVec3f &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTranslate</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a9e7499122cfa98b5e3eec4832248343d</anchor>
      <arglist>(const SbVec3f &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTransform</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>ab213f7106629056c14f92d7cca1b0e40</anchor>
      <arglist>(const SbVec3f &amp;t, const SbRotation &amp;r, const SbVec3f &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTransform</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a35048991968e198707e5186ac9c12c68</anchor>
      <arglist>(const SbVec3f &amp;t, const SbRotation &amp;r, const SbVec3f &amp;s, const SbRotation &amp;so)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTransform</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>aaa26b5ff6e108f1ad44552320dec9375</anchor>
      <arglist>(const SbVec3f &amp;translation, const SbRotation &amp;rotation, const SbVec3f &amp;scaleFactor, const SbRotation &amp;scaleOrientation, const SbVec3f &amp;center)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getTransform</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a5b40e19cb8f6b1dce441347427f66a00</anchor>
      <arglist>(SbVec3f &amp;t, SbRotation &amp;r, SbVec3f &amp;s, SbRotation &amp;so) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getTransform</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a53e528234893981b74a164d04fe11c90</anchor>
      <arglist>(SbVec3f &amp;translation, SbRotation &amp;rotation, SbVec3f &amp;scaleFactor, SbRotation &amp;scaleOrientation, const SbVec3f &amp;center) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>factor</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a34d355d437c12b71cffcf6aca2deada8</anchor>
      <arglist>(SbMatrix &amp;r, SbVec3f &amp;s, SbMatrix &amp;u, SbVec3f &amp;t, SbMatrix &amp;proj) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>LUDecomposition</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a44442a984a6db189e521b8e599187eb3</anchor>
      <arglist>(int index[4], float &amp;d)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>LUBackSubstitution</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a152cfcf7f9d158d774e73c6e3f685e23</anchor>
      <arglist>(int index[4], float b[4]) const</arglist>
    </member>
    <member kind="function">
      <type>SbMatrix</type>
      <name>transpose</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a16554414e4ac02b86429c6d1f639a4bd</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbMatrix &amp;</type>
      <name>multRight</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a95c83d6772896a1c592d9f02ef9b9b73</anchor>
      <arglist>(const SbMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>SbMatrix &amp;</type>
      <name>multLeft</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a9fb67deb0eba537ad84e4a7064ced20d</anchor>
      <arglist>(const SbMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multMatrixVec</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>aea4a11ce7d02434760a7e3b62ff94f8f</anchor>
      <arglist>(const SbVec3f &amp;src, SbVec3f &amp;dst) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multVecMatrix</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>ac50a48e4adf51ec4310fe27f83c5ca62</anchor>
      <arglist>(const SbVec3f &amp;src, SbVec3f &amp;dst) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multDirMatrix</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a8da4ce9743a4f8f0db336281c735eea6</anchor>
      <arglist>(const SbVec3f &amp;src, SbVec3f &amp;dst) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multLineMatrix</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a245e826e0e4eef8dcf07c0b96bbbcca4</anchor>
      <arglist>(const SbLine &amp;src, SbLine &amp;dst) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multVecMatrix</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a1e84df12b21758f33c717921f9a97e7d</anchor>
      <arglist>(const SbVec4f &amp;src, SbVec4f &amp;dst) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a7a5760fae1e64cb480577c9e2ed83aca</anchor>
      <arglist>(FILE *fp) const</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator float *</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a2e9cb965db606983daab26f713cd85bd</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator SbMat &amp;</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a68ebdb48cc42675a9608de80ac995b03</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>float *</type>
      <name>operator []</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a5001b1879eb54606e9a9add33ebfa00d</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>const float *</type>
      <name>operator []</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>ad1c5a1f439c7bda6742d753943a3b55e</anchor>
      <arglist>(int i) const</arglist>
    </member>
    <member kind="function">
      <type>SbMatrix &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>ab923719276439757ba9c351af0d48645</anchor>
      <arglist>(const SbMat &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>SbMatrix &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a53b9da1c1ed8a4aabe50962719b16f21</anchor>
      <arglist>(const SbMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>SbMatrix &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a2f48f009fcc63c5ccb7a7c49bc80d03a</anchor>
      <arglist>(const SbRotation &amp;q)</arglist>
    </member>
    <member kind="function">
      <type>SbMatrix &amp;</type>
      <name>operator *=</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a30f88b939aa104b95fbf6e7d14e80359</anchor>
      <arglist>(const SbMatrix &amp;m)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbMatrix</type>
      <name>identity</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>adc24591ea5071d7d8f18eee7066c36e3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbMatrix</type>
      <name>operator *</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a95d715c1f29d9ea051a243481bd3b254</anchor>
      <arglist>(const SbMatrix &amp;m1, const SbMatrix &amp;m2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>abf8843860b5e03a0061ebe2ec9d8a9ad</anchor>
      <arglist>(const SbMatrix &amp;m1, const SbMatrix &amp;m2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator !=</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a6cc14f91f3c76e40802a39a0f8fc7d5f</anchor>
      <arglist>(const SbMatrix &amp;m1, const SbMatrix &amp;m2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbMutex</name>
    <filename>classSbMutex.html</filename>
  </compound>
  <compound kind="class">
    <name>SbName</name>
    <filename>classSbName.html</filename>
    <member kind="function">
      <type></type>
      <name>SbName</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>ad6a4c7d4f516d74b22a0f054065c4d1b</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbName</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>ab724be41e08ba30cbe70bca6bb0f6920</anchor>
      <arglist>(const char *namestring)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbName</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>ab523d9d8a9ebe1a7e7d7206579cba24f</anchor>
      <arglist>(const SbString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbName</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a29e5b8239dd822004d5a332bfecec96e</anchor>
      <arglist>(const SbName &amp;name)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbName</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a727ed1c947b2f9a7f00216489af3fa5d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>getString</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>af4025fc41df3195e640c748da108033e</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a891658302e137d5bebf78c98a54a8fb9</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>ab7b1caa800e980943296136f6d58243b</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator const char *</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>ae2b38a6bf78b52a4239b9b27360dd5f6</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbBool</type>
      <name>isIdentStartChar</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a8542c60491baad59191fa04c8f05c7ff</anchor>
      <arglist>(const char c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbBool</type>
      <name>isIdentChar</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a3f201ffe519350d5ae06f31fc30ed9c9</anchor>
      <arglist>(const char c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbBool</type>
      <name>isBaseNameStartChar</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>ab4e8fb488f254fda26e22055223ecf0e</anchor>
      <arglist>(const char c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbBool</type>
      <name>isBaseNameChar</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>ad4c80d5dd355792ef2406f09d47b42de</anchor>
      <arglist>(const char c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const SbName &amp;</type>
      <name>empty</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a20587288b45a68e953a08428640afcc9</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a1a9e2e87224f997e7b85ea4270f31491</anchor>
      <arglist>(const SbName &amp;lhs, const char *rhs)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a11b92ad49c0bd13adc4cfa5bbaa4ff0d</anchor>
      <arglist>(const char *lhs, const SbName &amp;rhs)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>af664e0fe96b220633d87506098c586ff</anchor>
      <arglist>(const SbName &amp;lhs, const SbName &amp;rhs)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a817a20561fe7a7cc170a871975806296</anchor>
      <arglist>(const SbName &amp;lhs, const char *rhs)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>aed52cb7e045ed247aba2ca9e0715c031</anchor>
      <arglist>(const char *lhs, const SbName &amp;rhs)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a29000d9ba142f3ad44fb42b0c9b9baf3</anchor>
      <arglist>(const SbName &amp;lhs, const SbName &amp;rhs)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbOctTree</name>
    <filename>classSbOctTree.html</filename>
    <member kind="function">
      <type></type>
      <name>SbOctTree</name>
      <anchorfile>classSbOctTree.html</anchorfile>
      <anchor>add70351f00eacc285ac91c8394af6f84</anchor>
      <arglist>(const SbBox3f &amp;bbox, const SbOctTreeFuncs &amp;itemfuncs, const int maxitemspernode=64)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbOctTree</name>
      <anchorfile>classSbOctTree.html</anchorfile>
      <anchor>ab9a58a484f6eacacce9b5d91943abd7b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addItem</name>
      <anchorfile>classSbOctTree.html</anchorfile>
      <anchor>abe0d819501c3e600783942cffb2b157f</anchor>
      <arglist>(void *const item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbOctTree.html</anchorfile>
      <anchor>a0960def43c29ed624d0da49241db7d77</anchor>
      <arglist>(void *const item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>findItems</name>
      <anchorfile>classSbOctTree.html</anchorfile>
      <anchor>acc5cc991823078fe0cda606f9d1a22b2</anchor>
      <arglist>(const SbVec3f &amp;pos, SbList&lt; void * &gt; &amp;destarray, const SbBool removeduplicates=TRUE) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>findItems</name>
      <anchorfile>classSbOctTree.html</anchorfile>
      <anchor>a478d6cb1237c3243f6ee70a603773cfd</anchor>
      <arglist>(const SbBox3f &amp;box, SbList&lt; void * &gt; &amp;destarray, const SbBool removeduplicates=TRUE) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>findItems</name>
      <anchorfile>classSbOctTree.html</anchorfile>
      <anchor>a16b1bd954d5db4614957c6d246d94a9a</anchor>
      <arglist>(const SbSphere &amp;sphere, SbList&lt; void * &gt; &amp;destarray, const SbBool removeduplicates=TRUE) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>findItems</name>
      <anchorfile>classSbOctTree.html</anchorfile>
      <anchor>a113a7d7b14b2a3a250b8810181b39ba0</anchor>
      <arglist>(const SbPlane *const planes, const int numplanes, SbList&lt; void * &gt; &amp;destarray, const SbBool removeduplicates=TRUE) const</arglist>
    </member>
    <member kind="function">
      <type>const SbBox3f &amp;</type>
      <name>getBoundingBox</name>
      <anchorfile>classSbOctTree.html</anchorfile>
      <anchor>a7698bf6f6f00b0fe0431f0758dc16225</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>classSbOctTree.html</anchorfile>
      <anchor>a40ce23dda004f6b4a6c97a488286b0c7</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>SbOctTreeFuncs</name>
    <filename>structSbOctTreeFuncs.html</filename>
    <member kind="variable">
      <type>SbBool(*</type>
      <name>ptinsidefunc</name>
      <anchorfile>structSbOctTreeFuncs.html</anchorfile>
      <anchor>a5450fad1a556bcb0788817e5a39fc16e</anchor>
      <arglist>)(void *const item, const SbVec3f &amp;pt)</arglist>
    </member>
    <member kind="variable">
      <type>SbBool(*</type>
      <name>insideboxfunc</name>
      <anchorfile>structSbOctTreeFuncs.html</anchorfile>
      <anchor>a19dbec3e9e9c84894d8cad53143af732</anchor>
      <arglist>)(void *const item, const SbBox3f &amp;box)</arglist>
    </member>
    <member kind="variable">
      <type>SbBool(*</type>
      <name>insidespherefunc</name>
      <anchorfile>structSbOctTreeFuncs.html</anchorfile>
      <anchor>a39db96f6e92c0ca5734f0ae3158a75a7</anchor>
      <arglist>)(void *const item, const SbSphere &amp;sphere)</arglist>
    </member>
    <member kind="variable">
      <type>SbBool(*</type>
      <name>insideplanesfunc</name>
      <anchorfile>structSbOctTreeFuncs.html</anchorfile>
      <anchor>a755d9f3c5dcab3bfbaf8ac46c17c537f</anchor>
      <arglist>)(void *const item, const SbPlane *const planes, const int numplanes)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr</name>
    <filename>classSbPimplPtr.html</filename>
    <templarg>T</templarg>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; class SoNodeVisualizeP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; class SoProfilerStatsP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; PImpl &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SbProfilingDataP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoActionP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoBoxHighlightRenderActionP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoCallbackActionP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoDraggerP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoGeoCoordinateP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoGLRenderActionP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoHandleEventActionP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoLineHighlightRenderActionP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoMaterialP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoPrimitiveVertexCacheP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoProfilerTopEngineP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoProfilerTopKitP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoProfilerVisualizeKitP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoRayPickActionP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoReorganizeActionP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoScrollingGraphKitP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoSeparatorP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoSimplifyActionP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoToVRML2ActionP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoToVRMLActionP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoTrackballDraggerP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoTransformerDraggerP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoTranslate2DraggerP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoVertexAttributeElementP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPimplPtr&lt; SoVertexAttributeP &gt;</name>
    <filename>classSbPimplPtr.html</filename>
  </compound>
  <compound kind="class">
    <name>SbPlane</name>
    <filename>classSbPlane.html</filename>
    <member kind="function">
      <type></type>
      <name>SbPlane</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>a1db5bae636297d29cc50435cd2f85cde</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbPlane</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>a9d318bb4c7e48e81dfee4248048b3c0b</anchor>
      <arglist>(const SbVec3f &amp;normal, const float D)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbPlane</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>acb9fc24accebfae55bc56cd1deda2aa7</anchor>
      <arglist>(const SbVec3f &amp;p0, const SbVec3f &amp;p1, const SbVec3f &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbPlane</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>aed3e3d54f30693e031efd3373f35a25c</anchor>
      <arglist>(const SbVec3f &amp;normal, const SbVec3f &amp;point)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>offset</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>a324e8467ece2b14d3cd993d471862a6e</anchor>
      <arglist>(const float d)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>a092d50c631e724272b159d9282bb13d0</anchor>
      <arglist>(const SbLine &amp;l, SbVec3f &amp;intersection) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transform</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>a383bc77412bbf7173e96a8e14e5a3325</anchor>
      <arglist>(const SbMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isInHalfSpace</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>af2d80f1912f7461a2df55a307743bbcf</anchor>
      <arglist>(const SbVec3f &amp;point) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getDistance</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>a36196c263ddf636532d382b69f7c8358</anchor>
      <arglist>(const SbVec3f &amp;point) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f &amp;</type>
      <name>getNormal</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>af654675126c52ebf2ef5e609a4c0186a</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getDistanceFromOrigin</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>a1db9ed95eb258aa44989ae83f549b853</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>a0395550dec1a537e6801cfaa376425b9</anchor>
      <arglist>(FILE *file) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>a997ff4e34ebbec65b7ddd964b66a96ea</anchor>
      <arglist>(const SbPlane &amp;pl, SbLine &amp;line) const</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>a8830930d3c1f38ec5d41cc9b5416a142</anchor>
      <arglist>(const SbPlane &amp;p1, const SbPlane &amp;p2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator !=</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>a191c74014705f8bd115fbe7ee8732f9a</anchor>
      <arglist>(const SbPlane &amp;p1, const SbPlane &amp;p2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbPlaneProjector</name>
    <filename>classSbPlaneProjector.html</filename>
    <base>SbProjector</base>
    <member kind="function">
      <type></type>
      <name>SbPlaneProjector</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a17fb773d8a14e7c0a2099cf062f41f44</anchor>
      <arglist>(const SbBool orient=FALSE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbPlaneProjector</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a3ef8017b79f7ddb0114cf1b4ac2cdcdc</anchor>
      <arglist>(const SbPlane &amp;plane, const SbBool orient=FALSE)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbProjector *</type>
      <name>copy</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a11765ac0bd05fba1191e9cfe54d1f96a</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>project</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>af53fe67381ccac9b29de56c243ab5243</anchor>
      <arglist>(const SbVec2f &amp;point)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>tryProject</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a56924db7500b49c135112a478e0544ba</anchor>
      <arglist>(const SbVec2f &amp;point, const float epsilon, SbVec3f &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPlane</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a87b6cc3c0b0081f6794283c08bf6a815</anchor>
      <arglist>(const SbPlane &amp;plane)</arglist>
    </member>
    <member kind="function">
      <type>const SbPlane &amp;</type>
      <name>getPlane</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>abc557b5b53cf5f80117c6b566cc379e2</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOrientToEye</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a338c5c92203c71af31467f53e7ca067e</anchor>
      <arglist>(const SbBool orienttoeye)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isOrientToEye</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>ac6771fce84b956870d6a33423a3de23d</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>getVector</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a71bff22fade60bab1dff0712fc9c1b09</anchor>
      <arglist>(const SbVec2f &amp;viewpos1, const SbVec2f &amp;viewpos2)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>getVector</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a4078f3a50298f318235dd7385db0c82c</anchor>
      <arglist>(const SbVec2f &amp;viewpos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStartPosition</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a313f157900e6b80cee0bcb7247966d9a</anchor>
      <arglist>(const SbVec2f &amp;viewpos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStartPosition</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a2b9100b73f90134a2f178ea73b5d2a57</anchor>
      <arglist>(const SbVec3f &amp;point)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>setupPlane</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a688bfaa1b95d749458ffb137314c5703</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbPlane</type>
      <name>plane</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a285bd75831659701d3be8e67233d9b39</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbPlane</type>
      <name>nonOrientPlane</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a1306a57449db989650f04758486d3951</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbBool</type>
      <name>orientToEye</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a217fdecb25351d4f4b83ebbf061e52a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbBool</type>
      <name>needSetup</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>aca42872fdc02d9914112c9d9c85c6a3d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>lastPoint</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>afbd27c654699465a946209f344b94d72</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbPList</name>
    <filename>classSbPList.html</filename>
    <member kind="function">
      <type></type>
      <name>SbPList</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>aa7f2d079fc9b7f79159c52bfc84c1903</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbPList</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>af811d0ca4b528e41ded787620a098302</anchor>
      <arglist>(const SbPList &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbPList</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>abd1d6b798ff7e7ca94a2c0cd421a99b5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>afde90b2b3d0a9f12bdf0525bc6f8dd95</anchor>
      <arglist>(const SbPList &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbPList &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>aebfa0b8e1ecc80d7fa4b290bcc0a63d4</anchor>
      <arglist>(const SbPList &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a74b60d94666a2e26bfd8d594093171b3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a61404440e153af0870eac6183d09fc04</anchor>
      <arglist>(void *item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>afc68999bc3396ed5b5a0c8fcc897e30d</anchor>
      <arglist>(const void *item) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>af500b13baee20036c51b7746c9b046b0</anchor>
      <arglist>(void *item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a4e876aa0634c39c25d6492a70691341d</anchor>
      <arglist>(void *item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a6a4deead2d652da76afce4a6d6cbf755</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a85f37433e030fb1845a1f210098b805d</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a6a5fdef8d0e2776880391f3b9a5fbb9e</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>ac32c857e4308dd6b638275d90ea6fc60</anchor>
      <arglist>(const int length, const int fit=0)</arglist>
    </member>
    <member kind="function">
      <type>void **</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a0db71b9548f20b68aec5a97b817cf53c</anchor>
      <arglist>(const int start=0) const</arglist>
    </member>
    <member kind="function">
      <type>void *&amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a8f4ae28407482bca1ee8c6c7d67a1584</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>ad7c01f46b58ee4dd83c4698ee4654d47</anchor>
      <arglist>(const SbPList &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a2dfca1a5e7f9506ea974251404861820</anchor>
      <arglist>(const SbPList &amp;l) const</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>get</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a2d0ec1b326fe82fe6c2f19553a68b671</anchor>
      <arglist>(const int index) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a2594a4326065d15ec4bcb3104b4e74b6</anchor>
      <arglist>(const int index, void *item)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a28744f335b05d2e87bbc000f39a9e241</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a926913f2d3bf61561fa5681baa3955b5</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbProfilingData</name>
    <filename>classSbProfilingData.html</filename>
    <member kind="function">
      <type></type>
      <name>SbProfilingData</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a488aacafe6ca7807896ac31343667978</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbProfilingData</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a846e722d1391ba5c86952478ee04b923</anchor>
      <arglist>(const SbProfilingData &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbProfilingData</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>abd2766243e5524aded127cd6d45a0074</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setActionType</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>ae18037eb4ed6aee87bd05e511ee33f55</anchor>
      <arglist>(SoType actiontype)</arglist>
    </member>
    <member kind="function">
      <type>SoType</type>
      <name>getActionType</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>add091fc77694985eb7ff38c2264c48b6</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setActionStartTime</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>afedc0010bd7aac22f3191acfaafb4d73</anchor>
      <arglist>(SbTime starttime)</arglist>
    </member>
    <member kind="function">
      <type>SbTime</type>
      <name>getActionStartTime</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a0cdb78a8b77c5ab6b24a1c76ff5c33c7</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setActionStopTime</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>acfa2223276b957082882eca43b9464c2</anchor>
      <arglist>(SbTime stoptime)</arglist>
    </member>
    <member kind="function">
      <type>SbTime</type>
      <name>getActionStopTime</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a7852de0f544ec1e29d18edb4cd27e707</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbTime</type>
      <name>getActionDuration</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>abc0952b982f90964e3328ca87197eac0</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNodeTiming</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a27e4e5f78b5e5c1d0e90f040f3835a6a</anchor>
      <arglist>(const SoPath *path, SbTime timing)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNodeTiming</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a05fd61b8921339389b1c5079a82e45fa</anchor>
      <arglist>(int idx, SbTime timing)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>preOffsetNodeTiming</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>af20d7eb46b40fd5e6085479bf8d55181</anchor>
      <arglist>(int idx, SbTime timing)</arglist>
    </member>
    <member kind="function">
      <type>SbTime</type>
      <name>getNodeTiming</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>acd22fe96d7e1a23846ade5554a0a6dba</anchor>
      <arglist>(const SoPath *path, unsigned int queryflags=0) const</arglist>
    </member>
    <member kind="function">
      <type>SbTime</type>
      <name>getNodeTiming</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>ae8d202a6df3d0460fe938a7da15c4f07</anchor>
      <arglist>(int idx, unsigned int queryflags=0) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNodeFootprint</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a79fa926a23d11e4d4fc6c9b5b758d2f4</anchor>
      <arglist>(const SoPath *path, FootprintType type, size_t footprint)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNodeFootprint</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>ae97302f0bcb5ee39354e0a4a3e4240c3</anchor>
      <arglist>(int idx, FootprintType type, size_t footprint)</arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>getNodeFootprint</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a2247d6e1ffc147c1b6c4823babf8305a</anchor>
      <arglist>(const SoPath *path, FootprintType type, unsigned int queryflags=0) const</arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>getNodeFootprint</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a428b842fc0f89c39abedeb83a24400f8</anchor>
      <arglist>(int idx, FootprintType type, unsigned int queryflags=0) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNodeFlag</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a2dd73f063fce54f827559ee6e6638dfa</anchor>
      <arglist>(const SoPath *path, NodeFlag flag, SbBool on)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNodeFlag</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a0b7fb2b455a8429d7d9d9fc471bcf107</anchor>
      <arglist>(int idx, NodeFlag flag, SbBool on)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>getNodeFlag</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>ac734f353fa3485edb24b1e91071daf5d</anchor>
      <arglist>(const SoPath *path, NodeFlag flag) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>getNodeFlag</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>ae3c6d24ad13b57aa016b544a94c88241</anchor>
      <arglist>(int idx, NodeFlag flag) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getIndex</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>aecb6beb0a686cc503b2dfabf086aa396</anchor>
      <arglist>(const SoPath *path, SbBool create=FALSE)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getParentIndex</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a231a0935ebf1bdfde4479d2b32e18165</anchor>
      <arglist>(int idx) const</arglist>
    </member>
    <member kind="function">
      <type>SoType</type>
      <name>getNodeType</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a33c72cf3247c11c22aa71e06ef8b2566</anchor>
      <arglist>(int idx) const</arglist>
    </member>
    <member kind="function">
      <type>SbName</type>
      <name>getNodeName</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>ab5789e28c130ddf5c122c46cc7b32d87</anchor>
      <arglist>(int idx) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLongestNameLength</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a4b58029129c1bbd3adc7d4eacdc93622</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLongestTypeNameLength</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a1ab966cd8134b2111a7461dd1627f12d</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getNumNodeEntries</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a045efade58188c95939838c45f848af7</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reportAll</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a418a80de829f1d4055fe571019e3dbe8</anchor>
      <arglist>(SbProfilingDataCB *callback, void *userdata) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getStatsForTypesKeyList</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a7032d204fc05ebc2eea8be9d8a7fa20a</anchor>
      <arglist>(SbList&lt; SbProfilingNodeTypeKey &gt; &amp;keys_out) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getStatsForType</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>af7c9d9c6ec33db53b6f36c5082c83d08</anchor>
      <arglist>(SbProfilingNodeTypeKey type, SbTime &amp;total, SbTime &amp;max, uint32_t &amp;count) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getStatsForNamesKeyList</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a1be5a95fe02aaa779d5ce5b1f074cd1d</anchor>
      <arglist>(SbList&lt; SbProfilingNodeNameKey &gt; &amp;keys_out) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getStatsForName</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a616227db236efe12a437ea5c1e7d1925</anchor>
      <arglist>(SbProfilingNodeNameKey name, SbTime &amp;total, SbTime &amp;max, uint32_t &amp;count) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a40251e3b831483c7a8d591fdc8ef8afe</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbProfilingData &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>ac341fadcf59bdd94cd51c2cd4ef7e41d</anchor>
      <arglist>(const SbProfilingData &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>SbProfilingData &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>ad569c820296171fe6c2798403c7cb508</anchor>
      <arglist>(const SbProfilingData &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>getProfilingDataSize</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>adeb67d7832d4316b9cdf113e7f3f24cf</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbProjector</name>
    <filename>classSbProjector.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual SbVec3f</type>
      <name>project</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>a10aa00e733aae551b5e813bce2e52d2d</anchor>
      <arglist>(const SbVec2f &amp;point)=0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setViewVolume</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>a31e07b5d3f93e5be01f1945536e74a18</anchor>
      <arglist>(const SbViewVolume &amp;vol)</arglist>
    </member>
    <member kind="function">
      <type>const SbViewVolume &amp;</type>
      <name>getViewVolume</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>a98404f6b17ae586060e5b97e5e3434b8</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setWorkingSpace</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>acc11d72e261a3a27304377d673e48b21</anchor>
      <arglist>(const SbMatrix &amp;space)</arglist>
    </member>
    <member kind="function">
      <type>const SbMatrix &amp;</type>
      <name>getWorkingSpace</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>a58e37c326b0ee0ea4f8a779a6f7c0b53</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual SbProjector *</type>
      <name>copy</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>aa33a37be8140f93ccad65e06a1f5c88b</anchor>
      <arglist>(void) const =0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>tryProject</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>a1912d859fd6a18d253706c9fdd40b5e0</anchor>
      <arglist>(const SbVec2f &amp;point, const float epsilon, SbVec3f &amp;result)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SbProjector</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>af5e966f3ff29a796d35c7a1e0c6284e5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SbProjector</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>a6414ffa4d6d0635f1261b71a5df81ea9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbLine</type>
      <name>getWorkingLine</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>a8821291cc1b392a2a29ba00cb3d9a917</anchor>
      <arglist>(const SbVec2f &amp;point) const</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>float</type>
      <name>findVanishingDistance</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>a5d3db00e8ae894e10aad75d11dc1f4e1</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbBool</type>
      <name>verifyProjection</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>aa219e6c43451c00713db6db3e4361d9e</anchor>
      <arglist>(const SbVec3f &amp;projpt) const</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbViewVolume</type>
      <name>viewVol</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>af87ecfa2c2a1f99472327b7721eca310</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbMatrix</type>
      <name>worldToWorking</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>a9320194b4e872c21a2f6b04a2ff9d815</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbMatrix</type>
      <name>workingToWorld</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>a9cb662f372bcc9d01a7b392cde75e8e1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbRotation</name>
    <filename>classSbRotation.html</filename>
    <member kind="function">
      <type></type>
      <name>SbRotation</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>af7b34a3688cd8e1bfc3482bddb997b82</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbRotation</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>aabdc5a912bc0a6690dd47083a8b3f39f</anchor>
      <arglist>(const SbVec3f &amp;axis, const float radians)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbRotation</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>ae048a5c82d3f01f275f6223c8e180092</anchor>
      <arglist>(const float q[4])</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbRotation</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>ab86e1cbd8aec00ea9006be02649fa93f</anchor>
      <arglist>(const float q0, const float q1, const float q2, const float q3)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbRotation</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>ac42b51c454f31c7e4427801097cfda1f</anchor>
      <arglist>(const SbMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbRotation</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a5a71d62e68580ed900c071b3cf605b56</anchor>
      <arglist>(const SbVec3f &amp;rotateFrom, const SbVec3f &amp;rotateTo)</arglist>
    </member>
    <member kind="function">
      <type>const float *</type>
      <name>getValue</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>af97805cfe5cd1bc177d30aaaaac94cf8</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>ad50a2d4a984462946b28cb541844c14e</anchor>
      <arglist>(float &amp;q0, float &amp;q1, float &amp;q2, float &amp;q3) const</arglist>
    </member>
    <member kind="function">
      <type>SbRotation &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a341d6be6f5b7207edb5eb4f118f4e352</anchor>
      <arglist>(const float q0, const float q1, const float q2, const float q3)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a439e2ce16a821e64e0515dfd95e4bff3</anchor>
      <arglist>(SbVec3f &amp;axis, float &amp;radians) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a23a6cde9db84da45a588b2b6dcaab74c</anchor>
      <arglist>(SbMatrix &amp;matrix) const</arglist>
    </member>
    <member kind="function">
      <type>SbRotation &amp;</type>
      <name>invert</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a60bf4c2709c944b64bef644375250d88</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbRotation</type>
      <name>inverse</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a2f8dbc9a5877d0c3a6d9e10bdc621dca</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbRotation &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a3f7dfa32c2ab80fc0e6808ca1940512d</anchor>
      <arglist>(const float q[4])</arglist>
    </member>
    <member kind="function">
      <type>SbRotation &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a39efcb6f3651bea7b194f2e56cfb910f</anchor>
      <arglist>(const SbMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>SbRotation &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a0346dd919d996967cb7d1b907214f0ab</anchor>
      <arglist>(const SbVec3f &amp;axis, const float radians)</arglist>
    </member>
    <member kind="function">
      <type>SbRotation &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a0e4f23004de7569337960d7e5011e63d</anchor>
      <arglist>(const SbVec3f &amp;rotateFrom, const SbVec3f &amp;rotateTo)</arglist>
    </member>
    <member kind="function">
      <type>SbRotation &amp;</type>
      <name>operator *=</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a7f8232b6798656f896b10bb0ae92550c</anchor>
      <arglist>(const SbRotation &amp;q)</arglist>
    </member>
    <member kind="function">
      <type>SbRotation &amp;</type>
      <name>operator *=</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a192282055f034a48edc0bd5cf5a00cc5</anchor>
      <arglist>(const float s)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>operator[]</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a93e36415ab2e07c126a99c20f937f840</anchor>
      <arglist>(int n) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>equals</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a9dac5a577c39ba17387af7772ecee1a5</anchor>
      <arglist>(const SbRotation &amp;r, float tolerance) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multVec</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a9bf38e125fc5356d08a03a6e08df98f4</anchor>
      <arglist>(const SbVec3f &amp;src, SbVec3f &amp;dst) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scaleAngle</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>aecf5befb7013da43f9c459ee86a81e80</anchor>
      <arglist>(const float scaleFactor)</arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>toString</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a77aaa761134c8ca10e4f5326b0be42dc</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>fromString</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>abe4d493f5ad74a6c30135f62c0e36df6</anchor>
      <arglist>(const SbString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>abcb4364e56dc2eb2b253aa4a0b5e2ffa</anchor>
      <arglist>(FILE *fp) const</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbRotation</type>
      <name>slerp</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a04650493010ed066c2d055596f38c6f4</anchor>
      <arglist>(const SbRotation &amp;rot0, const SbRotation &amp;rot1, float t)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbRotation</type>
      <name>identity</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a185e88e106dbba29d4bb8339ff28c4ac</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a083b52d28a5b2c848ec051b051383816</anchor>
      <arglist>(const SbRotation &amp;q1, const SbRotation &amp;q2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a5fb0f927ad287d0913505d7f7ac04429</anchor>
      <arglist>(const SbRotation &amp;q1, const SbRotation &amp;q2)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbRotation</type>
      <name>operator *</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a10c486d8d9ec66dca3a3db76168e385e</anchor>
      <arglist>(const SbRotation &amp;q1, const SbRotation &amp;q2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbRWMutex</name>
    <filename>classSbRWMutex.html</filename>
  </compound>
  <compound kind="class">
    <name>SbSphere</name>
    <filename>classSbSphere.html</filename>
    <member kind="function">
      <type></type>
      <name>SbSphere</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>a73387572407620a899681cb05af33cd0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbSphere</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>a10410586031d8b3c9b5bc55876f3b1c9</anchor>
      <arglist>(const SbVec3f &amp;center, const float radius)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>a906782620b3e8bdb004ba314e9f90cbe</anchor>
      <arglist>(const SbVec3f &amp;center, const float radius)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCenter</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>a4b7d11065b77b3d1ea4308880a6b0574</anchor>
      <arglist>(const SbVec3f &amp;center)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRadius</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>a27485e86fea83dff472e6042eab71ed3</anchor>
      <arglist>(const float radius)</arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f &amp;</type>
      <name>getCenter</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>ab9a1eb78d16651bb6e7b3cce5e77b319</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getRadius</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>a776df31eef9adc7f459b1b82eab3584c</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>circumscribe</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>a57d815c498ead420cfe4b480fd4a6aa2</anchor>
      <arglist>(const SbBox3f &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>ad2657e2e7df7164be28c80fcb0ab870a</anchor>
      <arglist>(const SbLine &amp;l, SbVec3f &amp;intersection) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>ad55942fe2faf009d1cb5ccf7dc02acd9</anchor>
      <arglist>(const SbLine &amp;l, SbVec3f &amp;enter, SbVec3f &amp;exit) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>pointInside</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>a6b83f57c2d386d363266c1cab7075e8a</anchor>
      <arglist>(const SbVec3f &amp;p) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>a939ad24a69b9507e18bad400cb2350f2</anchor>
      <arglist>(FILE *file) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbSpherePlaneProjector</name>
    <filename>classSbSpherePlaneProjector.html</filename>
    <base>SbSphereSectionProjector</base>
    <member kind="function">
      <type></type>
      <name>SbSpherePlaneProjector</name>
      <anchorfile>classSbSpherePlaneProjector.html</anchorfile>
      <anchor>a3042ff531eb61c7cbc3b9d4c5a6f3b19</anchor>
      <arglist>(const float edgetol=0.9f, const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbSpherePlaneProjector</name>
      <anchorfile>classSbSpherePlaneProjector.html</anchorfile>
      <anchor>a85c71f491a82ea4e698bda6611365bf2</anchor>
      <arglist>(const SbSphere &amp;sph, const float edgetol=0.9f, const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbProjector *</type>
      <name>copy</name>
      <anchorfile>classSbSpherePlaneProjector.html</anchorfile>
      <anchor>a60f2b4ecce5ed6413934517cf0c3ca96</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>project</name>
      <anchorfile>classSbSpherePlaneProjector.html</anchorfile>
      <anchor>affe7047c1f8ef6c2bcf2032d76bd73c4</anchor>
      <arglist>(const SbVec2f &amp;point)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbRotation</type>
      <name>getRotation</name>
      <anchorfile>classSbSpherePlaneProjector.html</anchorfile>
      <anchor>ab0010e8222fbf7f4a86b8a18260e45e1</anchor>
      <arglist>(const SbVec3f &amp;point1, const SbVec3f &amp;point2)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbRotation</type>
      <name>getRotation</name>
      <anchorfile>classSbSpherePlaneProjector.html</anchorfile>
      <anchor>a8fb39b306183be8e6353e43df6bfc349</anchor>
      <arglist>(const SbVec3f &amp;point1, const SbBool tol1, const SbVec3f &amp;point2, const SbBool tol2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbSphereProjector</name>
    <filename>classSbSphereProjector.html</filename>
    <base>SbProjector</base>
    <member kind="function">
      <type>SbVec3f</type>
      <name>projectAndGetRotation</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>ac38482c976e0d9054e794a034abcf79e</anchor>
      <arglist>(const SbVec2f &amp;point, SbRotation &amp;rot)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual SbRotation</type>
      <name>getRotation</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>a9c4d57571349f6233e78e351b949a7b9</anchor>
      <arglist>(const SbVec3f &amp;point1, const SbVec3f &amp;point2)=0</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSphere</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>ace6896e5966432ac44d86c04d1e4eb61</anchor>
      <arglist>(const SbSphere &amp;sph)</arglist>
    </member>
    <member kind="function">
      <type>const SbSphere &amp;</type>
      <name>getSphere</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>a6220a37e4af7bda760c62d2e26599c17</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOrientToEye</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>ac4d069b1a39639e6700a63d659c7236f</anchor>
      <arglist>(const SbBool orienttoeye)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isOrientToEye</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>a729fa28d6220350e6352491dcfd74e73</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFront</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>a071532046e8c7319df2a29befe5903e2</anchor>
      <arglist>(const SbBool infront)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isFront</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>af2eda16b55d9845e7be189cf972247c5</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isPointInFront</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>ab52f0dcb29ee1d27ac4bf2b39e6f9a6b</anchor>
      <arglist>(const SbVec3f &amp;point) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setWorkingSpace</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>afe1519305c87d7726dc40b9daaa59764</anchor>
      <arglist>(const SbMatrix &amp;space)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SbSphereProjector</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>a868f57ebec32957883b1321b0adf955b</anchor>
      <arglist>(const SbBool orienttoeye)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SbSphereProjector</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>a378cd6b9ec089b03a78251e433d57758</anchor>
      <arglist>(const SbSphere &amp;s, const SbBool orienttoeye)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbBool</type>
      <name>intersectSphereFront</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>ab08294fd4cac38679167e552e4940ab0</anchor>
      <arglist>(const SbLine &amp;l, SbVec3f &amp;result)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbBool</type>
      <name>intersectFront</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>af53c03608a41fad58f82856113d20f65</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbSphere</type>
      <name>sphere</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>ab0ba051f5995c4924989789b99ca818f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbBool</type>
      <name>orientToEye</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>a0883b57c43eb641b44359f5caeb977fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbBool</type>
      <name>needSetup</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>a136681b3e872e38473160fe0fde0352d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>lastPoint</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>a23eb381f2626c24f4c2fa378e89412b4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbSphereSectionProjector</name>
    <filename>classSbSphereSectionProjector.html</filename>
    <base>SbSphereProjector</base>
    <member kind="function">
      <type></type>
      <name>SbSphereSectionProjector</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>a9090a203bc67b74149a825fc5df14c42</anchor>
      <arglist>(const float edgetol=0.9f, const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbSphereSectionProjector</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>a048b76c7d97b33c9576c2e870ea9a502</anchor>
      <arglist>(const SbSphere &amp;sph, const float edgetol=0.9f, const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbProjector *</type>
      <name>copy</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>a9896169983bc4ac24ac415cb7e13724e</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>project</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>ae9bd7709409cf32532354b67bb0cb8f9</anchor>
      <arglist>(const SbVec2f &amp;point)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbRotation</type>
      <name>getRotation</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>acb939b44f139674396cfb9304a2fa686</anchor>
      <arglist>(const SbVec3f &amp;point1, const SbVec3f &amp;point2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTolerance</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>ab54f9887c3ba8b10ca0154d3049688b3</anchor>
      <arglist>(const float edgetol)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getTolerance</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>a3093560b6af78c1e624e95ebebb9e95f</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRadialFactor</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>aa089532afabe3ba67335ce603a7c879b</anchor>
      <arglist>(const float rad=0.0f)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getRadialFactor</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>a56e97badb2f0f2e59e8a986a1970fe6d</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isWithinTolerance</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>ac5f2c7751c2eda4828cf891a39509b8f</anchor>
      <arglist>(const SbVec3f &amp;point)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>setupTolerance</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>a482a9ff7c5301f9ae5bca606f3f5d345</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>tolerance</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>a7428f52b5d33e7c256361c1bfccf9b84</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>tolDist</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>a8680e19ea7232b1f972fbc5c17478bd3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>radialFactor</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>ab221449da9bff16c2ffc0a7cd3e4f26f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>planePoint</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>a9d54fc42f4321c46a2cc8ff4b074e0f6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>planeDir</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>af31156dbf1e400fb807ab9754bcd13c7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>planeDist</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>ad6d329c6cdc0645d91226668351118e7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbPlane</type>
      <name>tolPlane</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>a1607bd15508d9d1f93a3371f8f31b460</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbSphereSheetProjector</name>
    <filename>classSbSphereSheetProjector.html</filename>
    <base>SbSphereProjector</base>
    <member kind="function">
      <type></type>
      <name>SbSphereSheetProjector</name>
      <anchorfile>classSbSphereSheetProjector.html</anchorfile>
      <anchor>a8356658bb33977f1787120b0c9d40af3</anchor>
      <arglist>(const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbSphereSheetProjector</name>
      <anchorfile>classSbSphereSheetProjector.html</anchorfile>
      <anchor>a26219758d2f787d0386fcec538289895</anchor>
      <arglist>(const SbSphere &amp;sph, const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbProjector *</type>
      <name>copy</name>
      <anchorfile>classSbSphereSheetProjector.html</anchorfile>
      <anchor>abc838f2f82f98a843fa7a690043e0c60</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>project</name>
      <anchorfile>classSbSphereSheetProjector.html</anchorfile>
      <anchor>a0bcb1b01105408906699823d85f8990c</anchor>
      <arglist>(const SbVec2f &amp;point)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbRotation</type>
      <name>getRotation</name>
      <anchorfile>classSbSphereSheetProjector.html</anchorfile>
      <anchor>ae98f637b246b3defc53a8db8c228d5b0</anchor>
      <arglist>(const SbVec3f &amp;point1, const SbVec3f &amp;point2)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>setupPlane</name>
      <anchorfile>classSbSphereSheetProjector.html</anchorfile>
      <anchor>a9e7eea331df3c3fd6197b9d308c444c1</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>workingProjPoint</name>
      <anchorfile>classSbSphereSheetProjector.html</anchorfile>
      <anchor>a1e15498d6b5eec4688af05be0e980815</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>planePoint</name>
      <anchorfile>classSbSphereSheetProjector.html</anchorfile>
      <anchor>a82db4e1ef68eecc7d51b3d88f1178b7b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>planeDir</name>
      <anchorfile>classSbSphereSheetProjector.html</anchorfile>
      <anchor>ab262ce8024b732bb3533c5b78b2ec862</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>planeDist</name>
      <anchorfile>classSbSphereSheetProjector.html</anchorfile>
      <anchor>a6e28d2fee1faf1f50d41f3185826c5dc</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbPlane</type>
      <name>tolPlane</name>
      <anchorfile>classSbSphereSheetProjector.html</anchorfile>
      <anchor>ac4f5bcfe4f3032b8cba40d94572a1e82</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbStorage</name>
    <filename>classSbStorage.html</filename>
  </compound>
  <compound kind="class">
    <name>SbString</name>
    <filename>classSbString.html</filename>
    <member kind="function">
      <type></type>
      <name>SbString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>ad8bd7fd681ed31cae3c2165b9575e65d</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a3100d87da8215cf09b4386cb500ad464</anchor>
      <arglist>(const char *s)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a7dee6217016462d0a27715917fa2644b</anchor>
      <arglist>(const wchar_t *s)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a5107e4772f6e2088d256d34da1e30730</anchor>
      <arglist>(const char *s, int start, int end)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a4aa2a3f963edba4e22746393f82d5855</anchor>
      <arglist>(const SbString &amp;s)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a39c40a499231bc125b14b802c0b85f70</anchor>
      <arglist>(const int digits)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a33b47eab7803f9d9cec6db6862ab2120</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>hash</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a5b029f547aa68f3679f7e9927921705d</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a118684a0c356938e183e88781c435a4a</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeEmpty</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>ade6800edca5eb14538b266a61fede1e4</anchor>
      <arglist>(SbBool freeold=TRUE)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>getString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a6bfa023105342c057fe9eb555772ed6c</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>getSubString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a178c3857cb4bd08514aad93a1261aa6a</anchor>
      <arglist>(int startidx, int endidx=-1) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deleteSubString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a7d14b085ab8efac7bf5ee5a3b4a88e4f</anchor>
      <arglist>(int startidx, int endidx=-1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addIntString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>ac371e6d216d1f29b15b0fe6bd7023e99</anchor>
      <arglist>(const int value)</arglist>
    </member>
    <member kind="function">
      <type>char</type>
      <name>operator[]</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a25d142b4673f7c601bf484b5faf917c2</anchor>
      <arglist>(int index) const</arglist>
    </member>
    <member kind="function">
      <type>SbString &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>aff8574febe670eb6ed208c38ef9a530f</anchor>
      <arglist>(const char *s)</arglist>
    </member>
    <member kind="function">
      <type>SbString &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a48e6dd186644cb4248fa467873bda3bb</anchor>
      <arglist>(const SbString &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>SbString &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a7b4907e540abc08f9e966105ed9f20a9</anchor>
      <arglist>(const char *s)</arglist>
    </member>
    <member kind="function">
      <type>SbString &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a876f50865efc300930a7b242a1417a4b</anchor>
      <arglist>(const SbString &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>SbString &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a45c3f7f9f4c2b8798f2cb44ccf16dc17</anchor>
      <arglist>(const char c)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a0332de1adccc10496a0ca9413e81b4b3</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>compareSubString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>ace634ce56b64231d4cc6b93a0ba5e0bc</anchor>
      <arglist>(const char *text, int offset=0) const</arglist>
    </member>
    <member kind="function">
      <type>SbString &amp;</type>
      <name>sprintf</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a5b8b394310de686b49033d6e5ef16280</anchor>
      <arglist>(const char *formatstr,...)</arglist>
    </member>
    <member kind="function">
      <type>SbString &amp;</type>
      <name>vsprintf</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>af55ef20fed88bf7dbb8cb1eaf2457af3</anchor>
      <arglist>(const char *formatstr, va_list args)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>af13ccf36e4ec60eb22b23dca020f14c5</anchor>
      <arglist>(const SbString &amp;s) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>findAll</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>ae363cd9a05e13f49e9ea6c7078597c5a</anchor>
      <arglist>(const SbString &amp;s, SbIntList &amp;found) const</arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>lower</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>aa676eb974d064dae86adb2f9abb14566</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>upper</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a9b086168721f0b9cb8c96eb32e7128d7</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a48a640f2d1caa056ed2bc684cec72f16</anchor>
      <arglist>(std::FILE *fp) const</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static uint32_t</type>
      <name>hash</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>aeb40745b411a8d8efb71f1c738e3df8d</anchor>
      <arglist>(const char *s)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>acb6753b1515604ca971a1a87aff2f428</anchor>
      <arglist>(const SbString &amp;sbstr, const char *s)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>ac9b65d4d28f6c30992fea63ddd7cf2b9</anchor>
      <arglist>(const char *s, const SbString &amp;sbstr)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a678e767b7619480700a63bc39c567734</anchor>
      <arglist>(const SbString &amp;str1, const SbString &amp;str2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>aea9790c709cb18bdb1d696b322dbf1cf</anchor>
      <arglist>(const SbString &amp;sbstr, const char *s)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a65681d9c628370051ef61439f119bf17</anchor>
      <arglist>(const char *s, const SbString &amp;sbstr)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>ac7482060b03b437119ecae06d3986178</anchor>
      <arglist>(const SbString &amp;str1, const SbString &amp;str2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator&lt;</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a6ed1cb37360a4ca12c90f1c7cb27db6b</anchor>
      <arglist>(const SbString &amp;sbstr, const char *s)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator&lt;</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a9072e7b323d65c64110af3fff813b4d1</anchor>
      <arglist>(const char *s, const SbString &amp;sbstr)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator&lt;</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a94ed21c674ca5fc0100e0babf1a680cb</anchor>
      <arglist>(const SbString &amp;str1, const SbString &amp;str2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator&gt;</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a4ec0654b3fe5c53bfc65b10746731d7f</anchor>
      <arglist>(const SbString &amp;sbstr, const char *s)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator&gt;</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a46bc605c66301db6ecb77e923fec9a91</anchor>
      <arglist>(const char *s, const SbString &amp;sbstr)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator&gt;</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>af52285d09146696f46c923e786a6ad02</anchor>
      <arglist>(const SbString &amp;str1, const SbString &amp;str2)</arglist>
    </member>
    <member kind="friend">
      <type>friend const SbString</type>
      <name>operator+</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a9eaa950edece45dbdf394a3b39744c5d</anchor>
      <arglist>(const SbString &amp;str1, const SbString &amp;str2)</arglist>
    </member>
    <member kind="friend">
      <type>friend const SbString</type>
      <name>operator+</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a8c85f017ad0d4f843049a0c0f5026fa8</anchor>
      <arglist>(const SbString &amp;sbstr, const char *s)</arglist>
    </member>
    <member kind="friend">
      <type>friend const SbString</type>
      <name>operator+</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a54b38460b412035516ce1dca74affbec</anchor>
      <arglist>(const char *s, const SbString &amp;sbstr)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbStringList</name>
    <filename>classSbStringList.html</filename>
    <base>SbPList</base>
    <member kind="function">
      <type></type>
      <name>SbStringList</name>
      <anchorfile>classSbStringList.html</anchorfile>
      <anchor>a5f9e3315b61678d13d6f2360cc0e8c98</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbStringList</name>
      <anchorfile>classSbStringList.html</anchorfile>
      <anchor>ae66cdc3f06175aff254fd055db619b82</anchor>
      <arglist>(const int sizehint)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbStringList.html</anchorfile>
      <anchor>ae790131caab0ba8c6ee5c23154c53f44</anchor>
      <arglist>(SbString *string) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbStringList.html</anchorfile>
      <anchor>ad3242b4d563ab18cf2ec232865490e35</anchor>
      <arglist>(SbString *string, int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>SbString *&amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbStringList.html</anchorfile>
      <anchor>a62269f0455859d1747ab9f995e478de6</anchor>
      <arglist>(const int idx) const</arglist>
    </member>
    <member kind="function">
      <type>const SbString **</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbStringList.html</anchorfile>
      <anchor>a654d581accf5ca27f60b53af39d86361</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbTesselator</name>
    <filename>classSbTesselator.html</filename>
    <member kind="function">
      <type></type>
      <name>SbTesselator</name>
      <anchorfile>classSbTesselator.html</anchorfile>
      <anchor>af364565888f0def8e1665f223adb8d61</anchor>
      <arglist>(SbTesselatorCB *func=NULL, void *data=NULL)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbTesselator</name>
      <anchorfile>classSbTesselator.html</anchorfile>
      <anchor>a635c1016d1bcde86146bb86b04ccb17e</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>beginPolygon</name>
      <anchorfile>classSbTesselator.html</anchorfile>
      <anchor>a8092c3ca8ca4539e18fff6ff7552c828</anchor>
      <arglist>(SbBool keepVertices=FALSE, const SbVec3f &amp;normal=SbVec3f(0.0f, 0.0f, 0.0f))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addVertex</name>
      <anchorfile>classSbTesselator.html</anchorfile>
      <anchor>aefa3b7a22e769602fae46054725d7a0b</anchor>
      <arglist>(const SbVec3f &amp;v, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>endPolygon</name>
      <anchorfile>classSbTesselator.html</anchorfile>
      <anchor>a904c2f4eb454771851a600fce8957385</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCallback</name>
      <anchorfile>classSbTesselator.html</anchorfile>
      <anchor>ab6937880e7f06cecadd8efd95a7c469f</anchor>
      <arglist>(SbTesselatorCB *func, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbThread</name>
    <filename>classSbThread.html</filename>
  </compound>
  <compound kind="class">
    <name>SbThreadAutoLock</name>
    <filename>classSbThreadAutoLock.html</filename>
  </compound>
  <compound kind="class">
    <name>SbThreadMutex</name>
    <filename>classSbThreadMutex.html</filename>
  </compound>
  <compound kind="class">
    <name>SbTime</name>
    <filename>classSbTime.html</filename>
    <member kind="function">
      <type></type>
      <name>SbTime</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a9f7c034551e616cadd327ddef6310484</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbTime</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a3579ba1742a3827a42f5a6d34b3d8de5</anchor>
      <arglist>(const double sec)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbTime</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a43c176cc2f6d54eb4d0bdb57d9cea8c7</anchor>
      <arglist>(const int32_t sec, const long usec)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbTime</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a7b1d561c19cc78f7e061fc50c9b0021f</anchor>
      <arglist>(const struct timeval *const tv)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setToTimeOfDay</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>aeae606e00a26076aeaccca2e0b077aac</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a8f695933fe3cc2722eb8bdd75aa99c69</anchor>
      <arglist>(const double sec)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a2fcad96f5a9be55efbe29574a1de172b</anchor>
      <arglist>(const int32_t sec, const long usec)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>ab38f422af390a3eb5f9141be0ca41a72</anchor>
      <arglist>(const struct timeval *const tv)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMsecValue</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a675520e49045fd8a1cf419a3f761c26e</anchor>
      <arglist>(const unsigned long msec)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getValue</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>adf674ebeb895c682cf11165d1025761d</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>af5a0f5fa457a253dfe747bfc4da00e70</anchor>
      <arglist>(time_t &amp;sec, long &amp;usec) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a150765bac7b05928684aa4ed5e407384</anchor>
      <arglist>(struct timeval *tv) const</arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>getMsecValue</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>ac03cbfbb1bc88de8b3f621ec5b756341</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>format</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>acdb45fc6b82efbf98b24e5884e3e2262</anchor>
      <arglist>(const char *const fmt=&quot;%S.%i&quot;) const</arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>formatDate</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a298165440f31540c9eccac3325923e14</anchor>
      <arglist>(const char *const fmt=NULL) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>parsedate</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>ac5f6ad3aabca3582cc14dfa1ac9c4092</anchor>
      <arglist>(const char *const date)</arglist>
    </member>
    <member kind="function">
      <type>SbTime &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a644fc261ef8d20ad27e54bbda017c8ec</anchor>
      <arglist>(const SbTime &amp;tm)</arglist>
    </member>
    <member kind="function">
      <type>SbTime &amp;</type>
      <name>operator -=</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a3a8f635db8fb2f7daa7e27a05dc46430</anchor>
      <arglist>(const SbTime &amp;tm)</arglist>
    </member>
    <member kind="function">
      <type>SbTime</type>
      <name>operator-</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a6e1ae9f38f681ac075a0af6c347e90ef</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbTime &amp;</type>
      <name>operator *=</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>ad6e43f786161629e0c88ed4adace4b24</anchor>
      <arglist>(const double s)</arglist>
    </member>
    <member kind="function">
      <type>SbTime &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a50011d50a5a86f86fe27e48ca2d8ddd3</anchor>
      <arglist>(const double s)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>operator/</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a34f1b0e8fd090afcb45c59f60125f9e1</anchor>
      <arglist>(const SbTime &amp;tm) const</arglist>
    </member>
    <member kind="function">
      <type>SbTime</type>
      <name>operator %</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a656286e66fba165000e5e3c3a54b0b5b</anchor>
      <arglist>(const SbTime &amp;tm) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a4b5d5aef6cc0c3044a5f4eae0fef53cf</anchor>
      <arglist>(const SbTime &amp;tm) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator !=</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>affbe620882afc1e35b3347102bc3ff7f</anchor>
      <arglist>(const SbTime &amp;tm) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>operator&lt;</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a2f2af48de6c321770f9c0d849e4ce05b</anchor>
      <arglist>(const SbTime &amp;tm) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>operator &gt;</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a9f060ae7b6fad3b172f6d40f8f6c9d3f</anchor>
      <arglist>(const SbTime &amp;tm) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>operator&lt;=</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a5c4afab0599de3e6377c67f1aedf0e87</anchor>
      <arglist>(const SbTime &amp;tm) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>operator &gt;=</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a187fbdfb7bca723467047d2ebe413581</anchor>
      <arglist>(const SbTime &amp;tm) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a6278a0de3f23dbecd0cafe2a0fdd537a</anchor>
      <arglist>(FILE *fp) const</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbTime</type>
      <name>getTimeOfDay</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a6a24da27d9ba83fc848b860f164d00fc</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbTime</type>
      <name>zero</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>aa43feadef19a055eb17bf244605f9972</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbTime</type>
      <name>max</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a43279740f6f03fc3333a2165f4e75322</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbTime</type>
      <name>maxTime</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a8c4c29b97fef8d0f9a373fdf10e303e5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>sleep</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a1c47c0ca8049cd2129c39ba393d52595</anchor>
      <arglist>(int msec)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbTime</type>
      <name>operator+</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a83f13bc9e9d38624d8b33200dbbb55d9</anchor>
      <arglist>(const SbTime &amp;t0, const SbTime &amp;t1)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbTime</type>
      <name>operator -</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a2687f0ea0c68fe750d1bd0d0fd2bce23</anchor>
      <arglist>(const SbTime &amp;t0, const SbTime &amp;t1)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbTime</type>
      <name>operator *</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a0b7d33f66525f06fba4dbf7daf3a33a6</anchor>
      <arglist>(const double s, const SbTime &amp;tm)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbTime</type>
      <name>operator *</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a35088690c2e75b7e3f0e0feeea56293c</anchor>
      <arglist>(const SbTime &amp;tm, const double s)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbTime</type>
      <name>operator/</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>ac30cf5c325aca8e6f924ac03e28b571c</anchor>
      <arglist>(const SbTime &amp;tm, const double s)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbTypedStorage</name>
    <filename>classSbTypedStorage.html</filename>
    <templarg></templarg>
  </compound>
  <compound kind="class">
    <name>SbTypeInfo</name>
    <filename>classSbTypeInfo.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec2b</name>
    <filename>classSbVec2b.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec2d</name>
    <filename>classSbVec2d.html</filename>
    <member kind="function">
      <type></type>
      <name>SbVec2d</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>ac63dd0791c0095c9144f9bb9a6607eea</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2d</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a8db1b8fa814457c661fd9d3883fe339b</anchor>
      <arglist>(const double v[2])</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2d</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a49f6c2e309736dc6150b5c5da97d7712</anchor>
      <arglist>(double x, double y)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2d</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>ad5b47009527e6d47db0bbde7d901b7d3</anchor>
      <arglist>(const SbVec2f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2d</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a38d93efca3bd30cfc4dc4a39c772920a</anchor>
      <arglist>(const SbVec2b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2d</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>aa27005c1f3b6621801122a8110a983cb</anchor>
      <arglist>(const SbVec2s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2d</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a55d2f7e0c108ff0a57d76661627c84df</anchor>
      <arglist>(const SbVec2i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a497a600ee7dd4324a62f344b34927b57</anchor>
      <arglist>(const double v[2])</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>aa714b79f7d7157f3f782f223fdb17e23</anchor>
      <arglist>(double x, double y)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>ac6bf0143ec4cf44f744d2629c1ff88a5</anchor>
      <arglist>(const SbVec2f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a8ba5a744c6e52bdc183584f796fbdd38</anchor>
      <arglist>(const SbVec2b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>aef24e59ed4eb153b229737938b362f2f</anchor>
      <arglist>(const SbVec2s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>ad303b770569dff5d0e017cdc9fd707f8</anchor>
      <arglist>(const SbVec2i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>const double *</type>
      <name>getValue</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a9915eb7fe50f240ac02a259005a32274</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>ab2e7acc5bd7ba254a236166d7991f904</anchor>
      <arglist>(double &amp;x, double &amp;y) const</arglist>
    </member>
    <member kind="function">
      <type>double &amp;</type>
      <name>operator []</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a309ec44d80f634f2cfb2f878b9fc2fdb</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>const double &amp;</type>
      <name>operator []</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a97529255994b3c4763db7b98abb4ebf0</anchor>
      <arglist>(int i) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>equals</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>ae54297db83f03f9ff9bc505cda9043e4</anchor>
      <arglist>(const SbVec2d &amp;v, double tolerance) const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>dot</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a25fb1dfd4adbaddeeffdc09e4420812d</anchor>
      <arglist>(const SbVec2d &amp;v) const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>length</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>af99e381e3e8fbbb0a54c8571d9db0cf1</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>normalize</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a50bd14d8fd33c214eed8dc712b62441a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>negate</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a0e540f28f7a2332dbd186e38ca066c82</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>operator *=</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a80caf69aca6c5f7880b5d5c99ebfb21f</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a6d0c4645c6758f2b561730371118d2e6</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a5eb83d7686ad695253070e6526f1aba5</anchor>
      <arglist>(const SbVec2d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>operator -=</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a30a43d6c958082680ef6cf28ff56a8e6</anchor>
      <arglist>(const SbVec2d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d</type>
      <name>operator -</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a6b61277753c160220e2c81947acbadf4</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>abd4345026dd22f2ca2bdb5f247cf6897</anchor>
      <arglist>(FILE *fp) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d</type>
      <name>operator *</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>aad0731b25abde91b1c06b00404c298a8</anchor>
      <arglist>(const SbVec2d &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d</type>
      <name>operator *</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a03777e54047e49cb89f25021d0e64aba</anchor>
      <arglist>(double d, const SbVec2d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d</type>
      <name>operator/</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a1bf50012c612e4cba25faf4c43b35fdd</anchor>
      <arglist>(const SbVec2d &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d</type>
      <name>operator+</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>aca58910afc203e37d3130116b194c4f6</anchor>
      <arglist>(const SbVec2d &amp;v1, const SbVec2d &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d</type>
      <name>operator -</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a4951f83eb76c7306b9ed570274d710fc</anchor>
      <arglist>(const SbVec2d &amp;v1, const SbVec2d &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>ac385222f5fba67dd4681703b68203fb5</anchor>
      <arglist>(const SbVec2d &amp;v1, const SbVec2d &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator !=</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a8272c02b5419980d9aa02067b1a74f37</anchor>
      <arglist>(const SbVec2d &amp;v1, const SbVec2d &amp;v2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbVec2f</name>
    <filename>classSbVec2f.html</filename>
    <member kind="function">
      <type></type>
      <name>SbVec2f</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a1346ce09a8a9385f9c006cc5d63fcbf6</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2f</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>af3a6d469ba3a49ddc779aba017d3bb6b</anchor>
      <arglist>(const float v[2])</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2f</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>ab304ea742290b959eccc883bdae04e21</anchor>
      <arglist>(float x, float y)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2f</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a86d660046ca1cd6d23db075dc558a02c</anchor>
      <arglist>(const SbVec2d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2f</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>aa2ecac9cb0488503e03f7155df51d3ed</anchor>
      <arglist>(const SbVec2b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2f</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>acac859226bb926bed1e2f05698897f2a</anchor>
      <arglist>(const SbVec2s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2f</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a0aad8c6cd9c4811851bb86fd771ad039</anchor>
      <arglist>(const SbVec2i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>aa1e22cf35a2b1d95069161eb89b09421</anchor>
      <arglist>(const float v[2])</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a186ed3c323758b75395a9b3f4e39ce25</anchor>
      <arglist>(float x, float y)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a1c47c2a19edb3d862f3315652cdd76b4</anchor>
      <arglist>(const SbVec2d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>af75f570bfdd582e34e840ecd96a8a1cf</anchor>
      <arglist>(const SbVec2b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a6b8d3b85044489347f3fa474f4fb8d4d</anchor>
      <arglist>(const SbVec2s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a8ee69f0bab7c511656ed566aa87d78d7</anchor>
      <arglist>(const SbVec2i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>const float *</type>
      <name>getValue</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a6080fdafb358b3a596694917422e62c9</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a889a861881fa83b785c2b02bc14e442c</anchor>
      <arglist>(float &amp;x, float &amp;y) const</arglist>
    </member>
    <member kind="function">
      <type>float &amp;</type>
      <name>operator []</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a56dca66d78f5f619de4d3a9f6feaf7ee</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>const float &amp;</type>
      <name>operator []</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>ae9228be4ccad72dc89338681bdae5ac2</anchor>
      <arglist>(int i) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>dot</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>ac0287f950791daeae40dd2e600450e46</anchor>
      <arglist>(const SbVec2f &amp;v) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>equals</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a498beced4667ab961d474c736f482d8e</anchor>
      <arglist>(const SbVec2f &amp;v, float tolerance) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>length</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>ac0bd4a8ac50f7651abf35c43e31485e1</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>sqrLength</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a3bbc6688aa0de41ac30f431db5f462b3</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>negate</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a3d337eaf4ba60a986ca315dbdc0a8316</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>normalize</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a5391fa1b1910a636d8344e6981711f54</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>operator *=</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a6cbe639780f3e9aefbc4090be52f2ebd</anchor>
      <arglist>(float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a485f2867b40967c4d75f2c2369bdc982</anchor>
      <arglist>(float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>acfa72ec47271a175e83aa4ea3de95cc0</anchor>
      <arglist>(const SbVec2f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>operator -=</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a3c7c785d9bfad56c004715177a3e27e7</anchor>
      <arglist>(const SbVec2f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f</type>
      <name>operator -</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>ac327f456af8ba23f65b75de8ed757afd</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>toString</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a1304215946d8b56081c8841d36b39650</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>fromString</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a5b8c2115eded5cbd4009a451e81b6466</anchor>
      <arglist>(const SbString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>ade00536463c0a4f270b8fe395412207d</anchor>
      <arglist>(FILE *fp) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f</type>
      <name>operator *</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a89269e404adbf8cd673e5783e637bab6</anchor>
      <arglist>(const SbVec2f &amp;v, float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f</type>
      <name>operator *</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a73d8e67731c88be17fba27c4b45b27fc</anchor>
      <arglist>(float d, const SbVec2f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f</type>
      <name>operator/</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>ae241274f86f09257c43312082f79c11e</anchor>
      <arglist>(const SbVec2f &amp;v, float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f</type>
      <name>operator+</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a833644ab1c9540c85936d53902343dbc</anchor>
      <arglist>(const SbVec2f &amp;v1, const SbVec2f &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f</type>
      <name>operator -</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a082672c19b59dbce5c1821dbb7275e29</anchor>
      <arglist>(const SbVec2f &amp;v1, const SbVec2f &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>afc60d5b71be030e65e2b48b777fe2f04</anchor>
      <arglist>(const SbVec2f &amp;v1, const SbVec2f &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator !=</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>ab3a544115e664cb6b76d005a303db665</anchor>
      <arglist>(const SbVec2f &amp;v1, const SbVec2f &amp;v2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbVec2i32</name>
    <filename>classSbVec2i32.html</filename>
    <member kind="function">
      <type></type>
      <name>SbVec2i32</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a61e4389eec4df5c60d8a2541a53dad61</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2i32</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>ad59bbb7800e85102cd79ab426a2cca7e</anchor>
      <arglist>(const int32_t v[2])</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2i32</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a63207a149dd902f2fd4efa6ed344ff0d</anchor>
      <arglist>(int32_t x, int32_t y)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2i32</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>aa6ae02dc4997eb8b8733f8058973b86c</anchor>
      <arglist>(const SbVec2ui32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2i32</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>afcd070a1d22281da4ac07c475fe39cf7</anchor>
      <arglist>(const SbVec2b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2i32</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a5c0bce7d90fca72b17032fd674c58ed6</anchor>
      <arglist>(const SbVec2s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2i32</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a60131c056aa7c115e2513257412ba168</anchor>
      <arglist>(const SbVec2f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2i32</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>aa43fbef9688c1eb7a5e60c5e09c617ce</anchor>
      <arglist>(const SbVec2d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a8b97efa83369d7bf3d8deb0bcff7fe50</anchor>
      <arglist>(const int32_t v[2])</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>ad49d532be08ccf4d9ffefdb198b73055</anchor>
      <arglist>(int32_t x, int32_t y)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a52e224026a651fdd3ed21aa078ff30c0</anchor>
      <arglist>(const SbVec2ui32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>aa1791190f26a7336931c0a7d660be05e</anchor>
      <arglist>(const SbVec2b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a37fe9378a81cd3ebc6ae4a23fba34b0f</anchor>
      <arglist>(const SbVec2s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>ac5cb93e79d042c64c45094f7b56d643c</anchor>
      <arglist>(const SbVec2f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>aff9883884b8de7439fba08700679678f</anchor>
      <arglist>(const SbVec2d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>const int32_t *</type>
      <name>getValue</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a9150fba40dd4f313af6d8c5723c55172</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a0bd56ee80b0e8f6aefef304b6e7ba11e</anchor>
      <arglist>(int32_t &amp;x, int32_t &amp;y) const</arglist>
    </member>
    <member kind="function">
      <type>int32_t &amp;</type>
      <name>operator []</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a3952944e6cb27f49edec85b6cce4eab0</anchor>
      <arglist>(const int i)</arglist>
    </member>
    <member kind="function">
      <type>const int32_t &amp;</type>
      <name>operator []</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a9c350994a86c7404d3ad08e548b81626</anchor>
      <arglist>(const int i) const</arglist>
    </member>
    <member kind="function">
      <type>int32_t</type>
      <name>dot</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a81b282053c35503b7d937535856ccb14</anchor>
      <arglist>(const SbVec2i32 &amp;v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>negate</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a8375dc369919c84c71c8dc890353a93a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>operator *=</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a0af5a42f74c9e4d848b7f38568437e4d</anchor>
      <arglist>(int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>operator *=</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a2fd2e69c3983786ad6b3a0e0220701cf</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a56e63433419e83d2032e186be949faba</anchor>
      <arglist>(int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a0371eb39aaf87ea431621c900914a8e2</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>acd086b0892a1e4db6a455d7de07de539</anchor>
      <arglist>(const SbVec2i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>operator -=</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a1292ca42eae5a8777c0b746979fe8bf0</anchor>
      <arglist>(const SbVec2i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32</type>
      <name>operator -</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a2a63a42072f23bffab68076e7c1e2214</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a3fa823ef8557548c84e14ea1cab69c84</anchor>
      <arglist>(FILE *fp) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32</type>
      <name>operator *</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a975d1088154b2c99f36cc95eeb8c3fff</anchor>
      <arglist>(const SbVec2i32 &amp;v, int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32</type>
      <name>operator *</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a2963a58deb4b65dfed527cc3f1c9e612</anchor>
      <arglist>(const SbVec2i32 &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32</type>
      <name>operator *</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a0f36852f23d5ba018e82f09c4d5e2c66</anchor>
      <arglist>(int d, const SbVec2i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32</type>
      <name>operator *</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a1afbfd8d6a3accecefac17fd92cc6de3</anchor>
      <arglist>(double d, const SbVec2i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32</type>
      <name>operator/</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>ac56ca284a16ec1723a03ce26c4c5f682</anchor>
      <arglist>(const SbVec2i32 &amp;v, int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32</type>
      <name>operator/</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a17b0be4cc751a41ff8423359ed754c03</anchor>
      <arglist>(const SbVec2i32 &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32</type>
      <name>operator+</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>ac0679ae7383def6697ac3e649e8fbfe5</anchor>
      <arglist>(const SbVec2i32 &amp;v1, const SbVec2i32 &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32</type>
      <name>operator -</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>aa5e39e166fa7cce44783f0c82a085c8d</anchor>
      <arglist>(const SbVec2i32 &amp;v1, const SbVec2i32 &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>ab90407c32069ca2fed431d5db3633771</anchor>
      <arglist>(const SbVec2i32 &amp;v1, const SbVec2i32 &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator !=</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a16819b2a65fa12f513402f35e5833897</anchor>
      <arglist>(const SbVec2i32 &amp;v1, const SbVec2i32 &amp;v2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbVec2s</name>
    <filename>classSbVec2s.html</filename>
    <member kind="function">
      <type></type>
      <name>SbVec2s</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a949d11f0e5baf23139d37077d86c8668</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2s</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a81a132782d39edfd8aa9637551d9cab1</anchor>
      <arglist>(const short v[2])</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2s</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a164465f376cdb9154aaa07fda5419efa</anchor>
      <arglist>(short x, short y)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2s</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>af847eda487ca16d780c0150144e1154d</anchor>
      <arglist>(const SbVec2us &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2s</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a1e4b9ff96307591762b7c5b3e7e2c214</anchor>
      <arglist>(const SbVec2b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2s</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a5287c7f1a1a8c5ca4bad9ada3f79da3a</anchor>
      <arglist>(const SbVec2i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2s</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a8365abe07d53394660dba57b699d36a9</anchor>
      <arglist>(const SbVec2f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2s</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>aa4e1abdb20854f571736e316de7cc683</anchor>
      <arglist>(const SbVec2d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a749320fbf358f1101ba7c25a1ba1a3b8</anchor>
      <arglist>(const short v[2])</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a7cf9b71b29cb2e8e959d231f5832f85e</anchor>
      <arglist>(short x, short y)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a94dbeefccf4638ac09a5d739d1c96c0b</anchor>
      <arglist>(const SbVec2us &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>ac36f7b2d4621000432abf7b1a7c7419c</anchor>
      <arglist>(const SbVec2b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a9079068a737e916a72b475e970922156</anchor>
      <arglist>(const SbVec2i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a57e93cf652fab9f7d970386dccd41d50</anchor>
      <arglist>(const SbVec2f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a8527511481b416340acede23b547bb4a</anchor>
      <arglist>(const SbVec2d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>const short *</type>
      <name>getValue</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a268a363d6a2cdaa24ee20370006e121f</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a2e3e3dd70b3627df8f7153f1029833a6</anchor>
      <arglist>(short &amp;x, short &amp;y) const</arglist>
    </member>
    <member kind="function">
      <type>short &amp;</type>
      <name>operator []</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>aba4c3e71d613b6e29eb078611a53a351</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>const short &amp;</type>
      <name>operator []</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a3a71e66dfc6d05e32688a829d8a87995</anchor>
      <arglist>(int i) const</arglist>
    </member>
    <member kind="function">
      <type>int32_t</type>
      <name>dot</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>ae88c061e72a4af3e5f26277f682e5ded</anchor>
      <arglist>(SbVec2s v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>negate</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>ab1a9e1cdd67a4ca519e91c60ab4cb477</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>operator *=</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>af95c1a39e1c74dacc1858737854363de</anchor>
      <arglist>(int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>operator *=</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a4128d75ca1b90866cb2bf2bd75f5a3ca</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>ac5864539fcf034cd700a9ed0a3c2951f</anchor>
      <arglist>(int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>ad8f0d4947c757fa8a7fb080b77ed2216</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a66bc5e12845fdb529c78cdf2369d832b</anchor>
      <arglist>(SbVec2s v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>operator -=</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a9313e3ec7ffc62d535286afc08345546</anchor>
      <arglist>(SbVec2s v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s</type>
      <name>operator -</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a166c60878ae64f6961b1a2aabec3e1c9</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>toString</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a2f5786f7f7db22a5893a169abd7ee2fa</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>fromString</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a748fddd3cd777af3474334b4e349897e</anchor>
      <arglist>(const SbString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a05c83126483028b42e6e0119f26042e4</anchor>
      <arglist>(FILE *fp) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s</type>
      <name>operator *</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a980493e159180298fb381a2b257998eb</anchor>
      <arglist>(const SbVec2s &amp;v, int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s</type>
      <name>operator *</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>af98aacfac6f716a461f76002cd56802f</anchor>
      <arglist>(const SbVec2s &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s</type>
      <name>operator *</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a2163709c6b48336b332ba8430c351d33</anchor>
      <arglist>(int d, const SbVec2s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s</type>
      <name>operator *</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a5b6f9be8b203c27c476dfca8dcd972fc</anchor>
      <arglist>(double d, const SbVec2s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s</type>
      <name>operator/</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a0da97de4ad79429159ef2a7e9d9b9c75</anchor>
      <arglist>(const SbVec2s &amp;v, int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s</type>
      <name>operator/</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a4997afc77f28a86590c3b56851ac7653</anchor>
      <arglist>(const SbVec2s &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s</type>
      <name>operator+</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>aa0e3205ce44f1b1834fcd95f90b370e7</anchor>
      <arglist>(const SbVec2s &amp;v1, const SbVec2s &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s</type>
      <name>operator -</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a4089ad1f1fc766781e331c887d7ed609</anchor>
      <arglist>(const SbVec2s &amp;v1, const SbVec2s &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a5e0d9c3c70b584ef527896aab18d0c8c</anchor>
      <arglist>(const SbVec2s &amp;v1, const SbVec2s &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator !=</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>aa4ded39646afb1c9538e85f1263d43b7</anchor>
      <arglist>(const SbVec2s &amp;v1, const SbVec2s &amp;v2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbVec2ub</name>
    <filename>classSbVec2ub.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec2ui32</name>
    <filename>classSbVec2ui32.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec2us</name>
    <filename>classSbVec2us.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec3b</name>
    <filename>classSbVec3b.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec3d</name>
    <filename>classSbVec3d.html</filename>
    <member kind="function">
      <type></type>
      <name>SbVec3d</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a8eadb0adc327684c460881ae81253e12</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3d</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a6d5c6a6082b72c55aae88e23acd843c1</anchor>
      <arglist>(const double v[3])</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3d</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a48aba5218dae1458533f87b178da6c5a</anchor>
      <arglist>(double x, double y, double z)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3d</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a823106c1f8611953022ce6e422631d6d</anchor>
      <arglist>(const SbVec3f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3d</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a0c4266b3b2c8d12bb6a4cc36583b64af</anchor>
      <arglist>(const SbVec3b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3d</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a278090650beed389e86fb29070a27f20</anchor>
      <arglist>(const SbVec3s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3d</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>aa2ba794348f9bed86b80853790cae5a0</anchor>
      <arglist>(const SbVec3i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3d</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>adddf72fdfe5999442b9ca0ed2f781d9c</anchor>
      <arglist>(const SbDPPlane &amp;p0, const SbDPPlane &amp;p1, const SbDPPlane &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a3502ebf227e379148924170d37d1d91b</anchor>
      <arglist>(const double v[3])</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>af33229ecf26ed9181b9560f2cf2cfd45</anchor>
      <arglist>(double x, double y, double z)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a1767493fbe105a21443784c1401a8197</anchor>
      <arglist>(const SbVec3d &amp;barycentric, const SbVec3d &amp;v0, const SbVec3d &amp;v1, const SbVec3d &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>ac5a6c3d7be0b7515767823eb5128c712</anchor>
      <arglist>(const SbVec3f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>abbf3097826dee7efb5e27e1816b5520a</anchor>
      <arglist>(const SbVec3b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>af2213f41172c01715105e62441ee3e32</anchor>
      <arglist>(const SbVec3s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>ac9d45642a2188d2fd3ca9d3a3a1b74d8</anchor>
      <arglist>(const SbVec3i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>const double *</type>
      <name>getValue</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>aa9612077aea81a79d4d8d5a65ff4f0af</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a8d407ca49aaf3e5e6dd394c968a408c3</anchor>
      <arglist>(double &amp;x, double &amp;y, double &amp;z) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>cross</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a6e3827bc11069cedd4193c629620a1fe</anchor>
      <arglist>(const SbVec3d &amp;v) const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>dot</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a0f6e6e465330ad46f0e897f09a4d59e1</anchor>
      <arglist>(const SbVec3d &amp;v) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>equals</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a04177c9fea56098bb927c8390778a723</anchor>
      <arglist>(const SbVec3d &amp;v, double tolerance) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>getClosestAxis</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>afd03c52996fa0fa75976e347474d0f54</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>length</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a0c2ca6225f108954417678209f2eb3ac</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>sqrLength</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>af0313a600d6f73b452cb850cc9b85a8f</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>negate</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>acd1ac1abcfc3e3ed33da1d00a16e0b26</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>normalize</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a18665ea58a934c30bf0c1c6514756906</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>operator *=</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>acb51012ddf031339c1e6afcd661daebc</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>afd49d1b1b565338d01143c800dd5a01f</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a168f773bc5d03cea72b7b6e195f3b5b9</anchor>
      <arglist>(const SbVec3d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>operator -=</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a0f50322ecdc694136f82329ab4262ed9</anchor>
      <arglist>(const SbVec3d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>operator -</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a890be3f67feb6e6930286198f12166bf</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>toString</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a0556dbad5ca21ee522da182fde2309c7</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>fromString</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>afccce23ff5d0cbc4be2afacfd7981542</anchor>
      <arglist>(const SbString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a1f5ac217b99bc23a14187f7719c329b8</anchor>
      <arglist>(FILE *fp) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>operator *</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>ab0e39ea6b4263df37bd5f87036c92284</anchor>
      <arglist>(const SbVec3d &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>operator *</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a83b721b148f0129bd23ad873c5b007f5</anchor>
      <arglist>(double d, const SbVec3d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>operator/</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>afa88edac3a167324bd3f1244b00a4cde</anchor>
      <arglist>(const SbVec3d &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>operator+</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>aeb666d8a1c045ccf8bcb6e7cb7dc2031</anchor>
      <arglist>(const SbVec3d &amp;v1, const SbVec3d &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>operator -</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>adad4ef9df9fc6bf5d15ad783ca123a5e</anchor>
      <arglist>(const SbVec3d &amp;v1, const SbVec3d &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a6274cf58ed1a8882288f72ea5ae2cee3</anchor>
      <arglist>(const SbVec3d &amp;v1, const SbVec3d &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator !=</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a7c3fa48d2fc66626e838040dc6d7d42e</anchor>
      <arglist>(const SbVec3d &amp;v1, const SbVec3d &amp;v2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbVec3f</name>
    <filename>classSbVec3f.html</filename>
    <member kind="function">
      <type></type>
      <name>SbVec3f</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>aa76258aca6004c0bc187eb1bb6ad8920</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3f</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a5d493a03bcc39dd578d10fb16a9880b0</anchor>
      <arglist>(const float v[3])</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3f</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>ab1b1809e180447f9543c568fe1797afe</anchor>
      <arglist>(float x, float y, float z)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3f</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a361be6b8e470fcd78a751d9e903c77d1</anchor>
      <arglist>(const SbVec3d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3f</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a407499b4811c6d58fd869b9b7ac968ba</anchor>
      <arglist>(const SbVec3b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3f</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a7bd67c1129f1b91537b630b75882773e</anchor>
      <arglist>(const SbVec3s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3f</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>ae46cd083167fe597aec88d0756b99133</anchor>
      <arglist>(const SbVec3i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3f</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>aa3f9d152a6c12807db97f06f8a6a882d</anchor>
      <arglist>(const SbPlane &amp;p0, const SbPlane &amp;p1, const SbPlane &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a441b6c1a81cb3a144aea083d273e0fba</anchor>
      <arglist>(const float v[3])</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>acbd4bc205e738596a07798c3fa066f7f</anchor>
      <arglist>(float x, float y, float z)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a398f573712c5fe396171acbcc350c1b7</anchor>
      <arglist>(const SbVec3f &amp;barycentric, const SbVec3f &amp;v0, const SbVec3f &amp;v1, const SbVec3f &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a01a8dba4f91c56a4f7fd8a1c2fe0b74f</anchor>
      <arglist>(const SbVec3d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>ae861ee2e14544a07526edac9f8ab56b8</anchor>
      <arglist>(const SbVec3b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a9c0650859153a39b3d0214ccb804d66f</anchor>
      <arglist>(const SbVec3s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a8197f09226440885ae0ca0cb19f48ad9</anchor>
      <arglist>(const SbVec3i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>const float *</type>
      <name>getValue</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a481f9536d1feffa9d9f2a7a6f3c95b41</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a4d8077f7368b8ca9eda627984f5fd68f</anchor>
      <arglist>(float &amp;x, float &amp;y, float &amp;z) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>equals</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>aa2def7cb424a0304d037f5a231a87a2a</anchor>
      <arglist>(const SbVec3f &amp;v, float tolerance) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>cross</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a02c505a34519ba8a0b59a875d5993a0b</anchor>
      <arglist>(const SbVec3f &amp;v) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>dot</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a8f1a7b2347abeeb3f1f65a97b795cf43</anchor>
      <arglist>(const SbVec3f &amp;v) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getClosestAxis</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a773f5f8cfa1ca21306b1ee3d49385209</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>length</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a5c2a3a2b674f5c76ee03f0a7fb1ca4b9</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>sqrLength</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>af3b736fb181ace83094acea63628fee7</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>normalize</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>ac0d97d3db797a7a849d4f28c3a2436f2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>negate</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a93022b11a182eba2bb4bd334ee243d43</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>operator *=</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a3fd6c6730186ae532181756a15ded095</anchor>
      <arglist>(float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a1f312a6caf3ecd58fc4adfaa9cc76708</anchor>
      <arglist>(float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a047dd8714e8aa6c0877742e8984465be</anchor>
      <arglist>(const SbVec3f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>operator -=</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a84841f73536fe16758e936f62720757a</anchor>
      <arglist>(const SbVec3f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>operator -</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a183515862797d0a6f18452132a2a6d1e</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>toString</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a743757efaaf3595e95bb22a1b40ac5eb</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>fromString</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>ac905cbd501030b50597f35d4092a0a02</anchor>
      <arglist>(const SbString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a1b0b3eb5025cf40dc06f6e33dc03c7de</anchor>
      <arglist>(FILE *fp) const</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>vec</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a47474608ef4d1d3724b2bfad52a60dd2</anchor>
      <arglist>[3]</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>operator *</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>ae9f51fa82418c665dddbb925c70be240</anchor>
      <arglist>(const SbVec3f &amp;v, float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>operator *</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a3ddb20b80fba7a3668b697208ac2e8f6</anchor>
      <arglist>(float d, const SbVec3f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>operator/</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>ab7e6292b2c255bdbd92e36f93cba6120</anchor>
      <arglist>(const SbVec3f &amp;v, float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>operator+</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a4a0d56698007ef9dced0e01822984034</anchor>
      <arglist>(const SbVec3f &amp;v1, const SbVec3f &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>operator -</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>aa107a1a5d014ba32a5ff9c86b7a7bb90</anchor>
      <arglist>(const SbVec3f &amp;v1, const SbVec3f &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a75471273e406ad2f2df577bb83e02986</anchor>
      <arglist>(const SbVec3f &amp;v1, const SbVec3f &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator !=</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a5575988b878194d176c27765e7584c3b</anchor>
      <arglist>(const SbVec3f &amp;v1, const SbVec3f &amp;v2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbVec3fList</name>
    <filename>classSbVec3fList.html</filename>
    <base>SbPList</base>
    <member kind="function">
      <type></type>
      <name>SbVec3fList</name>
      <anchorfile>classSbVec3fList.html</anchorfile>
      <anchor>a1e7610fb5a9ce564075095b632f6b322</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbVec3fList</name>
      <anchorfile>classSbVec3fList.html</anchorfile>
      <anchor>a8fcd4eb25a06eba2bc6dcfb9d3287c45</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbVec3fList.html</anchorfile>
      <anchor>a9899c06fc9b57c6d203c542791bba3c6</anchor>
      <arglist>(const SbVec3f *item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbVec3fList.html</anchorfile>
      <anchor>adc8c71f530c7b2cdd6e2c61c07b84e92</anchor>
      <arglist>(const SbVec3f *item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f *</type>
      <name>operator[]</name>
      <anchorfile>classSbVec3fList.html</anchorfile>
      <anchor>add9d7fb9fce38bc9a78ff194de0444f9</anchor>
      <arglist>(const int idx) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbVec3i32</name>
    <filename>classSbVec3i32.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec3s</name>
    <filename>classSbVec3s.html</filename>
    <member kind="function">
      <type></type>
      <name>SbVec3s</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a8a17743467745471b1b30c6bf00a181a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3s</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a31fd3dc5ec1fddb163f9f6a88ae89190</anchor>
      <arglist>(const short v[3])</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3s</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>adc03f5041b94c89f8e5f3f62c653a746</anchor>
      <arglist>(short x, short y, short z)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3s</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a2678145a4a2f7292f6e0ab74847ed823</anchor>
      <arglist>(const SbVec3us &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3s</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>af11345b4ad1e0e22df232888f20f175c</anchor>
      <arglist>(const SbVec3b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3s</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>ae5b06878f494b039ad77a1a8edabc384</anchor>
      <arglist>(const SbVec3i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3s</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>af7f0f60434502a96320805da1129e2ca</anchor>
      <arglist>(const SbVec3f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3s</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a87ebb005dda25e4028180796dc718da9</anchor>
      <arglist>(const SbVec3d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a13bcd6f18c9b72e0398932ebc2c3f2be</anchor>
      <arglist>(const short v[3])</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a7b3b315d4c4ee43904b574e55413987b</anchor>
      <arglist>(const SbVec3us &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>aaa8e79640bc4dabb9bd3e2c7bd577e0c</anchor>
      <arglist>(const SbVec3b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a508bfa34c7c89ef64cd756467970ee39</anchor>
      <arglist>(const SbVec3i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a301642f2b0250ceaae2cc92cbcd64612</anchor>
      <arglist>(const SbVec3f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>ad75c16547603db047d2dde75f0f86808</anchor>
      <arglist>(const SbVec3d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>const short *</type>
      <name>getValue</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>ae0e116ac912a30aafccadc7bc5d94481</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a3bfdece9b4e932effd2f39a38c986b3c</anchor>
      <arglist>(short &amp;x, short &amp;y, short &amp;z) const</arglist>
    </member>
    <member kind="function">
      <type>int32_t</type>
      <name>dot</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a8829f91aae9477e1c5a600df76750bf1</anchor>
      <arglist>(const SbVec3s &amp;v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>negate</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a38e6999933ca957c0af4ab78e07b8a67</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>operator *=</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>acc3fc5c180cbb17ac9134193492d8ac5</anchor>
      <arglist>(int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>operator *=</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a0c0d8076e2b31797f208bbfc5d6db62f</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a40824232039d0b271ca7f0543d95197c</anchor>
      <arglist>(int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a1ca5b77e6a490548f857b6d94e6a0638</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a58cea8166e2a1705f15322da77f4927d</anchor>
      <arglist>(const SbVec3s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>operator -=</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a14d142bf0b738cbca66f10b1cc10b5a5</anchor>
      <arglist>(const SbVec3s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>toString</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a56f3790b85760a19c06ed71820b16e96</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>fromString</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a1560b584ee7714f1d43cb0e997f1c511</anchor>
      <arglist>(const SbString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a7d07c5a20beb367eaf43ec690912dc33</anchor>
      <arglist>(FILE *fp) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s</type>
      <name>operator *</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a2ec51695f97a1a267b0192eaeafa0b83</anchor>
      <arglist>(const SbVec3s &amp;v, int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s</type>
      <name>operator *</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a08e8622267cacb0e1ae4d13b602ae375</anchor>
      <arglist>(const SbVec3s &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s</type>
      <name>operator *</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a2f7d43fffe89c51d7c59a5099ff930a6</anchor>
      <arglist>(int d, const SbVec3s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s</type>
      <name>operator *</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a59869acea93e68a76629ddcc142b00f2</anchor>
      <arglist>(double d, const SbVec3s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s</type>
      <name>operator/</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a03691fd07c4ea890fbd6e64a218b3003</anchor>
      <arglist>(const SbVec3s &amp;v, int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s</type>
      <name>operator/</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a4ab17190eb376a2158952bff4561839a</anchor>
      <arglist>(const SbVec3s &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s</type>
      <name>operator+</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a0fae636d216f98ed3bc952f87c2b76e7</anchor>
      <arglist>(const SbVec3s &amp;v1, const SbVec3s &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s</type>
      <name>operator -</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>abf3b7bbf5962a2f216ba64713c40de20</anchor>
      <arglist>(const SbVec3s &amp;v1, const SbVec3s &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a17f16774265457801b432b293eaed06a</anchor>
      <arglist>(const SbVec3s &amp;v1, const SbVec3s &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator !=</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a51d2d7c4391e01c3909aa43d404543fb</anchor>
      <arglist>(const SbVec3s &amp;v1, const SbVec3s &amp;v2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbVec3ub</name>
    <filename>classSbVec3ub.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec3ui32</name>
    <filename>classSbVec3ui32.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec3us</name>
    <filename>classSbVec3us.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec4b</name>
    <filename>classSbVec4b.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec4d</name>
    <filename>classSbVec4d.html</filename>
    <member kind="function">
      <type></type>
      <name>SbVec4d</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>ac7b884bfbc3a4b9ce649cdb59de77c79</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4d</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a4b144ff8a8ac21844af1a5b3726116fa</anchor>
      <arglist>(const double v[4])</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4d</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a0837c17f58fa7dcec2691c541518aece</anchor>
      <arglist>(double x, double y, double z, double w)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4d</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>aee7e6576a17bc24a36855fe435afb4f1</anchor>
      <arglist>(const SbVec4f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4d</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>ac01e33c7da04a3a6a5cc6c3fd6283d44</anchor>
      <arglist>(const SbVec4b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4d</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>ac1efc8004cd66e8db305e3ceedf10115</anchor>
      <arglist>(const SbVec4s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4d</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>ae434ea3369094a66f4f2248fdade51d5</anchor>
      <arglist>(const SbVec4i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a3935367aceacc5ec86a5e6e696f89e60</anchor>
      <arglist>(const double v[4])</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>ade3661a30bd5f8b3eb0304d0f473a5e0</anchor>
      <arglist>(double x, double y, double z, double w)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a47b57f921f695d62482ed7bab91113d2</anchor>
      <arglist>(const SbVec4f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>ae09ccacd8d4a66f1da6e9e1c256ce9b4</anchor>
      <arglist>(const SbVec4b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a675ded6aca0f8ef91ac9bf30ad8e1ac8</anchor>
      <arglist>(const SbVec4s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a2a3136bdafc59fcf0fb4205b0efbeca1</anchor>
      <arglist>(const SbVec4i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>const double *</type>
      <name>getValue</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>aa2c5a322d67a97574d03a43b69698dfa</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a038c1f00b48492c8cf0eae2036c95178</anchor>
      <arglist>(double &amp;x, double &amp;y, double &amp;z, double &amp;w) const</arglist>
    </member>
    <member kind="function">
      <type>double &amp;</type>
      <name>operator []</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>aaf4895d1fa3dc823fd3b74744568cce5</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>const double &amp;</type>
      <name>operator []</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a2ad0293c83ed7c956e13e1844fc55225</anchor>
      <arglist>(int i) const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>dot</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a6d25e000507c70c6d4f7545a9d307849</anchor>
      <arglist>(const SbVec4d &amp;v) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>equals</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>aa7f3609de8f20dce93f190cba0864ecf</anchor>
      <arglist>(const SbVec4d &amp;v, double tolerance) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getReal</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a3522e6e34b507d29e95607f38e1abafd</anchor>
      <arglist>(SbVec3d &amp;v) const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>length</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>af2386a04d61543d4b3953749f9a30970</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>sqrLength</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>aaf434f08eae3b15c94414e0cebdb0956</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>negate</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>ad954080acdc3f04dcf367720462677fd</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>normalize</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>aac6b1ddbae7284245537b7354f7bcc92</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d &amp;</type>
      <name>operator *=</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>adbe5109883887491fd146b3a10ffe79a</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>aa53a7b2961acae8d12ab2362b445c951</anchor>
      <arglist>(const SbVec4d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d &amp;</type>
      <name>operator -=</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a76c3e5aa63aa6c66b9a5f4de1bc2a562</anchor>
      <arglist>(const SbVec4d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d</type>
      <name>operator -</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>ae4bebd11855a4cf336bcd386669b60e0</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a3819ab891f966f4b979ffef6b5213b0f</anchor>
      <arglist>(FILE *fp) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d</type>
      <name>operator *</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a8e1753ac0850ab4d33182bc76709bb19</anchor>
      <arglist>(const SbVec4d &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d</type>
      <name>operator *</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a9c288e945dd970580d48503584555f2a</anchor>
      <arglist>(double d, const SbVec4d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d</type>
      <name>operator/</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>ae02649fb85b10ede354e713efb7c55fb</anchor>
      <arglist>(const SbVec4d &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d</type>
      <name>operator+</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a7e01a6afd5a4380ae240805cd96744c2</anchor>
      <arglist>(const SbVec4d &amp;v1, const SbVec4d &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d</type>
      <name>operator -</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a5edb5c9e39cf1c649a5404c2d48ee86a</anchor>
      <arglist>(const SbVec4d &amp;v1, const SbVec4d &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a38923a1aab2ce280682f0c33f7229789</anchor>
      <arglist>(const SbVec4d &amp;v1, const SbVec4d &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator !=</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a166e7adac7b1c02c06b3802c874ed42c</anchor>
      <arglist>(const SbVec4d &amp;v1, const SbVec4d &amp;v2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbVec4f</name>
    <filename>classSbVec4f.html</filename>
    <member kind="function">
      <type></type>
      <name>SbVec4f</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a8906e1c6054ce209d1f6d77a21515e44</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4f</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>ad731535c83725d6bdc900b9a30ab4c92</anchor>
      <arglist>(const float v[4])</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4f</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>adf498d940df41d8a89e34bffcb3cf2b8</anchor>
      <arglist>(float x, float y, float z, float w)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4f</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a8545647ed869389186e93b47b7e2d52e</anchor>
      <arglist>(const SbVec4d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4f</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a98e08f627dac939645bb52580db3c4aa</anchor>
      <arglist>(const SbVec4b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4f</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a254dd416048917eee27af0b8463fbd48</anchor>
      <arglist>(const SbVec4s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4f</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>ac83cc2c568738c8781fcee9b2fde8cf8</anchor>
      <arglist>(const SbVec4i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a5a641bc3d9805f860ed2c5d2b635389e</anchor>
      <arglist>(const float v[4])</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>aa064707268b43ad1df00633375e7e092</anchor>
      <arglist>(float x, float y, float z, float w)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a9c1937f4c3d7b1148957a0ac6d67b72f</anchor>
      <arglist>(const SbVec4d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>aee85f8205cddc571831987e400c4775e</anchor>
      <arglist>(const SbVec4b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a2cb09fafbc258b541f6cd85c7e0a6b04</anchor>
      <arglist>(const SbVec4s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a6122ce3070d5e7ee16db5cb9ef89b173</anchor>
      <arglist>(const SbVec4i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>const float *</type>
      <name>getValue</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>abac4ee260db49f80da545978de2a9858</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>ab972b9946330047984521bd05b601b9b</anchor>
      <arglist>(float &amp;x, float &amp;y, float &amp;z, float &amp;w) const</arglist>
    </member>
    <member kind="function">
      <type>float &amp;</type>
      <name>operator []</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>af0de9512650fdfa17ddbc7a1c19b99e9</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>const float &amp;</type>
      <name>operator []</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a94ed403f27072c4f4ccc41a66f1f7738</anchor>
      <arglist>(int i) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>equals</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a90d86b1e759ad899d951cc820c29a5bc</anchor>
      <arglist>(const SbVec4f &amp;v, float tolerance) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>dot</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>ae711b047c9a255b89b2134b28f882fe7</anchor>
      <arglist>(const SbVec4f &amp;v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getReal</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a7cc22dfb8e4e4499bc31fc4d77a47a02</anchor>
      <arglist>(SbVec3f &amp;v) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>length</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>af5c90616554e3a871b3d9aea1f38afec</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>sqrLength</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a77a3b372c37bfb7be3f2201f48d2dd05</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>negate</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>ac87c676afcddcdd4c4a8e4dfacaaf81e</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>normalize</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>aee89703dbbd922b7c3df9084787af3bd</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f &amp;</type>
      <name>operator *=</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a78a1d2cbc362b4d8533a209143449f6f</anchor>
      <arglist>(float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a386fce6ce83b627ec4fe352241301ad0</anchor>
      <arglist>(float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>abe309edc1357ce93eb1f218c6eb1e1ba</anchor>
      <arglist>(const SbVec4f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f &amp;</type>
      <name>operator -=</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>ad7fb85a65fdbdbb8a4724be6cf3a9821</anchor>
      <arglist>(const SbVec4f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f</type>
      <name>operator -</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>aefbc32481a2c04e48dc6e263c1be5bb4</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a5294aebcd7af71ffb897447aee7bf6f9</anchor>
      <arglist>(FILE *fp) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f</type>
      <name>operator *</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a82dc54beb7148f1ba56d84d2cbab3768</anchor>
      <arglist>(const SbVec4f &amp;v, float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f</type>
      <name>operator *</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a0e22efc0c64e5826143f95fd5964a38f</anchor>
      <arglist>(float d, const SbVec4f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f</type>
      <name>operator/</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>af0c94dc96d51452294649791712c142a</anchor>
      <arglist>(const SbVec4f &amp;v, float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f</type>
      <name>operator+</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>abc1db057a8df5be3eb7f5d19f90b0e58</anchor>
      <arglist>(const SbVec4f &amp;v1, const SbVec4f &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f</type>
      <name>operator -</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a20f390da185eb5704d0ea457c0c5c72b</anchor>
      <arglist>(const SbVec4f &amp;v1, const SbVec4f &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>aaaeee53660c883978e3ab2b0cfc27a77</anchor>
      <arglist>(const SbVec4f &amp;v1, const SbVec4f &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator !=</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>acb516b176ac41e981c82fbe1031746e7</anchor>
      <arglist>(const SbVec4f &amp;v1, const SbVec4f &amp;v2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbVec4i32</name>
    <filename>classSbVec4i32.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec4s</name>
    <filename>classSbVec4s.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec4ub</name>
    <filename>classSbVec4ub.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec4ui32</name>
    <filename>classSbVec4ui32.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec4us</name>
    <filename>classSbVec4us.html</filename>
  </compound>
  <compound kind="class">
    <name>SbViewportRegion</name>
    <filename>classSbViewportRegion.html</filename>
    <member kind="function">
      <type></type>
      <name>SbViewportRegion</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>af522056ea9d27359b03cb2b88536f0e2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbViewportRegion</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>af415380060c898ed123ba1b3cf120802</anchor>
      <arglist>(short width, short height)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbViewportRegion</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a9573bcfcce0b7e9ffa774d82f0fc09ad</anchor>
      <arglist>(SbVec2s winSize)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbViewportRegion</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a8b9832f4a55148a0553529c1c6cc0966</anchor>
      <arglist>(const SbViewportRegion &amp;vpReg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWindowSize</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a0ae54dc0d8416d2cccdb0b3d6d3ae640</anchor>
      <arglist>(short width, short height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWindowSize</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a8772016f85c60dd7737eabca3483f0da</anchor>
      <arglist>(SbVec2s winSize)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setViewport</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>aee9986763e2234c411c8822206db539d</anchor>
      <arglist>(float left, float bottom, float width, float height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setViewport</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>ad5f9e32fb1fde9ea5825572c76d06e57</anchor>
      <arglist>(SbVec2f origin, SbVec2f size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setViewportPixels</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a2977b42c205177a6e89b3860fd823951</anchor>
      <arglist>(short left, short bottom, short width, short height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setViewportPixels</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a98cd719e0afc2b942f0cd99110b8aff0</anchor>
      <arglist>(SbVec2s origin, SbVec2s size)</arglist>
    </member>
    <member kind="function">
      <type>const SbVec2s &amp;</type>
      <name>getWindowSize</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>ae63f4e7cae3adb1b27f6b78fd37f6d8b</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec2f &amp;</type>
      <name>getViewportOrigin</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a28055ad0bd9d1d55cdc25e6d2dd71eb5</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec2s &amp;</type>
      <name>getViewportOriginPixels</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a4bb4240ca032f59004c6169d2eaeec21</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec2f &amp;</type>
      <name>getViewportSize</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a02a6c39bb08a460cbfd2ce0bdfe1a6c9</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec2s &amp;</type>
      <name>getViewportSizePixels</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>aa535cf3a9b7a91c08abad5e6026908c0</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getViewportAspectRatio</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>ab2a189d0f49034a9c011940b6de6287c</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scaleWidth</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a11855a05e9ed450a22cddffdcb373e58</anchor>
      <arglist>(float ratio)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scaleHeight</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>ab3249cb0a55be9ced4681951283a176e</anchor>
      <arglist>(float ratio)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPixelsPerInch</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a13bf92c587ea65ea35bafbd342b11d44</anchor>
      <arglist>(float ppi)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getPixelsPerInch</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a3707ffb4733c62969c7d2dabb48b4315</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getPixelsPerPoint</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>ab21864aeedaadd249ad0b044e08fcdc2</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a24a129704980d044e361f65171300e5b</anchor>
      <arglist>(FILE *file) const</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a759c633952740a45c23994bec51fb830</anchor>
      <arglist>(const SbViewportRegion &amp;reg1, const SbViewportRegion &amp;reg2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>aa4ea8adbc5071d1d32e113fbeaeb1597</anchor>
      <arglist>(const SbViewportRegion &amp;reg1, const SbViewportRegion &amp;reg2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbViewVolume</name>
    <filename>classSbViewVolume.html</filename>
    <member kind="enumeration">
      <type></type>
      <name>ProjectionType</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a769616c39bae7ee4e78bac640e0bdaf4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ORTHOGRAPHIC</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a769616c39bae7ee4e78bac640e0bdaf4a19f676b5e880a7189080151156b64337</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PERSPECTIVE</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a769616c39bae7ee4e78bac640e0bdaf4a9538d7439b5b05a137f9e33f8bd4e014</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ORTHOGRAPHIC</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a769616c39bae7ee4e78bac640e0bdaf4a19f676b5e880a7189080151156b64337</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PERSPECTIVE</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a769616c39bae7ee4e78bac640e0bdaf4a9538d7439b5b05a137f9e33f8bd4e014</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbViewVolume</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>acbcf2f7f32cf0e74b4655367b4a8fe94</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbViewVolume</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>abc5d921466ff37e56d462f2d126ab87d</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getMatrices</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a361857e419c54359380fd1ad758ad03b</anchor>
      <arglist>(SbMatrix &amp;affine, SbMatrix &amp;proj) const</arglist>
    </member>
    <member kind="function">
      <type>SbMatrix</type>
      <name>getMatrix</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>ad4dce507aa618f86c0f23f14d04ccf1e</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbMatrix</type>
      <name>getCameraSpaceMatrix</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>adf2a742bb03cd52dd20a9f86918f7e15</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>projectPointToLine</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a1abcca6f87d1a784e23d94e6f111ca40</anchor>
      <arglist>(const SbVec2f &amp;pt, SbLine &amp;line) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>projectPointToLine</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a99d792abb0862e83f6e931241de334f3</anchor>
      <arglist>(const SbVec2f &amp;pt, SbVec3f &amp;line0, SbVec3f &amp;line1) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>projectToScreen</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a5f3c7be330c62cf0d04a3adc3324b3d7</anchor>
      <arglist>(const SbVec3f &amp;src, SbVec3f &amp;dst) const</arglist>
    </member>
    <member kind="function">
      <type>SbPlane</type>
      <name>getPlane</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a5c5e90dc4ebdff0cbb12aadad1211296</anchor>
      <arglist>(const float distFromEye) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getSightPoint</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a8058eda4ea4999ee2072c0bab91defac</anchor>
      <arglist>(const float distFromEye) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getPlanePoint</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>adc4eed5b28544e7c81ad68a5b1bbb5bd</anchor>
      <arglist>(const float distFromEye, const SbVec2f &amp;normPoint) const</arglist>
    </member>
    <member kind="function">
      <type>SbRotation</type>
      <name>getAlignRotation</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>ab5b7bc52ee00a8f7acee49ff1336ebfa</anchor>
      <arglist>(SbBool rightAngleOnly=FALSE) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getWorldToScreenScale</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a440d458d33da7d0847b4b45bd88eba36</anchor>
      <arglist>(const SbVec3f &amp;worldCenter, float normRadius) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f</type>
      <name>projectBox</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>ad812156832e0ef72d9390017721ffbfd</anchor>
      <arglist>(const SbBox3f &amp;box) const</arglist>
    </member>
    <member kind="function">
      <type>SbViewVolume</type>
      <name>narrow</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a8ec02ece7009c5b22a78d2a1b07e665e</anchor>
      <arglist>(float left, float bottom, float right, float top) const</arglist>
    </member>
    <member kind="function">
      <type>SbViewVolume</type>
      <name>narrow</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a620eb95b0f519ce61fba840a1fec887b</anchor>
      <arglist>(const SbBox3f &amp;box) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ortho</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a74cccdb71cc35fb5b3b084917031ebe7</anchor>
      <arglist>(float left, float right, float bottom, float top, float nearval, float farval)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>perspective</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>aa62d154de3ec060318a8bc49d59c5422</anchor>
      <arglist>(float fovy, float aspect, float nearval, float farval)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>frustum</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a3bdbe7dc553465904db3b42fa295b48e</anchor>
      <arglist>(float left, float right, float bottom, float top, float nearval, float farval)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rotateCamera</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a7f048618c8b356e7cc5af37d81972a5d</anchor>
      <arglist>(const SbRotation &amp;q)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>translateCamera</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a7a29ff8f99f24a9d16defe527ff0fc0f</anchor>
      <arglist>(const SbVec3f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>zVector</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a01eff5b96bce3baa463f9e8f61c631c2</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbViewVolume</type>
      <name>zNarrow</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>ac4aaaf3397769127fe0ddce905e36549</anchor>
      <arglist>(float nearval, float farval) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scale</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a8ba76dfded56d0e9b41a3c4f8adec007</anchor>
      <arglist>(float factor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scaleWidth</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a9d2eb384e69810c23df5748342e081d3</anchor>
      <arglist>(float ratio)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scaleHeight</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a93de473b12e0847fd6aa31a9d143f5c9</anchor>
      <arglist>(float ratio)</arglist>
    </member>
    <member kind="function">
      <type>ProjectionType</type>
      <name>getProjectionType</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a169b2cb01d564c396ddff910b993cf17</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f &amp;</type>
      <name>getProjectionPoint</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a68f251ada689b325d2258d4a23a0283d</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f &amp;</type>
      <name>getProjectionDirection</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>ae683db05d229799fec177f4faa478704</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getNearDist</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a8fe846023809b1e7c8be6fa2c75ca691</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getWidth</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>ae0a61ceb417263974b5b8ec26005f4dc</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getHeight</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a60fe063f25c704c8d61c5f5bb5aab514</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getDepth</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>aba39279735846d481bc98dd35f8b56be</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a6e9db79aac2cd78e3d551bf79585e3b1</anchor>
      <arglist>(FILE *fp) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getViewVolumePlanes</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a3001d19bd399cc7a5970413e868f2cae</anchor>
      <arglist>(SbPlane planes[6]) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transform</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a0f836b45107fedfea1a212aeaed38a3e</anchor>
      <arglist>(const SbMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getViewUp</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a06781a61a59a69b7ab80f2fba949c6ee</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>afc04ec170f132454b3ebdeaada67586e</anchor>
      <arglist>(const SbVec3f &amp;p) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a94a69acfa321f46f636a1ca2e407d659</anchor>
      <arglist>(const SbVec3f &amp;p0, const SbVec3f &amp;p1, SbVec3f &amp;closestpoint) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a0a0748a30844a0a5453b9307e68ac25f</anchor>
      <arglist>(const SbBox3f &amp;box) const</arglist>
    </member>
    <member kind="function">
      <type>SbBox3f</type>
      <name>intersectionBox</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a11d9ee44fa1d6ba5ae84794855b809cb</anchor>
      <arglist>(const SbBox3f &amp;box) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>outsideTest</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a8ce7d5f0b99ddc02074ea3d6cc9724ef</anchor>
      <arglist>(const SbPlane &amp;p, const SbVec3f &amp;bmin, const SbVec3f &amp;bmax) const</arglist>
    </member>
    <member kind="function">
      <type>const SbDPViewVolume &amp;</type>
      <name>getDPViewVolume</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a50cbdca80d245d8b986192a99fd4cdd6</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="variable">
      <type>ProjectionType</type>
      <name>type</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a8299568cb7ad6fda09eec92adede6877</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SbVec3f</type>
      <name>projPoint</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>ab473472322064d5b790a0361fc31ec00</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SbVec3f</type>
      <name>projDir</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a3d66037590e6ad2f2ba8d8e63cb72e02</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>float</type>
      <name>nearDist</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a063842c5cf236a3b5351fa4241679730</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>float</type>
      <name>nearToFar</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a6c20b2e40244a5c83d52e97c169d7e0e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SbVec3f</type>
      <name>llf</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>adf2952f98c0edf4ae4416858d906f3f3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SbVec3f</type>
      <name>lrf</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a152c5ad6f9182d94dbc8e36bf1c994e2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SbVec3f</type>
      <name>ulf</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>acdeb4aa5b5c465b64a90dddcd8f06ffd</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbXfBox3d</name>
    <filename>classSbXfBox3d.html</filename>
    <base>SbBox3d</base>
    <member kind="function">
      <type></type>
      <name>SbXfBox3d</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a44adce59ac262e3deb32a42bc536c824</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbXfBox3d</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>aec9342cfb81b97f1591e601c7c8f04b1</anchor>
      <arglist>(const SbVec3d &amp;boxmin, const SbVec3d &amp;boxmax)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbXfBox3d</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a7b56b4cc56417ef51d429719f2b735e2</anchor>
      <arglist>(const SbBox3d &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTransform</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>acedc78abc26655c9775bc6bfdb35d281</anchor>
      <arglist>(const SbDPMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>const SbDPMatrix &amp;</type>
      <name>getTransform</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a29e7e62fa9d0e52bdd83943eaa0bda43</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>const SbDPMatrix &amp;</type>
      <name>getInverse</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a7a217cf27763d0366a458019803e2fc2</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>getCenter</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a872dc6688701761cd48ebdc3e75f414e</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a8da790ddabc38dedcac25228fe89eef5</anchor>
      <arglist>(const SbVec3d &amp;pt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a64874cec573cb996acd53e57779ac100</anchor>
      <arglist>(const SbBox3d &amp;bb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a18392992a10fbbcf77c2c77124492cfd</anchor>
      <arglist>(const SbXfBox3d &amp;bb)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>ac0cf8e324003d6511311041b6dd132ec</anchor>
      <arglist>(const SbVec3d &amp;pt) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a86897c4ed59c3acf5969f9a8a3c37313</anchor>
      <arglist>(const SbBox3d &amp;bb) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>aefdbf228f70547094cb2396a7516deed</anchor>
      <arglist>(const SbXfBox3d &amp;bb) const</arglist>
    </member>
    <member kind="function">
      <type>SbBox3d</type>
      <name>project</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a02c8f5b68471f4c091e67dfc134a2993</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getSpan</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>ab4fa1e58fd636183d98373c249e32bbc</anchor>
      <arglist>(const SbVec3d &amp;direction, double &amp;dMin, double &amp;dMax) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transform</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a6bc269dedda3d499ccd711fb66dd4474</anchor>
      <arglist>(const SbDPMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getVolume</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>aa4230472a5c2cbe062fa5fd822495f27</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbXfBox3f</name>
    <filename>classSbXfBox3f.html</filename>
    <base>SbBox3f</base>
    <member kind="function">
      <type></type>
      <name>SbXfBox3f</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a2adb39957d667d7bdc8d3b2c73bf03ee</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbXfBox3f</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>afebdecf40efde099111da9108b6c0f0a</anchor>
      <arglist>(const SbVec3f &amp;boxmin, const SbVec3f &amp;boxmax)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbXfBox3f</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a0434ffabf617a0709fd8906650777425</anchor>
      <arglist>(const SbBox3f &amp;box)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbXfBox3f</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a5f7d0963b5d178faec3752339e08edda</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTransform</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a8283248fd57a70c3c9c9fe15a04733f2</anchor>
      <arglist>(const SbMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>const SbMatrix &amp;</type>
      <name>getTransform</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>aa087905c77d99e6f6b8db14b754d400b</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>const SbMatrix &amp;</type>
      <name>getInverse</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>ab6eafea15cd5b4e31d32b11a1480f9c1</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getCenter</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>ab3c46bbba08f8db60507669a52b6fb96</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>af8ea6006198bccfd6857d43fbb853db0</anchor>
      <arglist>(const SbVec3f &amp;pt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>aca7f30a621d18216f8ed2cc9fb621f9a</anchor>
      <arglist>(const SbBox3f &amp;bb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a05f077bbffbfae38d6a6cdb76aba253f</anchor>
      <arglist>(const SbXfBox3f &amp;bb)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>ac8b1115422b3442a96f5a7497de29a23</anchor>
      <arglist>(const SbVec3f &amp;pt) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a368e72adb472385dc90600f926b84bb7</anchor>
      <arglist>(const SbBox3f &amp;bb) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>af2eb910ec804a2008aedc6232ce3b2fd</anchor>
      <arglist>(const SbXfBox3f &amp;bb) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getSpan</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a672483dcde09b255191872607916cdf0</anchor>
      <arglist>(const SbVec3f &amp;direction, float &amp;dMin, float &amp;dMax) const</arglist>
    </member>
    <member kind="function">
      <type>SbBox3f</type>
      <name>project</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a1fef055b01da1585f6be3deeaf10ee77</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transform</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a011e2b7df656b970e4bf09937cda6498</anchor>
      <arglist>(const SbMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getVolume</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>ab621d8c83592e911a4dccc29fc072af5</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a5d07d6992a04d8917842d4b8d69307b8</anchor>
      <arglist>(FILE *file) const</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a9b6bfb6e1bad9a583fe7cae59cec244f</anchor>
      <arglist>(const SbXfBox3f &amp;b1, const SbXfBox3f &amp;b2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator !=</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>adbd5fed43ac5cc15c42ab82090360b3f</anchor>
      <arglist>(const SbXfBox3f &amp;b1, const SbXfBox3f &amp;b2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXML</name>
    <filename>classScXML.html</filename>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClasses</name>
      <anchorfile>classScXML.html</anchorfile>
      <anchor>a575021fd42fe7862aeaadef4d79cfc50</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static ScXMLStateMachine *</type>
      <name>readFile</name>
      <anchorfile>classScXML.html</anchorfile>
      <anchor>a1cf5fd33dccf83b71c676b74996c2843</anchor>
      <arglist>(const char *filename)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static ScXMLStateMachine *</type>
      <name>readBuffer</name>
      <anchorfile>classScXML.html</anchorfile>
      <anchor>a94ab99dfd3b0be6d49a521088e59c49a</anchor>
      <arglist>(const SbByteBuffer &amp;buffer)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLAbstractStateElt</name>
    <filename>classScXMLAbstractStateElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="pure">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLAbstractStateElt.html</anchorfile>
      <anchor>a867c54d30371c84bb914eab9eeca8b60</anchor>
      <arglist>(void) const =0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLAbstractStateElt.html</anchorfile>
      <anchor>aeb4dd3b18eb44246b68770299c6d41e6</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLAbstractStateElt.html</anchorfile>
      <anchor>a82c121e5111f4af5945d260f0f73129f</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLAddOpExprDataObj</name>
    <filename>classScXMLAddOpExprDataObj.html</filename>
    <base>ScXMLExprDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLAddOpExprDataObj.html</anchorfile>
      <anchor>a331c19e1b4634550d6cad041cdf4ac68</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLAnchorElt</name>
    <filename>classScXMLAnchorElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLAnchorElt.html</anchorfile>
      <anchor>a72b3e6bfa741610696c8f71457de42e6</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLAnchorElt.html</anchorfile>
      <anchor>a99563ba2ea8f290d1bd4fca33a9ae20c</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLAnchorElt.html</anchorfile>
      <anchor>a1967103114d7ace69c4d679ff7a0082a</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLAndOpExprDataObj</name>
    <filename>classScXMLAndOpExprDataObj.html</filename>
    <base>ScXMLExprDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLAndOpExprDataObj.html</anchorfile>
      <anchor>aa134377f577f2f9d5d3b12191db63e89</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLAppendOpExprDataObj</name>
    <filename>classScXMLAppendOpExprDataObj.html</filename>
    <base>ScXMLExprDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLAppendOpExprDataObj.html</anchorfile>
      <anchor>abf7773622c0685de8585cdf2f7eefac2</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLAssignElt</name>
    <filename>classScXMLAssignElt.html</filename>
    <base>ScXMLExecutableElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLAssignElt.html</anchorfile>
      <anchor>a0d351724784147a3f92c7f909ca1d973</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ScXMLAssignElt</name>
      <anchorfile>classScXMLAssignElt.html</anchorfile>
      <anchor>a5284526a47273ba0a92fd09a42af74c5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLAssignElt.html</anchorfile>
      <anchor>a365ebe17d543bfbc44783cd932030ce6</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLAssignElt.html</anchorfile>
      <anchor>aafd764188f56914aa61c2ff520d758b3</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classScXMLAssignElt.html</anchorfile>
      <anchor>ada746ed6fe36b4c6065d1e272cb66050</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>cleanClass</name>
      <anchorfile>classScXMLAssignElt.html</anchorfile>
      <anchor>ac9629e5875b1b5cedc7769b9c9e36001</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLBoolDataObj</name>
    <filename>classScXMLBoolDataObj.html</filename>
    <base>ScXMLConstantDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLBoolDataObj.html</anchorfile>
      <anchor>afe498dcdc3803ef8bcd583d2778e5f76</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLCoinAddOpExprDataObj</name>
    <filename>classScXMLCoinAddOpExprDataObj.html</filename>
    <base>ScXMLAddOpExprDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLCoinAddOpExprDataObj.html</anchorfile>
      <anchor>a1f9d4e255269eeeaf17a4c1825d92ee7</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLCoinDivideOpExprDataObj</name>
    <filename>classScXMLCoinDivideOpExprDataObj.html</filename>
    <base>ScXMLDivideOpExprDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLCoinDivideOpExprDataObj.html</anchorfile>
      <anchor>a4f2e7391c5a283cf815d09b40c258323</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLCoinEqualsOpExprDataObj</name>
    <filename>classScXMLCoinEqualsOpExprDataObj.html</filename>
    <base>ScXMLEqualsOpExprDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLCoinEqualsOpExprDataObj.html</anchorfile>
      <anchor>a7a5541c16411866898cf4621efdd0522</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLCoinEvaluator</name>
    <filename>classScXMLCoinEvaluator.html</filename>
    <base>ScXMLEvaluator</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLCoinEvaluator.html</anchorfile>
      <anchor>a8d5f6f74fd48a32dd672db9f191c35d2</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setStateMachine</name>
      <anchorfile>classScXMLCoinEvaluator.html</anchorfile>
      <anchor>a9b3cc77cd58c18d836f3fb5885436e33</anchor>
      <arglist>(ScXMLStateMachine *sm)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ScXMLDataObj *</type>
      <name>evaluate</name>
      <anchorfile>classScXMLCoinEvaluator.html</anchorfile>
      <anchor>ac70918f4a3a3a3dad5e7f37f8e4706f0</anchor>
      <arglist>(const char *expression) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>clearTemporaryVariables</name>
      <anchorfile>classScXMLCoinEvaluator.html</anchorfile>
      <anchor>aeb19052d03db41282f624ec86b58bb1f</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLCoinLengthFuncExprDataObj</name>
    <filename>classScXMLCoinLengthFuncExprDataObj.html</filename>
    <base>ScXMLExprDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLCoinLengthFuncExprDataObj.html</anchorfile>
      <anchor>a68609b2b1f0b505ac4f8c76e420c0447</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLCoinMultiplyOpExprDataObj</name>
    <filename>classScXMLCoinMultiplyOpExprDataObj.html</filename>
    <base>ScXMLMultiplyOpExprDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLCoinMultiplyOpExprDataObj.html</anchorfile>
      <anchor>ab54ac2a7f2be1a9611d76e7a05944e64</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLCoinSubtractOpExprDataObj</name>
    <filename>classScXMLCoinSubtractOpExprDataObj.html</filename>
    <base>ScXMLSubtractOpExprDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLCoinSubtractOpExprDataObj.html</anchorfile>
      <anchor>ac0296ed95e40ec88b281fe05dc058c26</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLConstantDataObj</name>
    <filename>classScXMLConstantDataObj.html</filename>
    <base>ScXMLDataObj</base>
    <member kind="function" virtualness="pure">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLConstantDataObj.html</anchorfile>
      <anchor>a8c426234b6bb8ece08fcd426d74f0270</anchor>
      <arglist>(void) const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLContentElt</name>
    <filename>classScXMLContentElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLContentElt.html</anchorfile>
      <anchor>ae351dfe0caa242ee7697656afe26d236</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLDataElt</name>
    <filename>classScXMLDataElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLDataElt.html</anchorfile>
      <anchor>a7f5a3e926461fa39d78f8fff76129b55</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLDataElt.html</anchorfile>
      <anchor>adbae717dc44fe179e36b6b3917dd98b7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLDataElt.html</anchorfile>
      <anchor>ae9b93c1323a8c76a8d3b0102ba032b0d</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLDataModelElt</name>
    <filename>classScXMLDataModelElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLDataModelElt.html</anchorfile>
      <anchor>a1e755fcaf2c410223b0d90e88c9cd257</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLDataModelElt.html</anchorfile>
      <anchor>a8a15fbe319261c8645985da8f1143738</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLDataModelElt.html</anchorfile>
      <anchor>a512bc34d7c9d63e4e63263404601c36f</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLDataObj</name>
    <filename>classScXMLDataObj.html</filename>
    <base>ScXMLObject</base>
    <member kind="function" virtualness="pure">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLDataObj.html</anchorfile>
      <anchor>aa8f127e9e677b82f01f321b18a298e16</anchor>
      <arglist>(void) const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLDivideOpExprDataObj</name>
    <filename>classScXMLDivideOpExprDataObj.html</filename>
    <base>ScXMLExprDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLDivideOpExprDataObj.html</anchorfile>
      <anchor>a67b6797b08a600a9cdaa30ff9392cc13</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLDocument</name>
    <filename>classScXMLDocument.html</filename>
    <base>ScXMLObject</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLDocument.html</anchorfile>
      <anchor>aa5337f49246c0f1a6d5917fc0058b3a5</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLECMAScriptEvaluator</name>
    <filename>classScXMLECMAScriptEvaluator.html</filename>
    <base>ScXMLEvaluator</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLECMAScriptEvaluator.html</anchorfile>
      <anchor>a525246e396739dea336c1921a5fd5c64</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLElseElt</name>
    <filename>classScXMLElseElt.html</filename>
    <base>ScXMLExecutableElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLElseElt.html</anchorfile>
      <anchor>a7298a41a79592cf8a0e9947a7c2ba7b5</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLElseIfElt</name>
    <filename>classScXMLElseIfElt.html</filename>
    <base>ScXMLExecutableElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLElseIfElt.html</anchorfile>
      <anchor>ada89fc99f57ab0e2ceb0cfd431679efd</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLElseIfElt.html</anchorfile>
      <anchor>a0150583699cdc62856c7dc3e949ad520</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLElseIfElt.html</anchorfile>
      <anchor>a4ae2104a2dad43abf6b63840162fcee7</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLElt</name>
    <filename>classScXMLElt.html</filename>
    <base>ScXMLObject</base>
    <member kind="function" virtualness="pure">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLElt.html</anchorfile>
      <anchor>a3b97c34ff5fba99583caa4d8ef5252d2</anchor>
      <arglist>(void) const =0</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setXMLAttribute</name>
      <anchorfile>classScXMLElt.html</anchorfile>
      <anchor>abb8824092c35f5293d957065a0259396</anchor>
      <arglist>(const char *attribute, const char *value)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>getXMLAttribute</name>
      <anchorfile>classScXMLElt.html</anchorfile>
      <anchor>a4378b50af2d2154767933238a5a1f743</anchor>
      <arglist>(const char *attribute) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLElt.html</anchorfile>
      <anchor>ac76e77f8ecedd593ec87b0fa1ee5f7df</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLElt.html</anchorfile>
      <anchor>aa38cbdab911d6eb5c003aeb66acc89b2</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
    <member kind="function">
      <type>ScXMLElt *</type>
      <name>clone</name>
      <anchorfile>classScXMLElt.html</anchorfile>
      <anchor>a0771e7f9b586233f3496500cbb0a01ac</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setContainer</name>
      <anchorfile>classScXMLElt.html</anchorfile>
      <anchor>ac663bd4b53820306beef387a6e1a916b</anchor>
      <arglist>(ScXMLElt *container)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isContainedIn</name>
      <anchorfile>classScXMLElt.html</anchorfile>
      <anchor>ac2f8600c79c1f5ed87d23e1d9c204262</anchor>
      <arglist>(const ScXMLElt *object) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLEltReader</name>
    <filename>classScXMLEltReader.html</filename>
  </compound>
  <compound kind="class">
    <name>ScXMLEqualsOpExprDataObj</name>
    <filename>classScXMLEqualsOpExprDataObj.html</filename>
    <base>ScXMLExprDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLEqualsOpExprDataObj.html</anchorfile>
      <anchor>a212d86df462e6d05ce529435380e3e62</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLEvaluator</name>
    <filename>classScXMLEvaluator.html</filename>
    <base>ScXMLObject</base>
    <member kind="function" virtualness="pure">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLEvaluator.html</anchorfile>
      <anchor>a22f5bcbd102a6ebfbf399c35addc24e6</anchor>
      <arglist>(void) const =0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setStateMachine</name>
      <anchorfile>classScXMLEvaluator.html</anchorfile>
      <anchor>a903df9c19b4a93b2988b57672f417d3c</anchor>
      <arglist>(ScXMLStateMachine *sm)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>clearTemporaryVariables</name>
      <anchorfile>classScXMLEvaluator.html</anchorfile>
      <anchor>a7eb59462c0c8b1a267522a89ec22d607</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLEvent</name>
    <filename>classScXMLEvent.html</filename>
    <base>ScXMLObject</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLEvent.html</anchorfile>
      <anchor>a0a46b68ba8de78fcfc9600a8202ec1db</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setEventName</name>
      <anchorfile>classScXMLEvent.html</anchorfile>
      <anchor>a7c1112de3684d5726726fbf97bfdffe3</anchor>
      <arglist>(const SbName &amp;name)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLEventElt</name>
    <filename>classScXMLEventElt.html</filename>
    <base>ScXMLExecutableElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLEventElt.html</anchorfile>
      <anchor>a31914a1058b99685a38c29d7eeba8dff</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLEventElt.html</anchorfile>
      <anchor>ad2e64434411a92e1a6659408ff9f89f4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLEventElt.html</anchorfile>
      <anchor>ac85c75d7a44ac96db8edd2d629be86f8</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLEventTarget</name>
    <filename>classScXMLEventTarget.html</filename>
    <base>ScXMLObject</base>
    <member kind="function" virtualness="pure">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>a83c3e492e1f1cd43160447442ca05828</anchor>
      <arglist>(void) const =0</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ScXMLEventTarget</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>a8e874c8fee8316b3a2fd75a6936e52de</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ScXMLEventTarget</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>ac3df6642b7fdc94eb395ec662f931de7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setEventTargetType</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>a694726f866c9375e59a23fa452448a59</anchor>
      <arglist>(const char *targettype)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setEventTargetName</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>a01f9001ba754d17f13caa7bf4c616441</anchor>
      <arglist>(const char *targetname)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLEvent *</type>
      <name>getCurrentEvent</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>a2cde2c49534e0d7e430c41908e949f85</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>queueEvent</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>a023f131293775c89553361dace4be77b</anchor>
      <arglist>(const ScXMLEvent *event)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>queueEvent</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>a148b192e2023df0791fb6a31e20ae780</anchor>
      <arglist>(const SbName &amp;eventid)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>processEventQueue</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>aa3d16a8a6bf692e27c582265718f4870</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>sendExternalEvent</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>ab8e655ff48e2ebdfc5fb0c86d6c0ed98</anchor>
      <arglist>(const ScXMLSendElt *sendelt)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>sendInternalEvent</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>ac73c18b66a68eb85e9278dc8221228d6</anchor>
      <arglist>(const ScXMLEventElt *sendelt)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>queueInternalEvent</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>a8b89a0434ab290c60e38a7d1eb33baf0</anchor>
      <arglist>(const ScXMLEvent *event)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>queueInternalEvent</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>a1099010bf8b651dd898bd03bb529e31b</anchor>
      <arglist>(const SbName &amp;eventid)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>setCurrentEvent</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>aef63077fd0be0d7d5517782eba5041a1</anchor>
      <arglist>(const ScXMLEvent *event)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const ScXMLEvent *</type>
      <name>getNextEvent</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>ad5850f0aa6dbeba031b6bd11290e17a9</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const ScXMLEvent *</type>
      <name>getNextInternalEvent</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>a45236316c39e87ff37b70bb6c9487069</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const ScXMLEvent *</type>
      <name>getNextExternalEvent</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>aad3ad8d1f16b6bee38011f3262d030b0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>processOneEvent</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>ac141e368b9f95ff6feb08e4237e80ee0</anchor>
      <arglist>(const ScXMLEvent *event)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>registerEventTarget</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>ae4bbc4eb147297e6446df86d371b4322</anchor>
      <arglist>(ScXMLEventTarget *target, const char *sessionid=NULL)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>unregisterEventTarget</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>a3d62897337afbd7fbb1b213b77d6e5f7</anchor>
      <arglist>(ScXMLEventTarget *target, const char *sessionid=NULL)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static ScXMLEventTarget *</type>
      <name>getEventTarget</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>ab839c7b7288105c37d84374ee2d1ee15</anchor>
      <arglist>(const char *targettype, const char *targetname, const char *sessionid=NULL)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLExecutableElt</name>
    <filename>classScXMLExecutableElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="pure">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLExecutableElt.html</anchorfile>
      <anchor>ad26b5a870cf887de5d6c9da6421984be</anchor>
      <arglist>(void) const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLExprDataObj</name>
    <filename>classScXMLExprDataObj.html</filename>
    <base>ScXMLDataObj</base>
    <member kind="function" virtualness="pure">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLExprDataObj.html</anchorfile>
      <anchor>a27504f4074ceca56214d913758ec61f3</anchor>
      <arglist>(void) const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLFinalElt</name>
    <filename>classScXMLFinalElt.html</filename>
    <base>ScXMLAbstractStateElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLFinalElt.html</anchorfile>
      <anchor>ad68325e6e81cf51d98856c4cb7ae16bd</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLFinalElt.html</anchorfile>
      <anchor>ad02a235ecbb5d518b8d26b7d0f99540c</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLFinalizeElt</name>
    <filename>classScXMLFinalizeElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLFinalizeElt.html</anchorfile>
      <anchor>a739c641941ca1304a37e53cb71c7a645</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLHistoryElt</name>
    <filename>classScXMLHistoryElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLHistoryElt.html</anchorfile>
      <anchor>a72b497e4b939fda16d9c7cf952aeb4fb</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLHistoryElt.html</anchorfile>
      <anchor>ac077afa9f5c2048df00d37b86022ff31</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLHistoryElt.html</anchorfile>
      <anchor>a189ccd052870f5794b067d832115da17</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLIfElt</name>
    <filename>classScXMLIfElt.html</filename>
    <base>ScXMLExecutableElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLIfElt.html</anchorfile>
      <anchor>aed4954eb11758087ab104f3bd0cb0cb1</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLIfElt.html</anchorfile>
      <anchor>ae628a920951925caf369ebef3c69c262</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLIfElt.html</anchorfile>
      <anchor>afc15cbb987aebc166f03910263df51ca</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLInExprDataObj</name>
    <filename>classScXMLInExprDataObj.html</filename>
    <base>ScXMLMinimumExprDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLInExprDataObj.html</anchorfile>
      <anchor>a51ee81be2fef1d4a2de458c106345a73</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLInitialElt</name>
    <filename>classScXMLInitialElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLInitialElt.html</anchorfile>
      <anchor>ad4c6d725dd5e31787c8091ddab81f1dc</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLInitialElt.html</anchorfile>
      <anchor>a662ed90adcdbd06b6ea49bdd64862494</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLInvokeElt</name>
    <filename>classScXMLInvokeElt.html</filename>
    <base>ScXMLExecutableElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLInvokeElt.html</anchorfile>
      <anchor>ac5d77a69791d3813b873761c2afff2f0</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLInvokeElt.html</anchorfile>
      <anchor>afa48803a9d3619d5638fb92a28d6d3f2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLInvokeElt.html</anchorfile>
      <anchor>aa08cb98ade648f5ec2976c7a0d1a3fbc</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLLogElt</name>
    <filename>classScXMLLogElt.html</filename>
    <base>ScXMLExecutableElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLLogElt.html</anchorfile>
      <anchor>a0268f96802be9fd98b6d78291a4b587c</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLLogElt.html</anchorfile>
      <anchor>a9d070ae058209d8a58d469141d55a4d1</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLLogElt.html</anchorfile>
      <anchor>af0d2754c76405a6ac47ba2efe8575eb5</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLMinimumEvaluator</name>
    <filename>classScXMLMinimumEvaluator.html</filename>
    <base>ScXMLEvaluator</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLMinimumEvaluator.html</anchorfile>
      <anchor>a6021af4504fc8e6ef822171ed22aa517</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setStateMachine</name>
      <anchorfile>classScXMLMinimumEvaluator.html</anchorfile>
      <anchor>a7cd2015644ffedd3ace380747fe3eacc</anchor>
      <arglist>(ScXMLStateMachine *)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ScXMLDataObj *</type>
      <name>evaluate</name>
      <anchorfile>classScXMLMinimumEvaluator.html</anchorfile>
      <anchor>a7d118dbb8fc68c2fd784408ac68f36e5</anchor>
      <arglist>(const char *expression) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>setAtLocation</name>
      <anchorfile>classScXMLMinimumEvaluator.html</anchorfile>
      <anchor>aa2bab3639e92cb1a242d797e10b580c2</anchor>
      <arglist>(const char *location, ScXMLDataObj *obj)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ScXMLDataObj *</type>
      <name>locate</name>
      <anchorfile>classScXMLMinimumEvaluator.html</anchorfile>
      <anchor>a524b2f80ab641ce5979b86418d6c2b29</anchor>
      <arglist>(const char *location) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>clearTemporaryVariables</name>
      <anchorfile>classScXMLMinimumEvaluator.html</anchorfile>
      <anchor>ace8b736796006bbd8bd2fb3838cab38f</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLMinimumExprDataObj</name>
    <filename>classScXMLMinimumExprDataObj.html</filename>
    <base>ScXMLExprDataObj</base>
    <member kind="function" virtualness="pure">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLMinimumExprDataObj.html</anchorfile>
      <anchor>acae67b14941ffd8ca46c042512dbcf09</anchor>
      <arglist>(void) const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLMultiplyOpExprDataObj</name>
    <filename>classScXMLMultiplyOpExprDataObj.html</filename>
    <base>ScXMLExprDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLMultiplyOpExprDataObj.html</anchorfile>
      <anchor>ab7552f6c55c9ad75ad7f993ce2dce546</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLNegateOpExprDataObj</name>
    <filename>classScXMLNegateOpExprDataObj.html</filename>
    <base>ScXMLExprDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLNegateOpExprDataObj.html</anchorfile>
      <anchor>aad1e4f3d5df3572f383ebcac74cb1427</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLNotOpExprDataObj</name>
    <filename>classScXMLNotOpExprDataObj.html</filename>
    <base>ScXMLExprDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLNotOpExprDataObj.html</anchorfile>
      <anchor>a084e931b156fc7847df93d68131ff937</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLObject</name>
    <filename>classScXMLObject.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLObject.html</anchorfile>
      <anchor>a99bfd8003e56ea165441c66a33da44c6</anchor>
      <arglist>(void) const =0</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isOfType</name>
      <anchorfile>classScXMLObject.html</anchorfile>
      <anchor>aa7076590ebc60151d1c5833e2b800ddc</anchor>
      <arglist>(SoType type) const</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SoType</type>
      <name>getClassTypeId</name>
      <anchorfile>classScXMLObject.html</anchorfile>
      <anchor>aff4dbd61103a1c659b1126bd1342d9f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classScXMLObject.html</anchorfile>
      <anchor>ad52f3e69104a3527433768dc369539ae</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>cleanClass</name>
      <anchorfile>classScXMLObject.html</anchorfile>
      <anchor>aae0c5a4a174aca5ba7d7c6f41828b181</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>registerClassType</name>
      <anchorfile>classScXMLObject.html</anchorfile>
      <anchor>a8146bae33082f60297517988ebda4632</anchor>
      <arglist>(const char *xmlns, const char *classname, SoType type)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>registerInvokeClassType</name>
      <anchorfile>classScXMLObject.html</anchorfile>
      <anchor>aa7838602d6dc4f741be2b0984cedf966</anchor>
      <arglist>(const char *xmlns, const char *targettype, const char *source, SoType type)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLOnEntryElt</name>
    <filename>classScXMLOnEntryElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLOnEntryElt.html</anchorfile>
      <anchor>a68f267278d7aeeb8661e430118d5852d</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLOnEntryElt.html</anchorfile>
      <anchor>a265d8cfbda656e3bffe52c97c150cd24</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>execute</name>
      <anchorfile>classScXMLOnEntryElt.html</anchorfile>
      <anchor>a3d3acbeb7fcbf2be8c12933892a665a3</anchor>
      <arglist>(ScXMLStateMachine *statemachine) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLOnExitElt</name>
    <filename>classScXMLOnExitElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLOnExitElt.html</anchorfile>
      <anchor>a385ad439ac59627316c91a216a4d367d</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLOnExitElt.html</anchorfile>
      <anchor>a01517347fb14e19f588ee295b32f6eb8</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLOrOpExprDataObj</name>
    <filename>classScXMLOrOpExprDataObj.html</filename>
    <base>ScXMLExprDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLOrOpExprDataObj.html</anchorfile>
      <anchor>a7fc6afbae478c415c869dcaa58e0ad91</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLParallelElt</name>
    <filename>classScXMLParallelElt.html</filename>
    <base>ScXMLAbstractStateElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLParallelElt.html</anchorfile>
      <anchor>aa923a7303e92e8b2d32aa6cd38646968</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLParallelElt.html</anchorfile>
      <anchor>a9617bfd842c4f986f172e587ab223d61</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLParallelElt.html</anchorfile>
      <anchor>aa224381ad2a1800c8a718afd49af276c</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isAtomicState</name>
      <anchorfile>classScXMLParallelElt.html</anchorfile>
      <anchor>a6f5ec34b51cc367fb7867111d33f6cc3</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classScXMLParallelElt.html</anchorfile>
      <anchor>a2aac4f137a0b91cb919bbe47ed68562e</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>cleanClass</name>
      <anchorfile>classScXMLParallelElt.html</anchorfile>
      <anchor>af182a69ac52dc21320895c24a31af5fb</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLParamElt</name>
    <filename>classScXMLParamElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLParamElt.html</anchorfile>
      <anchor>a14d91276a087c647f11298f2f166ccb0</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLParamElt.html</anchorfile>
      <anchor>aa9be25ba25216e462d66688ff4e6bc64</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLParamElt.html</anchorfile>
      <anchor>a573c0bc6cea59c2d2abe6511a785157b</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLRealDataObj</name>
    <filename>classScXMLRealDataObj.html</filename>
    <base>ScXMLConstantDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLRealDataObj.html</anchorfile>
      <anchor>ae2d6f1e368a0366afc8ff23f64b2cca3</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLReferenceDataObj</name>
    <filename>classScXMLReferenceDataObj.html</filename>
    <base>ScXMLExprDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLReferenceDataObj.html</anchorfile>
      <anchor>a94bdedff9f1aab090e0c677796b0fbcc</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLSbDataObj</name>
    <filename>classScXMLSbDataObj.html</filename>
    <base>ScXMLConstantDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLSbDataObj.html</anchorfile>
      <anchor>a3c3eed3ad21c3b0c1e45324bd4cb5828</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLScriptElt</name>
    <filename>classScXMLScriptElt.html</filename>
    <base>ScXMLExecutableElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLScriptElt.html</anchorfile>
      <anchor>a0570ae8316b634c2ad922135462e75e0</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLScxmlElt</name>
    <filename>classScXMLScxmlElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLScxmlElt.html</anchorfile>
      <anchor>a2a9a791d42fa80936c150f3a730cb38a</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLScxmlElt.html</anchorfile>
      <anchor>a29134c57770eedc8f9b15a251890ae13</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLScxmlElt.html</anchorfile>
      <anchor>aad80392e87a513dc72de1349172379b0</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLSendElt</name>
    <filename>classScXMLSendElt.html</filename>
    <base>ScXMLExecutableElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLSendElt.html</anchorfile>
      <anchor>a9e1787a6a62d8065f1f5ab284cdb54c1</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLSendElt.html</anchorfile>
      <anchor>a2a8200bf1060a20e0d91b4491059b574</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLSendElt.html</anchorfile>
      <anchor>a41fe5f24dae02c3598a0787708fdc0bf</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLStateElt</name>
    <filename>classScXMLStateElt.html</filename>
    <base>ScXMLAbstractStateElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLStateElt.html</anchorfile>
      <anchor>a6caf823ad28f63c4cfb78a2095566062</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ScXMLStateElt</name>
      <anchorfile>classScXMLStateElt.html</anchorfile>
      <anchor>a6df32b2660e35cdfe5a3d8421fa06259</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ScXMLStateElt</name>
      <anchorfile>classScXMLStateElt.html</anchorfile>
      <anchor>ae2a8e7e817e691345cb185f470ede375</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setSrcAttribute</name>
      <anchorfile>classScXMLStateElt.html</anchorfile>
      <anchor>ae04314f867ba7a3d357e084225cf134d</anchor>
      <arglist>(const char *src)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>getSrcAttribute</name>
      <anchorfile>classScXMLStateElt.html</anchorfile>
      <anchor>a681302b499a30a334bfc46ce911d6a74</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setInitialAttribute</name>
      <anchorfile>classScXMLStateElt.html</anchorfile>
      <anchor>a6720ab49835e6c0fad259720986b8501</anchor>
      <arglist>(const char *initial)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>getInitialAttribute</name>
      <anchorfile>classScXMLStateElt.html</anchorfile>
      <anchor>a6cac180d650a4146f0ca4df9f4a70c2e</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLStateElt.html</anchorfile>
      <anchor>a7ce8ae758e0d4cc5e3122e5fbff5bda9</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLStateElt.html</anchorfile>
      <anchor>ae6609c8d53f496c6b9817c1123ec81f8</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isAtomicState</name>
      <anchorfile>classScXMLStateElt.html</anchorfile>
      <anchor>a456305fa8dea9c7ce5d09ab21517141f</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classScXMLStateElt.html</anchorfile>
      <anchor>abcc72a83bef74eb20b0baa9d8717d902</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>cleanClass</name>
      <anchorfile>classScXMLStateElt.html</anchorfile>
      <anchor>a971dc77f454a90ff5eaa4dbe7cff42dd</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLStateMachine</name>
    <filename>classScXMLStateMachine.html</filename>
    <base>ScXMLEventTarget</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>ac598573a1f6498a705251cf5f2b30d75</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setSessionId</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>a675d32dd576b9cbe81b89481935c31ed</anchor>
      <arglist>(const SbName &amp;sessionid)</arglist>
    </member>
    <member kind="function">
      <type>const SbName &amp;</type>
      <name>getSessionId</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>a76545648a64b195a07939e25d6b9d773</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>initialize</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>aba14c712ade5e2ca27c73102cef20b62</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>isActive</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>aaa6981d016ce855e660d3d4effb5fa11</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>isFinished</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>abf6c683d8c3885e19fecd0e50cdfaaf5</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>getNumActiveStates</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>abf21332fe140349b60d29d58bb4d3334</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>getActiveState</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>a9e72584d1db339e8f00fbbb881ed5e3e</anchor>
      <arglist>(int idx) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>addDeleteCallback</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>af8bf1428945535c5479a7cc79e9acb00</anchor>
      <arglist>(ScXMLStateMachineDeleteCB *callback, void *userdata)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>removeDeleteCallback</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>ae6b467bfeefaef24bf8a03884e3013e5</anchor>
      <arglist>(ScXMLStateMachineDeleteCB *callback, void *userdata)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>addStateChangeCallback</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>ad84c8d6eccdb3a9f77938855bef43068</anchor>
      <arglist>(ScXMLStateChangeCB *callback, void *userdata)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>removeStateChangeCallback</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>ab498767b29892f25403678a8e6ee8a53</anchor>
      <arglist>(ScXMLStateChangeCB *callback, void *userdata)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>processOneEvent</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>a9dbeab737cb398f1a50cb523fd417e64</anchor>
      <arglist>(const ScXMLEvent *event)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLStringDataObj</name>
    <filename>classScXMLStringDataObj.html</filename>
    <base>ScXMLConstantDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLStringDataObj.html</anchorfile>
      <anchor>a68d938f7cd08c9d3215116a9e17b3602</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLSubtractOpExprDataObj</name>
    <filename>classScXMLSubtractOpExprDataObj.html</filename>
    <base>ScXMLExprDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLSubtractOpExprDataObj.html</anchorfile>
      <anchor>abd64917f192ca486beb8ddccf8f3cc75</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLTransitionElt</name>
    <filename>classScXMLTransitionElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLTransitionElt.html</anchorfile>
      <anchor>acfc26ef8303c4d485a93baaf2ca59e82</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLTransitionElt.html</anchorfile>
      <anchor>a3c5cb6b36ea69121befca3438f1255f4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLTransitionElt.html</anchorfile>
      <anchor>a4cf1f257591ad77cea3941edddd7e222</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isConditionLess</name>
      <anchorfile>classScXMLTransitionElt.html</anchorfile>
      <anchor>a9864df9a2a93ad5604852ef6f0f5e4ee</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isTargetLess</name>
      <anchorfile>classScXMLTransitionElt.html</anchorfile>
      <anchor>a02684e8d81b714a393193ad096d47004</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isSelfReferencing</name>
      <anchorfile>classScXMLTransitionElt.html</anchorfile>
      <anchor>a0428df16a023ad9c0c737c99b5577085</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>isEventMatch</name>
      <anchorfile>classScXMLTransitionElt.html</anchorfile>
      <anchor>a77cdc6a779275b6680424aa12b395659</anchor>
      <arglist>(const ScXMLEvent *event) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>evaluateCondition</name>
      <anchorfile>classScXMLTransitionElt.html</anchorfile>
      <anchor>a2092e23a55d5d2c8615c0027e9bf4e57</anchor>
      <arglist>(ScXMLStateMachine *statemachine)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>execute</name>
      <anchorfile>classScXMLTransitionElt.html</anchorfile>
      <anchor>a7ee7cba58ee4ba237ce27d0fdd6895fe</anchor>
      <arglist>(ScXMLStateMachine *statemachine) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLValidateElt</name>
    <filename>classScXMLValidateElt.html</filename>
    <base>ScXMLExecutableElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLValidateElt.html</anchorfile>
      <anchor>a1a6e010861f33ea0e3cb135999a496bc</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLValidateElt.html</anchorfile>
      <anchor>a191f8975f4364fd2265d2c75821d07b0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLValidateElt.html</anchorfile>
      <anchor>a6fac0d99274008a949fe0d3155e5cc77</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLXMLDataObj</name>
    <filename>classScXMLXMLDataObj.html</filename>
    <base>ScXMLDataObj</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLXMLDataObj.html</anchorfile>
      <anchor>a81c1e07e3a051adb77e8d136b7da4294</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLXPathEvaluator</name>
    <filename>classScXMLXPathEvaluator.html</filename>
    <base>ScXMLEvaluator</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLXPathEvaluator.html</anchorfile>
      <anchor>aa54b2efeebda2d729242c90aceb1d2b6</anchor>
      <arglist>(void) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoAccumulatedElement</name>
    <filename>classSoAccumulatedElement.html</filename>
    <base>SoElement</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>matches</name>
      <anchorfile>classSoAccumulatedElement.html</anchorfile>
      <anchor>ae00b476c5cd32b69dc391f3b65e84426</anchor>
      <arglist>(const SoElement *element) const</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classSoAccumulatedElement.html</anchorfile>
      <anchor>ae73af63a5def9e9f13c08c0d67cbed27</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>push</name>
      <anchorfile>classSoAccumulatedElement.html</anchorfile>
      <anchor>aa056ead3804fe3818d8ca55e67ef38d0</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>clearNodeIds</name>
      <anchorfile>classSoAccumulatedElement.html</anchorfile>
      <anchor>a70f1473b38a1d7337d643ee8b4e59bc6</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>addNodeId</name>
      <anchorfile>classSoAccumulatedElement.html</anchorfile>
      <anchor>a0132837d8e145edce7586e2b3169cf20</anchor>
      <arglist>(const SoNode *const node)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>setNodeId</name>
      <anchorfile>classSoAccumulatedElement.html</anchorfile>
      <anchor>a72bfdec083dc26e5b36bbd7a0bccbd47</anchor>
      <arglist>(const SoNode *const node)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>copyNodeIds</name>
      <anchorfile>classSoAccumulatedElement.html</anchorfile>
      <anchor>ae65a5e4a450f584709bf55bb18a3edb8</anchor>
      <arglist>(const SoAccumulatedElement *copyfrom)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SoElement *</type>
      <name>copyMatchInfo</name>
      <anchorfile>classSoAccumulatedElement.html</anchorfile>
      <anchor>a42345e34d481d0b802b8e7b721b598e1</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>captureThis</name>
      <anchorfile>classSoAccumulatedElement.html</anchorfile>
      <anchor>a82c2a54f1e2b8eef07b0e257eaa37df8</anchor>
      <arglist>(SoState *state) const</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbList&lt; SbUniqueId &gt;</type>
      <name>nodeIds</name>
      <anchorfile>classSoAccumulatedElement.html</anchorfile>
      <anchor>a6ad9023f4ff2487772a486f0d5057323</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoAction</name>
    <filename>classSoAction.html</filename>
    <member kind="enumeration">
      <type></type>
      <name>AppliedCode</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a1c1dcf644f0e8bc1acd92f9cd8c917d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>PathCode</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a0942e2ce7d88ebc8e7cd10cf26310c67</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SoAction</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>ad2839c2461c998920de832d8bdaa34c1</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a364ad60918a4d20ebdc9635457fe331c</anchor>
      <arglist>(void) const =0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>isOfType</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a5478020eea5f2b7d4e183e16d29d6611</anchor>
      <arglist>(SoType type) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>apply</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>ad2d6ddb297b3a1f5b80026db5fd5e616</anchor>
      <arglist>(SoNode *root)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>apply</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a8f922db782cb971042da8adc64f61d47</anchor>
      <arglist>(SoPath *path)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>apply</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a311e03e553957474b6920afe03fb94fc</anchor>
      <arglist>(const SoPathList &amp;pathlist, SbBool obeysrules=FALSE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>apply</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a984b580685859d42c4505980249fd409</anchor>
      <arglist>(SoAction *beingApplied)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>invalidateState</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a3fbc8efc139853a56e707baecf02b357</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>AppliedCode</type>
      <name>getWhatAppliedTo</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a7cf5dc15e2ea395a8bf9e05827e7c9f3</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SoNode *</type>
      <name>getNodeAppliedTo</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a79ea01b9e731224d00fc792ea19a9802</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SoPath *</type>
      <name>getPathAppliedTo</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>aedea6d5b8b79997c9085937f5dcf517d</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>const SoPathList *</type>
      <name>getPathListAppliedTo</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a791ea2da77f97bb290520f9d92fe4f3b</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>const SoPathList *</type>
      <name>getOriginalPathListAppliedTo</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a5062d853f79a06b4031622e9b59b8d18</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isLastPathListAppliedTo</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>ad953f48ef9f01d8b2c4596157a6e5cdc</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>PathCode</type>
      <name>getPathCode</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a42b2f4960252071194099b4a965eefa2</anchor>
      <arglist>(int &amp;numindices, const int *&amp;indices)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>traverse</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a805627d07445a9c3a7e6324748aac2a9</anchor>
      <arglist>(SoNode *const node)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>hasTerminated</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>af20b8fd5a41faad4f5f21bb7769a5f33</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>const SoPath *</type>
      <name>getCurPath</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>af5920f3da63a6ba8577dc56621815341</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SoState *</type>
      <name>getState</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a477a09961787e99a9621bb07e79c922c</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function">
      <type>PathCode</type>
      <name>getCurPathCode</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>ac2b14e6d8f2d1a290c7d8bc90bc9f410</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoNode *</type>
      <name>getCurPathTail</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a4e9810cb526353255fedf04792151c2d</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>usePathCode</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>aea5650e3b7ae6207c4c3d675e83073b5</anchor>
      <arglist>(int &amp;numindices, const int *&amp;indices)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pushCurPath</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a148ece4bf4cda79914ee3a2116c05d09</anchor>
      <arglist>(const int childindex, SoNode *node=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>popCurPath</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a88ceb9648c0f51d7ba87475ca8555f28</anchor>
      <arglist>(const PathCode prevpathcode)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pushCurPath</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>abebcc05d2d935803a3c95310c9447614</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>popPushCurPath</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>adf8242136a44ff3af40ea102b372e4e1</anchor>
      <arglist>(const int childindex, SoNode *node=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>popCurPath</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a989bcb87598bf55b31bf0704189abb11</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>switchToPathTraversal</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a4285818426cf039bd556b537398d9ece</anchor>
      <arglist>(SoPath *path)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>switchToNodeTraversal</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>accfc280f70bc8f888f61890f07a4aac2</anchor>
      <arglist>(SoNode *node)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a6fca4d3db681ecea3bd1d5c24d1f160d</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClasses</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a9c1f8064ac89d9e36d36a8d05365e26a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SoType</type>
      <name>getClassTypeId</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a3a714aae7f852be330d276041f7bc26e</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>nullAction</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a6dd54a728307c37d3cd87b2891b9359e</anchor>
      <arglist>(SoAction *action, SoNode *node)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SoAction</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a7f6ac9fad4b83a66a321adfa48ebacd1</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>beginTraversal</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a893a67a9bf2e7b5b5ef0f1f36f1b8097</anchor>
      <arglist>(SoNode *node)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>endTraversal</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a9af52ee33d0effeba2f23d9c3d4d6ad0</anchor>
      <arglist>(SoNode *node)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>setTerminated</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>aa968d7390c6d9ec862e0c9c1c7e48de5</anchor>
      <arglist>(const SbBool flag)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoEnabledElementsList &amp;</type>
      <name>getEnabledElements</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>ae4668ce77fd8b3fc5cbf496ca1721d62</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>shouldCompactPathList</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a59700c3dd417a802e9531b6544ff6b81</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static SoEnabledElementsList *</type>
      <name>getClassEnabledElements</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>ac3a072966a0f9fa9f96fa1affc44fe9b</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static SoActionMethodList *</type>
      <name>getClassActionMethods</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a655c3dbf9f093cdfaa7cc896ca54c0f3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoState *</type>
      <name>state</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a5b4ccb851346b95c3c3562b1824d258b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoActionMethodList *</type>
      <name>traversalMethods</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a00703b6a5c0bac45ac95756f7eb054af</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoActionMethodList</name>
    <filename>classSoActionMethodList.html</filename>
    <base>SbPList</base>
    <member kind="function">
      <type></type>
      <name>SoActionMethodList</name>
      <anchorfile>classSoActionMethodList.html</anchorfile>
      <anchor>af86c8480152c573d9e75e835aa72bc74</anchor>
      <arglist>(SoActionMethodList *const parentlist)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SoActionMethodList</name>
      <anchorfile>classSoActionMethodList.html</anchorfile>
      <anchor>a474f294ac9475da3d05f269dd47c7699</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addMethod</name>
      <anchorfile>classSoActionMethodList.html</anchorfile>
      <anchor>a79983ab40c7c4be74506aff39f9e0a72</anchor>
      <arglist>(const SoType node, const SoActionMethod method)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUp</name>
      <anchorfile>classSoActionMethodList.html</anchorfile>
      <anchor>a85d2c887bf7ccc5d8fbc3cb9e7df0050</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoAlarmSensor</name>
    <filename>classSoAlarmSensor.html</filename>
    <base>SoTimerQueueSensor</base>
    <member kind="function">
      <type></type>
      <name>SoAlarmSensor</name>
      <anchorfile>classSoAlarmSensor.html</anchorfile>
      <anchor>a114d31b978c009fb47f419bc356d4f88</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoAlarmSensor</name>
      <anchorfile>classSoAlarmSensor.html</anchorfile>
      <anchor>a2b5ca4eee57d66a63d73a89cf9324b2a</anchor>
      <arglist>(SoSensorCB *func, void *data)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SoAlarmSensor</name>
      <anchorfile>classSoAlarmSensor.html</anchorfile>
      <anchor>ab504b1bd587ec26c7ffcbc5a72ac3f1f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTime</name>
      <anchorfile>classSoAlarmSensor.html</anchorfile>
      <anchor>af1886674d1187f94ff408349f738d3cc</anchor>
      <arglist>(const SbTime &amp;abstime)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTimeFromNow</name>
      <anchorfile>classSoAlarmSensor.html</anchorfile>
      <anchor>a8988efd19de1d900859696a628e8e55f</anchor>
      <arglist>(const SbTime &amp;reltime)</arglist>
    </member>
    <member kind="function">
      <type>const SbTime &amp;</type>
      <name>getTime</name>
      <anchorfile>classSoAlarmSensor.html</anchorfile>
      <anchor>a06072d1d5a45921e7cd81534c8ffb065</anchor>
      <arglist>(void) const</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>schedule</name>
      <anchorfile>classSoAlarmSensor.html</anchorfile>
      <anchor>a457a8626f5856284e66367e5ec8bf54a</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoAlphaTest</name>
    <filename>classSoAlphaTest.html</filename>
    <base>SoNode</base>
    <member kind="enumeration">
      <type></type>
      <name>Function</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>af21bb2d9573f0673e2f636ef82f424f1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NONE</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>af21bb2d9573f0673e2f636ef82f424f1a8b0557cff65c58a521bc7ec8ac83a676</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NEVER</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>af21bb2d9573f0673e2f636ef82f424f1af76ce4e47d1a17e5d3a86714f55d894f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ALWAYS</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>af21bb2d9573f0673e2f636ef82f424f1a5b1a78aa5e038ba10398322cebad7026</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LESS</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>af21bb2d9573f0673e2f636ef82f424f1a6f8eca382fe3ae8a5eb483f33d6aa246</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LEQUAL</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>af21bb2d9573f0673e2f636ef82f424f1af0b59036b3007a7ba0e46750dc3ca43e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EQUAL</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>af21bb2d9573f0673e2f636ef82f424f1af7d8e0673b5e7a12949710eb07a564ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GEQUAL</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>af21bb2d9573f0673e2f636ef82f424f1a29037b9059c646095cc398734dc2c9e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GREATER</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
     