
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was Config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# provide meta-data
set(libpkg_varname "LIBPKG")
set(libpkg-git_varname "LIBPKG")
set(LIBPKG_DISPLAY_NAME "Unofficial Arch Linux package library (git)")
set(LIBPKG_AUTHOR "Martchus")
set(LIBPKG_VERSION "0.0.4-545.8a33d34")
set(LIBPKG_VERSION_MAJOR "0")
set(LIBPKG_VERSION_MINOR "0")
set(LIBPKG_VERSION_PATCH "4")
set(LIBPKG_GIT_REV_COUNT "545")
set(LIBPKG_GIT_LAST_COMMIT_ID "8a33d34")
set(LIBPKG_URL "https://github.com/Martchus/arch-repo-manager")
set(LIBPKG_DESCRIPTION "C++ library to parse Arch Linux packages and databases")
set(LIBPKG_LICENSE "GPL-2.0+")

# define general config
set(LIBPKG_IS_HEADER_ONLY NO)
set(LIBPKG_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include/libpkg-git")
set(LIBPKG_BIN_DIR "${PACKAGE_PREFIX_DIR}/bin")
set(LIBPKG_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib")
set(LIBPKG_DATA_DIRS "${PACKAGE_PREFIX_DIR}/share/libpkg-git")
set(LIBPKG_MODULE_DIRS "${PACKAGE_PREFIX_DIR}/share/libpkg-git/cmake/modules")
set(LIBPKG_CONFIG_DIRS "${PACKAGE_PREFIX_DIR}/share/libpkg-git/cmake")
set(LIBPKG_PRIVATE_QT_MODULES "")
set(LIBPKG_PRIVATE_KF_MODULES "")
set(LIBPKG_PUBLIC_QT_MODULES "")
set(LIBPKG_PUBLIC_KF_MODULES "")
set(LIBPKG_REQUIRED_PACKAGES "c++utilities-git;reflective_rapidjson-git")
set(LIBPKG_REQUIRED_PKG_CONFIG_MODULES "")
set(LIBPKG_HAS_QT_TRANSLATION_FILES )
set(LIBPKG_QT_RESOURCES )

# define mapping from CMake targets to pkg-config module names
set(PKG_CONFIG_libpkg-git "libpkg-git")

# save policies before modifying them e.g. though the inclusion of 3rdParty
cmake_policy(PUSH)

# define additional find_package arguments for required CMake-packages

# define library config, add imported target
set(LIBPKG_PACKAGE "libpkg-git")
set(LIBPKG_LIB "libpkg-git")
set(LIBPKG_LIB_IS_SHARED "ON")
set(LIBPKG_STATIC_LINKAGE "OFF")
if(NOT TARGET "${LIBPKG_LIB}")
    # make dependencies of the library available
    # caveat: This currently does *not* cover Qt and KF modules which are so far only handled
    #         separately when using the function use_LIBPKG.

    # find c++utilities-git to use its CMake modules
    if (NOT LIBPKG_PACKAGE STREQUAL "c++utilities-git")
        find_package("c++utilities-git" ${LIBPKG_FIND_PACKAGE_ARGS_c++utilities-git} REQUIRED)
    endif ()

    # prefer static libraries if libpkg was configured this way during its build
    set(LIBPKG_DEFAULT_CMAKE_MODULE_PATH "${CMAKE_MODULE_PATH}")
    list(APPEND CMAKE_MODULE_PATH "${LIBPKG_MODULE_DIRS}")
    list(APPEND CMAKE_MODULE_PATH "${CPP_UTILITIES_MODULE_DIRS}")
    include(3rdPartyFunctions)
    if (LIBPKG_STATIC_LINKAGE)
        save_library_preference()
        prefer_static_libraries()
    endif ()

    # find all required packages
    foreach (_REQUIRED_PACKAGE ${LIBPKG_REQUIRED_PACKAGES})
        string(REGEX MATCH _REQUIRED_PACKAGE_MATCH "(.*)-([^-]*)" "${_REQUIRED_PACKAGE}")
        if (_REQUIRED_PACKAGE_MATCH)
            set(_REQUIRED_PACKAGE "${CMAKE_MATCH_1}")
            set(_REQUIRED_VERSION "${CMAKE_MATCH_2}")
        else ()
            unset(_REQUIRED_VERSION)
        endif ()
        string(REPLACE "::" "_" _REQUIRED_PACKAGE_VARNAME "${_REQUIRED_PACKAGE}")
        if (LIBPKG_FIND_PACKAGE_ARGS_${_REQUIRED_PACKAGE_VARNAME})
            set(_FIND_PACKAGE_ARGS ${LIBPKG_FIND_PACKAGE_ARGS_${_REQUIRED_PACKAGE_VARNAME}})
        else ()
            set(_FIND_PACKAGE_ARGS REQUIRED)
        endif ()
        if (_REQUIRED_VERSION)
            find_package("${_REQUIRED_PACKAGE}" "${_REQUIRED_VERSION}" ${_FIND_PACKAGE_ARGS})
        else ()
            find_package("${_REQUIRED_PACKAGE}" ${_FIND_PACKAGE_ARGS})
        endif()
    endforeach()

    # find all required pkg-config modules
    if (LIBPKG_REQUIRED_PKG_CONFIG_MODULES)
        foreach (LIBPKG_REQUIRED_PKG_CONFIG_MODULE ${LIBPKG_REQUIRED_PKG_CONFIG_MODULES})
            string(REPLACE "::" "_" LIBPKG_REQUIRED_PKG_CONFIG_MODULE_VARNAME "${LIBPKG_REQUIRED_PKG_CONFIG_MODULE}")
            use_pkg_config_module(
                TARGET_NAME "${LIBPKG_REQUIRED_PKG_CONFIG_MODULE}"
                PKG_CONFIG_MODULES "${PKG_CONFIG_${LIBPKG_REQUIRED_PKG_CONFIG_MODULE_VARNAME}}"
                LIBRARIES_VARIABLE DEV_NULL
                PKG_CONFIG_MODULES_VARIABLE DEV_NULL
            )
        endforeach ()
    endif ()

    # restore preference of static libraries
    if (LIBPKG_STATIC_LINKAGE)
        restore_library_preference()
    endif ()

    # add target for the library itself
    include("${CMAKE_CURRENT_LIST_DIR}/libpkg-gitTargets.cmake")

    # restore module path
    set(CMAKE_MODULE_PATH "${LIBPKG_DEFAULT_CMAKE_MODULE_PATH}")
endif()

# define function to ease use of library in projects following conventions of c++utilities' build script
function(use_LIBPKG)
    # make CMake modules of the project available
    list(APPEND CMAKE_MODULE_PATH "${LIBPKG_MODULE_DIRS}")
    set(CMAKE_MODULE_PATH "${CMAKE_MODULE_PATH}" PARENT_SCOPE)

    # parse arguments
    list(APPEND CMAKE_MODULE_PATH "${CPP_UTILITIES_MODULE_DIRS}")
    include(3rdParty)
    parse_arguments_for_use_functions(${ARGN})

    # link against library (also "link" against header-only libs to get compile defs and interface link libs)
    link_directories(${LIBPKG_LIB_DIR})
    if (ARGS_ONLY_HEADERS)
        set(TARGET_NAME "${LIBPKG_LIB}-headers")
    else ()
        set(TARGET_NAME "${LIBPKG_LIB}")
    endif ()
    set("${ARGS_LIBRARIES_VARIABLE}" "${${ARGS_LIBRARIES_VARIABLE}};${TARGET_NAME}" PARENT_SCOPE)
    set("${ARGS_PACKAGES_VARIABLE}" "${${ARGS_PACKAGES_VARIABLE}};${LIBPKG_PACKAGE}" PARENT_SCOPE)

    if (ARGS_ONLY_HEADERS)
        return ()
    endif ()

    # add required Qt and KF modules
    set(IMPORTED_QT_MODULES
        ${IMPORTED_QT_MODULES}
        ${LIBPKG_PUBLIC_QT_MODULES}
        ${LIBPKG_PRIVATE_QT_MODULES}
        PARENT_SCOPE
    )
    set(IMPORTED_KF_MODULES
        ${IMPORTED_KF_MODULES}
        ${LIBPKG_PUBLIC_KF_MODULES}
        ${LIBPKG_PRIVATE_KF_MODULES}
        PARENT_SCOPE
    )

    # add required translations to APP_SPECIFIC_QT_TRANSLATION_FILES_ARRAY
    if(LIBPKG_HAS_QT_TRANSLATION_FILES)
        set(APP_SPECIFIC_QT_TRANSLATION_FILES "${APP_SPECIFIC_QT_TRANSLATION_FILES};libpkg" PARENT_SCOPE)
    endif()

    # add Qt resources if it is a static library
    if (NOT LIBPKG_LIB_IS_SHARED)
        set(STATIC_LIBRARIES_QT_RESOURCES "${STATIC_LIBRARIES_QT_RESOURCES};${LIBPKG_QT_RESOURCES}" PARENT_SCOPE)
    endif()
endfunction()

# restore policies
cmake_policy(POP)
