/****************************************************************************
 *   This file is part of the aGrUM/pyAgrum library.                        *
 *                                                                          *
 *   Copyright (c) 2005-2025 by                                             *
 *       - Pierre-Henri WUILLEMIN(_at_LIP6)                                 *
 *       - Christophe GONZALES(_at_AMU)                                     *
 *                                                                          *
 *   The aGrUM/pyAgrum library is free software; you can redistribute it    *
 *   and/or modify it under the terms of either :                           *
 *                                                                          *
 *    - the GNU Lesser General Public License as published by               *
 *      the Free Software Foundation, either version 3 of the License,      *
 *      or (at your option) any later version,                              *
 *    - the MIT license (MIT),                                              *
 *    - or both in dual license, as here.                                   *
 *                                                                          *
 *   (see https://agrum.gitlab.io/articles/dual-licenses-lgplv3mit.html)    *
 *                                                                          *
 *   This aGrUM/pyAgrum library is distributed in the hope that it will be  *
 *   useful, but WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,          *
 *   INCLUDING BUT NOT LIMITED TO THE WARRANTIES MERCHANTABILITY or FITNESS *
 *   FOR A PARTICULAR PURPOSE  AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 *   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 *   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,        *
 *   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR  *
 *   OTHER DEALINGS IN THE SOFTWARE.                                        *
 *                                                                          *
 *   See LICENCES for more details.                                         *
 *                                                                          *
 *   SPDX-FileCopyrightText: Copyright 2005-2025                            *
 *       - Pierre-Henri WUILLEMIN(_at_LIP6)                                 *
 *       - Christophe GONZALES(_at_AMU)                                     *
 *   SPDX-License-Identifier: LGPL-3.0-or-later OR MIT                      *
 *                                                                          *
 *   Contact  : info_at_agrum_dot_org                                       *
 *   homepage : http://agrum.gitlab.io                                      *
 *   gitlab   : https://gitlab.com/agrumery/agrum                           *
 *                                                                          *
 ****************************************************************************/


/** @file
 * @brief the base class for "low-level" operators used to schedule inferences
 *
 * @author Christophe GONZALES(@AMU) and Pierre-Henri WUILLEMIN(@LIP6)
 */

#ifndef DOXYGEN_SHOULD_SKIP_THIS

#  include <agrum/agrum.h>

#  include <agrum/base/graphicalModels/inference/scheduler/scheduleOperator.h>

namespace gum {

  /// operator ==
  INLINE bool ScheduleOperator::operator==(const ScheduleOperator& op) const {
    return (_op_type_ == op._op_type_);
  }

  /// operator !=
  INLINE bool ScheduleOperator::operator!=(const ScheduleOperator& op) const {
    return !ScheduleOperator::operator==(op);
  }

  /// checks whether two ScheduleOperator are similar
  INLINE bool ScheduleOperator::isSameOperator(const ScheduleOperator& op) const {
    return (_op_type_ == op._op_type_);
  }

  /// returns the name of the operator
  INLINE ScheduleOperatorType ScheduleOperator::type() const { return _op_type_; }

  /// indicates whether the operator deletes some of its arguments
  INLINE bool ScheduleOperator::implyDeletion() const { return _imply_deletion_; }

  /// makes the results of the operator persistent or not
  INLINE void ScheduleOperator::makeResultsPersistent(const bool is_persistent) {
    _result_persistent_ = is_persistent;
  }

  /// shows whether the operator has persistent results
  INLINE bool ScheduleOperator::hasPersistentResults() const { return _result_persistent_; }


} /* namespace gum */

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
