/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.multimedia;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.IBinder;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Size;
import android.view.Display;
import android.view.WindowManager;
import android.view.WindowMetrics;
import org.qtproject.qt.android.multimedia.QtScreenCaptureService;

class QtScreenGrabber {
    private final Object mServiceLock = new Object();
    private QtScreenCaptureService mService = null;
    private final Context m_activity;
    static final String DATA = "data";
    static final String HEIGHT = "height";
    static final String ID = "id";
    static final String RESULT_CODE = "resultCode";
    static final String WIDTH = "width";
    private static final String QtTAG = "QtScreenGrabber";
    private ServiceConnection mConnection = new ServiceConnection(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            Object object = QtScreenGrabber.this.mServiceLock;
            synchronized (object) {
                QtScreenCaptureService.ScreenCaptureBinder screenCaptureBinder = (QtScreenCaptureService.ScreenCaptureBinder)iBinder;
                QtScreenGrabber.this.mService = screenCaptureBinder.getService();
                QtScreenGrabber.this.mServiceLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName componentName) {
            Object object = QtScreenGrabber.this.mServiceLock;
            synchronized (object) {
                QtScreenGrabber.this.mService = null;
            }
        }
    };

    QtScreenGrabber(Activity activity, int n) {
        this.m_activity = activity;
        MediaProjectionManager mediaProjectionManager = (MediaProjectionManager)activity.getSystemService("media_projection");
        activity.startActivityForResult(mediaProjectionManager.createScreenCaptureIntent(), n);
    }

    public static Size getScreenCaptureSize(Activity activity) {
        WindowManager windowManager = (WindowManager)activity.getSystemService("window");
        if (windowManager == null) {
            Log.w((String)QtTAG, (String)"WindowManager is null. Invalid screen size");
            return new Size(0, 0);
        }
        if (Build.VERSION.SDK_INT >= 30) {
            WindowMetrics windowMetrics = windowManager.getCurrentWindowMetrics();
            return new Size(windowMetrics.getBounds().width(), windowMetrics.getBounds().height());
        }
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getRealMetrics(displayMetrics);
        return new Size(displayMetrics.widthPixels, displayMetrics.heightPixels);
    }

    public boolean startScreenCaptureService(int n, long l, int n2, int n3, Intent intent) {
        try {
            Intent intent2 = new Intent(this.m_activity, QtScreenCaptureService.class);
            intent2.putExtra(RESULT_CODE, n);
            intent2.putExtra(DATA, (Parcelable)intent);
            intent2.putExtra(ID, l);
            intent2.putExtra(WIDTH, n2);
            intent2.putExtra(HEIGHT, n3);
            this.m_activity.bindService(intent2, this.mConnection, 1);
            this.m_activity.startService(intent2);
        }
        catch (Exception exception) {
            Log.w((String)QtTAG, (String)("Cannot start QtScreenCaptureService: " + exception));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopScreenCaptureService() {
        try {
            Intent intent = new Intent(this.m_activity, QtScreenCaptureService.class);
            Object object = this.mServiceLock;
            synchronized (object) {
                if (this.mService == null) {
                    this.mServiceLock.wait(1000L);
                }
                if (this.mService != null) {
                    this.mService.stopScreenCapture();
                }
                this.m_activity.unbindService(this.mConnection);
            }
            this.m_activity.stopService(intent);
        }
        catch (Exception exception) {
            Log.w((String)QtTAG, (String)("Cannot stop QtScreenCaptureService: " + exception));
            return false;
        }
        return true;
    }
}

