/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.multimedia;

import android.content.Context;
import android.media.AudioDeviceCallback;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.media.MediaRecorder;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

class QtAudioDeviceManager {
    private static final String TAG = "QtAudioDeviceManager";
    private static AudioManager m_audioManager = null;
    private static final AudioDevicesReceiver m_audioDevicesReceiver = new AudioDevicesReceiver();
    private static Handler handler = new Handler(Looper.getMainLooper());
    private static AudioRecord m_recorder = null;
    private static AudioTrack m_streamPlayer = null;
    private static Thread m_streamingThread = null;
    private static boolean m_isStreaming = false;
    private static boolean m_useSpeaker = false;
    private static final int m_sampleRate = 8000;
    private static final int m_channels = 2;
    private static final int m_audioFormat = 2;
    private static final int m_bufferSize = AudioRecord.getMinBufferSize((int)8000, (int)2, (int)2);
    private static int m_currentOutputId = -1;
    private static final HashMap<Integer, Integer> priorityMap = new HashMap<Integer, Integer>(){
        {
            this.put(3, 1);
            this.put(4, 1);
            this.put(8, 2);
            this.put(7, 2);
            this.put(2, 3);
        }
    };
    private static final int DEFAULT_PRIORITY = 4;
    private static final int[] bluetoothTypes = new int[]{8, 7};
    private static final int[] wiredTypes = new int[]{3, 4};

    QtAudioDeviceManager() {
    }

    static native void onAudioInputDevicesUpdated();

    static native void onAudioOutputDevicesUpdated();

    private static void updateDeviceList() {
        if (m_currentOutputId != -1) {
            QtAudioDeviceManager.setAudioOutput(m_currentOutputId);
        }
        QtAudioDeviceManager.onAudioInputDevicesUpdated();
        QtAudioDeviceManager.onAudioOutputDevicesUpdated();
    }

    static void registerAudioHeadsetStateReceiver() {
        m_audioManager.registerAudioDeviceCallback((AudioDeviceCallback)m_audioDevicesReceiver, handler);
    }

    static void unregisterAudioHeadsetStateReceiver() {
        m_audioManager.unregisterAudioDeviceCallback((AudioDeviceCallback)m_audioDevicesReceiver);
    }

    static void setContext(Context context) {
        m_audioManager = (AudioManager)context.getSystemService("audio");
    }

    private static String[] getAudioOutputDevices() {
        return QtAudioDeviceManager.getAudioDevices(2);
    }

    private static String[] getAudioInputDevices() {
        return QtAudioDeviceManager.getAudioDevices(1);
    }

    private static boolean isBluetoothDevice(AudioDeviceInfo audioDeviceInfo) {
        switch (audioDeviceInfo.getType()) {
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private static boolean setAudioInput(MediaRecorder mediaRecorder, int n) {
        AudioDeviceInfo[] audioDeviceInfoArray;
        if (Build.VERSION.SDK_INT < 28) {
            return false;
        }
        for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray = m_audioManager.getDevices(1)) {
            if (audioDeviceInfo.getId() != n) continue;
            boolean bl = mediaRecorder.setPreferredDevice(audioDeviceInfo);
            if (bl && QtAudioDeviceManager.isBluetoothDevice(audioDeviceInfo)) {
                m_audioManager.startBluetoothSco();
                m_audioManager.setBluetoothScoOn(true);
            }
            return bl;
        }
        return false;
    }

    private static void setInputMuted(boolean bl) {
        m_audioManager.setMicrophoneMute(bl);
    }

    private static boolean isMicrophoneMute() {
        return m_audioManager.isMicrophoneMute();
    }

    private static String audioDeviceTypeToString(int n) {
        switch (n) {
            case 19: {
                return "AUX Line";
            }
            case 7: 
            case 8: {
                return "Bluetooth";
            }
            case 1: {
                return "Built in earpiece";
            }
            case 15: {
                return "Built in microphone";
            }
            case 2: {
                return "Built in speaker";
            }
            case 13: {
                return "Dock";
            }
            case 14: {
                return "FM";
            }
            case 16: {
                return "FM TUNER";
            }
            case 9: {
                return "HDMI";
            }
            case 10: {
                return "HDMI ARC";
            }
            case 20: {
                return "IP";
            }
            case 5: {
                return "Line analog";
            }
            case 6: {
                return "Line digital";
            }
            case 17: {
                return "TV tuner";
            }
            case 12: {
                return "USB accessory";
            }
            case 4: {
                return "Wired headphones";
            }
            case 3: {
                return "Wired headset";
            }
        }
        if (Build.VERSION.SDK_INT >= 24 && n == 21) {
            return "Bus";
        }
        return "Unknown-Type";
    }

    private static void sortAudioDevices(AudioDeviceInfo[] audioDeviceInfoArray) {
        Comparator<AudioDeviceInfo> comparator = new Comparator<AudioDeviceInfo>(){

            @Override
            public int compare(AudioDeviceInfo audioDeviceInfo, AudioDeviceInfo audioDeviceInfo2) {
                return this.getPriority(audioDeviceInfo) - this.getPriority(audioDeviceInfo2);
            }

            private int getPriority(AudioDeviceInfo audioDeviceInfo) {
                return priorityMap.getOrDefault(audioDeviceInfo.getType(), 4);
            }
        };
        Arrays.sort(audioDeviceInfoArray, comparator);
    }

    private static String[] getAudioDevices(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Build.VERSION.SDK_INT >= 23) {
            boolean bl = false;
            boolean bl2 = false;
            AudioDeviceInfo[] audioDeviceInfoArray = m_audioManager.getDevices(n);
            QtAudioDeviceManager.sortAudioDevices(audioDeviceInfoArray);
            for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray) {
                String string = QtAudioDeviceManager.audioDeviceTypeToString(audioDeviceInfo.getType());
                if (string.equals(QtAudioDeviceManager.audioDeviceTypeToString(0))) continue;
                if (string.equals(QtAudioDeviceManager.audioDeviceTypeToString(15))) {
                    if (bl) continue;
                    bl = true;
                } else if (QtAudioDeviceManager.isBluetoothDevice(audioDeviceInfo)) {
                    if (bl2) continue;
                    bl2 = true;
                }
                arrayList.add(audioDeviceInfo.getId() + ":" + string + " (" + audioDeviceInfo.getProductName().toString() + ")");
            }
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    private static boolean containsAnyOfType(AudioDeviceInfo[] audioDeviceInfoArray, int[] ... nArray) {
        return Arrays.stream(audioDeviceInfoArray).anyMatch(audioDeviceInfo -> Arrays.stream(nArray).flatMapToInt(Arrays::stream).anyMatch(n -> audioDeviceInfo.getType() == n));
    }

    private static int getCorrectModeIfContainsAnyOfType(AudioDeviceInfo[] audioDeviceInfoArray, int[] ... nArray) {
        return QtAudioDeviceManager.containsAnyOfType(audioDeviceInfoArray, nArray) ? 3 : 0;
    }

    private static int getModeForWired(AudioDeviceInfo[] audioDeviceInfoArray) {
        return QtAudioDeviceManager.getCorrectModeIfContainsAnyOfType(audioDeviceInfoArray, new int[][]{bluetoothTypes});
    }

    private static int getModeForBluotooth(AudioDeviceInfo[] audioDeviceInfoArray) {
        return QtAudioDeviceManager.getCorrectModeIfContainsAnyOfType(audioDeviceInfoArray, new int[][]{wiredTypes});
    }

    private static int getModeForSpeaker(AudioDeviceInfo[] audioDeviceInfoArray) {
        return QtAudioDeviceManager.getCorrectModeIfContainsAnyOfType(audioDeviceInfoArray, bluetoothTypes, wiredTypes);
    }

    private static boolean setAudioOutput(int n) {
        AudioDeviceInfo[] audioDeviceInfoArray;
        for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray = m_audioManager.getDevices(2)) {
            if (audioDeviceInfo.getId() != n) continue;
            switch (audioDeviceInfo.getType()) {
                case 7: 
                case 8: {
                    QtAudioDeviceManager.setAudioOutput(audioDeviceInfo, QtAudioDeviceManager.getModeForBluotooth(audioDeviceInfoArray), true, false);
                    return true;
                }
                case 2: {
                    QtAudioDeviceManager.setAudioOutput(audioDeviceInfo, QtAudioDeviceManager.getModeForSpeaker(audioDeviceInfoArray), false, true);
                    return true;
                }
                case 3: 
                case 4: {
                    QtAudioDeviceManager.setAudioOutput(audioDeviceInfo, QtAudioDeviceManager.getModeForWired(audioDeviceInfoArray), false, false);
                    return true;
                }
                case 1: {
                    Log.w((String)TAG, (String)"Built in Earpiece may not work when Wired Headphones are connected");
                    QtAudioDeviceManager.setAudioOutput(audioDeviceInfo, 2, false, false);
                    return true;
                }
                case 9: 
                case 10: 
                case 29: {
                    QtAudioDeviceManager.setAudioOutput(audioDeviceInfo, 0, false, false);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private static void setAudioOutput(AudioDeviceInfo audioDeviceInfo, int n, boolean bl, boolean bl2) {
        m_audioManager.setMode(n);
        if (Build.VERSION.SDK_INT < 31) {
            if (bl) {
                m_audioManager.startBluetoothSco();
            } else {
                m_audioManager.stopBluetoothSco();
            }
            m_audioManager.setSpeakerphoneOn(bl2);
        } else if (n == 3) {
            m_audioManager.setCommunicationDevice(audioDeviceInfo);
        }
        m_audioManager.setBluetoothScoOn(bl);
        m_currentOutputId = audioDeviceInfo.getId();
    }

    private static void streamSound() {
        byte[] byArray = new byte[m_bufferSize];
        while (m_isStreaming) {
            m_recorder.read(byArray, 0, m_bufferSize);
            m_streamPlayer.play();
            m_streamPlayer.write(byArray, 0, m_bufferSize);
            m_streamPlayer.stop();
        }
    }

    private static void startSoundStreaming(int n, int n2) {
        AudioDeviceInfo[] audioDeviceInfoArray;
        if (m_isStreaming) {
            QtAudioDeviceManager.stopSoundStreaming();
        }
        m_recorder = new AudioRecord(0, 8000, 2, 2, m_bufferSize);
        m_streamPlayer = new AudioTrack(3, 8000, 2, 2, m_bufferSize, 1);
        for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray = m_audioManager.getDevices(3)) {
            if (audioDeviceInfo.getId() == n2) {
                m_streamPlayer.setPreferredDevice(audioDeviceInfo);
                continue;
            }
            if (audioDeviceInfo.getId() != n) continue;
            m_recorder.setPreferredDevice(audioDeviceInfo);
        }
        m_recorder.startRecording();
        m_isStreaming = true;
        m_streamingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                QtAudioDeviceManager.streamSound();
            }
        });
        m_streamingThread.start();
    }

    private static void stopSoundStreaming() {
        if (!m_isStreaming) {
            return;
        }
        m_isStreaming = false;
        try {
            m_streamingThread.join();
            m_streamingThread = null;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        m_recorder.stop();
        m_recorder.release();
        m_streamPlayer.release();
        m_streamPlayer = null;
        m_recorder = null;
    }

    private static class AudioDevicesReceiver
    extends AudioDeviceCallback {
        private AudioDevicesReceiver() {
        }

        public void onAudioDevicesAdded(AudioDeviceInfo[] audioDeviceInfoArray) {
            QtAudioDeviceManager.updateDeviceList();
        }

        public void onAudioDevicesRemoved(AudioDeviceInfo[] audioDeviceInfoArray) {
            QtAudioDeviceManager.updateDeviceList();
        }
    }
}

