/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.multimedia;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import android.view.OrientationEventListener;
import android.webkit.MimeTypeMap;
import java.io.File;

class QtMultimediaUtils {
    private static Context m_context = null;
    private static OrientationListener m_orientationListener = null;
    private static final String QtTAG = "Qt QtMultimediaUtils";

    static void setActivity(Activity activity, Object object) {
    }

    static void setContext(Context context) {
        m_context = context;
        m_orientationListener = new OrientationListener(context);
    }

    QtMultimediaUtils() {
    }

    static void enableOrientationListener(boolean bl) {
        if (bl) {
            m_orientationListener.enable();
        } else {
            m_orientationListener.disable();
        }
    }

    static int getDeviceOrientation() {
        return OrientationListener.deviceOrientation;
    }

    static String getDefaultMediaDirectory(int n) {
        String string = new String();
        switch (n) {
            case 0: {
                string = Environment.DIRECTORY_MUSIC;
                break;
            }
            case 1: {
                string = Environment.DIRECTORY_MOVIES;
                break;
            }
            case 2: {
                string = Environment.DIRECTORY_DCIM;
                break;
            }
        }
        File file = new File("");
        file = n == 3 ? new File(Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "Sounds") : Environment.getExternalStoragePublicDirectory((String)string);
        file.mkdirs();
        return file.getAbsolutePath();
    }

    static void registerMediaFile(String string) {
        MediaScannerConnection.scanFile((Context)m_context, (String[])new String[]{string}, null, null);
    }

    static File getCacheDirectory() {
        return m_context.getCacheDir();
    }

    private static String[] getMediaCodecs() {
        MediaCodecList mediaCodecList = new MediaCodecList(0);
        MediaCodecInfo[] mediaCodecInfoArray = mediaCodecList.getCodecInfos();
        String[] stringArray = new String[mediaCodecInfoArray.length];
        for (int i = 0; i < mediaCodecInfoArray.length; ++i) {
            stringArray[i] = mediaCodecInfoArray[i].getName();
        }
        return stringArray;
    }

    static String getMimeType(Context context, String string) {
        Uri uri = Uri.parse((String)string);
        String string2 = null;
        try {
            String string3 = uri.getScheme();
            if (string3 != null && string3.contains("content")) {
                ContentResolver contentResolver = context.getContentResolver();
                string2 = contentResolver.getType(uri);
            } else {
                String string4 = MimeTypeMap.getFileExtensionFromUrl((String)string);
                if (string4 != null) {
                    string2 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string4);
                }
            }
        }
        catch (Exception exception) {
            Log.e((String)QtTAG, (String)("getMimeType(): " + exception.toString()));
        }
        return string2;
    }

    private static class OrientationListener
    extends OrientationEventListener {
        static int deviceOrientation = 0;

        OrientationListener(Context context) {
            super(context);
        }

        public void onOrientationChanged(int n) {
            if (n == -1) {
                return;
            }
            deviceOrientation = n;
        }
    }
}

