/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.multimedia;

import android.app.Activity;
import android.hardware.camera2.CameraManager;
import android.os.Handler;
import android.util.Log;
import java.util.concurrent.CountDownLatch;
import org.qtproject.qt.android.UsedFromNativeCode;

class QtCameraAvailabilityListener
extends CameraManager.AvailabilityCallback {
    static final String LOG_TAG = "QtCameraAvailabilityListener";
    CameraManager mCameraManager = null;
    long mVideoDevicesNativePtr = 0L;
    Handler mAvailabilityCallbackHandler = null;

    @UsedFromNativeCode
    QtCameraAvailabilityListener(Activity activity, long l) {
        this.mCameraManager = (CameraManager)activity.getSystemService("camera");
        this.mVideoDevicesNativePtr = l;
        this.mAvailabilityCallbackHandler = new Handler(activity.getMainLooper());
        this.mCameraManager.registerAvailabilityCallback((CameraManager.AvailabilityCallback)this, this.mAvailabilityCallbackHandler);
    }

    @UsedFromNativeCode
    void cleanup() {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        boolean bl = this.mAvailabilityCallbackHandler.post(() -> {
            this.mCameraManager.unregisterAvailabilityCallback((CameraManager.AvailabilityCallback)this);
            this.mVideoDevicesNativePtr = 0L;
            countDownLatch.countDown();
        });
        if (!bl) {
            Log.w((String)LOG_TAG, (String)"Unable to post cleanup job to corresponding thread during QAndroidVideoDevices cleanup.");
            return;
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            Log.w((String)LOG_TAG, (String)"Unable to wait for cleanup job to finish on corresponding thread duringQAndroidVideoDevices cleanup.");
        }
    }

    native void onCameraAvailableNative(long var1);

    public void onCameraAvailable(String string) {
        assert (this.mVideoDevicesNativePtr != 0L);
        this.onCameraAvailableNative(this.mVideoDevicesNativePtr);
    }

    native void onCameraUnavailableNative(long var1);

    public void onCameraUnavailable(String string) {
        assert (this.mVideoDevicesNativePtr != 0L);
        this.onCameraUnavailableNative(this.mVideoDevicesNativePtr);
    }

    public void onCameraAccessPrioritiesChanged() {
    }
}

