/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Insets;
import android.os.Build;
import android.view.DisplayCutout;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import java.util.HashMap;
import org.qtproject.qt.android.QtActivityBase;
import org.qtproject.qt.android.QtEditText;
import org.qtproject.qt.android.QtInputConnection;
import org.qtproject.qt.android.QtInputDelegate;
import org.qtproject.qt.android.QtLayout;
import org.qtproject.qt.android.QtNative;
import org.qtproject.qt.android.QtSurface;
import org.qtproject.qt.android.QtSurfaceInterface;
import org.qtproject.qt.android.QtTextureView;
import org.qtproject.qt.android.UsedFromNativeCode;

@SuppressLint(value={"ViewConstructor"})
class QtWindow
extends QtLayout
implements QtSurfaceInterface {
    private View m_surfaceContainer;
    private View m_nativeView;
    private final HashMap<Integer, QtWindow> m_childWindows = new HashMap();
    private QtWindow m_parentWindow;
    private GestureDetector m_gestureDetector;
    private final QtEditText m_editText;
    private final QtInputConnection.QtInputConnectionListener m_inputConnectionListener;

    private static native void setSurface(int var0, Surface var1);

    private static native void safeAreaMarginsChanged(Insets var0, int var1);

    static native void windowFocusChanged(boolean var0, int var1);

    static native void updateWindows();

    QtWindow(Context context, boolean bl, QtWindow qtWindow, QtInputConnection.QtInputConnectionListener qtInputConnectionListener) {
        super(context);
        this.setId(View.generateViewId());
        this.m_inputConnectionListener = qtInputConnectionListener;
        this.setParent(qtWindow);
        this.setFocusableInTouchMode(true);
        this.setDefaultFocusHighlightEnabled(false);
        this.setImportantForAccessibility(2);
        this.setVisible(false);
        if (!bl && context instanceof Activity) {
            this.m_editText = new QtEditText(context, qtInputConnectionListener);
            this.m_editText.setImportantForAccessibility(2);
            QtLayout.LayoutParams layoutParams = new QtLayout.LayoutParams(-2, -2);
            QtNative.runAction(() -> this.addView(this.m_editText, layoutParams));
        } else {
            this.m_editText = null;
        }
        QtNative.runAction(() -> {
            this.m_gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

                public void onLongPress(MotionEvent motionEvent) {
                    QtInputDelegate.longPress(QtWindow.this.getId(), (int)motionEvent.getX(), (int)motionEvent.getY());
                }
            });
            this.m_gestureDetector.setIsLongpressEnabled(true);
        });
        if (this.getContext() instanceof QtActivityBase) {
            this.setOnApplyWindowInsetsListener((view, windowInsets) -> {
                Insets insets;
                if (Build.VERSION.SDK_INT >= 30) {
                    int n = WindowInsets.Type.displayCutout() | WindowInsets.Type.systemBars();
                    insets = windowInsets.getInsets(n);
                } else {
                    DisplayCutout displayCutout;
                    int n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = 0;
                    int n5 = view.getSystemUiVisibility();
                    if ((n5 & 4) == 0) {
                        n = windowInsets.getSystemWindowInsetLeft();
                        n2 = windowInsets.getSystemWindowInsetTop();
                        n3 = windowInsets.getSystemWindowInsetRight();
                        n4 = windowInsets.getSystemWindowInsetBottom();
                    }
                    if ((displayCutout = windowInsets.getDisplayCutout()) != null) {
                        n = Math.max(n, displayCutout.getSafeInsetLeft());
                        n2 = Math.max(n2, displayCutout.getSafeInsetTop());
                        n3 = Math.max(n3, displayCutout.getSafeInsetRight());
                        n4 = Math.max(n4, displayCutout.getSafeInsetBottom());
                    }
                    insets = Insets.of((int)n, (int)n2, (int)n3, (int)n4);
                }
                QtNative.runAction(() -> QtWindow.safeAreaMarginsChanged(insets, this.getId()));
                return windowInsets;
            });
            QtNative.runAction(() -> this.requestApplyInsets());
        }
    }

    @UsedFromNativeCode
    void setVisible(boolean bl) {
        QtNative.runAction(() -> {
            if (bl) {
                this.setVisibility(0);
            } else {
                this.setVisibility(4);
            }
        });
    }

    @Override
    public void onSurfaceChanged(Surface surface) {
        QtWindow.setSurface(this.getId(), surface);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        QtWindow.windowFocusChanged(true, this.getId());
        if (this.m_editText != null && this.m_inputConnectionListener != null) {
            this.m_inputConnectionListener.onEditTextChanged(this.m_editText);
        }
        QtInputDelegate.sendTouchEvent(motionEvent, this.getId());
        this.m_gestureDetector.onTouchEvent(motionEvent);
        return true;
    }

    public boolean onTrackballEvent(MotionEvent motionEvent) {
        QtInputDelegate.sendTrackballEvent(motionEvent, this.getId());
        return true;
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return QtInputDelegate.sendGenericMotionEvent(motionEvent, this.getId());
    }

    @UsedFromNativeCode
    void removeWindow() {
        if (this.m_parentWindow != null) {
            this.m_parentWindow.removeChildWindow(this.getId());
        }
    }

    @UsedFromNativeCode
    void createSurface(boolean bl, int n, boolean bl2, int n2) {
        QtNative.runAction(() -> {
            if (this.m_surfaceContainer != null) {
                this.removeView(this.m_surfaceContainer);
            }
            this.m_surfaceContainer = n2 == 0 ? new QtSurface(this.getContext(), this, bl, n) : new QtTextureView(this.getContext(), this, bl2);
            this.m_surfaceContainer.setLayoutParams((ViewGroup.LayoutParams)new QtLayout.LayoutParams(-1, -1));
            this.addView(this.m_surfaceContainer, 0);
        });
    }

    @UsedFromNativeCode
    void destroySurface() {
        QtNative.runAction(() -> {
            if (this.m_surfaceContainer != null) {
                this.removeView(this.m_surfaceContainer);
                this.m_surfaceContainer = null;
            }
        }, false);
    }

    @UsedFromNativeCode
    void setGeometry(int n, int n2, int n3, int n4) {
        QtNative.runAction(() -> {
            if (this.getContext() instanceof QtActivityBase) {
                this.setLayoutParams(new QtLayout.LayoutParams(n3, n4, n, n2));
            }
        });
    }

    void addChildWindow(QtWindow qtWindow) {
        QtNative.runAction(() -> {
            this.m_childWindows.put(qtWindow.getId(), qtWindow);
            this.addView((View)qtWindow, this.getChildCount());
        });
    }

    void removeChildWindow(int n) {
        QtNative.runAction(() -> {
            if (this.m_childWindows.containsKey(n)) {
                this.removeView((View)this.m_childWindows.remove(n));
            }
        });
    }

    @UsedFromNativeCode
    void setNativeView(View view) {
        QtNative.runAction(() -> {
            if (this.m_nativeView != null) {
                this.removeView(this.m_nativeView);
            }
            this.m_nativeView = view;
            this.m_nativeView.setLayoutParams((ViewGroup.LayoutParams)new QtLayout.LayoutParams(-1, -1));
            this.addView(this.m_nativeView);
        });
    }

    @UsedFromNativeCode
    void bringChildToFront(int n) {
        QtNative.runAction(() -> {
            View view = (View)this.m_childWindows.get(n);
            if (view != null && this.getChildCount() > 0) {
                this.moveChild(view, this.getChildCount() - 1);
            }
        });
    }

    @UsedFromNativeCode
    void bringChildToBack(int n) {
        QtNative.runAction(() -> {
            View view = (View)this.m_childWindows.get(n);
            if (view != null) {
                this.moveChild(view, 0);
            }
        });
    }

    @UsedFromNativeCode
    void removeNativeView() {
        QtNative.runAction(() -> {
            if (this.m_nativeView != null) {
                this.removeView(this.m_nativeView);
                this.m_nativeView = null;
            }
        });
    }

    void setParent(QtWindow qtWindow) {
        if (this.m_parentWindow == qtWindow) {
            return;
        }
        if (this.m_parentWindow != null) {
            this.m_parentWindow.removeChildWindow(this.getId());
        }
        this.m_parentWindow = qtWindow;
        if (this.m_parentWindow != null) {
            this.m_parentWindow.addChildWindow(this);
        }
    }

    @UsedFromNativeCode
    void updateFocusedEditText() {
        if (this.m_editText != null && this.m_inputConnectionListener != null) {
            this.m_inputConnectionListener.onEditTextChanged(this.m_editText);
        }
    }
}

