
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was Config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# provide meta-data
set(qtutilities_varname "QT_UTILITIES")
set(qtutilities_varname "QT_UTILITIES")
set(QT_UTILITIES_DISPLAY_NAME "Qt Utilities")
set(QT_UTILITIES_AUTHOR "Martchus")
set(QT_UTILITIES_VERSION "6.19.1-685.23ebaee")
set(QT_UTILITIES_VERSION_MAJOR "6")
set(QT_UTILITIES_VERSION_MINOR "19")
set(QT_UTILITIES_VERSION_PATCH "1")
set(QT_UTILITIES_GIT_REV_COUNT "685")
set(QT_UTILITIES_GIT_LAST_COMMIT_ID "23ebaee")
set(QT_UTILITIES_URL "https://github.com/Martchus/qtutilities")
set(QT_UTILITIES_DESCRIPTION "Common Qt related C++ classes and routines used by my applications such as dialogs, widgets and models")
set(QT_UTILITIES_LICENSE "GPL-2.0+")

# define general config
set(QT_UTILITIES_IS_HEADER_ONLY NO)
set(QT_UTILITIES_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include")
set(QT_UTILITIES_BIN_DIR "${PACKAGE_PREFIX_DIR}/bin")
set(QT_UTILITIES_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib")
set(QT_UTILITIES_DATA_DIRS "${PACKAGE_PREFIX_DIR}/share/qtutilities")
set(QT_UTILITIES_MODULE_DIRS "${PACKAGE_PREFIX_DIR}/share/qtutilities/cmake/modules")
set(QT_UTILITIES_CONFIG_DIRS "${PACKAGE_PREFIX_DIR}/share/qtutilities/cmake")
set(QT_UTILITIES_PRIVATE_QT_MODULES "Gui;Core")
set(QT_UTILITIES_PRIVATE_KF_MODULES "")
set(QT_UTILITIES_PUBLIC_QT_MODULES "Core;Gui")
set(QT_UTILITIES_PUBLIC_KF_MODULES "")
set(QT_UTILITIES_REQUIRED_PACKAGES "c++utilities")
set(QT_UTILITIES_REQUIRED_PKG_CONFIG_MODULES "")
set(QT_UTILITIES_HAS_QT_TRANSLATION_FILES YES)
set(QT_UTILITIES_QT_RESOURCES qtutilsicons;qtutilities_translations)

# define mapping from CMake targets to pkg-config module names
set(PKG_CONFIG_qtutilities "qtutilities")

# save policies before modifying them e.g. though the inclusion of 3rdParty
cmake_policy(PUSH)

# define additional find_package arguments for required CMake-packages

# define library config, add imported target
set(QT_UTILITIES_PACKAGE "qtutilities")
set(QT_UTILITIES_LIB "qtutilities")
set(QT_UTILITIES_LIB_IS_SHARED "OFF")
set(QT_UTILITIES_STATIC_LINKAGE "OFF")
if(NOT TARGET "${QT_UTILITIES_LIB}")
    # make dependencies of the library available
    # caveat: This currently does *not* cover Qt and KF modules which are so far only handled
    #         separately when using the function use_QT_UTILITIES.

    # find c++utilities to use its CMake modules
    if (NOT QT_UTILITIES_PACKAGE STREQUAL "c++utilities")
        find_package("c++utilities" ${QT_UTILITIES_FIND_PACKAGE_ARGS_c++utilities} REQUIRED)
    endif ()

    # prefer static libraries if qtutilities was configured this way during its build
    set(QT_UTILITIES_DEFAULT_CMAKE_MODULE_PATH "${CMAKE_MODULE_PATH}")
    list(APPEND CMAKE_MODULE_PATH "${QT_UTILITIES_MODULE_DIRS}")
    list(APPEND CMAKE_MODULE_PATH "${CPP_UTILITIES_MODULE_DIRS}")
    include(3rdPartyFunctions)
    if (QT_UTILITIES_STATIC_LINKAGE)
        save_library_preference()
        prefer_static_libraries()
    endif ()

    # find all required packages
    foreach (_REQUIRED_PACKAGE ${QT_UTILITIES_REQUIRED_PACKAGES})
        string(REGEX MATCH _REQUIRED_PACKAGE_MATCH "(.*)-([^-]*)" "${_REQUIRED_PACKAGE}")
        if (_REQUIRED_PACKAGE_MATCH)
            set(_REQUIRED_PACKAGE "${CMAKE_MATCH_1}")
            set(_REQUIRED_VERSION "${CMAKE_MATCH_2}")
        else ()
            unset(_REQUIRED_VERSION)
        endif ()
        string(REPLACE "::" "_" _REQUIRED_PACKAGE_VARNAME "${_REQUIRED_PACKAGE}")
        if (QT_UTILITIES_FIND_PACKAGE_ARGS_${_REQUIRED_PACKAGE_VARNAME})
            set(_FIND_PACKAGE_ARGS ${QT_UTILITIES_FIND_PACKAGE_ARGS_${_REQUIRED_PACKAGE_VARNAME}})
        else ()
            set(_FIND_PACKAGE_ARGS REQUIRED)
        endif ()
        if (_REQUIRED_VERSION)
            find_package("${_REQUIRED_PACKAGE}" "${_REQUIRED_VERSION}" ${_FIND_PACKAGE_ARGS})
        else ()
            find_package("${_REQUIRED_PACKAGE}" ${_FIND_PACKAGE_ARGS})
        endif()
    endforeach()

    # find all required pkg-config modules
    if (QT_UTILITIES_REQUIRED_PKG_CONFIG_MODULES)
        foreach (QT_UTILITIES_REQUIRED_PKG_CONFIG_MODULE ${QT_UTILITIES_REQUIRED_PKG_CONFIG_MODULES})
            string(REPLACE "::" "_" QT_UTILITIES_REQUIRED_PKG_CONFIG_MODULE_VARNAME "${QT_UTILITIES_REQUIRED_PKG_CONFIG_MODULE}")
            use_pkg_config_module(
                TARGET_NAME "${QT_UTILITIES_REQUIRED_PKG_CONFIG_MODULE}"
                PKG_CONFIG_MODULES "${PKG_CONFIG_${QT_UTILITIES_REQUIRED_PKG_CONFIG_MODULE_VARNAME}}"
                LIBRARIES_VARIABLE DEV_NULL
                PKG_CONFIG_MODULES_VARIABLE DEV_NULL
            )
        endforeach ()
    endif ()

    # restore preference of static libraries
    if (QT_UTILITIES_STATIC_LINKAGE)
        restore_library_preference()
    endif ()

    # add target for the library itself
    include("${CMAKE_CURRENT_LIST_DIR}/qtutilitiesTargets.cmake")

    # restore module path
    set(CMAKE_MODULE_PATH "${QT_UTILITIES_DEFAULT_CMAKE_MODULE_PATH}")
endif()

# define function to ease use of library in projects following conventions of c++utilities' build script
function(use_QT_UTILITIES)
    # make CMake modules of the project available
    list(APPEND CMAKE_MODULE_PATH "${QT_UTILITIES_MODULE_DIRS}")
    set(CMAKE_MODULE_PATH "${CMAKE_MODULE_PATH}" PARENT_SCOPE)

    # parse arguments
    list(APPEND CMAKE_MODULE_PATH "${CPP_UTILITIES_MODULE_DIRS}")
    include(3rdParty)
    parse_arguments_for_use_functions(${ARGN})

    # link against library (also "link" against header-only libs to get compile defs and interface link libs)
    link_directories(${QT_UTILITIES_LIB_DIR})
    if (ARGS_ONLY_HEADERS)
        set(TARGET_NAME "${QT_UTILITIES_LIB}-headers")
    else ()
        set(TARGET_NAME "${QT_UTILITIES_LIB}")
    endif ()
    set("${ARGS_LIBRARIES_VARIABLE}" "${${ARGS_LIBRARIES_VARIABLE}};${TARGET_NAME}" PARENT_SCOPE)
    set("${ARGS_PACKAGES_VARIABLE}" "${${ARGS_PACKAGES_VARIABLE}};${QT_UTILITIES_PACKAGE}" PARENT_SCOPE)

    if (ARGS_ONLY_HEADERS)
        return ()
    endif ()

    # add required Qt and KF modules
    set(IMPORTED_QT_MODULES
        ${IMPORTED_QT_MODULES}
        ${QT_UTILITIES_PUBLIC_QT_MODULES}
        ${QT_UTILITIES_PRIVATE_QT_MODULES}
        PARENT_SCOPE
    )
    set(IMPORTED_KF_MODULES
        ${IMPORTED_KF_MODULES}
        ${QT_UTILITIES_PUBLIC_KF_MODULES}
        ${QT_UTILITIES_PRIVATE_KF_MODULES}
        PARENT_SCOPE
    )

    # add required translations to APP_SPECIFIC_QT_TRANSLATION_FILES_ARRAY
    if(QT_UTILITIES_HAS_QT_TRANSLATION_FILES)
        set(APP_SPECIFIC_QT_TRANSLATION_FILES "${APP_SPECIFIC_QT_TRANSLATION_FILES};qtutilities" PARENT_SCOPE)
    endif()

    # add Qt resources if it is a static library
    if (NOT QT_UTILITIES_LIB_IS_SHARED)
        set(STATIC_LIBRARIES_QT_RESOURCES "${STATIC_LIBRARIES_QT_RESOURCES};${QT_UTILITIES_QT_RESOURCES}" PARENT_SCOPE)
    endif()
endfunction()

# restore policies
cmake_policy(POP)
