/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.multimedia;

import android.content.Context;
import android.media.AudioDeviceCallback;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.qtproject.qt.android.UsedFromNativeCode;

class QtAudioDeviceManager {
    private static final String TAG = "QtAudioDeviceManager";
    private static AudioManager m_audioManager = null;
    private static final AudioDevicesReceiver m_audioDevicesReceiver = new AudioDevicesReceiver();
    private static Handler handler = new Handler(Looper.getMainLooper());
    private static AudioRecord m_recorder = null;
    private static AudioTrack m_streamPlayer = null;
    private static Thread m_streamingThread = null;
    private static boolean m_isStreaming = false;
    private static boolean m_useSpeaker = false;
    private static final int m_sampleRate = 8000;
    private static final int m_channels = 2;
    private static final int m_audioFormat = 2;
    private static final int m_bufferSize = AudioRecord.getMinBufferSize((int)8000, (int)2, (int)2);
    private static int m_currentOutputId = -1;
    private static AtomicInteger m_scoCounter = new AtomicInteger();
    private static AtomicInteger m_communicationDeviceCounter = new AtomicInteger();
    private static AtomicInteger m_speakerphoneCounter = new AtomicInteger();
    private static int m_currentCommunicationDeviceId = -1;
    private static final HashMap<Integer, Integer> priorityMap = new HashMap<Integer, Integer>(){
        {
            this.put(3, 1);
            this.put(4, 1);
            this.put(8, 2);
            this.put(7, 2);
            this.put(2, 3);
        }
    };
    private static final int DEFAULT_PRIORITY = 4;
    private static final int[] bluetoothTypes = new int[]{8, 7};
    private static final int[] wiredTypes = new int[]{3, 4};

    QtAudioDeviceManager() {
    }

    static native void onAudioInputDevicesUpdated();

    static native void onAudioOutputDevicesUpdated();

    private static void updateDeviceList() {
        if (m_currentOutputId != -1) {
            QtAudioDeviceManager.prepareAudioOutput(m_currentOutputId);
        }
        QtAudioDeviceManager.onAudioInputDevicesUpdated();
        QtAudioDeviceManager.onAudioOutputDevicesUpdated();
    }

    static void registerAudioHeadsetStateReceiver() {
        m_audioManager.registerAudioDeviceCallback((AudioDeviceCallback)m_audioDevicesReceiver, handler);
    }

    static void unregisterAudioHeadsetStateReceiver() {
        m_audioManager.unregisterAudioDeviceCallback((AudioDeviceCallback)m_audioDevicesReceiver);
    }

    static void setContext(Context context) {
        m_audioManager = (AudioManager)context.getSystemService("audio");
    }

    static AudioDeviceInfo[] getAudioOutputDevices() {
        return QtAudioDeviceManager.getAudioDevices(2);
    }

    static AudioDeviceInfo[] getAudioInputDevices() {
        return QtAudioDeviceManager.getAudioDevices(1);
    }

    @UsedFromNativeCode
    static AudioDeviceInfo getAudioInputDeviceInfo(int n) {
        AudioDeviceInfo[] audioDeviceInfoArray;
        for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray = m_audioManager.getDevices(1)) {
            if (audioDeviceInfo.getId() != n) continue;
            return audioDeviceInfo;
        }
        return null;
    }

    @UsedFromNativeCode
    static int getDefaultSampleRate() {
        String string = m_audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
        return Integer.parseInt(string);
    }

    @UsedFromNativeCode
    static boolean isBluetoothDevice(AudioDeviceInfo audioDeviceInfo) {
        switch (audioDeviceInfo.getType()) {
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @UsedFromNativeCode
    static boolean prepareAudioInput(int n) {
        AudioDeviceInfo[] audioDeviceInfoArray;
        for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray = m_audioManager.getDevices(1)) {
            if (audioDeviceInfo.getId() != n) continue;
            switch (audioDeviceInfo.getType()) {
                case 3: 
                case 7: 
                case 8: 
                case 15: 
                case 22: {
                    return QtAudioDeviceManager.prepareAudioDevice(audioDeviceInfo, 0);
                }
            }
            return true;
        }
        return false;
    }

    private static void setInputMuted(boolean bl) {
        m_audioManager.setMicrophoneMute(bl);
    }

    private static boolean isMicrophoneMute() {
        return m_audioManager.isMicrophoneMute();
    }

    private static String audioDeviceTypeToString(int n) {
        switch (n) {
            case 19: {
                return "AUX Line";
            }
            case 7: 
            case 8: {
                return "Bluetooth";
            }
            case 1: {
                return "Built in earpiece";
            }
            case 15: {
                return "Built in microphone";
            }
            case 2: {
                return "Built in speaker";
            }
            case 13: {
                return "Dock";
            }
            case 14: {
                return "FM";
            }
            case 16: {
                return "FM TUNER";
            }
            case 9: {
                return "HDMI";
            }
            case 10: {
                return "HDMI ARC";
            }
            case 20: {
                return "IP";
            }
            case 5: {
                return "Line analog";
            }
            case 6: {
                return "Line digital";
            }
            case 17: {
                return "TV tuner";
            }
            case 12: {
                return "USB accessory";
            }
            case 4: {
                return "Wired headphones";
            }
            case 3: {
                return "Wired headset";
            }
        }
        if (Build.VERSION.SDK_INT >= 24 && n == 21) {
            return "Bus";
        }
        return "Unknown-Type";
    }

    private static void sortAudioDevices(AudioDeviceInfo[] audioDeviceInfoArray) {
        Comparator<AudioDeviceInfo> comparator = new Comparator<AudioDeviceInfo>(){

            @Override
            public int compare(AudioDeviceInfo audioDeviceInfo, AudioDeviceInfo audioDeviceInfo2) {
                return this.getPriority(audioDeviceInfo) - this.getPriority(audioDeviceInfo2);
            }

            private int getPriority(AudioDeviceInfo audioDeviceInfo) {
                return priorityMap.getOrDefault(audioDeviceInfo.getType(), 4);
            }
        };
        Arrays.sort(audioDeviceInfoArray, comparator);
    }

    private static AudioDeviceInfo[] getAudioDevices(int n) {
        ArrayList<AudioDeviceInfo> arrayList = new ArrayList<AudioDeviceInfo>();
        if (Build.VERSION.SDK_INT >= 23) {
            boolean bl = false;
            boolean bl2 = false;
            AudioDeviceInfo[] audioDeviceInfoArray = m_audioManager.getDevices(n);
            QtAudioDeviceManager.sortAudioDevices(audioDeviceInfoArray);
            for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray) {
                String string = QtAudioDeviceManager.audioDeviceTypeToString(audioDeviceInfo.getType());
                if (string.equals(QtAudioDeviceManager.audioDeviceTypeToString(0))) continue;
                if (string.equals(QtAudioDeviceManager.audioDeviceTypeToString(15))) {
                    if (bl) continue;
                    bl = true;
                } else if (QtAudioDeviceManager.isBluetoothDevice(audioDeviceInfo)) {
                    if (bl2) continue;
                    bl2 = true;
                }
                arrayList.add(audioDeviceInfo);
            }
        }
        return arrayList.toArray(new AudioDeviceInfo[arrayList.size()]);
    }

    private static boolean containsAnyOfType(AudioDeviceInfo[] audioDeviceInfoArray, int[] ... nArray) {
        return Arrays.stream(audioDeviceInfoArray).anyMatch(audioDeviceInfo -> Arrays.stream(nArray).flatMapToInt(Arrays::stream).anyMatch(n -> audioDeviceInfo.getType() == n));
    }

    private static int getCorrectModeIfContainsAnyOfType(AudioDeviceInfo[] audioDeviceInfoArray, int[] ... nArray) {
        return QtAudioDeviceManager.containsAnyOfType(audioDeviceInfoArray, nArray) ? 3 : 0;
    }

    private static int getModeForWired(AudioDeviceInfo[] audioDeviceInfoArray) {
        return QtAudioDeviceManager.getCorrectModeIfContainsAnyOfType(audioDeviceInfoArray, new int[][]{bluetoothTypes});
    }

    private static int getModeForBluetooth(AudioDeviceInfo[] audioDeviceInfoArray) {
        return QtAudioDeviceManager.getCorrectModeIfContainsAnyOfType(audioDeviceInfoArray, new int[][]{wiredTypes});
    }

    private static int getModeForSpeaker(AudioDeviceInfo[] audioDeviceInfoArray) {
        return QtAudioDeviceManager.getCorrectModeIfContainsAnyOfType(audioDeviceInfoArray, bluetoothTypes, wiredTypes);
    }

    private static boolean prepareAudioOutput(int n) {
        AudioDeviceInfo[] audioDeviceInfoArray;
        for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray = m_audioManager.getDevices(2)) {
            if (audioDeviceInfo.getId() != n) continue;
            switch (audioDeviceInfo.getType()) {
                case 7: 
                case 8: {
                    return QtAudioDeviceManager.prepareAudioDevice(audioDeviceInfo, QtAudioDeviceManager.getModeForBluetooth(audioDeviceInfoArray));
                }
                case 2: {
                    return QtAudioDeviceManager.prepareAudioDevice(audioDeviceInfo, QtAudioDeviceManager.getModeForSpeaker(audioDeviceInfoArray));
                }
                case 3: 
                case 4: {
                    return QtAudioDeviceManager.prepareAudioDevice(audioDeviceInfo, QtAudioDeviceManager.getModeForWired(audioDeviceInfoArray));
                }
                case 1: {
                    Log.w((String)TAG, (String)"Built in Earpiece may not work when Wired Headphones are connected");
                    return QtAudioDeviceManager.prepareAudioDevice(audioDeviceInfo, 2);
                }
                case 9: 
                case 10: 
                case 29: {
                    return QtAudioDeviceManager.prepareAudioDevice(audioDeviceInfo, 0);
                }
            }
            return false;
        }
        return false;
    }

    private static AudioDeviceInfo getValidCommunicationDevice(AudioDeviceInfo audioDeviceInfo) {
        if (audioDeviceInfo.isSink()) {
            return audioDeviceInfo;
        }
        if (QtAudioDeviceManager.isBluetoothDevice(audioDeviceInfo)) {
            List list = m_audioManager.getAvailableCommunicationDevices();
            for (AudioDeviceInfo audioDeviceInfo2 : list) {
                boolean bl = audioDeviceInfo2.getType() == audioDeviceInfo.getType();
                boolean bl2 = audioDeviceInfo2.getAddress().equals(audioDeviceInfo.getAddress());
                if (!bl || !bl2) continue;
                return audioDeviceInfo2;
            }
            Log.w((String)TAG, (String)("No matching bluetooth output device found for " + audioDeviceInfo));
        }
        return null;
    }

    private static boolean deviceIsCurrentCommunicationDevice(AudioDeviceInfo audioDeviceInfo) {
        if (m_currentCommunicationDeviceId == -1 || audioDeviceInfo == null) {
            return false;
        }
        return m_currentCommunicationDeviceId == audioDeviceInfo.getId();
    }

    @UsedFromNativeCode
    static void releaseAudioDevice(int n) {
        AudioDeviceInfo[] audioDeviceInfoArray;
        for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray = m_audioManager.getDevices(3)) {
            if (audioDeviceInfo.getId() != n) continue;
            QtAudioDeviceManager.releaseAudioDevice(audioDeviceInfo);
        }
    }

    private static void releaseAudioDevice(AudioDeviceInfo audioDeviceInfo) {
        if (Build.VERSION.SDK_INT >= 31) {
            AudioDeviceInfo audioDeviceInfo2 = QtAudioDeviceManager.getValidCommunicationDevice(audioDeviceInfo);
            if (!QtAudioDeviceManager.deviceIsCurrentCommunicationDevice(audioDeviceInfo2)) {
                return;
            }
            if (m_communicationDeviceCounter.decrementAndGet() == 0) {
                m_audioManager.clearCommunicationDevice();
                m_currentCommunicationDeviceId = -1;
            }
        } else if (QtAudioDeviceManager.isBluetoothDevice(audioDeviceInfo) && m_audioManager.isBluetoothScoOn() && m_scoCounter.decrementAndGet() == 0) {
            m_audioManager.stopBluetoothSco();
            m_audioManager.setBluetoothScoOn(false);
        } else if (audioDeviceInfo.getType() == 2 && m_speakerphoneCounter.decrementAndGet() == 0) {
            m_audioManager.setSpeakerphoneOn(false);
        }
    }

    private static boolean prepareAudioDevice(AudioDeviceInfo audioDeviceInfo, int n) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        if (audioDeviceInfo == null) {
            return false;
        }
        m_audioManager.setMode(n);
        boolean bl4 = audioDeviceInfo.isSink();
        if (bl4) {
            m_currentOutputId = audioDeviceInfo.getId();
        }
        boolean bl5 = (bl3 = QtAudioDeviceManager.isBluetoothDevice(audioDeviceInfo)) && !bl4;
        boolean bl6 = bl2 = n == 2 || n == 3;
        if (Build.VERSION.SDK_INT >= 31) {
            if (!bl5 && !bl2) {
                return true;
            }
            AudioDeviceInfo audioDeviceInfo2 = QtAudioDeviceManager.getValidCommunicationDevice(audioDeviceInfo);
            if (audioDeviceInfo2 == null) {
                Log.w((String)TAG, (String)("No suitable communication device to set to enable communication via " + audioDeviceInfo.getId()));
                return false;
            }
            if (QtAudioDeviceManager.deviceIsCurrentCommunicationDevice(audioDeviceInfo2)) {
                m_communicationDeviceCounter.incrementAndGet();
                return true;
            }
            if (m_audioManager.setCommunicationDevice(audioDeviceInfo2)) {
                m_currentCommunicationDeviceId = audioDeviceInfo2.getId();
                m_communicationDeviceCounter.set(1);
                return true;
            }
            return false;
        }
        boolean bl7 = bl = audioDeviceInfo.getType() == 2;
        if (bl5 && m_scoCounter.getAndIncrement() == 0) {
            m_audioManager.startBluetoothSco();
            m_audioManager.setBluetoothScoOn(true);
        } else if (bl && m_speakerphoneCounter.getAndIncrement() == 0) {
            m_audioManager.setSpeakerphoneOn(true);
        }
        return true;
    }

    private static void streamSound() {
        byte[] byArray = new byte[m_bufferSize];
        while (m_isStreaming) {
            m_recorder.read(byArray, 0, m_bufferSize);
            m_streamPlayer.play();
            m_streamPlayer.write(byArray, 0, m_bufferSize);
            m_streamPlayer.stop();
        }
    }

    private static void startSoundStreaming(int n, int n2) {
        AudioDeviceInfo[] audioDeviceInfoArray;
        if (m_isStreaming) {
            QtAudioDeviceManager.stopSoundStreaming();
        }
        m_recorder = new AudioRecord(0, 8000, 2, 2, m_bufferSize);
        m_streamPlayer = new AudioTrack(3, 8000, 2, 2, m_bufferSize, 1);
        for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray = m_audioManager.getDevices(3)) {
            if (audioDeviceInfo.getId() == n2) {
                m_streamPlayer.setPreferredDevice(audioDeviceInfo);
                continue;
            }
            if (audioDeviceInfo.getId() != n) continue;
            m_recorder.setPreferredDevice(audioDeviceInfo);
        }
        m_recorder.startRecording();
        m_isStreaming = true;
        m_streamingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                QtAudioDeviceManager.streamSound();
            }
        });
        m_streamingThread.start();
    }

    private static void stopSoundStreaming() {
        if (!m_isStreaming) {
            return;
        }
        m_isStreaming = false;
        try {
            m_streamingThread.join();
            m_streamingThread = null;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        m_recorder.stop();
        m_recorder.release();
        m_streamPlayer.release();
        m_streamPlayer = null;
        m_recorder = null;
    }

    private static class AudioDevicesReceiver
    extends AudioDeviceCallback {
        private AudioDevicesReceiver() {
        }

        public void onAudioDevicesAdded(AudioDeviceInfo[] audioDeviceInfoArray) {
            QtAudioDeviceManager.updateDeviceList();
        }

        public void onAudioDevicesRemoved(AudioDeviceInfo[] audioDeviceInfoArray) {
            QtAudioDeviceManager.updateDeviceList();
        }
    }
}

