/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.multimedia;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.media.AudioAttributes;
import android.media.MediaFormat;
import android.media.MediaPlayer;
import android.media.PlaybackParams;
import android.media.TimedText;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import android.view.SurfaceHolder;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class QtAndroidMediaPlayer {
    private MediaPlayer mMediaPlayer = null;
    private AudioAttributes mAudioAttributes = null;
    private HashMap<String, String> mHeaders = null;
    private Uri mUri = null;
    private final long mID;
    private final Context mContext;
    private boolean mMuted = false;
    private int mVolume = 100;
    private static final String TAG = "Qt MediaPlayer";
    private SurfaceHolder mSurfaceHolder = null;
    private ScheduledExecutorService mProgressScheduler = null;
    private ScheduledFuture<?> mProgressWatcherHandle = null;
    private volatile int mState = 1;

    native void onErrorNative(int var1, int var2, long var3);

    native void onBufferingUpdateNative(int var1, long var2);

    native void onProgressUpdateNative(int var1, long var2);

    native void onDurationChangedNative(int var1, long var2);

    native void onInfoNative(int var1, int var2, long var3);

    native void onVideoSizeChangedNative(int var1, int var2, long var3);

    native void onStateChangedNative(int var1, long var2);

    native void onTrackInfoChangedNative(long var1);

    native void onTimedTextChangedNative(String var1, int var2, long var3);

    QtAndroidMediaPlayer(Context context, long l) {
        this.mID = l;
        this.mContext = context;
    }

    MediaPlayer getMediaPlayerHandle() {
        return this.mMediaPlayer;
    }

    private void setState(int n) {
        if (this.mState == n) {
            return;
        }
        this.mState = n;
        this.onStateChangedNative(this.mState, this.mID);
    }

    private void init() {
        if (this.mMediaPlayer != null) {
            return;
        }
        this.mMediaPlayer = new MediaPlayer();
        this.setState(2);
        this.setVolumeHelper(this.mMuted ? 0 : this.mVolume);
        QtAndroidMediaPlayer.setAudioAttributes(this.mMediaPlayer, this.mAudioAttributes);
        this.mMediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)new MediaPlayerBufferingListener());
        this.mMediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)new MediaPlayerCompletionListener());
        this.mMediaPlayer.setOnInfoListener((MediaPlayer.OnInfoListener)new MediaPlayerInfoListener());
        this.mMediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)new MediaPlayerSeekCompleteListener());
        this.mMediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)new MediaPlayerVideoSizeChangedListener());
        this.mMediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)new MediaPlayerErrorListener());
        this.mMediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)new MediaPlayerPreparedListener());
        this.mMediaPlayer.setOnTimedTextListener((MediaPlayer.OnTimedTextListener)new MediaPlayerTimedTextListener());
        this.mProgressScheduler = Executors.newScheduledThreadPool(1);
    }

    void startProgressWatcher() {
        if (this.mProgressScheduler.isTerminated() || this.mProgressScheduler == null) {
            this.mProgressScheduler = Executors.newScheduledThreadPool(1);
        }
        this.mProgressWatcherHandle = this.mProgressScheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (QtAndroidMediaPlayer.this.isPlaying()) {
                    QtAndroidMediaPlayer.this.onProgressUpdateNative(QtAndroidMediaPlayer.this.getCurrentPosition(), QtAndroidMediaPlayer.this.mID);
                }
            }
        }, 10L, 100L, TimeUnit.MILLISECONDS);
    }

    void cancelProgressWatcher() {
        if (this.mProgressScheduler != null) {
            this.mProgressScheduler.shutdown();
        }
    }

    void start() {
        if ((this.mState & 0x1A8) == 0) {
            return;
        }
        try {
            this.mMediaPlayer.start();
            this.setState(32);
            this.startProgressWatcher();
        }
        catch (IllegalStateException illegalStateException) {
            Log.w((String)TAG, (Throwable)illegalStateException);
        }
    }

    void pause() {
        if ((this.mState & 0x1A0) == 0) {
            return;
        }
        try {
            this.mMediaPlayer.pause();
            this.setState(128);
        }
        catch (IllegalStateException illegalStateException) {
            Log.w((String)TAG, (Throwable)illegalStateException);
        }
    }

    void stop() {
        if ((this.mState & 0x1E8) == 0) {
            return;
        }
        try {
            this.mMediaPlayer.stop();
            this.setState(64);
            this.cancelProgressWatcher();
        }
        catch (IllegalStateException illegalStateException) {
            Log.w((String)TAG, (Throwable)illegalStateException);
        }
    }

    void seekTo(int n) {
        if ((this.mState & 0x1A8) == 0) {
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                this.mMediaPlayer.seekTo((long)n, 3);
            } else {
                this.mMediaPlayer.seekTo(n);
            }
        }
        catch (IllegalStateException illegalStateException) {
            Log.w((String)TAG, (Throwable)illegalStateException);
        }
    }

    boolean isPlaying() {
        boolean bl = false;
        if ((this.mState & 0x1FA) == 0) {
            return bl;
        }
        try {
            bl = this.mMediaPlayer.isPlaying();
        }
        catch (IllegalStateException illegalStateException) {
            Log.w((String)TAG, (Throwable)illegalStateException);
        }
        return bl;
    }

    void prepareAsync() {
        if ((this.mState & 0x50) == 0) {
            return;
        }
        try {
            this.mMediaPlayer.prepareAsync();
            this.setState(4);
        }
        catch (IllegalStateException illegalStateException) {
            Log.w((String)TAG, (Throwable)illegalStateException);
        }
    }

    void initHeaders() {
        this.mHeaders = new HashMap();
    }

    void setHeader(String string, String string2) {
        this.mHeaders.put(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDataSource(String string) {
        block23: {
            if (this.mState == 1) {
                this.init();
            }
            if (this.mState != 2) {
                this.reset();
            }
            if (this.mState != 2) {
                Log.w((String)TAG, (String)"Trying to set data source of a media player that is not idle!");
                return;
            }
            if (this.mSurfaceHolder != null) {
                this.mMediaPlayer.setDisplay(this.mSurfaceHolder);
            }
            AssetFileDescriptor assetFileDescriptor = null;
            FileInputStream fileInputStream = null;
            try {
                this.mUri = Uri.parse((String)string);
                if (this.mUri.getScheme().compareTo("assets") == 0) {
                    String string2 = this.mUri.getPath().substring(1);
                    AssetManager assetManager = this.mContext.getAssets();
                    assetFileDescriptor = assetManager.openFd(string2);
                    long l = assetFileDescriptor.getStartOffset();
                    long l2 = assetFileDescriptor.getLength();
                    FileDescriptor fileDescriptor = assetFileDescriptor.getFileDescriptor();
                    this.mMediaPlayer.setDataSource(fileDescriptor, l, l2);
                } else if (this.mUri.getScheme().compareTo("file") == 0) {
                    fileInputStream = new FileInputStream(this.mUri.getPath());
                    FileDescriptor fileDescriptor = fileInputStream.getFD();
                    this.mMediaPlayer.setDataSource(fileDescriptor);
                } else if (this.mUri.getScheme().compareTo("content") == 0) {
                    this.mMediaPlayer.setDataSource(this.mContext, this.mUri, this.mHeaders);
                } else {
                    this.mMediaPlayer.setDataSource(string);
                }
                this.setState(16);
            }
            catch (Exception exception) {
                Log.w((String)TAG, (Throwable)exception);
            }
            finally {
                try {
                    if (assetFileDescriptor != null) {
                        assetFileDescriptor.close();
                    }
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                if ((this.mState & 0x10) != 0) break block23;
                this.setState(512);
                this.onErrorNative(1, -1004, this.mID);
                return;
            }
        }
    }

    private boolean isMediaPlayerPrepared() {
        int n = 488;
        return (this.mState & n) != 0;
    }

    TrackInfo[] getAllTrackInfo() {
        if (!this.isMediaPlayerPrepared()) {
            Log.w((String)TAG, (String)"Trying to get track info of a media player that is not prepared!");
            return new TrackInfo[0];
        }
        MediaPlayer.TrackInfo[] trackInfoArray = new MediaPlayer.TrackInfo[]{};
        try {
            trackInfoArray = this.mMediaPlayer.getTrackInfo();
        }
        catch (IllegalStateException illegalStateException) {
            Log.w((String)TAG, (Throwable)illegalStateException);
        }
        int n = trackInfoArray.length;
        TrackInfo[] trackInfoArray2 = new TrackInfo[n];
        for (int i = 0; i < n; ++i) {
            MediaPlayer.TrackInfo trackInfo = trackInfoArray[i];
            int n2 = trackInfo.getTrackType();
            String string = this.getMimeType(trackInfo);
            String string2 = trackInfo.getLanguage();
            trackInfoArray2[i] = new TrackInfo(n2, string, string2);
        }
        return trackInfoArray2;
    }

    private String getMimeType(MediaPlayer.TrackInfo trackInfo) {
        String string;
        String string2 = string = "application/octet-stream";
        MediaFormat mediaFormat = trackInfo.getFormat();
        if (mediaFormat != null) {
            string2 = mediaFormat.getString("mime", string);
        }
        return string2;
    }

    void selectTrack(int n) {
        if (!this.isMediaPlayerPrepared()) {
            Log.d((String)TAG, (String)"Trying to select a track of a media player that is not prepared!");
            return;
        }
        try {
            this.mMediaPlayer.selectTrack(n);
        }
        catch (IllegalStateException illegalStateException) {
            Log.w((String)TAG, (Throwable)illegalStateException);
        }
    }

    void deselectTrack(int n) {
        if (!this.isMediaPlayerPrepared()) {
            Log.d((String)TAG, (String)"Trying to deselect track of a media player that is not prepared!");
            return;
        }
        try {
            this.mMediaPlayer.deselectTrack(n);
        }
        catch (IllegalStateException illegalStateException) {
            Log.w((String)TAG, (Throwable)illegalStateException);
        }
    }

    int getSelectedTrack(int n) {
        boolean bl;
        int n2 = -1;
        if (!this.isMediaPlayerPrepared()) {
            Log.d((String)TAG, (String)"Trying to get the selected track of a media player that is not prepared!");
            return n2;
        }
        boolean bl2 = n == 1;
        boolean bl3 = n == 2;
        boolean bl4 = n == 3;
        boolean bl5 = bl = n == 4;
        if (!(bl2 || bl3 || bl || bl4)) {
            Log.w((String)TAG, (String)"Trying to get a selected track of a invalid type Only Video,Audio, TimedText and Subtitle tracks are selectable.");
            return n2;
        }
        try {
            return this.mMediaPlayer.getSelectedTrack(n);
        }
        catch (IllegalStateException illegalStateException) {
            Log.w((String)TAG, (Throwable)illegalStateException);
            return n2;
        }
    }

    int getCurrentPosition() {
        int n = 0;
        if ((this.mState & 0x1FA) == 0) {
            return n;
        }
        try {
            n = this.mMediaPlayer.getCurrentPosition();
        }
        catch (IllegalStateException illegalStateException) {
            Log.w((String)TAG, (Throwable)illegalStateException);
        }
        return n;
    }

    int getDuration() {
        int n = 0;
        if ((this.mState & 0x1E8) == 0) {
            return n;
        }
        try {
            n = this.mMediaPlayer.getDuration();
        }
        catch (IllegalStateException illegalStateException) {
            Log.w((String)TAG, (Throwable)illegalStateException);
        }
        return n;
    }

    void setVolume(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 100) {
            n = 100;
        }
        this.mVolume = n;
        if (!this.mMuted) {
            this.setVolumeHelper(this.mVolume);
        }
    }

    private void setVolumeHelper(int n) {
        if ((this.mState & 0x1FA) == 0) {
            return;
        }
        try {
            float f = (float)n / 100.0f;
            this.mMediaPlayer.setVolume(f, f);
        }
        catch (IllegalStateException illegalStateException) {
            Log.w((String)TAG, (Throwable)illegalStateException);
        }
    }

    SurfaceHolder display() {
        return this.mSurfaceHolder;
    }

    void setDisplay(SurfaceHolder surfaceHolder) {
        this.mSurfaceHolder = surfaceHolder;
        if ((this.mState & 1) != 0) {
            return;
        }
        this.mMediaPlayer.setDisplay(this.mSurfaceHolder);
    }

    int getVolume() {
        return this.mVolume;
    }

    void mute(boolean bl) {
        this.mMuted = bl;
        this.setVolumeHelper(bl ? 0 : this.mVolume);
    }

    boolean isMuted() {
        return this.mMuted;
    }

    void reset() {
        if (this.mState == 1) {
            return;
        }
        this.mMediaPlayer.reset();
        this.setState(2);
        this.cancelProgressWatcher();
    }

    void release() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        this.setState(1);
        this.cancelProgressWatcher();
    }

    void setAudioAttributes(int n, int n2) {
        this.mAudioAttributes = new AudioAttributes.Builder().setUsage(n2).setContentType(n).build();
        QtAndroidMediaPlayer.setAudioAttributes(this.mMediaPlayer, this.mAudioAttributes);
    }

    private static void setAudioAttributes(MediaPlayer mediaPlayer, AudioAttributes audioAttributes) {
        if (mediaPlayer == null || audioAttributes == null) {
            return;
        }
        try {
            mediaPlayer.setAudioAttributes(audioAttributes);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.w((String)TAG, (Throwable)illegalArgumentException);
        }
    }

    boolean setPlaybackRate(float f) {
        PlaybackParams playbackParams = this.mMediaPlayer.getPlaybackParams();
        playbackParams.setSpeed(f);
        if ((double)f != 0.0) {
            playbackParams.setPitch(Math.abs(f));
        }
        try {
            this.mMediaPlayer.setPlaybackParams(playbackParams);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            Log.e((String)TAG, (String)("Cannot set playback rate " + f + " :" + runtimeException.toString()));
            return false;
        }
        if ((this.mState & 0x20) == 0 && this.mMediaPlayer.isPlaying()) {
            this.setState(32);
            this.startProgressWatcher();
        }
        return true;
    }

    private class State {
        static final int Uninitialized = 1;
        static final int Idle = 2;
        static final int Preparing = 4;
        static final int Prepared = 8;
        static final int Initialized = 16;
        static final int Started = 32;
        static final int Stopped = 64;
        static final int Paused = 128;
        static final int PlaybackCompleted = 256;
        static final int Error = 512;

        private State() {
        }
    }

    private class MediaPlayerBufferingListener
    implements MediaPlayer.OnBufferingUpdateListener {
        private int mBufferPercent = -1;

        private MediaPlayerBufferingListener() {
        }

        public void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
            if (this.mBufferPercent == n) {
                return;
            }
            this.mBufferPercent = n;
            QtAndroidMediaPlayer.this.onBufferingUpdateNative(this.mBufferPercent, QtAndroidMediaPlayer.this.mID);
        }
    }

    private class MediaPlayerCompletionListener
    implements MediaPlayer.OnCompletionListener {
        private MediaPlayerCompletionListener() {
        }

        public void onCompletion(MediaPlayer mediaPlayer) {
            QtAndroidMediaPlayer.this.setState(256);
        }
    }

    private class MediaPlayerInfoListener
    implements MediaPlayer.OnInfoListener {
        private MediaPlayerInfoListener() {
        }

        public boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
            QtAndroidMediaPlayer.this.onInfoNative(n, n2, QtAndroidMediaPlayer.this.mID);
            return true;
        }
    }

    private class MediaPlayerSeekCompleteListener
    implements MediaPlayer.OnSeekCompleteListener {
        private MediaPlayerSeekCompleteListener() {
        }

        public void onSeekComplete(MediaPlayer mediaPlayer) {
            QtAndroidMediaPlayer.this.onProgressUpdateNative(QtAndroidMediaPlayer.this.getCurrentPosition(), QtAndroidMediaPlayer.this.mID);
        }
    }

    private class MediaPlayerVideoSizeChangedListener
    implements MediaPlayer.OnVideoSizeChangedListener {
        private MediaPlayerVideoSizeChangedListener() {
        }

        public void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
            QtAndroidMediaPlayer.this.onVideoSizeChangedNative(n, n2, QtAndroidMediaPlayer.this.mID);
        }
    }

    private class MediaPlayerErrorListener
    implements MediaPlayer.OnErrorListener {
        private MediaPlayerErrorListener() {
        }

        public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
            QtAndroidMediaPlayer.this.setState(512);
            QtAndroidMediaPlayer.this.onErrorNative(n, n2, QtAndroidMediaPlayer.this.mID);
            return true;
        }
    }

    private class MediaPlayerPreparedListener
    implements MediaPlayer.OnPreparedListener {
        private MediaPlayerPreparedListener() {
        }

        public void onPrepared(MediaPlayer mediaPlayer) {
            QtAndroidMediaPlayer.this.setState(8);
            QtAndroidMediaPlayer.this.onDurationChangedNative(QtAndroidMediaPlayer.this.getDuration(), QtAndroidMediaPlayer.this.mID);
            QtAndroidMediaPlayer.this.onTrackInfoChangedNative(QtAndroidMediaPlayer.this.mID);
        }
    }

    private class MediaPlayerTimedTextListener
    implements MediaPlayer.OnTimedTextListener {
        private MediaPlayerTimedTextListener() {
        }

        public void onTimedText(MediaPlayer mediaPlayer, TimedText timedText) {
            QtAndroidMediaPlayer.this.onTimedTextChangedNative(timedText.getText(), mediaPlayer.getCurrentPosition(), QtAndroidMediaPlayer.this.mID);
        }
    }

    class TrackInfo {
        private int type;
        private String mime;
        private String language;

        TrackInfo(int n, String string, String string2) {
            this.type = n;
            this.mime = string;
            this.language = string2;
        }

        int getType() {
            return this.type;
        }

        String getMime() {
            return this.mime;
        }

        String getLanguage() {
            return this.language;
        }
    }
}

