/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.multimedia;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.util.Range;
import android.view.Surface;
import java.util.ArrayList;
import java.util.List;
import org.qtproject.qt.android.UsedFromNativeCode;
import org.qtproject.qt.android.multimedia.QtExifDataHandler;
import org.qtproject.qt.android.multimedia.QtVideoDeviceManager;

@TargetApi(value=23)
class QtCamera2 {
    CameraDevice mCameraDevice = null;
    QtVideoDeviceManager mVideoDeviceManager = null;
    HandlerThread mBackgroundThread;
    Handler mBackgroundHandler;
    ImageReader mPreviewImageReader = null;
    ImageReader mStillPhotoImageReader = null;
    CameraManager mCameraManager;
    CameraCaptureSession mCaptureSession;
    CaptureRequest.Builder mPreviewRequestBuilder;
    CaptureRequest mPreviewRequest;
    String mCameraId;
    List<Surface> mTargetSurfaces = new ArrayList<Surface>();
    private static int MaxNumberFrames = 12;
    private static final int DEFAULT_FLASH_MODE = 1;
    private static final int DEFAULT_TORCH_MODE = 0;
    private static final int DEFAULT_AF_MODE = 4;
    private static final float DEFAULT_FOCUS_DISTANCE = 1.0f;
    private static final float DEFAULT_ZOOM_FACTOR = 1.0f;
    private final SyncedMembers mSyncedMembers = new SyncedMembers();
    private QtExifDataHandler mExifDataHandler = null;
    CameraDevice.StateCallback mStateCallback = new CameraDevice.StateCallback(){

        public void onOpened(CameraDevice cameraDevice) {
            if (QtCamera2.this.mCameraDevice != null) {
                QtCamera2.this.mCameraDevice.close();
            }
            QtCamera2.this.mCameraDevice = cameraDevice;
            QtCamera2.this.onCameraOpened(QtCamera2.this.mCameraId);
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            cameraDevice.close();
            if (QtCamera2.this.mCameraDevice == cameraDevice) {
                QtCamera2.this.mCameraDevice = null;
            }
            QtCamera2.this.onCameraDisconnect(QtCamera2.this.mCameraId);
        }

        public void onError(CameraDevice cameraDevice, int n) {
            cameraDevice.close();
            if (QtCamera2.this.mCameraDevice == cameraDevice) {
                QtCamera2.this.mCameraDevice = null;
            }
            QtCamera2.this.onCameraError(QtCamera2.this.mCameraId, n);
        }
    };
    CameraCaptureSession.StateCallback mCaptureStateCallback = new CameraCaptureSession.StateCallback(){

        public void onConfigured(CameraCaptureSession cameraCaptureSession) {
            QtCamera2.this.mCaptureSession = cameraCaptureSession;
            QtCamera2.this.onCaptureSessionConfigured(QtCamera2.this.mCameraId);
        }

        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
            QtCamera2.this.onCaptureSessionConfigureFailed(QtCamera2.this.mCameraId);
        }

        public void onActive(CameraCaptureSession cameraCaptureSession) {
            super.onActive(cameraCaptureSession);
            QtCamera2.this.onSessionActive(QtCamera2.this.mCameraId);
        }

        public void onClosed(CameraCaptureSession cameraCaptureSession) {
            super.onClosed(cameraCaptureSession);
            QtCamera2.this.onSessionClosed(QtCamera2.this.mCameraId);
        }
    };
    PreviewCaptureSessionCallback mPreviewCaptureCallback = new PreviewCaptureSessionCallback();
    ImageReader.OnImageAvailableListener mOnStillPhotoAvailableListener = new ImageReader.OnImageAvailableListener(){

        public void onImageAvailable(ImageReader imageReader) {
            QtCamera2.this.onStillPhotoAvailable(QtCamera2.this.mCameraId, imageReader.acquireLatestImage());
        }
    };
    ImageReader.OnImageAvailableListener mOnPreviewImageAvailableListener = new ImageReader.OnImageAvailableListener(){

        public void onImageAvailable(ImageReader imageReader) {
            try {
                Image image = imageReader.acquireLatestImage();
                if (image != null) {
                    QtCamera2.this.onPreviewFrameAvailable(QtCamera2.this.mCameraId, image);
                }
            }
            catch (IllegalStateException illegalStateException) {
                Log.e((String)"QtCamera2", (String)("Image processing taking too long. Let's wait 0,5s more " + illegalStateException));
                try {
                    Thread.sleep(500L);
                    QtCamera2.this.onPreviewFrameAvailable(QtCamera2.this.mCameraId, imageReader.acquireLatestImage());
                }
                catch (IllegalStateException | InterruptedException exception) {
                    Log.e((String)"QtCamera2", (String)("Will not wait anymore. Restart camera session. " + exception));
                    String string = QtCamera2.this.mCameraId;
                    QtCamera2.this.stopAndClose();
                    QtCamera2.this.addImageReader(QtCamera2.this.mPreviewImageReader.getWidth(), QtCamera2.this.mPreviewImageReader.getHeight(), QtCamera2.this.mPreviewImageReader.getImageFormat());
                    QtCamera2.this.open(string);
                }
            }
        }
    };

    native void onStillPhotoCaptureFailed(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedFromNativeCode
    public void resetControlProperties() {
        SyncedMembers syncedMembers = this.mSyncedMembers;
        synchronized (syncedMembers) {
            this.mSyncedMembers.mCameraSettings = new CameraSettings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CameraSettings atomicCameraSettingsCopy() {
        SyncedMembers syncedMembers = this.mSyncedMembers;
        synchronized (syncedMembers) {
            return new CameraSettings(this.mSyncedMembers.mCameraSettings);
        }
    }

    native void onCameraOpened(String var1);

    native void onCameraDisconnect(String var1);

    native void onCameraError(String var1, int var2);

    native void onCaptureSessionConfigured(String var1);

    native void onCaptureSessionConfigureFailed(String var1);

    native void onSessionActive(String var1);

    native void onSessionClosed(String var1);

    native void onCaptureSessionFailed(String var1, int var2, long var3);

    QtCamera2(Context context) {
        this.mCameraManager = (CameraManager)context.getSystemService("camera");
        this.mVideoDeviceManager = new QtVideoDeviceManager(context);
        this.startBackgroundThread();
    }

    void startBackgroundThread() {
        this.mBackgroundThread = new HandlerThread("CameraBackground");
        this.mBackgroundThread.start();
        this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
    }

    @UsedFromNativeCode
    void stopBackgroundThread() {
        this.mBackgroundThread.quitSafely();
        try {
            this.mBackgroundThread.join();
            this.mBackgroundThread = null;
            this.mBackgroundHandler = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @SuppressLint(value={"MissingPermission"})
    boolean open(String string) {
        try {
            this.mCameraId = string;
            this.mCameraManager.openCamera(string, this.mStateCallback, this.mBackgroundHandler);
            return true;
        }
        catch (Exception exception) {
            Log.w((String)"QtCamera2", (String)("Failed to open camera:" + exception));
            return false;
        }
    }

    native void onStillPhotoAvailable(String var1, Image var2);

    native void onPreviewFrameAvailable(String var1, Image var2);

    @UsedFromNativeCode
    void prepareCamera(int n, int n2, int n3, int n4, int n5) {
        this.addImageReader(n, n2, n3);
        this.setFrameRate(n4, n5);
    }

    private void addImageReader(int n, int n2, int n3) {
        if (this.mPreviewImageReader != null) {
            this.removeSurface(this.mPreviewImageReader.getSurface());
        }
        if (this.mStillPhotoImageReader != null) {
            this.removeSurface(this.mStillPhotoImageReader.getSurface());
        }
        this.mPreviewImageReader = ImageReader.newInstance((int)n, (int)n2, (int)n3, (int)MaxNumberFrames);
        this.mPreviewImageReader.setOnImageAvailableListener(this.mOnPreviewImageAvailableListener, this.mBackgroundHandler);
        this.addSurface(this.mPreviewImageReader.getSurface());
        this.mStillPhotoImageReader = ImageReader.newInstance((int)n, (int)n2, (int)n3, (int)MaxNumberFrames);
        this.mStillPhotoImageReader.setOnImageAvailableListener(this.mOnStillPhotoAvailableListener, this.mBackgroundHandler);
        this.addSurface(this.mStillPhotoImageReader.getSurface());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFrameRate(int n, int n2) {
        SyncedMembers syncedMembers = this.mSyncedMembers;
        synchronized (syncedMembers) {
            ((SyncedMembers)this.mSyncedMembers).mCameraSettings.mFpsRange = n <= 0 || n2 <= 0 ? null : new Range((Comparable)Integer.valueOf(n), (Comparable)Integer.valueOf(n2));
        }
    }

    boolean addSurface(Surface surface) {
        if (this.mTargetSurfaces.contains(surface)) {
            return true;
        }
        return this.mTargetSurfaces.add(surface);
    }

    boolean removeSurface(Surface surface) {
        return this.mTargetSurfaces.remove(surface);
    }

    @UsedFromNativeCode
    void clearSurfaces() {
        this.mTargetSurfaces.clear();
    }

    @UsedFromNativeCode
    boolean createSession() {
        if (this.mCameraDevice == null) {
            return false;
        }
        try {
            this.mCameraDevice.createCaptureSession(this.mTargetSurfaces, this.mCaptureStateCallback, this.mBackgroundHandler);
            return true;
        }
        catch (Exception exception) {
            Log.w((String)"QtCamera2", (String)("Failed to create a capture session:" + exception));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedFromNativeCode
    boolean start() {
        if (this.mCameraDevice == null) {
            return false;
        }
        if (this.mCaptureSession == null) {
            return false;
        }
        try {
            SyncedMembers syncedMembers = this.mSyncedMembers;
            synchronized (syncedMembers) {
                this.setRepeatingRequestToPreview();
                this.mSyncedMembers.mIsStarted = true;
            }
            return true;
        }
        catch (CameraAccessException cameraAccessException) {
            Log.w((String)"QtCamera2", (String)("Failed to start preview:" + (Object)((Object)cameraAccessException)));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedFromNativeCode
    void stopAndClose() {
        SyncedMembers syncedMembers = this.mSyncedMembers;
        synchronized (syncedMembers) {
            try {
                if (null != this.mCaptureSession) {
                    this.mCaptureSession.close();
                    this.mCaptureSession = null;
                }
                if (null != this.mCameraDevice) {
                    this.mCameraDevice.close();
                    this.mCameraDevice = null;
                }
                this.mCameraId = "";
                this.mTargetSurfaces.clear();
            }
            catch (Exception exception) {
                Log.w((String)"QtCamera2", (String)("Failed to stop and close:" + exception));
            }
            this.mSyncedMembers.mIsStarted = false;
            this.mSyncedMembers.mIsTakingStillPhoto = false;
        }
    }

    private void finalizeStillPhoto(CameraSettings cameraSettings) throws CameraAccessException {
        CaptureRequest.Builder builder = this.mCameraDevice.createCaptureRequest(2);
        builder.addTarget(this.mStillPhotoImageReader.getSurface());
        builder.set(CaptureRequest.CONTROL_CAPTURE_INTENT, (Object)2);
        this.applyStillPhotoSettingsToCaptureRequestBuilder(builder, cameraSettings);
        this.mCaptureSession.capture(builder.build(), (CameraCaptureSession.CaptureCallback)new StillPhotoFinalizerCallback(), this.mBackgroundHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedFromNativeCode
    void beginStillPhotoCapture() {
        Object object = this.mSyncedMembers;
        synchronized (object) {
            if (this.mSyncedMembers.mIsTakingStillPhoto) {
                Log.w((String)"QtCamera2", (String)"beginStillPhotoCapture() was called on camera backend while there is already a still photo in progress. This is not supported. Likely Qt developer bug.");
                return;
            }
        }
        object = this.atomicCameraSettingsCopy();
        try {
            this.submitNewStillPhotoCapture((CameraSettings)object);
        }
        catch (CameraAccessException cameraAccessException) {
            Log.w((String)"QtCamera2", (String)("Cannot get access to the camera: " + (Object)((Object)cameraAccessException)));
            cameraAccessException.printStackTrace();
            this.onStillPhotoCaptureFailed(this.mCameraId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void submitNewStillPhotoCapture(CameraSettings cameraSettings) throws CameraAccessException {
        CaptureRequest.Builder builder = this.mCameraDevice.createCaptureRequest(2);
        builder.addTarget(this.mPreviewImageReader.getSurface());
        this.applyStillPhotoSettingsToCaptureRequestBuilder(builder, cameraSettings);
        boolean bl = (Integer)builder.get(CaptureRequest.CONTROL_AF_MODE) == 1;
        Integer n = (Integer)builder.get(CaptureRequest.CONTROL_AE_MODE);
        boolean bl2 = n != null && n != 0;
        StillPhotoPrecaptureCallback stillPhotoPrecaptureCallback = new StillPhotoPrecaptureCallback(cameraSettings, bl, bl2);
        this.mCaptureSession.setRepeatingRequest(builder.build(), (CameraCaptureSession.CaptureCallback)stillPhotoPrecaptureCallback, this.mBackgroundHandler);
        if (bl) {
            builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
        }
        if (bl2) {
            builder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
        }
        this.mCaptureSession.capture(builder.build(), null, this.mBackgroundHandler);
        SyncedMembers syncedMembers = this.mSyncedMembers;
        synchronized (syncedMembers) {
            this.mSyncedMembers.mIsTakingStillPhoto = true;
        }
    }

    @UsedFromNativeCode
    void saveExifToFile(String string) {
        if (this.mExifDataHandler != null) {
            this.mExifDataHandler.save(string);
        } else {
            Log.e((String)"QtCamera2", (String)("No Exif data that could be saved to " + string));
        }
    }

    private Rect getScalerCropRegion(float f) {
        Rect rect = this.mVideoDeviceManager.getActiveArraySize(this.mCameraId);
        float f2 = 1.0f;
        if (f != 0.0f) {
            f2 = 1.0f / f;
        }
        int n = rect.width() - (int)((float)rect.width() * f2);
        int n2 = rect.height() - (int)((float)rect.height() * f2);
        return new Rect(n / 2, n2 / 2, rect.width() - n / 2, rect.height() - n2 / 2);
    }

    private void applyZoomSettingsToRequestBuilder(CaptureRequest.Builder builder, float f) {
        if (Build.VERSION.SDK_INT < 30) {
            builder.set(CaptureRequest.SCALER_CROP_REGION, (Object)this.getScalerCropRegion(f));
        } else {
            builder.set(CaptureRequest.CONTROL_ZOOM_RATIO, (Object)Float.valueOf(f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedFromNativeCode
    void zoomTo(float f) {
        SyncedMembers syncedMembers = this.mSyncedMembers;
        synchronized (syncedMembers) {
            ((SyncedMembers)this.mSyncedMembers).mCameraSettings.mZoomFactor = f;
            if (!this.mSyncedMembers.mIsStarted) {
                return;
            }
            this.applyZoomSettingsToRequestBuilder(this.mPreviewRequestBuilder, f);
            this.mPreviewRequest = this.mPreviewRequestBuilder.build();
            if (this.mSyncedMembers.mIsTakingStillPhoto) {
                return;
            }
            try {
                this.mCaptureSession.setRepeatingRequest(this.mPreviewRequest, (CameraCaptureSession.CaptureCallback)this.mPreviewCaptureCallback, this.mBackgroundHandler);
            }
            catch (Exception exception) {
                Log.w((String)"QtCamera2", (String)("Failed to set zoom:" + exception));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedFromNativeCode
    void setFocusMode(int n) {
        int n2 = 0;
        if (n == 0) {
            n2 = 4;
        } else if (n == 5) {
            n2 = 0;
        } else {
            Log.d((String)"QtCamera2", (String)"received a QCamera::FocusMode from native code that is not recognized. Likely Qt developer bug. Ignoring.");
            return;
        }
        SyncedMembers syncedMembers = this.mSyncedMembers;
        synchronized (syncedMembers) {
            ((SyncedMembers)this.mSyncedMembers).mCameraSettings.mAFMode = n2;
            if (!this.mSyncedMembers.mIsStarted) {
                return;
            }
            this.applyFocusSettingsToCaptureRequestBuilder(this.mPreviewRequestBuilder, this.mSyncedMembers.mCameraSettings, false);
            this.mPreviewRequest = this.mPreviewRequestBuilder.build();
            if (this.mSyncedMembers.mIsTakingStillPhoto) {
                return;
            }
            try {
                this.mCaptureSession.setRepeatingRequest(this.mPreviewRequest, (CameraCaptureSession.CaptureCallback)this.mPreviewCaptureCallback, this.mBackgroundHandler);
            }
            catch (Exception exception) {
                Log.w((String)"QtCamera2", (String)("Failed to set focus mode:" + exception));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedFromNativeCode
    void setFlashMode(String string) {
        SyncedMembers syncedMembers = this.mSyncedMembers;
        synchronized (syncedMembers) {
            int n = this.mVideoDeviceManager.stringToControlAEMode(string);
            if (n < 0) {
                Log.w((String)"QtCamera2", (String)"Unknown flash mode");
                return;
            }
            ((SyncedMembers)this.mSyncedMembers).mCameraSettings.mStillPhotoFlashMode = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedFromNativeCode
    public void setFocusDistance(float f) {
        if (f < 0.0f || f > 1.0f) {
            Log.w((String)"QtCamera2", (String)"received out-of-bounds value when setting camera focus-distance. Likely Qt developer bug. Ignoring.");
            return;
        }
        SyncedMembers syncedMembers = this.mSyncedMembers;
        synchronized (syncedMembers) {
            ((SyncedMembers)this.mSyncedMembers).mCameraSettings.mFocusDistance = f;
            if (!this.mSyncedMembers.mIsStarted) {
                return;
            }
            if (((SyncedMembers)this.mSyncedMembers).mCameraSettings.mAFMode == 0) {
                this.applyFocusSettingsToCaptureRequestBuilder(this.mPreviewRequestBuilder, this.mSyncedMembers.mCameraSettings, false);
                this.mPreviewRequest = this.mPreviewRequestBuilder.build();
                if (this.mSyncedMembers.mIsTakingStillPhoto) {
                    return;
                }
                try {
                    this.mCaptureSession.setRepeatingRequest(this.mPreviewRequest, (CameraCaptureSession.CaptureCallback)this.mPreviewCaptureCallback, this.mBackgroundHandler);
                }
                catch (Exception exception) {
                    Log.w((String)"QtCamera2", (String)("Failed to set focus distance:" + exception));
                }
            }
        }
    }

    private int getTorchModeValue(boolean bl) {
        return bl ? 2 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedFromNativeCode
    void setTorchMode(boolean bl) {
        SyncedMembers syncedMembers = this.mSyncedMembers;
        synchronized (syncedMembers) {
            ((SyncedMembers)this.mSyncedMembers).mCameraSettings.mTorchMode = this.getTorchModeValue(bl);
            if (this.mSyncedMembers.mIsStarted) {
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)((SyncedMembers)this.mSyncedMembers).mCameraSettings.mTorchMode);
                this.mPreviewRequest = this.mPreviewRequestBuilder.build();
                if (this.mSyncedMembers.mIsTakingStillPhoto) {
                    return;
                }
                try {
                    this.mCaptureSession.setRepeatingRequest(this.mPreviewRequest, (CameraCaptureSession.CaptureCallback)this.mPreviewCaptureCallback, this.mBackgroundHandler);
                }
                catch (Exception exception) {
                    Log.w((String)"QtCamera2", (String)("Failed to set flash mode:" + exception));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedFromNativeCode
    private void setRepeatingRequestToPreview() throws CameraAccessException {
        SyncedMembers syncedMembers = this.mSyncedMembers;
        synchronized (syncedMembers) {
            this.mPreviewRequestBuilder = this.mCameraDevice.createCaptureRequest(3);
            this.mPreviewRequestBuilder.addTarget(this.mPreviewImageReader.getSurface());
            this.applyPreviewSettingsToCaptureRequestBuilder(this.mPreviewRequestBuilder, this.mSyncedMembers.mCameraSettings);
            this.mPreviewRequest = this.mPreviewRequestBuilder.build();
            this.mCaptureSession.setRepeatingRequest(this.mPreviewRequest, (CameraCaptureSession.CaptureCallback)this.mPreviewCaptureCallback, this.mBackgroundHandler);
        }
    }

    private void applyStillPhotoSettingsToCaptureRequestBuilder(CaptureRequest.Builder builder, CameraSettings cameraSettings) {
        builder.set(CaptureRequest.CONTROL_CAPTURE_INTENT, (Object)2);
        builder.set(CaptureRequest.CONTROL_MODE, (Object)1);
        builder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
        this.applyZoomSettingsToRequestBuilder(builder, cameraSettings.mZoomFactor);
        this.applyFocusSettingsToCaptureRequestBuilder(builder, cameraSettings, true);
        if (cameraSettings.mStillPhotoFlashMode == 3) {
            builder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
            builder.set(CaptureRequest.FLASH_MODE, (Object)2);
        } else if (cameraSettings.mStillPhotoFlashMode == 2) {
            builder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
        }
    }

    private void applyPreviewSettingsToCaptureRequestBuilder(CaptureRequest.Builder builder, CameraSettings cameraSettings) {
        builder.set(CaptureRequest.CONTROL_CAPTURE_INTENT, (Object)3);
        this.applyFocusSettingsToCaptureRequestBuilder(builder, cameraSettings, false);
        builder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
        builder.set(CaptureRequest.FLASH_MODE, (Object)cameraSettings.mTorchMode);
        this.applyZoomSettingsToRequestBuilder(builder, cameraSettings.mZoomFactor);
        if (cameraSettings.mFpsRange != null) {
            builder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, cameraSettings.mFpsRange);
        }
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)0);
    }

    void applyFocusSettingsToCaptureRequestBuilder(CaptureRequest.Builder builder, CameraSettings cameraSettings, boolean bl) {
        int n = cameraSettings.mAFMode;
        if (bl && n == 4) {
            n = 1;
        }
        if (!this.isAfModeAvailable(n)) {
            if (this.isAfModeAvailable(0)) {
                builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
            }
            builder.set(CaptureRequest.LENS_FOCUS_DISTANCE, null);
            return;
        }
        builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)n);
        if (n == 0) {
            float f = this.calcLensFocusDistanceFromQCameraFocusDistance(cameraSettings.mFocusDistance);
            if (f < 0.0f) {
                Log.w((String)"QtCamera2", (String)"Tried to apply FocusModeManual on a camera that doesn't support setting lens distance. Likely Qt developer bug. Ignoring.");
            } else {
                builder.set(CaptureRequest.LENS_FOCUS_DISTANCE, (Object)Float.valueOf(f));
            }
        } else {
            builder.set(CaptureRequest.LENS_FOCUS_DISTANCE, null);
        }
    }

    private float calcLensFocusDistanceFromQCameraFocusDistance(float f) {
        float f2 = this.mVideoDeviceManager.getLensInfoMinimumFocusDistance(this.mCameraId);
        if (f2 <= 0.0f) {
            return -1.0f;
        }
        return (1.0f - f) * f2;
    }

    private boolean isAfModeAvailable(int n) {
        if (this.mVideoDeviceManager == null || this.mCameraId == null || this.mCameraId.isEmpty()) {
            return false;
        }
        return this.mVideoDeviceManager.isAfModeAvailable(this.mCameraId, n);
    }

    static boolean afStateIsReadyForCapture(Integer n) {
        return n == null || n == 4 || n == 5;
    }

    static boolean aeStateIsReadyForCapture(Integer n) {
        return n == null || n == 2 || n == 4;
    }

    class CameraSettings {
        public int mStillPhotoFlashMode = 1;
        public int mTorchMode = 0;
        public int mAFMode = 4;
        public float mFocusDistance = 1.0f;
        public float mZoomFactor = 1.0f;
        Range<Integer> mFpsRange = null;

        public CameraSettings() {
        }

        public CameraSettings(CameraSettings cameraSettings) {
            this.mStillPhotoFlashMode = cameraSettings.mStillPhotoFlashMode;
            this.mTorchMode = cameraSettings.mTorchMode;
            this.mAFMode = cameraSettings.mAFMode;
            this.mFocusDistance = cameraSettings.mFocusDistance;
            this.mZoomFactor = cameraSettings.mZoomFactor;
            if (cameraSettings.mFpsRange != null) {
                this.mFpsRange = new Range((Comparable)((Integer)cameraSettings.mFpsRange.getLower()), (Comparable)((Integer)cameraSettings.mFpsRange.getUpper()));
            }
        }
    }

    class SyncedMembers {
        private boolean mIsStarted = false;
        private boolean mIsTakingStillPhoto = false;
        private CameraSettings mCameraSettings = new CameraSettings();

        SyncedMembers() {
        }
    }

    class PreviewCaptureSessionCallback
    extends CameraCaptureSession.CaptureCallback {
        PreviewCaptureSessionCallback() {
        }

        public void onCaptureFailed(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, CaptureFailure captureFailure) {
            super.onCaptureFailed(cameraCaptureSession, captureRequest, captureFailure);
            QtCamera2.this.onCaptureSessionFailed(QtCamera2.this.mCameraId, captureFailure.getReason(), captureFailure.getFrameNumber());
        }
    }

    class StillPhotoFinalizerCallback
    extends CameraCaptureSession.CaptureCallback {
        StillPhotoFinalizerCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCaptureFailed(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, CaptureFailure captureFailure) {
            QtCamera2.this.onStillPhotoCaptureFailed(QtCamera2.this.mCameraId);
            SyncedMembers syncedMembers = QtCamera2.this.mSyncedMembers;
            synchronized (syncedMembers) {
                QtCamera2.this.mSyncedMembers.mIsTakingStillPhoto = false;
            }
            try {
                QtCamera2.this.setRepeatingRequestToPreview();
            }
            catch (CameraAccessException cameraAccessException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCaptureCompleted(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, TotalCaptureResult totalCaptureResult) {
            try {
                QtCamera2.this.mExifDataHandler = new QtExifDataHandler((CaptureResult)totalCaptureResult);
                SyncedMembers syncedMembers = QtCamera2.this.mSyncedMembers;
                synchronized (syncedMembers) {
                    if (QtCamera2.this.mSyncedMembers.mIsStarted) {
                        QtCamera2.this.setRepeatingRequestToPreview();
                    }
                    QtCamera2.this.mSyncedMembers.mIsTakingStillPhoto = false;
                }
            }
            catch (CameraAccessException cameraAccessException) {
                cameraAccessException.printStackTrace();
            }
            catch (NullPointerException nullPointerException) {
                Log.e((String)"QtCamera2", (String)"Null-pointer access exception thrown when finalizing still photo capture. This should not be possible.");
                nullPointerException.printStackTrace();
            }
            catch (IllegalStateException illegalStateException) {
                Log.w((String)"QtCamera2", (String)"Session is no longer active.");
                illegalStateException.printStackTrace();
            }
        }
    }

    class StillPhotoPrecaptureCallback
    extends CameraCaptureSession.CaptureCallback {
        CameraSettings mCameraSettings = null;
        boolean mWaitForAutoFocus = false;
        boolean mWaitForAutoExposure = false;
        boolean mShouldProcessIncomingEvents = true;

        StillPhotoPrecaptureCallback(CameraSettings cameraSettings, boolean bl, boolean bl2) {
            this.mCameraSettings = cameraSettings;
            this.mWaitForAutoFocus = bl;
            this.mWaitForAutoExposure = bl2;
        }

        boolean capturingWithAutoFlash() {
            return this.mWaitForAutoExposure && this.mCameraSettings.mStillPhotoFlashMode == 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onCaptureFailureEvent() {
            this.mShouldProcessIncomingEvents = false;
            QtCamera2.this.onStillPhotoCaptureFailed(QtCamera2.this.mCameraId);
            SyncedMembers syncedMembers = QtCamera2.this.mSyncedMembers;
            synchronized (syncedMembers) {
                QtCamera2.this.mSyncedMembers.mIsTakingStillPhoto = false;
            }
            try {
                QtCamera2.this.setRepeatingRequestToPreview();
            }
            catch (CameraAccessException cameraAccessException) {
                // empty catch block
            }
        }

        public void onCaptureFailed(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, CaptureFailure captureFailure) {
            this.onCaptureFailureEvent();
        }

        private StillPhotoPrecaptureOperation determinePrecaptureOperation(CaptureResult captureResult) {
            Integer n = (Integer)captureResult.get(CaptureResult.CONTROL_AF_STATE);
            Integer n2 = (Integer)captureResult.get(CaptureResult.CONTROL_AE_STATE);
            if (this.capturingWithAutoFlash() && n2 == 4) {
                return StillPhotoPrecaptureOperation.RESUBMIT_WITH_FORCED_FLASH;
            }
            if (!this.mWaitForAutoFocus && !this.mWaitForAutoExposure) {
                return StillPhotoPrecaptureOperation.FINALIZE_CAPTURE;
            }
            if (this.mWaitForAutoFocus && QtCamera2.afStateIsReadyForCapture(n) && !this.mWaitForAutoExposure) {
                return StillPhotoPrecaptureOperation.FINALIZE_CAPTURE;
            }
            if (!this.mWaitForAutoFocus && this.mWaitForAutoExposure && QtCamera2.aeStateIsReadyForCapture(n2)) {
                return StillPhotoPrecaptureOperation.FINALIZE_CAPTURE;
            }
            if (this.mWaitForAutoFocus && QtCamera2.afStateIsReadyForCapture(n) && this.mWaitForAutoExposure && QtCamera2.aeStateIsReadyForCapture(n2)) {
                return StillPhotoPrecaptureOperation.FINALIZE_CAPTURE;
            }
            return StillPhotoPrecaptureOperation.WAIT;
        }

        public void onCaptureCompleted(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, TotalCaptureResult totalCaptureResult) {
            if (!this.mShouldProcessIncomingEvents) {
                return;
            }
            StillPhotoPrecaptureOperation stillPhotoPrecaptureOperation = this.determinePrecaptureOperation((CaptureResult)totalCaptureResult);
            try {
                switch (stillPhotoPrecaptureOperation) {
                    case FINALIZE_CAPTURE: {
                        QtCamera2.this.finalizeStillPhoto(this.mCameraSettings);
                        break;
                    }
                    case RESUBMIT_WITH_FORCED_FLASH: {
                        CameraSettings cameraSettings = new CameraSettings(this.mCameraSettings);
                        cameraSettings.mStillPhotoFlashMode = 3;
                        QtCamera2.this.submitNewStillPhotoCapture(cameraSettings);
                        break;
                    }
                }
            }
            catch (CameraAccessException cameraAccessException) {
                this.onCaptureFailureEvent();
            }
            if (stillPhotoPrecaptureOperation != StillPhotoPrecaptureOperation.WAIT) {
                this.mShouldProcessIncomingEvents = false;
            }
        }
    }

    static enum StillPhotoPrecaptureOperation {
        FINALIZE_CAPTURE,
        RESUBMIT_WITH_FORCED_FLASH,
        WAIT;

    }
}

