/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.nfc;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.os.Build;
import android.os.Parcelable;
import android.util.Log;

class QtNfc {
    private static final String TAG = "QtNfc";
    private static NfcAdapter m_adapter = null;
    private static PendingIntent m_pendingIntent = null;
    private static Context m_context = null;
    private static Activity m_activity = null;

    QtNfc() {
    }

    static void setContext(Context context) {
        m_context = context;
        if (context instanceof Activity) {
            m_activity = (Activity)context;
        }
        m_adapter = NfcAdapter.getDefaultAdapter((Context)context);
        if (m_activity == null) {
            Log.w((String)TAG, (String)"New NFC tags will only be recognized with Android activities and not with Android services.");
            return;
        }
        if (m_adapter == null) {
            return;
        }
        int n = Build.VERSION.SDK_INT >= 31 ? 0x2000000 : 0;
        m_pendingIntent = PendingIntent.getActivity((Context)m_activity, (int)0, (Intent)new Intent((Context)m_activity, m_activity.getClass()).addFlags(0x20000000), (int)n);
    }

    static boolean startDiscovery() {
        if (m_adapter == null || m_activity == null || !m_activity.getPackageManager().hasSystemFeature("android.hardware.nfc")) {
            return false;
        }
        m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                IntentFilter[] intentFilterArray = new IntentFilter[3];
                intentFilterArray[0] = new IntentFilter();
                intentFilterArray[0].addAction("android.nfc.action.TAG_DISCOVERED");
                intentFilterArray[0].addCategory("android.intent.category.DEFAULT");
                intentFilterArray[1] = new IntentFilter();
                intentFilterArray[1].addAction("android.nfc.action.NDEF_DISCOVERED");
                intentFilterArray[1].addCategory("android.intent.category.DEFAULT");
                try {
                    intentFilterArray[1].addDataType("*/*");
                }
                catch (IntentFilter.MalformedMimeTypeException malformedMimeTypeException) {
                    throw new RuntimeException("IntentFilter.addDataType() failed");
                }
                intentFilterArray[2] = new IntentFilter();
                intentFilterArray[2].addAction("android.nfc.action.TECH_DISCOVERED");
                String[][] stringArray = new String[][]{{"android.nfc.tech.Ndef"}, {"android.nfc.tech.NdefFormatable"}};
                try {
                    m_adapter.enableForegroundDispatch(m_activity, m_pendingIntent, intentFilterArray, stringArray);
                }
                catch (IllegalStateException illegalStateException) {
                    Log.d((String)QtNfc.TAG, (String)("enableForegroundDispatch failed: " + illegalStateException.toString()));
                }
            }
        });
        return true;
    }

    static boolean stopDiscovery() {
        if (m_adapter == null || m_activity == null || !m_activity.getPackageManager().hasSystemFeature("android.hardware.nfc")) {
            return false;
        }
        m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    m_adapter.disableForegroundDispatch(m_activity);
                }
                catch (IllegalStateException illegalStateException) {
                    Log.d((String)QtNfc.TAG, (String)("disableForegroundDispatch failed: " + illegalStateException.toString()));
                }
            }
        });
        return true;
    }

    static boolean isEnabled() {
        if (m_adapter == null) {
            return false;
        }
        return m_adapter.isEnabled();
    }

    static boolean isSupported() {
        return m_adapter != null;
    }

    static Intent getStartIntent() {
        Log.d((String)TAG, (String)"getStartIntent");
        if (m_activity == null) {
            return null;
        }
        Intent intent = m_activity.getIntent();
        if ("android.nfc.action.NDEF_DISCOVERED".equals(intent.getAction()) || "android.nfc.action.TECH_DISCOVERED".equals(intent.getAction()) || "android.nfc.action.TAG_DISCOVERED".equals(intent.getAction())) {
            return intent;
        }
        return null;
    }

    static Parcelable getTag(Intent intent) {
        if (Build.VERSION.SDK_INT >= 33) {
            return (Parcelable)intent.getParcelableExtra("android.nfc.extra.TAG", Tag.class);
        }
        return intent.getParcelableExtra("android.nfc.extra.TAG");
    }
}

