/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.Display;
import android.view.Menu;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.PopupMenu;
import java.util.HashMap;
import org.qtproject.qt.android.BackendRegister;
import org.qtproject.qt.android.QtAccessibilityInterface;
import org.qtproject.qt.android.QtActivityDelegateBase;
import org.qtproject.qt.android.QtDisplayManager;
import org.qtproject.qt.android.QtEditText;
import org.qtproject.qt.android.QtInputDelegate;
import org.qtproject.qt.android.QtInputInterface;
import org.qtproject.qt.android.QtLayout;
import org.qtproject.qt.android.QtMenuInterface;
import org.qtproject.qt.android.QtNative;
import org.qtproject.qt.android.QtRootLayout;
import org.qtproject.qt.android.QtWindow;
import org.qtproject.qt.android.QtWindowInterface;
import org.qtproject.qt.android.UsedFromNativeCode;

class QtActivityDelegate
extends QtActivityDelegateBase
implements QtWindowInterface,
QtAccessibilityInterface,
QtMenuInterface,
QtNative.AppStateDetailsListener {
    private static final String QtTAG = "QtActivityDelegate";
    private QtRootLayout m_layout = null;
    private ImageView m_splashScreen = null;
    private boolean m_splashScreenSticky = false;
    private boolean m_backendsRegistered = false;
    private View m_dummyView = null;
    private final HashMap<Integer, View> m_nativeViews = new HashMap();

    QtActivityDelegate(Activity activity) {
        super(activity);
    }

    @Override
    void initMembers() {
        super.initMembers();
        this.setActionBarVisibility(false);
        this.setActivityBackgroundDrawable();
    }

    void registerBackends() {
        if (this.m_backendsRegistered || BackendRegister.isNull()) {
            return;
        }
        this.m_backendsRegistered = true;
        BackendRegister.registerBackend(QtWindowInterface.class, this);
        BackendRegister.registerBackend(QtAccessibilityInterface.class, this);
        BackendRegister.registerBackend(QtMenuInterface.class, this);
        BackendRegister.registerBackend(QtInputInterface.class, this.m_inputDelegate);
    }

    void unregisterBackends() {
        if (!this.m_backendsRegistered) {
            return;
        }
        this.m_backendsRegistered = false;
        if (BackendRegister.isNull()) {
            return;
        }
        BackendRegister.unregisterBackend(QtWindowInterface.class);
        BackendRegister.unregisterBackend(QtAccessibilityInterface.class);
        BackendRegister.unregisterBackend(QtMenuInterface.class);
        BackendRegister.unregisterBackend(QtInputInterface.class);
    }

    @Override
    public void setSystemUiVisibility(boolean bl, boolean bl2) {
        if (this.m_layout == null) {
            return;
        }
        QtNative.runAction(() -> {
            if (this.m_layout != null) {
                this.m_displayManager.setSystemUiVisibility(bl, bl2);
                this.m_layout.requestLayout();
                QtWindow.updateWindows();
            }
        });
    }

    @Override
    public final void onAppStateDetailsChanged(QtNative.ApplicationStateDetails applicationStateDetails) {
        if (applicationStateDetails.isStarted) {
            this.registerBackends();
        } else {
            this.unregisterBackends();
        }
    }

    @Override
    void startNativeApplicationImpl(final String string2, final String string3) {
        if (this.m_layout == null) {
            Log.e((String)QtTAG, (String)"Unable to start native application with a null layout");
            return;
        }
        this.m_layout.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (QtActivityDelegate.this.m_layout != null) {
                    QtNative.startApplication(string2, string3);
                    QtActivityDelegate.this.m_layout.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            }
        });
    }

    @Override
    protected void setUpLayout() {
        this.m_layout = new QtRootLayout((Context)this.m_activity);
        int n = this.m_activity.getResources().getConfiguration().orientation;
        this.setUpSplashScreen(n);
        this.m_activity.registerForContextMenu((View)this.m_layout);
        this.m_activity.setContentView((View)this.m_layout, new ViewGroup.LayoutParams(-1, -1));
        QtDisplayManager.handleOrientationChanges(this.m_activity);
        this.handleUiModeChange(this.m_activity.getResources().getConfiguration().uiMode & 0x30);
        Display display = Build.VERSION.SDK_INT < 30 ? this.m_activity.getWindowManager().getDefaultDisplay() : this.m_activity.getDisplay();
        QtDisplayManager.handleRefreshRateChanged(QtDisplayManager.getRefreshRate(display));
        this.m_layout.getViewTreeObserver().addOnPreDrawListener(() -> {
            if (!this.m_inputDelegate.isKeyboardVisible()) {
                return true;
            }
            Rect rect = new Rect();
            this.m_activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
            DisplayMetrics displayMetrics = new DisplayMetrics();
            this.m_activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            int n = displayMetrics.heightPixels - rect.bottom;
            if (n < 0) {
                this.m_inputDelegate.setKeyboardVisibility(false, System.nanoTime());
                return true;
            }
            int[] nArray = new int[2];
            this.m_layout.getLocationOnScreen(nArray);
            QtInputDelegate.keyboardGeometryChanged(nArray[0], rect.bottom - nArray[1], rect.width(), n);
            return true;
        });
    }

    @Override
    protected void setUpSplashScreen(int n) {
        if (this.m_layout == null) {
            Log.e((String)QtTAG, (String)"Unable to setup splash screen with a null layout");
            return;
        }
        try {
            ActivityInfo activityInfo = this.m_activity.getPackageManager().getActivityInfo(this.m_activity.getComponentName(), 128);
            String string2 = "android.app.splash_screen_drawable_" + (n == 2 ? "landscape" : "portrait");
            if (!activityInfo.metaData.containsKey(string2)) {
                string2 = "android.app.splash_screen_drawable";
            }
            if (activityInfo.metaData.containsKey(string2)) {
                this.m_splashScreenSticky = activityInfo.metaData.containsKey("android.app.splash_screen_sticky") && activityInfo.metaData.getBoolean("android.app.splash_screen_sticky");
                int n2 = activityInfo.metaData.getInt(string2);
                this.m_splashScreen = new ImageView((Context)this.m_activity);
                this.m_splashScreen.setImageDrawable(this.m_activity.getResources().getDrawable(n2, this.m_activity.getTheme()));
                this.m_splashScreen.setScaleType(ImageView.ScaleType.FIT_XY);
                this.m_splashScreen.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
                this.m_layout.addView((View)this.m_splashScreen);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected void hideSplashScreen(int n) {
        QtNative.runAction(() -> {
            if (this.m_splashScreen == null) {
                return;
            }
            if (this.m_layout != null && n <= 0) {
                this.m_layout.removeView((View)this.m_splashScreen);
                this.m_splashScreen = null;
                return;
            }
            AlphaAnimation alphaAnimation = new AlphaAnimation(1.0f, 0.0f);
            alphaAnimation.setInterpolator((Interpolator)new AccelerateInterpolator());
            alphaAnimation.setDuration((long)n);
            alphaAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationEnd(Animation animation) {
                    QtActivityDelegate.this.hideSplashScreen(0);
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationStart(Animation animation) {
                }
            });
            this.m_splashScreen.startAnimation((Animation)alphaAnimation);
        });
    }

    @Override
    public void notifyLocationChange(int n) {
        this.m_accessibilityDelegate.notifyLocationChange(n);
    }

    @Override
    public void notifyObjectHide(int n, int n2) {
        this.m_accessibilityDelegate.notifyObjectHide(n, n2);
    }

    @Override
    public void notifyObjectShow(int n) {
        this.m_accessibilityDelegate.notifyObjectShow(n);
    }

    @Override
    public void notifyObjectFocus(int n) {
        this.m_accessibilityDelegate.notifyObjectFocus(n);
    }

    @Override
    public void notifyValueChanged(int n, String string2) {
        this.m_accessibilityDelegate.notifyValueChanged(n, string2);
    }

    @Override
    public void notifyScrolledEvent(int n) {
        this.m_accessibilityDelegate.notifyScrolledEvent(n);
    }

    @Override
    public void initializeAccessibility() {
        QtNative.runAction(() -> this.m_accessibilityDelegate.initLayoutAccessibility(this.m_layout));
    }

    @Override
    public void resetOptionsMenu() {
        QtNative.runAction(() -> ((Activity)this.m_activity).invalidateOptionsMenu());
    }

    @Override
    public void openOptionsMenu() {
        QtNative.runAction(() -> ((Activity)this.m_activity).openOptionsMenu());
    }

    @Override
    public void closeContextMenu() {
        QtNative.runAction(() -> ((Activity)this.m_activity).closeContextMenu());
    }

    @Override
    public void openContextMenu(int n, int n2, int n3, int n4) {
        if (this.m_layout == null) {
            Log.e((String)QtTAG, (String)"Unable to open context menu with a null layout");
            return;
        }
        this.m_layout.postDelayed(() -> {
            if (this.m_layout == null) {
                Log.w((String)QtTAG, (String)"Unable to open context menu on null layout");
                return;
            }
            final QtEditText qtEditText = this.m_inputDelegate.getCurrentQtEditText();
            if (qtEditText == null) {
                Log.w((String)QtTAG, (String)"No focused view when trying to open context menu");
                return;
            }
            this.m_layout.setLayoutParams(qtEditText, new QtLayout.LayoutParams(n3, n4, n, n2), false);
            qtEditText.requestLayout();
            qtEditText.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    qtEditText.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    PopupMenu popupMenu2 = new PopupMenu((Context)QtActivityDelegate.this.m_activity, (View)qtEditText);
                    QtActivityDelegate.this.onCreatePopupMenu(popupMenu2.getMenu());
                    popupMenu2.setOnMenuItemClickListener(arg_0 -> ((Activity)QtActivityDelegate.this.m_activity).onContextItemSelected(arg_0));
                    popupMenu2.setOnDismissListener(popupMenu -> QtActivityDelegate.this.m_activity.onContextMenuClosed(popupMenu.getMenu()));
                    popupMenu2.show();
                }
            });
        }, 100L);
    }

    void onCreatePopupMenu(Menu menu) {
        QtNative.fillContextMenu(menu);
        this.setContextMenuVisible(true);
    }

    @Override
    void setActionBarVisibility(boolean bl) {
        if (this.m_activity.getActionBar() == null) {
            return;
        }
        if (ViewConfiguration.get((Context)this.m_activity).hasPermanentMenuKey() || !bl) {
            this.m_activity.getActionBar().hide();
        } else {
            this.m_activity.getActionBar().show();
        }
    }

    @Override
    @UsedFromNativeCode
    public void addTopLevelWindow(QtWindow qtWindow) {
        if (this.m_layout == null || qtWindow == null) {
            return;
        }
        QtNative.runAction(() -> {
            if (this.m_layout == null) {
                return;
            }
            if (this.m_topLevelWindows.isEmpty() && this.m_dummyView != null) {
                this.m_layout.removeView(this.m_dummyView);
                this.m_dummyView = null;
            }
            this.m_layout.addView((View)qtWindow, this.m_topLevelWindows.size());
            this.m_topLevelWindows.put(qtWindow.getId(), qtWindow);
            if (!this.m_splashScreenSticky) {
                this.hideSplashScreen();
            }
        });
    }

    @Override
    @UsedFromNativeCode
    public void removeTopLevelWindow(int n) {
        QtNative.runAction(() -> {
            if (this.m_topLevelWindows.containsKey(n)) {
                QtWindow qtWindow = (QtWindow)this.m_topLevelWindows.remove(n);
                qtWindow.setOnApplyWindowInsetsListener(null);
                if (this.m_topLevelWindows.isEmpty()) {
                    this.m_dummyView = qtWindow;
                } else if (this.m_layout != null) {
                    this.m_layout.removeView((View)qtWindow);
                }
            }
        });
    }

    @Override
    @UsedFromNativeCode
    public void bringChildToFront(int n) {
        if (this.m_layout != null) {
            QtNative.runAction(() -> {
                QtWindow qtWindow = (QtWindow)this.m_topLevelWindows.get(n);
                if (qtWindow != null && this.m_layout != null) {
                    this.m_layout.moveChild((View)qtWindow, this.m_topLevelWindows.size() - 1);
                }
            });
        }
    }

    @Override
    @UsedFromNativeCode
    public void bringChildToBack(int n) {
        if (this.m_layout != null) {
            QtNative.runAction(() -> {
                QtWindow qtWindow = (QtWindow)this.m_topLevelWindows.get(n);
                if (qtWindow != null && this.m_layout != null) {
                    this.m_layout.moveChild((View)qtWindow, 0);
                }
            });
        }
    }

    private void setActivityBackgroundDrawable() {
        TypedValue typedValue = new TypedValue();
        this.m_activity.getTheme().resolveAttribute(16842836, typedValue, true);
        Object object = typedValue.type >= 28 && typedValue.type <= 31 ? new ColorDrawable(typedValue.data) : this.m_activity.getResources().getDrawable(typedValue.resourceId, this.m_activity.getTheme());
        this.m_activity.getWindow().setBackgroundDrawable((Drawable)object);
    }

    @UsedFromNativeCode
    void insertNativeView(int n, View view, int n2, int n3, int n4, int n5) {
        if (this.m_layout == null) {
            return;
        }
        QtNative.runAction(() -> {
            if (this.m_dummyView != null) {
                this.m_layout.removeView(this.m_dummyView);
                this.m_dummyView = null;
            }
            if (this.m_nativeViews.containsKey(n)) {
                this.m_layout.removeView(this.m_nativeViews.remove(n));
            }
            if (n4 < 0 || n5 < 0) {
                view.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            } else {
                view.setLayoutParams((ViewGroup.LayoutParams)new QtLayout.LayoutParams(n4, n5, n2, n3));
            }
            view.setId(n);
            this.m_layout.addView(view);
            this.m_nativeViews.put(n, view);
        });
    }

    @UsedFromNativeCode
    void setNativeViewGeometry(int n, int n2, int n3, int n4, int n5) {
        QtNative.runAction(() -> {
            if (this.m_nativeViews.containsKey(n)) {
                View view = this.m_nativeViews.get(n);
                if (view != null) {
                    view.setLayoutParams((ViewGroup.LayoutParams)new QtLayout.LayoutParams(n4, n5, n2, n3));
                }
            } else {
                Log.e((String)QtTAG, (String)("View " + n + " not found!"));
            }
        });
    }
}

