/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.system.Os;
import android.text.TextUtils;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import org.qtproject.qt.android.QtLayout;
import org.qtproject.qt.android.QtNative;
import org.qtproject.qt.android.QtNativeAccessibility;

class QtAccessibilityDelegate
extends View.AccessibilityDelegate {
    private static final String TAG = "Qt A11Y";
    static final int INVALID_ID = 333;
    private View m_view = null;
    private AccessibilityManager m_manager;
    private QtLayout m_layout;
    private int m_focusedVirtualViewId = 333;
    private int m_hoveredVirtualViewId = 333;
    private final int[] m_globalOffset = new int[2];
    private int m_oldOffsetX = 0;
    private int m_oldOffsetY = 0;
    private final AccessibilityNodeProvider m_nodeProvider = new AccessibilityNodeProvider(){

        public AccessibilityNodeInfo createAccessibilityNodeInfo(int n) {
            if (n == -1 || QtAccessibilityDelegate.this.m_layout.getChildCount() == 0) {
                return QtAccessibilityDelegate.this.getNodeForView();
            }
            return QtAccessibilityDelegate.this.getNodeForVirtualViewId(n);
        }

        public boolean performAction(int n, int n2, Bundle bundle) {
            if (QtAccessibilityDelegate.this.m_view == null) {
                Log.e((String)QtAccessibilityDelegate.TAG, (String)"Unable to perform action with a null view");
                return false;
            }
            boolean bl = false;
            switch (n2) {
                case 128: {
                    if (QtAccessibilityDelegate.this.m_focusedVirtualViewId == n) {
                        QtAccessibilityDelegate.this.m_focusedVirtualViewId = 333;
                    }
                    QtAccessibilityDelegate.this.m_view.invalidate();
                    QtAccessibilityDelegate.this.sendEventForVirtualViewId(n, 65536);
                    bl = true;
                    break;
                }
                default: {
                    if (n != -1) break;
                    return QtAccessibilityDelegate.this.m_view.performAccessibilityAction(n2, bundle);
                }
            }
            return bl |= QtAccessibilityDelegate.this.performActionForVirtualViewId(n, n2);
        }
    };

    QtAccessibilityDelegate() {
    }

    void initLayoutAccessibility(QtLayout qtLayout) {
        if (qtLayout == null) {
            Log.w((String)TAG, (String)"Unable to initialize the accessibility delegate with a null layout");
            return;
        }
        this.m_layout = qtLayout;
        this.m_manager = (AccessibilityManager)this.m_layout.getContext().getSystemService(AccessibilityManager.class);
        if (this.m_manager != null) {
            AccessibilityManagerListener accessibilityManagerListener = new AccessibilityManagerListener();
            if (!this.m_manager.addAccessibilityStateChangeListener((AccessibilityManager.AccessibilityStateChangeListener)accessibilityManagerListener)) {
                Log.w((String)"Qt A11y", (String)"Could not register a11y state change listener");
            }
            if (this.m_manager.isEnabled()) {
                accessibilityManagerListener.onAccessibilityStateChanged(true);
            }
        }
    }

    public AccessibilityNodeProvider getAccessibilityNodeProvider(View view) {
        return this.m_nodeProvider;
    }

    private boolean dispatchHoverEvent(MotionEvent motionEvent) {
        if (this.m_manager == null || !this.m_manager.isTouchExplorationEnabled()) {
            return false;
        }
        int n = QtNativeAccessibility.hitTest(motionEvent.getX(), motionEvent.getY());
        if (n == 333) {
            n = -1;
        }
        switch (motionEvent.getAction()) {
            case 7: 
            case 9: 
            case 10: {
                this.setHoveredVirtualViewId(n);
            }
        }
        return true;
    }

    void notifyScrolledEvent(int n) {
        QtNative.runAction(() -> this.sendEventForVirtualViewId(n, 4096));
    }

    void notifyLocationChange(int n) {
        QtNative.runAction(() -> {
            if (this.m_focusedVirtualViewId == n) {
                this.invalidateVirtualViewId(this.m_focusedVirtualViewId);
            }
        });
    }

    void notifyObjectHide(int n, int n2) {
        QtNative.runAction(() -> {
            if (this.m_view != null && this.m_focusedVirtualViewId == n) {
                this.m_focusedVirtualViewId = 333;
                this.m_view.invalidate();
                this.sendEventForVirtualViewId(n, 65536);
            }
            this.invalidateVirtualViewId(n2);
        });
    }

    void notifyObjectShow(int n) {
        QtNative.runAction(() -> this.invalidateVirtualViewId(n));
    }

    void notifyObjectFocus(int n) {
        QtNative.runAction(() -> {
            if (this.m_view == null) {
                return;
            }
            this.m_focusedVirtualViewId = n;
            this.m_view.invalidate();
            this.sendEventForVirtualViewId(n, 32768);
        });
    }

    void notifyValueChanged(int n, String string2) {
        if (this.m_manager == null) {
            return;
        }
        QtNative.runAction(() -> {
            if (this.m_view == null) {
                return;
            }
            if (n == 333 || !this.m_manager.isEnabled()) {
                Log.w((String)TAG, (String)"notifyValueChanged() for invalid view");
                return;
            }
            ViewGroup viewGroup = (ViewGroup)this.m_view.getParent();
            if (viewGroup == null) {
                Log.w((String)TAG, (String)"Could not announce value because ViewGroup was null.");
                return;
            }
            CharSequence charSequence = this.getNodeForVirtualViewId(n).getClassName();
            int n2 = charSequence != null && charSequence.equals("android.widget.ProgressBar") ? 2048 : 16384;
            AccessibilityEvent accessibilityEvent = this.obtainAccessibilityEvent(n2);
            accessibilityEvent.setEnabled(true);
            accessibilityEvent.setClassName(charSequence);
            accessibilityEvent.setContentDescription((CharSequence)string2);
            if (accessibilityEvent.getText().isEmpty() && TextUtils.isEmpty((CharSequence)accessibilityEvent.getContentDescription())) {
                Log.w((String)TAG, (String)("No value to announce for " + accessibilityEvent.getClassName()));
                return;
            }
            accessibilityEvent.setPackageName((CharSequence)this.m_view.getContext().getPackageName());
            accessibilityEvent.setSource(this.m_view, n);
            if (!viewGroup.requestSendAccessibilityEvent(this.m_view, accessibilityEvent)) {
                Log.w((String)TAG, (String)("Failed to send value change announcement for " + accessibilityEvent.getClassName()));
            }
        });
    }

    void notifyDescriptionOrNameChanged(int n, String string2) {
        if (n == this.m_focusedVirtualViewId) {
            this.notifyValueChanged(n, string2);
        }
    }

    void notifyAnnouncementEvent(int n, String string2) {
        QtNative.runAction(() -> {
            if (this.m_view == null) {
                return;
            }
            if (n == 333) {
                Log.w((String)TAG, (String)"notifyAnnouncementEvent() for invalid view");
                return;
            }
            if (!this.m_manager.isEnabled()) {
                Log.w((String)TAG, (String)"notifyAnnouncementEvent for disabled AccessibilityManager");
                return;
            }
            AccessibilityEvent accessibilityEvent = this.obtainAccessibilityEvent(16384);
            accessibilityEvent.getText().add(string2);
            accessibilityEvent.setClassName(this.getNodeForVirtualViewId(n).getClassName());
            accessibilityEvent.setPackageName((CharSequence)this.m_view.getContext().getPackageName());
            this.sendAccessibilityEvent(accessibilityEvent);
        });
    }

    void sendEventForVirtualViewId(int n, int n2) {
        AccessibilityEvent accessibilityEvent = this.getEventForVirtualViewId(n, n2);
        this.sendAccessibilityEvent(accessibilityEvent);
    }

    void sendAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        if (this.m_view == null || accessibilityEvent == null) {
            return;
        }
        ViewGroup viewGroup = (ViewGroup)this.m_view.getParent();
        if (viewGroup == null) {
            Log.w((String)TAG, (String)"Could not send AccessibilityEvent because group was null. This should really not happen.");
            return;
        }
        viewGroup.requestSendAccessibilityEvent(this.m_view, accessibilityEvent);
    }

    void invalidateVirtualViewId(int n) {
        AccessibilityEvent accessibilityEvent = this.getEventForVirtualViewId(n, 2048);
        if (accessibilityEvent == null) {
            return;
        }
        accessibilityEvent.setContentChangeTypes(1);
        this.sendAccessibilityEvent(accessibilityEvent);
    }

    private void setHoveredVirtualViewId(int n) {
        if (this.m_hoveredVirtualViewId == n) {
            return;
        }
        int n2 = this.m_hoveredVirtualViewId;
        this.m_hoveredVirtualViewId = n;
        this.sendEventForVirtualViewId(n, 128);
        this.sendEventForVirtualViewId(n2, 256);
    }

    private AccessibilityEvent getEventForVirtualViewId(int n, int n2) {
        boolean bl;
        boolean bl2 = bl = this.m_manager != null && this.m_manager.isEnabled();
        if (this.m_view == null || !bl || n == 333) {
            Log.w((String)TAG, (String)"getEventForVirtualViewId for invalid view");
            return null;
        }
        if (this.m_layout == null || this.m_layout.getChildCount() == 0) {
            return null;
        }
        AccessibilityEvent accessibilityEvent = this.obtainAccessibilityEvent(n2);
        accessibilityEvent.setEnabled(true);
        accessibilityEvent.setClassName(this.getNodeForVirtualViewId(n).getClassName());
        accessibilityEvent.setContentDescription((CharSequence)QtNativeAccessibility.descriptionForAccessibleObject(n));
        if (accessibilityEvent.getText().isEmpty() && TextUtils.isEmpty((CharSequence)accessibilityEvent.getContentDescription())) {
            Log.w((String)TAG, (String)"AccessibilityEvent with empty description");
        }
        accessibilityEvent.setPackageName((CharSequence)this.m_view.getContext().getPackageName());
        accessibilityEvent.setSource(this.m_view, n);
        return accessibilityEvent;
    }

    private void dumpNodes(int n) {
        int[] nArray;
        Log.i((String)TAG, (String)("A11Y hierarchy: " + n + " parent: " + QtNativeAccessibility.parentId(n)));
        Log.i((String)TAG, (String)("    desc: " + QtNativeAccessibility.descriptionForAccessibleObject(n) + " rect: " + QtNativeAccessibility.screenRect(n)));
        Log.i((String)TAG, (String)(" NODE: " + this.getNodeForVirtualViewId(n)));
        for (int n2 : nArray = QtNativeAccessibility.childIdListForAccessibleObject(n)) {
            Log.i((String)TAG, (String)(n + " has child: " + n2));
            this.dumpNodes(n2);
        }
    }

    private AccessibilityNodeInfo getNodeForView() {
        if (this.m_view == null || this.m_layout == null) {
            return this.obtainAccessibilityNodeInfo();
        }
        AccessibilityNodeInfo accessibilityNodeInfo = this.obtainAccessibilityNodeInfo(this.m_view);
        AccessibilityNodeInfo accessibilityNodeInfo2 = this.obtainAccessibilityNodeInfo(this.m_view);
        this.m_view.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo2);
        this.m_view.getLocationOnScreen(this.m_globalOffset);
        int n = this.m_globalOffset[0];
        int n2 = this.m_globalOffset[1];
        Rect rect = new Rect();
        this.getBoundsInParent(accessibilityNodeInfo2, rect);
        this.setBoundsInParent(accessibilityNodeInfo, rect);
        Rect rect2 = new Rect();
        accessibilityNodeInfo2.getBoundsInScreen(rect2);
        rect2.offset(n, n2);
        accessibilityNodeInfo.setBoundsInScreen(rect2);
        ViewParent viewParent = this.m_view.getParent();
        if (viewParent instanceof View) {
            accessibilityNodeInfo.setParent((View)viewParent);
        }
        accessibilityNodeInfo.setVisibleToUser(accessibilityNodeInfo2.isVisibleToUser());
        accessibilityNodeInfo.setPackageName(accessibilityNodeInfo2.getPackageName());
        accessibilityNodeInfo.setClassName(accessibilityNodeInfo2.getClassName());
        if (this.m_layout.getChildCount() != 0) {
            int[] nArray;
            for (int n3 : nArray = QtNativeAccessibility.childIdListForAccessibleObject(-1)) {
                accessibilityNodeInfo.addChild(this.m_view, n3);
            }
        }
        if (this.m_oldOffsetX != n || this.m_oldOffsetY != n2) {
            this.m_oldOffsetX = n;
            this.m_oldOffsetY = n2;
            if (this.m_focusedVirtualViewId != 333) {
                this.m_nodeProvider.performAction(this.m_focusedVirtualViewId, 128, new Bundle());
                this.m_nodeProvider.performAction(this.m_focusedVirtualViewId, 64, new Bundle());
            }
        }
        return accessibilityNodeInfo;
    }

    private AccessibilityNodeInfo getNodeForVirtualViewId(int n) {
        int[] nArray;
        if (this.m_view == null || this.m_layout == null) {
            return this.obtainAccessibilityNodeInfo();
        }
        AccessibilityNodeInfo accessibilityNodeInfo = this.obtainAccessibilityNodeInfo();
        accessibilityNodeInfo.setPackageName((CharSequence)this.m_view.getContext().getPackageName());
        if (this.m_layout.getChildCount() == 0 || !QtNativeAccessibility.populateNode(n, accessibilityNodeInfo)) {
            return accessibilityNodeInfo;
        }
        accessibilityNodeInfo.setSource(this.m_view, n);
        if (TextUtils.isEmpty((CharSequence)accessibilityNodeInfo.getText()) && TextUtils.isEmpty((CharSequence)accessibilityNodeInfo.getContentDescription())) {
            Log.w((String)TAG, (String)("AccessibilityNodeInfo with empty contentDescription: " + n));
        }
        int n2 = QtNativeAccessibility.parentId(n);
        accessibilityNodeInfo.setParent(this.m_view, n2);
        Rect rect = QtNativeAccessibility.screenRect(n);
        int n3 = this.m_globalOffset[0];
        int n4 = this.m_globalOffset[1];
        rect.offset(n3, n4);
        accessibilityNodeInfo.setBoundsInScreen(rect);
        Rect rect2 = QtNativeAccessibility.screenRect(n2);
        rect.offset(-rect2.left, -rect2.top);
        this.setBoundsInParent(accessibilityNodeInfo, rect);
        if (this.m_focusedVirtualViewId == n) {
            accessibilityNodeInfo.setAccessibilityFocused(true);
            accessibilityNodeInfo.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_CLEAR_ACCESSIBILITY_FOCUS);
        } else {
            accessibilityNodeInfo.setAccessibilityFocused(false);
            accessibilityNodeInfo.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_ACCESSIBILITY_FOCUS);
        }
        for (int n5 : nArray = QtNativeAccessibility.childIdListForAccessibleObject(n)) {
            accessibilityNodeInfo.addChild(this.m_view, n5);
        }
        if (accessibilityNodeInfo.isScrollable()) {
            this.setCollectionInfo(accessibilityNodeInfo, nArray.length, 1, false);
        }
        return accessibilityNodeInfo;
    }

    protected boolean performActionForVirtualViewId(int n, int n2) {
        boolean bl = false;
        switch (n2) {
            case 16: {
                bl = QtNativeAccessibility.clickAction(n);
                if (!bl) break;
                this.sendEventForVirtualViewId(n, 1);
                break;
            }
            case 64: {
                if (this.m_focusedVirtualViewId == n || (bl = QtNativeAccessibility.focusAction(n))) break;
                this.notifyObjectFocus(n);
                bl = true;
                break;
            }
            case 4096: {
                bl = QtNativeAccessibility.scrollForward(n);
                break;
            }
            case 8192: {
                bl = QtNativeAccessibility.scrollBackward(n);
            }
        }
        return bl;
    }

    private AccessibilityEvent obtainAccessibilityEvent(int n) {
        if (Build.VERSION.SDK_INT >= 30) {
            return new AccessibilityEvent(n);
        }
        return AccessibilityEvent.obtain((int)n);
    }

    private AccessibilityNodeInfo obtainAccessibilityNodeInfo() {
        if (Build.VERSION.SDK_INT >= 30) {
            return new AccessibilityNodeInfo();
        }
        return AccessibilityNodeInfo.obtain();
    }

    private AccessibilityNodeInfo obtainAccessibilityNodeInfo(View view) {
        if (Build.VERSION.SDK_INT >= 30) {
            return new AccessibilityNodeInfo(view);
        }
        return AccessibilityNodeInfo.obtain((View)view);
    }

    private void getBoundsInParent(AccessibilityNodeInfo accessibilityNodeInfo, Rect rect) {
        accessibilityNodeInfo.getBoundsInParent(rect);
    }

    private void setBoundsInParent(AccessibilityNodeInfo accessibilityNodeInfo, Rect rect) {
        accessibilityNodeInfo.setBoundsInParent(rect);
    }

    private void setCollectionInfo(AccessibilityNodeInfo accessibilityNodeInfo, int n, int n2, boolean bl) {
        if (Build.VERSION.SDK_INT >= 30) {
            accessibilityNodeInfo.setCollectionInfo(new AccessibilityNodeInfo.CollectionInfo(n, n2, bl));
        } else {
            accessibilityNodeInfo.setCollectionInfo(AccessibilityNodeInfo.CollectionInfo.obtain((int)n, (int)n2, (boolean)bl));
        }
    }

    private class AccessibilityManagerListener
    implements AccessibilityManager.AccessibilityStateChangeListener {
        private AccessibilityManagerListener() {
        }

        public void onAccessibilityStateChanged(boolean bl) {
            if (QtAccessibilityDelegate.this.m_layout == null) {
                return;
            }
            String string2 = Os.getenv((String)"QT_ANDROID_DISABLE_ACCESSIBILITY");
            if (string2 != null && (string2.equalsIgnoreCase("true") || string2.equals("1"))) {
                return;
            }
            if (!bl) {
                if (QtAccessibilityDelegate.this.m_view != null) {
                    QtAccessibilityDelegate.this.m_layout.removeView(QtAccessibilityDelegate.this.m_view);
                    QtAccessibilityDelegate.this.m_view = null;
                }
                QtNativeAccessibility.setActive(bl);
                return;
            }
            try {
                View view = QtAccessibilityDelegate.this.m_view;
                if (view == null) {
                    view = new View(QtAccessibilityDelegate.this.m_layout.getContext());
                    view.setId(-1);
                }
                view.setAccessibilityDelegate((View.AccessibilityDelegate)QtAccessibilityDelegate.this);
                if (QtAccessibilityDelegate.this.m_view == null) {
                    QtAccessibilityDelegate.this.m_layout.addView(view, QtAccessibilityDelegate.this.m_layout.getChildCount(), new ViewGroup.LayoutParams(-1, -1));
                }
                QtAccessibilityDelegate.this.m_view = view;
                QtAccessibilityDelegate.this.m_view.setOnHoverListener((View.OnHoverListener)new HoverEventListener());
            }
            catch (Exception exception) {
                Log.w((String)"Qt A11y", (String)("Unknown exception: " + exception));
            }
            QtNativeAccessibility.setActive(bl);
        }
    }

    private class HoverEventListener
    implements View.OnHoverListener {
        private HoverEventListener() {
        }

        public boolean onHover(View view, MotionEvent motionEvent) {
            return QtAccessibilityDelegate.this.dispatchHoverEvent(motionEvent);
        }
    }
}

