/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Size;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowInsetsController;
import android.view.WindowManager;
import android.view.WindowMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.qtproject.qt.android.UsedFromNativeCode;

class QtDisplayManager {
    private static String QtTAG = "QtDisplayManager";
    private boolean m_isFullScreen = false;
    private boolean m_expandedToCutout = false;
    private static int m_previousRotation = -1;
    private final DisplayManager.DisplayListener m_displayListener;
    private final Activity m_activity;

    static native void handleLayoutSizeChanged(int var0, int var1);

    static native void handleOrientationChanged(int var0, int var1);

    static native void handleRefreshRateChanged(float var0);

    static native void handleUiDarkModeChanged(int var0);

    static native void handleScreenAdded(int var0);

    static native void handleScreenChanged(int var0);

    static native void handleScreenRemoved(int var0);

    static native void handleScreenDensityChanged(double var0);

    QtDisplayManager(Activity activity) {
        this.m_activity = activity;
        this.m_displayListener = new DisplayManager.DisplayListener(){

            public void onDisplayAdded(int n) {
                QtDisplayManager.handleScreenAdded(n);
            }

            public void onDisplayChanged(int n) {
                QtDisplayManager.updateRefreshRate((Context)QtDisplayManager.this.m_activity);
                QtDisplayManager.updateScreenDensity(QtDisplayManager.this.m_activity);
                QtDisplayManager.handleScreenChanged(n);
            }

            public void onDisplayRemoved(int n) {
                QtDisplayManager.handleScreenRemoved(n);
            }
        };
    }

    static void updateRefreshRate(Context context) {
        Display display = QtDisplayManager.getDisplay(context);
        float f = display != null ? display.getRefreshRate() : 60.0f;
        QtDisplayManager.handleRefreshRateChanged(f);
    }

    static void handleOrientationChange(Activity activity) {
        int n;
        Display display = QtDisplayManager.getDisplay((Context)activity);
        int n2 = n = display != null ? display.getRotation() : 0;
        if (m_previousRotation == n) {
            return;
        }
        int n3 = QtDisplayManager.getNativeOrientation(activity, n);
        QtDisplayManager.handleOrientationChanged(n, n3);
        m_previousRotation = n;
    }

    static void updateScreenDensity(Activity activity) {
        Resources resources = activity == null ? Resources.getSystem() : activity.getResources();
        double d = resources.getDisplayMetrics().density;
        QtDisplayManager.handleScreenDensityChanged(d);
    }

    private static int getNativeOrientation(Activity activity, int n) {
        boolean bl;
        int n2 = activity.getResources().getConfiguration().orientation;
        boolean bl2 = n == 1 || n == 3;
        boolean bl3 = bl = n2 == 2;
        if (bl && !bl2 || !bl && bl2) {
            return 2;
        }
        return 1;
    }

    void initDisplayProperties() {
        QtDisplayManager.handleOrientationChange(this.m_activity);
        QtDisplayManager.updateRefreshRate((Context)this.m_activity);
        QtDisplayManager.updateScreenDensity(this.m_activity);
    }

    void registerDisplayListener() {
        DisplayManager displayManager = (DisplayManager)this.m_activity.getSystemService("display");
        displayManager.registerDisplayListener(this.m_displayListener, null);
    }

    void unregisterDisplayListener() {
        DisplayManager displayManager = (DisplayManager)this.m_activity.getSystemService("display");
        displayManager.unregisterDisplayListener(this.m_displayListener);
    }

    void setSystemUiVisibilityPreAndroidR(View view) {
        int n;
        if (this.m_isFullScreen || this.m_expandedToCutout) {
            n = 1536;
            if (this.m_isFullScreen) {
                n |= 0x1106;
            }
        } else {
            n = 0;
        }
        view.setSystemUiVisibility(n);
    }

    void setSystemUiVisibility(boolean bl, boolean bl2) {
        int n;
        WindowManager.LayoutParams layoutParams;
        int n2;
        if (this.m_isFullScreen == bl && this.m_expandedToCutout == bl2) {
            return;
        }
        this.m_isFullScreen = bl;
        this.m_expandedToCutout = bl2;
        Window window = this.m_activity.getWindow();
        View view = window.getDecorView();
        if (Build.VERSION.SDK_INT >= 30) {
            if (this.m_isFullScreen || this.m_expandedToCutout) {
                window.setDecorFitsSystemWindows(false);
                n2 = 1;
            } else {
                window.setDecorFitsSystemWindows(true);
                n2 = 0;
            }
            layoutParams = window.getAttributes();
            layoutParams.layoutInDisplayCutoutMode = n2;
            window.setAttributes(layoutParams);
            WindowInsetsController windowInsetsController = window.getInsetsController();
            if (windowInsetsController != null) {
                if (this.m_isFullScreen) {
                    windowInsetsController.hide(WindowInsets.Type.systemBars());
                    n = 2;
                } else {
                    windowInsetsController.show(WindowInsets.Type.systemBars());
                    n = 1;
                }
                windowInsetsController.setSystemBarsBehavior(n);
            }
        } else {
            this.setSystemUiVisibilityPreAndroidR(view);
        }
        if (!bl && !QtDisplayManager.edgeToEdgeEnabled(this.m_activity)) {
            window.clearFlags(0xC000000);
            window.addFlags(Integer.MIN_VALUE);
            if (this.m_expandedToCutout) {
                if (Build.VERSION.SDK_INT >= 29) {
                    window.setStatusBarColor(0);
                    window.setNavigationBarColor(0);
                } else {
                    n2 = window.getStatusBarColor();
                    int n3 = n2 & 0xFFFFFF;
                    window.setStatusBarColor(n3);
                    int n4 = window.getNavigationBarColor();
                    n = n4 & Integer.MAX_VALUE;
                    window.setNavigationBarColor(n);
                }
            } else {
                Resources.Theme theme = this.m_activity.getTheme();
                layoutParams = new TypedValue();
                theme.resolveAttribute(16843857, (TypedValue)layoutParams, true);
                int n5 = layoutParams.data;
                window.setStatusBarColor(n5);
                theme.resolveAttribute(16843858, (TypedValue)layoutParams, true);
                n = layoutParams.data;
                window.setNavigationBarColor(n);
            }
        }
        view.post(() -> view.requestApplyInsets());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean edgeToEdgeEnabled(Activity activity) {
        if (Build.VERSION.SDK_INT > 35) {
            return true;
        }
        if (Build.VERSION.SDK_INT < 35) {
            return false;
        }
        int[] nArray = new int[]{16844442};
        TypedArray typedArray = activity.getTheme().obtainStyledAttributes(nArray);
        try {
            boolean bl = !typedArray.getBoolean(0, false);
            return bl;
        }
        finally {
            typedArray.recycle();
        }
    }

    boolean isFullScreen() {
        return this.m_isFullScreen;
    }

    boolean expandedToCutout() {
        return this.m_expandedToCutout;
    }

    boolean decorFitsSystemWindows() {
        return !this.isFullScreen() && !this.expandedToCutout();
    }

    void reinstateFullScreen() {
        if (this.m_isFullScreen) {
            this.m_isFullScreen = false;
            this.setSystemUiVisibility(true, this.m_expandedToCutout);
        }
    }

    private static void setSystemUiVisibility(View view, int n) {
        view.setSystemUiVisibility(n);
    }

    @UsedFromNativeCode
    static void setStatusBarColorHint(Activity activity, boolean bl) {
        Window window = activity.getWindow();
        if (Build.VERSION.SDK_INT >= 30) {
            WindowInsetsController windowInsetsController = window.getInsetsController();
            if (windowInsetsController != null) {
                int n = 8;
                int n2 = bl ? n : 0;
                windowInsetsController.setSystemBarsAppearance(n2, n);
            }
        } else {
            int n = window.getDecorView().getSystemUiVisibility();
            int n3 = 8192;
            int n4 = bl ? n | n3 : n & ~n3;
            QtDisplayManager.setSystemUiVisibility(window.getDecorView(), n4);
        }
    }

    @UsedFromNativeCode
    static void setNavigationBarColorHint(Activity activity, boolean bl) {
        Window window = activity.getWindow();
        if (Build.VERSION.SDK_INT >= 30) {
            WindowInsetsController windowInsetsController = window.getInsetsController();
            if (windowInsetsController != null) {
                int n = 16;
                int n2 = bl ? n : 0;
                windowInsetsController.setSystemBarsAppearance(n2, n);
            }
        } else {
            int n = window.getDecorView().getSystemUiVisibility();
            int n3 = 16;
            int n4 = bl ? n | n3 : n & ~n3;
            QtDisplayManager.setSystemUiVisibility(window.getDecorView(), n4);
        }
    }

    static int resolveColorAttribute(Activity activity, int n) {
        Resources.Theme theme = activity.getTheme();
        Resources resources = activity.getResources();
        TypedValue typedValue = new TypedValue();
        if (theme.resolveAttribute(n, typedValue, true)) {
            if (typedValue.resourceId != 0) {
                return resources.getColor(typedValue.resourceId, theme);
            }
            if (typedValue.type >= 28 && typedValue.type <= 31) {
                return typedValue.data;
            }
        }
        return -1;
    }

    static int getThemeDefaultStatusBarColor(Activity activity) {
        if (Build.VERSION.SDK_INT >= 35) {
            return -1;
        }
        return QtDisplayManager.resolveColorAttribute(activity, 16843857);
    }

    static int getThemeDefaultNavigationBarColor(Activity activity) {
        if (Build.VERSION.SDK_INT >= 35) {
            return -1;
        }
        return QtDisplayManager.resolveColorAttribute(activity, 16843858);
    }

    static void enableSystemBarsBackgroundDrawing(Window window) {
        window.addFlags(Integer.MIN_VALUE);
        window.clearFlags(0xC000000);
    }

    static void setStatusBarColor(Window window, int n) {
        if (Build.VERSION.SDK_INT >= 35) {
            return;
        }
        window.setStatusBarColor(n);
    }

    static void setNavigationBarColor(Window window, int n) {
        if (Build.VERSION.SDK_INT >= 35) {
            return;
        }
        window.setNavigationBarColor(n);
    }

    static Display getDisplay(Context context) {
        Activity activity = (Activity)context;
        if (activity != null) {
            return Build.VERSION.SDK_INT < 30 ? activity.getWindowManager().getDefaultDisplay() : activity.getDisplay();
        }
        DisplayManager displayManager = (DisplayManager)context.getSystemService(DisplayManager.class);
        return displayManager.getDisplay(0);
    }

    @UsedFromNativeCode
    static Display getDisplay(Context context, int n) {
        DisplayManager displayManager = (DisplayManager)context.getSystemService("display");
        if (displayManager != null) {
            return displayManager.getDisplay(n);
        }
        return null;
    }

    @UsedFromNativeCode
    static List<Display> getAvailableDisplays(Context context) {
        DisplayManager displayManager = (DisplayManager)context.getSystemService("display");
        if (displayManager != null) {
            Display[] displayArray = displayManager.getDisplays();
            return Arrays.asList(displayArray);
        }
        return new ArrayList<Display>();
    }

    @UsedFromNativeCode
    static Size getDisplaySize(Context context, Display display) {
        if (display == null || context == null) {
            return new Size(0, 0);
        }
        if (Build.VERSION.SDK_INT < 30) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            display.getRealMetrics(displayMetrics);
            return new Size(displayMetrics.widthPixels, displayMetrics.heightPixels);
        }
        try {
            Context context2 = context.createDisplayContext(display);
            WindowManager windowManager = (WindowManager)context2.getSystemService(WindowManager.class);
            if (windowManager != null) {
                WindowMetrics windowMetrics = windowManager.getCurrentWindowMetrics();
                Rect rect = windowMetrics.getBounds();
                return new Size(rect.width(), rect.height());
            }
            Log.e((String)QtTAG, (String)("getDisplaySize(): WindowManager null, display ID" + display.getDisplayId()));
        }
        catch (Exception exception) {
            Log.e((String)QtTAG, (String)("Failed to retrieve display metrics with " + exception));
        }
        return new Size(0, 0);
    }

    @UsedFromNativeCode
    static float getXDpi(DisplayMetrics displayMetrics) {
        if (displayMetrics.xdpi < 120.0f) {
            return 120.0f;
        }
        return displayMetrics.xdpi;
    }

    @UsedFromNativeCode
    static float getYDpi(DisplayMetrics displayMetrics) {
        if (displayMetrics.ydpi < 120.0f) {
            return 120.0f;
        }
        return displayMetrics.ydpi;
    }
}

