/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.PopupWindow;
import org.qtproject.qt.android.CursorView;
import org.qtproject.qt.android.QtInputDelegate;

class CursorHandle
implements ViewTreeObserver.OnPreDrawListener {
    private static final String QtTag = "QtCursorHandle";
    static final int IdCursorHandle = 1;
    static final int IdLeftHandle = 2;
    static final int IdRightHandle = 3;
    private final View m_layout;
    private CursorView m_cursorView = null;
    private PopupWindow m_popup = null;
    private final int m_id;
    private final int m_attr;
    private final Activity m_activity;
    private int m_posX = 0;
    private int m_posY = 0;
    private int m_lastX;
    private int m_lastY;
    int tolerance;
    private final boolean m_rtl;
    int m_yShift;

    CursorHandle(Activity activity, View view, int n, int n2, boolean bl) {
        this.m_activity = activity;
        this.m_id = n;
        this.m_attr = n2;
        this.m_layout = view;
        DisplayMetrics displayMetrics = activity.getResources().getDisplayMetrics();
        this.m_yShift = (int)TypedValue.applyDimension((int)5, (float)1.0f, (DisplayMetrics)displayMetrics);
        this.tolerance = Math.min(1, (int)((float)this.m_yShift / 2.0f));
        this.m_lastX = this.m_lastY = -1 - this.tolerance;
        this.m_rtl = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOverlay() {
        Drawable drawable2;
        if (this.m_popup != null) {
            return;
        }
        Context context = this.m_layout.getContext();
        int[] nArray = new int[]{this.m_attr};
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(nArray);
        try {
            drawable2 = typedArray.getDrawable(0);
        }
        finally {
            typedArray.recycle();
        }
        this.m_cursorView = new CursorView(context, this);
        this.m_cursorView.setImageDrawable(drawable2);
        this.m_popup = new PopupWindow(context, null, 16843464);
        this.m_popup.setSplitTouchEnabled(true);
        this.m_popup.setClippingEnabled(false);
        this.m_popup.setContentView((View)this.m_cursorView);
        if (drawable2 != null) {
            this.m_popup.setWidth(drawable2.getIntrinsicWidth());
            this.m_popup.setHeight(drawable2.getIntrinsicHeight());
        } else {
            Log.w((String)QtTag, (String)("initOverlay(): cannot get width/height for popup from null drawable for attribute " + this.m_attr));
        }
        this.m_layout.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
    }

    void setPosition(int n, int n2) {
        this.initOverlay();
        int[] nArray = new int[2];
        View view = (View)this.m_layout.getParent();
        if (view == null) {
            view = this.m_layout;
        }
        view.getLocationOnScreen(nArray);
        int[] nArray2 = new int[2];
        int[] nArray3 = new int[2];
        this.m_activity.getWindow().getDecorView().getLocationOnScreen(nArray2);
        this.m_activity.getWindow().getDecorView().getLocationInWindow(nArray3);
        int n3 = n + nArray[0] - nArray2[0];
        int n4 = n2 + nArray[1] + this.m_yShift + (nArray3[1] - nArray2[1]);
        n3 = this.m_id == 1 ? (n3 -= this.m_popup.getWidth() / 2) : (this.m_id == 2 && !this.m_rtl || this.m_id == 3 && this.m_rtl ? (n3 -= this.m_popup.getWidth() * 3 / 4) : (n3 -= this.m_popup.getWidth() / 4));
        if (this.m_popup.isShowing()) {
            this.m_popup.update(n3, n4, -1, -1);
            this.m_cursorView.adjusted(n - this.m_posX, n2 - this.m_posY);
        } else {
            this.m_popup.showAtLocation(view, 0, n3, n4);
        }
        this.m_posX = n;
        this.m_posY = n2;
    }

    int bottom() {
        this.initOverlay();
        int[] nArray = new int[2];
        this.m_cursorView.getLocationOnScreen(nArray);
        return nArray[1] + this.m_cursorView.getHeight();
    }

    void hide() {
        if (this.m_popup != null) {
            this.m_popup.dismiss();
        }
    }

    int width() {
        if (this.m_cursorView == null) {
            return 0;
        }
        return this.m_cursorView.getDrawable().getIntrinsicWidth();
    }

    void updatePosition(int n, int n2) {
        if (Math.abs(this.m_lastX - n) > this.tolerance || Math.abs(this.m_lastY - (n2 -= this.m_yShift)) > this.tolerance) {
            QtInputDelegate.handleLocationChanged(this.m_id, n + this.m_posX, n2 + this.m_posY);
            this.m_lastX = n;
            this.m_lastY = n2;
        }
    }

    public boolean onPreDraw() {
        if (this.m_popup != null && this.m_popup.isShowing()) {
            this.setPosition(this.m_posX, this.m_posY);
        }
        return true;
    }
}

