# Some Qt modules also load plugin target in extra config, so check whether the target already exists
if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::QTextToSpeechPluginSapi)
    add_library(${QT_VARIANT_PREFIX}Qt5::QTextToSpeechPluginSapi MODULE IMPORTED)

set(_Qt5QTextToSpeechPluginSapi_MODULE_DEPENDENCIES "Gui;Core")

foreach(_module_dep ${_Qt5QTextToSpeechPluginSapi_MODULE_DEPENDENCIES})
    if(NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
        find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
             ${_Qt5TextToSpeech_FIND_VERSION_EXACT}
            ${_Qt5TextToSpeech_DEPENDENCIES_FIND_QUIET}
            ${_Qt5TextToSpeech_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
        )
    endif()
endforeach()

    _populate_TextToSpeech_plugin_properties_static(${QT_VARIANT_PREFIX}Qt5::TextToSpeech ${QT_VARIANT_PREFIX}Qt5::QTextToSpeechPluginSapi QTextToSpeechPluginSapi RELEASE "texttospeech/libqtexttospeech_sapi.a")


list(APPEND ${QT_VARIANT_PREFIX}Qt5TextToSpeech_PLUGINS ${QT_VARIANT_PREFIX}Qt5::QTextToSpeechPluginSapi)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::TextToSpeech APPEND PROPERTY QT_ALL_PLUGINS_texttospeech ${QT_VARIANT_PREFIX}Qt5::QTextToSpeechPluginSapi)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QTextToSpeechPluginSapi PROPERTY QT_PLUGIN_TYPE "texttospeech")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QTextToSpeechPluginSapi PROPERTY QT_PLUGIN_EXTENDS "")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QTextToSpeechPluginSapi PROPERTY QT_PLUGIN_CLASS_NAME "QTextToSpeechPluginSapi")
endif()
