/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Toast;
import org.qtproject.qt.android.QtActivityDelegate;
import org.qtproject.qt.android.QtActivityLoader;
import org.qtproject.qt.android.QtLoader;
import org.qtproject.qt.android.QtNative;
import org.qtproject.qt.android.QtWindow;
import org.qtproject.qt.android.UsedFromNativeCode;

public class QtActivityBase
extends Activity {
    public static final String EXTRA_SOURCE_INFO = "org.qtproject.qt.android.sourceInfo";
    private String m_applicationParams = "";
    private boolean m_isCustomThemeSet = false;
    private boolean m_retainNonConfigurationInstance = false;
    private Configuration m_prevConfig;
    private final QtActivityDelegate m_delegate = new QtActivityDelegate(this);
    private boolean m_onCreateSucceeded = false;

    private void addReferrer(Intent intent) {
        Bundle bundle = intent.getExtras();
        if (bundle != null && bundle.getString(EXTRA_SOURCE_INFO) != null) {
            return;
        }
        if (bundle == null) {
            Uri uri = this.getReferrer();
            if (uri != null) {
                String string2 = uri.toString().replaceFirst("android-app://", "");
                intent.putExtra(EXTRA_SOURCE_INFO, string2);
            }
        } else {
            String string3 = bundle.getString("com.android.browser.application_id");
            if (string3 != null) {
                intent.putExtra(EXTRA_SOURCE_INFO, string3);
            }
        }
    }

    public void appendApplicationParameters(String string2) {
        if (string2 == null || string2.isEmpty()) {
            return;
        }
        if (!this.m_applicationParams.isEmpty()) {
            this.m_applicationParams = this.m_applicationParams + " ";
        }
        this.m_applicationParams = this.m_applicationParams + string2;
    }

    public void setTheme(int n) {
        super.setTheme(n);
        this.m_isCustomThemeSet = true;
    }

    private void restartApplication() {
        Intent intent = Intent.makeRestartActivityTask((ComponentName)this.getComponentName());
        this.startActivity(intent);
        QtNative.quitApp();
        Runtime.getRuntime().exit(0);
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.requestWindowFeature(8);
        if (!this.m_isCustomThemeSet) {
            this.setTheme(Build.VERSION.SDK_INT >= 29 ? 16974563 : 16973934);
        }
        if (QtNative.getStateDetails().isStarted) {
            this.restartApplication();
        }
        QtNative.registerAppStateListener(this.m_delegate);
        this.addReferrer(this.getIntent());
        try {
            QtActivityLoader qtActivityLoader = QtActivityLoader.getActivityLoader(this);
            qtActivityLoader.appendApplicationParameters(this.m_applicationParams);
            QtLoader.LoadingResult loadingResult = qtActivityLoader.loadQtLibraries();
            if (loadingResult == QtLoader.LoadingResult.Succeeded) {
                this.m_delegate.startNativeApplication(qtActivityLoader.getApplicationParameters(), qtActivityLoader.getMainLibraryPath());
            } else if (loadingResult == QtLoader.LoadingResult.Failed) {
                this.showFatalFinishingToast();
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            this.showFatalFinishingToast();
            return;
        }
        this.m_prevConfig = new Configuration(this.getResources().getConfiguration());
        this.m_onCreateSucceeded = true;
    }

    private void showFatalFinishingToast() {
        Resources resources = this.getResources();
        String string2 = this.getPackageName();
        int n = resources.getIdentifier("fatal_error_msg", "string", string2);
        String string3 = resources.getString(n);
        Toast.makeText((Context)this, (CharSequence)string3, (int)1).show();
        this.finish();
    }

    protected void onPause() {
        super.onPause();
        if (Build.VERSION.SDK_INT < 24 || !this.isInMultiWindowMode()) {
            QtNative.setApplicationState(2);
        }
        this.m_delegate.displayManager().unregisterDisplayListener();
    }

    protected void onResume() {
        super.onResume();
        QtNative.setApplicationState(4);
        if (QtNative.getStateDetails().isStarted) {
            this.m_delegate.displayManager().registerDisplayListener();
            QtWindow.updateWindows();
            this.m_delegate.displayManager().reinstateFullScreen();
        }
    }

    protected void onStop() {
        super.onStop();
        QtNative.setApplicationState(0);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (!this.m_onCreateSucceeded) {
            System.exit(-1);
        }
        if (!this.m_retainNonConfigurationInstance) {
            QtNative.unregisterAppStateListener(this.m_delegate);
            QtNative.terminateQt();
            QtNative.setActivity(null);
            QtNative.getQtThread().exit();
            System.exit(0);
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.m_delegate.handleUiModeChange(configuration.uiMode & 0x30);
        int n = configuration.diff(this.m_prevConfig);
        if ((n & 4) != 0) {
            QtNative.updateLocale();
        }
        this.m_prevConfig = new Configuration(configuration);
    }

    public boolean onContextItemSelected(MenuItem menuItem) {
        this.m_delegate.setContextMenuVisible(false);
        return QtNative.onContextItemSelected(menuItem.getItemId(), menuItem.isChecked());
    }

    public void onContextMenuClosed(Menu menu) {
        if (!this.m_delegate.isContextMenuVisible()) {
            return;
        }
        this.m_delegate.setContextMenuVisible(false);
        QtNative.onContextMenuClosed(menu);
    }

    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
        contextMenu.clearHeader();
        QtNative.onCreateContextMenu(contextMenu);
        this.m_delegate.setContextMenuVisible(true);
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        boolean bl = this.m_delegate.getInputDelegate().handleDispatchKeyEvent(keyEvent);
        if (QtNative.getStateDetails().isStarted && bl) {
            return true;
        }
        return super.dispatchKeyEvent(keyEvent);
    }

    public boolean dispatchGenericMotionEvent(MotionEvent motionEvent) {
        boolean bl = this.m_delegate.getInputDelegate().handleDispatchGenericMotionEvent(motionEvent);
        if (QtNative.getStateDetails().isStarted && bl) {
            return true;
        }
        return super.dispatchGenericMotionEvent(motionEvent);
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        QtNative.ApplicationStateDetails applicationStateDetails = QtNative.getStateDetails();
        if (!applicationStateDetails.isStarted || !applicationStateDetails.nativePluginIntegrationReady) {
            return false;
        }
        return this.m_delegate.getInputDelegate().onKeyDown(n, keyEvent);
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        QtNative.ApplicationStateDetails applicationStateDetails = QtNative.getStateDetails();
        if (!applicationStateDetails.isStarted || !applicationStateDetails.nativePluginIntegrationReady) {
            return false;
        }
        return this.m_delegate.getInputDelegate().onKeyUp(n, keyEvent);
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        menu.clear();
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        boolean bl = QtNative.onPrepareOptionsMenu(menu);
        this.m_delegate.setActionBarVisibility(bl && menu.size() > 0);
        return bl;
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        return QtNative.onOptionsItemSelected(menuItem.getItemId(), menuItem.isChecked());
    }

    public void onOptionsMenuClosed(Menu menu) {
        QtNative.onOptionsMenuClosed(menu);
    }

    protected void onRestoreInstanceState(Bundle bundle) {
        super.onRestoreInstanceState(bundle);
        if (this.getLastNonConfigurationInstance() == null) {
            return;
        }
        QtNative.setStarted(bundle.getBoolean("Started"));
        boolean bl = bundle.getBoolean("isFullScreen");
        boolean bl2 = bundle.getBoolean("expandedToCutout");
        this.m_delegate.displayManager().setSystemUiVisibility(bl, bl2);
    }

    public Object onRetainNonConfigurationInstance() {
        super.onRetainNonConfigurationInstance();
        this.m_retainNonConfigurationInstance = true;
        return true;
    }

    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("isFullScreen", this.m_delegate.displayManager().isFullScreen());
        bundle.putBoolean("expandedToCutout", this.m_delegate.displayManager().expandedToCutout());
        bundle.putBoolean("Started", QtNative.getStateDetails().isStarted);
    }

    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (bl) {
            this.m_delegate.displayManager().reinstateFullScreen();
        }
    }

    protected void onNewIntent(Intent intent) {
        this.addReferrer(intent);
        QtNative.onNewIntent(intent);
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        QtNative.onActivityResult(n, n2, intent);
    }

    public void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
        QtNative.sendRequestPermissionsResult(n, nArray);
    }

    @UsedFromNativeCode
    public void hideSplashScreen(int n) {
        this.m_delegate.hideSplashScreen(n);
    }
}

