/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.content.Context;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.security.InvalidParameterException;
import org.qtproject.qt.android.QtNative;
import org.qtproject.qt.android.QtQmlStatus;
import org.qtproject.qt.android.QtQmlStatusChangeListener;
import org.qtproject.qt.android.QtQuickViewContent;
import org.qtproject.qt.android.QtSignalListener;
import org.qtproject.qt.android.QtView;

public class QtQuickView
extends QtView {
    private static final String TAG = "QtQuickView";
    private String m_qmlUri;
    private String[] m_qmlImportPaths = null;
    private QtQmlStatusChangeListener m_statusChangeListener = null;
    private QtQmlStatus m_lastStatus = QtQmlStatus.NULL;
    private boolean m_hasQueuedStatus = false;
    private WeakReference<QtQuickViewContent> m_loadedComponent;

    native void createQuickView(String var1, int var2, int var3, long var4, long var6, String[] var8);

    native void setRootObjectProperty(long var1, String var3, Object var4);

    native Object getRootObjectProperty(long var1, String var3);

    native int addRootObjectSignalListener(long var1, String var3, Class<?>[] var4, Object var5);

    native boolean removeRootObjectSignalListener(long var1, int var3);

    public QtQuickView(Context context, String string, String string2) throws InvalidParameterException {
        this(context, string, string2, null);
    }

    public QtQuickView(Context context, String string, String string2, String[] stringArray) throws InvalidParameterException {
        super(context, string2);
        if (string == null || string.isEmpty()) {
            throw new InvalidParameterException("QtQuickView: argument 'qmlUri' may not be empty or null");
        }
        this.m_qmlUri = string;
        this.m_qmlImportPaths = stringArray;
    }

    public QtQuickView(Context context) {
        super(context);
    }

    public <T extends QtQuickViewContent> void loadContent(T t, String[] stringArray) throws InvalidParameterException {
        String string = t.getLibraryName();
        String string2 = t.getFilePath();
        if (string == null || string.isEmpty()) {
            throw new InvalidParameterException("QtQuickViewContent: return value of getLibraryName() may not be empty or null");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new InvalidParameterException("QtQuickViewContent: return value of getFilePath() may not be empty or null");
        }
        this.m_qmlUri = string2;
        this.m_qmlImportPaths = stringArray;
        if (this.m_loadedComponent != null) {
            this.m_loadedComponent.clear();
        }
        this.m_loadedComponent = new WeakReference<T>(t);
        t.detachView();
        t.attachView(this);
        if (this.getWindowReference() == 0L) {
            this.loadQtLibraries(string);
        } else {
            this.createQuickView(this.m_qmlUri, this.getWidth(), this.getHeight(), 0L, this.getWindowReference(), this.m_qmlImportPaths);
        }
    }

    public <T extends QtQuickViewContent> void loadContent(T t) throws InvalidParameterException {
        this.loadContent(t, null);
    }

    protected void createWindow(long l) {
        this.createQuickView(this.m_qmlUri, this.getWidth(), this.getHeight(), l, this.getWindowReference(), this.m_qmlImportPaths);
    }

    public void setProperty(String string, Object object) {
        this.setRootObjectProperty(this.getWindowReference(), string, object);
    }

    public <T> T getProperty(String string) {
        return (T)this.getRootObjectProperty(this.getWindowReference(), string);
    }

    public <T> int connectSignalListener(String string, Class<T> clazz, QtSignalListener<T> qtSignalListener) {
        return this.connectSignalListener(string, new Class[]{clazz}, qtSignalListener);
    }

    public int connectSignalListener(String string, Class<?>[] classArray, Object object) {
        int n = this.addRootObjectSignalListener(this.getWindowReference(), string, classArray, object);
        if (n < 0) {
            Log.w((String)TAG, (String)("The signal " + string + " does not exist in the root object or the arguments do not match with the listener."));
        }
        return n;
    }

    public boolean disconnectSignalListener(int n) {
        return this.removeRootObjectSignalListener(this.getWindowReference(), n);
    }

    public QtQmlStatus getStatus() {
        return this.m_lastStatus;
    }

    public void setStatusChangeListener(QtQmlStatusChangeListener qtQmlStatusChangeListener) {
        this.m_statusChangeListener = qtQmlStatusChangeListener;
        if (this.m_hasQueuedStatus) {
            this.sendStatusChanged(this.m_lastStatus);
            this.m_hasQueuedStatus = false;
        }
    }

    private void handleStatusChange(int n) {
        try {
            this.m_lastStatus = QtQmlStatus.fromInt(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.m_lastStatus = QtQmlStatus.NULL;
            illegalArgumentException.printStackTrace();
        }
        if (this.m_statusChangeListener == null) {
            this.m_hasQueuedStatus = true;
        } else {
            this.sendStatusChanged(this.m_lastStatus);
        }
    }

    private void sendStatusChanged(QtQmlStatus qtQmlStatus) {
        QtNative.runAction(() -> {
            if (this.m_statusChangeListener != null) {
                QtQuickViewContent qtQuickViewContent;
                QtQuickViewContent qtQuickViewContent2 = qtQuickViewContent = this.m_loadedComponent != null ? (QtQuickViewContent)this.m_loadedComponent.get() : null;
                if (qtQuickViewContent == null) {
                    this.m_statusChangeListener.onStatusChanged(qtQmlStatus);
                } else {
                    this.m_statusChangeListener.onStatusChanged(qtQmlStatus, qtQuickViewContent);
                }
            }
        });
    }
}

