/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.networkinformation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.os.Build;

class QtAndroidNetworkInformation {
    private static final String LOG_TAG = "QtAndroidNetworkInformation";
    private static QtNetworkInformationCallback m_callback = null;
    private static final Object m_lock = new Object();

    private static native void networkConnectivityChanged(int var0);

    private static native void genericInfoChanged(boolean var0, boolean var1);

    private static native void transportMediumChanged(int var0);

    private QtAndroidNetworkInformation() {
    }

    static AndroidConnectivity state() {
        if (m_callback != null && QtAndroidNetworkInformation.m_callback.previousState != null) {
            return QtAndroidNetworkInformation.m_callback.previousState;
        }
        return AndroidConnectivity.Unknown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"MissingPermission"})
    static void registerReceiver(Context context) {
        Object object = m_lock;
        synchronized (object) {
            if (m_callback == null) {
                ConnectivityManager connectivityManager = QtAndroidNetworkInformation.getConnectivityManager(context);
                m_callback = new QtNetworkInformationCallback();
                NetworkRequest.Builder builder = new NetworkRequest.Builder();
                if (Build.VERSION.SDK_INT >= 30) {
                    builder = builder.clearCapabilities();
                }
                builder = builder.addCapability(12);
                if (Build.VERSION.SDK_INT >= 28) {
                    builder = builder.addCapability(21);
                    builder = builder.addCapability(19);
                }
                NetworkRequest networkRequest = builder.build();
                connectivityManager.registerNetworkCallback(networkRequest, (ConnectivityManager.NetworkCallback)m_callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterReceiver(Context context) {
        Object object = m_lock;
        synchronized (object) {
            if (m_callback != null) {
                QtAndroidNetworkInformation.getConnectivityManager(context).unregisterNetworkCallback((ConnectivityManager.NetworkCallback)m_callback);
                m_callback = null;
            }
        }
    }

    static ConnectivityManager getConnectivityManager(Context context) {
        return (ConnectivityManager)context.getSystemService("connectivity");
    }

    private static class QtNetworkInformationCallback
    extends ConnectivityManager.NetworkCallback {
        AndroidConnectivity previousState = null;
        Transport previousTransport = null;

        QtNetworkInformationCallback() {
        }

        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            AndroidConnectivity androidConnectivity = !networkCapabilities.hasCapability(12) ? AndroidConnectivity.Disconnected : (networkCapabilities.hasCapability(16) ? AndroidConnectivity.Connected : AndroidConnectivity.Unknown);
            Transport transport = this.getTransport(networkCapabilities);
            if (transport == Transport.Unknown) {
                androidConnectivity = AndroidConnectivity.Unknown;
            }
            this.setState(androidConnectivity);
            this.setTransportMedium(transport);
            boolean bl = networkCapabilities.hasCapability(17);
            boolean bl2 = !networkCapabilities.hasCapability(11);
            QtAndroidNetworkInformation.genericInfoChanged(bl, bl2);
        }

        private Transport getTransport(NetworkCapabilities networkCapabilities) {
            if (networkCapabilities.hasTransport(1)) {
                return Transport.WiFi;
            }
            if (networkCapabilities.hasTransport(0)) {
                return Transport.Cellular;
            }
            if (networkCapabilities.hasTransport(2)) {
                return Transport.Bluetooth;
            }
            if (networkCapabilities.hasTransport(3)) {
                return Transport.Ethernet;
            }
            if (networkCapabilities.hasTransport(5)) {
                return Transport.WiFiAware;
            }
            if (networkCapabilities.hasTransport(6)) {
                return Transport.LoWPAN;
            }
            return Transport.Unknown;
        }

        private void setState(AndroidConnectivity androidConnectivity) {
            if (this.previousState != androidConnectivity) {
                this.previousState = androidConnectivity;
                QtAndroidNetworkInformation.networkConnectivityChanged(androidConnectivity.ordinal());
            }
        }

        private void setTransportMedium(Transport transport) {
            if (this.previousTransport != transport) {
                this.previousTransport = transport;
                QtAndroidNetworkInformation.transportMediumChanged(transport.ordinal());
            }
        }

        public void onLost(Network network) {
            this.setState(AndroidConnectivity.Disconnected);
        }
    }

    static enum AndroidConnectivity {
        Connected,
        Unknown,
        Disconnected;

    }

    static enum Transport {
        Unknown,
        Bluetooth,
        Cellular,
        Ethernet,
        LoWPAN,
        Usb,
        WiFi,
        WiFiAware;

    }
}

