"""
Name: info.py
Porpose: program information strings
Writer: jeanslack <jeanlucperni@gmail.com>
license: GPL3
Copyleft: (C) 2025 Gianluca Pernigotto <jeanlucperni@gmail.com>
Rev: June 10 2025
####################################################################

This file is part of FFcuesplitter.

    FFcuesplitter is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    FFcuesplitter is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with FFcuesplitter.  If not, see <http://www.gnu.org/licenses/>.
"""
AUTHOR = "Gianluca Pernigotto - Jeanslack"
CONTACT = '<jeanlucperni@gmail.com>'
MAINTAINER = "Gianluca Pernigotto - Jeanslack"
COPYLEFT = '2025'
VERSION = '1.0.31'
RELEASE = 'June 27 2025'
APPNAME = "FFcuesplitter"
PKGNAME = "ffcuesplitter"
LICENSE_NAME = "GPL3 (Gnu Public License)"
PROJECTURL = "https://github.com/jeanslack/FFcuesplitter"
GITHUBURL = "https://github.com/jeanslack/FFcuesplitter"
SHORT_DESCRIPT = ("FFmpeg based audio splitter for CDDA images associated "
                  "with .cue files.")
LONG_DESCRIPT = """FFcuesplitter is a multi-platform CUE sheet splitter
entirely based on FFmpeg. Splits big audio tracks and automatically embeds tags
using the information contained in the associated **"CUE"** sheet. It supports
multiple CUE sheet encodings and many input formats (due to FFmpeg), including
APE format, without need installing extra audio libs and packages. It has the
ability to accept both files and directories as input while also working in
recursive mode. Can be used both as a Python module or by command line."""
SHORT_LICENSE = f"""
Copyright - {COPYLEFT} {AUTHOR}
Author and Developer: {AUTHOR}
Mail: {CONTACT}

FFcuesplitter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

FFcuesplitter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with FFcuesplitter.  If not, see <http://www.gnu.org/licenses/>.
"""
