# Some Qt modules also load plugin target in extra config, so check whether the target already exists
if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::VirtualCanBusPlugin)
    add_library(${QT_VARIANT_PREFIX}Qt5::VirtualCanBusPlugin MODULE IMPORTED)

set(_Qt5VirtualCanBusPlugin_MODULE_DEPENDENCIES "SerialBus;Network;Core")

foreach(_module_dep ${_Qt5VirtualCanBusPlugin_MODULE_DEPENDENCIES})
    if(NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
        find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
             ${_Qt5SerialBus_FIND_VERSION_EXACT}
            ${_Qt5SerialBus_DEPENDENCIES_FIND_QUIET}
            ${_Qt5SerialBus_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
        )
    endif()
endforeach()

    _populate_SerialBus_plugin_properties_static(${QT_VARIANT_PREFIX}Qt5::SerialBus ${QT_VARIANT_PREFIX}Qt5::VirtualCanBusPlugin VirtualCanBusPlugin RELEASE "canbus/libqtvirtualcanbus.a")


list(APPEND ${QT_VARIANT_PREFIX}Qt5SerialBus_PLUGINS ${QT_VARIANT_PREFIX}Qt5::VirtualCanBusPlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::SerialBus APPEND PROPERTY QT_ALL_PLUGINS_canbus ${QT_VARIANT_PREFIX}Qt5::VirtualCanBusPlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::VirtualCanBusPlugin PROPERTY QT_PLUGIN_TYPE "canbus")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::VirtualCanBusPlugin PROPERTY QT_PLUGIN_EXTENDS "")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::VirtualCanBusPlugin PROPERTY QT_PLUGIN_CLASS_NAME "VirtualCanBusPlugin")
endif()
