
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was Config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# provide meta-data
set(syncthingwidgets_varname "SYNCTHINGWIDGETS")
set(syncthingwidgets-qt6_varname "SYNCTHINGWIDGETS")
set(SYNCTHINGWIDGETS_DISPLAY_NAME "UI elements of Syncthing Tray")
set(SYNCTHINGWIDGETS_AUTHOR "Martchus")
set(SYNCTHINGWIDGETS_VERSION "2.0.6")
set(SYNCTHINGWIDGETS_VERSION_MAJOR "2")
set(SYNCTHINGWIDGETS_VERSION_MINOR "0")
set(SYNCTHINGWIDGETS_VERSION_PATCH "6")
set(SYNCTHINGWIDGETS_GIT_REV_COUNT "")
set(SYNCTHINGWIDGETS_GIT_LAST_COMMIT_ID "")
set(SYNCTHINGWIDGETS_URL "https://Martchus.github.io/syncthingtray")
set(SYNCTHINGWIDGETS_DESCRIPTION "Tray application for Syncthing v1 and v2")
set(SYNCTHINGWIDGETS_LICENSE "GPL-2.0+")

# define general config
set(SYNCTHINGWIDGETS_IS_HEADER_ONLY NO)
set(SYNCTHINGWIDGETS_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include/syncthingwidgets-static-qt6")
set(SYNCTHINGWIDGETS_BIN_DIR "${PACKAGE_PREFIX_DIR}/bin")
set(SYNCTHINGWIDGETS_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib")
set(SYNCTHINGWIDGETS_DATA_DIRS "${PACKAGE_PREFIX_DIR}/share/syncthingwidgets-static-qt6")
set(SYNCTHINGWIDGETS_MODULE_DIRS "${PACKAGE_PREFIX_DIR}/share/syncthingwidgets-static-qt6/cmake/modules")
set(SYNCTHINGWIDGETS_CONFIG_DIRS "${PACKAGE_PREFIX_DIR}/share/syncthingwidgets-static-qt6/cmake")
set(SYNCTHINGWIDGETS_PRIVATE_QT_MODULES "Network;Concurrent;Gui;Widgets;Core")
set(SYNCTHINGWIDGETS_PRIVATE_KF_MODULES "")
set(SYNCTHINGWIDGETS_PUBLIC_QT_MODULES "Gui;Widgets")
set(SYNCTHINGWIDGETS_PUBLIC_KF_MODULES "")
set(SYNCTHINGWIDGETS_REQUIRED_PACKAGES "c++utilities-static;qtutilities-static-qt6;syncthingconnector-static-qt6;syncthingmodel-static-qt6")
set(SYNCTHINGWIDGETS_REQUIRED_PKG_CONFIG_MODULES "")
set(SYNCTHINGWIDGETS_HAS_QT_TRANSLATION_FILES YES)
set(SYNCTHINGWIDGETS_QT_RESOURCES syncthingwidgetsicons;syncthingwidgets_translations;qtutilsicons;qtutilities_translations;syncthingconnector_translations;syncthingmodelicons;syncthingmodel_translations;qtforkawesome_font)

# define mapping from CMake targets to pkg-config module names
set(PKG_CONFIG_syncthingwidgets-qt6 "syncthingwidgets-static-qt6")

# save policies before modifying them e.g. though the inclusion of 3rdParty
cmake_policy(PUSH)

# define additional find_package arguments for required CMake-packages

# define library config, add imported target
set(SYNCTHINGWIDGETS_PACKAGE "syncthingwidgets-static-qt6")
set(SYNCTHINGWIDGETS_LIB "syncthingwidgets-qt6")
set(SYNCTHINGWIDGETS_LIB_IS_SHARED "OFF")
set(SYNCTHINGWIDGETS_STATIC_LINKAGE "ON")
if(NOT TARGET "${SYNCTHINGWIDGETS_LIB}")
    # make dependencies of the library available
    # caveat: This currently does *not* cover Qt and KF modules which are so far only handled
    #         separately when using the function use_syncthingwidgets.

    # find c++utilities-static to use its CMake modules
    if (NOT SYNCTHINGWIDGETS_PACKAGE STREQUAL "c++utilities-static")
        find_package("c++utilities-static" ${SYNCTHINGWIDGETS_FIND_PACKAGE_ARGS_c++utilities-static} REQUIRED)
    endif ()

    # prefer static libraries if syncthingwidgets was configured this way during its build
    set(SYNCTHINGWIDGETS_DEFAULT_CMAKE_MODULE_PATH "${CMAKE_MODULE_PATH}")
    list(APPEND CMAKE_MODULE_PATH "${SYNCTHINGWIDGETS_MODULE_DIRS}")
    list(APPEND CMAKE_MODULE_PATH "${CPP_UTILITIES_MODULE_DIRS}")
    include(3rdPartyFunctions)
    if (SYNCTHINGWIDGETS_STATIC_LINKAGE)
        save_library_preference()
        prefer_static_libraries()
    endif ()

    # find all required packages
    foreach (_REQUIRED_PACKAGE ${SYNCTHINGWIDGETS_REQUIRED_PACKAGES})
        string(REGEX MATCH _REQUIRED_PACKAGE_MATCH "(.*)-([^-]*)" "${_REQUIRED_PACKAGE}")
        if (_REQUIRED_PACKAGE_MATCH)
            set(_REQUIRED_PACKAGE "${CMAKE_MATCH_1}")
            set(_REQUIRED_VERSION "${CMAKE_MATCH_2}")
        else ()
            unset(_REQUIRED_VERSION)
        endif ()
        string(REPLACE "::" "_" _REQUIRED_PACKAGE_VARNAME "${_REQUIRED_PACKAGE}")
        if (SYNCTHINGWIDGETS_FIND_PACKAGE_ARGS_${_REQUIRED_PACKAGE_VARNAME})
            set(_FIND_PACKAGE_ARGS ${SYNCTHINGWIDGETS_FIND_PACKAGE_ARGS_${_REQUIRED_PACKAGE_VARNAME}})
        else ()
            set(_FIND_PACKAGE_ARGS REQUIRED)
        endif ()
        if (_REQUIRED_VERSION)
            find_package("${_REQUIRED_PACKAGE}" "${_REQUIRED_VERSION}" ${_FIND_PACKAGE_ARGS})
        else ()
            find_package("${_REQUIRED_PACKAGE}" ${_FIND_PACKAGE_ARGS})
        endif()
    endforeach()

    # find all required pkg-config modules
    if (SYNCTHINGWIDGETS_REQUIRED_PKG_CONFIG_MODULES)
        foreach (SYNCTHINGWIDGETS_REQUIRED_PKG_CONFIG_MODULE ${SYNCTHINGWIDGETS_REQUIRED_PKG_CONFIG_MODULES})
            string(REPLACE "::" "_" SYNCTHINGWIDGETS_REQUIRED_PKG_CONFIG_MODULE_VARNAME "${SYNCTHINGWIDGETS_REQUIRED_PKG_CONFIG_MODULE}")
            use_pkg_config_module(
                TARGET_NAME "${SYNCTHINGWIDGETS_REQUIRED_PKG_CONFIG_MODULE}"
                PKG_CONFIG_MODULES "${PKG_CONFIG_${SYNCTHINGWIDGETS_REQUIRED_PKG_CONFIG_MODULE_VARNAME}}"
                LIBRARIES_VARIABLE DEV_NULL
                PKG_CONFIG_MODULES_VARIABLE DEV_NULL
            )
        endforeach ()
    endif ()

    # restore preference of static libraries
    if (SYNCTHINGWIDGETS_STATIC_LINKAGE)
        restore_library_preference()
    endif ()

    # add target for the library itself
    include("${CMAKE_CURRENT_LIST_DIR}/syncthingwidgets-static-qt6Targets.cmake")

    # restore module path
    set(CMAKE_MODULE_PATH "${SYNCTHINGWIDGETS_DEFAULT_CMAKE_MODULE_PATH}")
endif()

# define function to ease use of library in projects following conventions of c++utilities' build script
function(use_syncthingwidgets)
    # make CMake modules of the project available
    list(APPEND CMAKE_MODULE_PATH "${SYNCTHINGWIDGETS_MODULE_DIRS}")
    set(CMAKE_MODULE_PATH "${CMAKE_MODULE_PATH}" PARENT_SCOPE)

    # parse arguments
    list(APPEND CMAKE_MODULE_PATH "${CPP_UTILITIES_MODULE_DIRS}")
    include(3rdParty)
    parse_arguments_for_use_functions(${ARGN})

    # link against library (also "link" against header-only libs to get compile defs and interface link libs)
    link_directories(${SYNCTHINGWIDGETS_LIB_DIR})
    if (ARGS_ONLY_HEADERS)
        set(TARGET_NAME "${SYNCTHINGWIDGETS_LIB}-headers")
    else ()
        set(TARGET_NAME "${SYNCTHINGWIDGETS_LIB}")
    endif ()
    set("${ARGS_LIBRARIES_VARIABLE}" "${${ARGS_LIBRARIES_VARIABLE}};${TARGET_NAME}" PARENT_SCOPE)
    set("${ARGS_PACKAGES_VARIABLE}" "${${ARGS_PACKAGES_VARIABLE}};${SYNCTHINGWIDGETS_PACKAGE}" PARENT_SCOPE)

    if (ARGS_ONLY_HEADERS)
        return ()
    endif ()

    # add required Qt and KF modules
    set(IMPORTED_QT_MODULES
        ${IMPORTED_QT_MODULES}
        ${SYNCTHINGWIDGETS_PUBLIC_QT_MODULES}
        ${SYNCTHINGWIDGETS_PRIVATE_QT_MODULES}
        PARENT_SCOPE
    )
    set(IMPORTED_KF_MODULES
        ${IMPORTED_KF_MODULES}
        ${SYNCTHINGWIDGETS_PUBLIC_KF_MODULES}
        ${SYNCTHINGWIDGETS_PRIVATE_KF_MODULES}
        PARENT_SCOPE
    )

    # add required translations to APP_SPECIFIC_QT_TRANSLATION_FILES_ARRAY
    if(SYNCTHINGWIDGETS_HAS_QT_TRANSLATION_FILES)
        set(APP_SPECIFIC_QT_TRANSLATION_FILES "${APP_SPECIFIC_QT_TRANSLATION_FILES};syncthingwidgets" PARENT_SCOPE)
    endif()

    # add Qt resources if it is a static library
    if (NOT SYNCTHINGWIDGETS_LIB_IS_SHARED)
        set(STATIC_LIBRARIES_QT_RESOURCES "${STATIC_LIBRARIES_QT_RESOURCES};${SYNCTHINGWIDGETS_QT_RESOURCES}" PARENT_SCOPE)
    endif()
endfunction()

# restore policies
cmake_policy(POP)
