
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was Config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# provide meta-data
set(syncthingmodel_varname "LIB_SYNCTHING_MODEL")
set(syncthingmodel-qt6_varname "LIB_SYNCTHING_MODEL")
set(LIB_SYNCTHING_MODEL_DISPLAY_NAME "Data models of Syncthing Tray")
set(LIB_SYNCTHING_MODEL_AUTHOR "Martchus")
set(LIB_SYNCTHING_MODEL_VERSION "2.0.3")
set(LIB_SYNCTHING_MODEL_VERSION_MAJOR "2")
set(LIB_SYNCTHING_MODEL_VERSION_MINOR "0")
set(LIB_SYNCTHING_MODEL_VERSION_PATCH "3")
set(LIB_SYNCTHING_MODEL_GIT_REV_COUNT "")
set(LIB_SYNCTHING_MODEL_GIT_LAST_COMMIT_ID "")
set(LIB_SYNCTHING_MODEL_URL "https://Martchus.github.io/syncthingtray")
set(LIB_SYNCTHING_MODEL_DESCRIPTION "Data models of Syncthing Tray")
set(LIB_SYNCTHING_MODEL_LICENSE "GPL-2.0+")

# define general config
set(LIB_SYNCTHING_MODEL_IS_HEADER_ONLY NO)
set(LIB_SYNCTHING_MODEL_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include/syncthingmodel-shared-qt6")
set(LIB_SYNCTHING_MODEL_BIN_DIR "${PACKAGE_PREFIX_DIR}/bin")
set(LIB_SYNCTHING_MODEL_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib")
set(LIB_SYNCTHING_MODEL_DATA_DIRS "${PACKAGE_PREFIX_DIR}/share/syncthingmodel-shared-qt6")
set(LIB_SYNCTHING_MODEL_MODULE_DIRS "${PACKAGE_PREFIX_DIR}/share/syncthingmodel-shared-qt6/cmake/modules")
set(LIB_SYNCTHING_MODEL_CONFIG_DIRS "${PACKAGE_PREFIX_DIR}/share/syncthingmodel-shared-qt6/cmake")
set(LIB_SYNCTHING_MODEL_PRIVATE_QT_MODULES "Concurrent;Network;Gui;Svg;Widgets;Core")
set(LIB_SYNCTHING_MODEL_PRIVATE_KF_MODULES "")
set(LIB_SYNCTHING_MODEL_PUBLIC_QT_MODULES "Gui;Widgets")
set(LIB_SYNCTHING_MODEL_PUBLIC_KF_MODULES "")
set(LIB_SYNCTHING_MODEL_REQUIRED_PACKAGES "syncthingconnector-shared-qt6;qtforkawesome-shared-qt6")
set(LIB_SYNCTHING_MODEL_REQUIRED_PKG_CONFIG_MODULES "")
set(LIB_SYNCTHING_MODEL_HAS_QT_TRANSLATION_FILES YES)
set(LIB_SYNCTHING_MODEL_QT_RESOURCES syncthingmodelicons)

# define mapping from CMake targets to pkg-config module names
set(PKG_CONFIG_syncthingmodel-qt6 "syncthingmodel-shared-qt6")

# save policies before modifying them e.g. though the inclusion of 3rdParty
cmake_policy(PUSH)

# define additional find_package arguments for required CMake-packages

# define library config, add imported target
set(LIB_SYNCTHING_MODEL_PACKAGE "syncthingmodel-shared-qt6")
set(LIB_SYNCTHING_MODEL_LIB "syncthingmodel-qt6")
set(LIB_SYNCTHING_MODEL_LIB_IS_SHARED "ON")
set(LIB_SYNCTHING_MODEL_STATIC_LINKAGE "OFF")
if(NOT TARGET "${LIB_SYNCTHING_MODEL_LIB}")
    # make dependencies of the library available
    # caveat: This currently does *not* cover Qt and KF modules which are so far only handled
    #         separately when using the function use_syncthingmodel.

    # find c++utilities-shared to use its CMake modules
    if (NOT LIB_SYNCTHING_MODEL_PACKAGE STREQUAL "c++utilities-shared")
        find_package("c++utilities-shared" ${LIB_SYNCTHING_MODEL_FIND_PACKAGE_ARGS_c++utilities-shared} REQUIRED)
    endif ()

    # prefer static libraries if syncthingmodel was configured this way during its build
    set(LIB_SYNCTHING_MODEL_DEFAULT_CMAKE_MODULE_PATH "${CMAKE_MODULE_PATH}")
    list(APPEND CMAKE_MODULE_PATH "${LIB_SYNCTHING_MODEL_MODULE_DIRS}")
    list(APPEND CMAKE_MODULE_PATH "${CPP_UTILITIES_MODULE_DIRS}")
    include(3rdPartyFunctions)
    if (LIB_SYNCTHING_MODEL_STATIC_LINKAGE)
        save_library_preference()
        prefer_static_libraries()
    endif ()

    # find all required packages
    foreach (_REQUIRED_PACKAGE ${LIB_SYNCTHING_MODEL_REQUIRED_PACKAGES})
        string(REGEX MATCH _REQUIRED_PACKAGE_MATCH "(.*)-([^-]*)" "${_REQUIRED_PACKAGE}")
        if (_REQUIRED_PACKAGE_MATCH)
            set(_REQUIRED_PACKAGE "${CMAKE_MATCH_1}")
            set(_REQUIRED_VERSION "${CMAKE_MATCH_2}")
        else ()
            unset(_REQUIRED_VERSION)
        endif ()
        string(REPLACE "::" "_" _REQUIRED_PACKAGE_VARNAME "${_REQUIRED_PACKAGE}")
        if (LIB_SYNCTHING_MODEL_FIND_PACKAGE_ARGS_${_REQUIRED_PACKAGE_VARNAME})
            set(_FIND_PACKAGE_ARGS ${LIB_SYNCTHING_MODEL_FIND_PACKAGE_ARGS_${_REQUIRED_PACKAGE_VARNAME}})
        else ()
            set(_FIND_PACKAGE_ARGS REQUIRED)
        endif ()
        if (_REQUIRED_VERSION)
            find_package("${_REQUIRED_PACKAGE}" "${_REQUIRED_VERSION}" ${_FIND_PACKAGE_ARGS})
        else ()
            find_package("${_REQUIRED_PACKAGE}" ${_FIND_PACKAGE_ARGS})
        endif()
    endforeach()

    # find all required pkg-config modules
    if (LIB_SYNCTHING_MODEL_REQUIRED_PKG_CONFIG_MODULES)
        foreach (LIB_SYNCTHING_MODEL_REQUIRED_PKG_CONFIG_MODULE ${LIB_SYNCTHING_MODEL_REQUIRED_PKG_CONFIG_MODULES})
            string(REPLACE "::" "_" LIB_SYNCTHING_MODEL_REQUIRED_PKG_CONFIG_MODULE_VARNAME "${LIB_SYNCTHING_MODEL_REQUIRED_PKG_CONFIG_MODULE}")
            use_pkg_config_module(
                TARGET_NAME "${LIB_SYNCTHING_MODEL_REQUIRED_PKG_CONFIG_MODULE}"
                PKG_CONFIG_MODULES "${PKG_CONFIG_${LIB_SYNCTHING_MODEL_REQUIRED_PKG_CONFIG_MODULE_VARNAME}}"
                LIBRARIES_VARIABLE DEV_NULL
                PKG_CONFIG_MODULES_VARIABLE DEV_NULL
            )
        endforeach ()
    endif ()

    # restore preference of static libraries
    if (LIB_SYNCTHING_MODEL_STATIC_LINKAGE)
        restore_library_preference()
    endif ()

    # add target for the library itself
    include("${CMAKE_CURRENT_LIST_DIR}/syncthingmodel-shared-qt6Targets.cmake")

    # restore module path
    set(CMAKE_MODULE_PATH "${LIB_SYNCTHING_MODEL_DEFAULT_CMAKE_MODULE_PATH}")
endif()

# define function to ease use of library in projects following conventions of c++utilities' build script
function(use_syncthingmodel)
    # make CMake modules of the project available
    list(APPEND CMAKE_MODULE_PATH "${LIB_SYNCTHING_MODEL_MODULE_DIRS}")
    set(CMAKE_MODULE_PATH "${CMAKE_MODULE_PATH}" PARENT_SCOPE)

    # parse arguments
    list(APPEND CMAKE_MODULE_PATH "${CPP_UTILITIES_MODULE_DIRS}")
    include(3rdParty)
    parse_arguments_for_use_functions(${ARGN})

    # link against library (also "link" against header-only libs to get compile defs and interface link libs)
    link_directories(${LIB_SYNCTHING_MODEL_LIB_DIR})
    if (ARGS_ONLY_HEADERS)
        set(TARGET_NAME "${LIB_SYNCTHING_MODEL_LIB}-headers")
    else ()
        set(TARGET_NAME "${LIB_SYNCTHING_MODEL_LIB}")
    endif ()
    set("${ARGS_LIBRARIES_VARIABLE}" "${${ARGS_LIBRARIES_VARIABLE}};${TARGET_NAME}" PARENT_SCOPE)
    set("${ARGS_PACKAGES_VARIABLE}" "${${ARGS_PACKAGES_VARIABLE}};${LIB_SYNCTHING_MODEL_PACKAGE}" PARENT_SCOPE)

    if (ARGS_ONLY_HEADERS)
        return ()
    endif ()

    # add required Qt and KF modules
    set(IMPORTED_QT_MODULES
        ${IMPORTED_QT_MODULES}
        ${LIB_SYNCTHING_MODEL_PUBLIC_QT_MODULES}
        ${LIB_SYNCTHING_MODEL_PRIVATE_QT_MODULES}
        PARENT_SCOPE
    )
    set(IMPORTED_KF_MODULES
        ${IMPORTED_KF_MODULES}
        ${LIB_SYNCTHING_MODEL_PUBLIC_KF_MODULES}
        ${LIB_SYNCTHING_MODEL_PRIVATE_KF_MODULES}
        PARENT_SCOPE
    )

    # add required translations to APP_SPECIFIC_QT_TRANSLATION_FILES_ARRAY
    if(LIB_SYNCTHING_MODEL_HAS_QT_TRANSLATION_FILES)
        set(APP_SPECIFIC_QT_TRANSLATION_FILES "${APP_SPECIFIC_QT_TRANSLATION_FILES};syncthingmodel" PARENT_SCOPE)
    endif()

    # add Qt resources if it is a static library
    if (NOT LIB_SYNCTHING_MODEL_LIB_IS_SHARED)
        set(STATIC_LIBRARIES_QT_RESOURCES "${STATIC_LIBRARIES_QT_RESOURCES};${LIB_SYNCTHING_MODEL_QT_RESOURCES}" PARENT_SCOPE)
    endif()
endfunction()

# restore policies
cmake_policy(POP)
