#ifndef QT_UTILITIES_DISABLE_WARNINGS_MOC_H
#define QT_UTILITIES_DISABLE_WARNINGS_MOC_H

#include <QtGlobal> // for QtCompilerDetection

/*!
 * \file disablewarningsmoc.h
 * \brief Macro to disable warnings that sources generated by moc might generate.
 * \remarks These warnings are also worked around by disabling them for `mocs_compilation.cpp`
 *          files via `set_source_files_properties` on CMake-level. The set of warnings should
 *          be kept in-sync between the CMake-level workaround and this macro.
 */

#define QT_UTILITIES_DISABLE_WARNINGS_FOR_MOC_INCLUDE                                                                                                \
    QT_WARNING_PUSH                                                                                                                                  \
    QT_WARNING_DISABLE_GCC("-Wsign-conversion")                                                                                                      \
    QT_WARNING_DISABLE_CLANG("-Wsign-conversion")
#define QT_UTILITIES_RESTORE_WARNINGS_FOR_MOC_INCLUDE QT_WARNING_POP

#endif // QT_UTILITIES_DISABLE_WARNINGS_MOC_H
