// This file is generated by kconfig_compiler_kf5 from darkly.kcfg.
// All changes you do to this file will be lost.
#ifndef DARKLY_STYLECONFIGDATA_H
#define DARKLY_STYLECONFIGDATA_H

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

namespace Darkly {

class StyleConfigData : public KConfigSkeleton
{
  public:
    enum EnumShadowSize { ShadowNone, ShadowSmall, ShadowMedium, ShadowLarge, ShadowVeryLarge };
    enum EnumShadowIntensity { Low, Medium, High, Maximum };
    enum EnumMnemonicsMode { MN_NEVER, MN_AUTO, MN_ALWAYS };
    enum EnumWindowDragMode { WD_NONE, WD_MINIMAL, WD_FULL };

    static StyleConfigData *self();
    ~StyleConfigData() override;

    /**
      Set ShadowStrength
    */
    static
    void setShadowStrength( int v )
    {
      if (v < 25)
      {
        qDebug() << "setShadowStrength: value " << v << " is less than the minimum value of 25";
        v = 25;
      }

      if (v > 255)
      {
        qDebug() << "setShadowStrength: value " << v << " is greater than the maximum value of 255";
        v = 255;
      }

      if (!self()->isShadowStrengthImmutable())
        self()->mShadowStrength = v;
    }

    /**
      Get ShadowStrength
    */
    static
    int shadowStrength()
    {
      return self()->mShadowStrength;
    }

    /**
      Is ShadowStrength Immutable
    */
    static
    bool isShadowStrengthImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShadowStrength" ) );
    }

    /**
      Set FloatingTitlebar
    */
    static
    void setFloatingTitlebar( bool v )
    {
      if (!self()->isFloatingTitlebarImmutable())
        self()->mFloatingTitlebar = v;
    }

    /**
      Get FloatingTitlebar
    */
    static
    bool floatingTitlebar()
    {
      return self()->mFloatingTitlebar;
    }

    /**
      Is FloatingTitlebar Immutable
    */
    static
    bool isFloatingTitlebarImmutable()
    {
      return self()->isImmutable( QStringLiteral( "FloatingTitlebar" ) );
    }

    /**
      Set ScrollBarTransient
    */
    static
    void setScrollBarTransient( bool v )
    {
      if (!self()->isScrollBarTransientImmutable())
        self()->mScrollBarTransient = v;
    }

    /**
      Get ScrollBarTransient
    */
    static
    bool scrollBarTransient()
    {
      return self()->mScrollBarTransient;
    }

    /**
      Is ScrollBarTransient Immutable
    */
    static
    bool isScrollBarTransientImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ScrollBarTransient" ) );
    }

    /**
      Set ScrollBarTransientAlwaysShowSlim
    */
    static
    void setScrollBarTransientAlwaysShowSlim( bool v )
    {
      if (!self()->isScrollBarTransientAlwaysShowSlimImmutable())
        self()->mScrollBarTransientAlwaysShowSlim = v;
    }

    /**
      Get ScrollBarTransientAlwaysShowSlim
    */
    static
    bool scrollBarTransientAlwaysShowSlim()
    {
      return self()->mScrollBarTransientAlwaysShowSlim;
    }

    /**
      Is ScrollBarTransientAlwaysShowSlim Immutable
    */
    static
    bool isScrollBarTransientAlwaysShowSlimImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ScrollBarTransientAlwaysShowSlim" ) );
    }

    /**
      Set ShadowSize
    */
    static
    void setShadowSize( int v )
    {
      if (!self()->isShadowSizeImmutable())
        self()->mShadowSize = v;
    }

    /**
      Get ShadowSize
    */
    static
    int shadowSize()
    {
      return self()->mShadowSize;
    }

    /**
      Is ShadowSize Immutable
    */
    static
    bool isShadowSizeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShadowSize" ) );
    }

    /**
      Set ShadowColor
    */
    static
    void setShadowColor( const QColor & v )
    {
      if (!self()->isShadowColorImmutable())
        self()->mShadowColor = v;
    }

    /**
      Get ShadowColor
    */
    static
    QColor shadowColor()
    {
      return self()->mShadowColor;
    }

    /**
      Is ShadowColor Immutable
    */
    static
    bool isShadowColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShadowColor" ) );
    }

    /**
      Set ShadowIntensity
    */
    static
    void setShadowIntensity( int v )
    {
      if (!self()->isShadowIntensityImmutable())
        self()->mShadowIntensity = v;
    }

    /**
      Get ShadowIntensity
    */
    static
    int shadowIntensity()
    {
      return self()->mShadowIntensity;
    }

    /**
      Is ShadowIntensity Immutable
    */
    static
    bool isShadowIntensityImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShadowIntensity" ) );
    }

    /**
      Set OutlineCloseButton
    */
    static
    void setOutlineCloseButton( bool v )
    {
      if (!self()->isOutlineCloseButtonImmutable())
        self()->mOutlineCloseButton = v;
    }

    /**
      Get OutlineCloseButton
    */
    static
    bool outlineCloseButton()
    {
      return self()->mOutlineCloseButton;
    }

    /**
      Is OutlineCloseButton Immutable
    */
    static
    bool isOutlineCloseButtonImmutable()
    {
      return self()->isImmutable( QStringLiteral( "OutlineCloseButton" ) );
    }

    /**
      Set CornerRadius
    */
    static
    void setCornerRadius( int v )
    {
      if (v < 1)
      {
        qDebug() << "setCornerRadius: value " << v << " is less than the minimum value of 1";
        v = 1;
      }

      if (v > 16)
      {
        qDebug() << "setCornerRadius: value " << v << " is greater than the maximum value of 16";
        v = 16;
      }

      if (!self()->isCornerRadiusImmutable())
        self()->mCornerRadius = v;
    }

    /**
      Get CornerRadius
    */
    static
    int cornerRadius()
    {
      return self()->mCornerRadius;
    }

    /**
      Is CornerRadius Immutable
    */
    static
    bool isCornerRadiusImmutable()
    {
      return self()->isImmutable( QStringLiteral( "CornerRadius" ) );
    }

    /**
      Set ButtonHeight
    */
    static
    void setButtonHeight( int v )
    {
      if (!self()->isButtonHeightImmutable())
        self()->mButtonHeight = v;
    }

    /**
      Get ButtonHeight
    */
    static
    int buttonHeight()
    {
      return self()->mButtonHeight;
    }

    /**
      Is ButtonHeight Immutable
    */
    static
    bool isButtonHeightImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ButtonHeight" ) );
    }

    /**
      Set ButtonWidth
    */
    static
    void setButtonWidth( int v )
    {
      if (!self()->isButtonWidthImmutable())
        self()->mButtonWidth = v;
    }

    /**
      Get ButtonWidth
    */
    static
    int buttonWidth()
    {
      return self()->mButtonWidth;
    }

    /**
      Is ButtonWidth Immutable
    */
    static
    bool isButtonWidthImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ButtonWidth" ) );
    }

    /**
      Set MenuItemHeight
    */
    static
    void setMenuItemHeight( int v )
    {
      if (!self()->isMenuItemHeightImmutable())
        self()->mMenuItemHeight = v;
    }

    /**
      Get MenuItemHeight
    */
    static
    int menuItemHeight()
    {
      return self()->mMenuItemHeight;
    }

    /**
      Is MenuItemHeight Immutable
    */
    static
    bool isMenuItemHeightImmutable()
    {
      return self()->isImmutable( QStringLiteral( "MenuItemHeight" ) );
    }

    /**
      Set FancyMargins
    */
    static
    void setFancyMargins( bool v )
    {
      if (!self()->isFancyMarginsImmutable())
        self()->mFancyMargins = v;
    }

    /**
      Get FancyMargins
    */
    static
    bool fancyMargins()
    {
      return self()->mFancyMargins;
    }

    /**
      Is FancyMargins Immutable
    */
    static
    bool isFancyMarginsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "FancyMargins" ) );
    }

    /**
      Set SunkenEffect
    */
    static
    void setSunkenEffect( bool v )
    {
      if (!self()->isSunkenEffectImmutable())
        self()->mSunkenEffect = v;
    }

    /**
      Get SunkenEffect
    */
    static
    bool sunkenEffect()
    {
      return self()->mSunkenEffect;
    }

    /**
      Is SunkenEffect Immutable
    */
    static
    bool isSunkenEffectImmutable()
    {
      return self()->isImmutable( QStringLiteral( "SunkenEffect" ) );
    }

    /**
      Set UseNewCheckBox
    */
    static
    void setUseNewCheckBox( bool v )
    {
      if (!self()->isUseNewCheckBoxImmutable())
        self()->mUseNewCheckBox = v;
    }

    /**
      Get UseNewCheckBox
    */
    static
    bool useNewCheckBox()
    {
      return self()->mUseNewCheckBox;
    }

    /**
      Is UseNewCheckBox Immutable
    */
    static
    bool isUseNewCheckBoxImmutable()
    {
      return self()->isImmutable( QStringLiteral( "UseNewCheckBox" ) );
    }

    /**
      Set AnimationsEnabled
    */
    static
    void setAnimationsEnabled( bool v )
    {
      if (!self()->isAnimationsEnabledImmutable())
        self()->mAnimationsEnabled = v;
    }

    /**
      Get AnimationsEnabled
    */
    static
    bool animationsEnabled()
    {
      return self()->mAnimationsEnabled;
    }

    /**
      Is AnimationsEnabled Immutable
    */
    static
    bool isAnimationsEnabledImmutable()
    {
      return self()->isImmutable( QStringLiteral( "AnimationsEnabled" ) );
    }

    /**
      Set AnimationSteps
    */
    static
    void setAnimationSteps( int v )
    {
      if (!self()->isAnimationStepsImmutable())
        self()->mAnimationSteps = v;
    }

    /**
      Get AnimationSteps
    */
    static
    int animationSteps()
    {
      return self()->mAnimationSteps;
    }

    /**
      Is AnimationSteps Immutable
    */
    static
    bool isAnimationStepsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "AnimationSteps" ) );
    }

    /**
      Set AnimationsDuration
    */
    static
    void setAnimationsDuration( int v )
    {
      if (!self()->isAnimationsDurationImmutable())
        self()->mAnimationsDuration = v;
    }

    /**
      Get AnimationsDuration
    */
    static
    int animationsDuration()
    {
      return self()->mAnimationsDuration;
    }

    /**
      Is AnimationsDuration Immutable
    */
    static
    bool isAnimationsDurationImmutable()
    {
      return self()->isImmutable( QStringLiteral( "AnimationsDuration" ) );
    }

    /**
      Set StackedWidgetTransitionsEnabled
    */
    static
    void setStackedWidgetTransitionsEnabled( bool v )
    {
      if (!self()->isStackedWidgetTransitionsEnabledImmutable())
        self()->mStackedWidgetTransitionsEnabled = v;
    }

    /**
      Get StackedWidgetTransitionsEnabled
    */
    static
    bool stackedWidgetTransitionsEnabled()
    {
      return self()->mStackedWidgetTransitionsEnabled;
    }

    /**
      Is StackedWidgetTransitionsEnabled Immutable
    */
    static
    bool isStackedWidgetTransitionsEnabledImmutable()
    {
      return self()->isImmutable( QStringLiteral( "StackedWidgetTransitionsEnabled" ) );
    }

    /**
      Set ProgressBarAnimated
    */
    static
    void setProgressBarAnimated( bool v )
    {
      if (!self()->isProgressBarAnimatedImmutable())
        self()->mProgressBarAnimated = v;
    }

    /**
      Get ProgressBarAnimated
    */
    static
    bool progressBarAnimated()
    {
      return self()->mProgressBarAnimated;
    }

    /**
      Is ProgressBarAnimated Immutable
    */
    static
    bool isProgressBarAnimatedImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ProgressBarAnimated" ) );
    }

    /**
      Set ProgressBarBusyStepDuration
    */
    static
    void setProgressBarBusyStepDuration( int v )
    {
      if (!self()->isProgressBarBusyStepDurationImmutable())
        self()->mProgressBarBusyStepDuration = v;
    }

    /**
      Get ProgressBarBusyStepDuration
    */
    static
    int progressBarBusyStepDuration()
    {
      return self()->mProgressBarBusyStepDuration;
    }

    /**
      Is ProgressBarBusyStepDuration Immutable
    */
    static
    bool isProgressBarBusyStepDurationImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ProgressBarBusyStepDuration" ) );
    }

    /**
      Set ScrollBarAddLineButtons
    */
    static
    void setScrollBarAddLineButtons( int v )
    {
      if (!self()->isScrollBarAddLineButtonsImmutable())
        self()->mScrollBarAddLineButtons = v;
    }

    /**
      Get ScrollBarAddLineButtons
    */
    static
    int scrollBarAddLineButtons()
    {
      return self()->mScrollBarAddLineButtons;
    }

    /**
      Is ScrollBarAddLineButtons Immutable
    */
    static
    bool isScrollBarAddLineButtonsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ScrollBarAddLineButtons" ) );
    }

    /**
      Set ScrollBarSubLineButtons
    */
    static
    void setScrollBarSubLineButtons( int v )
    {
      if (!self()->isScrollBarSubLineButtonsImmutable())
        self()->mScrollBarSubLineButtons = v;
    }

    /**
      Get ScrollBarSubLineButtons
    */
    static
    int scrollBarSubLineButtons()
    {
      return self()->mScrollBarSubLineButtons;
    }

    /**
      Is ScrollBarSubLineButtons Immutable
    */
    static
    bool isScrollBarSubLineButtonsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ScrollBarSubLineButtons" ) );
    }

    /**
      Set MnemonicsMode
    */
    static
    void setMnemonicsMode( int v )
    {
      if (!self()->isMnemonicsModeImmutable())
        self()->mMnemonicsMode = v;
    }

    /**
      Get MnemonicsMode
    */
    static
    int mnemonicsMode()
    {
      return self()->mMnemonicsMode;
    }

    /**
      Is MnemonicsMode Immutable
    */
    static
    bool isMnemonicsModeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "MnemonicsMode" ) );
    }

    /**
      Set ToolBarDrawItemSeparator
    */
    static
    void setToolBarDrawItemSeparator( bool v )
    {
      if (!self()->isToolBarDrawItemSeparatorImmutable())
        self()->mToolBarDrawItemSeparator = v;
    }

    /**
      Get ToolBarDrawItemSeparator
    */
    static
    bool toolBarDrawItemSeparator()
    {
      return self()->mToolBarDrawItemSeparator;
    }

    /**
      Is ToolBarDrawItemSeparator Immutable
    */
    static
    bool isToolBarDrawItemSeparatorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ToolBarDrawItemSeparator" ) );
    }

    /**
      Set ToolBarDrawSeparator
    */
    static
    void setToolBarDrawSeparator( bool v )
    {
      if (!self()->isToolBarDrawSeparatorImmutable())
        self()->mToolBarDrawSeparator = v;
    }

    /**
      Get ToolBarDrawSeparator
    */
    static
    bool toolBarDrawSeparator()
    {
      return self()->mToolBarDrawSeparator;
    }

    /**
      Is ToolBarDrawSeparator Immutable
    */
    static
    bool isToolBarDrawSeparatorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ToolBarDrawSeparator" ) );
    }

    /**
      Set ViewDrawFocusIndicator
    */
    static
    void setViewDrawFocusIndicator( bool v )
    {
      if (!self()->isViewDrawFocusIndicatorImmutable())
        self()->mViewDrawFocusIndicator = v;
    }

    /**
      Get ViewDrawFocusIndicator
    */
    static
    bool viewDrawFocusIndicator()
    {
      return self()->mViewDrawFocusIndicator;
    }

    /**
      Is ViewDrawFocusIndicator Immutable
    */
    static
    bool isViewDrawFocusIndicatorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ViewDrawFocusIndicator" ) );
    }

    /**
      Set WidgetDrawShadow
    */
    static
    void setWidgetDrawShadow( bool v )
    {
      if (!self()->isWidgetDrawShadowImmutable())
        self()->mWidgetDrawShadow = v;
    }

    /**
      Get WidgetDrawShadow
    */
    static
    bool widgetDrawShadow()
    {
      return self()->mWidgetDrawShadow;
    }

    /**
      Is WidgetDrawShadow Immutable
    */
    static
    bool isWidgetDrawShadowImmutable()
    {
      return self()->isImmutable( QStringLiteral( "WidgetDrawShadow" ) );
    }

    /**
      Set WidgetToolBarShadow
    */
    static
    void setWidgetToolBarShadow( bool v )
    {
      if (!self()->isWidgetToolBarShadowImmutable())
        self()->mWidgetToolBarShadow = v;
    }

    /**
      Get WidgetToolBarShadow
    */
    static
    bool widgetToolBarShadow()
    {
      return self()->mWidgetToolBarShadow;
    }

    /**
      Is WidgetToolBarShadow Immutable
    */
    static
    bool isWidgetToolBarShadowImmutable()
    {
      return self()->isImmutable( QStringLiteral( "WidgetToolBarShadow" ) );
    }

    /**
      Set ScrollableMenu
    */
    static
    void setScrollableMenu( bool v )
    {
      if (!self()->isScrollableMenuImmutable())
        self()->mScrollableMenu = v;
    }

    /**
      Get ScrollableMenu
    */
    static
    bool scrollableMenu()
    {
      return self()->mScrollableMenu;
    }

    /**
      Is ScrollableMenu Immutable
    */
    static
    bool isScrollableMenuImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ScrollableMenu" ) );
    }

    /**
      Set OldTabbar
    */
    static
    void setOldTabbar( bool v )
    {
      if (!self()->isOldTabbarImmutable())
        self()->mOldTabbar = v;
    }

    /**
      Get OldTabbar
    */
    static
    bool oldTabbar()
    {
      return self()->mOldTabbar;
    }

    /**
      Is OldTabbar Immutable
    */
    static
    bool isOldTabbarImmutable()
    {
      return self()->isImmutable( QStringLiteral( "OldTabbar" ) );
    }

    /**
      Set ViewDrawTreeBranchLines
    */
    static
    void setViewDrawTreeBranchLines( bool v )
    {
      if (!self()->isViewDrawTreeBranchLinesImmutable())
        self()->mViewDrawTreeBranchLines = v;
    }

    /**
      Get ViewDrawTreeBranchLines
    */
    static
    bool viewDrawTreeBranchLines()
    {
      return self()->mViewDrawTreeBranchLines;
    }

    /**
      Is ViewDrawTreeBranchLines Immutable
    */
    static
    bool isViewDrawTreeBranchLinesImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ViewDrawTreeBranchLines" ) );
    }

    /**
      Set ViewInvertSortIndicator
    */
    static
    void setViewInvertSortIndicator( bool v )
    {
      if (!self()->isViewInvertSortIndicatorImmutable())
        self()->mViewInvertSortIndicator = v;
    }

    /**
      Get ViewInvertSortIndicator
    */
    static
    bool viewInvertSortIndicator()
    {
      return self()->mViewInvertSortIndicator;
    }

    /**
      Is ViewInvertSortIndicator Immutable
    */
    static
    bool isViewInvertSortIndicatorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ViewInvertSortIndicator" ) );
    }

    /**
      Set TabBarAltStyle
    */
    static
    void setTabBarAltStyle( bool v )
    {
      if (!self()->isTabBarAltStyleImmutable())
        self()->mTabBarAltStyle = v;
    }

    /**
      Get TabBarAltStyle
    */
    static
    bool tabBarAltStyle()
    {
      return self()->mTabBarAltStyle;
    }

    /**
      Is TabBarAltStyle Immutable
    */
    static
    bool isTabBarAltStyleImmutable()
    {
      return self()->isImmutable( QStringLiteral( "TabBarAltStyle" ) );
    }

    /**
      Set DocumentModeTabs
    */
    static
    void setDocumentModeTabs( bool v )
    {
      if (!self()->isDocumentModeTabsImmutable())
        self()->mDocumentModeTabs = v;
    }

    /**
      Get DocumentModeTabs
    */
    static
    bool documentModeTabs()
    {
      return self()->mDocumentModeTabs;
    }

    /**
      Is DocumentModeTabs Immutable
    */
    static
    bool isDocumentModeTabsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DocumentModeTabs" ) );
    }

    /**
      Set TabBarDrawCenteredTabs
    */
    static
    void setTabBarDrawCenteredTabs( bool v )
    {
      if (!self()->isTabBarDrawCenteredTabsImmutable())
        self()->mTabBarDrawCenteredTabs = v;
    }

    /**
      Get TabBarDrawCenteredTabs
    */
    static
    bool tabBarDrawCenteredTabs()
    {
      return self()->mTabBarDrawCenteredTabs;
    }

    /**
      Is TabBarDrawCenteredTabs Immutable
    */
    static
    bool isTabBarDrawCenteredTabsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "TabBarDrawCenteredTabs" ) );
    }

    /**
      Set TabBarTabExpandFullWidth
    */
    static
    void setTabBarTabExpandFullWidth( bool v )
    {
      if (!self()->isTabBarTabExpandFullWidthImmutable())
        self()->mTabBarTabExpandFullWidth = v;
    }

    /**
      Get TabBarTabExpandFullWidth
    */
    static
    bool tabBarTabExpandFullWidth()
    {
      return self()->mTabBarTabExpandFullWidth;
    }

    /**
      Is TabBarTabExpandFullWidth Immutable
    */
    static
    bool isTabBarTabExpandFullWidthImmutable()
    {
      return self()->isImmutable( QStringLiteral( "TabBarTabExpandFullWidth" ) );
    }

    /**
      Set TabDrawHighlight
    */
    static
    void setTabDrawHighlight( bool v )
    {
      if (!self()->isTabDrawHighlightImmutable())
        self()->mTabDrawHighlight = v;
    }

    /**
      Get TabDrawHighlight
    */
    static
    bool tabDrawHighlight()
    {
      return self()->mTabDrawHighlight;
    }

    /**
      Is TabDrawHighlight Immutable
    */
    static
    bool isTabDrawHighlightImmutable()
    {
      return self()->isImmutable( QStringLiteral( "TabDrawHighlight" ) );
    }

    /**
      Set UnifiedTabBarKonsole
    */
    static
    void setUnifiedTabBarKonsole( bool v )
    {
      if (!self()->isUnifiedTabBarKonsoleImmutable())
        self()->mUnifiedTabBarKonsole = v;
    }

    /**
      Get UnifiedTabBarKonsole
    */
    static
    bool unifiedTabBarKonsole()
    {
      return self()->mUnifiedTabBarKonsole;
    }

    /**
      Is UnifiedTabBarKonsole Immutable
    */
    static
    bool isUnifiedTabBarKonsoleImmutable()
    {
      return self()->isImmutable( QStringLiteral( "UnifiedTabBarKonsole" ) );
    }

    /**
      Set renderThinSeperatorBetweenTheScrollBar
    */
    static
    void setRenderThinSeperatorBetweenTheScrollBar( bool v )
    {
      if (!self()->isRenderThinSeperatorBetweenTheScrollBarImmutable())
        self()->mRenderThinSeperatorBetweenTheScrollBar = v;
    }

    /**
      Get renderThinSeperatorBetweenTheScrollBar
    */
    static
    bool renderThinSeperatorBetweenTheScrollBar()
    {
      return self()->mRenderThinSeperatorBetweenTheScrollBar;
    }

    /**
      Is renderThinSeperatorBetweenTheScrollBar Immutable
    */
    static
    bool isRenderThinSeperatorBetweenTheScrollBarImmutable()
    {
      return self()->isImmutable( QStringLiteral( "renderThinSeperatorBetweenTheScrollBar" ) );
    }

    /**
      Set TabUseHighlightColor
    */
    static
    void setTabUseHighlightColor( bool v )
    {
      if (!self()->isTabUseHighlightColorImmutable())
        self()->mTabUseHighlightColor = v;
    }

    /**
      Get TabUseHighlightColor
    */
    static
    bool tabUseHighlightColor()
    {
      return self()->mTabUseHighlightColor;
    }

    /**
      Is TabUseHighlightColor Immutable
    */
    static
    bool isTabUseHighlightColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "TabUseHighlightColor" ) );
    }

    /**
      Set DisableDolphinUrlNavigatorBackground
    */
    static
    void setDisableDolphinUrlNavigatorBackground( bool v )
    {
      if (!self()->isDisableDolphinUrlNavigatorBackgroundImmutable())
        self()->mDisableDolphinUrlNavigatorBackground = v;
    }

    /**
      Get DisableDolphinUrlNavigatorBackground
    */
    static
    bool disableDolphinUrlNavigatorBackground()
    {
      return self()->mDisableDolphinUrlNavigatorBackground;
    }

    /**
      Is DisableDolphinUrlNavigatorBackground Immutable
    */
    static
    bool isDisableDolphinUrlNavigatorBackgroundImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DisableDolphinUrlNavigatorBackground" ) );
    }

    /**
      Set TabUseBrighterCloseIcon
    */
    static
    void setTabUseBrighterCloseIcon( bool v )
    {
      if (!self()->isTabUseBrighterCloseIconImmutable())
        self()->mTabUseBrighterCloseIcon = v;
    }

    /**
      Get TabUseBrighterCloseIcon
    */
    static
    bool tabUseBrighterCloseIcon()
    {
      return self()->mTabUseBrighterCloseIcon;
    }

    /**
      Is TabUseBrighterCloseIcon Immutable
    */
    static
    bool isTabUseBrighterCloseIconImmutable()
    {
      return self()->isImmutable( QStringLiteral( "TabUseBrighterCloseIcon" ) );
    }

    /**
      Set TabsHeight
    */
    static
    void setTabsHeight( int v )
    {
      if (!self()->isTabsHeightImmutable())
        self()->mTabsHeight = v;
    }

    /**
      Get TabsHeight
    */
    static
    int tabsHeight()
    {
      return self()->mTabsHeight;
    }

    /**
      Is TabsHeight Immutable
    */
    static
    bool isTabsHeightImmutable()
    {
      return self()->isImmutable( QStringLiteral( "TabsHeight" ) );
    }

    /**
      Set TitleWidgetDrawFrame
    */
    static
    void setTitleWidgetDrawFrame( bool v )
    {
      if (!self()->isTitleWidgetDrawFrameImmutable())
        self()->mTitleWidgetDrawFrame = v;
    }

    /**
      Get TitleWidgetDrawFrame
    */
    static
    bool titleWidgetDrawFrame()
    {
      return self()->mTitleWidgetDrawFrame;
    }

    /**
      Is TitleWidgetDrawFrame Immutable
    */
    static
    bool isTitleWidgetDrawFrameImmutable()
    {
      return self()->isImmutable( QStringLiteral( "TitleWidgetDrawFrame" ) );
    }

    /**
      Set FullOutline
    */
    static
    void setFullOutline( bool v )
    {
      if (!self()->isFullOutlineImmutable())
        self()->mFullOutline = v;
    }

    /**
      Get FullOutline
    */
    static
    bool fullOutline()
    {
      return self()->mFullOutline;
    }

    /**
      Is FullOutline Immutable
    */
    static
    bool isFullOutlineImmutable()
    {
      return self()->isImmutable( QStringLiteral( "FullOutline" ) );
    }

    /**
      Set DockWidgetDrawFrame
    */
    static
    void setDockWidgetDrawFrame( bool v )
    {
      if (!self()->isDockWidgetDrawFrameImmutable())
        self()->mDockWidgetDrawFrame = v;
    }

    /**
      Get DockWidgetDrawFrame
    */
    static
    bool dockWidgetDrawFrame()
    {
      return self()->mDockWidgetDrawFrame;
    }

    /**
      Is DockWidgetDrawFrame Immutable
    */
    static
    bool isDockWidgetDrawFrameImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DockWidgetDrawFrame" ) );
    }

    /**
      Set KTextEditDrawFrame
    */
    static
    void setKTextEditDrawFrame( bool v )
    {
      if (!self()->isKTextEditDrawFrameImmutable())
        self()->mKTextEditDrawFrame = v;
    }

    /**
      Get KTextEditDrawFrame
    */
    static
    bool kTextEditDrawFrame()
    {
      return self()->mKTextEditDrawFrame;
    }

    /**
      Is KTextEditDrawFrame Immutable
    */
    static
    bool isKTextEditDrawFrameImmutable()
    {
      return self()->isImmutable( QStringLiteral( "KTextEditDrawFrame" ) );
    }

    /**
      Set SidePanelDrawFrame
    */
    static
    void setSidePanelDrawFrame( bool v )
    {
      if (!self()->isSidePanelDrawFrameImmutable())
        self()->mSidePanelDrawFrame = v;
    }

    /**
      Get SidePanelDrawFrame
    */
    static
    bool sidePanelDrawFrame()
    {
      return self()->mSidePanelDrawFrame;
    }

    /**
      Is SidePanelDrawFrame Immutable
    */
    static
    bool isSidePanelDrawFrameImmutable()
    {
      return self()->isImmutable( QStringLiteral( "SidePanelDrawFrame" ) );
    }

    /**
      Set MenuItemDrawStrongFocus
    */
    static
    void setMenuItemDrawStrongFocus( bool v )
    {
      if (!self()->isMenuItemDrawStrongFocusImmutable())
        self()->mMenuItemDrawStrongFocus = v;
    }

    /**
      Get MenuItemDrawStrongFocus
    */
    static
    bool menuItemDrawStrongFocus()
    {
      return self()->mMenuItemDrawStrongFocus;
    }

    /**
      Is MenuItemDrawStrongFocus Immutable
    */
    static
    bool isMenuItemDrawStrongFocusImmutable()
    {
      return self()->isImmutable( QStringLiteral( "MenuItemDrawStrongFocus" ) );
    }

    /**
      Set RoundedRubberBandFrame
    */
    static
    void setRoundedRubberBandFrame( bool v )
    {
      if (!self()->isRoundedRubberBandFrameImmutable())
        self()->mRoundedRubberBandFrame = v;
    }

    /**
      Get RoundedRubberBandFrame
    */
    static
    bool roundedRubberBandFrame()
    {
      return self()->mRoundedRubberBandFrame;
    }

    /**
      Is RoundedRubberBandFrame Immutable
    */
    static
    bool isRoundedRubberBandFrameImmutable()
    {
      return self()->isImmutable( QStringLiteral( "RoundedRubberBandFrame" ) );
    }

    /**
      Set WindowDragMode
    */
    static
    void setWindowDragMode( int v )
    {
      if (!self()->isWindowDragModeImmutable())
        self()->mWindowDragMode = v;
    }

    /**
      Get WindowDragMode
    */
    static
    int windowDragMode()
    {
      return self()->mWindowDragMode;
    }

    /**
      Is WindowDragMode Immutable
    */
    static
    bool isWindowDragModeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "WindowDragMode" ) );
    }

    /**
      Set WindowDragWhiteList
    */
    static
    void setWindowDragWhiteList( const QStringList & v )
    {
      if (!self()->isWindowDragWhiteListImmutable())
        self()->mWindowDragWhiteList = v;
    }

    /**
      Get WindowDragWhiteList
    */
    static
    QStringList windowDragWhiteList()
    {
      return self()->mWindowDragWhiteList;
    }

    /**
      Is WindowDragWhiteList Immutable
    */
    static
    bool isWindowDragWhiteListImmutable()
    {
      return self()->isImmutable( QStringLiteral( "WindowDragWhiteList" ) );
    }

    /**
      Set WindowDragBlackList
    */
    static
    void setWindowDragBlackList( const QStringList & v )
    {
      if (!self()->isWindowDragBlackListImmutable())
        self()->mWindowDragBlackList = v;
    }

    /**
      Get WindowDragBlackList
    */
    static
    QStringList windowDragBlackList()
    {
      return self()->mWindowDragBlackList;
    }

    /**
      Is WindowDragBlackList Immutable
    */
    static
    bool isWindowDragBlackListImmutable()
    {
      return self()->isImmutable( QStringLiteral( "WindowDragBlackList" ) );
    }

    /**
      Set OpaqueApps
    */
    static
    void setOpaqueApps( const QStringList & v )
    {
      if (!self()->isOpaqueAppsImmutable())
        self()->mOpaqueApps = v;
    }

    /**
      Get OpaqueApps
    */
    static
    QStringList opaqueApps()
    {
      return self()->mOpaqueApps;
    }

    /**
      Is OpaqueApps Immutable
    */
    static
    bool isOpaqueAppsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "OpaqueApps" ) );
    }

    /**
      Set ForceOpaque
    */
    static
    void setForceOpaque( const QStringList & v )
    {
      if (!self()->isForceOpaqueImmutable())
        self()->mForceOpaque = v;
    }

    /**
      Get ForceOpaque
    */
    static
    QStringList forceOpaque()
    {
      return self()->mForceOpaque;
    }

    /**
      Is ForceOpaque Immutable
    */
    static
    bool isForceOpaqueImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ForceOpaque" ) );
    }

    /**
      Set UseWMMoveResize
    */
    static
    void setUseWMMoveResize( bool v )
    {
      if (!self()->isUseWMMoveResizeImmutable())
        self()->mUseWMMoveResize = v;
    }

    /**
      Get UseWMMoveResize
    */
    static
    bool useWMMoveResize()
    {
      return self()->mUseWMMoveResize;
    }

    /**
      Is UseWMMoveResize Immutable
    */
    static
    bool isUseWMMoveResizeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "UseWMMoveResize" ) );
    }

    /**
      Set SplitterProxyEnabled
    */
    static
    void setSplitterProxyEnabled( bool v )
    {
      if (!self()->isSplitterProxyEnabledImmutable())
        self()->mSplitterProxyEnabled = v;
    }

    /**
      Get SplitterProxyEnabled
    */
    static
    bool splitterProxyEnabled()
    {
      return self()->mSplitterProxyEnabled;
    }

    /**
      Is SplitterProxyEnabled Immutable
    */
    static
    bool isSplitterProxyEnabledImmutable()
    {
      return self()->isImmutable( QStringLiteral( "SplitterProxyEnabled" ) );
    }

    /**
      Set SplitterProxyWidth
    */
    static
    void setSplitterProxyWidth( int v )
    {
      if (!self()->isSplitterProxyWidthImmutable())
        self()->mSplitterProxyWidth = v;
    }

    /**
      Get SplitterProxyWidth
    */
    static
    int splitterProxyWidth()
    {
      return self()->mSplitterProxyWidth;
    }

    /**
      Is SplitterProxyWidth Immutable
    */
    static
    bool isSplitterProxyWidthImmutable()
    {
      return self()->isImmutable( QStringLiteral( "SplitterProxyWidth" ) );
    }

    /**
      Set WidgetExplorerEnabled
    */
    static
    void setWidgetExplorerEnabled( bool v )
    {
      if (!self()->isWidgetExplorerEnabledImmutable())
        self()->mWidgetExplorerEnabled = v;
    }

    /**
      Get WidgetExplorerEnabled
    */
    static
    bool widgetExplorerEnabled()
    {
      return self()->mWidgetExplorerEnabled;
    }

    /**
      Is WidgetExplorerEnabled Immutable
    */
    static
    bool isWidgetExplorerEnabledImmutable()
    {
      return self()->isImmutable( QStringLiteral( "WidgetExplorerEnabled" ) );
    }

    /**
      Set DrawWidgetRects
    */
    static
    void setDrawWidgetRects( bool v )
    {
      if (!self()->isDrawWidgetRectsImmutable())
        self()->mDrawWidgetRects = v;
    }

    /**
      Get DrawWidgetRects
    */
    static
    bool drawWidgetRects()
    {
      return self()->mDrawWidgetRects;
    }

    /**
      Is DrawWidgetRects Immutable
    */
    static
    bool isDrawWidgetRectsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DrawWidgetRects" ) );
    }

    /**
      Set MenuOpacity
    */
    static
    void setMenuOpacity( int v )
    {
      if (!self()->isMenuOpacityImmutable())
        self()->mMenuOpacity = v;
    }

    /**
      Get MenuOpacity
    */
    static
    int menuOpacity()
    {
      return self()->mMenuOpacity;
    }

    /**
      Is MenuOpacity Immutable
    */
    static
    bool isMenuOpacityImmutable()
    {
      return self()->isImmutable( QStringLiteral( "MenuOpacity" ) );
    }

    /**
      Set DolphinSidebarOpacity
    */
    static
    void setDolphinSidebarOpacity( int v )
    {
      if (!self()->isDolphinSidebarOpacityImmutable())
        self()->mDolphinSidebarOpacity = v;
    }

    /**
      Get DolphinSidebarOpacity
    */
    static
    int dolphinSidebarOpacity()
    {
      return self()->mDolphinSidebarOpacity;
    }

    /**
      Is DolphinSidebarOpacity Immutable
    */
    static
    bool isDolphinSidebarOpacityImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DolphinSidebarOpacity" ) );
    }

    /**
      Set DolphinViewOpacity
    */
    static
    void setDolphinViewOpacity( int v )
    {
      if (!self()->isDolphinViewOpacityImmutable())
        self()->mDolphinViewOpacity = v;
    }

    /**
      Get DolphinViewOpacity
    */
    static
    int dolphinViewOpacity()
    {
      return self()->mDolphinViewOpacity;
    }

    /**
      Is DolphinViewOpacity Immutable
    */
    static
    bool isDolphinViewOpacityImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DolphinViewOpacity" ) );
    }

    /**
      Set TransparentDolphinView
    */
    static
    void setTransparentDolphinView( bool v )
    {
      if (!self()->isTransparentDolphinViewImmutable())
        self()->mTransparentDolphinView = v;
    }

    /**
      Get TransparentDolphinView
    */
    static
    bool transparentDolphinView()
    {
      return self()->mTransparentDolphinView;
    }

    /**
      Is TransparentDolphinView Immutable
    */
    static
    bool isTransparentDolphinViewImmutable()
    {
      return self()->isImmutable( QStringLiteral( "TransparentDolphinView" ) );
    }

    /**
      Set MenuBarOpacity
    */
    static
    void setMenuBarOpacity( int v )
    {
      if (!self()->isMenuBarOpacityImmutable())
        self()->mMenuBarOpacity = v;
    }

    /**
      Get MenuBarOpacity
    */
    static
    int menuBarOpacity()
    {
      return self()->mMenuBarOpacity;
    }

    /**
      Is MenuBarOpacity Immutable
    */
    static
    bool isMenuBarOpacityImmutable()
    {
      return self()->isImmutable( QStringLiteral( "MenuBarOpacity" ) );
    }

    /**
      Set ToolBarOpacity
    */
    static
    void setToolBarOpacity( int v )
    {
      if (!self()->isToolBarOpacityImmutable())
        self()->mToolBarOpacity = v;
    }

    /**
      Get ToolBarOpacity
    */
    static
    int toolBarOpacity()
    {
      return self()->mToolBarOpacity;
    }

    /**
      Is ToolBarOpacity Immutable
    */
    static
    bool isToolBarOpacityImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ToolBarOpacity" ) );
    }

    /**
      Set TabBarOpacity
    */
    static
    void setTabBarOpacity( int v )
    {
      if (!self()->isTabBarOpacityImmutable())
        self()->mTabBarOpacity = v;
    }

    /**
      Get TabBarOpacity
    */
    static
    int tabBarOpacity()
    {
      return self()->mTabBarOpacity;
    }

    /**
      Is TabBarOpacity Immutable
    */
    static
    bool isTabBarOpacityImmutable()
    {
      return self()->isImmutable( QStringLiteral( "TabBarOpacity" ) );
    }

    /**
      Set AdjustToDarkThemes
    */
    static
    void setAdjustToDarkThemes( bool v )
    {
      if (!self()->isAdjustToDarkThemesImmutable())
        self()->mAdjustToDarkThemes = v;
    }

    /**
      Get AdjustToDarkThemes
    */
    static
    bool adjustToDarkThemes()
    {
      return self()->mAdjustToDarkThemes;
    }

    /**
      Is AdjustToDarkThemes Immutable
    */
    static
    bool isAdjustToDarkThemesImmutable()
    {
      return self()->isImmutable( QStringLiteral( "AdjustToDarkThemes" ) );
    }

    /**
      Set TabBGColor
    */
    static
    void setTabBGColor( const QColor & v )
    {
      if (!self()->isTabBGColorImmutable())
        self()->mTabBGColor = v;
    }

    /**
      Get TabBGColor
    */
    static
    QColor tabBGColor()
    {
      return self()->mTabBGColor;
    }

    /**
      Is TabBGColor Immutable
    */
    static
    bool isTabBGColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "TabBGColor" ) );
    }

  protected:
    StyleConfigData();
    friend class StyleConfigDataHelper;


    // Common
    int mShadowStrength;
    bool mFloatingTitlebar;
    bool mScrollBarTransient;
    bool mScrollBarTransientAlwaysShowSlim;
    int mShadowSize;
    QColor mShadowColor;
    int mShadowIntensity;
    bool mOutlineCloseButton;
    int mCornerRadius;
    int mButtonHeight;
    int mButtonWidth;
    int mMenuItemHeight;
    bool mFancyMargins;
    bool mSunkenEffect;
    bool mUseNewCheckBox;

    // Style
    bool mAnimationsEnabled;
    int mAnimationSteps;
    int mAnimationsDuration;
    bool mStackedWidgetTransitionsEnabled;
    bool mProgressBarAnimated;
    int mProgressBarBusyStepDuration;
    int mScrollBarAddLineButtons;
    int mScrollBarSubLineButtons;
    int mMnemonicsMode;
    bool mToolBarDrawItemSeparator;
    bool mToolBarDrawSeparator;
    bool mViewDrawFocusIndicator;
    bool mWidgetDrawShadow;
    bool mWidgetToolBarShadow;
    bool mScrollableMenu;
    bool mOldTabbar;
    bool mViewDrawTreeBranchLines;
    bool mViewInvertSortIndicator;
    bool mTabBarAltStyle;
    bool mDocumentModeTabs;
    bool mTabBarDrawCenteredTabs;
    bool mTabBarTabExpandFullWidth;
    bool mTabDrawHighlight;
    bool mUnifiedTabBarKonsole;
    bool mRenderThinSeperatorBetweenTheScrollBar;
    bool mTabUseHighlightColor;
    bool mDisableDolphinUrlNavigatorBackground;
    bool mTabUseBrighterCloseIcon;
    int mTabsHeight;
    bool mTitleWidgetDrawFrame;
    bool mFullOutline;
    bool mDockWidgetDrawFrame;
    bool mKTextEditDrawFrame;
    bool mSidePanelDrawFrame;
    bool mMenuItemDrawStrongFocus;
    bool mRoundedRubberBandFrame;
    int mWindowDragMode;
    QStringList mWindowDragWhiteList;
    QStringList mWindowDragBlackList;
    QStringList mOpaqueApps;
    QStringList mForceOpaque;
    bool mUseWMMoveResize;
    bool mSplitterProxyEnabled;
    int mSplitterProxyWidth;
    bool mWidgetExplorerEnabled;
    bool mDrawWidgetRects;
    int mMenuOpacity;
    int mDolphinSidebarOpacity;
    int mDolphinViewOpacity;
    bool mTransparentDolphinView;
    int mMenuBarOpacity;
    int mToolBarOpacity;
    int mTabBarOpacity;
    bool mAdjustToDarkThemes;
    QColor mTabBGColor;

  private:
};

}

#endif

