namespace ReflectiveRapidJSON {
namespace JsonReflector {

// define code for (de)serializing LibPkg::SignatureLevelConfig objects
template <> LIBPKG_EXPORT void push<::LibPkg::SignatureLevelConfig>(const ::LibPkg::SignatureLevelConfig &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.databaseScope, "databaseScope", value, allocator);
    push(reflectable.packageScope, "packageScope", value, allocator);
}
template <> LIBPKG_EXPORT void pull<::LibPkg::SignatureLevelConfig>(::LibPkg::SignatureLevelConfig &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibPkg::SignatureLevelConfig";
    }
    // pull members
    pull(reflectable.databaseScope, "databaseScope", value, errors);
    pull(reflectable.packageScope, "packageScope", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

} // namespace JsonReflector
} // namespace ReflectiveRapidJSON
namespace ReflectiveRapidJSON {
namespace BinaryReflector {

// define code for (de)serializing LibPkg::SignatureLevelConfig objects
template <> LIBPKG_EXPORT void writeCustomType<::LibPkg::SignatureLevelConfig>(BinarySerializer &serializer, const ::LibPkg::SignatureLevelConfig &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::SignatureLevelConfig>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.databaseScope, version);
    serializer.write(customObject.packageScope, version);
}
template <> LIBPKG_EXPORT BinaryVersion readCustomType<::LibPkg::SignatureLevelConfig>(BinaryDeserializer &deserializer, ::LibPkg::SignatureLevelConfig &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::SignatureLevelConfig>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibPkg::SignatureLevelConfig");
    }
    // read members
    deserializer.read(customObject.databaseScope, version);
    deserializer.read(customObject.packageScope, version);
    return version;
}

} // namespace BinaryReflector
} // namespace ReflectiveRapidJSON
