namespace ReflectiveRapidJSON {
namespace JsonReflector {

// define code for (de)serializing BinaryInfo objects
template <>  void push<::BinaryInfo>(const ::BinaryInfo &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.name, "name", value, allocator);
    push(reflectable.architecture, "architecture", value, allocator);
    push(reflectable.symbols, "symbols", value, allocator);
    push(reflectable.requiredLibs, "requiredLibs", value, allocator);
    push(reflectable.rpath, "rpath", value, allocator);
    push(reflectable.prefix, "prefix", value, allocator);
    push(reflectable.isBigEndian, "isBigEndian", value, allocator);
}
template <>  void pull<::BinaryInfo>(::BinaryInfo &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "BinaryInfo";
    }
    // pull members
    pull(reflectable.name, "name", value, errors);
    pull(reflectable.architecture, "architecture", value, errors);
    pull(reflectable.symbols, "symbols", value, errors);
    pull(reflectable.requiredLibs, "requiredLibs", value, errors);
    pull(reflectable.rpath, "rpath", value, errors);
    pull(reflectable.prefix, "prefix", value, errors);
    pull(reflectable.isBigEndian, "isBigEndian", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing PacparseResults objects
template <>  void push<::PacparseResults>(const ::PacparseResults &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.packages, "packages", value, allocator);
    push(reflectable.binaries, "binaries", value, allocator);
}
template <>  void pull<::PacparseResults>(::PacparseResults &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "PacparseResults";
    }
    // pull members
    pull(reflectable.packages, "packages", value, errors);
    pull(reflectable.binaries, "binaries", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

} // namespace JsonReflector
} // namespace ReflectiveRapidJSON
