namespace ReflectiveRapidJSON {
namespace JsonReflector {

// define code for (de)serializing LibRepoMgr::BuildActionTemplate objects
template <> LIBREPOMGR_EXPORT void push<::LibRepoMgr::BuildActionTemplate>(const ::LibRepoMgr::BuildActionTemplate &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.directory, "directory", value, allocator);
    push(reflectable.packageNames, "packageNames", value, allocator);
    push(reflectable.sourceDbs, "sourceDbs", value, allocator);
    push(reflectable.destinationDbs, "destinationDbs", value, allocator);
    push(reflectable.settings, "settings", value, allocator);
    push(reflectable.flags, "flags", value, allocator);
    push(reflectable.type, "type", value, allocator);
    push(reflectable.maxFrequency, "maxFrequency", value, allocator);
}
template <> LIBREPOMGR_EXPORT void pull<::LibRepoMgr::BuildActionTemplate>(::LibRepoMgr::BuildActionTemplate &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibRepoMgr::BuildActionTemplate";
    }
    // pull members
    pull(reflectable.directory, "directory", value, errors);
    pull(reflectable.packageNames, "packageNames", value, errors);
    pull(reflectable.sourceDbs, "sourceDbs", value, errors);
    pull(reflectable.destinationDbs, "destinationDbs", value, errors);
    pull(reflectable.settings, "settings", value, errors);
    pull(reflectable.flags, "flags", value, errors);
    pull(reflectable.type, "type", value, errors);
    pull(reflectable.maxFrequency, "maxFrequency", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibRepoMgr::BuildActionSequenceData objects
template <> LIBREPOMGR_EXPORT void push<::LibRepoMgr::BuildActionSequenceData>(const ::LibRepoMgr::BuildActionSequenceData &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.name, "name", value, allocator);
    push(reflectable.concurrent, "concurrent", value, allocator);
}
template <> LIBREPOMGR_EXPORT void pull<::LibRepoMgr::BuildActionSequenceData>(::LibRepoMgr::BuildActionSequenceData &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibRepoMgr::BuildActionSequenceData";
    }
    // pull members
    pull(reflectable.name, "name", value, errors);
    pull(reflectable.concurrent, "concurrent", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibRepoMgr::BuildActionSequenceNodes objects
template <> LIBREPOMGR_EXPORT void push<::LibRepoMgr::BuildActionSequenceNodes>(const ::LibRepoMgr::BuildActionSequenceNodes &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.actions, "actions", value, allocator);
}
template <> LIBREPOMGR_EXPORT void pull<::LibRepoMgr::BuildActionSequenceNodes>(::LibRepoMgr::BuildActionSequenceNodes &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibRepoMgr::BuildActionSequenceNodes";
    }
    // pull members
    pull(reflectable.actions, "actions", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibRepoMgr::BuildTask objects
template <> LIBREPOMGR_EXPORT void push<::LibRepoMgr::BuildTask>(const ::LibRepoMgr::BuildTask &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    push(static_cast<const ::LibRepoMgr::BuildActionSequenceData &>(reflectable), value, allocator);
    push(static_cast<const ::LibRepoMgr::BuildActionSequenceNodes &>(reflectable), value, allocator);
    // push members
    push(reflectable.desc, "desc", value, allocator);
    push(reflectable.category, "category", value, allocator);
    push(reflectable.frequency, "frequency", value, allocator);
}
template <> LIBREPOMGR_EXPORT void pull<::LibRepoMgr::BuildTask>(::LibRepoMgr::BuildTask &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    pull(static_cast<::LibRepoMgr::BuildActionSequenceData &>(reflectable), value, errors);
    pull(static_cast<::LibRepoMgr::BuildActionSequenceNodes &>(reflectable), value, errors);
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibRepoMgr::BuildTask";
    }
    // pull members
    pull(reflectable.desc, "desc", value, errors);
    pull(reflectable.category, "category", value, errors);
    pull(reflectable.frequency, "frequency", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibRepoMgr::BuildPresets objects
template <> LIBREPOMGR_EXPORT void push<::LibRepoMgr::BuildPresets>(const ::LibRepoMgr::BuildPresets &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.templates, "templates", value, allocator);
    push(reflectable.tasks, "tasks", value, allocator);
}
template <> LIBREPOMGR_EXPORT void pull<::LibRepoMgr::BuildPresets>(::LibRepoMgr::BuildPresets &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibRepoMgr::BuildPresets";
    }
    // pull members
    pull(reflectable.templates, "templates", value, errors);
    pull(reflectable.tasks, "tasks", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

} // namespace JsonReflector
} // namespace ReflectiveRapidJSON
