namespace ReflectiveRapidJSON {
namespace JsonReflector {

// define code for (de)serializing LibRepoMgr::PackageConversion objects
template <> LIBREPOMGR_EXPORT void push<::LibRepoMgr::PackageConversion>(const ::LibRepoMgr::PackageConversion &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.sourcePackage, "sourcePackage", value, allocator);
    push(reflectable.sourceVariant, "sourceVariant", value, allocator);
    push(reflectable.destinationVariant, "destinationVariant", value, allocator);
}
template <> LIBREPOMGR_EXPORT void pull<::LibRepoMgr::PackageConversion>(::LibRepoMgr::PackageConversion &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibRepoMgr::PackageConversion";
    }
    // pull members
    pull(reflectable.sourcePackage, "sourcePackage", value, errors);
    pull(reflectable.sourceVariant, "sourceVariant", value, errors);
    pull(reflectable.destinationVariant, "destinationVariant", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibRepoMgr::PackageBuildData objects
template <> LIBREPOMGR_EXPORT void push<::LibRepoMgr::PackageBuildData>(const ::LibRepoMgr::PackageBuildData &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.existingVersion, "existingVersion", value, allocator);
    push(reflectable.existingPackages, "existingPackages", value, allocator);
    push(reflectable.sourceDirectory, "sourceDirectory", value, allocator);
    push(reflectable.originalSourceDirectory, "originalSourceDirectory", value, allocator);
    push(reflectable.sourceInfo, "sourceInfo", value, allocator);
    push(reflectable.packages, "packages", value, allocator);
    push(reflectable.warnings, "warnings", value, allocator);
    push(reflectable.error, "error", value, allocator);
    push(reflectable.specifiedIndex, "specifiedIndex", value, allocator);
    push(reflectable.hasSource, "hasSource", value, allocator);
    push(reflectable.convertFrom, "convertFrom", value, allocator);
}
template <> LIBREPOMGR_EXPORT void pull<::LibRepoMgr::PackageBuildData>(::LibRepoMgr::PackageBuildData &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibRepoMgr::PackageBuildData";
    }
    // pull members
    pull(reflectable.existingVersion, "existingVersion", value, errors);
    pull(reflectable.existingPackages, "existingPackages", value, errors);
    pull(reflectable.sourceDirectory, "sourceDirectory", value, errors);
    pull(reflectable.originalSourceDirectory, "originalSourceDirectory", value, errors);
    pull(reflectable.sourceInfo, "sourceInfo", value, errors);
    pull(reflectable.packages, "packages", value, errors);
    pull(reflectable.warnings, "warnings", value, errors);
    pull(reflectable.error, "error", value, errors);
    pull(reflectable.specifiedIndex, "specifiedIndex", value, errors);
    pull(reflectable.hasSource, "hasSource", value, errors);
    pull(reflectable.convertFrom, "convertFrom", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibRepoMgr::BuildPreparation objects
template <> LIBREPOMGR_EXPORT void push<::LibRepoMgr::BuildPreparation>(const ::LibRepoMgr::BuildPreparation &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.buildData, "buildData", value, allocator);
    push(reflectable.dbConfig, "dbConfig", value, allocator);
    push(reflectable.stagingDbConfig, "stagingDbConfig", value, allocator);
    push(reflectable.targetDb, "targetDb", value, allocator);
    push(reflectable.targetArch, "targetArch", value, allocator);
    push(reflectable.stagingDb, "stagingDb", value, allocator);
    push(reflectable.batches, "batches", value, allocator);
    push(reflectable.cyclicLeftovers, "cyclicLeftovers", value, allocator);
    push(reflectable.warnings, "warnings", value, allocator);
    push(reflectable.error, "error", value, allocator);
    push(reflectable.manuallyOrdered, "manuallyOrdered", value, allocator);
    push(reflectable.debugDb, "debugDb", value, allocator);
    push(reflectable.stagingDebugDb, "stagingDebugDb", value, allocator);
    push(reflectable.additionalBuildOptions, "additionalBuildOptions", value, allocator);
}
template <> LIBREPOMGR_EXPORT void pull<::LibRepoMgr::BuildPreparation>(::LibRepoMgr::BuildPreparation &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibRepoMgr::BuildPreparation";
    }
    // pull members
    pull(reflectable.buildData, "buildData", value, errors);
    pull(reflectable.dbConfig, "dbConfig", value, errors);
    pull(reflectable.stagingDbConfig, "stagingDbConfig", value, errors);
    pull(reflectable.targetDb, "targetDb", value, errors);
    pull(reflectable.targetArch, "targetArch", value, errors);
    pull(reflectable.stagingDb, "stagingDb", value, errors);
    pull(reflectable.batches, "batches", value, errors);
    pull(reflectable.cyclicLeftovers, "cyclicLeftovers", value, errors);
    pull(reflectable.warnings, "warnings", value, errors);
    pull(reflectable.error, "error", value, errors);
    pull(reflectable.manuallyOrdered, "manuallyOrdered", value, errors);
    pull(reflectable.debugDb, "debugDb", value, errors);
    pull(reflectable.stagingDebugDb, "stagingDebugDb", value, errors);
    pull(reflectable.additionalBuildOptions, "additionalBuildOptions", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibRepoMgr::PackageBuildProgress objects
template <> LIBREPOMGR_EXPORT void push<::LibRepoMgr::PackageBuildProgress>(const ::LibRepoMgr::PackageBuildProgress &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.started, "started", value, allocator);
    push(reflectable.finished, "finished", value, allocator);
    push(reflectable.buildDirectory, "buildDirectory", value, allocator);
    push(reflectable.chrootDirectory, "chrootDirectory", value, allocator);
    push(reflectable.chrootUser, "chrootUser", value, allocator);
    push(reflectable.makechrootpkgFlags, "makechrootpkgFlags", value, allocator);
    push(reflectable.makepkgFlags, "makepkgFlags", value, allocator);
    push(reflectable.packageExtension, "packageExtension", value, allocator);
    push(reflectable.warnings, "warnings", value, allocator);
    push(reflectable.error, "error", value, allocator);
    push(reflectable.updatedVersion, "updatedVersion", value, allocator);
    push(reflectable.stagingNeeded, "stagingNeeded", value, allocator);
    push(reflectable.skipChrootUpgrade, "skipChrootUpgrade", value, allocator);
    push(reflectable.skipChrootCleanup, "skipChrootCleanup", value, allocator);
    push(reflectable.keepPreviousSourceTree, "keepPreviousSourceTree", value, allocator);
    push(reflectable.checksumsUpdated, "checksumsUpdated", value, allocator);
    push(reflectable.hasSources, "hasSources", value, allocator);
    push(reflectable.addedToRepo, "addedToRepo", value, allocator);
}
template <> LIBREPOMGR_EXPORT void pull<::LibRepoMgr::PackageBuildProgress>(::LibRepoMgr::PackageBuildProgress &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibRepoMgr::PackageBuildProgress";
    }
    // pull members
    pull(reflectable.started, "started", value, errors);
    pull(reflectable.finished, "finished", value, errors);
    pull(reflectable.buildDirectory, "buildDirectory", value, errors);
    pull(reflectable.chrootDirectory, "chrootDirectory", value, errors);
    pull(reflectable.chrootUser, "chrootUser", value, errors);
    pull(reflectable.makechrootpkgFlags, "makechrootpkgFlags", value, errors);
    pull(reflectable.makepkgFlags, "makepkgFlags", value, errors);
    pull(reflectable.packageExtension, "packageExtension", value, errors);
    pull(reflectable.warnings, "warnings", value, errors);
    pull(reflectable.error, "error", value, errors);
    pull(reflectable.updatedVersion, "updatedVersion", value, errors);
    pull(reflectable.stagingNeeded, "stagingNeeded", value, errors);
    pull(reflectable.skipChrootUpgrade, "skipChrootUpgrade", value, errors);
    pull(reflectable.skipChrootCleanup, "skipChrootCleanup", value, errors);
    pull(reflectable.keepPreviousSourceTree, "keepPreviousSourceTree", value, errors);
    pull(reflectable.checksumsUpdated, "checksumsUpdated", value, errors);
    pull(reflectable.hasSources, "hasSources", value, errors);
    pull(reflectable.addedToRepo, "addedToRepo", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibRepoMgr::RebuildInfo objects
template <> LIBREPOMGR_EXPORT void push<::LibRepoMgr::RebuildInfo>(const ::LibRepoMgr::RebuildInfo &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.provides, "provides", value, allocator);
    push(reflectable.libprovides, "libprovides", value, allocator);
}
template <> LIBREPOMGR_EXPORT void pull<::LibRepoMgr::RebuildInfo>(::LibRepoMgr::RebuildInfo &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibRepoMgr::RebuildInfo";
    }
    // pull members
    pull(reflectable.provides, "provides", value, errors);
    pull(reflectable.libprovides, "libprovides", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibRepoMgr::BuildProgress objects
template <> LIBREPOMGR_EXPORT void push<::LibRepoMgr::BuildProgress>(const ::LibRepoMgr::BuildProgress &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.progressByPackage, "progressByPackage", value, allocator);
    push(reflectable.targetDbFilePath, "targetDbFilePath", value, allocator);
    push(reflectable.targetRepoPath, "targetRepoPath", value, allocator);
    push(reflectable.stagingDbFilePath, "stagingDbFilePath", value, allocator);
    push(reflectable.stagingRepoPath, "stagingRepoPath", value, allocator);
    push(reflectable.producedProvides, "producedProvides", value, allocator);
    push(reflectable.removedProvides, "removedProvides", value, allocator);
    push(reflectable.rebuildList, "rebuildList", value, allocator);
    push(reflectable.targetDebugDbFilePath, "targetDebugDbFilePath", value, allocator);
    push(reflectable.targetDebugRepoPath, "targetDebugRepoPath", value, allocator);
    push(reflectable.stagingDebugDbFilePath, "stagingDebugDbFilePath", value, allocator);
    push(reflectable.stagingDebugRepoPath, "stagingDebugRepoPath", value, allocator);
}
template <> LIBREPOMGR_EXPORT void pull<::LibRepoMgr::BuildProgress>(::LibRepoMgr::BuildProgress &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibRepoMgr::BuildProgress";
    }
    // pull members
    pull(reflectable.progressByPackage, "progressByPackage", value, errors);
    pull(reflectable.targetDbFilePath, "targetDbFilePath", value, errors);
    pull(reflectable.targetRepoPath, "targetRepoPath", value, errors);
    pull(reflectable.stagingDbFilePath, "stagingDbFilePath", value, errors);
    pull(reflectable.stagingRepoPath, "stagingRepoPath", value, errors);
    pull(reflectable.producedProvides, "producedProvides", value, errors);
    pull(reflectable.removedProvides, "removedProvides", value, errors);
    pull(reflectable.rebuildList, "rebuildList", value, errors);
    pull(reflectable.targetDebugDbFilePath, "targetDebugDbFilePath", value, errors);
    pull(reflectable.targetDebugRepoPath, "targetDebugRepoPath", value, errors);
    pull(reflectable.stagingDebugDbFilePath, "stagingDebugDbFilePath", value, errors);
    pull(reflectable.stagingDebugRepoPath, "stagingDebugRepoPath", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibRepoMgr::PackageMovementResult objects
template <> LIBREPOMGR_EXPORT void push<::LibRepoMgr::PackageMovementResult>(const ::LibRepoMgr::PackageMovementResult &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.failedPackages, "failedPackages", value, allocator);
    push(reflectable.processedPackages, "processedPackages", value, allocator);
    push(reflectable.errorMessage, "errorMessage", value, allocator);
    push(reflectable.processedDebugPackages, "processedDebugPackages", value, allocator);
}
template <> LIBREPOMGR_EXPORT void pull<::LibRepoMgr::PackageMovementResult>(::LibRepoMgr::PackageMovementResult &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibRepoMgr::PackageMovementResult";
    }
    // pull members
    pull(reflectable.failedPackages, "failedPackages", value, errors);
    pull(reflectable.processedPackages, "processedPackages", value, errors);
    pull(reflectable.errorMessage, "errorMessage", value, errors);
    pull(reflectable.processedDebugPackages, "processedDebugPackages", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibRepoMgr::RepositoryProblem objects
template <> LIBREPOMGR_EXPORT void push<::LibRepoMgr::RepositoryProblem>(const ::LibRepoMgr::RepositoryProblem &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.desc, "desc", value, allocator);
    push(reflectable.pkg, "pkg", value, allocator);
    push(reflectable.critical, "critical", value, allocator);
}
template <> LIBREPOMGR_EXPORT void pull<::LibRepoMgr::RepositoryProblem>(::LibRepoMgr::RepositoryProblem &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibRepoMgr::RepositoryProblem";
    }
    // pull members
    pull(reflectable.desc, "desc", value, errors);
    pull(reflectable.pkg, "pkg", value, errors);
    pull(reflectable.critical, "critical", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibRepoMgr::BuildActionMessages objects
template <> LIBREPOMGR_EXPORT void push<::LibRepoMgr::BuildActionMessages>(const ::LibRepoMgr::BuildActionMessages &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.notes, "notes", value, allocator);
    push(reflectable.warnings, "warnings", value, allocator);
    push(reflectable.errors, "errors", value, allocator);
}
template <> LIBREPOMGR_EXPORT void pull<::LibRepoMgr::BuildActionMessages>(::LibRepoMgr::BuildActionMessages &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibRepoMgr::BuildActionMessages";
    }
    // pull members
    pull(reflectable.notes, "notes", value, errors);
    pull(reflectable.warnings, "warnings", value, errors);
    pull(reflectable.errors, "errors", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibRepoMgr::BuildActionBase objects
template <> LIBREPOMGR_EXPORT void push<::LibRepoMgr::BuildActionBase>(const ::LibRepoMgr::BuildActionBase &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.id, "id", value, allocator);
    push(reflectable.type, "type", value, allocator);
    push(reflectable.taskName, "taskName", value, allocator);
    push(reflectable.templateName, "templateName", value, allocator);
    push(reflectable.status, "status", value, allocator);
    push(reflectable.result, "result", value, allocator);
    push(reflectable.created, "created", value, allocator);
    push(reflectable.started, "started", value, allocator);
    push(reflectable.finished, "finished", value, allocator);
    push(reflectable.startAfter, "startAfter", value, allocator);
    push(reflectable.directory, "directory", value, allocator);
    push(reflectable.sourceDbs, "sourceDbs", value, allocator);
    push(reflectable.destinationDbs, "destinationDbs", value, allocator);
    push(reflectable.packageNames, "packageNames", value, allocator);
    push(reflectable.flags, "flags", value, allocator);
    push(reflectable.settings, "settings", value, allocator);
}
template <> LIBREPOMGR_EXPORT void pull<::LibRepoMgr::BuildActionBase>(::LibRepoMgr::BuildActionBase &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibRepoMgr::BuildActionBase";
    }
    // pull members
    pull(reflectable.id, "id", value, errors);
    pull(reflectable.type, "type", value, errors);
    pull(reflectable.taskName, "taskName", value, errors);
    pull(reflectable.templateName, "templateName", value, errors);
    pull(reflectable.status, "status", value, errors);
    pull(reflectable.result, "result", value, errors);
    pull(reflectable.created, "created", value, errors);
    pull(reflectable.started, "started", value, errors);
    pull(reflectable.finished, "finished", value, errors);
    pull(reflectable.startAfter, "startAfter", value, errors);
    pull(reflectable.directory, "directory", value, errors);
    pull(reflectable.sourceDbs, "sourceDbs", value, errors);
    pull(reflectable.destinationDbs, "destinationDbs", value, errors);
    pull(reflectable.packageNames, "packageNames", value, errors);
    pull(reflectable.flags, "flags", value, errors);
    pull(reflectable.settings, "settings", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibRepoMgr::BuildAction objects
template <> LIBREPOMGR_EXPORT void push<::LibRepoMgr::BuildAction>(const ::LibRepoMgr::BuildAction &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    push(static_cast<const ::LibRepoMgr::BuildActionBase &>(reflectable), value, allocator);
    // push members
    push(reflectable.logfiles, "logfiles", value, allocator);
    push(reflectable.artefacts, "artefacts", value, allocator);
    push(reflectable.resultData, "resultData", value, allocator);
}
template <> LIBREPOMGR_EXPORT void pull<::LibRepoMgr::BuildAction>(::LibRepoMgr::BuildAction &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    pull(static_cast<::LibRepoMgr::BuildActionBase &>(reflectable), value, errors);
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibRepoMgr::BuildAction";
    }
    // pull members
    pull(reflectable.logfiles, "logfiles", value, errors);
    pull(reflectable.artefacts, "artefacts", value, errors);
    pull(reflectable.resultData, "resultData", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

} // namespace JsonReflector
} // namespace ReflectiveRapidJSON
namespace ReflectiveRapidJSON {
namespace BinaryReflector {

// define code for (de)serializing LibRepoMgr::PackageConversion objects
template <> LIBREPOMGR_EXPORT void writeCustomType<::LibRepoMgr::PackageConversion>(BinarySerializer &serializer, const ::LibRepoMgr::PackageConversion &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibRepoMgr::PackageConversion, 1>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.sourcePackage, version);
    serializer.write(customObject.sourceVariant, version);
    serializer.write(customObject.destinationVariant, version);
}
template <> LIBREPOMGR_EXPORT BinaryVersion readCustomType<::LibRepoMgr::PackageConversion>(BinaryDeserializer &deserializer, ::LibRepoMgr::PackageConversion &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibRepoMgr::PackageConversion, 1>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibRepoMgr::PackageConversion");
    }
    // read members
    deserializer.read(customObject.sourcePackage, version);
    deserializer.read(customObject.sourceVariant, version);
    deserializer.read(customObject.destinationVariant, version);
    return version;
}

// define code for (de)serializing LibRepoMgr::PackageBuildData objects
template <> LIBREPOMGR_EXPORT void writeCustomType<::LibRepoMgr::PackageBuildData>(BinarySerializer &serializer, const ::LibRepoMgr::PackageBuildData &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibRepoMgr::PackageBuildData, 2>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.existingVersion, version);
    serializer.write(customObject.existingPackages, version);
    serializer.write(customObject.sourceDirectory, version);
    serializer.write(customObject.originalSourceDirectory, version);
    serializer.write(customObject.sourceInfo, version);
    serializer.write(customObject.packages, version);
    serializer.write(customObject.warnings, version);
    serializer.write(customObject.error, version);
    serializer.write(customObject.specifiedIndex, version);
    serializer.write(customObject.hasSource, version);
    if (version >= 2) {
        serializer.write(customObject.convertFrom, version);
    }
}
template <> LIBREPOMGR_EXPORT BinaryVersion readCustomType<::LibRepoMgr::PackageBuildData>(BinaryDeserializer &deserializer, ::LibRepoMgr::PackageBuildData &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibRepoMgr::PackageBuildData, 2>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibRepoMgr::PackageBuildData");
    }
    // read members
    deserializer.read(customObject.existingVersion, version);
    deserializer.read(customObject.existingPackages, version);
    deserializer.read(customObject.sourceDirectory, version);
    deserializer.read(customObject.originalSourceDirectory, version);
    deserializer.read(customObject.sourceInfo, version);
    deserializer.read(customObject.packages, version);
    deserializer.read(customObject.warnings, version);
    deserializer.read(customObject.error, version);
    deserializer.read(customObject.specifiedIndex, version);
    deserializer.read(customObject.hasSource, version);
    if (version >= 2) {
        deserializer.read(customObject.convertFrom, version);
    }
    return version;
}

// define code for (de)serializing LibRepoMgr::BuildPreparation objects
template <> LIBREPOMGR_EXPORT void writeCustomType<::LibRepoMgr::BuildPreparation>(BinarySerializer &serializer, const ::LibRepoMgr::BuildPreparation &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibRepoMgr::BuildPreparation, 2>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.buildData, version);
    serializer.write(customObject.dbConfig, version);
    serializer.write(customObject.stagingDbConfig, version);
    serializer.write(customObject.targetDb, version);
    serializer.write(customObject.targetArch, version);
    serializer.write(customObject.stagingDb, version);
    serializer.write(customObject.batches, version);
    serializer.write(customObject.cyclicLeftovers, version);
    serializer.write(customObject.warnings, version);
    serializer.write(customObject.error, version);
    serializer.write(customObject.manuallyOrdered, version);
    if (version >= 2) {
        serializer.write(customObject.debugDb, version);
        serializer.write(customObject.stagingDebugDb, version);
        serializer.write(customObject.additionalBuildOptions, version);
    }
}
template <> LIBREPOMGR_EXPORT BinaryVersion readCustomType<::LibRepoMgr::BuildPreparation>(BinaryDeserializer &deserializer, ::LibRepoMgr::BuildPreparation &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibRepoMgr::BuildPreparation, 2>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibRepoMgr::BuildPreparation");
    }
    // read members
    deserializer.read(customObject.buildData, version);
    deserializer.read(customObject.dbConfig, version);
    deserializer.read(customObject.stagingDbConfig, version);
    deserializer.read(customObject.targetDb, version);
    deserializer.read(customObject.targetArch, version);
    deserializer.read(customObject.stagingDb, version);
    deserializer.read(customObject.batches, version);
    deserializer.read(customObject.cyclicLeftovers, version);
    deserializer.read(customObject.warnings, version);
    deserializer.read(customObject.error, version);
    deserializer.read(customObject.manuallyOrdered, version);
    if (version >= 2) {
        deserializer.read(customObject.debugDb, version);
        deserializer.read(customObject.stagingDebugDb, version);
        deserializer.read(customObject.additionalBuildOptions, version);
    }
    return version;
}

// define code for (de)serializing LibRepoMgr::PackageBuildProgress objects
template <> LIBREPOMGR_EXPORT void writeCustomType<::LibRepoMgr::PackageBuildProgress>(BinarySerializer &serializer, const ::LibRepoMgr::PackageBuildProgress &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibRepoMgr::PackageBuildProgress, 1>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.started, version);
    serializer.write(customObject.finished, version);
    serializer.write(customObject.buildDirectory, version);
    serializer.write(customObject.chrootDirectory, version);
    serializer.write(customObject.chrootUser, version);
    serializer.write(customObject.makechrootpkgFlags, version);
    serializer.write(customObject.makepkgFlags, version);
    serializer.write(customObject.packageExtension, version);
    serializer.write(customObject.warnings, version);
    serializer.write(customObject.error, version);
    serializer.write(customObject.updatedVersion, version);
    serializer.write(customObject.stagingNeeded, version);
    serializer.write(customObject.skipChrootUpgrade, version);
    serializer.write(customObject.skipChrootCleanup, version);
    serializer.write(customObject.keepPreviousSourceTree, version);
    serializer.write(customObject.checksumsUpdated, version);
    serializer.write(customObject.hasSources, version);
    serializer.write(customObject.addedToRepo, version);
}
template <> LIBREPOMGR_EXPORT BinaryVersion readCustomType<::LibRepoMgr::PackageBuildProgress>(BinaryDeserializer &deserializer, ::LibRepoMgr::PackageBuildProgress &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibRepoMgr::PackageBuildProgress, 1>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibRepoMgr::PackageBuildProgress");
    }
    // read members
    deserializer.read(customObject.started, version);
    deserializer.read(customObject.finished, version);
    deserializer.read(customObject.buildDirectory, version);
    deserializer.read(customObject.chrootDirectory, version);
    deserializer.read(customObject.chrootUser, version);
    deserializer.read(customObject.makechrootpkgFlags, version);
    deserializer.read(customObject.makepkgFlags, version);
    deserializer.read(customObject.packageExtension, version);
    deserializer.read(customObject.warnings, version);
    deserializer.read(customObject.error, version);
    deserializer.read(customObject.updatedVersion, version);
    deserializer.read(customObject.stagingNeeded, version);
    deserializer.read(customObject.skipChrootUpgrade, version);
    deserializer.read(customObject.skipChrootCleanup, version);
    deserializer.read(customObject.keepPreviousSourceTree, version);
    deserializer.read(customObject.checksumsUpdated, version);
    deserializer.read(customObject.hasSources, version);
    deserializer.read(customObject.addedToRepo, version);
    return version;
}

// define code for (de)serializing LibRepoMgr::RebuildInfo objects
template <> LIBREPOMGR_EXPORT void writeCustomType<::LibRepoMgr::RebuildInfo>(BinarySerializer &serializer, const ::LibRepoMgr::RebuildInfo &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibRepoMgr::RebuildInfo, 1>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.provides, version);
    serializer.write(customObject.libprovides, version);
}
template <> LIBREPOMGR_EXPORT BinaryVersion readCustomType<::LibRepoMgr::RebuildInfo>(BinaryDeserializer &deserializer, ::LibRepoMgr::RebuildInfo &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibRepoMgr::RebuildInfo, 1>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibRepoMgr::RebuildInfo");
    }
    // read members
    deserializer.read(customObject.provides, version);
    deserializer.read(customObject.libprovides, version);
    return version;
}

// define code for (de)serializing LibRepoMgr::BuildProgress objects
template <> LIBREPOMGR_EXPORT void writeCustomType<::LibRepoMgr::BuildProgress>(BinarySerializer &serializer, const ::LibRepoMgr::BuildProgress &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibRepoMgr::BuildProgress, 2>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.progressByPackage, version);
    serializer.write(customObject.targetDbFilePath, version);
    serializer.write(customObject.targetRepoPath, version);
    serializer.write(customObject.stagingDbFilePath, version);
    serializer.write(customObject.stagingRepoPath, version);
    serializer.write(customObject.producedProvides, version);
    serializer.write(customObject.removedProvides, version);
    serializer.write(customObject.rebuildList, version);
    if (version >= 2) {
        serializer.write(customObject.targetDebugDbFilePath, version);
        serializer.write(customObject.targetDebugRepoPath, version);
        serializer.write(customObject.stagingDebugDbFilePath, version);
        serializer.write(customObject.stagingDebugRepoPath, version);
    }
}
template <> LIBREPOMGR_EXPORT BinaryVersion readCustomType<::LibRepoMgr::BuildProgress>(BinaryDeserializer &deserializer, ::LibRepoMgr::BuildProgress &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibRepoMgr::BuildProgress, 2>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibRepoMgr::BuildProgress");
    }
    // read members
    deserializer.read(customObject.progressByPackage, version);
    deserializer.read(customObject.targetDbFilePath, version);
    deserializer.read(customObject.targetRepoPath, version);
    deserializer.read(customObject.stagingDbFilePath, version);
    deserializer.read(customObject.stagingRepoPath, version);
    deserializer.read(customObject.producedProvides, version);
    deserializer.read(customObject.removedProvides, version);
    deserializer.read(customObject.rebuildList, version);
    if (version >= 2) {
        deserializer.read(customObject.targetDebugDbFilePath, version);
        deserializer.read(customObject.targetDebugRepoPath, version);
        deserializer.read(customObject.stagingDebugDbFilePath, version);
        deserializer.read(customObject.stagingDebugRepoPath, version);
    }
    return version;
}

// define code for (de)serializing LibRepoMgr::PackageMovementResult objects
template <> LIBREPOMGR_EXPORT void writeCustomType<::LibRepoMgr::PackageMovementResult>(BinarySerializer &serializer, const ::LibRepoMgr::PackageMovementResult &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibRepoMgr::PackageMovementResult, 2>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.failedPackages, version);
    serializer.write(customObject.processedPackages, version);
    serializer.write(customObject.errorMessage, version);
    if (version >= 2) {
        serializer.write(customObject.processedDebugPackages, version);
    }
}
template <> LIBREPOMGR_EXPORT BinaryVersion readCustomType<::LibRepoMgr::PackageMovementResult>(BinaryDeserializer &deserializer, ::LibRepoMgr::PackageMovementResult &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibRepoMgr::PackageMovementResult, 2>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibRepoMgr::PackageMovementResult");
    }
    // read members
    deserializer.read(customObject.failedPackages, version);
    deserializer.read(customObject.processedPackages, version);
    deserializer.read(customObject.errorMessage, version);
    if (version >= 2) {
        deserializer.read(customObject.processedDebugPackages, version);
    }
    return version;
}

// define code for (de)serializing LibRepoMgr::RepositoryProblem objects
template <> LIBREPOMGR_EXPORT void writeCustomType<::LibRepoMgr::RepositoryProblem>(BinarySerializer &serializer, const ::LibRepoMgr::RepositoryProblem &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibRepoMgr::RepositoryProblem, 1>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.desc, version);
    serializer.write(customObject.pkg, version);
    serializer.write(customObject.critical, version);
}
template <> LIBREPOMGR_EXPORT BinaryVersion readCustomType<::LibRepoMgr::RepositoryProblem>(BinaryDeserializer &deserializer, ::LibRepoMgr::RepositoryProblem &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibRepoMgr::RepositoryProblem, 1>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibRepoMgr::RepositoryProblem");
    }
    // read members
    deserializer.read(customObject.desc, version);
    deserializer.read(customObject.pkg, version);
    deserializer.read(customObject.critical, version);
    return version;
}

// define code for (de)serializing LibRepoMgr::BuildActionMessages objects
template <> LIBREPOMGR_EXPORT void writeCustomType<::LibRepoMgr::BuildActionMessages>(BinarySerializer &serializer, const ::LibRepoMgr::BuildActionMessages &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibRepoMgr::BuildActionMessages, 1>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.notes, version);
    serializer.write(customObject.warnings, version);
    serializer.write(customObject.errors, version);
}
template <> LIBREPOMGR_EXPORT BinaryVersion readCustomType<::LibRepoMgr::BuildActionMessages>(BinaryDeserializer &deserializer, ::LibRepoMgr::BuildActionMessages &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibRepoMgr::BuildActionMessages, 1>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibRepoMgr::BuildActionMessages");
    }
    // read members
    deserializer.read(customObject.notes, version);
    deserializer.read(customObject.warnings, version);
    deserializer.read(customObject.errors, version);
    return version;
}

// define code for (de)serializing LibRepoMgr::BuildActionBase objects
template <> LIBREPOMGR_EXPORT void writeCustomType<::LibRepoMgr::BuildActionBase>(BinarySerializer &serializer, const ::LibRepoMgr::BuildActionBase &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibRepoMgr::BuildActionBase, 1>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.id, version);
    serializer.write(customObject.type, version);
    serializer.write(customObject.taskName, version);
    serializer.write(customObject.templateName, version);
    serializer.write(customObject.status, version);
    serializer.write(customObject.result, version);
    serializer.write(customObject.created, version);
    serializer.write(customObject.started, version);
    serializer.write(customObject.finished, version);
    serializer.write(customObject.startAfter, version);
    serializer.write(customObject.directory, version);
    serializer.write(customObject.sourceDbs, version);
    serializer.write(customObject.destinationDbs, version);
    serializer.write(customObject.packageNames, version);
    serializer.write(customObject.flags, version);
    serializer.write(customObject.settings, version);
}
template <> LIBREPOMGR_EXPORT BinaryVersion readCustomType<::LibRepoMgr::BuildActionBase>(BinaryDeserializer &deserializer, ::LibRepoMgr::BuildActionBase &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibRepoMgr::BuildActionBase, 1>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibRepoMgr::BuildActionBase");
    }
    // read members
    deserializer.read(customObject.id, version);
    deserializer.read(customObject.type, version);
    deserializer.read(customObject.taskName, version);
    deserializer.read(customObject.templateName, version);
    deserializer.read(customObject.status, version);
    deserializer.read(customObject.result, version);
    deserializer.read(customObject.created, version);
    deserializer.read(customObject.started, version);
    deserializer.read(customObject.finished, version);
    deserializer.read(customObject.startAfter, version);
    deserializer.read(customObject.directory, version);
    deserializer.read(customObject.sourceDbs, version);
    deserializer.read(customObject.destinationDbs, version);
    deserializer.read(customObject.packageNames, version);
    deserializer.read(customObject.flags, version);
    deserializer.read(customObject.settings, version);
    return version;
}

// define code for (de)serializing LibRepoMgr::BuildAction objects
template <> LIBREPOMGR_EXPORT void writeCustomType<::LibRepoMgr::BuildAction>(BinarySerializer &serializer, const ::LibRepoMgr::BuildAction &customObject, BinaryVersion version)
{
    // write base classes
    serializer.write(static_cast<const ::LibRepoMgr::BuildActionBase &>(customObject), version);
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibRepoMgr::BuildAction, 1>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.logfiles, version);
    serializer.write(customObject.artefacts, version);
    serializer.write(customObject.resultData, version);
}
template <> LIBREPOMGR_EXPORT BinaryVersion readCustomType<::LibRepoMgr::BuildAction>(BinaryDeserializer &deserializer, ::LibRepoMgr::BuildAction &customObject, BinaryVersion version)
{
    // read base classes
    deserializer.read(static_cast<::LibRepoMgr::BuildActionBase &>(customObject), version);
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibRepoMgr::BuildAction, 1>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibRepoMgr::BuildAction");
    }
    // read members
    deserializer.read(customObject.logfiles, version);
    deserializer.read(customObject.artefacts, version);
    deserializer.read(customObject.resultData, version);
    return version;
}

} // namespace BinaryReflector
} // namespace ReflectiveRapidJSON
