namespace ReflectiveRapidJSON {
namespace JsonReflector {

// define code for (de)serializing LibPkg::AurRpcResult objects
template <> LIBPKG_EXPORT void push<::LibPkg::AurRpcResult>(const ::LibPkg::AurRpcResult &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.ID, "ID", value, allocator);
    push(reflectable.Name, "Name", value, allocator);
    push(reflectable.PackageBaseID, "PackageBaseID", value, allocator);
    push(reflectable.PackageBase, "PackageBase", value, allocator);
    push(reflectable.Version, "Version", value, allocator);
    push(reflectable.Description, "Description", value, allocator);
    push(reflectable.URL, "URL", value, allocator);
    push(reflectable.NumVotes, "NumVotes", value, allocator);
    push(reflectable.Popularity, "Popularity", value, allocator);
    push(reflectable.OutOfDate, "OutOfDate", value, allocator);
    push(reflectable.Maintainer, "Maintainer", value, allocator);
    push(reflectable.FirstSubmitted, "FirstSubmitted", value, allocator);
    push(reflectable.LastModified, "LastModified", value, allocator);
    push(reflectable.URLPath, "URLPath", value, allocator);
    push(reflectable.Conflicts, "Conflicts", value, allocator);
    push(reflectable.Provides, "Provides", value, allocator);
    push(reflectable.Replaces, "Replaces", value, allocator);
    push(reflectable.Depends, "Depends", value, allocator);
    push(reflectable.MakeDepends, "MakeDepends", value, allocator);
    push(reflectable.CheckDepends, "CheckDepends", value, allocator);
    push(reflectable.OptDepends, "OptDepends", value, allocator);
    push(reflectable.License, "License", value, allocator);
    push(reflectable.Groups, "Groups", value, allocator);
    push(reflectable.Keywords, "Keywords", value, allocator);
}
template <> LIBPKG_EXPORT void pull<::LibPkg::AurRpcResult>(::LibPkg::AurRpcResult &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibPkg::AurRpcResult";
    }
    // pull members
    pull(reflectable.ID, "ID", value, errors);
    pull(reflectable.Name, "Name", value, errors);
    pull(reflectable.PackageBaseID, "PackageBaseID", value, errors);
    pull(reflectable.PackageBase, "PackageBase", value, errors);
    pull(reflectable.Version, "Version", value, errors);
    pull(reflectable.Description, "Description", value, errors);
    pull(reflectable.URL, "URL", value, errors);
    pull(reflectable.NumVotes, "NumVotes", value, errors);
    pull(reflectable.Popularity, "Popularity", value, errors);
    pull(reflectable.OutOfDate, "OutOfDate", value, errors);
    pull(reflectable.Maintainer, "Maintainer", value, errors);
    pull(reflectable.FirstSubmitted, "FirstSubmitted", value, errors);
    pull(reflectable.LastModified, "LastModified", value, errors);
    pull(reflectable.URLPath, "URLPath", value, errors);
    pull(reflectable.Conflicts, "Conflicts", value, errors);
    pull(reflectable.Provides, "Provides", value, errors);
    pull(reflectable.Replaces, "Replaces", value, errors);
    pull(reflectable.Depends, "Depends", value, errors);
    pull(reflectable.MakeDepends, "MakeDepends", value, errors);
    pull(reflectable.CheckDepends, "CheckDepends", value, errors);
    pull(reflectable.OptDepends, "OptDepends", value, errors);
    pull(reflectable.License, "License", value, errors);
    pull(reflectable.Groups, "Groups", value, errors);
    pull(reflectable.Keywords, "Keywords", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibPkg::AurRpcMultiInfo objects
template <> LIBPKG_EXPORT void push<::LibPkg::AurRpcMultiInfo>(const ::LibPkg::AurRpcMultiInfo &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.version, "version", value, allocator);
    push(reflectable.resultcount, "resultcount", value, allocator);
    push(reflectable.type, "type", value, allocator);
    push(reflectable.results, "results", value, allocator);
}
template <> LIBPKG_EXPORT void pull<::LibPkg::AurRpcMultiInfo>(::LibPkg::AurRpcMultiInfo &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibPkg::AurRpcMultiInfo";
    }
    // pull members
    pull(reflectable.version, "version", value, errors);
    pull(reflectable.resultcount, "resultcount", value, errors);
    pull(reflectable.type, "type", value, errors);
    pull(reflectable.results, "results", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

} // namespace JsonReflector
} // namespace ReflectiveRapidJSON
