namespace ReflectiveRapidJSON {
namespace JsonReflector {

// define code for (de)serializing LibPkg::Dependency objects
template <> LIBPKG_EXPORT void push<::LibPkg::Dependency>(const ::LibPkg::Dependency &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.name, "name", value, allocator);
    push(reflectable.version, "version", value, allocator);
    push(reflectable.description, "description", value, allocator);
    push(reflectable.mode, "mode", value, allocator);
}
template <> LIBPKG_EXPORT void pull<::LibPkg::Dependency>(::LibPkg::Dependency &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibPkg::Dependency";
    }
    // pull members
    pull(reflectable.name, "name", value, errors);
    pull(reflectable.version, "version", value, errors);
    pull(reflectable.description, "description", value, errors);
    pull(reflectable.mode, "mode", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibPkg::DatabaseDependency objects
template <> LIBPKG_EXPORT void push<::LibPkg::DatabaseDependency>(const ::LibPkg::DatabaseDependency &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    push(static_cast<const ::LibPkg::Dependency &>(reflectable), value, allocator);
    // push members
    push(reflectable.relevantPackages, "relevantPackages", value, allocator);
}
template <> LIBPKG_EXPORT void pull<::LibPkg::DatabaseDependency>(::LibPkg::DatabaseDependency &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    pull(static_cast<::LibPkg::Dependency &>(reflectable), value, errors);
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibPkg::DatabaseDependency";
    }
    // pull members
    pull(reflectable.relevantPackages, "relevantPackages", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibPkg::DatabaseLibraryDependency objects
template <> LIBPKG_EXPORT void push<::LibPkg::DatabaseLibraryDependency>(const ::LibPkg::DatabaseLibraryDependency &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.name, "name", value, allocator);
    push(reflectable.relevantPackages, "relevantPackages", value, allocator);
}
template <> LIBPKG_EXPORT void pull<::LibPkg::DatabaseLibraryDependency>(::LibPkg::DatabaseLibraryDependency &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibPkg::DatabaseLibraryDependency";
    }
    // pull members
    pull(reflectable.name, "name", value, errors);
    pull(reflectable.relevantPackages, "relevantPackages", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibPkg::SourceFile objects
template <> LIBPKG_EXPORT void push<::LibPkg::SourceFile>(const ::LibPkg::SourceFile &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.path, "path", value, allocator);
    push(reflectable.contents, "contents", value, allocator);
}
template <> LIBPKG_EXPORT void pull<::LibPkg::SourceFile>(::LibPkg::SourceFile &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibPkg::SourceFile";
    }
    // pull members
    pull(reflectable.path, "path", value, errors);
    pull(reflectable.contents, "contents", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibPkg::SourceInfo objects
template <> LIBPKG_EXPORT void push<::LibPkg::SourceInfo>(const ::LibPkg::SourceInfo &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.name, "name", value, allocator);
    push(reflectable.archs, "archs", value, allocator);
    push(reflectable.makeDependencies, "makeDependencies", value, allocator);
    push(reflectable.checkDependencies, "checkDependencies", value, allocator);
    push(reflectable.maintainer, "maintainer", value, allocator);
    push(reflectable.id, "id", value, allocator);
    push(reflectable.category, "category", value, allocator);
    push(reflectable.votes, "votes", value, allocator);
    push(reflectable.outOfDate, "outOfDate", value, allocator);
    push(reflectable.firstSubmitted, "firstSubmitted", value, allocator);
    push(reflectable.lastModified, "lastModified", value, allocator);
    push(reflectable.url, "url", value, allocator);
    push(reflectable.sources, "sources", value, allocator);
    push(reflectable.directory, "directory", value, allocator);
}
template <> LIBPKG_EXPORT void pull<::LibPkg::SourceInfo>(::LibPkg::SourceInfo &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibPkg::SourceInfo";
    }
    // pull members
    pull(reflectable.name, "name", value, errors);
    pull(reflectable.archs, "archs", value, errors);
    pull(reflectable.makeDependencies, "makeDependencies", value, errors);
    pull(reflectable.checkDependencies, "checkDependencies", value, errors);
    pull(reflectable.maintainer, "maintainer", value, errors);
    pull(reflectable.id, "id", value, errors);
    pull(reflectable.category, "category", value, errors);
    pull(reflectable.votes, "votes", value, errors);
    pull(reflectable.outOfDate, "outOfDate", value, errors);
    pull(reflectable.firstSubmitted, "firstSubmitted", value, errors);
    pull(reflectable.lastModified, "lastModified", value, errors);
    pull(reflectable.url, "url", value, errors);
    pull(reflectable.sources, "sources", value, errors);
    pull(reflectable.directory, "directory", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibPkg::PackageInfo objects
template <> LIBPKG_EXPORT void push<::LibPkg::PackageInfo>(const ::LibPkg::PackageInfo &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.fileName, "fileName", value, allocator);
    push(reflectable.files, "files", value, allocator);
    push(reflectable.buildDate, "buildDate", value, allocator);
    push(reflectable.packager, "packager", value, allocator);
    push(reflectable.md5, "md5", value, allocator);
    push(reflectable.sha256, "sha256", value, allocator);
    push(reflectable.pgpSignature, "pgpSignature", value, allocator);
    push(reflectable.size, "size", value, allocator);
}
template <> LIBPKG_EXPORT void pull<::LibPkg::PackageInfo>(::LibPkg::PackageInfo &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibPkg::PackageInfo";
    }
    // pull members
    pull(reflectable.fileName, "fileName", value, errors);
    pull(reflectable.files, "files", value, errors);
    pull(reflectable.buildDate, "buildDate", value, errors);
    pull(reflectable.packager, "packager", value, errors);
    pull(reflectable.md5, "md5", value, errors);
    pull(reflectable.sha256, "sha256", value, errors);
    pull(reflectable.pgpSignature, "pgpSignature", value, errors);
    pull(reflectable.size, "size", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibPkg::InstallInfo objects
template <> LIBPKG_EXPORT void push<::LibPkg::InstallInfo>(const ::LibPkg::InstallInfo &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.installDate, "installDate", value, allocator);
    push(reflectable.installedSize, "installedSize", value, allocator);
    push(reflectable.backupFiles, "backupFiles", value, allocator);
    push(reflectable.installStatus, "installStatus", value, allocator);
    push(reflectable.validationMethods, "validationMethods", value, allocator);
}
template <> LIBPKG_EXPORT void pull<::LibPkg::InstallInfo>(::LibPkg::InstallInfo &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibPkg::InstallInfo";
    }
    // pull members
    pull(reflectable.installDate, "installDate", value, errors);
    pull(reflectable.installedSize, "installedSize", value, errors);
    pull(reflectable.backupFiles, "backupFiles", value, errors);
    pull(reflectable.installStatus, "installStatus", value, errors);
    pull(reflectable.validationMethods, "validationMethods", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibPkg::PackageVersion objects
template <> LIBPKG_EXPORT void push<::LibPkg::PackageVersion>(const ::LibPkg::PackageVersion &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.epoch, "epoch", value, allocator);
    push(reflectable.upstream, "upstream", value, allocator);
    push(reflectable.package, "package", value, allocator);
}
template <> LIBPKG_EXPORT void pull<::LibPkg::PackageVersion>(::LibPkg::PackageVersion &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibPkg::PackageVersion";
    }
    // pull members
    pull(reflectable.epoch, "epoch", value, errors);
    pull(reflectable.upstream, "upstream", value, errors);
    pull(reflectable.package, "package", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibPkg::PackageBase objects
template <> LIBPKG_EXPORT void push<::LibPkg::PackageBase>(const ::LibPkg::PackageBase &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.origin, "origin", value, allocator);
    push(reflectable.timestamp, "timestamp", value, allocator);
    push(reflectable.buildDate, "buildDate", value, allocator);
    push(reflectable.name, "name", value, allocator);
    push(reflectable.version, "version", value, allocator);
    push(reflectable.arch, "arch", value, allocator);
    push(reflectable.archs, "archs", value, allocator);
    push(reflectable.description, "description", value, allocator);
}
template <> LIBPKG_EXPORT void pull<::LibPkg::PackageBase>(::LibPkg::PackageBase &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibPkg::PackageBase";
    }
    // pull members
    pull(reflectable.origin, "origin", value, errors);
    pull(reflectable.timestamp, "timestamp", value, errors);
    pull(reflectable.buildDate, "buildDate", value, errors);
    pull(reflectable.name, "name", value, errors);
    pull(reflectable.version, "version", value, errors);
    pull(reflectable.arch, "arch", value, errors);
    pull(reflectable.archs, "archs", value, errors);
    pull(reflectable.description, "description", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibPkg::Package objects
template <> LIBPKG_EXPORT void push<::LibPkg::Package>(const ::LibPkg::Package &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    push(static_cast<const ::LibPkg::PackageBase &>(reflectable), value, allocator);
    // push members
    push(reflectable.upstreamUrl, "upstreamUrl", value, allocator);
    push(reflectable.licenses, "licenses", value, allocator);
    push(reflectable.groups, "groups", value, allocator);
    push(reflectable.dependencies, "dependencies", value, allocator);
    push(reflectable.optionalDependencies, "optionalDependencies", value, allocator);
    push(reflectable.conflicts, "conflicts", value, allocator);
    push(reflectable.provides, "provides", value, allocator);
    push(reflectable.replaces, "replaces", value, allocator);
    push(reflectable.libprovides, "libprovides", value, allocator);
    push(reflectable.libdepends, "libdepends", value, allocator);
    push(reflectable.sourceInfo, "sourceInfo", value, allocator);
    push(reflectable.packageInfo, "packageInfo", value, allocator);
    push(reflectable.installInfo, "installInfo", value, allocator);
}
template <> LIBPKG_EXPORT void pull<::LibPkg::Package>(::LibPkg::Package &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    pull(static_cast<::LibPkg::PackageBase &>(reflectable), value, errors);
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibPkg::Package";
    }
    // pull members
    pull(reflectable.upstreamUrl, "upstreamUrl", value, errors);
    pull(reflectable.licenses, "licenses", value, errors);
    pull(reflectable.groups, "groups", value, errors);
    pull(reflectable.dependencies, "dependencies", value, errors);
    pull(reflectable.optionalDependencies, "optionalDependencies", value, errors);
    pull(reflectable.conflicts, "conflicts", value, errors);
    pull(reflectable.provides, "provides", value, errors);
    pull(reflectable.replaces, "replaces", value, errors);
    pull(reflectable.libprovides, "libprovides", value, errors);
    pull(reflectable.libdepends, "libdepends", value, errors);
    pull(reflectable.sourceInfo, "sourceInfo", value, errors);
    pull(reflectable.packageInfo, "packageInfo", value, errors);
    pull(reflectable.installInfo, "installInfo", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibPkg::DependencyDetail objects
template <> LIBPKG_EXPORT void push<::LibPkg::DependencyDetail>(const ::LibPkg::DependencyDetail &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.version, "version", value, allocator);
    push(reflectable.mode, "mode", value, allocator);
    push(reflectable.relevantPackages, "relevantPackages", value, allocator);
}
template <> LIBPKG_EXPORT void pull<::LibPkg::DependencyDetail>(::LibPkg::DependencyDetail &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibPkg::DependencyDetail";
    }
    // pull members
    pull(reflectable.version, "version", value, errors);
    pull(reflectable.mode, "mode", value, errors);
    pull(reflectable.relevantPackages, "relevantPackages", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

} // namespace JsonReflector
} // namespace ReflectiveRapidJSON
namespace ReflectiveRapidJSON {
namespace BinaryReflector {

// define code for (de)serializing LibPkg::Dependency objects
template <> LIBPKG_EXPORT void writeCustomType<::LibPkg::Dependency>(BinarySerializer &serializer, const ::LibPkg::Dependency &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::Dependency>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.name, version);
    serializer.write(customObject.version, version);
    serializer.write(customObject.description, version);
    serializer.write(customObject.mode, version);
}
template <> LIBPKG_EXPORT BinaryVersion readCustomType<::LibPkg::Dependency>(BinaryDeserializer &deserializer, ::LibPkg::Dependency &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::Dependency>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibPkg::Dependency");
    }
    // read members
    deserializer.read(customObject.name, version);
    deserializer.read(customObject.version, version);
    deserializer.read(customObject.description, version);
    deserializer.read(customObject.mode, version);
    return version;
}

// define code for (de)serializing LibPkg::DatabaseDependency objects
template <> LIBPKG_EXPORT void writeCustomType<::LibPkg::DatabaseDependency>(BinarySerializer &serializer, const ::LibPkg::DatabaseDependency &customObject, BinaryVersion version)
{
    // write base classes
    serializer.write(static_cast<const ::LibPkg::Dependency &>(customObject), version);
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::DatabaseDependency, 1>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.relevantPackages, version);
}
template <> LIBPKG_EXPORT BinaryVersion readCustomType<::LibPkg::DatabaseDependency>(BinaryDeserializer &deserializer, ::LibPkg::DatabaseDependency &customObject, BinaryVersion version)
{
    // read base classes
    deserializer.read(static_cast<::LibPkg::Dependency &>(customObject), version);
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::DatabaseDependency, 1>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibPkg::DatabaseDependency");
    }
    // read members
    deserializer.read(customObject.relevantPackages, version);
    return version;
}

// define code for (de)serializing LibPkg::DatabaseLibraryDependency objects
template <> LIBPKG_EXPORT void writeCustomType<::LibPkg::DatabaseLibraryDependency>(BinarySerializer &serializer, const ::LibPkg::DatabaseLibraryDependency &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::DatabaseLibraryDependency, 1>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.name, version);
    serializer.write(customObject.relevantPackages, version);
}
template <> LIBPKG_EXPORT BinaryVersion readCustomType<::LibPkg::DatabaseLibraryDependency>(BinaryDeserializer &deserializer, ::LibPkg::DatabaseLibraryDependency &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::DatabaseLibraryDependency, 1>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibPkg::DatabaseLibraryDependency");
    }
    // read members
    deserializer.read(customObject.name, version);
    deserializer.read(customObject.relevantPackages, version);
    return version;
}

// define code for (de)serializing LibPkg::SourceFile objects
template <> LIBPKG_EXPORT void writeCustomType<::LibPkg::SourceFile>(BinarySerializer &serializer, const ::LibPkg::SourceFile &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::SourceFile>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.path, version);
    serializer.write(customObject.contents, version);
}
template <> LIBPKG_EXPORT BinaryVersion readCustomType<::LibPkg::SourceFile>(BinaryDeserializer &deserializer, ::LibPkg::SourceFile &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::SourceFile>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibPkg::SourceFile");
    }
    // read members
    deserializer.read(customObject.path, version);
    deserializer.read(customObject.contents, version);
    return version;
}

// define code for (de)serializing LibPkg::SourceInfo objects
template <> LIBPKG_EXPORT void writeCustomType<::LibPkg::SourceInfo>(BinarySerializer &serializer, const ::LibPkg::SourceInfo &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::SourceInfo>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.name, version);
    serializer.write(customObject.archs, version);
    serializer.write(customObject.makeDependencies, version);
    serializer.write(customObject.checkDependencies, version);
    serializer.write(customObject.maintainer, version);
    serializer.write(customObject.id, version);
    serializer.write(customObject.category, version);
    serializer.write(customObject.votes, version);
    serializer.write(customObject.outOfDate, version);
    serializer.write(customObject.firstSubmitted, version);
    serializer.write(customObject.lastModified, version);
    serializer.write(customObject.url, version);
    serializer.write(customObject.sources, version);
    serializer.write(customObject.directory, version);
}
template <> LIBPKG_EXPORT BinaryVersion readCustomType<::LibPkg::SourceInfo>(BinaryDeserializer &deserializer, ::LibPkg::SourceInfo &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::SourceInfo>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibPkg::SourceInfo");
    }
    // read members
    deserializer.read(customObject.name, version);
    deserializer.read(customObject.archs, version);
    deserializer.read(customObject.makeDependencies, version);
    deserializer.read(customObject.checkDependencies, version);
    deserializer.read(customObject.maintainer, version);
    deserializer.read(customObject.id, version);
    deserializer.read(customObject.category, version);
    deserializer.read(customObject.votes, version);
    deserializer.read(customObject.outOfDate, version);
    deserializer.read(customObject.firstSubmitted, version);
    deserializer.read(customObject.lastModified, version);
    deserializer.read(customObject.url, version);
    deserializer.read(customObject.sources, version);
    deserializer.read(customObject.directory, version);
    return version;
}

// define code for (de)serializing LibPkg::PackageInfo objects
template <> LIBPKG_EXPORT void writeCustomType<::LibPkg::PackageInfo>(BinarySerializer &serializer, const ::LibPkg::PackageInfo &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::PackageInfo>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.fileName, version);
    serializer.write(customObject.files, version);
    serializer.write(customObject.buildDate, version);
    serializer.write(customObject.packager, version);
    serializer.write(customObject.md5, version);
    serializer.write(customObject.sha256, version);
    serializer.write(customObject.pgpSignature, version);
    serializer.write(customObject.size, version);
}
template <> LIBPKG_EXPORT BinaryVersion readCustomType<::LibPkg::PackageInfo>(BinaryDeserializer &deserializer, ::LibPkg::PackageInfo &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::PackageInfo>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibPkg::PackageInfo");
    }
    // read members
    deserializer.read(customObject.fileName, version);
    deserializer.read(customObject.files, version);
    deserializer.read(customObject.buildDate, version);
    deserializer.read(customObject.packager, version);
    deserializer.read(customObject.md5, version);
    deserializer.read(customObject.sha256, version);
    deserializer.read(customObject.pgpSignature, version);
    deserializer.read(customObject.size, version);
    return version;
}

// define code for (de)serializing LibPkg::InstallInfo objects
template <> LIBPKG_EXPORT void writeCustomType<::LibPkg::InstallInfo>(BinarySerializer &serializer, const ::LibPkg::InstallInfo &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::InstallInfo>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.installDate, version);
    serializer.write(customObject.installedSize, version);
    serializer.write(customObject.backupFiles, version);
    serializer.write(customObject.installStatus, version);
    serializer.write(customObject.validationMethods, version);
}
template <> LIBPKG_EXPORT BinaryVersion readCustomType<::LibPkg::InstallInfo>(BinaryDeserializer &deserializer, ::LibPkg::InstallInfo &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::InstallInfo>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibPkg::InstallInfo");
    }
    // read members
    deserializer.read(customObject.installDate, version);
    deserializer.read(customObject.installedSize, version);
    deserializer.read(customObject.backupFiles, version);
    deserializer.read(customObject.installStatus, version);
    deserializer.read(customObject.validationMethods, version);
    return version;
}

// define code for (de)serializing LibPkg::PackageBase objects
template <> LIBPKG_EXPORT void writeCustomType<::LibPkg::PackageBase>(BinarySerializer &serializer, const ::LibPkg::PackageBase &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::PackageBase, 1>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.origin, version);
    serializer.write(customObject.timestamp, version);
    serializer.write(customObject.buildDate, version);
    serializer.write(customObject.name, version);
    serializer.write(customObject.version, version);
    serializer.write(customObject.arch, version);
    serializer.write(customObject.archs, version);
    serializer.write(customObject.description, version);
}
template <> LIBPKG_EXPORT BinaryVersion readCustomType<::LibPkg::PackageBase>(BinaryDeserializer &deserializer, ::LibPkg::PackageBase &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::PackageBase, 1>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibPkg::PackageBase");
    }
    // read members
    deserializer.read(customObject.origin, version);
    deserializer.read(customObject.timestamp, version);
    deserializer.read(customObject.buildDate, version);
    deserializer.read(customObject.name, version);
    deserializer.read(customObject.version, version);
    deserializer.read(customObject.arch, version);
    deserializer.read(customObject.archs, version);
    deserializer.read(customObject.description, version);
    return version;
}

// define code for (de)serializing LibPkg::Package objects
template <> LIBPKG_EXPORT void writeCustomType<::LibPkg::Package>(BinarySerializer &serializer, const ::LibPkg::Package &customObject, BinaryVersion version)
{
    // write base classes
    serializer.write(static_cast<const ::LibPkg::PackageBase &>(customObject), version);
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::Package, 1>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.upstreamUrl, version);
    serializer.write(customObject.licenses, version);
    serializer.write(customObject.groups, version);
    serializer.write(customObject.dependencies, version);
    serializer.write(customObject.optionalDependencies, version);
    serializer.write(customObject.conflicts, version);
    serializer.write(customObject.provides, version);
    serializer.write(customObject.replaces, version);
    serializer.write(customObject.libprovides, version);
    serializer.write(customObject.libdepends, version);
    serializer.write(customObject.sourceInfo, version);
    serializer.write(customObject.packageInfo, version);
    serializer.write(customObject.installInfo, version);
}
template <> LIBPKG_EXPORT BinaryVersion readCustomType<::LibPkg::Package>(BinaryDeserializer &deserializer, ::LibPkg::Package &customObject, BinaryVersion version)
{
    // read base classes
    deserializer.read(static_cast<::LibPkg::PackageBase &>(customObject), version);
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::Package, 1>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibPkg::Package");
    }
    // read members
    deserializer.read(customObject.upstreamUrl, version);
    deserializer.read(customObject.licenses, version);
    deserializer.read(customObject.groups, version);
    deserializer.read(customObject.dependencies, version);
    deserializer.read(customObject.optionalDependencies, version);
    deserializer.read(customObject.conflicts, version);
    deserializer.read(customObject.provides, version);
    deserializer.read(customObject.replaces, version);
    deserializer.read(customObject.libprovides, version);
    deserializer.read(customObject.libdepends, version);
    deserializer.read(customObject.sourceInfo, version);
    deserializer.read(customObject.packageInfo, version);
    deserializer.read(customObject.installInfo, version);
    return version;
}

// define code for (de)serializing LibPkg::DependencyDetail objects
template <> LIBPKG_EXPORT void writeCustomType<::LibPkg::DependencyDetail>(BinarySerializer &serializer, const ::LibPkg::DependencyDetail &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::DependencyDetail>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.version, version);
    serializer.write(customObject.mode, version);
    serializer.write(customObject.relevantPackages, version);
}
template <> LIBPKG_EXPORT BinaryVersion readCustomType<::LibPkg::DependencyDetail>(BinaryDeserializer &deserializer, ::LibPkg::DependencyDetail &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::DependencyDetail>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibPkg::DependencyDetail");
    }
    // read members
    deserializer.read(customObject.version, version);
    deserializer.read(customObject.mode, version);
    deserializer.read(customObject.relevantPackages, version);
    return version;
}

} // namespace BinaryReflector
} // namespace ReflectiveRapidJSON
