namespace ReflectiveRapidJSON {
namespace JsonReflector {

// define code for (de)serializing LibPkg::PackageUpdate objects
template <> LIBPKG_EXPORT void push<::LibPkg::PackageUpdate>(const ::LibPkg::PackageUpdate &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.oldVersion, "oldVersion", value, allocator);
    push(reflectable.newVersion, "newVersion", value, allocator);
}
template <> LIBPKG_EXPORT void pull<::LibPkg::PackageUpdate>(::LibPkg::PackageUpdate &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibPkg::PackageUpdate";
    }
    // pull members
    pull(reflectable.oldVersion, "oldVersion", value, errors);
    pull(reflectable.newVersion, "newVersion", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibPkg::PackageUpdates objects
template <> LIBPKG_EXPORT void push<::LibPkg::PackageUpdates>(const ::LibPkg::PackageUpdates &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.versionUpdates, "versionUpdates", value, allocator);
    push(reflectable.packageUpdates, "packageUpdates", value, allocator);
    push(reflectable.downgrades, "downgrades", value, allocator);
    push(reflectable.orphans, "orphans", value, allocator);
}
template <> LIBPKG_EXPORT void pull<::LibPkg::PackageUpdates>(::LibPkg::PackageUpdates &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibPkg::PackageUpdates";
    }
    // pull members
    pull(reflectable.versionUpdates, "versionUpdates", value, errors);
    pull(reflectable.packageUpdates, "packageUpdates", value, errors);
    pull(reflectable.downgrades, "downgrades", value, errors);
    pull(reflectable.orphans, "orphans", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibPkg::UnresolvedDependencies objects
template <> LIBPKG_EXPORT void push<::LibPkg::UnresolvedDependencies>(const ::LibPkg::UnresolvedDependencies &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.deps, "deps", value, allocator);
    push(reflectable.libs, "libs", value, allocator);
}
template <> LIBPKG_EXPORT void pull<::LibPkg::UnresolvedDependencies>(::LibPkg::UnresolvedDependencies &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibPkg::UnresolvedDependencies";
    }
    // pull members
    pull(reflectable.deps, "deps", value, errors);
    pull(reflectable.libs, "libs", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibPkg::Database objects
template <> LIBPKG_EXPORT void push<::LibPkg::Database>(const ::LibPkg::Database &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.name, "name", value, allocator);
    push(reflectable.path, "path", value, allocator);
    push(reflectable.filesPath, "filesPath", value, allocator);
    push(reflectable.mirrors, "mirrors", value, allocator);
    push(reflectable.usage, "usage", value, allocator);
    push(reflectable.signatureLevel, "signatureLevel", value, allocator);
    push(reflectable.arch, "arch", value, allocator);
    push(reflectable.dependencies, "dependencies", value, allocator);
    push(reflectable.localPkgDir, "localPkgDir", value, allocator);
    push(reflectable.localDbDir, "localDbDir", value, allocator);
    push(reflectable.lastUpdate, "lastUpdate", value, allocator);
    push(reflectable.syncFromMirror, "syncFromMirror", value, allocator);
    push(reflectable.toBeDiscarded, "toBeDiscarded", value, allocator);
}
template <> LIBPKG_EXPORT void pull<::LibPkg::Database>(::LibPkg::Database &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibPkg::Database";
    }
    // pull members
    pull(reflectable.name, "name", value, errors);
    pull(reflectable.path, "path", value, errors);
    pull(reflectable.filesPath, "filesPath", value, errors);
    pull(reflectable.mirrors, "mirrors", value, errors);
    pull(reflectable.usage, "usage", value, errors);
    pull(reflectable.signatureLevel, "signatureLevel", value, errors);
    pull(reflectable.arch, "arch", value, errors);
    pull(reflectable.dependencies, "dependencies", value, errors);
    pull(reflectable.localPkgDir, "localPkgDir", value, errors);
    pull(reflectable.localDbDir, "localDbDir", value, errors);
    pull(reflectable.lastUpdate, "lastUpdate", value, errors);
    pull(reflectable.syncFromMirror, "syncFromMirror", value, errors);
    pull(reflectable.toBeDiscarded, "toBeDiscarded", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

} // namespace JsonReflector
} // namespace ReflectiveRapidJSON
namespace ReflectiveRapidJSON {
namespace BinaryReflector {

// define code for (de)serializing LibPkg::PackageUpdate objects
template <> LIBPKG_EXPORT void writeCustomType<::LibPkg::PackageUpdate>(BinarySerializer &serializer, const ::LibPkg::PackageUpdate &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::PackageUpdate>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.oldVersion, version);
    serializer.write(customObject.newVersion, version);
}
template <> LIBPKG_EXPORT BinaryVersion readCustomType<::LibPkg::PackageUpdate>(BinaryDeserializer &deserializer, ::LibPkg::PackageUpdate &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::PackageUpdate>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibPkg::PackageUpdate");
    }
    // read members
    deserializer.read(customObject.oldVersion, version);
    deserializer.read(customObject.newVersion, version);
    return version;
}

// define code for (de)serializing LibPkg::PackageUpdates objects
template <> LIBPKG_EXPORT void writeCustomType<::LibPkg::PackageUpdates>(BinarySerializer &serializer, const ::LibPkg::PackageUpdates &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::PackageUpdates, 1>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.versionUpdates, version);
    serializer.write(customObject.packageUpdates, version);
    serializer.write(customObject.downgrades, version);
    serializer.write(customObject.orphans, version);
}
template <> LIBPKG_EXPORT BinaryVersion readCustomType<::LibPkg::PackageUpdates>(BinaryDeserializer &deserializer, ::LibPkg::PackageUpdates &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::PackageUpdates, 1>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibPkg::PackageUpdates");
    }
    // read members
    deserializer.read(customObject.versionUpdates, version);
    deserializer.read(customObject.packageUpdates, version);
    deserializer.read(customObject.downgrades, version);
    deserializer.read(customObject.orphans, version);
    return version;
}

// define code for (de)serializing LibPkg::UnresolvedDependencies objects
template <> LIBPKG_EXPORT void writeCustomType<::LibPkg::UnresolvedDependencies>(BinarySerializer &serializer, const ::LibPkg::UnresolvedDependencies &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::UnresolvedDependencies, 1>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.deps, version);
    serializer.write(customObject.libs, version);
}
template <> LIBPKG_EXPORT BinaryVersion readCustomType<::LibPkg::UnresolvedDependencies>(BinaryDeserializer &deserializer, ::LibPkg::UnresolvedDependencies &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::UnresolvedDependencies, 1>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibPkg::UnresolvedDependencies");
    }
    // read members
    deserializer.read(customObject.deps, version);
    deserializer.read(customObject.libs, version);
    return version;
}

// define code for (de)serializing LibPkg::Database objects
template <> LIBPKG_EXPORT void writeCustomType<::LibPkg::Database>(BinarySerializer &serializer, const ::LibPkg::Database &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::Database>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.name, version);
    serializer.write(customObject.path, version);
    serializer.write(customObject.filesPath, version);
    serializer.write(customObject.mirrors, version);
    serializer.write(customObject.usage, version);
    serializer.write(customObject.signatureLevel, version);
    serializer.write(customObject.arch, version);
    serializer.write(customObject.dependencies, version);
    serializer.write(customObject.localPkgDir, version);
    serializer.write(customObject.localDbDir, version);
    serializer.write(customObject.lastUpdate, version);
    serializer.write(customObject.syncFromMirror, version);
    serializer.write(customObject.toBeDiscarded, version);
}
template <> LIBPKG_EXPORT BinaryVersion readCustomType<::LibPkg::Database>(BinaryDeserializer &deserializer, ::LibPkg::Database &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::Database>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibPkg::Database");
    }
    // read members
    deserializer.read(customObject.name, version);
    deserializer.read(customObject.path, version);
    deserializer.read(customObject.filesPath, version);
    deserializer.read(customObject.mirrors, version);
    deserializer.read(customObject.usage, version);
    deserializer.read(customObject.signatureLevel, version);
    deserializer.read(customObject.arch, version);
    deserializer.read(customObject.dependencies, version);
    deserializer.read(customObject.localPkgDir, version);
    deserializer.read(customObject.localDbDir, version);
    deserializer.read(customObject.lastUpdate, version);
    deserializer.read(customObject.syncFromMirror, version);
    deserializer.read(customObject.toBeDiscarded, version);
    return version;
}

} // namespace BinaryReflector
} // namespace ReflectiveRapidJSON
