/***************************************************************************
 *   Copyright (c) 2005-2024  by Pierre-Henri WUILLEMIN et Christophe GONZALES   *
 *   {prenom.nom}_at_lip6.fr                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/**
 * @file
 * @brief This file contains definition for a BNGenerator
 *
 * @author Pierre-Henri WUILLEMIN
 */

#include <agrum/BN/generator/MCBayesNetGenerator.h>

class BNGenerator {
  public:
  gum::BayesNet< double >
     generate(gum::Size n_nodes = 10, gum::Size n_arcs = 15, gum::Size n_modmax = 4) {
    if (n_arcs > n_nodes * (n_nodes + 1) / 2)
      GUM_ERROR(gum::OperationNotAllowed, "Too many arcs for a BN")

    gum::BayesNet< double > bn;

    gum::MCBayesNetGenerator< double > gen(n_nodes, n_arcs, n_modmax);
    gen.generateBN(bn);

    return bn;
  }
};
