/****************************************************************************
 *   This file is part of the aGrUM/pyAgrum library.                        *
 *                                                                          *
 *   Copyright (c) 2005-2025 by                                             *
 *       - Pierre-Henri WUILLEMIN(_at_LIP6)                                 *
 *       - Christophe GONZALES(_at_AMU)                                     *
 *                                                                          *
 *   The aGrUM/pyAgrum library is free software; you can redistribute it    *
 *   and/or modify it under the terms of either :                           *
 *                                                                          *
 *    - the GNU Lesser General Public License as published by               *
 *      the Free Software Foundation, either version 3 of the License,      *
 *      or (at your option) any later version,                              *
 *    - the MIT license (MIT),                                              *
 *    - or both in dual license, as here.                                   *
 *                                                                          *
 *   (see https://agrum.gitlab.io/articles/dual-licenses-lgplv3mit.html)    *
 *                                                                          *
 *   This aGrUM/pyAgrum library is distributed in the hope that it will be  *
 *   useful, but WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,          *
 *   INCLUDING BUT NOT LIMITED TO THE WARRANTIES MERCHANTABILITY or FITNESS *
 *   FOR A PARTICULAR PURPOSE  AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 *   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 *   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,        *
 *   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR  *
 *   OTHER DEALINGS IN THE SOFTWARE.                                        *
 *                                                                          *
 *   See LICENCES for more details.                                         *
 *                                                                          *
 *   SPDX-FileCopyrightText: Copyright 2005-2025                            *
 *       - Pierre-Henri WUILLEMIN(_at_LIP6)                                 *
 *       - Christophe GONZALES(_at_AMU)                                     *
 *   SPDX-License-Identifier: LGPL-3.0-or-later OR MIT                      *
 *                                                                          *
 *   Contact  : info_at_agrum_dot_org                                       *
 *   homepage : http://agrum.gitlab.io                                      *
 *   gitlab   : https://gitlab.com/agrumery/agrum                           *
 *                                                                          *
 ****************************************************************************/


/**
 * @file
 * @brief The class for computing Log2 (Gamma(x)).
 *
 * @author Christophe GONZALES(_at_AMU) and Pierre-Henri WUILLEMIN(_at_LIP6)
 */

#include <agrum/base/core/math/gammaLog2.h>

#ifdef GUM_NO_INLINE
#  include <agrum/base/core/math/gammaLog2_inl.h>
#endif   // GUM_NO_INLINE

namespace gum {

  // @brief Default constructor.
  GammaLog2::GammaLog2(bool requires_precision) : _requires_precision_{requires_precision} {
    GUM_CONSTRUCTOR(GammaLog2);
  }

  // @brief Copy constructor.
  GammaLog2::GammaLog2(const GammaLog2& from) : _requires_precision_{from._requires_precision_} {
    GUM_CONS_CPY(GammaLog2);
  }

  // @brief Move constructor.
  GammaLog2::GammaLog2(GammaLog2&& from) : _requires_precision_{from._requires_precision_} {
    GUM_CONS_MOV(GammaLog2);
  }

  // @brief Class destructor.
  GammaLog2::~GammaLog2() {
    GUM_DESTRUCTOR(GammaLog2);
    ;
  }

  // the Log2 (gamma (x)) for x varying from 0 to 50 by step of 1/100
  const std::vector< double > GammaLog2::_small_values_{std::numeric_limits< double >::max(),
                                                        6.635647,
                                                        5.627671,
                                                        5.034964,
                                                        4.612409,
                                                        4.283187,
                                                        4.013081,
                                                        3.783834,
                                                        3.584550,
                                                        3.408198,
                                                        3.249977,
                                                        3.106463,
                                                        2.975126,
                                                        2.854044,
                                                        2.741723,
                                                        2.636978,
                                                        2.538853,
                                                        2.446567,
                                                        2.359471,
                                                        2.277022,
                                                        2.198759,
                                                        2.124291,
                                                        2.053279,
                                                        1.985429,
                                                        1.920486,
                                                        1.858224,
                                                        1.798445,
                                                        1.740972,
                                                        1.685649,
                                                        1.632335,
                                                        1.580902,
                                                        1.531237,
                                                        1.483236,
                                                        1.436805,
                                                        1.391857,
                                                        1.348316,
                                                        1.306108,
                                                        1.265167,
                                                        1.225433,
                                                        1.186849,
                                                        1.149363,
                                                        1.112927,
                                                        1.077497,
                                                        1.043029,
                                                        1.009486,
                                                        0.976830,
                                                        0.945028,
                                                        0.914048,
                                                        0.883860,
                                                        0.854436,
                                                        0.825748,
                                                        0.797773,
                                                        0.770486,
                                                        0.743865,
                                                        0.717889,
                                                        0.692538,
                                                        0.667794,
                                                        0.643637,
                                                        0.620052,
                                                        0.597021,
                                                        0.574530,
                                                        0.552564,
                                                        0.531108,
                                                        0.510149,
                                                        0.489675,
                                                        0.469673,
                                                        0.450131,
                                                        0.431039,
                                                        0.412385,
                                                        0.394159,
                                                        0.376352,
                                                        0.358954,
                                                        0.341955,
                                                        0.325348,
                                                        0.309123,
                                                        0.293272,
                                                        0.277789,
                                                        0.262665,
                                                        0.247892,
                                                        0.233465,
                                                        0.219376,
                                                        0.205618,
                                                        0.192187,
                                                        0.179074,
                                                        0.166275,
                                                        0.153784,
                                                        0.141596,
                                                        0.129704,
                                                        0.118104,
                                                        0.106791,
                                                        0.095761,
                                                        0.085007,
                                                        0.074527,
                                                        0.064315,
                                                        0.054367,
                                                        0.044679,
                                                        0.035246,
                                                        0.026066,
                                                        0.017134,
                                                        0.008447,
                                                        0.000000,
                                                        -0.008209,
                                                        -0.016185,
                                                        -0.023930,
                                                        -0.031447,
                                                        -0.038741,
                                                        -0.045813,
                                                        -0.052667,
                                                        -0.059307,
                                                        -0.065733,
                                                        -0.071951,
                                                        -0.077961,
                                                        -0.083768,
                                                        -0.089373,
                                                        -0.094778,
                                                        -0.099988,
                                                        -0.105003,
                                                        -0.109826,
                                                        -0.114460,
                                                        -0.118907,
                                                        -0.123169,
                                                        -0.127248,
                                                        -0.131146,
                                                        -0.134865,
                                                        -0.138408,
                                                        -0.141776,
                                                        -0.144972,
                                                        -0.147996,
                                                        -0.150852,
                                                        -0.153540,
                                                        -0.156063,
                                                        -0.158423,
                                                        -0.160620,
                                                        -0.162657,
                                                        -0.164536,
                                                        -0.166257,
                                                        -0.167824,
                                                        -0.169236,
                                                        -0.170496,
                                                        -0.171605,
                                                        -0.172565,
                                                        -0.173377,
                                                        -0.174042,
                                                        -0.174562,
                                                        -0.174939,
                                                        -0.175173,
                                                        -0.175266,
                                                        -0.175219,
                                                        -0.175033,
                                                        -0.174711,
                                                        -0.174252,
                                                        -0.173658,
                                                        -0.172931,
                                                        -0.172071,
                                                        -0.171080,
                                                        -0.169958,
                                                        -0.168708,
                                                        -0.167329,
                                                        -0.165823,
                                                        -0.164192,
                                                        -0.162436,
                                                        -0.160555,
                                                        -0.158552,
                                                        -0.156427,
                                                        -0.154182,
                                                        -0.151816,
                                                        -0.149331,
                                                        -0.146728,
                                                        -0.144009,
                                                        -0.141173,
                                                        -0.138221,
                                                        -0.135156,
                                                        -0.131976,
                                                        -0.128684,
                                                        -0.125280,
                                                        -0.121765,
                                                        -0.118140,
                                                        -0.114405,
                                                        -0.110562,
                                                        -0.106611,
                                                        -0.102552,
                                                        -0.098388,
                                                        -0.094118,
                                                        -0.089743,
                                                        -0.085263,
                                                        -0.080681,
                                                        -0.075996,
                                                        -0.071209,
                                                        -0.066320,
                                                        -0.061331,
                                                        -0.056242,
                                                        -0.051054,
                                                        -0.045767,
                                                        -0.040383,
                                                        -0.034901,
                                                        -0.029322,
                                                        -0.023647,
                                                        -0.017877,
                                                        -0.012012,
                                                        -0.006053,
                                                        0.000000,
                                                        0.006146,
                                                        0.012384,
                                                        0.018715,
                                                        0.025136,
                                                        0.031649,
                                                        0.038251,
                                                        0.044943,
                                                        0.051725,
                                                        0.058595,
                                                        0.065553,
                                                        0.072598,
                                                        0.079731,
                                                        0.086950,
                                                        0.094255,
                                                        0.101646,
                                                        0.109122,
                                                        0.116682,
                                                        0.124327,
                                                        0.132055,
                                                        0.139866,
                                                        0.147759,
                                                        0.155735,
                                                        0.163793,
                                                        0.171932,
                                                        0.180152,
                                                        0.188452,
                                                        0.196832,
                                                        0.205292,
                                                        0.213831,
                                                        0.222448,
                                                        0.231144,
                                                        0.239918,
                                                        0.248769,
                                                        0.257697,
                                                        0.266702,
                                                        0.275783,
                                                        0.284940,
                                                        0.294172,
                                                        0.303480,
                                                        0.312862,
                                                        0.322318,
                                                        0.331849,
                                                        0.341453,
                                                        0.351130,
                                                        0.360880,
                                                        0.370703,
                                                        0.380597,
                                                        0.390564,
                                                        0.400602,
                                                        0.410711,
                                                        0.420890,
                                                        0.431140,
                                                        0.441461,
                                                        0.451851,
                                                        0.462310,
                                                        0.472838,
                                                        0.483435,
                                                        0.494101,
                                                        0.504835,
                                                        0.515636,
                                                        0.526505,
                                                        0.537442,
                                                        0.548445,
                                                        0.559514,
                                                        0.570650,
                                                        0.581852,
                                                        0.593120,
                                                        0.604453,
                                                        0.615851,
                                                        0.627313,
                                                        0.638841,
                                                        0.650432,
                                                        0.662088,
                                                        0.673807,
                                                        0.685590,
                                                        0.697436,
                                                        0.709344,
                                                        0.721315,
                                                        0.733349,
                                                        0.745445,
                                                        0.757602,
                                                        0.769821,
                                                        0.782101,
                                                        0.794442,
                                                        0.806844,
                                                        0.819307,
                                                        0.831830,
                                                        0.844412,
                                                        0.857055,
                                                        0.869757,
                                                        0.882518,
                                                        0.895339,
                                                        0.908218,
                                                        0.921156,
                                                        0.934152,
                                                        0.947206,
                                                        0.960319,
                                                        0.973488,
                                                        0.986716,
                                                        1.000000,
                                                        1.013341,
                                                        1.026740,
                                                        1.040194,
                                                        1.053705,
                                                        1.067272,
                                                        1.080895,
                                                        1.094574,
                                                        1.108308,
                                                        1.122098,
                                                        1.135942,
                                                        1.149841,
                                                        1.163795,
                                                        1.177804,
                                                        1.191866,
                                                        1.205983,
                                                        1.220153,
                                                        1.234377,
                                                        1.248655,
                                                        1.262985,
                                                        1.277369,
                                                        1.291806,
                                                        1.306295,
                                                        1.320837,
                                                        1.335431,
                                                        1.350077,
                                                        1.364775,
                                                        1.379525,
                                                        1.394326,
                                                        1.409178,
                                                        1.424082,
                                                        1.439037,
                                                        1.454043,
                                                        1.469099,
                                                        1.484206,
                                                        1.499363,
                                                        1.514570,
                                                        1.529827,
                                                        1.545134,
                                                        1.560490,
                                                        1.575896,
                                                        1.591351,
                                                        1.606856,
                                                        1.622409,
                                                        1.638011,
                                                        1.653662,
                                                        1.669361,
                                                        1.685108,
                                                        1.700904,
                                                        1.716747,
                                                        1.732639,
                                                        1.748578,
                                                        1.764564,
                                                        1.780598,
                                                        1.796679,
                                                        1.812807,
                                                        1.828982,
                                                        1.845204,
                                                        1.861472,
                                                        1.877787,
                                                        1.894148,
                                                        1.910555,
                                                        1.927008,
                                                        1.943507,
                                                        1.960052,
                                                        1.976643,
                                                        1.993278,
                                                        2.009959,
                                                        2.026686,
                                                        2.043457,
                                                        2.060273,
                                                        2.077134,
                                                        2.094039,
                                                        2.110989,
                                                        2.127983,
                                                        2.145021,
                                                        2.162104,
                                                        2.179230,
                                                        2.196400,
                                                        2.213614,
                                                        2.230871,
                                                        2.248172,
                                                        2.265516,
                                                        2.282903,
                                                        2.300333,
                                                        2.317806,
                                                        2.335322,
                                                        2.352880,
                                                        2.370481,
                                                        2.388124,
                                                        2.405810,
                                                        2.423538,
                                                        2.441307,
                                                        2.459119,
                                                        2.476972,
                                                        2.494867,
                                                        2.512804,
                                                        2.530781,
                                                        2.548801,
                                                        2.566861,
                                                        2.584963,
                                                        2.603105,
                                                        2.621288,
                                                        2.639512,
                                                        2.657777,
                                                        2.676082,
                                                        2.694427,
                                                        2.712813,
                                                        2.731239,
                                                        2.749705,
                                                        2.768210,
                                                        2.786756,
                                                        2.805341,
                                                        2.823966,
                                                        2.842631,
                                                        2.861335,
                                                        2.880078,
                                                        2.898860,
                                                        2.917681,
                                                        2.936542,
                                                        2.955441,
                                                        2.974379,
                                                        2.993356,
                                                        3.012371,
                                                        3.031425,
                                                        3.050517,
                                                        3.069647,
                                                        3.088815,
                                                        3.108022,
                                                        3.127266,
                                                        3.146548,
                                                        3.165868,
                                                        3.185226,
                                                        3.204621,
                                                        3.224054,
                                                        3.243524,
                                                        3.263031,
                                                        3.282576,
                                                        3.302157,
                                                        3.321776,
                                                        3.341431,
                                                        3.361123,
                                                        3.380852,
                                                        3.400618,
                                                        3.420420,
                                                        3.440258,
                                                        3.460133,
                                                        3.480044,
                                                        3.499991,
                                                        3.519974,
                                                        3.539994,
                                                        3.560049,
                                                        3.580140,
                                                        3.600266,
                                                        3.620428,
                                                        3.640626,
                                                        3.660859,
                                                        3.681128,
                                                        3.701432,
                                                        3.721771,
                                                        3.742145,
                                                        3.762554,
                                                        3.782998,
                                                        3.803477,
                                                        3.823991,
                                                        3.844539,
                                                        3.865122,
                                                        3.885739,
                                                        3.906391,
                                                        3.927078,
                                                        3.947798,
                                                        3.968553,
                                                        3.989342,
                                                        4.010165,
                                                        4.031021,
                                                        4.051912,
                                                        4.072837,
                                                        4.093795,
                                                        4.114787,
                                                        4.135812,
                                                        4.156871,
                                                        4.177963,
                                                        4.199089,
                                                        4.220248,
                                                        4.241440,
                                                        4.262665,
                                                        4.283923,
                                                        4.305214,
                                                        4.326538,
                                                        4.347895,
                                                        4.369284,
                                                        4.390706,
                                                        4.412161,
                                                        4.433648,
                                                        4.455168,
                                                        4.476720,
                                                        4.498304,
                                                        4.519920,
                                                        4.541569,
                                                        4.563250,
                                                        4.584963,
                                                        4.606707,
                                                        4.628484,
                                                        4.650292,
                                                        4.672132,
                                                        4.694004,
                                                        4.715907,
                                                        4.737842,
                                                        4.759808,
                                                        4.781805,
                                                        4.803834,
                                                        4.825894,
                                                        4.847986,
                                                        4.870108,
                                                        4.892262,
                                                        4.914446,
                                                        4.936661,
                                                        4.958907,
                                                        4.981184,
                                                        5.003492,
                                                        5.025830,
                                                        5.048199,
                                                        5.070599,
                                                        5.093029,
                                                        5.115489,
                                                        5.137979,
                                                        5.160500,
                                                        5.183051,
                                                        5.205632,
                                                        5.228244,
                                                        5.250885,
                                                        5.273556,
                                                        5.296257,
                                                        5.318988,
                                                        5.341749,
                                                        5.364539,
                                                        5.387359,
                                                        5.410209,
                                                        5.433088,
                                                        5.455997,
                                                        5.478935,
                                                        5.501902,
                                                        5.524899,
                                                        5.547924,
                                                        5.570979,
                                                        5.594063,
                                                        5.617177,
                                                        5.640319,
                                                        5.663490,
                                                        5.686690,
                                                        5.709919,
                                                        5.733176,
                                                        5.756462,
                                                        5.779777,
                                                        5.803121,
                                                        5.826493,
                                                        5.849893,
                                                        5.873322,
                                                        5.896779,
                                                        5.920265,
                                                        5.943779,
                                                        5.967321,
                                                        5.990891,
                                                        6.014489,
                                                        6.038115,
                                                        6.061770,
                                                        6.085452,
                                                        6.109162,
                                                        6.132900,
                                                        6.156666,
                                                        6.180459,
                                                        6.204280,
                                                        6.228129,
                                                        6.252005,
                                                        6.275908,
                                                        6.299840,
                                                        6.323798,
                                                        6.347784,
                                                        6.371797,
                                                        6.395838,
                                                        6.419905,
                                                        6.444000,
                                                        6.468122,
                                                        6.492271,
                                                        6.516447,
                                                        6.540649,
                                                        6.564879,
                                                        6.589136,
                                                        6.613419,
                                                        6.637729,
                                                        6.662066,
                                                        6.686429,
                                                        6.710819,
                                                        6.735236,
                                                        6.759679,
                                                        6.784148,
                                                        6.808644,
                                                        6.833166,
                                                        6.857715,
                                                        6.882290,
                                                        6.906891,
                                                        6.931518,
                                                        6.956171,
                                                        6.980850,
                                                        7.005556,
                                                        7.030287,
                                                        7.055044,
                                                        7.079827,
                                                        7.104636,
                                                        7.129471,
                                                        7.154332,
                                                        7.179218,
                                                        7.204129,
                                                        7.229067,
                                                        7.254030,
                                                        7.279018,
                                                        7.304032,
                                                        7.329072,
                                                        7.354137,
                                                        7.379227,
                                                        7.404342,
                                                        7.429483,
                                                        7.454648,
                                                        7.479839,
                                                        7.505056,
                                                        7.530297,
                                                        7.555563,
                                                        7.580854,
                                                        7.606170,
                                                        7.631511,
                                                        7.656877,
                                                        7.682268,
                                                        7.707683,
                                                        7.733124,
                                                        7.758589,
                                                        7.784078,
                                                        7.809592,
                                                        7.835131,
                                                        7.860694,
                                                        7.886282,
                                                        7.911894,
                                                        7.937530,
                                                        7.963191,
                                                        7.988877,
                                                        8.014586,
                                                        8.040320,
                                                        8.066078,
                                                        8.091860,
                                                        8.117666,
                                                        8.143496,
                                                        8.169350,
                                                        8.195228,
                                                        8.221131,
                                                        8.247057,
                                                        8.273007,
                                                        8.298980,
                                                        8.324978,
                                                        8.350999,
                                                        8.377044,
                                                        8.403113,
                                                        8.429206,
                                                        8.455322,
                                                        8.481461,
                                                        8.507624,
                                                        8.533811,
                                                        8.560021,
                                                        8.586254,
                                                        8.612511,
                                                        8.638791,
                                                        8.665094,
                                                        8.691421,
                                                        8.717771,
                                                        8.744144,
                                                        8.770540,
                                                        8.796959,
                                                        8.823402,
                                                        8.849867,
                                                        8.876355,
                                                        8.902867,
                                                        8.929401,
                                                        8.955958,
                                                        8.982538,
                                                        9.009141,
                                                        9.035767,
                                                        9.062415,
                                                        9.089086,
                                                        9.115780,
                                                        9.142496,
                                                        9.169235,
                                                        9.195997,
                                                        9.222781,
                                                        9.249587,
                                                        9.276416,
                                                        9.303268,
                                                        9.330142,
                                                        9.357038,
                                                        9.383956,
                                                        9.410897,
                                                        9.437860,
                                                        9.464846,
                                                        9.491853,
                                                        9.518883,
                                                        9.545934,
                                                        9.573008,
                                                        9.600104,
                                                        9.627222,
                                                        9.654362,
                                                        9.681524,
                                                        9.708708,
                                                        9.735913,
                                                        9.763141,
                                                        9.790390,
                                                        9.817661,
                                                        9.844954,
                                                        9.872269,
                                                        9.899605,
                                                        9.926963,
                                                        9.954342,
                                                        9.981743,
                                                        10.009166,
                                                        10.036610,
                                                        10.064076,
                                                        10.091563,
                                                        10.119072,
                                                        10.146602,
                                                        10.174153,
                                                        10.201726,
                                                        10.229320,
                                                        10.256935,
                                                        10.284571,
                                                        10.312229,
                                                        10.339908,
                                                        10.367608,
                                                        10.395329,
                                                        10.423071,
                                                        10.450835,
                                                        10.478619,
                                                        10.506424,
                                                        10.534251,
                                                        10.562098,
                                                        10.589966,
                                                        10.617855,
                                                        10.645765,
                                                        10.673695,
                                                        10.701647,
                                                        10.729619,
                                                        10.757612,
                                                        10.785625,
                                                        10.813660,
                                                        10.841714,
                                                        10.869790,
                                                        10.897886,
                                                        10.926003,
                                                        10.954140,
                                                        10.982297,
                                                        11.010475,
                                                        11.038674,
                                                        11.066893,
                                                        11.095132,
                                                        11.123392,
                                                        11.151672,
                                                        11.179972,
                                                        11.208292,
                                                        11.236633,
                                                        11.264994,
                                                        11.293375,
                                                        11.321776,
                                                        11.350197,
                                                        11.378639,
                                                        11.407100,
                                                        11.435582,
                                                        11.464083,
                                                        11.492605,
                                                        11.521146,
                                                        11.549708,
                                                        11.578289,
                                                        11.606890,
                                                        11.635511,
                                                        11.664152,
                                                        11.692813,
                                                        11.721493,
                                                        11.750193,
                                                        11.778913,
                                                        11.807652,
                                                        11.836411,
                                                        11.865190,
                                                        11.893988,
                                                        11.922806,
                                                        11.951644,
                                                        11.980501,
                                                        12.009377,
                                                        12.038273,
                                                        12.067188,
                                                        12.096123,
                                                        12.125077,
                                                        12.154051,
                                                        12.183044,
                                                        12.212056,
                                                        12.241087,
                                                        12.270138,
                                                        12.299208,
                                                        12.328297,
                                                        12.357406,
                                                        12.386533,
                                                        12.415680,
                                                        12.444845,
                                                        12.474030,
                                                        12.503234,
                                                        12.532457,
                                                        12.561699,
                                                        12.590960,
                                                        12.620240,
                                                        12.649538,
                                                        12.678856,
                                                        12.708193,
                                                        12.737548,
                                                        12.766922,
                                                        12.796315,
                                                        12.825727,
                                                        12.855158,
                                                        12.884607,
                                                        12.914075,
                                                        12.943562,
                                                        12.973067,
                                                        13.002591,
                                                        13.032134,
                                                        13.061695,
                                                        13.091275,
                                                        13.120873,
                                                        13.150490,
                                                        13.180126,
                                                        13.209779,
                                                        13.239452,
                                                        13.269142,
                                                        13.298851,
                                                        13.328579,
                                                        13.358325,
                                                        13.388089,
                                                        13.417871,
                                                        13.447672,
                                                        13.477491,
                                                        13.507328,
                                                        13.537184,
                                                        13.567057,
                                                        13.596949,
                                                        13.626859,
                                                        13.656787,
                                                        13.686734,
                                                        13.716698,
                                                        13.746680,
                                                        13.776681,
                                                        13.806699,
                                                        13.836735,
                                                        13.866790,
                                                        13.896862,
                                                        13.926952,
                                                        13.957060,
                                                        13.987186,
                                                        14.017330,
                                                        14.047492,
                                                        14.077671,
                                                        14.107868,
                                                        14.138083,
                                                        14.168316,
                                                        14.198566,
                                                        14.228835,
                                                        14.259121,
                                                        14.289424,
                                                        14.319745,
                                                        14.350084,
                                                        14.380440,
                                                        14.410814,
                                                        14.441206,
                                                        14.471615,
                                                        14.502041,
                                                        14.532485,
                                                        14.562947,
                                                        14.593426,
                                                        14.623922,
                                                        14.654436,
                                                        14.684967,
                                                        14.715515,
                                                        14.746081,
                                                        14.776664,
                                                        14.807265,
                                                        14.837883,
                                                        14.868518,
                                                        14.899170,
                                                        14.929839,
                                                        14.960526,
                                                        14.991230,
                                                        15.021951,
                                                        15.052689,
                                                        15.083444,
                                                        15.114216,
                                                        15.145006,
                                                        15.175812,
                                                        15.206636,
                                                        15.237476,
                                                        15.268334,
                                                        15.299208,
                                                        15.330099,
                                                        15.361008,
                                                        15.391933,
                                                        15.422875,
                                                        15.453834,
                                                        15.484810,
                                                        15.515803,
                                                        15.546812,
                                                        15.577839,
                                                        15.608882,
                                                        15.639942,
                                                        15.671018,
                                                        15.702111,
                                                        15.733221,
                                                        15.764348,
                                                        15.795491,
                                                        15.826651,
                                                        15.857828,
                                                        15.889021,
                                                        15.920231,
                                                        15.951457,
                                                        15.982700,
                                                        16.013960,
                                                        16.045236,
                                                        16.076528,
                                                        16.107837,
                                                        16.139162,
                                                        16.170504,
                                                        16.201862,
                                                        16.233237,
                                                        16.264628,
                                                        16.296035,
                                                        16.327459,
                                                        16.358899,
                                                        16.390355,
                                                        16.421828,
                                                        16.453317,
                                                        16.484822,
                                                        16.516343,
                                                        16.547880,
                                                        16.579434,
                                                        16.611004,
                                                        16.642590,
                                                        16.674192,
                                                        16.705811,
                                                        16.737445,
                                                        16.769096,
                                                        16.800762,
                                                        16.832445,
                                                        16.864143,
                                                        16.895858,
                                                        16.927589,
                                                        16.959335,
                                                        16.991098,
                                                        17.022876,
                                                        17.054671,
                                                        17.086481,
                                                        17.118308,
                                                        17.150150,
                                                        17.182008,
                                                        17.213881,
                                                        17.245771,
                                                        17.277677,
                                                        17.309598,
                                                        17.341535,
                                                        17.373488,
                                                        17.405456,
                                                        17.437440,
                                                        17.469440,
                                                        17.501456,
                                                        17.533487,
                                                        17.565534,
                                                        17.597596,
                                                        17.629675,
                                                        17.661768,
                                                        17.693878,
                                                        17.726003,
                                                        17.758143,
                                                        17.790299,
                                                        17.822471,
                                                        17.854657,
                                                        17.886860,
                                                        17.919078,
                                                        17.951311,
                                                        17.983560,
                                                        18.015824,
                                                        18.048104,
                                                        18.080399,
                                                        18.112709,
                                                        18.145035,
                                                        18.177376,
                                                        18.209733,
                                                        18.242104,
                                                        18.274491,
                                                        18.306893,
                                                        18.339311,
                                                        18.371744,
                                                        18.404192,
                                                        18.436655,
                                                        18.469133,
                                                        18.501627,
                                                        18.534135,
                                                        18.566659,
                                                        18.599198,
                                                        18.631752,
                                                        18.664321,
                                                        18.696905,
                                                        18.729505,
                                                        18.762119,
                                                        18.794748,
                                                        18.827393,
                                                        18.860052,
                                                        18.892726,
                                                        18.925416,
                                                        18.958120,
                                                        18.990839,
                                                        19.023573,
                                                        19.056322,
                                                        19.089086,
                                                        19.121865,
                                                        19.154659,
                                                        19.187467,
                                                        19.220290,
                                                        19.253129,
                                                        19.285981,
                                                        19.318849,
                                                        19.351732,
                                                        19.384629,
                                                        19.417541,
                                                        19.450468,
                                                        19.483409,
                                                        19.516365,
                                                        19.549336,
                                                        19.582321,
                                                        19.615321,
                                                        19.648336,
                                                        19.681366,
                                                        19.714410,
                                                        19.747468,
                                                        19.780541,
                                                        19.813629,
                                                        19.846731,
                                                        19.879848,
                                                        19.912979,
                                                        19.946125,
                                                        19.979285,
                                                        20.012460,
                                                        20.045649,
                                                        20.078853,
                                                        20.112071,
                                                        20.145303,
                                                        20.178550,
                                                        20.211812,
                                                        20.245087,
                                                        20.278377,
                                                        20.311682,
                                                        20.345000,
                                                        20.378333,
                                                        20.411680,
                                                        20.445042,
                                                        20.478418,
                                                        20.511808,
                                                        20.545212,
                                                        20.578631,
                                                        20.612064,
                                                        20.645511,
                                                        20.678972,
                                                        20.712447,
                                                        20.745937,
                                                        20.779441,
                                                        20.812958,
                                                        20.846490,
                                                        20.880036,
                                                        20.913596,
                                                        20.947171,
                                                        20.980759,
                                                        21.014361,
                                                        21.047977,
                                                        21.081608,
                                                        21.115252,
                                                        21.148911,
                                                        21.182583,
                                                        21.216269,
                                                        21.249970,
                                                        21.283684,
                                                        21.317412,
                                                        21.351154,
                                                        21.384910,
                                                        21.418680,
                                                        21.452464,
                                                        21.486261,
                                                        21.520073,
                                                        21.553898,
                                                        21.587737,
                                                        21.621590,
                                                        21.655457,
                                                        21.689337,
                                                        21.723231,
                                                        21.757139,
                                                        21.791061,
                                                        21.824997,
                                                        21.858946,
                                                        21.892909,
                                                        21.926885,
                                                        21.960876,
                                                        21.994879,
                                                        22.028897,
                                                        22.062928,
                                                        22.096973,
                                                        22.131032,
                                                        22.165104,
                                                        22.199189,
                                                        22.233289,
                                                        22.267401,
                                                        22.301528,
                                                        22.335668,
                                                        22.369821,
                                                        22.403988,
                                                        22.438168,
                                                        22.472362,
                                                        22.506570,
                                                        22.540790,
                                                        22.575025,
                                                        22.609272,
                                                        22.643533,
                                                        22.677808,
                                                        22.712096,
                                                        22.746397,
                                                        22.780712,
                                                        22.815040,
                                                        22.849381,
                                                        22.883736,
                                                        22.918104,
                                                        22.952486,
                                                        22.986880,
                                                        23.021288,
                                                        23.055710,
                                                        23.090144,
                                                        23.124592,
                                                        23.159053,
                                                        23.193527,
                                                        23.228015,
                                                        23.262515,
                                                        23.297029,
                                                        23.331556,
                                                        23.366096,
                                                        23.400649,
                                                        23.435216,
                                                        23.469796,
                                                        23.504388,
                                                        23.538994,
                                                        23.573613,
                                                        23.608245,
                                                        23.642890,
                                                        23.677548,
                                                        23.712219,
                                                        23.746904,
                                                        23.781601,
                                                        23.816311,
                                                        23.851034,
                                                        23.885771,
                                                        23.920520,
                                                        23.955282,
                                                        23.990057,
                                                        24.024845,
                                                        24.059646,
                                                        24.094460,
                                                        24.129287,
                                                        24.164127,
                                                        24.198979,
                                                        24.233845,
                                                        24.268723,
                                                        24.303614,
                                                        24.338518,
                                                        24.373435,
                                                        24.408365,
                                                        24.443307,
                                                        24.478263,
                                                        24.513231,
                                                        24.548212,
                                                        24.583205,
                                                        24.618212,
                                                        24.653231,
                                                        24.688262,
                                                        24.723307,
                                                        24.758364,
                                                        24.793434,
                                                        24.828517,
                                                        24.863612,
                                                        24.898720,
                                                        24.933840,
                                                        24.968974,
                                                        25.004119,
                                                        25.039278,
                                                        25.074449,
                                                        25.109633,
                                                        25.144829,
                                                        25.180038,
                                                        25.215259,
                                                        25.250493,
                                                        25.285739,
                                                        25.320998,
                                                        25.356270,
                                                        25.391554,
                                                        25.426850,
                                                        25.462159,
                                                        25.497480,
                                                        25.532814,
                                                        25.568161,
                                                        25.603519,
                                                        25.638891,
                                                        25.674274,
                                                        25.709670,
                                                        25.745079,
                                                        25.780499,
                                                        25.815933,
                                                        25.851378,
                                                        25.886836,
                                                        25.922306,
                                                        25.957789,
                                                        25.993284,
                                                        26.028791,
                                                        26.064311,
                                                        26.099842,
                                                        26.135387,
                                                        26.170943,
                                                        26.206512,
                                                        26.242092,
                                                        26.277686,
                                                        26.313291,
                                                        26.348908,
                                                        26.384538,
                                                        26.420180,
                                                        26.455834,
                                                        26.491501,
                                                        26.527179,
                                                        26.562870,
                                                        26.598573,
                                                        26.634288,
                                                        26.670015,
                                                        26.705754,
                                                        26.741505,
                                                        26.777269,
                                                        26.813044,
                                                        26.848832,
                                                        26.884631,
                                                        26.920443,
                                                        26.956267,
                                                        26.992102,
                                                        27.027950,
                                                        27.063810,
                                                        27.099682,
                                                        27.135566,
                                                        27.171461,
                                                        27.207369,
                                                        27.243289,
                                                        27.279221,
                                                        27.315164,
                                                        27.351120,
                                                        27.387087,
                                                        27.423067,
                                                        27.459058,
                                                        27.495061,
                                                        27.531076,
                                                        27.567103,
                                                        27.603142,
                                                        27.639193,
                                                        27.675255,
                                                        27.711330,
                                                        27.747416,
                                                        27.783514,
                                                        27.819624,
                                                        27.855746,
                                                        27.891879,
                                                        27.928024,
                                                        27.964181,
                                                        28.000350,
                                                        28.036530,
                                                        28.072723,
                                                        28.108927,
                                                        28.145142,
                                                        28.181370,
                                                        28.217609,
                                                        28.253860,
                                                        28.290122,
                                                        28.326396,
                                                        28.362682,
                                                        28.398980,
                                                        28.435289,
                                                        28.471609,
                                                        28.507942,
                                                        28.544286,
                                                        28.580642,
                                                        28.617009,
                                                        28.653388,
                                                        28.689778,
                                                        28.726180,
                                                        28.762594,
                                                        28.799019,
                                                        28.835455,
                                                        28.871903,
                                                        28.908363,
                                                        28.944834,
                                                        28.981317,
                                                        29.017811,
                                                        29.054317,
                                                        29.090834,
                                                        29.127363,
                                                        29.163903,
                                                        29.200455,
                                                        29.237018,
                                                        29.273592,
                                                        29.310178,
                                                        29.346775,
                                                        29.383384,
                                                        29.420004,
                                                        29.456635,
                                                        29.493278,
                                                        29.529933,
                                                        29.566598,
                                                        29.603275,
                                                        29.639963,
                                                        29.676663,
                                                        29.713374,
                                                        29.750096,
                                                        29.786830,
                                                        29.823575,
                                                        29.860331,
                                                        29.897099,
                                                        29.933877,
                                                        29.970667,
                                                        30.007469,
                                                        30.044281,
                                                        30.081105,
                                                        30.117940,
                                                        30.154786,
                                                        30.191644,
                                                        30.228512,
                                                        30.265392,
                                                        30.302283,
                                                        30.339185,
                                                        30.376099,
                                                        30.413023,
                                                        30.449959,
                                                        30.486906,
                                                        30.523863,
                                                        30.560833,
                                                        30.597813,
                                                        30.634804,
                                                        30.671806,
                                                        30.708820,
                                                        30.745845,
                                                        30.782880,
                                                        30.819927,
                                                        30.856985,
                                                        30.894053,
                                                        30.931133,
                                                        30.968224,
                                                        31.005326,
                                                        31.042439,
                                                        31.079563,
                                                        31.116698,
                                                        31.153844,
                                                        31.191001,
                                                        31.228169,
                                                        31.265348,
                                                        31.302537,
                                                        31.339738,
                                                        31.376950,
                                                        31.414173,
                                                        31.451406,
                                                        31.488651,
                                                        31.525906,
                                                        31.563172,
                                                        31.600450,
                                                        31.637738,
                                                        31.675037,
                                                        31.712346,
                                                        31.749667,
                                                        31.786999,
                                                        31.824341,
                                                        31.861694,
                                                        31.899058,
                                                        31.936433,
                                                        31.973819,
                                                        32.011215,
                                                        32.048622,
                                                        32.086040,
                                                        32.123469,
                                                        32.160909,
                                                        32.198359,
                                                        32.235820,
                                                        32.273292,
                                                        32.310774,
                                                        32.348268,
                                                        32.385772,
                                                        32.423287,
                                                        32.460812,
                                                        32.498348,
                                                        32.535895,
                                                        32.573452,
                                                        32.611021,
                                                        32.648599,
                                                        32.686189,
                                                        32.723789,
                                                        32.761400,
                                                        32.799021,
                                                        32.836653,
                                                        32.874296,
                                                        32.911949,
                                                        32.949613,
                                                        32.987288,
                                                        33.024973,
                                                        33.062669,
                                                        33.100375,
                                                        33.138092,
                                                        33.175819,
                                                        33.213557,
                                                        33.251305,
                                                        33.289064,
                                                        33.326834,
                                                        33.364614,
                                                        33.402404,
                                                        33.440205,
                                                        33.478017,
                                                        33.515839,
                                                        33.553671,
                                                        33.591514,
                                                        33.629368,
                                                        33.667232,
                                                        33.705106,
                                                        33.742991,
                                                        33.780886,
                                                        33.818792,
                                                        33.856708,
                                                        33.894634,
                                                        33.932571,
                                                        33.970518,
                                                        34.008476,
                                                        34.046444,
                                                        34.084422,
                                                        34.122411,
                                                        34.160410,
                                                        34.198420,
                                                        34.236440,
                                                        34.274470,
                                                        34.312510,
                                                        34.350561,
                                                        34.388622,
                                                        34.426694,
                                                        34.464776,
                                                        34.502868,
                                                        34.540970,
                                                        34.579083,
                                                        34.617206,
                                                        34.655339,
                                                        34.693482,
                                                        34.731636,
                                                        34.769800,
                                                        34.807974,
                                                        34.846158,
                                                        34.884353,
                                                        34.922558,
                                                        34.960773,
                                                        34.998998,
                                                        35.037233,
                                                        35.075479,
                                                        35.113735,
                                                        35.152001,
                                                        35.190277,
                                                        35.228563,
                                                        35.266859,
                                                        35.305166,
                                                        35.343482,
                                                        35.381809,
                                                        35.420146,
                                                        35.458493,
                                                        35.496850,
                                                        35.535218,
                                                        35.573595,
                                                        35.611982,
                                                        35.650380,
                                                        35.688787,
                                                        35.727205,
                                                        35.765633,
                                                        35.804070,
                                                        35.842518,
                                                        35.880976,
                                                        35.919444,
                                                        35.957922,
                                                        35.996410,
                                                        36.034907,
                                                        36.073415,
                                                        36.111933,
                                                        36.150461,
                                                        36.188999,
                                                        36.227547,
                                                        36.266104,
                                                        36.304672,
                                                        36.343250,
                                                        36.381838,
                                                        36.420435,
                                                        36.459043,
                                                        36.497660,
                                                        36.536287,
                                                        36.574925,
                                                        36.613572,
                                                        36.652229,
                                                        36.690896,
                                                        36.729573,
                                                        36.768259,
                                                        36.806956,
                                                        36.845662,
                                                        36.884379,
                                                        36.923105,
                                                        36.961841,
                                                        37.000587,
                                                        37.039342,
                                                        37.078108,
                                                        37.116883,
                                                        37.155668,
                                                        37.194463,
                                                        37.233268,
                                                        37.272083,
                                                        37.310907,
                                                        37.349741,
                                                        37.388585,
                                                        37.427438,
                                                        37.466302,
                                                        37.505175,
                                                        37.544058,
                                                        37.582950,
                                                        37.621853,
                                                        37.660765,
                                                        37.699687,
                                                        37.738618,
                                                        37.777559,
                                                        37.816510,
                                                        37.855471,
                                                        37.894441,
                                                        37.933421,
                                                        37.972411,
                                                        38.011410,
                                                        38.050419,
                                                        38.089437,
                                                        38.128466,
                                                        38.167504,
                                                        38.206551,
                                                        38.245608,
                                                        38.284675,
                                                        38.323751,
                                                        38.362837,
                                                        38.401933,
                                                        38.441038,
                                                        38.480153,
                                                        38.519277,
                                                        38.558411,
                                                        38.597555,
                                                        38.636708,
                                                        38.675870,
                                                        38.715043,
                                                        38.754224,
                                                        38.793416,
                                                        38.832616,
                                                        38.871827,
                                                        38.911046,
                                                        38.950276,
                                                        38.989515,
                                                        39.028763,
                                                        39.068021,
                                                        39.107288,
                                                        39.146565,
                                                        39.185851,
                                                        39.225147,
                                                        39.264452,
                                                        39.303767,
                                                        39.343091,
                                                        39.382425,
                                                        39.421768,
                                                        39.461120,
                                                        39.500482,
                                                        39.539853,
                                                        39.579234,
                                                        39.618624,
                                                        39.658024,
                                                        39.697433,
                                                        39.736851,
                                                        39.776279,
                                                        39.815716,
                                                        39.855162,
                                                        39.894618,
                                                        39.934083,
                                                        39.973558,
                                                        40.013041,
                                                        40.052535,
                                                        40.092037,
                                                        40.131549,
                                                        40.171070,
                                                        40.210601,
                                                        40.250140,
                                                        40.289690,
                                                        40.329248,
                                                        40.368816,
                                                        40.408393,
                                                        40.447979,
                                                        40.487575,
                                                        40.527179,
                                                        40.566793,
                                                        40.606417,
                                                        40.646049,
                                                        40.685691,
                                                        40.725342,
                                                        40.765003,
                                                        40.804672,
                                                        40.844351,
                                                        40.884039,
                                                        40.923736,
                                                        40.963442,
                                                        41.003158,
                                                        41.042883,
                                                        41.082617,
                                                        41.122360,
                                                        41.162112,
                                                        41.201874,
                                                        41.241644,
                                                        41.281424,
                                                        41.321213,
                                                        41.361011,
                                                        41.400818,
                                                        41.440635,
                                                        41.480460,
                                                        41.520295,
                                                        41.560139,
                                                        41.599991,
                                                        41.639853,
                                                        41.679724,
                                                        41.719604,
                                                        41.759494,
                                                        41.799392,
                                                        41.839299,
                                                        41.879216,
                                                        41.919141,
                                                        41.959076,
                                                        41.999020,
                                                        42.038972,
                                                        42.078934,
                                                        42.118905,
                                                        42.158885,
                                                        42.198873,
                                                        42.238871,
                                                        42.278878,
                                                        42.318894,
                                                        42.358919,
                                                        42.398953,
                                                        42.438996,
                                                        42.479047,
                                                        42.519108,
                                                        42.559178,
                                                        42.599257,
                                                        42.639344,
                                                        42.679441,
                                                        42.719547,
                                                        42.759661,
                                                        42.799785,
                                                        42.839917,
                                                        42.880059,
                                                        42.920209,
                                                        42.960368,
                                                        43.000536,
                                                        43.040714,
                                                        43.080899,
                                                        43.121094,
                                                        43.161298,
                                                        43.201511,
                                                        43.241732,
                                                        43.281963,
                                                        43.322202,
                                                        43.362450,
                                                        43.402707,
                                                        43.442973,
                                                        43.483247,
                                                        43.523531,
                                                        43.563823,
                                                        43.604125,
                                                        43.644435,
                                                        43.684753,
                                                        43.725081,
                                                        43.765418,
                                                        43.805763,
                                                        43.846117,
                                                        43.886480,
                                                        43.926851,
                                                        43.967232,
                                                        44.007621,
                                                        44.048019,
                                                        44.088426,
                                                        44.128841,
                                                        44.169266,
                                                        44.209699,
                                                        44.250140,
                                                        44.290591,
                                                        44.331050,
                                                        44.371518,
                                                        44.411995,
                                                        44.452480,
                                                        44.492975,
                                                        44.533477,
                                                        44.573989,
                                                        44.614509,
                                                        44.655038,
                                                        44.695576,
                                                        44.736122,
                                                        44.776677,
                                                        44.817241,
                                                        44.857813,
                                                        44.898394,
                                                        44.938984,
                                                        44.979582,
                                                        45.020189,
                                                        45.060805,
                                                        45.101429,
                                                        45.142062,
                                                        45.182703,
                                                        45.223353,
                                                        45.264012,
                                                        45.304679,
                                                        45.345355,
                                                        45.386040,
                                                        45.426733,
                                                        45.467435,
                                                        45.508145,
                                                        45.548864,
                                                        45.589591,
                                                        45.630327,
                                                        45.671072,
                                                        45.711825,
                                                        45.752587,
                                                        45.793357,
                                                        45.834136,
                                                        45.874923,
                                                        45.915719,
                                                        45.956524,
                                                        45.997337,
                                                        46.038158,
                                                        46.078988,
                                                        46.119826,
                                                        46.160673,
                                                        46.201529,
                                                        46.242393,
                                                        46.283265,
                                                        46.324146,
                                                        46.365036,
                                                        46.405934,
                                                        46.446840,
                                                        46.487755,
                                                        46.528678,
                                                        46.569610,
                                                        46.610550,
                                                        46.651499,
                                                        46.692456,
                                                        46.733421,
                                                        46.774395,
                                                        46.815378,
                                                        46.856368,
                                                        46.897368,
                                                        46.938375,
                                                        46.979391,
                                                        47.020416,
                                                        47.061448,
                                                        47.102490,
                                                        47.143539,
                                                        47.184597,
                                                        47.225664,
                                                        47.266738,
                                                        47.307821,
                                                        47.348913,
                                                        47.390013,
                                                        47.431121,
                                                        47.472237,
                                                        47.513362,
                                                        47.554495,
                                                        47.595637,
                                                        47.636787,
                                                        47.677945,
                                                        47.719111,
                                                        47.760286,
                                                        47.801469,
                                                        47.842661,
                                                        47.883860,
                                                        47.925068,
                                                        47.966285,
                                                        48.007509,
                                                        48.048742,
                                                        48.089983,
                                                        48.131232,
                                                        48.172490,
                                                        48.213756,
                                                        48.255030,
                                                        48.296313,
                                                        48.337603,
                                                        48.378902,
                                                        48.420209,
                                                        48.461525,
                                                        48.502848,
                                                        48.544180,
                                                        48.585520,
                                                        48.626869,
                                                        48.668225,
                                                        48.709590,
                                                        48.750963,
                                                        48.792344,
                                                        48.833733,
                                                        48.875130,
                                                        48.916536,
                                                        48.957950,
                                                        48.999372,
                                                        49.040802,
                                                        49.082240,
                                                        49.123687,
                                                        49.165141,
                                                        49.206604,
                                                        49.248075,
                                                        49.289554,
                                                        49.331041,
                                                        49.372536,
                                                        49.414040,
                                                        49.455551,
                                                        49.497071,
                                                        49.538599,
                                                        49.580135,
                                                        49.621679,
                                                        49.663231,
                                                        49.704791,
                                                        49.746359,
                                                        49.787936,
                                                        49.829520,
                                                        49.871113,
                                                        49.912713,
                                                        49.954322,
                                                        49.995939,
                                                        50.037564,
                                                        50.079196,
                                                        50.120837,
                                                        50.162486,
                                                        50.204143,
                                                        50.245808,
                                                        50.287481,
                                                        50.329162,
                                                        50.370851,
                                                        50.412548,
                                                        50.454253,
                                                        50.495967,
                                                        50.537688,
                                                        50.579417,
                                                        50.621154,
                                                        50.662899,
                                                        50.704652,
                                                        50.746413,
                                                        50.788182,
                                                        50.829959,
                                                        50.871744,
                                                        50.913537,
                                                        50.955338,
                                                        50.997147,
                                                        51.038964,
                                                        51.080789,
                                                        51.122621,
                                                        51.164462,
                                                        51.206311,
                                                        51.248167,
                                                        51.290032,
                                                        51.331904,
                                                        51.373784,
                                                        51.415672,
                                                        51.457569,
                                                        51.499473,
                                                        51.541384,
                                                        51.583304,
                                                        51.625232,
                                                        51.667167,
                                                        51.709111,
                                                        51.751062,
                                                        51.793021,
                                                        51.834989,
                                                        51.876963,
                                                        51.918946,
                                                        51.960937,
                                                        52.002935,
                                                        52.044942,
                                                        52.086956,
                                                        52.128978,
                                                        52.171008,
                                                        52.213046,
                                                        52.255091,
                                                        52.297144,
                                                        52.339206,
                                                        52.381275,
                                                        52.423351,
                                                        52.465436,
                                                        52.507528,
                                                        52.549628,
                                                        52.591736,
                                                        52.633852,
                                                        52.675976,
                                                        52.718107,
                                                        52.760246,
                                                        52.802393,
                                                        52.844548,
                                                        52.886710,
                                                        52.928880,
                                                        52.971058,
                                                        53.013244,
                                                        53.055437,
                                                        53.097638,
                                                        53.139847,
                                                        53.182064,
                                                        53.224288,
                                                        53.266520,
                                                        53.308760,
                                                        53.351008,
                                                        53.393263,
                                                        53.435526,
                                                        53.477797,
                                                        53.520075,
                                                        53.562361,
                                                        53.604655,
                                                        53.646956,
                                                        53.689265,
                                                        53.731582,
                                                        53.773907,
                                                        53.816239,
                                                        53.858579,
                                                        53.900926,
                                                        53.943281,
                                                        53.985644,
                                                        54.028014,
                                                        54.070392,
                                                        54.112778,
                                                        54.155172,
                                                        54.197573,
                                                        54.239981,
                                                        54.282397,
                                                        54.324821,
                                                        54.367253,
                                                        54.409692,
                                                        54.452139,
                                                        54.494593,
                                                        54.537055,
                                                        54.579525,
                                                        54.622002,
                                                        54.664486,
                                                        54.706979,
                                                        54.749479,
                                                        54.791986,
                                                        54.834501,
                                                        54.877024,
                                                        54.919554,
                                                        54.962092,
                                                        55.004637,
                                                        55.047190,
                                                        55.089750,
                                                        55.132318,
                                                        55.174894,
                                                        55.217477,
                                                        55.260068,
                                                        55.302666,
                                                        55.345271,
                                                        55.387885,
                                                        55.430505,
                                                        55.473134,
                                                        55.515769,
                                                        55.558412,
                                                        55.601063,
                                                        55.643721,
                                                        55.686387,
                                                        55.729060,
                                                        55.771741,
                                                        55.814429,
                                                        55.857125,
                                                        55.899828,
                                                        55.942539,
                                                        55.985257,
                                                        56.027983,
                                                        56.070716,
                                                        56.113456,
                                                        56.156204,
                                                        56.198959,
                                                        56.241722,
                                                        56.284493,
                                                        56.327270,
                                                        56.370055,
                                                        56.412848,
                                                        56.455648,
                                                        56.498455,
                                                        56.541270,
                                                        56.584093,
                                                        56.626922,
                                                        56.669759,
                                                        56.712604,
                                                        56.755456,
                                                        56.798315,
                                                        56.841182,
                                                        56.884056,
                                                        56.926937,
                                                        56.969826,
                                                        57.012722,
                                                        57.055626,
                                                        57.098537,
                                                        57.141455,
                                                        57.184381,
                                                        57.227314,
                                                        57.270255,
                                                        57.313202,
                                                        57.356157,
                                                        57.399120,
                                                        57.442090,
                                                        57.485067,
                                                        57.528051,
                                                        57.571043,
                                                        57.614042,
                                                        57.657049,
                                                        57.700062,
                                                        57.743083,
                                                        57.786112,
                                                        57.829148,
                                                        57.872191,
                                                        57.915241,
                                                        57.958298,
                                                        58.001363,
                                                        58.044436,
                                                        58.087515,
                                                        58.130602,
                                                        58.173696,
                                                        58.216797,
                                                        58.259906,
                                                        58.303021,
                                                        58.346145,
                                                        58.389275,
                                                        58.432412,
                                                        58.475557,
                                                        58.518709,
                                                        58.561869,
                                                        58.605035,
                                                        58.648209,
                                                        58.691390,
                                                        58.734579,
                                                        58.777774,
                                                        58.820977,
                                                        58.864187,
                                                        58.907404,
                                                        58.950628,
                                                        58.993860,
                                                        59.037099,
                                                        59.080345,
                                                        59.123598,
                                                        59.166858,
                                                        59.210126,
                                                        59.253401,
                                                        59.296683,
                                                        59.339972,
                                                        59.383268,
                                                        59.426572,
                                                        59.469882,
                                                        59.513200,
                                                        59.556525,
                                                        59.599857,
                                                        59.643196,
                                                        59.686543,
                                                        59.729897,
                                                        59.773257,
                                                        59.816625,
                                                        59.860000,
                                                        59.903382,
                                                        59.946772,
                                                        59.990168,
                                                        60.033571,
                                                        60.076982,
                                                        60.120400,
                                                        60.163825,
                                                        60.207257,
                                                        60.250696,
                                                        60.294142,
                                                        60.337595,
                                                        60.381056,
                                                        60.424523,
                                                        60.467998,
                                                        60.511479,
                                                        60.554968,
                                                        60.598464,
                                                        60.641967,
                                                        60.685477,
                                                        60.728994,
                                                        60.772518,
                                                        60.816049,
                                                        60.859587,
                                                        60.903132,
                                                        60.946685,
                                                        60.990244,
                                                        61.033810,
                                                        61.077384,
                                                        61.120964,
                                                        61.164552,
                                                        61.208146,
                                                        61.251748,
                                                        61.295357,
                                                        61.338972,
                                                        61.382595,
                                                        61.426224,
                                                        61.469861,
                                                        61.513505,
                                                        61.557155,
                                                        61.600813,
                                                        61.644478,
                                                        61.688149,
                                                        61.731828,
                                                        61.775513,
                                                        61.819206,
                                                        61.862906,
                                                        61.906612,
                                                        61.950326,
                                                        61.994046,
                                                        62.037774,
                                                        62.081508,
                                                        62.125249,
                                                        62.168998,
                                                        62.212753,
                                                        62.256515,
                                                        62.300284,
                                                        62.344060,
                                                        62.387843,
                                                        62.431633,
                                                        62.475430,
                                                        62.519234,
                                                        62.563045,
                                                        62.606862,
                                                        62.650687,
                                                        62.694519,
                                                        62.738357,
                                                        62.782202,
                                                        62.826055,
                                                        62.869914,
                                                        62.913780,
                                                        62.957653,
                                                        63.001533,
                                                        63.045419,
                                                        63.089313,
                                                        63.133213,
                                                        63.177121,
                                                        63.221035,
                                                        63.264956,
                                                        63.308884,
                                                        63.352819,
                                                        63.396760,
                                                        63.440709,
                                                        63.484664,
                                                        63.528627,
                                                        63.572596,
                                                        63.616572,
                                                        63.660555,
                                                        63.704544,
                                                        63.748541,
                                                        63.792544,
                                                        63.836554,
                                                        63.880571,
                                                        63.924595,
                                                        63.968626,
                                                        64.012663,
                                                        64.056707,
                                                        64.100758,
                                                        64.144816,
                                                        64.188881,
                                                        64.232952,
                                                        64.277030,
                                                        64.321116,
                                                        64.365207,
                                                        64.409306,
                                                        64.453411,
                                                        64.497524,
                                                        64.541643,
                                                        64.585768,
                                                        64.629901,
                                                        64.674040,
                                                        64.718186,
                                                        64.762339,
                                                        64.806499,
                                                        64.850665,
                                                        64.894838,
                                                        64.939018,
                                                        64.983205,
                                                        65.027398,
                                                        65.071598,
                                                        65.115805,
                                                        65.160018,
                                                        65.204239,
                                                        65.248466,
                                                        65.292699,
                                                        65.336940,
                                                        65.381187,
                                                        65.425441,
                                                        65.469701,
                                                        65.513969,
                                                        65.558243,
                                                        65.602523,
                                                        65.646811,
                                                        65.691105,
                                                        65.735406,
                                                        65.779713,
                                                        65.824027,
                                                        65.868348,
                                                        65.912676,
                                                        65.957010,
                                                        66.001351,
                                                        66.045698,
                                                        66.090053,
                                                        66.134414,
                                                        66.178781,
                                                        66.223155,
                                                        66.267536,
                                                        66.311924,
                                                        66.356318,
                                                        66.400719,
                                                        66.445126,
                                                        66.489540,
                                                        66.533961,
                                                        66.578389,
                                                        66.622823,
                                                        66.667263,
                                                        66.711710,
                                                        66.756164,
                                                        66.800625,
                                                        66.845092,
                                                        66.889566,
                                                        66.934046,
                                                        66.978533,
                                                        67.023027,
                                                        67.067527,
                                                        67.112034,
                                                        67.156547,
                                                        67.201067,
                                                        67.245593,
                                                        67.290127,
                                                        67.334666,
                                                        67.379213,
                                                        67.423766,
                                                        67.468325,
                                                        67.512891,
                                                        67.557464,
                                                        67.602043,
                                                        67.646628,
                                                        67.691221,
                                                        67.735820,
                                                        67.780425,
                                                        67.825037,
                                                        67.869655,
                                                        67.914280,
                                                        67.958912,
                                                        68.003550,
                                                        68.048195,
                                                        68.092846,
                                                        68.137504,
                                                        68.182168,
                                                        68.226839,
                                                        68.271516,
                                                        68.316200,
                                                        68.360890,
                                                        68.405587,
                                                        68.450290,
                                                        68.495000,
                                                        68.539716,
                                                        68.584439,
                                                        68.629169,
                                                        68.673904,
                                                        68.718647,
                                                        68.763396,
                                                        68.808151,
                                                        68.852913,
                                                        68.897681,
                                                        68.942456,
                                                        68.987237,
                                                        69.032025,
                                                        69.076819,
                                                        69.121619,
                                                        69.166426,
                                                        69.211240,
                                                        69.256060,
                                                        69.300886,
                                                        69.345719,
                                                        69.390559,
                                                        69.435405,
                                                        69.480257,
                                                        69.525115,
                                                        69.569981,
                                                        69.614852,
                                                        69.659730,
                                                        69.704615,
                                                        69.749505,
                                                        69.794403,
                                                        69.839306,
                                                        69.884216,
                                                        69.929133,
                                                        69.974056,
                                                        70.018985,
                                                        70.063921,
                                                        70.108863,
                                                        70.153812,
                                                        70.198767,
                                                        70.243728,
                                                        70.288696,
                                                        70.333670,
                                                        70.378650,
                                                        70.423637,
                                                        70.468630,
                                                        70.513630,
                                                        70.558636,
                                                        70.603648,
                                                        70.648667,
                                                        70.693692,
                                                        70.738724,
                                                        70.783762,
                                                        70.828806,
                                                        70.873856,
                                                        70.918913,
                                                        70.963976,
                                                        71.009046,
                                                        71.054122,
                                                        71.099204,
                                                        71.144293,
                                                        71.189388,
                                                        71.234489,
                                                        71.279597,
                                                        71.324711,
                                                        71.369831,
                                                        71.414957,
                                                        71.460090,
                                                        71.505230,
                                                        71.550375,
                                                        71.595527,
                                                        71.640685,
                                                        71.685850,
                                                        71.731020,
                                                        71.776197,
                                                        71.821381,
                                                        71.866570,
                                                        71.911766,
                                                        71.956968,
                                                        72.002177,
                                                        72.047392,
                                                        72.092613,
                                                        72.137840,
                                                        72.183074,
                                                        72.228314,
                                                        72.273560,
                                                        72.318812,
                                                        72.364071,
                                                        72.409336,
                                                        72.454607,
                                                        72.499885,
                                                        72.545168,
                                                        72.590458,
                                                        72.635755,
                                                        72.681057,
                                                        72.726366,
                                                        72.771681,
                                                        72.817002,
                                                        72.862329,
                                                        72.907663,
                                                        72.953003,
                                                        72.998349,
                                                        73.043701,
                                                        73.089060,
                                                        73.134424,
                                                        73.179795,
                                                        73.225173,
                                                        73.270556,
                                                        73.315946,
                                                        73.361341,
                                                        73.406743,
                                                        73.452152,
                                                        73.497566,
                                                        73.542987,
                                                        73.588413,
                                                        73.633846,
                                                        73.679285,
                                                        73.724731,
                                                        73.770182,
                                                        73.815640,
                                                        73.861104,
                                                        73.906574,
                                                        73.952050,
                                                        73.997532,
                                                        74.043021,
                                                        74.088516,
                                                        74.134017,
                                                        74.179524,
                                                        74.225037,
                                                        74.270556,
                                                        74.316082,
                                                        74.361613,
                                                        74.407151,
                                                        74.452695,
                                                        74.498245,
                                                        74.543801,
                                                        74.589363,
                                                        74.634932,
                                                        74.680506,
                                                        74.726087,
                                                        74.771674,
                                                        74.817267,
                                                        74.862866,
                                                        74.908471,
                                                        74.954082,
                                                        74.999700,
                                                        75.045323,
                                                        75.090953,
                                                        75.136589,
                                                        75.182230,
                                                        75.227878,
                                                        75.273532,
                                                        75.319192,
                                                        75.364859,
                                                        75.410531,
                                                        75.456209,
                                                        75.501894,
                                                        75.547584,
                                                        75.593281,
                                                        75.638983,
                                                        75.684692,
                                                        75.730407,
                                                        75.776128,
                                                        75.821855,
                                                        75.867588,
                                                        75.913327,
                                                        75.959072,
                                                        76.004823,
                                                        76.050580,
                                                        76.096343,
                                                        76.142113,
                                                        76.187888,
                                                        76.233670,
                                                        76.279457,
                                                        76.325250,
                                                        76.371050,
                                                        76.416855,
                                                        76.462667,
                                                        76.508485,
                                                        76.554308,
                                                        76.600138,
                                                        76.645973,
                                                        76.691815,
                                                        76.737663,
                                                        76.783516,
                                                        76.829376,
                                                        76.875242,
                                                        76.921113,
                                                        76.966991,
                                                        77.012875,
                                                        77.058764,
                                                        77.104660,
                                                        77.150562,
                                                        77.196469,
                                                        77.242383,
                                                        77.288303,
                                                        77.334228,
                                                        77.380160,
                                                        77.426097,
                                                        77.472041,
                                                        77.517990,
                                                        77.563946,
                                                        77.609907,
                                                        77.655875,
                                                        77.701848,
                                                        77.747827,
                                                        77.793813,
                                                        77.839804,
                                                        77.885801,
                                                        77.931804,
                                                        77.977813,
                                                        78.023828,
                                                        78.069849,
                                                        78.115876,
                                                        78.161909,
                                                        78.207948,
                                                        78.253992,
                                                        78.300043,
                                                        78.346100,
                                                        78.392162,
                                                        78.438231,
                                                        78.484305,
                                                        78.530385,
                                                        78.576471,
                                                        78.622563,
                                                        78.668661,
                                                        78.714765,
                                                        78.760875,
                                                        78.806991,
                                                        78.853112,
                                                        78.899240,
                                                        78.945373,
                                                        78.991512,
                                                        79.037657,
                                                        79.083808,
                                                        79.129965,
                                                        79.176128,
                                                        79.222297,
                                                        79.268471,
                                                        79.314652,
                                                        79.360838,
                                                        79.407030,
                                                        79.453228,
                                                        79.499432,
                                                        79.545642,
                                                        79.591858,
                                                        79.638079,
                                                        79.684307,
                                                        79.730540,
                                                        79.776779,
                                                        79.823024,
                                                        79.869275,
                                                        79.915531,
                                                        79.961794,
                                                        80.008062,
                                                        80.054336,
                                                        80.100616,
                                                        80.146902,
                                                        80.193194,
                                                        80.239491,
                                                        80.285794,
                                                        80.332103,
                                                        80.378418,
                                                        80.424739,
                                                        80.471066,
                                                        80.517398,
                                                        80.563736,
                                                        80.610080,
                                                        80.656430,
                                                        80.702786,
                                                        80.749147,
                                                        80.795514,
                                                        80.841887,
                                                        80.888266,
                                                        80.934651,
                                                        80.981041,
                                                        81.027437,
                                                        81.073839,
                                                        81.120247,
                                                        81.166661,
                                                        81.213080,
                                                        81.259505,
                                                        81.305936,
                                                        81.352373,
                                                        81.398815,
                                                        81.445263,
                                                        81.491717,
                                                        81.538177,
                                                        81.584642,
                                                        81.631113,
                                                        81.677590,
                                                        81.724073,
                                                        81.770562,
                                                        81.817056,
                                                        81.863556,
                                                        81.910062,
                                                        81.956573,
                                                        82.003090,
                                                        82.049613,
                                                        82.096142,
                                                        82.142676,
                                                        82.189216,
                                                        82.235762,
                                                        82.282314,
                                                        82.328871,
                                                        82.375434,
                                                        82.422003,
                                                        82.468578,
                                                        82.515158,
                                                        82.561744,
                                                        82.608335,
                                                        82.654933,
                                                        82.701536,
                                                        82.748144,
                                                        82.794759,
                                                        82.841379,
                                                        82.888005,
                                                        82.934636,
                                                        82.981274,
                                                        83.027917,
                                                        83.074565,
                                                        83.121219,
                                                        83.167879,
                                                        83.214545,
                                                        83.261216,
                                                        83.307893,
                                                        83.354576,
                                                        83.401264,
                                                        83.447958,
                                                        83.494658,
                                                        83.541364,
                                                        83.588075,
                                                        83.634791,
                                                        83.681514,
                                                        83.728242,
                                                        83.774975,
                                                        83.821715,
                                                        83.868460,
                                                        83.915210,
                                                        83.961966,
                                                        84.008728,
                                                        84.055496,
                                                        84.102269,
                                                        84.149048,
                                                        84.195832,
                                                        84.242622,
                                                        84.289418,
                                                        84.336219,
                                                        84.383026,
                                                        84.429839,
                                                        84.476657,
                                                        84.523481,
                                                        84.570311,
                                                        84.617146,
                                                        84.663986,
                                                        84.710833,
                                                        84.757684,
                                                        84.804542,
                                                        84.851405,
                                                        84.898274,
                                                        84.945148,
                                                        84.992028,
                                                        85.038914,
                                                        85.085805,
                                                        85.132701,
                                                        85.179604,
                                                        85.226511,
                                                        85.273425,
                                                        85.320344,
                                                        85.367269,
                                                        85.414199,
                                                        85.461135,
                                                        85.508076,
                                                        85.555023,
                                                        85.601975,
                                                        85.648933,
                                                        85.695897,
                                                        85.742866,
                                                        85.789841,
                                                        85.836821,
                                                        85.883807,
                                                        85.930798,
                                                        85.977795,
                                                        86.024798,
                                                        86.071806,
                                                        86.118820,
                                                        86.165839,
                                                        86.212863,
                                                        86.259894,
                                                        86.306929,
                                                        86.353971,
                                                        86.401018,
                                                        86.448070,
                                                        86.495128,
                                                        86.542191,
                                                        86.589260,
                                                        86.636335,
                                                        86.683415,
                                                        86.730500,
                                                        86.777591,
                                                        86.824688,
                                                        86.871790,
                                                        86.918897,
                                                        86.966010,
                                                        87.013129,
                                                        87.060253,
                                                        87.107383,
                                                        87.154518,
                                                        87.201658,
                                                        87.248804,
                                                        87.295956,
                                                        87.343113,
                                                        87.390276,
                                                        87.437444,
                                                        87.484617,
                                                        87.531796,
                                                        87.578981,
                                                        87.626171,
                                                        87.673366,
                                                        87.720567,
                                                        87.767773,
                                                        87.814985,
                                                        87.862202,
                                                        87.909425,
                                                        87.956653,
                                                        88.003887,
                                                        88.051126,
                                                        88.098371,
                                                        88.145621,
                                                        88.192877,
                                                        88.240138,
                                                        88.287404,
                                                        88.334676,
                                                        88.381953,
                                                        88.429236,
                                                        88.476524,
                                                        88.523818,
                                                        88.571117,
                                                        88.618422,
                                                        88.665732,
                                                        88.713047,
                                                        88.760368,
                                                        88.807694,
                                                        88.855026,
                                                        88.902363,
                                                        88.949705,
                                                        88.997053,
                                                        89.044407,
                                                        89.091765,
                                                        89.139130,
                                                        89.186499,
                                                        89.233874,
                                                        89.281255,
                                                        89.328641,
                                                        89.376032,
                                                        89.423428,
                                                        89.470830,
                                                        89.518238,
                                                        89.565651,
                                                        89.613069,
                                                        89.660492,
                                                        89.707921,
                                                        89.755356,
                                                        89.802796,
                                                        89.850241,
                                                        89.897691,
                                                        89.945147,
                                                        89.992608,
                                                        90.040075,
                                                        90.087547,
                                                        90.135024,
                                                        90.182507,
                                                        90.229995,
                                                        90.277489,
                                                        90.324988,
                                                        90.372492,
                                                        90.420001,
                                                        90.467516,
                                                        90.515037,
                                                        90.562562,
                                                        90.610093,
                                                        90.657630,
                                                        90.705171,
                                                        90.752718,
                                                        90.800271,
                                                        90.847828,
                                                        90.895391,
                                                        90.942960,
                                                        90.990534,
                                                        91.038113,
                                                        91.085697,
                                                        91.133287,
                                                        91.180882,
                                                        91.228482,
                                                        91.276088,
                                                        91.323699,
                                                        91.371315,
                                                        91.418937,
                                                        91.466564,
                                                        91.514196,
                                                        91.561834,
                                                        91.609477,
                                                        91.657125,
                                                        91.704778,
                                                        91.752437,
                                                        91.800101,
                                                        91.847771,
                                                        91.895445,
                                                        91.943125,
                                                        91.990811,
                                                        92.038501,
                                                        92.086197,
                                                        92.133898,
                                                        92.181605,
                                                        92.229316,
                                                        92.277033,
                                                        92.324756,
                                                        92.372483,
                                                        92.420216,
                                                        92.467954,
                                                        92.515698,
                                                        92.563446,
                                                        92.611200,
                                                        92.658960,
                                                        92.706724,
                                                        92.754494,
                                                        92.802269,
                                                        92.850049,
                                                        92.897834,
                                                        92.945625,
                                                        92.993421,
                                                        93.041223,
                                                        93.089029,
                                                        93.136841,
                                                        93.184658,
                                                        93.232480,
                                                        93.280308,
                                                        93.328140,
                                                        93.375978,
                                                        93.423822,
                                                        93.471670,
                                                        93.519524,
                                                        93.567383,
                                                        93.615247,
                                                        93.663116,
                                                        93.710991,
                                                        93.758870,
                                                        93.806756,
                                                        93.854646,
                                                        93.902541,
                                                        93.950442,
                                                        93.998348,
                                                        94.046259,
                                                        94.094175,
                                                        94.142097,
                                                        94.190024,
                                                        94.237955,
                                                        94.285893,
                                                        94.333835,
                                                        94.381782,
                                                        94.429735,
                                                        94.477693,
                                                        94.525656,
                                                        94.573625,
                                                        94.621598,
                                                        94.669577,
                                                        94.717561,
                                                        94.765550,
                                                        94.813544,
                                                        94.861543,
                                                        94.909548,
                                                        94.957558,
                                                        95.005573,
                                                        95.053593,
                                                        95.101618,
                                                        95.149649,
                                                        95.197684,
                                                        95.245725,
                                                        95.293771,
                                                        95.341822,
                                                        95.389878,
                                                        95.437940,
                                                        95.486006,
                                                        95.534078,
                                                        95.582155,
                                                        95.630237,
                                                        95.678324,
                                                        95.726416,
                                                        95.774514,
                                                        95.822617,
                                                        95.870724,
                                                        95.918837,
                                                        95.966955,
                                                        96.015078,
                                                        96.063207,
                                                        96.111340,
                                                        96.159479,
                                                        96.207623,
                                                        96.255771,
                                                        96.303925,
                                                        96.352084,
                                                        96.400249,
                                                        96.448418,
                                                        96.496592,
                                                        96.544772,
                                                        96.592956,
                                                        96.641146,
                                                        96.689341,
                                                        96.737541,
                                                        96.785746,
                                                        96.833956,
                                                        96.882172,
                                                        96.930392,
                                                        96.978618,
                                                        97.026848,
                                                        97.075084,
                                                        97.123325,
                                                        97.171571,
                                                        97.219822,
                                                        97.268078,
                                                        97.316339,
                                                        97.364605,
                                                        97.412876,
                                                        97.461153,
                                                        97.509434,
                                                        97.557721,
                                                        97.606012,
                                                        97.654309,
                                                        97.702611,
                                                        97.750918,
                                                        97.799230,
                                                        97.847547,
                                                        97.895869,
                                                        97.944196,
                                                        97.992528,
                                                        98.040865,
                                                        98.089207,
                                                        98.137555,
                                                        98.185907,
                                                        98.234265,
                                                        98.282627,
                                                        98.330995,
                                                        98.379367,
                                                        98.427745,
                                                        98.476128,
                                                        98.524515,
                                                        98.572908,
                                                        98.621306,
                                                        98.669709,
                                                        98.718117,
                                                        98.766530,
                                                        98.814948,
                                                        98.863371,
                                                        98.911799,
                                                        98.960232,
                                                        99.008670,
                                                        99.057113,
                                                        99.105561,
                                                        99.154014,
                                                        99.202472,
                                                        99.250935,
                                                        99.299403,
                                                        99.347877,
                                                        99.396355,
                                                        99.444838,
                                                        99.493326,
                                                        99.541819,
                                                        99.590318,
                                                        99.638821,
                                                        99.687329,
                                                        99.735842,
                                                        99.784360,
                                                        99.832884,
                                                        99.881412,
                                                        99.929945,
                                                        99.978483,
                                                        100.027026,
                                                        100.075574,
                                                        100.124128,
                                                        100.172686,
                                                        100.221249,
                                                        100.269817,
                                                        100.318390,
                                                        100.366968,
                                                        100.415551,
                                                        100.464139,
                                                        100.512732,
                                                        100.561330,
                                                        100.609933,
                                                        100.658541,
                                                        100.707153,
                                                        100.755771,
                                                        100.804394,
                                                        100.853022,
                                                        100.901654,
                                                        100.950292,
                                                        100.998935,
                                                        101.047582,
                                                        101.096235,
                                                        101.144892,
                                                        101.193554,
                                                        101.242222,
                                                        101.290894,
                                                        101.339571,
                                                        101.388253,
                                                        101.436940,
                                                        101.485632,
                                                        101.534329,
                                                        101.583031,
                                                        101.631738,
                                                        101.680450,
                                                        101.729166,
                                                        101.777888,
                                                        101.826615,
                                                        101.875346,
                                                        101.924082,
                                                        101.972824,
                                                        102.021570,
                                                        102.070321,
                                                        102.119077,
                                                        102.167838,
                                                        102.216604,
                                                        102.265375,
                                                        102.314150,
                                                        102.362931,
                                                        102.411716,
                                                        102.460507,
                                                        102.509302,
                                                        102.558102,
                                                        102.606907,
                                                        102.655717,
                                                        102.704532,
                                                        102.753352,
                                                        102.802177,
                                                        102.851006,
                                                        102.899841,
                                                        102.948680,
                                                        102.997524,
                                                        103.046373,
                                                        103.095227,
                                                        103.144086,
                                                        103.192950,
                                                        103.241819,
                                                        103.290692,
                                                        103.339571,
                                                        103.388454,
                                                        103.437342,
                                                        103.486235,
                                                        103.535133,
                                                        103.584035,
                                                        103.632943,
                                                        103.681856,
                                                        103.730773,
                                                        103.779695,
                                                        103.828622,
                                                        103.877554,
                                                        103.926491,
                                                        103.975432,
                                                        104.024379,
                                                        104.073330,
                                                        104.122286,
                                                        104.171247,
                                                        104.220213,
                                                        104.269183,
                                                        104.318159,
                                                        104.367139,
                                                        104.416124,
                                                        104.465115,
                                                        104.514109,
                                                        104.563109,
                                                        104.612114,
                                                        104.661123,
                                                        104.710137,
                                                        104.759156,
                                                        104.808180,
                                                        104.857209,
                                                        104.906242,
                                                        104.955280,
                                                        105.004323,
                                                        105.053371,
                                                        105.102424,
                                                        105.151482,
                                                        105.200544,
                                                        105.249611,
                                                        105.298683,
                                                        105.347760,
                                                        105.396841,
                                                        105.445928,
                                                        105.495019,
                                                        105.544115,
                                                        105.593216,
                                                        105.642321,
                                                        105.691432,
                                                        105.740547,
                                                        105.789667,
                                                        105.838792,
                                                        105.887921,
                                                        105.937056,
                                                        105.986195,
                                                        106.035339,
                                                        106.084487,
                                                        106.133641,
                                                        106.182799,
                                                        106.231962,
                                                        106.281130,
                                                        106.330303,
                                                        106.379480,
                                                        106.428662,
                                                        106.477849,
                                                        106.527041,
                                                        106.576237,
                                                        106.625438,
                                                        106.674644,
                                                        106.723855,
                                                        106.773070,
                                                        106.822291,
                                                        106.871516,
                                                        106.920745,
                                                        106.969980,
                                                        107.019219,
                                                        107.068463,
                                                        107.117712,
                                                        107.166966,
                                                        107.216224,
                                                        107.265487,
                                                        107.314755,
                                                        107.364027,
                                                        107.413304,
                                                        107.462586,
                                                        107.511873,
                                                        107.561165,
                                                        107.610461,
                                                        107.659762,
                                                        107.709067,
                                                        107.758378,
                                                        107.807693,
                                                        107.857013,
                                                        107.906337,
                                                        107.955667,
                                                        108.005001,
                                                        108.054339,
                                                        108.103683,
                                                        108.153031,
                                                        108.202384,
                                                        108.251741,
                                                        108.301104,
                                                        108.350471,
                                                        108.399842,
                                                        108.449219,
                                                        108.498600,
                                                        108.547986,
                                                        108.597376,
                                                        108.646772,
                                                        108.696172,
                                                        108.745576,
                                                        108.794986,
                                                        108.844400,
                                                        108.893818,
                                                        108.943242,
                                                        108.992670,
                                                        109.042103,
                                                        109.091540,
                                                        109.140982,
                                                        109.190429,
                                                        109.239881,
                                                        109.289337,
                                                        109.338798,
                                                        109.388264,
                                                        109.437734,
                                                        109.487209,
                                                        109.536689,
                                                        109.586173,
                                                        109.635662,
                                                        109.685155,
                                                        109.734654,
                                                        109.784157,
                                                        109.833664,
                                                        109.883177,
                                                        109.932694,
                                                        109.982215,
                                                        110.031742,
                                                        110.081273,
                                                        110.130808,
                                                        110.180348,
                                                        110.229893,
                                                        110.279443,
                                                        110.328997,
                                                        110.378556,
                                                        110.428120,
                                                        110.477688,
                                                        110.527260,
                                                        110.576838,
                                                        110.626420,
                                                        110.676007,
                                                        110.725598,
                                                        110.775194,
                                                        110.824795,
                                                        110.874400,
                                                        110.924010,
                                                        110.973624,
                                                        111.023244,
                                                        111.072867,
                                                        111.122496,
                                                        111.172129,
                                                        111.221767,
                                                        111.271409,
                                                        111.321056,
                                                        111.370707,
                                                        111.420363,
                                                        111.470024,
                                                        111.519690,
                                                        111.569360,
                                                        111.619034,
                                                        111.668713,
                                                        111.718397,
                                                        111.768086,
                                                        111.817779,
                                                        111.867476,
                                                        111.917179,
                                                        111.966885,
                                                        112.016597,
                                                        112.066313,
                                                        112.116034,
                                                        112.165759,
                                                        112.215489,
                                                        112.265223,
                                                        112.314962,
                                                        112.364706,
                                                        112.414454,
                                                        112.464207,
                                                        112.513964,
                                                        112.563726,
                                                        112.613493,
                                                        112.663264,
                                                        112.713039,
                                                        112.762820,
                                                        112.812604,
                                                        112.862394,
                                                        112.912188,
                                                        112.961986,
                                                        113.011790,
                                                        113.061597,
                                                        113.111410,
                                                        113.161226,
                                                        113.211048,
                                                        113.260874,
                                                        113.310704,
                                                        113.360539,
                                                        113.410379,
                                                        113.460223,
                                                        113.510072,
                                                        113.559925,
                                                        113.609783,
                                                        113.659646,
                                                        113.709513,
                                                        113.759384,
                                                        113.809260,
                                                        113.859141,
                                                        113.909026,
                                                        113.958916,
                                                        114.008810,
                                                        114.058709,
                                                        114.108612,
                                                        114.158520,
                                                        114.208433,
                                                        114.258349,
                                                        114.308271,
                                                        114.358197,
                                                        114.408128,
                                                        114.458063,
                                                        114.508002,
                                                        114.557946,
                                                        114.607895,
                                                        114.657848,
                                                        114.707806,
                                                        114.757768,
                                                        114.807735,
                                                        114.857706,
                                                        114.907682,
                                                        114.957662,
                                                        115.007647,
                                                        115.057636,
                                                        115.107630,
                                                        115.157628,
                                                        115.207631,
                                                        115.257639,
                                                        115.307650,
                                                        115.357667,
                                                        115.407688,
                                                        115.457713,
                                                        115.507743,
                                                        115.557777,
                                                        115.607816,
                                                        115.657859,
                                                        115.707907,
                                                        115.757960,
                                                        115.808016,
                                                        115.858078,
                                                        115.908144,
                                                        115.958214,
                                                        116.008289,
                                                        116.058368,
                                                        116.108452,
                                                        116.158540,
                                                        116.208633,
                                                        116.258730,
                                                        116.308831,
                                                        116.358938,
                                                        116.409048,
                                                        116.459163,
                                                        116.509283,
                                                        116.559407,
                                                        116.609535,
                                                        116.659668,
                                                        116.709806,
                                                        116.759948,
                                                        116.810094,
                                                        116.860245,
                                                        116.910400,
                                                        116.960560,
                                                        117.010724,
                                                        117.060893,
                                                        117.111066,
                                                        117.161243,
                                                        117.211425,
                                                        117.261612,
                                                        117.311803,
                                                        117.361998,
                                                        117.412198,
                                                        117.462402,
                                                        117.512611,
                                                        117.562824,
                                                        117.613042,
                                                        117.663264,
                                                        117.713490,
                                                        117.763721,
                                                        117.813956,
                                                        117.864196,
                                                        117.914440,
                                                        117.964689,
                                                        118.014942,
                                                        118.065200,
                                                        118.115461,
                                                        118.165728,
                                                        118.215999,
                                                        118.266274,
                                                        118.316553,
                                                        118.366837,
                                                        118.417126,
                                                        118.467419,
                                                        118.517716,
                                                        118.568018,
                                                        118.618324,
                                                        118.668635,
                                                        118.718949,
                                                        118.769269,
                                                        118.819593,
                                                        118.869921,
                                                        118.920253,
                                                        118.970590,
                                                        119.020932,
                                                        119.071278,
                                                        119.121628,
                                                        119.171982,
                                                        119.222341,
                                                        119.272705,
                                                        119.323073,
                                                        119.373445,
                                                        119.423821,
                                                        119.474202,
                                                        119.524588,
                                                        119.574977,
                                                        119.625372,
                                                        119.675770,
                                                        119.726173,
                                                        119.776580,
                                                        119.826992,
                                                        119.877408,
                                                        119.927828,
                                                        119.978253,
                                                        120.028682,
                                                        120.079116,
                                                        120.129554,
                                                        120.179996,
                                                        120.230443,
                                                        120.280894,
                                                        120.331349,
                                                        120.381809,
                                                        120.432273,
                                                        120.482742,
                                                        120.533215,
                                                        120.583692,
                                                        120.634173,
                                                        120.684659,
                                                        120.735150,
                                                        120.785644,
                                                        120.836143,
                                                        120.886647,
                                                        120.937155,
                                                        120.987667,
                                                        121.038183,
                                                        121.088704,
                                                        121.139229,
                                                        121.189759,
                                                        121.240292,
                                                        121.290831,
                                                        121.341373,
                                                        121.391920,
                                                        121.442471,
                                                        121.493027,
                                                        121.543587,
                                                        121.594151,
                                                        121.644719,
                                                        121.695292,
                                                        121.745869,
                                                        121.796451,
                                                        121.847037,
                                                        121.897627,
                                                        121.948222,
                                                        121.998820,
                                                        122.049424,
                                                        122.100031,
                                                        122.150643,
                                                        122.201259,
                                                        122.251879,
                                                        122.302504,
                                                        122.353133,
                                                        122.403767,
                                                        122.454404,
                                                        122.505047,
                                                        122.555693,
                                                        122.606344,
                                                        122.656998,
                                                        122.707658,
                                                        122.758321,
                                                        122.808989,
                                                        122.859661,
                                                        122.910338,
                                                        122.961019,
                                                        123.011704,
                                                        123.062393,
                                                        123.113087,
                                                        123.163785,
                                                        123.214487,
                                                        123.265194,
                                                        123.315905,
                                                        123.366620,
                                                        123.417339,
                                                        123.468063,
                                                        123.518791,
                                                        123.569523,
                                                        123.620260,
                                                        123.671001,
                                                        123.721746,
                                                        123.772495,
                                                        123.823249,
                                                        123.874007,
                                                        123.924769,
                                                        123.975536,
                                                        124.026307,
                                                        124.077082,
                                                        124.127861,
                                                        124.178645,
                                                        124.229433,
                                                        124.280225,
                                                        124.331021,
                                                        124.381822,
                                                        124.432627,
                                                        124.483436,
                                                        124.534250,
                                                        124.585067,
                                                        124.635889,
                                                        124.686716,
                                                        124.737546,
                                                        124.788381,
                                                        124.839220,
                                                        124.890063,
                                                        124.940911,
                                                        124.991763,
                                                        125.042619,
                                                        125.093479,
                                                        125.144344,
                                                        125.195212,
                                                        125.246085,
                                                        125.296963,
                                                        125.347844,
                                                        125.398730,
                                                        125.449620,
                                                        125.500514,
                                                        125.551413,
                                                        125.602315,
                                                        125.653222,
                                                        125.704133,
                                                        125.755049,
                                                        125.805968,
                                                        125.856892,
                                                        125.907820,
                                                        125.958753,
                                                        126.009689,
                                                        126.060630,
                                                        126.111575,
                                                        126.162524,
                                                        126.213478,
                                                        126.264435,
                                                        126.315397,
                                                        126.366363,
                                                        126.417333,
                                                        126.468308,
                                                        126.519287,
                                                        126.570270,
                                                        126.621257,
                                                        126.672248,
                                                        126.723244,
                                                        126.774244,
                                                        126.825248,
                                                        126.876256,
                                                        126.927268,
                                                        126.978285,
                                                        127.029305,
                                                        127.080330,
                                                        127.131360,
                                                        127.182393,
                                                        127.233431,
                                                        127.284472,
                                                        127.335518,
                                                        127.386569,
                                                        127.437623,
                                                        127.488681,
                                                        127.539744,
                                                        127.590811,
                                                        127.641882,
                                                        127.692957,
                                                        127.744037,
                                                        127.795121,
                                                        127.846208,
                                                        127.897300,
                                                        127.948397,
                                                        127.999497,
                                                        128.050602,
                                                        128.101710,
                                                        128.152823,
                                                        128.203940,
                                                        128.255062,
                                                        128.306187,
                                                        128.357317,
                                                        128.408450,
                                                        128.459588,
                                                        128.510730,
                                                        128.561877,
                                                        128.613027,
                                                        128.664182,
                                                        128.715340,
                                                        128.766503,
                                                        128.817670,
                                                        128.868841,
                                                        128.920017,
                                                        128.971196,
                                                        129.022380,
                                                        129.073568,
                                                        129.124760,
                                                        129.175956,
                                                        129.227156,
                                                        129.278361,
                                                        129.329569,
                                                        129.380782,
                                                        129.431999,
                                                        129.483220,
                                                        129.534445,
                                                        129.585674,
                                                        129.636908,
                                                        129.688145,
                                                        129.739387,
                                                        129.790633,
                                                        129.841883,
                                                        129.893137,
                                                        129.944395,
                                                        129.995658,
                                                        130.046924,
                                                        130.098195,
                                                        130.149470,
                                                        130.200748,
                                                        130.252031,
                                                        130.303319,
                                                        130.354610,
                                                        130.405905,
                                                        130.457205,
                                                        130.508508,
                                                        130.559816,
                                                        130.611128,
                                                        130.662444,
                                                        130.713764,
                                                        130.765088,
                                                        130.816416,
                                                        130.867749,
                                                        130.919085,
                                                        130.970426,
                                                        131.021771,
                                                        131.073120,
                                                        131.124473,
                                                        131.175830,
                                                        131.227191,
                                                        131.278556,
                                                        131.329926,
                                                        131.381299,
                                                        131.432677,
                                                        131.484058,
                                                        131.535444,
                                                        131.586834,
                                                        131.638228,
                                                        131.689626,
                                                        131.741028,
                                                        131.792434,
                                                        131.843845,
                                                        131.895259,
                                                        131.946677,
                                                        131.998100,
                                                        132.049527,
                                                        132.100957,
                                                        132.152392,
                                                        132.203831,
                                                        132.255274,
                                                        132.306721,
                                                        132.358172,
                                                        132.409628,
                                                        132.461087,
                                                        132.512550,
                                                        132.564018,
                                                        132.615489,
                                                        132.666965,
                                                        132.718444,
                                                        132.769928,
                                                        132.821416,
                                                        132.872908,
                                                        132.924404,
                                                        132.975904,
                                                        133.027408,
                                                        133.078916,
                                                        133.130428,
                                                        133.181944,
                                                        133.233464,
                                                        133.284989,
                                                        133.336517,
                                                        133.388050,
                                                        133.439586,
                                                        133.491127,
                                                        133.542671,
                                                        133.594220,
                                                        133.645773,
                                                        133.697329,
                                                        133.748890,
                                                        133.800455,
                                                        133.852024,
                                                        133.903597,
                                                        133.955174,
                                                        134.006755,
                                                        134.058340,
                                                        134.109929,
                                                        134.161522,
                                                        134.213119,
                                                        134.264720,
                                                        134.316326,
                                                        134.367935,
                                                        134.419548,
                                                        134.471166,
                                                        134.522787,
                                                        134.574412,
                                                        134.626042,
                                                        134.677675,
                                                        134.729313,
                                                        134.780954,
                                                        134.832600,
                                                        134.884249,
                                                        134.935903,
                                                        134.987560,
                                                        135.039222,
                                                        135.090888,
                                                        135.142557,
                                                        135.194231,
                                                        135.245908,
                                                        135.297590,
                                                        135.349276,
                                                        135.400966,
                                                        135.452659,
                                                        135.504357,
                                                        135.556059,
                                                        135.607764,
                                                        135.659474,
                                                        135.711188,
                                                        135.762906,
                                                        135.814627,
                                                        135.866353,
                                                        135.918083,
                                                        135.969817,
                                                        136.021554,
                                                        136.073296,
                                                        136.125042,
                                                        136.176791,
                                                        136.228545,
                                                        136.280303,
                                                        136.332065,
                                                        136.383830,
                                                        136.435600,
                                                        136.487374,
                                                        136.539151,
                                                        136.590933,
                                                        136.642718,
                                                        136.694508,
                                                        136.746302,
                                                        136.798099,
                                                        136.849901,
                                                        136.901706,
                                                        136.953516,
                                                        137.005329,
                                                        137.057147,
                                                        137.108968,
                                                        137.160793,
                                                        137.212623,
                                                        137.264456,
                                                        137.316293,
                                                        137.368135,
                                                        137.419980,
                                                        137.471829,
                                                        137.523682,
                                                        137.575539,
                                                        137.627401,
                                                        137.679266,
                                                        137.731135,
                                                        137.783008,
                                                        137.834885,
                                                        137.886765,
                                                        137.938650,
                                                        137.990539,
                                                        138.042432,
                                                        138.094329,
                                                        138.146229,
                                                        138.198134,
                                                        138.250043,
                                                        138.301955,
                                                        138.353871,
                                                        138.405792,
                                                        138.457716,
                                                        138.509645,
                                                        138.561577,
                                                        138.613513,
                                                        138.665453,
                                                        138.717397,
                                                        138.769345,
                                                        138.821297,
                                                        138.873253,
                                                        138.925213,
                                                        138.977177,
                                                        139.029144,
                                                        139.081116,
                                                        139.133092,
                                                        139.185071,
                                                        139.237055,
                                                        139.289042,
                                                        139.341033,
                                                        139.393028,
                                                        139.445027,
                                                        139.497031,
                                                        139.549038,
                                                        139.601048,
                                                        139.653063,
                                                        139.705082,
                                                        139.757105,
                                                        139.809131,
                                                        139.861162,
                                                        139.913196,
                                                        139.965234,
                                                        140.017277,
                                                        140.069323,
                                                        140.121373,
                                                        140.173427,
                                                        140.225485,
                                                        140.277547,
                                                        140.329612,
                                                        140.381682,
                                                        140.433755,
                                                        140.485833,
                                                        140.537914,
                                                        140.589999,
                                                        140.642088,
                                                        140.694181,
                                                        140.746278,
                                                        140.798379,
                                                        140.850484,
                                                        140.902593,
                                                        140.954705,
                                                        141.006821,
                                                        141.058942,
                                                        141.111066,
                                                        141.163194,
                                                        141.215326,
                                                        141.267462,
                                                        141.319602,
                                                        141.371745,
                                                        141.423893,
                                                        141.476044,
                                                        141.528199,
                                                        141.580359,
                                                        141.632522,
                                                        141.684689,
                                                        141.736859,
                                                        141.789034,
                                                        141.841213,
                                                        141.893395,
                                                        141.945581,
                                                        141.997771,
                                                        142.049966,
                                                        142.102163,
                                                        142.154365,
                                                        142.206571,
                                                        142.258780,
                                                        142.310994,
                                                        142.363211,
                                                        142.415432,
                                                        142.467657,
                                                        142.519886,
                                                        142.572119,
                                                        142.624355,
                                                        142.676596,
                                                        142.728840,
                                                        142.781088,
                                                        142.833340,
                                                        142.885596,
                                                        142.937856,
                                                        142.990120,
                                                        143.042387,
                                                        143.094658,
                                                        143.146933,
                                                        143.199212,
                                                        143.251495,
                                                        143.303782,
                                                        143.356073,
                                                        143.408367,
                                                        143.460665,
                                                        143.512967,
                                                        143.565273,
                                                        143.617583,
                                                        143.669896,
                                                        143.722214,
                                                        143.774535,
                                                        143.826860,
                                                        143.879189,
                                                        143.931522,
                                                        143.983859,
                                                        144.036199,
                                                        144.088543,
                                                        144.140892,
                                                        144.193243,
                                                        144.245599,
                                                        144.297959,
                                                        144.350322,
                                                        144.402690,
                                                        144.455061,
                                                        144.507436,
                                                        144.559814,
                                                        144.612197,
                                                        144.664583,
                                                        144.716973,
                                                        144.769367,
                                                        144.821765,
                                                        144.874167,
                                                        144.926572,
                                                        144.978982,
                                                        145.031395,
                                                        145.083812,
                                                        145.136232,
                                                        145.188657,
                                                        145.241085,
                                                        145.293518,
                                                        145.345953,
                                                        145.398393,
                                                        145.450837,
                                                        145.503284,
                                                        145.555735,
                                                        145.608190,
                                                        145.660649,
                                                        145.713112,
                                                        145.765578,
                                                        145.818048,
                                                        145.870522,
                                                        145.923000,
                                                        145.975482,
                                                        146.027967,
                                                        146.080456,
                                                        146.132949,
                                                        146.185446,
                                                        146.237947,
                                                        146.290451,
                                                        146.342959,
                                                        146.395471,
                                                        146.447987,
                                                        146.500506,
                                                        146.553030,
                                                        146.605557,
                                                        146.658087,
                                                        146.710622,
                                                        146.763160,
                                                        146.815703,
                                                        146.868249,
                                                        146.920798,
                                                        146.973352,
                                                        147.025909,
                                                        147.078470,
                                                        147.131035,
                                                        147.183604,
                                                        147.236176,
                                                        147.288752,
                                                        147.341332,
                                                        147.393916,
                                                        147.446504,
                                                        147.499095,
                                                        147.551690,
                                                        147.604289,
                                                        147.656891,
                                                        147.709497,
                                                        147.762108,
                                                        147.814721,
                                                        147.867339,
                                                        147.919960,
                                                        147.972585,
                                                        148.025214,
                                                        148.077847,
                                                        148.130483,
                                                        148.183123,
                                                        148.235767,
                                                        148.288415,
                                                        148.341066,
                                                        148.393722,
                                                        148.446380,
                                                        148.499043,
                                                        148.551710,
                                                        148.604380,
                                                        148.657054,
                                                        148.709731,
                                                        148.762413,
                                                        148.815098,
                                                        148.867787,
                                                        148.920479,
                                                        148.973176,
                                                        149.025876,
                                                        149.078579,
                                                        149.131287,
                                                        149.183998,
                                                        149.236713,
                                                        149.289432,
                                                        149.342155,
                                                        149.394881,
                                                        149.447611,
                                                        149.500344,
                                                        149.553082,
                                                        149.605823,
                                                        149.658568,
                                                        149.711317,
                                                        149.764069,
                                                        149.816825,
                                                        149.869585,
                                                        149.922348,
                                                        149.975115,
                                                        150.027886,
                                                        150.080661,
                                                        150.133439,
                                                        150.186222,
                                                        150.239007,
                                                        150.291797,
                                                        150.344590,
                                                        150.397387,
                                                        150.450188,
                                                        150.502992,
                                                        150.555800,
                                                        150.608612,
                                                        150.661428,
                                                        150.714247,
                                                        150.767070,
                                                        150.819896,
                                                        150.872727,
                                                        150.925561,
                                                        150.978399,
                                                        151.031240,
                                                        151.084085,
                                                        151.136934,
                                                        151.189787,
                                                        151.242643,
                                                        151.295503,
                                                        151.348367,
                                                        151.401234,
                                                        151.454105,
                                                        151.506980,
                                                        151.559858,
                                                        151.612740,
                                                        151.665626,
                                                        151.718516,
                                                        151.771409,
                                                        151.824306,
                                                        151.877206,
                                                        151.930111,
                                                        151.983019,
                                                        152.035930,
                                                        152.088846,
                                                        152.141765,
                                                        152.194687,
                                                        152.247614,
                                                        152.300544,
                                                        152.353477,
                                                        152.406415,
                                                        152.459356,
                                                        152.512301,
                                                        152.565249,
                                                        152.618201,
                                                        152.671157,
                                                        152.724116,
                                                        152.777080,
                                                        152.830046,
                                                        152.883017,
                                                        152.935991,
                                                        152.988969,
                                                        153.041950,
                                                        153.094935,
                                                        153.147924,
                                                        153.200917,
                                                        153.253913,
                                                        153.306913,
                                                        153.359916,
                                                        153.412923,
                                                        153.465934,
                                                        153.518948,
                                                        153.571966,
                                                        153.624988,
                                                        153.678014,
                                                        153.731043,
                                                        153.784075,
                                                        153.837112,
                                                        153.890152,
                                                        153.943195,
                                                        153.996243,
                                                        154.049294,
                                                        154.102348,
                                                        154.155407,
                                                        154.208469,
                                                        154.261534,
                                                        154.314603,
                                                        154.367676,
                                                        154.420753,
                                                        154.473833,
                                                        154.526917,
                                                        154.580004,
                                                        154.633095,
                                                        154.686190,
                                                        154.739288,
                                                        154.792390,
                                                        154.845496,
                                                        154.898605,
                                                        154.951718,
                                                        155.004834,
                                                        155.057954,
                                                        155.111078,
                                                        155.164205,
                                                        155.217336,
                                                        155.270471,
                                                        155.323609,
                                                        155.376751,
                                                        155.429897,
                                                        155.483046,
                                                        155.536199,
                                                        155.589355,
                                                        155.642515,
                                                        155.695679,
                                                        155.748846,
                                                        155.802017,
                                                        155.855192,
                                                        155.908370,
                                                        155.961551,
                                                        156.014737,
                                                        156.067926,
                                                        156.121118,
                                                        156.174314,
                                                        156.227514,
                                                        156.280718,
                                                        156.333925,
                                                        156.387135,
                                                        156.440350,
                                                        156.493567,
                                                        156.546789,
                                                        156.600014,
                                                        156.653243,
                                                        156.706475,
                                                        156.759711,
                                                        156.812950,
                                                        156.866193,
                                                        156.919440,
                                                        156.972690,
                                                        157.025944,
                                                        157.079202,
                                                        157.132463,
                                                        157.185727,
                                                        157.238996,
                                                        157.292268,
                                                        157.345543,
                                                        157.398822,
                                                        157.452105,
                                                        157.505391,
                                                        157.558681,
                                                        157.611974,
                                                        157.665271,
                                                        157.718572,
                                                        157.771876,
                                                        157.825184,
                                                        157.878495,
                                                        157.931810,
                                                        157.985128,
                                                        158.038450,
                                                        158.091776,
                                                        158.145105,
                                                        158.198438,
                                                        158.251775,
                                                        158.305115,
                                                        158.358458,
                                                        158.411805,
                                                        158.465156,
                                                        158.518510,
                                                        158.571868,
                                                        158.625229,
                                                        158.678594,
                                                        158.731963,
                                                        158.785335,
                                                        158.838711,
                                                        158.892090,
                                                        158.945473,
                                                        158.998859,
                                                        159.052249,
                                                        159.105643,
                                                        159.159040,
                                                        159.212440,
                                                        159.265845,
                                                        159.319252,
                                                        159.372664,
                                                        159.426079,
                                                        159.479497,
                                                        159.532919,
                                                        159.586345,
                                                        159.639774,
                                                        159.693206,
                                                        159.746643,
                                                        159.800082,
                                                        159.853526,
                                                        159.906973,
                                                        159.960423,
                                                        160.013877,
                                                        160.067335,
                                                        160.120796,
                                                        160.174260,
                                                        160.227728,
                                                        160.281200,
                                                        160.334675,
                                                        160.388154,
                                                        160.441636,
                                                        160.495122,
                                                        160.548612,
                                                        160.602105,
                                                        160.655601,
                                                        160.709101,
                                                        160.762605,
                                                        160.816112,
                                                        160.869623,
                                                        160.923137,
                                                        160.976654,
                                                        161.030176,
                                                        161.083700,
                                                        161.137229,
                                                        161.190761,
                                                        161.244296,
                                                        161.297835,
                                                        161.351377,
                                                        161.404923,
                                                        161.458473,
                                                        161.512026,
                                                        161.565582,
                                                        161.619142,
                                                        161.672706,
                                                        161.726273,
                                                        161.779843,
                                                        161.833417,
                                                        161.886995,
                                                        161.940576,
                                                        161.994161,
                                                        162.047749,
                                                        162.101341,
                                                        162.154936,
                                                        162.208535,
                                                        162.262137,
                                                        162.315743,
                                                        162.369352,
                                                        162.422965,
                                                        162.476581,
                                                        162.530201,
                                                        162.583824,
                                                        162.637451,
                                                        162.691081,
                                                        162.744715,
                                                        162.798352,
                                                        162.851993,
                                                        162.905638,
                                                        162.959285,
                                                        163.012937,
                                                        163.066592,
                                                        163.120250,
                                                        163.173912,
                                                        163.227577,
                                                        163.281246,
                                                        163.334918,
                                                        163.388594,
                                                        163.442273,
                                                        163.495956,
                                                        163.549642,
                                                        163.603332,
                                                        163.657025,
                                                        163.710722,
                                                        163.764422,
                                                        163.818126,
                                                        163.871833,
                                                        163.925544,
                                                        163.979258,
                                                        164.032976,
                                                        164.086697,
                                                        164.140422,
                                                        164.194150,
                                                        164.247882,
                                                        164.301617,
                                                        164.355355,
                                                        164.409097,
                                                        164.462843,
                                                        164.516592,
                                                        164.570344,
                                                        164.624100,
                                                        164.677860,
                                                        164.731623,
                                                        164.785389,
                                                        164.839159,
                                                        164.892932,
                                                        164.946709,
                                                        165.000489,
                                                        165.054273,
                                                        165.108060,
                                                        165.161851,
                                                        165.215645,
                                                        165.269443,
                                                        165.323244,
                                                        165.377048,
                                                        165.430856,
                                                        165.484668,
                                                        165.538482,
                                                        165.592301,
                                                        165.646123,
                                                        165.699948,
                                                        165.753777,
                                                        165.807609,
                                                        165.861445,
                                                        165.915284,
                                                        165.969126,
                                                        166.022972,
                                                        166.076822,
                                                        166.130675,
                                                        166.184531,
                                                        166.238391,
                                                        166.292254,
                                                        166.346121,
                                                        166.399991,
                                                        166.453865,
                                                        166.507742,
                                                        166.561622,
                                                        166.615506,
                                                        166.669394,
                                                        166.723284,
                                                        166.777179,
                                                        166.831077,
                                                        166.884978,
                                                        166.938882,
                                                        166.992790,
                                                        167.046702,
                                                        167.100617,
                                                        167.154535,
                                                        167.208457,
                                                        167.262382,
                                                        167.316311,
                                                        167.370243,
                                                        167.424178,
                                                        167.478117,
                                                        167.532060,
                                                        167.586006,
                                                        167.639955,
                                                        167.693908,
                                                        167.747864,
                                                        167.801823,
                                                        167.855786,
                                                        167.909753,
                                                        167.963722,
                                                        168.017696,
                                                        168.071672,
                                                        168.125652,
                                                        168.179636,
                                                        168.233623,
                                                        168.287613,
                                                        168.341607,
                                                        168.395604,
                                                        168.449605,
                                                        168.503609,
                                                        168.557616,
                                                        168.611627,
                                                        168.665641,
                                                        168.719659,
                                                        168.773680,
                                                        168.827704,
                                                        168.881732,
                                                        168.935764,
                                                        168.989798,
                                                        169.043836,
                                                        169.097878,
                                                        169.151923,
                                                        169.205971,
                                                        169.260023,
                                                        169.314078,
                                                        169.368137,
                                                        169.422199,
                                                        169.476264,
                                                        169.530333,
                                                        169.584405,
                                                        169.638480,
                                                        169.692559,
                                                        169.746642,
                                                        169.800728,
                                                        169.854817,
                                                        169.908909,
                                                        169.963005,
                                                        170.017105,
                                                        170.071207,
                                                        170.125313,
                                                        170.179423,
                                                        170.233536,
                                                        170.287652,
                                                        170.341772,
                                                        170.395895,
                                                        170.450021,
                                                        170.504151,
                                                        170.558284,
                                                        170.612421,
                                                        170.666561,
                                                        170.720704,
                                                        170.774851,
                                                        170.829001,
                                                        170.883155,
                                                        170.937312,
                                                        170.991472,
                                                        171.045636,
                                                        171.099803,
                                                        171.153973,
                                                        171.208147,
                                                        171.262324,
                                                        171.316505,
                                                        171.370688,
                                                        171.424876,
                                                        171.479066,
                                                        171.533260,
                                                        171.587458,
                                                        171.641659,
                                                        171.695863,
                                                        171.750070,
                                                        171.804281,
                                                        171.858495,
                                                        171.912713,
                                                        171.966934,
                                                        172.021158,
                                                        172.075386,
                                                        172.129617,
                                                        172.183851,
                                                        172.238089,
                                                        172.292330,
                                                        172.346575,
                                                        172.400823,
                                                        172.455074,
                                                        172.509329,
                                                        172.563587,
                                                        172.617848,
                                                        172.672112,
                                                        172.726380,
                                                        172.780652,
                                                        172.834927,
                                                        172.889205,
                                                        172.943486,
                                                        172.997771,
                                                        173.052059,
                                                        173.106350,
                                                        173.160645,
                                                        173.214943,
                                                        173.269245,
                                                        173.323550,
                                                        173.377858,
                                                        173.432169,
                                                        173.486484,
                                                        173.540803,
                                                        173.595124,
                                                        173.649449,
                                                        173.703777,
                                                        173.758109,
                                                        173.812444,
                                                        173.866782,
                                                        173.921124,
                                                        173.975469,
                                                        174.029817,
                                                        174.084168,
                                                        174.138523,
                                                        174.192882,
                                                        174.247243,
                                                        174.301608,
                                                        174.355976,
                                                        174.410348,
                                                        174.464723,
                                                        174.519101,
                                                        174.573483,
                                                        174.627868,
                                                        174.682256,
                                                        174.736648,
                                                        174.791042,
                                                        174.845441,
                                                        174.899842,
                                                        174.954247,
                                                        175.008655,
                                                        175.063067,
                                                        175.117482,
                                                        175.171900,
                                                        175.226321,
                                                        175.280746,
                                                        175.335174,
                                                        175.389605,
                                                        175.444040,
                                                        175.498478,
                                                        175.552920,
                                                        175.607364,
                                                        175.661812,
                                                        175.716263,
                                                        175.770718,
                                                        175.825176,
                                                        175.879637,
                                                        175.934102,
                                                        175.988570,
                                                        176.043041,
                                                        176.097515,
                                                        176.151993,
                                                        176.206474,
                                                        176.260958,
                                                        176.315446,
                                                        176.369937,
                                                        176.424431,
                                                        176.478929,
                                                        176.533430,
                                                        176.587934,
                                                        176.642441,
                                                        176.696952,
                                                        176.751466,
                                                        176.805984,
                                                        176.860504,
                                                        176.915028,
                                                        176.969556,
                                                        177.024086,
                                                        177.078620,
                                                        177.133157,
                                                        177.187697,
                                                        177.242241,
                                                        177.296788,
                                                        177.351339,
                                                        177.405892,
                                                        177.460449,
                                                        177.515009,
                                                        177.569573,
                                                        177.624139,
                                                        177.678709,
                                                        177.733283,
                                                        177.787859,
                                                        177.842439,
                                                        177.897022,
                                                        177.951609,
                                                        178.006198,
                                                        178.060791,
                                                        178.115388,
                                                        178.169987,
                                                        178.224590,
                                                        178.279196,
                                                        178.333805,
                                                        178.388418,
                                                        178.443034,
                                                        178.497653,
                                                        178.552276,
                                                        178.606901,
                                                        178.661530,
                                                        178.716163,
                                                        178.770798,
                                                        178.825437,
                                                        178.880079,
                                                        178.934725,
                                                        178.989373,
                                                        179.044025,
                                                        179.098680,
                                                        179.153339,
                                                        179.208000,
                                                        179.262665,
                                                        179.317333,
                                                        179.372005,
                                                        179.426680,
                                                        179.481358,
                                                        179.536039,
                                                        179.590723,
                                                        179.645411,
                                                        179.700102,
                                                        179.754796,
                                                        179.809494,
                                                        179.864195,
                                                        179.918899,
                                                        179.973606,
                                                        180.028317,
                                                        180.083031,
                                                        180.137748,
                                                        180.192468,
                                                        180.247191,
                                                        180.301918,
                                                        180.356648,
                                                        180.411382,
                                                        180.466118,
                                                        180.520858,
                                                        180.575601,
                                                        180.630347,
                                                        180.685097,
                                                        180.739850,
                                                        180.794606,
                                                        180.849365,
                                                        180.904127,
                                                        180.958893,
                                                        181.013662,
                                                        181.068434,
                                                        181.123210,
                                                        181.177988,
                                                        181.232770,
                                                        181.287556,
                                                        181.342344,
                                                        181.397136,
                                                        181.451930,
                                                        181.506729,
                                                        181.561530,
                                                        181.616334,
                                                        181.671142,
                                                        181.725953,
                                                        181.780768,
                                                        181.835585,
                                                        181.890406,
                                                        181.945230,
                                                        182.000057,
                                                        182.054887,
                                                        182.109721,
                                                        182.164558,
                                                        182.219398,
                                                        182.274241,
                                                        182.329088,
                                                        182.383937,
                                                        182.438790,
                                                        182.493647,
                                                        182.548506,
                                                        182.603369,
                                                        182.658234,
                                                        182.713103,
                                                        182.767976,
                                                        182.822851,
                                                        182.877730,
                                                        182.932612,
                                                        182.987497,
                                                        183.042385,
                                                        183.097277,
                                                        183.152172,
                                                        183.207070,
                                                        183.261971,
                                                        183.316875,
                                                        183.371783,
                                                        183.426694,
                                                        183.481608,
                                                        183.536525,
                                                        183.591445,
                                                        183.646369,
                                                        183.701296,
                                                        183.756226,
                                                        183.811159,
                                                        183.866095,
                                                        183.921035,
                                                        183.975978,
                                                        184.030924,
                                                        184.085873,
                                                        184.140826,
                                                        184.195781,
                                                        184.250740,
                                                        184.305702,
                                                        184.360667,
                                                        184.415636,
                                                        184.470608,
                                                        184.525582,
                                                        184.580560,
                                                        184.635542,
                                                        184.690526,
                                                        184.745514,
                                                        184.800504,
                                                        184.855498,
                                                        184.910495,
                                                        184.965496,
                                                        185.020499,
                                                        185.075506,
                                                        185.130516,
                                                        185.185529,
                                                        185.240545,
                                                        185.295565,
                                                        185.350587,
                                                        185.405613,
                                                        185.460642,
                                                        185.515674,
                                                        185.570710,
                                                        185.625748,
                                                        185.680790,
                                                        185.735835,
                                                        185.790883,
                                                        185.845934,
                                                        185.900989,
                                                        185.956046,
                                                        186.011107,
                                                        186.066171,
                                                        186.121238,
                                                        186.176309,
                                                        186.231382,
                                                        186.286459,
                                                        186.341539,
                                                        186.396622,
                                                        186.451708,
                                                        186.506797,
                                                        186.561890,
                                                        186.616985,
                                                        186.672084,
                                                        186.727186,
                                                        186.782291,
                                                        186.837400,
                                                        186.892511,
                                                        186.947626,
                                                        187.002743,
                                                        187.057864,
                                                        187.112989,
                                                        187.168116,
                                                        187.223246,
                                                        187.278380,
                                                        187.333517,
                                                        187.388657,
                                                        187.443800,
                                                        187.498946,
                                                        187.554095,
                                                        187.609248,
                                                        187.664404,
                                                        187.719563,
                                                        187.774725,
                                                        187.829890,
                                                        187.885058,
                                                        187.940229,
                                                        187.995404,
                                                        188.050582,
                                                        188.105763,
                                                        188.160947,
                                                        188.216134,
                                                        188.271324,
                                                        188.326518,
                                                        188.381715,
                                                        188.436914,
                                                        188.492117,
                                                        188.547323,
                                                        188.602533,
                                                        188.657745,
                                                        188.712960,
                                                        188.768179,
                                                        188.823401,
                                                        188.878626,
                                                        188.933854,
                                                        188.989085,
                                                        189.044319,
                                                        189.099557,
                                                        189.154797,
                                                        189.210041,
                                                        189.265288,
                                                        189.320538,
                                                        189.375791,
                                                        189.431048,
                                                        189.486307,
                                                        189.541569,
                                                        189.596835,
                                                        189.652104,
                                                        189.707376,
                                                        189.762651,
                                                        189.817929,
                                                        189.873210,
                                                        189.928495,
                                                        189.983782,
                                                        190.039073,
                                                        190.094367,
                                                        190.149664,
                                                        190.204964,
                                                        190.260267,
                                                        190.315573,
                                                        190.370883,
                                                        190.426195,
                                                        190.481511,
                                                        190.536830,
                                                        190.592152,
                                                        190.647477,
                                                        190.702805,
                                                        190.758136,
                                                        190.813470,
                                                        190.868808,
                                                        190.924148,
                                                        190.979492,
                                                        191.034839,
                                                        191.090189,
                                                        191.145542,
                                                        191.200898,
                                                        191.256257,
                                                        191.311620,
                                                        191.366985,
                                                        191.422354,
                                                        191.477725,
                                                        191.533100,
                                                        191.588478,
                                                        191.643859,
                                                        191.699243,
                                                        191.754630,
                                                        191.810021,
                                                        191.865414,
                                                        191.920811,
                                                        191.976210,
                                                        192.031613,
                                                        192.087019,
                                                        192.142428,
                                                        192.197840,
                                                        192.253255,
                                                        192.308673,
                                                        192.364094,
                                                        192.419519,
                                                        192.474946,
                                                        192.530377,
                                                        192.585811,
                                                        192.641247,
                                                        192.696687,
                                                        192.752130,
                                                        192.807576,
                                                        192.863025,
                                                        192.918478,
                                                        192.973933,
                                                        193.029391,
                                                        193.084853,
                                                        193.140317,
                                                        193.195785,
                                                        193.251256,
                                                        193.306730,
                                                        193.362207,
                                                        193.417687,
                                                        193.473170,
                                                        193.528656,
                                                        193.584145,
                                                        193.639638,
                                                        193.695133,
                                                        193.750631,
                                                        193.806133,
                                                        193.861638,
                                                        193.917145,
                                                        193.972656,
                                                        194.028170,
                                                        194.083687,
                                                        194.139207,
                                                        194.194730,
                                                        194.250257,
                                                        194.305786,
                                                        194.361318,
                                                        194.416854,
                                                        194.472392,
                                                        194.527934,
                                                        194.583478,
                                                        194.639026,
                                                        194.694577,
                                                        194.750131,
                                                        194.805687,
                                                        194.861247,
                                                        194.916810,
                                                        194.972377,
                                                        195.027946,
                                                        195.083518,
                                                        195.139093,
                                                        195.194672,
                                                        195.250253,
                                                        195.305837,
                                                        195.361425,
                                                        195.417016,
                                                        195.472609,
                                                        195.528206,
                                                        195.583806,
                                                        195.639409,
                                                        195.695014,
                                                        195.750623,
                                                        195.806235,
                                                        195.861850,
                                                        195.917469,
                                                        195.973090,
                                                        196.028714,
                                                        196.084341,
                                                        196.139972,
                                                        196.195605,
                                                        196.251241,
                                                        196.306881,
                                                        196.362523,
                                                        196.418169,
                                                        196.473818,
                                                        196.529469,
                                                        196.585124,
                                                        196.640782,
                                                        196.696443,
                                                        196.752106,
                                                        196.807773,
                                                        196.863443,
                                                        196.919116,
                                                        196.974792,
                                                        197.030471,
                                                        197.086153,
                                                        197.141839,
                                                        197.197527,
                                                        197.253218,
                                                        197.308912,
                                                        197.364610,
                                                        197.420310,
                                                        197.476013,
                                                        197.531720,
                                                        197.587429,
                                                        197.643142,
                                                        197.698857,
                                                        197.754576,
                                                        197.810297,
                                                        197.866022,
                                                        197.921750,
                                                        197.977480,
                                                        198.033214,
                                                        198.088951,
                                                        198.144690,
                                                        198.200433,
                                                        198.256179,
                                                        198.311928,
                                                        198.367680,
                                                        198.423435,
                                                        198.479193,
                                                        198.534954,
                                                        198.590717,
                                                        198.646484,
                                                        198.702254,
                                                        198.758028,
                                                        198.813804,
                                                        198.869583,
                                                        198.925365,
                                                        198.981150,
                                                        199.036938,
                                                        199.092729,
                                                        199.148523,
                                                        199.204321,
                                                        199.260121,
                                                        199.315924,
                                                        199.371730,
                                                        199.427540,
                                                        199.483352,
                                                        199.539167,
                                                        199.594985,
                                                        199.650807,
                                                        199.706631,
                                                        199.762458,
                                                        199.818289,
                                                        199.874122,
                                                        199.929958,
                                                        199.985798,
                                                        200.041640,
                                                        200.097485,
                                                        200.153334,
                                                        200.209185,
                                                        200.265040,
                                                        200.320897,
                                                        200.376757,
                                                        200.432621,
                                                        200.488487,
                                                        200.544357,
                                                        200.600229,
                                                        200.656104,
                                                        200.711983,
                                                        200.767864,
                                                        200.823749,
                                                        200.879636,
                                                        200.935526,
                                                        200.991420,
                                                        201.047316,
                                                        201.103216,
                                                        201.159118,
                                                        201.215023,
                                                        201.270932,
                                                        201.326843,
                                                        201.382758,
                                                        201.438675,
                                                        201.494595,
                                                        201.550519,
                                                        201.606445,
                                                        201.662374,
                                                        201.718307,
                                                        201.774242,
                                                        201.830180,
                                                        201.886121,
                                                        201.942066,
                                                        201.998013,
                                                        202.053963,
                                                        202.109916,
                                                        202.165872,
                                                        202.221832,
                                                        202.277794,
                                                        202.333759,
                                                        202.389727,
                                                        202.445698,
                                                        202.501672,
                                                        202.557649,
                                                        202.613629,
                                                        202.669612,
                                                        202.725598,
                                                        202.781587,
                                                        202.837579,
                                                        202.893574,
                                                        202.949572,
                                                        203.005573,
                                                        203.061577,
                                                        203.117584,
                                                        203.173593,
                                                        203.229606,
                                                        203.285622,
                                                        203.341641,
                                                        203.397662,
                                                        203.453687,
                                                        203.509714,
                                                        203.565745,
                                                        203.621779,
                                                        203.677815,
                                                        203.733855,
                                                        203.789897,
                                                        203.845942,
                                                        203.901991,
                                                        203.958042,
                                                        204.014097,
                                                        204.070154,
                                                        204.126214,
                                                        204.182277,
                                                        204.238343,
                                                        204.294412,
                                                        204.350485,
                                                        204.406560,
                                                        204.462638,
                                                        204.518719,
                                                        204.574802,
                                                        204.630889,
                                                        204.686979,
                                                        204.743072,
                                                        204.799168,
                                                        204.855266,
                                                        204.911368,
                                                        204.967473,
                                                        205.023580,
                                                        205.079691,
                                                        205.135804,
                                                        205.191920,
                                                        205.248040,
                                                        205.304162,
                                                        205.360287,
                                                        205.416416,
                                                        205.472547,
                                                        205.528681,
                                                        205.584818,
                                                        205.640958,
                                                        205.697101,
                                                        205.753247,
                                                        205.809395,
                                                        205.865547,
                                                        205.921702,
                                                        205.977860,
                                                        206.034020,
                                                        206.090184,
                                                        206.146350,
                                                        206.202520,
                                                        206.258692,
                                                        206.314867,
                                                        206.371045,
                                                        206.427227,
                                                        206.483411,
                                                        206.539598,
                                                        206.595788,
                                                        206.651981,
                                                        206.708177,
                                                        206.764375,
                                                        206.820577,
                                                        206.876782,
                                                        206.932989,
                                                        206.989200,
                                                        207.045413,
                                                        207.101630,
                                                        207.157849,
                                                        207.214071,
                                                        207.270296,
                                                        207.326524,
                                                        207.382755,
                                                        207.438989,
                                                        207.495226,
                                                        207.551466,
                                                        207.607709,
                                                        207.663954,
                                                        207.720203,
                                                        207.776454,
                                                        207.832709,
                                                        207.888966,
                                                        207.945226,
                                                        208.001490,
                                                        208.057756,
                                                        208.114025,
                                                        208.170297,
                                                        208.226571,
                                                        208.282849,
                                                        208.339130,
                                                        208.395414,
                                                        208.451700,
                                                        208.507990,
                                                        208.564282};

} /* namespace gum */
