/***************************************************************************
 *  aGrUM modified frames and atg files for cocoR
 *   Copyright (c) 2005-2024 by Pierre-Henri WUILLEMIN(@LIP6) and Christophe GONZALES(@AMU)
 *   info_at_agrum_dot_org
***************************************************************************/
/*----------------------------------------------------------------------
Compiler Generator Coco/R,
Copyright (c) 1990, 2004 Hanspeter Moessenboeck, University of Linz
extended by M. Loeberbauer & A. Woess, Univ. of Linz
ported to C++ by Csaba Balazs, University of Szeged
with improvements by Pat Terry, Rhodes University

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

As an exception, it is allowed to write an extension of Coco/R that is
used as a plugin in non-free software.

If not otherwise stated, any source code generated by Coco/R (other than
Coco/R itself) does not fall under the GNU General Public License.
-----------------------------------------------------------------------*/


#include <iostream>
#include <wchar.h>

#include "Parser.h"
#include "Scanner.h"


namespace gum {
namespace MDPDAT {


void Parser::SynErr( int n ) {
  if ( errDist >= minErrDist ) SynErr( scanner->filename(),la->line, la->col, n );

  errDist = 0;
}


const ErrorsContainer& Parser::errors( void ) const {
  return errors__;
}
ErrorsContainer& Parser::errors( void ) {
  return errors__;
}

void Parser::Get() {
  for ( ;; ) {
    t = la;
    la = scanner->Scan();

    if ( la->kind <= maxT ) { ++errDist; break; }

    

    if ( dummyToken != t ) {
      dummyToken->kind = t->kind;
      dummyToken->pos = t->pos;
      dummyToken->col = t->col;
      dummyToken->line = t->line;
      dummyToken->next = nullptr;
      coco_string_delete( dummyToken->val );
      dummyToken->val = coco_string_create( t->val );
      t = dummyToken;
    }

    la = t;
  }
}

void Parser::Expect( int n ) {
  if ( la->kind==n ) Get(); else { SynErr( n ); }
}

void Parser::ExpectWeak( int n, int follow ) {
  if ( la->kind == n ) Get();
  else {
    SynErr( n );

    while ( !StartOf( follow ) ) Get();
  }
}

bool Parser::WeakSeparator( int n, int syFol, int repFol ) {
  if ( la->kind == n ) {Get(); return true;}
  else if ( StartOf( repFol ) ) {return false;}
  else {
    SynErr( n );

    while ( !( StartOf( syFol ) || StartOf( repFol ) || StartOf( 0 ) ) ) {
      Get();
    }

    return StartOf( syFol );
  }
}

void Parser::MDPDAT() {
		VARIABLES_DECLARATION();
		while (la->kind == 10 /* "action" */) {
			ACTION();
		}
		REWARD_FUNCTION_GRAPH();
		DISCOUNT();
		TOLERANCE();
}

void Parser::VARIABLES_DECLARATION() {
		Expect(_lpar);
		Expect(8 /* "variables" */);
		while (la->kind == _lpar) {
			VARIABLE();
		}
		Expect(9 /* ")" */);
}

void Parser::ACTION() {
		std::string name_of_action;
		float tolerance; 
		Expect(10 /* "action" */);
		factory__->startActionDeclaration(); 
		if (la->kind == _ident) {
			IDENT(name_of_action);
		} else if (la->kind == _string) {
			STRING(name_of_action);
		} else SynErr(19);
		TRY( factory__->addAction( name_of_action ) ); 
		if (la->kind == _integer || la->kind == _number) {
			FLOAT(tolerance);
		}
		while (la->kind == _ident) {
			TRANSITION_FUNCTION_GRAPH();
		}
		if (la->kind == 12 /* "cost" */) {
			COST_FUNCTION_GRAPH();
		}
		Expect(11 /* "endaction" */);
		TRY( factory__->endActionDeclaration() ); 
}

void Parser::REWARD_FUNCTION_GRAPH() {
		std::string name_of_var;
		                        factory__->startRewardDeclaration(); 
		Expect(13 /* "reward" */);
		if (la->kind == _lpar) {
			if (IsFollowedByIdent() ) {
				Expect(_lpar);
				SUB_FUNCTION_GRAPH();
				Expect(9 /* ")" */);
			} else {
				Get();
				LEAF();
				Expect(9 /* ")" */);
			}
			TRY( factory__->addReward( ) );
			                   parentModality__.clear();
			                   parentNode__.clear(); 
		} else if (la->kind == 14 /* "[" */) {
			Get();
			std::string operand_type; 
			OPERAND(operand_type);
			factory__->setOperationModeOn( operand_type );
			if (IsFollowedByIdent() ) {
				Expect(_lpar);
				SUB_FUNCTION_GRAPH();
				Expect(9 /* ")" */);
			} else if (la->kind == _lpar) {
				Get();
				LEAF();
				Expect(9 /* ")" */);
			} else SynErr(20);
			TRY( factory__->addReward( ) );
			                     parentModality__.clear();
			                     parentNode__.clear(); 
			while (la->kind == _lpar) {
				if (IsFollowedByIdent() ) {
					Expect(_lpar);
					SUB_FUNCTION_GRAPH();
					Expect(9 /* ")" */);
				} else {
					Get();
					LEAF();
					Expect(9 /* ")" */);
				}
				TRY( factory__->addReward( ) );
				                     parentModality__.clear();
				                     parentNode__.clear(); 
			}
			Expect(15 /* "]" */);
		} else SynErr(21);
		factory__->endRewardDeclaration(); 
}

void Parser::DISCOUNT() {
		float value=0.0;
		        factory__->startDiscountDeclaration( ); 
		Expect(16 /* "discount" */);
		FLOAT(value);
		factory__->addDiscount( value );
		          factory__->endDiscountDeclaration( ); 
}

void Parser::TOLERANCE() {
		float value=0.0; 
		Expect(17 /* "tolerance" */);
		FLOAT(value);
}

void Parser::VARIABLE() {
		std::string name_of_var; 
		Expect(_lpar);
		factory__->startVariableDeclaration(); 
		IDENT(name_of_var);
		TRY( factory__->variableName( name_of_var ) ); 
		MODALITY_LIST();
		Expect(9 /* ")" */);
		TRY( factory__->endVariableDeclaration() ); 
}

void Parser::IDENT(std::string& name) {
		Expect(_ident);
		name=narrow(t->val);  
}

void Parser::MODALITY_LIST() {
		std::string label; 
		IDENT_OR_INTEGER(label);
		TRY( factory__->addModality( label ) ); 
		if (la->kind == _ident || la->kind == _integer) {
			MODALITY_LIST();
		}
}

void Parser::IDENT_OR_INTEGER(std::string& name) {
		if (la->kind == _ident) {
			IDENT(name);
		} else if (la->kind == _integer) {
			Get();
			name=narrow(t->val);  
		} else SynErr(22);
}

void Parser::STRING(std::string& str) {
		Expect(_string);
		str=narrow(t->val); 
}

void Parser::FLOAT(float& val) {
		if (la->kind == _number) {
			Get();
			val=coco_atof(t->val); 
		} else if (la->kind == _integer) {
			Get();
			val=float(coco_atoi(t->val)); 
		} else SynErr(23);
}

void Parser::TRANSITION_FUNCTION_GRAPH() {
		std::string name_of_var;
		                         factory__->startTransitionDeclaration(); 
		IDENT(name_of_var);
		std::string prime_name_of_var = name_of_var + "'";
		               currentFunctionGraphVar__ = prime_name_of_var; 
		if (IsFollowedByIdent() ) {
			Expect(_lpar);
			SUB_TRANSITION_FUNCTION_GRAPH();
			Expect(9 /* ")" */);
		} else if (la->kind == _lpar) {
			Get();
			TRANSITION_LEAF();
			Expect(9 /* ")" */);
		} else SynErr(24);
		TRY( factory__->addTransition( name_of_var ) );
		factory__->endTransitionDeclaration();
		parentModality__.clear();
		parentNode__.clear(); 
}

void Parser::COST_FUNCTION_GRAPH() {
		std::string name_of_var;
		                     factory__->startCostDeclaration(); 
		Expect(12 /* "cost" */);
		Expect(_lpar);
		SUB_FUNCTION_GRAPH();
		Expect(9 /* ")" */);
		TRY( factory__->addCost( ) );
		factory__->endCostDeclaration();
		parentModality__.clear();
		parentNode__.clear(); 
}

void Parser::SUB_TRANSITION_FUNCTION_GRAPH() {
		std::string name_of_var;
		 std::string modality_of_var;
		 NodeId var_id; 
		IDENT(name_of_var);
		var_id = factory__->addInternalNode( name_of_var );
		if( !parentNode__.empty() )
		 factory__->addArc( parentNode__.back(), var_id, parentModality__.back() );
		else
		 factory__->setRoot(var_id); 
		while (la->kind == _lpar) {
			Get();
			IDENT_OR_INTEGER(modality_of_var);
			parentNode__.push_back( var_id );
			                        parentModality__.push_back( (* (factory__->variable( name_of_var )))[modality_of_var] ); 
			if (IsFollowedByIdent() ) {
				Expect(_lpar);
				SUB_TRANSITION_FUNCTION_GRAPH();
				Expect(9 /* ")" */);
			} else if (la->kind == _lpar) {
				Get();
				TRANSITION_LEAF();
				Expect(9 /* ")" */);
			} else SynErr(25);
			parentModality__.pop_back(); 
			Expect(9 /* ")" */);
		}
		parentNode__.pop_back(); 
}

void Parser::TRANSITION_LEAF() {
		float value=0.0;
		gum::Idx i = 0;
		NodeId var_id = factory__->addInternalNode( currentFunctionGraphVar__ );
		if( !parentNode__.empty() )
		  factory__->addArc( parentNode__.back(), var_id, parentModality__.back() );
		else
		 factory__->setRoot(var_id); 
		FLOAT(value);
		NodeId val_id = factory__->addTerminalNode( value );
		factory__->addArc( var_id, val_id, i ); 
		while (la->kind == _integer || la->kind == _number) {
			FLOAT(value);
			++i;
			          val_id = factory__->addTerminalNode( value );
			         factory__->addArc( var_id, val_id, i ); 
		}
}

void Parser::SUB_FUNCTION_GRAPH() {
		std::string name_of_var;
		 std::string modality_of_var;
		 NodeId var_id;
		IDENT(name_of_var);
		var_id = factory__->addInternalNode( name_of_var );
		if( !parentNode__.empty() )
		 factory__->addArc( parentNode__.back(), var_id, parentModality__.back() );
		else
		factory__->setRoot(var_id); 
		while (la->kind == _lpar) {
			Get();
			IDENT_OR_INTEGER(modality_of_var);
			parentNode__.push_back( var_id );
			                        parentModality__.push_back( (* (factory__->variable( name_of_var )))[modality_of_var] );  
			if (IsFollowedByIdent() ) {
				Expect(_lpar);
				SUB_FUNCTION_GRAPH();
				Expect(9 /* ")" */);
			} else if (la->kind == _lpar) {
				Get();
				LEAF();
				Expect(9 /* ")" */);
			} else SynErr(26);
			parentModality__.pop_back(); 
			Expect(9 /* ")" */);
		}
		parentNode__.pop_back(); 
}

void Parser::LEAF() {
		float value=0.0; 
		FLOAT(value);
		NodeId val_id = factory__->addTerminalNode( value );
		         factory__->addArc( parentNode__.back(), val_id, parentModality__.back() ); 
		while (la->kind == _integer || la->kind == _number) {
			FLOAT(value);
			NodeId val_id = factory__->addTerminalNode( value );
			          factory__->addArc( parentNode__.back(), val_id, parentModality__.back() ); 
		}
}

void Parser::OPERAND(std::string& op) {
		Expect(_operand);
		op=narrow(t->val); 
}



// If the user declared a method Init and a mehtod Destroy they should
// be called in the contructur and the destructor respctively.
//
// The following templates are used to recognize if the user declared
// the methods Init and Destroy.

template<typename T>
struct ParserInitExistsRecognizer {
  template<typename U, void ( U::* )() = &U::Init>
  struct ExistsIfInitIsDefinedMarker {};

  struct InitIsMissingType {
    char dummy1;
  };

  struct InitExistsType {
    char dummy1; char dummy2;
  };

  // exists always
  template<typename U>
  static InitIsMissingType is_here( ... );

  // exist only if ExistsIfInitIsDefinedMarker is defined
  template<typename U>
  static InitExistsType is_here( ExistsIfInitIsDefinedMarker<U>* );

  enum { InitExists = ( sizeof( is_here<T>( nullptr ) ) == sizeof( InitExistsType ) ) };
};

template<typename T>
struct ParserDestroyExistsRecognizer {
  template<typename U, void ( U::* )() = &U::Destroy>
  struct ExistsIfDestroyIsDefinedMarker {};

  struct DestroyIsMissingType {
    char dummy1;
  };

  struct DestroyExistsType {
    char dummy1; char dummy2;
  };

  // exists always
  template<typename U>
  static DestroyIsMissingType is_here( ... );

  // exist only if ExistsIfDestroyIsDefinedMarker is defined
  template<typename U>
  static DestroyExistsType is_here( ExistsIfDestroyIsDefinedMarker<U>* );

  enum { DestroyExists = ( sizeof( is_here<T>( nullptr ) ) == sizeof( DestroyExistsType ) ) };
};

// The folloing templates are used to call the Init and Destroy methods if they exist.

// Generic case of the ParserInitCaller, gets used if the Init method is missing
template<typename T, bool = ParserInitExistsRecognizer<T>::InitExists>
struct ParserInitCaller {
  static void CallInit( T* t ) {
    // nothing to do
  }
};

// True case of the ParserInitCaller, gets used if the Init method exists
template<typename T>
struct ParserInitCaller<T, true> {
  static void CallInit( T* t ) {
    t->Init();
  }
};

// Generic case of the ParserDestroyCaller, gets used if the Destroy method is missing
template<typename T, bool = ParserDestroyExistsRecognizer<T>::DestroyExists>
struct ParserDestroyCaller {
  static void CallDestroy( T* t ) {
    // nothing to do
  }
};

// True case of the ParserDestroyCaller, gets used if the Destroy method exists
template<typename T>
struct ParserDestroyCaller<T, true> {
  static void CallDestroy( T* t ) {
    t->Destroy();
  }
};
void Parser::Parse() {
  t = nullptr;
  la = dummyToken = new Token();
  la->val = coco_string_create( L"Dummy Token" );
  Get();
  	MDPDAT();
	Expect(0);
}

Parser::Parser( Scanner* scanner ) {
  	maxT = 18;

  ParserInitCaller<Parser>::CallInit( this );
  dummyToken = nullptr;
  t = la = nullptr;
  minErrDist = 2;
  errDist = minErrDist;
  this->scanner = scanner;
}

bool Parser::StartOf( int s ) {
  const bool T = true;
  const bool x = false;

  	static bool set[1][20] = {
		{T,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x}
	};



  return set[s][la->kind];
}

Parser::~Parser() {
  ParserDestroyCaller<Parser>::CallDestroy( this );
  delete dummyToken;
}
void Parser::SemErr( const wchar_t* msg ) {
  if ( errDist >= minErrDist ) errors__.Error( scanner->filename(),t->line, t->col, msg );

  errDist = 0;
}

void Parser::Warning( const wchar_t* msg ) {
  errors__.Warning( scanner->filename(),t->line, t->col, msg );
}

void Parser::SynErr( const std::wstring& filename,int line, int col, int n ) {
  wchar_t* s;

  switch ( n ) {
      			case 0: s = coco_string_create(L"EOF expected"); break;
			case 1: s = coco_string_create(L"operand expected"); break;
			case 2: s = coco_string_create(L"ident expected"); break;
			case 3: s = coco_string_create(L"integer expected"); break;
			case 4: s = coco_string_create(L"number expected"); break;
			case 5: s = coco_string_create(L"string expected"); break;
			case 6: s = coco_string_create(L"largestring expected"); break;
			case 7: s = coco_string_create(L"lpar expected"); break;
			case 8: s = coco_string_create(L"\"variables\" expected"); break;
			case 9: s = coco_string_create(L"\")\" expected"); break;
			case 10: s = coco_string_create(L"\"action\" expected"); break;
			case 11: s = coco_string_create(L"\"endaction\" expected"); break;
			case 12: s = coco_string_create(L"\"cost\" expected"); break;
			case 13: s = coco_string_create(L"\"reward\" expected"); break;
			case 14: s = coco_string_create(L"\"[\" expected"); break;
			case 15: s = coco_string_create(L"\"]\" expected"); break;
			case 16: s = coco_string_create(L"\"discount\" expected"); break;
			case 17: s = coco_string_create(L"\"tolerance\" expected"); break;
			case 18: s = coco_string_create(L"??? expected"); break;
			case 19: s = coco_string_create(L"invalid ACTION"); break;
			case 20: s = coco_string_create(L"invalid REWARD_FUNCTION_GRAPH"); break;
			case 21: s = coco_string_create(L"invalid REWARD_FUNCTION_GRAPH"); break;
			case 22: s = coco_string_create(L"invalid IDENT_OR_INTEGER"); break;
			case 23: s = coco_string_create(L"invalid FLOAT"); break;
			case 24: s = coco_string_create(L"invalid TRANSITION_FUNCTION_GRAPH"); break;
			case 25: s = coco_string_create(L"invalid SUB_TRANSITION_FUNCTION_GRAPH"); break;
			case 26: s = coco_string_create(L"invalid SUB_FUNCTION_GRAPH"); break;


    default: {
      wchar_t format[20];
      coco_swprintf( format, 20, L"error %d", n );
      s = coco_string_create( format );
    }
    break;
  }

  //wprintf(L"-- line %d col %d: %ls\n", line, col, s);
  std::wstring ss=L"Syntax error : "+std::wstring( s );
  errors__.Error( filename,line,col,ss.c_str() );
  coco_string_delete( s );
}

} // namespace
} // namespace



