/***************************************************************************
 *  aGrUM modified frames and atg files for cocoR
 *   Copyright (c) 2005-2024 by Pierre-Henri WUILLEMIN(@LIP6) and Christophe GONZALES(@AMU)
 *   info_at_agrum_dot_org
***************************************************************************/
/*----------------------------------------------------------------------
Compiler Generator Coco/R,
Copyright (c) 1990, 2004 Hanspeter Moessenboeck, University of Linz
extended by M. Loeberbauer & A. Woess, Univ. of Linz
ported to C++ by Csaba Balazs, University of Szeged
with improvements by Pat Terry, Rhodes University

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

As an exception, it is allowed to write an extension of Coco/R that is
used as a plugin in non-free software.

If not otherwise stated, any source code generated by Coco/R (other than
Coco/R itself) does not fall under the GNU General Public License.
-----------------------------------------------------------------------*/


#include <iostream>
#include <wchar.h>

#include "Parser.h"
#include "Scanner.h"


namespace gum {
namespace net {


void Parser::SynErr( int n ) {
  if ( errDist >= minErrDist ) SynErr( scanner->filename(),la->line, la->col, n );

  errDist = 0;
}


const ErrorsContainer& Parser::errors( void ) const {
  return errors__;
}
ErrorsContainer& Parser::errors( void ) {
  return errors__;
}

void Parser::Get() {
  for ( ;; ) {
    t = la;
    la = scanner->Scan();

    if ( la->kind <= maxT ) { ++errDist; break; }

    

    if ( dummyToken != t ) {
      dummyToken->kind = t->kind;
      dummyToken->pos = t->pos;
      dummyToken->col = t->col;
      dummyToken->line = t->line;
      dummyToken->next = nullptr;
      coco_string_delete( dummyToken->val );
      dummyToken->val = coco_string_create( t->val );
      t = dummyToken;
    }

    la = t;
  }
}

void Parser::Expect( int n ) {
  if ( la->kind==n ) Get(); else { SynErr( n ); }
}

void Parser::ExpectWeak( int n, int follow ) {
  if ( la->kind == n ) Get();
  else {
    SynErr( n );

    while ( !StartOf( follow ) ) Get();
  }
}

bool Parser::WeakSeparator( int n, int syFol, int repFol ) {
  if ( la->kind == n ) {Get(); return true;}
  else if ( StartOf( repFol ) ) {return false;}
  else {
    SynErr( n );

    while ( !( StartOf( syFol ) || StartOf( repFol ) || StartOf( 0 ) ) ) {
      Get();
    }

    return StartOf( syFol );
  }
}

void Parser::STRING(std::string& str) {
		Expect(_string);
		str=narrow(t->val);str.erase(std::remove(str.begin(),str.end(),'\"'),str.end()); 
}

void Parser::IDENT(std::string& name) {
		Expect(_ident);
		name=narrow(t->val); 
}

void Parser::ELT_LIST(std::string& val) {
		if (la->kind == _string) {
			Get();
		} else if (la->kind == _number) {
			Get();
		} else if (la->kind == _integer) {
			Get();
		} else if (la->kind == _ident) {
			Get();
		} else SynErr(18);
		val=narrow(t->val);val.erase(std::remove(val.begin(),val.end(),'\"'),val.end()); 
}

void Parser::PURE_LIST(std::vector<std::string>& vals ) {
		std::string val;vals.clear(); 
		ELT_LIST(val);
		vals.push_back(val); 
		while (StartOf(1)) {
			ELT_LIST(val);
			vals.push_back(val); 
		}
}

void Parser::LIST(std::vector<std::string>& vals ) {
		Expect(5 /* "(" */);
		PURE_LIST(vals);
		Expect(6 /* ")" */);
}

void Parser::GARBAGE_ELT_LIST() {
		if (la->kind == _number) {
			Get();
		} else if (la->kind == _integer) {
			Get();
		} else SynErr(19);
}

void Parser::GARBAGE_LISTS_SEQUENCE() {
		GARBAGE_NESTED_LIST();
		while (la->kind == _integer || la->kind == _number || la->kind == 5 /* "(" */) {
			GARBAGE_NESTED_LIST();
		}
}

void Parser::GARBAGE_NESTED_LIST() {
		if (la->kind == _integer || la->kind == _number) {
			GARBAGE_ELT_LIST();
		} else if (la->kind == 5 /* "(" */) {
			Get();
			GARBAGE_LISTS_SEQUENCE();
			Expect(6 /* ")" */);
		} else SynErr(20);
}

void Parser::Net() {
		factory().startNetworkDeclaration();
		
		Expect(7 /* "net" */);
		std::string prop,val;
		std::vector<std::string> vals;
		
		Expect(8 /* "{" */);
		while (la->kind == _ident) {
			IDENT(prop);
			Expect(9 /* "=" */);
			while (la->kind == _ident || la->kind == _string || la->kind == 5 /* "(" */) {
				if (la->kind == _ident) {
					IDENT(val);
					factory().addNetworkProperty(prop,val); 
				} else if (la->kind == _string) {
					STRING(val);
					factory().addNetworkProperty(prop,val); 
				} else {
					LIST(vals);
					std::string merge;
					merge="(";
					for(Size i=Size(0);i<Size(vals.size());i++) {
					 if (i>0) merge+=",";
					 merge+=vals[i];
					}
					merge+=')';
					factory().addNetworkProperty(prop,merge);
					
				}
			}
			Expect(10 /* ";" */);
		}
		Expect(11 /* "}" */);
		factory().endNetworkDeclaration(); 
		while (la->kind == 12 /* "node" */) {
			NODE();
		}
		while (la->kind == 16 /* "potential" */) {
			POTENTIAL();
		}
}

void Parser::NODE() {
		std::string var;
		
		Expect(12 /* "node" */);
		IDENT(var);
		std::string prop;
		std::string val;
		std::vector<std::string> vals;
		bool labels_done=false;;
		
		TRY( factory().startVariableDeclaration());
		TRY( factory().variableName(var));
		
		Expect(8 /* "{" */);
		while (la->kind == _ident) {
			IDENT(prop);
			Expect(9 /* "=" */);
			while (la->kind == _ident || la->kind == _string || la->kind == 5 /* "(" */) {
				if (la->kind == _ident) {
					IDENT(val);
				} else if (la->kind == _string) {
					STRING(val);
				} else {
					LIST(vals);
					if (prop=="states") {
					 if (labels_done) SemErr("Several labels lists for "+var);
					 labels_done=true;
					 for(Size  i=0;i<vals.size();i++) {
					   TRY(factory().addModality(vals[i]));
					 }
					}
					
				}
			}
			Expect(10 /* ";" */);
		}
		Expect(11 /* "}" */);
		TRY(factory().endVariableDeclaration()); 
}

void Parser::POTENTIAL() {
		std::string variable;
		std::vector<float> probas;
		std::vector<std::string> var_seq;
		
		Expect(16 /* "potential" */);
		PARENTS_DEFINITION(variable,var_seq);
		Expect(8 /* "{" */);
		RAW_DATA(variable,var_seq);
		if (la->kind == 15 /* "experience" */) {
			EXPERIENCE();
		}
		Expect(11 /* "}" */);
}

void Parser::PARENTS_DEFINITION(std::string& name,std::vector<std::string>& var_seq) {
		std::vector<std::string> parents;
		Expect(5 /* "(" */);
		IDENT(name);
		TRY(factory().startParentsDeclaration(name));
		var_seq.clear();
		
		if (la->kind == 13 /* "|" */) {
			Get();
			if (StartOf(1)) {
				PURE_LIST(parents);
				for(Size i=0;i<Size(parents.size());i++) {
				 TRY(factory().variableId(parents[i]));
				 TRY(factory().addParent(parents[i]));
				 var_seq.push_back(parents[i]);
				}
				
			}
		}
		Expect(6 /* ")" */);
		var_seq.push_back(name);
		TRY(factory().endParentsDeclaration());
		
}

void Parser::FLOAT(float& val) {
		if (la->kind == _number) {
			Get();
			val=coco_atof(t->val); 
		} else if (la->kind == _integer) {
			Get();
			val=float(coco_atoi(t->val)); 
		} else SynErr(21);
}

void Parser::FLOAT_LIST(std::vector<float>& v ) {
		float value=0.0; 
		FLOAT(value);
		v.push_back(value); 
		while (la->kind == _integer || la->kind == _number) {
			FLOAT(value);
			v.push_back(value); 
		}
}

void Parser::FLOAT_NESTED_LIST(std::vector<float>& v ) {
		Expect(5 /* "(" */);
		if (la->kind == 5 /* "(" */) {
			FLOAT_NESTED_LIST(v);
			while (la->kind == 5 /* "(" */) {
				FLOAT_NESTED_LIST(v);
			}
		} else if (la->kind == _integer || la->kind == _number) {
			FLOAT_LIST(v);
		} else SynErr(22);
		Expect(6 /* ")" */);
}

void Parser::RAW_DATA(std::string& variable,std::vector<std::string>& var_seq ) {
		std::vector<float> probas;
		Expect(14 /* "data" */);
		Expect(9 /* "=" */);
		FLOAT_NESTED_LIST(probas);
		TRY(factory().startRawProbabilityDeclaration(variable));
		   gum::Size s=(gum::Size)0;
		   TRY(s=factory().cptDomainSize(factory().variableId(variable)));
		   if ((Size)probas.size()<(Size)s) {
		     Warning("Not enough data for cpt of node "+variable);
		   }
		   if ((Size)probas.size()>(Size)s) {
		     Warning("Too many data for cpt of node "+variable);
		   }
		   TRY(factory().rawConditionalTable(var_seq,probas));
		   TRY(factory().endRawProbabilityDeclaration());
		
		Expect(10 /* ";" */);
}

void Parser::EXPERIENCE() {
		std::vector<std::string> vals;std::string val; 
		Expect(15 /* "experience" */);
		Expect(9 /* "=" */);
		GARBAGE_NESTED_LIST();
		Expect(10 /* ";" */);
}



// If the user declared a method Init and a mehtod Destroy they should
// be called in the contructur and the destructor respctively.
//
// The following templates are used to recognize if the user declared
// the methods Init and Destroy.

template<typename T>
struct ParserInitExistsRecognizer {
  template<typename U, void ( U::* )() = &U::Init>
  struct ExistsIfInitIsDefinedMarker {};

  struct InitIsMissingType {
    char dummy1;
  };

  struct InitExistsType {
    char dummy1; char dummy2;
  };

  // exists always
  template<typename U>
  static InitIsMissingType is_here( ... );

  // exist only if ExistsIfInitIsDefinedMarker is defined
  template<typename U>
  static InitExistsType is_here( ExistsIfInitIsDefinedMarker<U>* );

  enum { InitExists = ( sizeof( is_here<T>( nullptr ) ) == sizeof( InitExistsType ) ) };
};

template<typename T>
struct ParserDestroyExistsRecognizer {
  template<typename U, void ( U::* )() = &U::Destroy>
  struct ExistsIfDestroyIsDefinedMarker {};

  struct DestroyIsMissingType {
    char dummy1;
  };

  struct DestroyExistsType {
    char dummy1; char dummy2;
  };

  // exists always
  template<typename U>
  static DestroyIsMissingType is_here( ... );

  // exist only if ExistsIfDestroyIsDefinedMarker is defined
  template<typename U>
  static DestroyExistsType is_here( ExistsIfDestroyIsDefinedMarker<U>* );

  enum { DestroyExists = ( sizeof( is_here<T>( nullptr ) ) == sizeof( DestroyExistsType ) ) };
};

// The folloing templates are used to call the Init and Destroy methods if they exist.

// Generic case of the ParserInitCaller, gets used if the Init method is missing
template<typename T, bool = ParserInitExistsRecognizer<T>::InitExists>
struct ParserInitCaller {
  static void CallInit( T* t ) {
    // nothing to do
  }
};

// True case of the ParserInitCaller, gets used if the Init method exists
template<typename T>
struct ParserInitCaller<T, true> {
  static void CallInit( T* t ) {
    t->Init();
  }
};

// Generic case of the ParserDestroyCaller, gets used if the Destroy method is missing
template<typename T, bool = ParserDestroyExistsRecognizer<T>::DestroyExists>
struct ParserDestroyCaller {
  static void CallDestroy( T* t ) {
    // nothing to do
  }
};

// True case of the ParserDestroyCaller, gets used if the Destroy method exists
template<typename T>
struct ParserDestroyCaller<T, true> {
  static void CallDestroy( T* t ) {
    t->Destroy();
  }
};
void Parser::Parse() {
  t = nullptr;
  la = dummyToken = new Token();
  la->val = coco_string_create( L"Dummy Token" );
  Get();
  	Net();
	Expect(0);
}

Parser::Parser( Scanner* scanner ) {
  	maxT = 17;

  ParserInitCaller<Parser>::CallInit( this );
  dummyToken = nullptr;
  t = la = nullptr;
  minErrDist = 2;
  errDist = minErrDist;
  this->scanner = scanner;
}

bool Parser::StartOf( int s ) {
  const bool T = true;
  const bool x = false;

  	static bool set[2][19] = {
		{T,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x},
		{x,T,T,T, T,x,x,x, x,x,x,x, x,x,x,x, x,x,x}
	};



  return set[s][la->kind];
}

Parser::~Parser() {
  ParserDestroyCaller<Parser>::CallDestroy( this );
  delete dummyToken;
}
void Parser::SemErr( const wchar_t* msg ) {
  if ( errDist >= minErrDist ) errors__.Error( scanner->filename(),t->line, t->col, msg );

  errDist = 0;
}

void Parser::Warning( const wchar_t* msg ) {
  errors__.Warning( scanner->filename(),t->line, t->col, msg );
}

void Parser::SynErr( const std::wstring& filename,int line, int col, int n ) {
  wchar_t* s;

  switch ( n ) {
      			case 0: s = coco_string_create(L"EOF expected"); break;
			case 1: s = coco_string_create(L"ident expected"); break;
			case 2: s = coco_string_create(L"integer expected"); break;
			case 3: s = coco_string_create(L"number expected"); break;
			case 4: s = coco_string_create(L"string expected"); break;
			case 5: s = coco_string_create(L"\"(\" expected"); break;
			case 6: s = coco_string_create(L"\")\" expected"); break;
			case 7: s = coco_string_create(L"\"net\" expected"); break;
			case 8: s = coco_string_create(L"\"{\" expected"); break;
			case 9: s = coco_string_create(L"\"=\" expected"); break;
			case 10: s = coco_string_create(L"\";\" expected"); break;
			case 11: s = coco_string_create(L"\"}\" expected"); break;
			case 12: s = coco_string_create(L"\"node\" expected"); break;
			case 13: s = coco_string_create(L"\"|\" expected"); break;
			case 14: s = coco_string_create(L"\"data\" expected"); break;
			case 15: s = coco_string_create(L"\"experience\" expected"); break;
			case 16: s = coco_string_create(L"\"potential\" expected"); break;
			case 17: s = coco_string_create(L"??? expected"); break;
			case 18: s = coco_string_create(L"invalid ELT_LIST"); break;
			case 19: s = coco_string_create(L"invalid GARBAGE_ELT_LIST"); break;
			case 20: s = coco_string_create(L"invalid GARBAGE_NESTED_LIST"); break;
			case 21: s = coco_string_create(L"invalid FLOAT"); break;
			case 22: s = coco_string_create(L"invalid FLOAT_NESTED_LIST"); break;


    default: {
      wchar_t format[20];
      coco_swprintf( format, 20, L"error %d", n );
      s = coco_string_create( format );
    }
    break;
  }

  //wprintf(L"-- line %d col %d: %ls\n", line, col, s);
  std::wstring ss=L"Syntax error : "+std::wstring( s );
  errors__.Error( filename,line,col,ss.c_str() );
  coco_string_delete( s );
}

} // namespace
} // namespace



