namespace ReflectiveRapidJSON {
namespace JsonReflector {

// define code for (de)serializing LibRepoMgr::MemoryUsage objects
template <> LIBREPOMGR_EXPORT void push<::LibRepoMgr::MemoryUsage>(const ::LibRepoMgr::MemoryUsage &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.virtualMemory, "virtualMemory", value, allocator);
    push(reflectable.residentSetSize, "residentSetSize", value, allocator);
    push(reflectable.sharedResidentSetSize, "sharedResidentSetSize", value, allocator);
    push(reflectable.peakResidentSetSize, "peakResidentSetSize", value, allocator);
}
template <> LIBREPOMGR_EXPORT void pull<::LibRepoMgr::MemoryUsage>(::LibRepoMgr::MemoryUsage &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibRepoMgr::MemoryUsage";
    }
    // pull members
    pull(reflectable.virtualMemory, "virtualMemory", value, errors);
    pull(reflectable.residentSetSize, "residentSetSize", value, errors);
    pull(reflectable.sharedResidentSetSize, "sharedResidentSetSize", value, errors);
    pull(reflectable.peakResidentSetSize, "peakResidentSetSize", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibRepoMgr::ResourceUsage objects
template <> LIBREPOMGR_EXPORT void push<::LibRepoMgr::ResourceUsage>(const ::LibRepoMgr::ResourceUsage &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    push(static_cast<const ::LibRepoMgr::MemoryUsage &>(reflectable), value, allocator);
    // push members
    push(reflectable.packageDbSize, "packageDbSize", value, allocator);
    push(reflectable.actionsDbSize, "actionsDbSize", value, allocator);
    push(reflectable.cachedPackages, "cachedPackages", value, allocator);
    push(reflectable.actionsCount, "actionsCount", value, allocator);
    push(reflectable.runningActionsCount, "runningActionsCount", value, allocator);
}
} // namespace JsonReflector
} // namespace ReflectiveRapidJSON
