namespace ReflectiveRapidJSON {
namespace JsonReflector {

// define code for (de)serializing LibPkg::DatabaseStatistics objects
template <> LIBPKG_EXPORT void push<::LibPkg::DatabaseStatistics>(const ::LibPkg::DatabaseStatistics &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.name, "name", value, allocator);
    push(reflectable.packageCount, "packageCount", value, allocator);
    push(reflectable.arch, "arch", value, allocator);
    push(reflectable.lastUpdate, "lastUpdate", value, allocator);
    push(reflectable.localPkgDir, "localPkgDir", value, allocator);
    push(reflectable.mainMirror, "mainMirror", value, allocator);
    push(reflectable.syncFromMirror, "syncFromMirror", value, allocator);
}
// define code for (de)serializing LibPkg::Status objects
template <> LIBPKG_EXPORT void push<::LibPkg::Status>(const ::LibPkg::Status &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.dbStats, "dbStats", value, allocator);
    push(reflectable.architectures, "architectures", value, allocator);
    push(reflectable.pacmanDatabasePath, "pacmanDatabasePath", value, allocator);
    push(reflectable.packageCacheDirs, "packageCacheDirs", value, allocator);
}
// define code for (de)serializing LibPkg::BuildOrderResult objects
template <> LIBPKG_EXPORT void push<::LibPkg::BuildOrderResult>(const ::LibPkg::BuildOrderResult &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.order, "order", value, allocator);
    push(reflectable.cycle, "cycle", value, allocator);
    push(reflectable.ignored, "ignored", value, allocator);
    push(reflectable.success, "success", value, allocator);
}
template <> LIBPKG_EXPORT void pull<::LibPkg::BuildOrderResult>(::LibPkg::BuildOrderResult &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibPkg::BuildOrderResult";
    }
    // pull members
    pull(reflectable.order, "order", value, errors);
    pull(reflectable.cycle, "cycle", value, errors);
    pull(reflectable.ignored, "ignored", value, errors);
    pull(reflectable.success, "success", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibPkg::LicenseFile objects
template <> LIBPKG_EXPORT void push<::LibPkg::LicenseFile>(const ::LibPkg::LicenseFile &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.filename, "filename", value, allocator);
    push(reflectable.content, "content", value, allocator);
}
template <> LIBPKG_EXPORT void pull<::LibPkg::LicenseFile>(::LibPkg::LicenseFile &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibPkg::LicenseFile";
    }
    // pull members
    pull(reflectable.filename, "filename", value, errors);
    pull(reflectable.content, "content", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibPkg::CommonLicense objects
template <> LIBPKG_EXPORT void push<::LibPkg::CommonLicense>(const ::LibPkg::CommonLicense &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.relevantPackages, "relevantPackages", value, allocator);
    push(reflectable.files, "files", value, allocator);
}
template <> LIBPKG_EXPORT void pull<::LibPkg::CommonLicense>(::LibPkg::CommonLicense &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibPkg::CommonLicense";
    }
    // pull members
    pull(reflectable.relevantPackages, "relevantPackages", value, errors);
    pull(reflectable.files, "files", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

// define code for (de)serializing LibPkg::LicenseResult objects
template <> LIBPKG_EXPORT void push<::LibPkg::LicenseResult>(const ::LibPkg::LicenseResult &reflectable, ::RAPIDJSON_NAMESPACE::Value::Object &value, ::RAPIDJSON_NAMESPACE::Document::AllocatorType &allocator)
{
    // push base classes
    // push members
    push(reflectable.commonLicenses, "commonLicenses", value, allocator);
    push(reflectable.customLicences, "customLicences", value, allocator);
    push(reflectable.consideredPackages, "consideredPackages", value, allocator);
    push(reflectable.ignoredPackages, "ignoredPackages", value, allocator);
    push(reflectable.notes, "notes", value, allocator);
    push(reflectable.mainProject, "mainProject", value, allocator);
    push(reflectable.dependendProjects, "dependendProjects", value, allocator);
    push(reflectable.licenseSummary, "licenseSummary", value, allocator);
    push(reflectable.success, "success", value, allocator);
}
template <> LIBPKG_EXPORT void pull<::LibPkg::LicenseResult>(::LibPkg::LicenseResult &reflectable, const ::RAPIDJSON_NAMESPACE::GenericValue<::RAPIDJSON_NAMESPACE::UTF8<char>>::ConstObject &value, JsonDeserializationErrors *errors)
{
    // pull base classes
    // set error context for current record
    const char *previousRecord = nullptr;
    if (errors) {
        previousRecord = errors->currentRecord;
        errors->currentRecord = "LibPkg::LicenseResult";
    }
    // pull members
    pull(reflectable.commonLicenses, "commonLicenses", value, errors);
    pull(reflectable.customLicences, "customLicences", value, errors);
    pull(reflectable.consideredPackages, "consideredPackages", value, errors);
    pull(reflectable.ignoredPackages, "ignoredPackages", value, errors);
    pull(reflectable.notes, "notes", value, errors);
    pull(reflectable.mainProject, "mainProject", value, errors);
    pull(reflectable.dependendProjects, "dependendProjects", value, errors);
    pull(reflectable.licenseSummary, "licenseSummary", value, errors);
    pull(reflectable.success, "success", value, errors);
    // restore error context for previous record
    if (errors) {
        errors->currentRecord = previousRecord;
    }
}

} // namespace JsonReflector
} // namespace ReflectiveRapidJSON
namespace ReflectiveRapidJSON {
namespace BinaryReflector {

// define code for (de)serializing LibPkg::LicenseFile objects
template <> LIBPKG_EXPORT void writeCustomType<::LibPkg::LicenseFile>(BinarySerializer &serializer, const ::LibPkg::LicenseFile &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::LicenseFile>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.filename, version);
    serializer.write(customObject.content, version);
}
template <> LIBPKG_EXPORT BinaryVersion readCustomType<::LibPkg::LicenseFile>(BinaryDeserializer &deserializer, ::LibPkg::LicenseFile &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::LicenseFile>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibPkg::LicenseFile");
    }
    // read members
    deserializer.read(customObject.filename, version);
    deserializer.read(customObject.content, version);
    return version;
}

// define code for (de)serializing LibPkg::CommonLicense objects
template <> LIBPKG_EXPORT void writeCustomType<::LibPkg::CommonLicense>(BinarySerializer &serializer, const ::LibPkg::CommonLicense &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::CommonLicense>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.relevantPackages, version);
    serializer.write(customObject.files, version);
}
template <> LIBPKG_EXPORT BinaryVersion readCustomType<::LibPkg::CommonLicense>(BinaryDeserializer &deserializer, ::LibPkg::CommonLicense &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::CommonLicense>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibPkg::CommonLicense");
    }
    // read members
    deserializer.read(customObject.relevantPackages, version);
    deserializer.read(customObject.files, version);
    return version;
}

// define code for (de)serializing LibPkg::LicenseResult objects
template <> LIBPKG_EXPORT void writeCustomType<::LibPkg::LicenseResult>(BinarySerializer &serializer, const ::LibPkg::LicenseResult &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::LicenseResult, 1>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.commonLicenses, version);
    serializer.write(customObject.customLicences, version);
    serializer.write(customObject.consideredPackages, version);
    serializer.write(customObject.ignoredPackages, version);
    serializer.write(customObject.notes, version);
    serializer.write(customObject.mainProject, version);
    serializer.write(customObject.dependendProjects, version);
    serializer.write(customObject.licenseSummary, version);
    serializer.write(customObject.success, version);
}
template <> LIBPKG_EXPORT BinaryVersion readCustomType<::LibPkg::LicenseResult>(BinaryDeserializer &deserializer, ::LibPkg::LicenseResult &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::LicenseResult, 1>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibPkg::LicenseResult");
    }
    // read members
    deserializer.read(customObject.commonLicenses, version);
    deserializer.read(customObject.customLicences, version);
    deserializer.read(customObject.consideredPackages, version);
    deserializer.read(customObject.ignoredPackages, version);
    deserializer.read(customObject.notes, version);
    deserializer.read(customObject.mainProject, version);
    deserializer.read(customObject.dependendProjects, version);
    deserializer.read(customObject.licenseSummary, version);
    deserializer.read(customObject.success, version);
    return version;
}

// define code for (de)serializing LibPkg::Config objects
template <> LIBPKG_EXPORT void writeCustomType<::LibPkg::Config>(BinarySerializer &serializer, const ::LibPkg::Config &customObject, BinaryVersion version)
{
    // write base classes
    // write version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::Config>>;
    if constexpr (V::enabled) {
        serializer.writeVariableLengthUIntBE(V::applyDefault(version));
    }
    // write members
    serializer.write(customObject.databases, version);
    serializer.write(customObject.aur, version);
    serializer.write(customObject.architectures, version);
    serializer.write(customObject.pacmanDatabasePath, version);
    serializer.write(customObject.packageCacheDirs, version);
    serializer.write(customObject.signatureLevel, version);
}
template <> LIBPKG_EXPORT BinaryVersion readCustomType<::LibPkg::Config>(BinaryDeserializer &deserializer, ::LibPkg::Config &customObject, BinaryVersion version)
{
    // read base classes
    // read version
    using V = Versioning<::ReflectiveRapidJSON::BinarySerializable< ::LibPkg::Config>>;
    if constexpr (V::enabled) {
        V::assertVersion(version = deserializer.readVariableLengthUIntBE(), "LibPkg::Config");
    }
    // read members
    deserializer.read(customObject.databases, version);
    deserializer.read(customObject.aur, version);
    deserializer.read(customObject.architectures, version);
    deserializer.read(customObject.pacmanDatabasePath, version);
    deserializer.read(customObject.packageCacheDirs, version);
    deserializer.read(customObject.signatureLevel, version);
    return version;
}

} // namespace BinaryReflector
} // namespace ReflectiveRapidJSON
